model Ex1_2

extends Modelica.Math;
import SI = Modelica.SIunits;
// Variables

Real h(unit="m")                              "Height of the water rise in capillary";


// Parameters
 
 parameter Real sigma(unit="N/m")=0.073            "Surface tension" ;
 parameter Real rho(unit="kg/m^3")=1000            "Density of water" ;
 parameter Real D(unit="m")=2e-03                  "Diameter of the pipe" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";
 
// Equations
equation

h =(4*sigma)/(rho*g*D);

end Ex1_2;
