model Ex1_3

extends Modelica.Math;
// Variables

Real C(unit="m/sec")                              "Velocity of sound";
Real V(unit="m/sec")                              "Speed of aircraft";
Real M(unit="")                                   "Mach number";


// Parameters
 

 parameter Real k(unit="")=1.4               "";
 parameter Real R(unit="J/kg")=287           "Gas constant";
 parameter Real T(unit="K")=223.3            "Temperature";//an altitude od 10000m above sealevel.
 parameter Real v(unit="km/hr")=800          "Speed of aircraft flies" ; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
// Equations
equation

C=sqrt(k*T*R);
V=v*1000/3600;
M=V/C;

end Ex1_3;
