model Ex1_4

extends Modelica.Math;
// Variables

Real rho1(unit="Kg/m")                        "Fluid density";
Real Re(unit="")                              "Reynold's number";


// Parameters
 

 parameter Real S(unit="")=0.91                 "Specific gravity" ;
 parameter Real rho(unit="kg/m^3")=1000         "Density of standard fluid" ;
 parameter Real d(unit="m")=25e-03              "Diameter of pipe" ;
 parameter Real v(unit="m/sec")=2.6             "Velocity" ; 
 parameter Real u(unit="N-s/m^2")=0.38          "viscosity" ; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
// Equations
equation

rho1=(S*rho);
Re=(rho1*d*v)/u;

end Ex1_4;
