model Ex1_5

extends Modelica.Math;
// Variables

Real p_abs(unit="kPa")                              "Absolute pressure in the tank";
Real rho(unit="kg/m^3")                             "Density";
Real W(unit="kg")                                   "Weight of air";


// Parameters
 

 parameter Real p1(unit="kPa")=101.3                   "Atmospheric pressure" ;
 parameter Real R(unit="J/kg")=287                     "Gas constant" ;
 parameter Real T(unit="K")=288                        "Temperature" ;
 parameter Real v(unit="m^3")=0.85                     "Volume" ;
 parameter Real g(unit="m/sec^2")=9.8                  "Acceleration due to gravity" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
// Equations
equation

p_abs=(3*p1)+(p1);
rho=p_abs*1000/(R*T);
W=rho*v*g;

//Answer may slightly vary due to rounding off error.
end Ex1_5;
