model Ex2_1

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real p2(unit="m")          "Pressure head at point 2 according to bernoullis equation";//p2=P2/(rho*g)
Real P2(unit="Pascal")     "Pressure at point 2";


// Parameters
 

 parameter Real p1(unit="m")=50                         "Pressure head at point 1" ;
 parameter Real v1(unit="m/sec")=5                      "Velocity" ;
 parameter Real rho_sw(unit="kg/m^3")=1.03e3            "Density of sea water" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";
// Equations
equation


p2=p1+((v1^2)/(2*g));
P2=rho_sw*g*p2;

end Ex2_1;
