model Ex2_10

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real a(unit="m^2")                           "Area of jet";
Real Q(unit="m^3/sec")                       "Discharge";
Real Hp(unit="m")                            "Head developed by pump";
Real P(unit="kW")                            "Power required to drive the pump";


// Parameters
 

 parameter Real V(unit="m/sec")=8.31                  "Velocity at the nozzle" ;
 parameter Real rho(unit="kg/m^3")=1000               "Density of water" ;
 parameter Real Zc(unit="m")=32                       "Datum head" ;
 parameter Real D(unit="m")=75e-03                    "Diameter" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

a=(pi/4)*D^2;
Q=a*V;
Hp=(V^2/(2*g))+Zc;
P=rho*g*Q*Hp/1000;

end Ex2_10;
