model Ex2_11

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real rho_(unit="kg/m^3")        "Density of Kerosene";
Real a(unit="")                 "Area ratio";
Real delta_P(unit="kPa")        "Difference of pressure between inlet and throat of the venturimeter";

// Parameters
 

 parameter Real w(unit="")=0.85                       "Specific gravity of Kerosene" ;
 parameter Real rho(unit="kg/m^3")=1000               "Density of water" ;
 parameter Real D2(unit="m")=0.06                     "Diameter of throat" ;
 parameter Real D1(unit="m")=0.1                      "Diameter of pipe" ;
 parameter Real Q(unit="m^3/sec")=0.05                "Flow rate" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

rho_=w*rho;
a=D2/D1;
delta_P=(Q^2*rho_*(1-(a^4)))*1e-03/(2*((pi/4)*(D2^2))^2);

//Answer may slightly vary due to rounding off error.

end Ex2_11;
