model Ex2_13

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real V1(unit="m/sec")             "Velocity";
Real Fx(unit="N")                 "Force produced in the x-direction";
Real Fy(unit="N")                 "Force produced in the y-direction";

// Parameters
 
 parameter Real m(unit="kg/sec")=32                  "Mass flow rate" ;
 parameter Real rho(unit="kg/m^3")=1000              "Density of water" ;
 parameter Real l(unit="m")=2e-02                    "Length of sheet" ;
 parameter Real b(unit="m")=4e-02                    "Width of sheet" ;
 parameter Real V2(unit="m/sec")=40                  "Velocity" ;
 parameter Real alpha(unit="degree celsius")=30      "Angle of deflector" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

V1=m/(rho*l*b);
Fx=m*(V1-(V2*cos(alpha*pi/180)));
Fy=m*(V1-(V2*sin(alpha*pi/180)));

//Answer may slightly vary due to rounding off error.

end Ex2_13;
