model Ex2_4

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real V(unit="m/sec")                          "Velocity of still air";
Real P0(unit="Pascal")                        "Maximum pressure";


// Parameters
 

 parameter Real P(unit="Pascal")=101.3e03                 "Atmospheric pressure" ;
 parameter Real rho(unit="kg/m^3")=1.225                  "Density" ;
 parameter Real v(unit="km/hr")=90                        "Velocity of still air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

V=v*1000/3600;
P0=P+((rho*V^2)/2);

end Ex2_4;
