model Ex2_9

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real P_g(unit="Pascal")                           "Pressure";
Real P(unit="Pascal")                             "Pressure";
Real rho_air(unit="kg/m^3")                       "Density of air";
Real V(unit="m/sec")                              "Velocity";
Real C(unit="m/sec")                              "Velocity of sound";
Real M(unit="")                                   "Mach number";

// Parameters
 

 parameter Real h0(unit="m")=16e-03                    "Piezometer pressure head" ;
 parameter Real h1(unit="m")=32e-03                    "Pitot tube pressure head" ;
 parameter Real rho(unit="kg/m^3")=1000                "Density of water" ;
 parameter Real P_atm(unit="Pascal")=101000            "Atmospheric pressure" ;
 parameter Real R(unit="J/kg-K")=287                   "Gas constant" ;
 parameter Real T(unit="K")=293                        "Temperature" ;
 parameter Real K(unit="")=1.4                         "Constant" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

P_g=rho*g*h1;
P =P_g+P_atm;
rho_air=P/(R*T);
V=sqrt((2*(h1-h0)*rho*g)/rho_air);
C=sqrt(K*R*T);
M=V/C;


end Ex2_9;
