model Ex5_2

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real V1(unit="m/sec")             "Velocity of the jet";
Real E(unit="m")                  "Euler's head";
Real Q(unit="m^3/sec")            "Flow rate";
Real Pe(unit="KW")                "Power developed by the runner";
Real P(unit="KW")                 "Shaft power developed by the turbine";

// Parameters
 
 parameter Real H(unit="m")=400                    "Head developed" ;
 parameter Real Hf(unit="m")=23.6                  "Head loss" ;
 parameter Real u(unit="m/sec")=40                 "Bucket speed" ;
 parameter Real k(unit="")=0.85                    "Length of sheet" ;
 parameter Real d(unit="m")=80e-03                 "Diameter of jet" ;
 parameter Real rho(unit="kg/m^3")=1000            "Density of water" ;
 parameter Real alpha(unit="degree celsius")=165   "Angle of deflector" ;
 parameter Real nm(unit="")=0.9                    "Mechanical efficiency" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation


V1=sqrt(2*g*(H-Hf));
E=(u/g)*(V1-u)*(1-(k*cos(alpha*pi/180)));                         //euler's head
Q=(pi/4)*d^2*V1;
Pe=rho*g*Q*E/1000;
P=Pe*nm;

//Answer may slightly vary due to rounding off error.
end Ex5_2;
