model Ex5_4

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real H(unit="m")                   "Effective head";
Real V1(unit="m/sec")              "Velocity of the jet";
Real Q(unit="m^3/sec")             "flow rate";
Real HP(unit="kW")                 "Hydraulic power";
Real u(unit="m/sec")               "Velocity";
Real S(unit="")                    "Speed ratio";
Real nh(unit="")                   "Hydraulic efficiency";

// Parameters
 
 parameter Real D(unit="m")=2                           "Diameter of the wheel" ;
 parameter Real N(unit="rev/min")=320                   "Shaft rotation" ;
 parameter Real d(unit="m")=165e-03                     "Diameter of the jet" ;
 parameter Real thetha(unit="degree celsius")=162       "Deflection of the jet" ;
 parameter Real rho(unit="kg/m^3")=1000                 "Density of water" ;
 parameter Real P(unit="N/m^2")=1000e03                 "Power trasmitted" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation


H=P/(rho*g);
V1=sqrt(2*g*H);
Q=(pi/4)*d^2*V1;
HP=rho*g*Q*H/1000;
u=pi*D*N/60;
S=u/V1;
nh =2*S*(1-S)*(1-(cos(thetha*pi/180)));

//Answer may slightly vary due to rounding off error. 
end Ex5_4;
