model Ex6_3

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real Q(unit="m^3/sec")                         "Peripheral velocity at inlet";
Real Vf(unit="m/sec")                          "Peripheral velocity at outlet";
Real V1f(unit="m/sec")                         "Velocity of flow at inlet";
Real V2f(unit="m/sec")                         "Velocity of flow at outlet";
Real D1(unit="m")                              "Inlet diameter";
Real B1(unit="m")                              "Inlet breadth";
Real u1(unit="m/sec")                          "Peripheral velocity at inlet";
Real V1w(unit="m/sec")                         "Whirl velocity at inlet";
Real alpha1(unit="degree celsius")             "Guide vane angle";
Real D2(unit="m")                              "Exit diameter";
Real u2(unit="m/sec")                          "Peripheral velocity at outlet";
Real beta2(unit="degree celsius")              "Runner blade exit angle";
Real n2(unit="")                               "Ratio";
Real B2(unit="m")                              "Exit breadth";

// Parameters
 
 parameter Real H(unit="m")=68                    "Head" ;
 parameter Real x(unit="")=0.15                   "Flow ratio" ;
 parameter Real N(unit="rpm")=750                 "Speed" ;
 parameter Real n1(unit="")=0.1                   "Breadth to diameter ratio at inlet" ;
 parameter Real P(unit="W")=330e03                "Power output" ;
 parameter Real n0(unit="")=0.85                  "Overall efficiency" ;
 parameter Real rho(unit="kg/m^3")=1000           "Density of water" ;
 parameter Real k(unit="")=0.94                   "Costant" ;
 parameter Real nH(unit="")=0.94                  "Hydraulic efficiency" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation


Q=P/(n0*rho*g*H);
Vf=x*sqrt(2*g*H);
V1f=Vf;
V2f=Vf;
D1=sqrt(Q/(k*pi*n1*V1f));
B1=D1*0.1;
u1=(pi*D1*N)/60;
V1w=nH*g*H/u1;
tan(alpha1*pi/180)=(V1f/V1w);
D2=D1/2;
u2=pi*D2*N/60;
tan(beta2*pi/180)=V2f/u2;
n2=(D1^2*n1/D2^2);
B2=n2*D2;

//Answer may slightly vary due to rounding off error.
end Ex6_3;
