model Ex6_4

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real V1f(unit="m/sec")                         "Velocity of flow at inlet";
Real V2f(unit="m/sec")                         "Velocity of flow at outlet";
Real u1(unit="m/sec")                          "Peripheral velocity at inlet";
Real V1w(unit="m/sec")                         "Whirl velocity at inlet";
Real alpha1(unit="degree celsius")             "Guide vane angle";
Real u2(unit="m/sec")                          "Peripheral velocity at outlet";
Real beta2(unit="degree celsius")              "Runner blade exit angle";

// Parameters
 
 parameter Real H(unit="m")=12                    "Head" ;
 parameter Real R1(unit="m")=24                   "Inlet radius" ;
 parameter Real R2(unit="m")=12                   "Outlet radius" ;
 parameter Real nH(unit="")=0.8                   "Hydraulic efficiency" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

V1f=0.15*sqrt(2*g*H);
V2f=V1f;
V1w=sqrt(nH*g*H);
u1=V1w;
u2=u1*(R2/R1);
tan(beta2*pi/180)=V2f/u2;
tan(alpha1*pi/180)=V1f/u1;

end Ex6_4;
