model Ex7_3

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real Q(unit="m^3/sec")                        "Flow rate";
Real Vf(unit="m/sec")                         "Flow velocity";
Real u(unit="m/sec")                          "velocity of the turbine";
Real Vw(unit="m/sec")                         "Whirl velocity at inlet";
Real D(unit="m")                              "Mean diameter";
Real rm(unit="m")                             "Mean radius";
Real Vwm(unit="m/sec")                        "Whirl velocity at mean radius";
Real rt(unit="m")                             "Tip radius";
Real Vwt(unit="m/sec")                        "Whirl velocity at tip radius";
Real rh(unit="m")                             "Hub radius";
Real Vwh(unit="m/sec")                        "Whirl velocity at hub radius";
Real uh(unit="m/sec")                         "Speed";
Real um(unit="m/sec")                         "Speed";
Real ut(unit="m/sec")                         "Speed";
Real beta1h(unit="degree celsius")            "Runner blade inlet angle at hub radius";
Real beta2h(unit="degree celsius")            "Runner blade outlet angle at hub radius";
Real beta1m(unit="degree celsius")            "Runner blade inlet angle at mean radius";
Real beta2m(unit="degree celsius")            "Runner blade outlet angle at mean radius";
Real beta1t(unit="degree celsius")            "Runner blade inlet angle at tip radius";
Real beta2t(unit="degree celsius")            "Runner blade outlet angle at tip radius";

// Parameters
 
 parameter Real Dt(unit="m")=4.5                 "Tip diameter" ;
 parameter Real Dh(unit="m")=2                   "Hub diameter" ;
 parameter Real rho(unit="kg/m^3")=1000          "Density of water" ;
 parameter Real N(unit="rpm")=150                "Rotational speed of the turbine" ;
 parameter Real P(unit="W")=20e06                "Power developed by turbine" ;
 parameter Real H(unit="m")=21                   "Head" ;
 parameter Real nh(unit="")=0.94                 "Hydraulic efficiency" ;
 parameter Real n0(unit="")=0.88                 "Overall efficiency" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

Q=P/(n0*H*rho*g); 
Vf=(4*Q)/(pi*(Dt^2-Dh^2)); 
u=2*pi*N/60;
Vw=(g*H*nh)/u;
D=(Dt+Dh)/2; 
rm=D/2;
Vwm=Vw/rm;
rt=rm +0.625;
Vwt =Vw/rt;
rh=rm -0.625;
Vwh=Vw/rh;
uh=(pi*2*rh*N)/60;
um=(pi*2*rm*N)/60;
ut=(pi*2*rt*N)/60;
tan((180-beta1h)*pi/180)=Vf/(uh-Vwh);
tan(beta2h*pi/180)=Vf/uh;
tan((180-beta1m)*pi/180)=Vf/(um-Vwm);
tan(beta2m*pi/180)=Vf/um;
tan((180-beta1t)*pi/180)=Vf/(ut-Vwt);
tan(beta2t*pi/180)=Vf/ut;


end Ex7_3;
