model Ex7_4

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real Q(unit="m^3/sec")                        "Flow rate";
Real Vf(unit="m/sec")                         "Flow velocity";
Real Dt(unit="m")                             "Tip diameter";
Real Dh(unit="m")                             "Hub diameter";
Real D(unit="m")                              "Mean Diameter";
Real N(unit="rpm")                            "Mean speed of turbine";

// Parameters
 
 parameter Real x(unit="")=0.5                   "Flow ratio" ;
 parameter Real ku(unit="")=1.6                  "Speed ratio" ;
 parameter Real rho(unit="kg/m^3")=1000          "Density of water" ;
 parameter Real P(unit="W")=60e06                "Power developed by turbine" ;
 parameter Real H(unit="m")=40                   "Head" ;
 parameter Real n0(unit="")=0.85                 "Overall efficiency" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

Q=P/(n0*H*rho*g);
Vf=x*sqrt(2*g*H);
Q=pi*(Dt^2-(0.35*Dt)^2)*Vf/4;
Dh=Dt*0.35;
D=(Dt+Dh)/2;
N=ku*sqrt(2*g*H)*60/(pi*D);


//Answer may slightly vary due to rounding off error.
end Ex7_4;
