model Ex8_4

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real u1(unit="m/sec")                    "Peripheral velocity at inlet";
Real u2(unit="m/sec")                    "Peripheral velocity at outlet";
Real V1f(unit="m/sec")                   "Velocity of flow at inlet";
Real Q(unit="m^3/sec")                   "Flow rate";
Real V2f(unit="m/sec")                   "Velocity of flow at outlet";
Real V2w(unit="m/sec")                   "Velocity of whirl at outlet";
Real alpha2(unit="degree celsius")       "blade angle at exit";
Real V2(unit="m/sec")                    "Absolute velocity at exit";
Real H1(unit="m")                        "Total head";
Real P(unit="W")                         "Theoretical power";
Real V1(unit="m/sec")                    "Absolute velocity at inlet";
Real delta_P(unit="Pascal")              "Pressure rise in the impeller";

// Parameters 

 parameter Real R1(unit="m")=21e-03                  "Inlet radius" ;
 parameter Real R2(unit="m")=66e-03                  "Exit radius" ;
 parameter Real rho(unit="kg/m^3")=1000              "Density of water" ;
 parameter Real beta1(unit="degree celsius")=44      "Inlet blade angle" ;
 parameter Real beta2(unit="degree celsius")=30      "Exit blade angle" ;
 parameter Real b1(unit="m")=11e-03                  "Width" ;
 parameter Real b2(unit="m")=5e-03                   "Width" ;
 parameter Real N(unit="rev/min")=2500               "Speed of the pump" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

u1=(2*pi*N*R1)/60;
u2=(2*pi*N*R2)/60;
V1f=tan(beta1*pi/180)*u1;
Q=pi*2*R1*b1*V1f;
V2f=Q/(2*pi*R2*b2);
tan(beta2*pi/180)=V2f/(u2-V2w);
tan(alpha2*pi/180)=(V2f/V2w);
V2=V2w/cos(alpha2*pi/180);
H1=(u2*V2w)/g;
P=rho*g*Q*H1;
V1=V1f;
delta_P=(rho*g*H1)-((rho/2)*(V2^2-V1^2));

end Ex8_4;
