model Ex8_5

extends Modelica.Math;
import SI = Modelica.SIunits;
// Variables

Real m;
Real Q(unit="m^3/sec")                              "Flow rate";
Real H1(unit="m")                                   "Head";


// Parameters
 
 parameter Real f(unit="")=0.025          "Firction loss" ;
 parameter Real D(unit="m")=0.3           "Daimeter" ;
 parameter Real l(unit="m")=70            "Length" ;
 parameter Real k(unit="")=2.5 ;
 parameter Real a(unit="")=112.8;
 parameter Real b(unit="")=5.35;
 parameter Real c(unit="")=7.9;
 parameter Real Z(unit="")=15;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";
 
// Equations
equation

m=((f*l/D)+k)/(2*g*(((pi*D*D)/4)^2));
Q=(1/(2*a))*(b+sqrt((b^2)+(4*a*c)));
H1 =Z+(m*Q^2);

////Answer may slightly vary due to rounding off error.
end Ex8_5;
