model Ex9_1

extends Modelica.Math;
import SI = Modelica.SIunits;

// Variables

Real H(unit="m")                    "Total head across the pump";
Real HP(unit="kW")                  "Hydraulic power";
Real SP(unit="kW")                  "Shaft power";
Real EP(unit="kW")                  "Electrical power";


// Parameters
 
 parameter Real Ps(unit="Pascal")=200e03            "Suction head" ;
 parameter Real Pd(unit="Pascal")=600e03            "Delivery head" ;
 parameter Real Z(unit="m")=0.1                     "Datum" ;
 parameter Real Q(unit="m^3/sec")=0.2               "Flow rate" ;
 parameter Real rho(unit="kg/m^3")=1000             "Density of water" ;
 parameter Real n0(unit="")=0.85                    "Overall efficiency" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 final constant SI.Acceleration g=9.80665 "Standard acceleration of gravity on earth";

// Equations
equation

H=((Ps/(rho*g))+Z)+((Pd/(rho*g))+Z);
HP=rho*g*Q*H/1000;
SP=HP/n0;
EP=SP;

//Answer may slightly vary due to rounding off error.
end Ex9_1;
