package Benin_onisitsha_alaoji_330kv_V2


  model Network
    OpenIPSL.Electrical.Buses.Bus Benin(P_0 = 149.20, Q_0 = 6.35, V_0 = 0.96, V_b = 330, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-66, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine line1(B = 0.001 / 2, G = 0, R = 0.018, X = 0.014, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-74, -16}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
    OpenIPSL.Electrical.Branches.PwLine line2(B = 0.001 / 2, G = 0, R = 0.049, X = 0.042, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Events.PwFault fault(R = 0.5, X = 0.5, t1 = 5, t2 = 7) annotation(
      Placement(visible = true, transformation(origin = {-40, -22}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus Onitsha(P_0 = 149.10, Q_0 = 3.47, V_0 = 0.96, V_b = 330, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {2, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine line3(B = 0.001 / 2, G = 0, R = 0.021, X = 0.014, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ load2(P_0 = 236, Q_0 = 146, V_0 = 0.96, V_b = 330) annotation(
      Placement(visible = true, transformation(origin = {21, -21}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus Alaoji(P_0 = 13.45, Q_0 = 3.45, V_0 = 0.96, V_b = 330, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {60, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ Load3(P_0 = 248, Q_0 = 153, V_0 = 0.96, V_b = 330) annotation(
      Placement(visible = true, transformation(origin = {84, -8.88178e-16}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ Load1(P_0 = 136, Q_0 = 84, V_0 = 0.96, V_b = 330) annotation(
      Placement(visible = true, transformation(origin = {-87, 1}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine line4(B = 0.001 / 2, G = 0, R = 0.018, X = 0.014, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {74, -16}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 1902) annotation(
      Placement(visible = true, transformation(origin = {80, 42}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0.001 / 2, G = 0, R = 0.049, X = 0.042, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, 28}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Breaker_type_open breaker_type_open1(t_c = 3, t_o = 4)  annotation(
      Placement(visible = true, transformation(origin = {-46, 28}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  Benin_onisitsha_alaoji_330kv_V2.Plant1 plant11 annotation(
      Placement(visible = true, transformation(origin = {-72, -48}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Benin_onisitsha_alaoji_330kv_V2.Plant2 plant21 annotation(
      Placement(visible = true, transformation(origin = {74, -44}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  equation
    connect(plant21.pwPin1, line4.n) annotation(
      Line(points = {{74, -34}, {74, -34}, {74, -24}, {74, -24}}, color = {0, 0, 255}));
    connect(line1.p, plant11.pwPin1) annotation(
      Line(points = {{-74, -24}, {-74, -31}, {-72, -31}, {-72, -38}}, color = {0, 0, 255}));
    connect(line2.p, Benin.p) annotation(
      Line(points = {{-38, 0}, {-66, 0}, {-66, 0}, {-66, 0}}, color = {0, 0, 255}));
    connect(breaker_type_open1.r, pwLine1.p) annotation(
      Line(points = {{-40, 28}, {-33, 28}}, color = {0, 0, 255}));
    connect(pwLine1.n, Onitsha.p) annotation(
      Line(points = {{-15, 28}, {-8, 28}, {-8, 0}, {2, 0}}, color = {0, 0, 255}));
    connect(Benin.p, breaker_type_open1.s) annotation(
      Line(points = {{-66, 0}, {-60, 0}, {-60, 28}, {-52, 28}, {-52, 28}}, color = {0, 0, 255}));
    connect(line3.n, Alaoji.p) annotation(
      Line(points = {{40, 0}, {60, 0}, {60, 0}, {60, 0}}, color = {0, 0, 255}));
    connect(Onitsha.p, line3.p) annotation(
      Line(points = {{2, 0}, {20, 0}, {20, 0}, {22, 0}}, color = {0, 0, 255}));
    connect(line2.n, Onitsha.p) annotation(
      Line(points = {{-20, 0}, {2, 0}, {2, 0}, {2, 0}}, color = {0, 0, 255}));
    connect(Alaoji.p, Load3.p) annotation(
      Line(points = {{60, 0}, {78, 0}, {78, 0}, {78, 0}}, color = {0, 0, 255}));
    connect(Alaoji.p, line4.p) annotation(
      Line(points = {{60, 0}, {74, 0}, {74, -7}}, color = {0, 0, 255}));
    connect(load2.p, line3.p) annotation(
      Line(points = {{21, -16}, {20, -16}, {20, 0}}, color = {0, 0, 255}));
    connect(fault.p, line2.p) annotation(
      Line(points = {{-40, -15}, {-40, 0}}, color = {0, 0, 255}));
    connect(line1.n, Benin.p) annotation(
      Line(points = {{-74, -7}, {-74, 0}, {-66, 0}}, color = {0, 0, 255}));
    connect(Load1.p, Benin.p) annotation(
      Line(points = {{-82, 1}, {-66, 1}, {-66, -1}, {-66, -1}}, color = {0, 0, 255}));
  end Network;

  model Plant1
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1902, V_b = 330, Vn = 20, kT = 0.06060606, r = 0.1, x = 0.001) annotation(
      Placement(visible = true, transformation(origin = {47, -1}, extent = {{-17, -17}, {17, 17}}, rotation = 0)));
    OpenIPSL.Interfaces.PwPin pwPin1 annotation(
      Placement(visible = true, transformation(origin = {97, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0), iconTransformation(origin = {97, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 1902) annotation(
      Placement(visible = true, transformation(origin = {84, 62}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order3 order31(D = 0, M = 10, P_0 = 386, Sn = 1902, T1d0 = 8, V_0 = 0.96, V_b = 330, Vn = 20, ra = 0.001, x1d = 0.302, xd = 1.9, xq = 1.7)  annotation(
      Placement(visible = true, transformation(origin = {-21, -1}, extent = {{-23, -23}, {23, 23}}, rotation = 0)));
  equation
    connect(order31.p, twoWindingTransformer1.p) annotation(
      Line(points = {{2, 0}, {30, 0}, {30, 0}, {28, 0}}, color = {0, 0, 255}));
    connect(order31.p, twoWindingTransformer1.p) annotation(
      Line(points = {{2, 0}, {26, 0}, {26, 0}, {28, 0}}, color = {0, 0, 255}));
    connect(order31.pm, order31.pm0) annotation(
      Line(points = {{-48, -12}, {-70, -12}, {-70, -36}, {-40, -36}, {-40, -26}, {-40, -26}}, color = {0, 0, 127}));
    connect(order31.vf, order31.vf0) annotation(
      Line(points = {{-48, 10}, {-64, 10}, {-64, 40}, {-40, 40}, {-40, 24}, {-40, 24}}, color = {0, 0, 127}));
    connect(twoWindingTransformer1.n, pwPin1) annotation(
      Line(points = {{66, -1}, {94, -1}, {94, 0}, {98, 0}}, color = {0, 0, 255}));
  end Plant1;

  model Plant2
    OpenIPSL.Interfaces.PwPin pwPin1 annotation(
      Placement(visible = true, transformation(origin = {92, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {92, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1430, V_b = 330, Vn = 20, kT = 0.06060606) annotation(
      Placement(visible = true, transformation(origin = {17, -1}, extent = {{-19, -19}, {19, 19}}, rotation = 0)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 1902) annotation(
      Placement(visible = true, transformation(origin = {52, 64}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order3 order31(D = 0, M = 10, P_0 = 455, Sn = 1430, T1d0 = 8, V_0 = 0.96, V_b = 330, Vn = 20, ra = 0.001, x1d = 0.302, xd = 1.9, xq = 1.7)  annotation(
      Placement(visible = true, transformation(origin = {-42, -2}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  equation
    connect(order31.p, twoWindingTransformer1.p) annotation(
      Line(points = {{-22, -2}, {-2, -2}, {-2, 0}, {-4, 0}}, color = {0, 0, 255}));
    connect(order31.vf, order31.vf0) annotation(
      Line(points = {{-66, 8}, {-76, 8}, {-76, 30}, {-58, 30}, {-58, 20}, {-58, 20}}, color = {0, 0, 127}));
    connect(order31.pm0, order31.pm) annotation(
      Line(points = {{-58, -24}, {-58, -24}, {-58, -38}, {-78, -38}, {-78, -12}, {-66, -12}, {-66, -12}}, color = {0, 0, 127}));
    connect(twoWindingTransformer1.n, pwPin1) annotation(
      Line(points = {{38, -2}, {86, -2}, {86, 0}, {92, 0}}, color = {0, 0, 255}));
  end Plant2;

  model Plant3
    extends OpenIPSL.Electrical.Essentials.pfComponent;
    parameter Real vf0 = 1.755517086537914;
    parameter Real vref0 = 1.118023800520641;
    parameter Real height_1 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Real tstart_1 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Boolean refdisturb_1 annotation(
      Dialog(group = "AVR Disturbance"));
    OpenIPSL.Electrical.Machines.PSAT.Order4 gen(Sn = 100, Vn = 18, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0, ra = 0, xd = 0.8958, xq = 0.8645, x1d = 0.1198, x1q = 0.1969, T1d0 = 6, T1q0 = 0.5350, M = 12.8, D = 0) annotation(
      Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {28, 14})));
    OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeII AVR(vrmin = -5, vrmax = 5, v0 = V_0, Ka = 20, Ta = 0.2, Kf = 0.063, Tf = 0.35, Ke = 1, Te = 0.314, Tr = 0.001, Ae = 0.0039, Be = 1.555) annotation(
      Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-6, 10})));
    Modelica.Blocks.Sources.Step step(startTime = tstart_1, offset = vref0, height = height_1) annotation(
      Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 90, origin = {-56, -2})));
    Modelica.Blocks.Logical.Switch switch1 annotation(
      Placement(transformation(extent = {{-50, 12}, {-40, 22}})));
    Modelica.Blocks.Sources.BooleanConstant booleanConstant(k = true) annotation(
      Placement(transformation(extent = {{-80, 2}, {-70, 12}})));
    OpenIPSL.Interfaces.PwPin pwPin annotation(
      Placement(transformation(extent = {{100, -10}, {120, 10}})));
    //Real P_MW;
    //Real Q_MVA;
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1902, V_b = 330, Vn = 20, kT = 0.06060606) annotation(
      Placement(visible = true, transformation(origin = {74, 0}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
  equation
    connect(twoWindingTransformer1.n, pwPin) annotation(
      Line(points = {{92, 0}, {110, 0}}, color = {0, 0, 255}));
    connect(gen.p, twoWindingTransformer1.p) annotation(
      Line(points = {{38, 14}, {56, 14}, {56, 0}}, color = {0, 0, 255}));
//P_MW = gen.P*S_b;
// Q_MVA = gen.Q*S_b;
    connect(gen.v, AVR.v) annotation(
      Line(points = {{39, 17}, {48, 17}, {48, -14}, {-22, -14}, {-22, 4}, {-18, 4}}, color = {0, 0, 127}, smooth = Smooth.None));
    connect(switch1.y, AVR.vref) annotation(
      Line(points = {{-39.5, 17}, {-26.75, 17}, {-26.75, 16}, {-18, 16}}, color = {0, 0, 127}));
    connect(booleanConstant.y, switch1.u2) annotation(
      Line(points = {{-69.5, 7}, {-66, 7}, {-66, 17}, {-51, 17}}, color = {255, 0, 255}));
    connect(step.y, switch1.u1) annotation(
      Line(points = {{-56, 2.4}, {-56, 21}, {-51, 21}}, color = {0, 0, 127}));
    connect(AVR.vf, gen.vf) annotation(
      Line(points = {{6, 10}, {8, 10}, {8, 19}, {16, 19}}, color = {0, 0, 127}));
    connect(gen.pm0, gen.pm) annotation(
      Line(points = {{20, 3}, {20, 0}, {14, 0}, {14, 9}, {16, 9}}, color = {0, 0, 127}));
    connect(gen.vf0, AVR.vf0) annotation(
      Line(points = {{20, 25}, {10, 25}, {10, 36}, {-26, 36}, {-26, -8}, {-6, -8}, {-6, -2}}, color = {0, 0, 127}));
    connect(AVR.vref0, switch1.u3) annotation(
      Line(points = {{-6, 22}, {-30, 22}, {-30, 50}, {-68, 50}, {-68, 42}, {-68, 13}, {-51, 13}}, color = {0, 0, 127}));
    annotation(
      Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-100, -100}, {100, 100}}, lineColor = {28, 108, 200}), Line(points = {{-60, -20}, {-20, 20}, {20, -20}, {60, 20}}, color = {28, 108, 200}), Text(extent = {{-34, -32}, {38, -52}}, lineColor = {28, 108, 200}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{62, 106}, {134, 68}}, lineColor = {238, 46, 47}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = DynamicSelect("0.0", String(P_MW, significantDigits = 3))), Text(extent = {{62, -70}, {134, -108}}, lineColor = {0, 255, 0}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = DynamicSelect("0.0", String(Q_MVA, significantDigits = 3)))}),
      Documentation);
  end Plant3;

  model plant4
    extends OpenIPSL.Electrical.Essentials.pfComponent;
    parameter Real vf0 = 1.755517086537914;
    parameter Real vref0 = 1.118023800520641;
    parameter Real height_1 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Real tstart_1 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Boolean refdisturb_1 annotation(
      Dialog(group = "AVR Disturbance"));
    OpenIPSL.Electrical.Machines.PSAT.Order4 gen(Sn = 100, Vn = 18, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0, ra = 0, xd = 0.8958, xq = 0.8645, x1d = 0.1198, x1q = 0.1969, T1d0 = 6, T1q0 = 0.5350, M = 12.8, D = 0) annotation(
      Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {28, 14})));
    OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeII AVR(vrmin = -5, vrmax = 5, v0 = V_0, Ka = 20, Ta = 0.2, Kf = 0.063, Tf = 0.35, Ke = 1, Te = 0.314, Tr = 0.001, Ae = 0.0039, Be = 1.555) annotation(
      Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-6, 10})));
    Modelica.Blocks.Sources.Step step(startTime = tstart_1, offset = vref0, height = height_1) annotation(
      Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 90, origin = {-56, -2})));
    Modelica.Blocks.Logical.Switch switch1 annotation(
      Placement(transformation(extent = {{-50, 12}, {-40, 22}})));
    Modelica.Blocks.Sources.BooleanConstant booleanConstant(k = true) annotation(
      Placement(transformation(extent = {{-80, 2}, {-70, 12}})));
    OpenIPSL.Interfaces.PwPin pwPin annotation(
      Placement(transformation(extent = {{100, -10}, {120, 10}})));
    //Real P_MW;
    //Real Q_MVA;
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1430, V_b = 330, Vn = 20, kT = 0.06060606) annotation(
      Placement(visible = true, transformation(origin = {74, 0}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
  equation
    connect(twoWindingTransformer1.n, pwPin) annotation(
      Line(points = {{92, 0}, {110, 0}}, color = {0, 0, 255}));
    connect(gen.p, twoWindingTransformer1.p) annotation(
      Line(points = {{38, 14}, {56, 14}, {56, 0}}, color = {0, 0, 255}));
//P_MW = gen.P*S_b;
// Q_MVA = gen.Q*S_b;
    connect(gen.v, AVR.v) annotation(
      Line(points = {{39, 17}, {48, 17}, {48, -14}, {-22, -14}, {-22, 4}, {-18, 4}}, color = {0, 0, 127}, smooth = Smooth.None));
    connect(switch1.y, AVR.vref) annotation(
      Line(points = {{-39.5, 17}, {-26.75, 17}, {-26.75, 16}, {-18, 16}}, color = {0, 0, 127}));
    connect(booleanConstant.y, switch1.u2) annotation(
      Line(points = {{-69.5, 7}, {-66, 7}, {-66, 17}, {-51, 17}}, color = {255, 0, 255}));
    connect(step.y, switch1.u1) annotation(
      Line(points = {{-56, 2.4}, {-56, 21}, {-51, 21}}, color = {0, 0, 127}));
    connect(AVR.vf, gen.vf) annotation(
      Line(points = {{6, 10}, {8, 10}, {8, 19}, {16, 19}}, color = {0, 0, 127}));
    connect(gen.pm0, gen.pm) annotation(
      Line(points = {{20, 3}, {20, 0}, {14, 0}, {14, 9}, {16, 9}}, color = {0, 0, 127}));
    connect(gen.vf0, AVR.vf0) annotation(
      Line(points = {{20, 25}, {10, 25}, {10, 36}, {-26, 36}, {-26, -8}, {-6, -8}, {-6, -2}}, color = {0, 0, 127}));
    connect(AVR.vref0, switch1.u3) annotation(
      Line(points = {{-6, 22}, {-30, 22}, {-30, 50}, {-68, 50}, {-68, 42}, {-68, 13}, {-51, 13}}, color = {0, 0, 127}));
    annotation(
      Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-100, -100}, {100, 100}}, lineColor = {28, 108, 200}), Line(points = {{-60, -20}, {-20, 20}, {20, -20}, {60, 20}}, color = {28, 108, 200}), Text(extent = {{-34, -32}, {38, -52}}, lineColor = {28, 108, 200}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{62, 106}, {134, 68}}, lineColor = {238, 46, 47}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = DynamicSelect("0.0", String(P_MW, significantDigits = 3))), Text(extent = {{62, -70}, {134, -108}}, lineColor = {0, 255, 0}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = DynamicSelect("0.0", String(Q_MVA, significantDigits = 3)))}),
      Documentation);
  end plant4;

  model Plant5
    OpenIPSL.Electrical.Controls.PSAT.TG.TGtypeII tGtypeII1(R = 0.2, S_b = 1902, Sn = 20, pmax0 = 1, wref = 1) annotation(
      Placement(visible = true, transformation(origin = {-17, -63}, extent = {{21, -21}, {-21, 21}}, rotation = 0)));
    OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 10, P_0 = 386, Q_0 = 0, Sn = 1902, V_0 = 0.96, V_b = 330, Vn = 20, ra = 0.001, x1d = 0.302) annotation(
      Placement(visible = true, transformation(origin = {-5, -1}, extent = {{-23, -23}, {23, 23}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1902, V_b = 330, Vn = 20, kT = 0.06060606)  annotation(
      Placement(visible = true, transformation(origin = {63, -1}, extent = {{-15, -15}, {15, 15}}, rotation = 0)));
  OpenIPSL.Interfaces.PwPin pwPin1 annotation(
      Placement(visible = true, transformation(origin = {108, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {108, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(twoWindingTransformer1.n, pwPin1) annotation(
      Line(points = {{80, -1}, {106, -1}, {106, 0}, {108, 0}}, color = {0, 0, 255}));
    connect(order21.p, twoWindingTransformer1.p) annotation(
      Line(points = {{18, 0}, {46, 0}, {46, -1}}, color = {0, 0, 255}));
    connect(order21.pm, tGtypeII1.pm) annotation(
      Line(points = {{-32.6, -12.5}, {-55.6, -12.5}, {-55.6, -64}, {-39.6, -64}, {-39.6, -63}}, color = {0, 0, 127}));
    connect(tGtypeII1.pm0, order21.pm0) annotation(
      Line(points = {{-15, -37.8}, {-15, -31.8}, {-21, -31.8}, {-21, -25.8}}, color = {0, 0, 127}));
    connect(tGtypeII1.W, order21.w) annotation(
      Line(points = {{10.2, -63}, {40.2, -63}, {40.2, 20}, {22.2, 20}}, color = {0, 0, 127}));
    connect(order21.vf, order21.vf0) annotation(
      Line(points = {{-30.6, 10.5}, {-80.6, 10.5}, {-80.6, 42.5}, {-20.6, 42.5}, {-20.6, 24.5}, {-22.6, 24.5}}, color = {0, 0, 127}));
    annotation(
      Icon(graphics = {Rectangle(origin = {5, 6}, fillColor = {0, 0, 255}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-85, 76}, {85, -76}})}),
      __OpenModelica_simulationFlags(lv = "LOG_STATS", s = "dassl"));
  end Plant5;

  model Breaker_type_open
  
    parameter Real t_c=Modelica.Constants.inf "closing time (s)";
    parameter Real t_o=Modelica.Constants.inf "Opening time (s)";
   
     OpenIPSL.Interfaces.PwPin s annotation (Placement(transformation(extent={{-60,-10},{-40,
              10}}), iconTransformation(extent={{-60,-10},{-40,10}})));
    OpenIPSL.Interfaces.PwPin r annotation (Placement(transformation(extent={{40,-10},{60,
              10}}), iconTransformation(extent={{40,-10},{60,10}})));
    Complex vs(re=s.vr, im=s.vi);
    Complex vr(re=r.vr, im=r.vi);
    Complex is(re=s.ir, im=s.ii);
    Complex ir(re=r.ir, im=r.ii);
  equation
    if time > t_c and time < t_o then
      vs = vr;
      is = -ir;
    else
      is = Complex(0, 0);
      ir = Complex(0, 0);
    end if;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=false, extent={{-40,-40},{40,40}}),
          graphics={Rectangle(
            extent={{-40,40},{40,-40}},
            lineThickness=0.5,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None),Ellipse(
            extent={{-40,40},{40,-42}},
            lineColor={28,108,200},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(extent={{-40,-40},{40,40}})),
      Documentation(info="<html>
  <table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
  <tr>
  <td><p>Reference</p></td>
  <td>-</td>
  </tr>
  <tr>
  <td><p>Last update</p></td>
  <td>Major change - 2016-02-22</td>
  </tr>
  <tr>
  <td><p>Author</p></td>
  <td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
  </tr>
  <tr>
  <td><p>Contact</p></td>
  <td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
  </tr>
  </table>
  </html>"));
  
  
  end Breaker_type_open;

  model Breaker_type_close
  
    parameter Real t_c=Modelica.Constants.inf "closing time (s)";
    parameter Real t_o=Modelica.Constants.inf "Opening time (s)";
   
     OpenIPSL.Interfaces.PwPin s annotation (Placement(transformation(extent={{-60,-10},{-40,
              10}}), iconTransformation(extent={{-60,-10},{-40,10}})));
    OpenIPSL.Interfaces.PwPin r annotation (Placement(transformation(extent={{40,-10},{60,
              10}}), iconTransformation(extent={{40,-10},{60,10}})));
    Complex vs(re=s.vr, im=s.vi);
    Complex vr(re=r.vr, im=r.vi);
    Complex is(re=s.ir, im=s.ii);
    Complex ir(re=r.ir, im=r.ii);
  equation
    if time > t_c and time < t_o then
     is = Complex(0, 0);
      ir = Complex(0, 0);
    else
      vs = vr;
      is = -ir;
    end if;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=false, extent={{-40,-40},{40,40}}),
          graphics={Rectangle(
            extent={{-40,40},{40,-40}},
            lineThickness=0.5,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None),Ellipse(
            extent={{-40,40},{40,-42}},
            lineColor={28,108,200},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(extent={{-40,-40},{40,40}})),
      Documentation(info="<html>
  <table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
  <tr>
  <td><p>Reference</p></td>
  <td>-</td>
  </tr>
  <tr>
  <td><p>Last update</p></td>
  <td>Major change - 2016-02-22</td>
  </tr>
  <tr>
  <td><p>Author</p></td>
  <td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
  </tr>
  <tr>
  <td><p>Contact</p></td>
  <td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
  </tr>
  </table>
  </html>"));
  
  
  end Breaker_type_close;

  model Plant6
    OpenIPSL.Electrical.Controls.PSAT.TG.TGtypeII tGtypeII1(R = 0.2, S_b = 1902, Sn = 20, pmax0 = 1, wref = 1) annotation(
      Placement(visible = true, transformation(origin = {-17, -63}, extent = {{21, -21}, {-21, 21}}, rotation = 0)));
    OpenIPSL.Electrical.Machines.PSAT.Order2 order21(D = 0, M = 10, P_0 = 455, Q_0 = 0, Sn = 1430, V_0 = 0.96, V_b = 330, Vn = 20, ra = 0.001, x1d = 0.302) annotation(
      Placement(visible = true, transformation(origin = {-5, -1}, extent = {{-23, -23}, {23, 23}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1430, V_b = 330, Vn = 20, kT = 0.06060606)  annotation(
      Placement(visible = true, transformation(origin = {63, -1}, extent = {{-15, -15}, {15, 15}}, rotation = 0)));
  OpenIPSL.Interfaces.PwPin pwPin1 annotation(
      Placement(visible = true, transformation(origin = {108, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {108, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(twoWindingTransformer1.n, pwPin1) annotation(
      Line(points = {{80, -1}, {106, -1}, {106, 0}, {108, 0}}, color = {0, 0, 255}));
    connect(order21.p, twoWindingTransformer1.p) annotation(
      Line(points = {{18, 0}, {46, 0}, {46, -1}}, color = {0, 0, 255}));
    connect(order21.pm, tGtypeII1.pm) annotation(
      Line(points = {{-32.6, -12.5}, {-55.6, -12.5}, {-55.6, -64}, {-39.6, -64}, {-39.6, -63}}, color = {0, 0, 127}));
    connect(tGtypeII1.pm0, order21.pm0) annotation(
      Line(points = {{-15, -37.8}, {-15, -31.8}, {-21, -31.8}, {-21, -25.8}}, color = {0, 0, 127}));
    connect(tGtypeII1.W, order21.w) annotation(
      Line(points = {{10.2, -63}, {40.2, -63}, {40.2, 20}, {22.2, 20}}, color = {0, 0, 127}));
    connect(order21.vf, order21.vf0) annotation(
      Line(points = {{-30.6, 10.5}, {-80.6, 10.5}, {-80.6, 42.5}, {-20.6, 42.5}, {-20.6, 24.5}, {-22.6, 24.5}}, color = {0, 0, 127}));
    annotation(
      Icon(graphics = {Rectangle(origin = {5, 6}, fillColor = {0, 0, 255}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-85, 76}, {85, -76}})}),
      __OpenModelica_simulationFlags(lv = "LOG_STATS", s = "dassl"));
  
  end Plant6;

  annotation(
    uses(OpenIPSL(version = "1.0.0")));


end Benin_onisitsha_alaoji_330kv_V2;
