package Benin_onisitsha_alaoji_330kv_V1

  model Network
    OpenIPSL.Electrical.Buses.Bus Benin(P_0 = 149.20, Q_0 = 6.35, V_0 = 0.96, V_b = 330, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-66, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine line1(B = 0.001 / 2, G = 0, R = 0.018, X = 0.014, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-74, -16}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
    OpenIPSL.Electrical.Branches.PwLine line2(B = 0.001 / 2, G = 0, R = 0.049, X = 0.042, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Events.PwFault fault(R = 0.5, X = 0.5, t1 = 5, t2 = 7) annotation(
      Placement(visible = true, transformation(origin = {-40, -22}, extent = {{-6, -6}, {6, 6}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus Onitsha(P_0 = 149.10, Q_0 = 3.47, V_0 = 0.96, V_b = 330, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {2, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine line3(B = 0.001 / 2, G = 0, R = 0.021, X = 0.014, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ load2(P_0 = 236, Q_0 = 146, V_0 = 0.96, V_b = 330) annotation(
      Placement(visible = true, transformation(origin = {21, -21}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus Alaoji(P_0 = 13.45, Q_0 = 3.45, V_0 = 0.96, V_b = 330, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {60, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ Load3(P_0 = 248, Q_0 = 153, V_0 = 0.96, V_b = 330) annotation(
      Placement(visible = true, transformation(origin = {84, -8.88178e-16}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ Load1(P_0 = 136, Q_0 = 84, V_0 = 0.96, V_b = 330) annotation(
      Placement(visible = true, transformation(origin = {-87, 1}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine line4(B = 0.001 / 2, G = 0, R = 0.018, X = 0.014, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {74, -16}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 1902) annotation(
      Placement(visible = true, transformation(origin = {80, 42}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0.001 / 2, G = 0, R = 0.049, X = 0.042, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, 28}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Breaker_type_open breaker_type_open1(t_c = 5.5, t_o = 6.5)  annotation(
      Placement(visible = true, transformation(origin = {-46, 28}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
    Benin_onitsha_alaoji_330kv.Plant2 plant21 annotation(
      Placement(visible = true, transformation(origin = {72, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
    Benin_onitsha_alaoji_330kv.Plant1 plant11 annotation(
      Placement(visible = true, transformation(origin = {-74, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  equation
  connect(line4.n, plant21.pwPin1) annotation(
      Line(points = {{74, -24}, {74, -29}, {72, -29}, {72, -31}}, color = {0, 0, 255}));
  connect(Benin.p, line2.p) annotation(
      Line(points = {{-66, 0}, {-40, 0}, {-40, 0}, {-38, 0}}, color = {0, 0, 255}));
  connect(line1.p, plant11.pwPin1) annotation(
      Line(points = {{-74, -24}, {-74, -24}, {-74, -40}, {-74, -40}}, color = {0, 0, 255}));
    connect(breaker_type_open1.r, pwLine1.p) annotation(
      Line(points = {{-40, 28}, {-33, 28}}, color = {0, 0, 255}));
    connect(pwLine1.n, Onitsha.p) annotation(
      Line(points = {{-15, 28}, {-8, 28}, {-8, 0}, {2, 0}}, color = {0, 0, 255}));
    connect(Benin.p, breaker_type_open1.s) annotation(
      Line(points = {{-66, 0}, {-60, 0}, {-60, 28}, {-52, 28}, {-52, 28}}, color = {0, 0, 255}));
    connect(line3.n, Alaoji.p) annotation(
      Line(points = {{40, 0}, {60, 0}, {60, 0}, {60, 0}}, color = {0, 0, 255}));
    connect(Onitsha.p, line3.p) annotation(
      Line(points = {{2, 0}, {20, 0}, {20, 0}, {22, 0}}, color = {0, 0, 255}));
    connect(line2.n, Onitsha.p) annotation(
      Line(points = {{-20, 0}, {2, 0}, {2, 0}, {2, 0}}, color = {0, 0, 255}));
    connect(Alaoji.p, Load3.p) annotation(
      Line(points = {{60, 0}, {78, 0}, {78, 0}, {78, 0}}, color = {0, 0, 255}));
    connect(Alaoji.p, line4.p) annotation(
      Line(points = {{60, 0}, {74, 0}, {74, -7}}, color = {0, 0, 255}));
    connect(load2.p, line3.p) annotation(
      Line(points = {{21, -16}, {20, -16}, {20, 0}}, color = {0, 0, 255}));
    connect(fault.p, line2.p) annotation(
      Line(points = {{-40, -15}, {-40, 0}}, color = {0, 0, 255}));
    connect(line1.n, Benin.p) annotation(
      Line(points = {{-74, -7}, {-74, 0}, {-66, 0}}, color = {0, 0, 255}));
    connect(Load1.p, Benin.p) annotation(
      Line(points = {{-82, 1}, {-66, 1}, {-66, -1}, {-66, -1}}, color = {0, 0, 255}));
  end Network;

  model Plant1
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1902, V_b = 330, Vn = 20, kT = 0.06060606, r = 0.1, x = 0.001) annotation(
      Placement(visible = true, transformation(origin = {47, -1}, extent = {{-17, -17}, {17, 17}}, rotation = 0)));
    OpenIPSL.Interfaces.PwPin pwPin1 annotation(
      Placement(visible = true, transformation(origin = {97, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0), iconTransformation(origin = {97, -1}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 1902) annotation(
      Placement(visible = true, transformation(origin = {84, 62}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order5_Type2 order5_Type21(D = 0, M = 10, P_0 = 386, Sn = 1902, V_0 = 0.96, V_b = 330, Vn = 20, ra = 0.001, x1d = 0.302)  annotation(
      Placement(visible = true, transformation(origin = {-32, 0}, extent = {{-24, -24}, {24, 24}}, rotation = 0)));
  equation
    connect(order5_Type21.vf, order5_Type21.vf0) annotation(
      Line(points = {{-60, 12}, {-72, 12}, {-72, 36}, {-52, 36}, {-52, 26}, {-52, 26}}, color = {0, 0, 127}));
    connect(order5_Type21.pm, order5_Type21.pm0) annotation(
      Line(points = {{-60, -12}, {-66, -12}, {-66, -36}, {-52, -36}, {-52, -26}, {-52, -26}}, color = {0, 0, 127}));
    connect(order5_Type21.p, twoWindingTransformer1.p) annotation(
      Line(points = {{-8, 0}, {28, 0}, {28, 0}, {28, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer1.n, pwPin1) annotation(
      Line(points = {{66, -1}, {94, -1}, {94, 0}, {98, 0}}, color = {0, 0, 255}));
  annotation(
      Icon(graphics = {Ellipse(origin = {4, 0}, extent = {{-86, 76}, {86, -76}}, endAngle = 360), Bitmap(extent = {{-30, 44}, {-30, 44}}), Rectangle(origin = {5, 3}, extent = {{-47, 41}, {47, -41}}), Text(origin = {1, 4}, extent = {{-23, 18}, {23, -18}}, textString = "Plant1")}));end Plant1;

  model Plant2
    OpenIPSL.Interfaces.PwPin pwPin1 annotation(
      Placement(visible = true, transformation(origin = {92, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {92, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 1430, V_b = 330, Vn = 20, kT = 0.06060606) annotation(
      Placement(visible = true, transformation(origin = {17, -1}, extent = {{-19, -19}, {19, 19}}, rotation = 0)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 1902) annotation(
      Placement(visible = true, transformation(origin = {52, 64}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order3 order31(D = 0, M = 10, P_0 = 455, Sn = 1430, T1d0 = 8, V_0 = 0.96, V_b = 330, Vn = 20, ra = 0.001, x1d = 0.302, xd = 1.9, xq = 1.7)  annotation(
      Placement(visible = true, transformation(origin = {-42, -2}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  equation
    connect(order31.p, twoWindingTransformer1.p) annotation(
      Line(points = {{-22, -2}, {-2, -2}, {-2, 0}, {-4, 0}}, color = {0, 0, 255}));
    connect(order31.vf, order31.vf0) annotation(
      Line(points = {{-66, 8}, {-76, 8}, {-76, 30}, {-58, 30}, {-58, 20}, {-58, 20}}, color = {0, 0, 127}));
    connect(order31.pm0, order31.pm) annotation(
      Line(points = {{-58, -24}, {-58, -24}, {-58, -38}, {-78, -38}, {-78, -12}, {-66, -12}, {-66, -12}}, color = {0, 0, 127}));
    connect(twoWindingTransformer1.n, pwPin1) annotation(
      Line(points = {{38, -2}, {86, -2}, {86, 0}, {92, 0}}, color = {0, 0, 255}));
  annotation(
      Icon(graphics = {Ellipse(extent = {{-82, 80}, {82, -80}}, endAngle = 360), Rectangle(origin = {6, 6}, extent = {{-44, 42}, {44, -42}}), Text(origin = {7, 6}, extent = {{-21, 20}, {21, -20}}, textString = "Plant2")}));end Plant2;

  model Breaker_type_open
  
    parameter Real t_c=Modelica.Constants.inf "closing time (s)";
    parameter Real t_o=Modelica.Constants.inf "Opening time (s)";
   
     OpenIPSL.Interfaces.PwPin s annotation (Placement(transformation(extent={{-60,-10},{-40,
              10}}), iconTransformation(extent={{-60,-10},{-40,10}})));
    OpenIPSL.Interfaces.PwPin r annotation (Placement(transformation(extent={{40,-10},{60,
              10}}), iconTransformation(extent={{40,-10},{60,10}})));
    Complex vs(re=s.vr, im=s.vi);
    Complex vr(re=r.vr, im=r.vi);
    Complex is(re=s.ir, im=s.ii);
    Complex ir(re=r.ir, im=r.ii);
  equation
    if time > t_c and time < t_o then
      vs = vr;
      is = -ir;
    else
      is = Complex(0, 0);
      ir = Complex(0, 0);
    end if;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=false, extent={{-40,-40},{40,40}}),
          graphics={Rectangle(
            extent={{-40,40},{40,-40}},
            lineThickness=0.5,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None),Ellipse(
            extent={{-40,40},{40,-42}},
            lineColor={28,108,200},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(extent={{-40,-40},{40,40}})),
      Documentation(info="<html>
  <table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
  <tr>
  <td><p>Reference</p></td>
  <td>-</td>
  </tr>
  <tr>
  <td><p>Last update</p></td>
  <td>Major change - 2016-02-22</td>
  </tr>
  <tr>
  <td><p>Author</p></td>
  <td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
  </tr>
  <tr>
  <td><p>Contact</p></td>
  <td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
  </tr>
  </table>
  </html>"));
  
  
  end Breaker_type_open;

  model Breaker_type_close
  
    parameter Real t_c=Modelica.Constants.inf "closing time (s)";
    parameter Real t_o=Modelica.Constants.inf "Opening time (s)";
   
     OpenIPSL.Interfaces.PwPin s annotation (Placement(transformation(extent={{-60,-10},{-40,
              10}}), iconTransformation(extent={{-60,-10},{-40,10}})));
    OpenIPSL.Interfaces.PwPin r annotation (Placement(transformation(extent={{40,-10},{60,
              10}}), iconTransformation(extent={{40,-10},{60,10}})));
    Complex vs(re=s.vr, im=s.vi);
    Complex vr(re=r.vr, im=r.vi);
    Complex is(re=s.ir, im=s.ii);
    Complex ir(re=r.ir, im=r.ii);
  equation
    if time > t_c and time < t_o then
     is = Complex(0, 0);
      ir = Complex(0, 0);
    else
      vs = vr;
      is = -ir;
    end if;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio=false, extent={{-40,-40},{40,40}}),
          graphics={Rectangle(
            extent={{-40,40},{40,-40}},
            lineThickness=0.5,
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid,
            pattern=LinePattern.None),Ellipse(
            extent={{-40,40},{40,-42}},
            lineColor={28,108,200},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(extent={{-40,-40},{40,40}})),
      Documentation(info="<html>
  <table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
  <tr>
  <td><p>Reference</p></td>
  <td>-</td>
  </tr>
  <tr>
  <td><p>Last update</p></td>
  <td>Major change - 2016-02-22</td>
  </tr>
  <tr>
  <td><p>Author</p></td>
  <td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
  </tr>
  <tr>
  <td><p>Contact</p></td>
  <td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
  </tr>
  </table>
  </html>"));
  
  
  end Breaker_type_close;


  annotation(
    uses(OpenIPSL(version = "1.0.0")));

end Benin_onisitsha_alaoji_330kv_V1;
