model ieee30bus
  OpenIPSL.Electrical.Buses.Bus bus1( V_0 = 1,V_b = 132, angle_0 = 0, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-27, 91}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0.02640, G = 0, R = 0.01920, X = 0.05750)  annotation(
    Placement(visible = true, transformation(origin = {-53, 93}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(P_0 = 40, V_0 = 1.043, V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-83, 91}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3( P_0 = 2.4, Q_0 = 1.2, V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-25, 63}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus4( P_0 = 7.6, Q_0 = 1.6, V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-25, 33}, extent = {{-7, -7}, {7, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus5( P_0 = 49,V_0 = 1.01, V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-95, -23}, extent = {{-7, -7}, {7, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus6(  V_0 = 1,V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-35, -21}, extent = {{-7, -7}, {7, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus7( P_0 = 22.8, Q_0 = 10.9, V_0 = 1, V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-63, -19}, extent = {{-7, -7}, {7, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0.02040, G = 0, R = 0.04520, X = 0.18520)  annotation(
    Placement(visible = true, transformation(origin = {-31, 75}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0.00420, G = 0, R = 0.01320, X = 0.03790)  annotation(
    Placement(visible = true, transformation(origin = {-41, 43}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0.02090, G = 0, R = 0.04720, X = 0.19830)  annotation(
    Placement(visible = true, transformation(origin = {-85, 39}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0.01020, G = 0, R = 0.04600, X = 0.11600)  annotation(
    Placement(visible = true, transformation(origin = {-75, -23}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine6(B = 0.00850, G = 0, R = 0.02670, X = 0.08200)  annotation(
    Placement(visible = true, transformation(origin = {-51, -21}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus8( P_0 = 30,V_0 = 1.01, V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-51, -85}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus9(  V_0 = 1,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-13, -29}, extent = {{-7, -7}, {7, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine7(B = 0.00450, G = 0, R = 0.01200, X = 0.04200)  annotation(
    Placement(visible = true, transformation(origin = {-52, -58}, extent = {{-4, -4}, {4, 4}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 32, V_b = 33, Vn = 33, m = 0.969, r = 0, rT = 0, x = 0.55600, xT = 0.55600)  annotation(
    Placement(visible = true, transformation(origin = {-16, -12}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Banks.PwCapacitorBank pwCapacitorBank1(B = 0.19, nsteps = 1)  annotation(
    Placement(visible = true, transformation(origin = {-1, -5}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus10(  P_0 = 5.8, Q_0 = 2,V_0 = 1, V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {9, -15}, extent = {{-7, -7}, {7, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus11(P_0 = 0,V_0 = 1.082, V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {7, -39}, extent = {{-7, -7}, {7, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus12( P_0 = 11.2, Q_0 = 7.5,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {3, 33}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus13(P_0 = 0,V_0 = 1.071, V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {5, 49}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus14( P_0 = 6.2, Q_0 = 1.6,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {41, 57}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine9(B = 0, G = 0, R = 0.12310, X = 0.25590)  annotation(
    Placement(visible = true, transformation(origin = {23, 35}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine10(B = 0, G = 0, R = 0.22100, X = 0.19970)  annotation(
    Placement(visible = true, transformation(origin = {47, 41}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus15( P_0 = 8.2, Q_0 = 2.5, V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {55, 31}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus16( P_0 = 3.5, Q_0 = 1.8,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {27, 23}, extent = {{-5, -5}, {5, 5}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus17( P_0 = 9, Q_0 = 5.8,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {21, -5}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus18( P_0 = 3.2, Q_0 = 0.9,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {51, 13}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus19( P_0 = 9.5, Q_0 = 3.4,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {47, -1}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus20( P_0 = 2.2, Q_0 = 0.7,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {35, 1}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine11(B = 0, G = 0, R = 0.10700, X = 0.21850)  annotation(
    Placement(visible = true, transformation(origin = {44, 24}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine12(B = 0, G = 0, R = 0.06390, X = 0.12920)  annotation(
    Placement(visible = true, transformation(origin = {44, 8}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine13(B = 0, G = 0, R = 0.03400, X = 0.06800)  annotation(
    Placement(visible = true, transformation(origin = {40, 0}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine15(B = 0, G = 0, R = 0.09360, X = 0.20900)  annotation(
    Placement(visible = true, transformation(origin = {16, -4}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine16(B = 0, G = 0, R = 0.03240, X = 0.08450)  annotation(
    Placement(visible = true, transformation(origin = {20, -12}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine17(B = 0, G = 0, R = 0.08240, X = 0.19320)  annotation(
    Placement(visible = true, transformation(origin = {22, 6}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus21( P_0 = 17.5, Q_0 = 11.2,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {41, -13}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus22( V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {53, -19}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine18(B = 0, G = 0, R = 0.03480, X = 0.07490)  annotation(
    Placement(visible = true, transformation(origin = {28, -14}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine19(B = 0, G = 0, R = 0.07270, X = 0.14990)  annotation(
    Placement(visible = true, transformation(origin = {32, -18}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus23( P_0 = 3.2, Q_0 = 1.6,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {65, 9}, extent = {{-3, -3}, {3, 3}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus24( P_0 = 8.7, Q_0 = 6.7,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {71, -13}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine20(B = 0, G = 0, R = 0.09450, X = 0.19870)  annotation(
    Placement(visible = true, transformation(origin = {15, 27}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine21(B = 0, G = 0, R = 0.10000, X = 0.20200)  annotation(
    Placement(visible = true, transformation(origin = {66, 20}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Banks.PwCapacitorBank pwCapacitorBank2(B = 0.043, nsteps = 1)  annotation(
    Placement(visible = true, transformation(origin = {77, -1}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus25( V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {77, -19}, extent = {{-3, -3}, {3, 3}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus26(P_0 = 3.50, Q_0 = 2.30,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {81, -27}, extent = {{-3, -3}, {3, 3}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine22(B = 0, G = 0, R = 0.13200, X = 0.27000)  annotation(
    Placement(visible = true, transformation(origin = {62, -4}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine23(B = 0, G = 0, R = 0.18850, X = 0.32920)  annotation(
    Placement(visible = true, transformation(origin = {66, -22}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine24(B = 0, G = 0, R = 0.25440, X = 0.38000)  annotation(
    Placement(visible = true, transformation(origin = {78, -22}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus27( V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {99, -17}, extent = {{-3, -3}, {3, 3}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine26(B = 0, G = 0,R = 0.10930, X = 0.20870)  annotation(
    Placement(visible = true, transformation(origin = {86, -6}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus28( V_b = 132, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {99, -35}, extent = {{-3, -3}, {3, 3}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus29( P_0 = 2.4, Q_0 = 0.9,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {111, -13}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(Sn = 65, V_b = 33, Vn = 33, m = 0.968, rT = 0, xT = 0.36900)  annotation(
    Placement(visible = true, transformation(origin = {99, -27}, extent = {{-3, -3}, {3, 3}}, rotation = 90)));
  OpenIPSL.Electrical.Buses.Bus bus30( P_0 = 10.6, Q_0 = 1.9,V_b = 33, displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {111, -1}, extent = {{-3, -3}, {3, 3}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine27(B = 0, G = 0, R = 0.21980, X = 0.41530)  annotation(
    Placement(visible = true, transformation(origin = {104, -12}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine28(B = 0, G = 0, R = 0.23990, X = 0.45330)  annotation(
    Placement(visible = true, transformation(origin = {108, -6}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine29(B = 0, G = 0, R = 0.32020, X = 0.60270)  annotation(
    Placement(visible = true, transformation(origin = {100, -6}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine30(B = 0.00650, G = 0, R = 0.01690, X = 0.05990)  annotation(
    Placement(visible = true, transformation(origin = {96, -52}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine31(B = 0.02140, G = 0, R = 0.06360, X = 0.20000)  annotation(
    Placement(visible = true, transformation(origin = {102, -52}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine32(B = 0.01870, G = 0, R = 0.05810, X = 0.17630)  annotation(
    Placement(visible = true, transformation(origin = {-75, 61}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine33(B = 0.01840, G = 0, R = 0.05700, X = 0.17370)  annotation(
    Placement(visible = true, transformation(origin = {-63, 61}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine34(B = 0.00450, G = 0, R = 0.01190, X = 0.04140)  annotation(
    Placement(visible = true, transformation(origin = {-43, 21}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
  inner OpenIPSL.Electrical.SystemBase SysData annotation(
    Placement(visible = true, transformation(origin = {106, 106}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine35(B = 0, G = 0, R = 0.06620, X = 0.13040) annotation(
    Placement(visible = true, transformation(origin = {35, 29}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine36(B = 0, G = 0, R = 0.01160, X = 0.02360) annotation(
    Placement(visible = true, transformation(origin = {46, -14}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PwLine pwLine37(B = 0, G = 0, R = 0.11500, X = 0.17900)  annotation(
    Placement(visible = true, transformation(origin = {60, -18}, extent = {{-2, -2}, {2, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeI aVRTypeI1(Ae = 0.0006, Be = 0.9, K0 = 7.04, T1 = 6.67, T2 = 1, T3 = 1, T4 = 1, Te = 0.4, Tr = 0.05, v0 = 1, vrmax = 7.57, vrmin = 0)  annotation(
    Placement(visible = true, transformation(origin = {26, 89}, extent = {{-6, -7}, {6, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeI aVRTypeI2(Ae = 0.0006, Be = 0.9, K0 = 7.04, T1 = 6.67, T2 = 1, T3 = 1, T4 = 1, Te = 0.4, Tr = 0.05, v0 = 1, vrmax = 7.57, vrmin = 0) annotation(
    Placement(visible = true, transformation(origin = {-114, 65}, extent = {{-6, -7}, {6, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeI aVRTypeI3(Ae = 0.0006, Be = 0.9, K0 = 7.04, T1 = 6.67, T2 = 1, T3 = 1, T4 = 1, Te = 0.4, Tr = 0.05, v0 = 1, vrmax = 7.57, vrmin = 0) annotation(
    Placement(visible = true, transformation(origin = {-112, -49}, extent = {{-6, -7}, {6, 7}}, rotation = 90)));
  OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeI aVRTypeI4(Ae = 0.0006, Be = 0.9, K0 = 7.04, T1 = 6.67, T2 = 1, T3 = 1, T4 = 1, Te = 0.4, Tr = 0.05, v0 = 1, vrmax = 7.57, vrmin = 0) annotation(
    Placement(visible = true, transformation(origin = {-22, -109}, extent = {{-6, -7}, {6, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeI aVRTypeI5(Ae = 0.0006, Be = 0.9, K0 = 7.04, T1 = 6.67, T2 = 1, T3 = 1, T4 = 1, Te = 0.4, Tr = 0.05, v0 = 1, vrmax = 7.57, vrmin = 0) annotation(
    Placement(visible = true, transformation(origin = {32, -51}, extent = {{-6, -7}, {6, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeI aVRTypeI6(Ae = 0.0006, Be = 0.9, K0 = 7.04, T1 = 6.67, T2 = 1, T3 = 1, T4 = 1, Te = 0.4, Tr = 0.05, v0 = 1, vrmax = 7.57, vrmin = 0) annotation(
    Placement(visible = true, transformation(origin = {29, 50}, extent = {{-3, -2}, {3, 2}}, rotation = 180)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer3(Sn = 65, V_b = 33, Vn = 33, m = 0.932, r = 0, rT = 0, x = 0.25600, xT = 0.25600) annotation(
    Placement(visible = true, transformation(origin = {-12, 34}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine14(B = 0, G = 0, R = 0, X = 0.14000) annotation(
    Placement(visible = true, transformation(origin = {-2, 44}, extent = {{-2, -2}, {2, 2}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine25(B = 0, G = 0, R = 0, X = 0.1100) annotation(
    Placement(visible = true, transformation(origin = {4, -24}, extent = {{-2, -2}, {2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine8(B = 0, G = 0, R = 0, X = 0.20800) annotation(
    Placement(visible = true, transformation(origin = {-4, -28}, extent = {{-2, -2}, {2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1(P_0 = 21.7, Q_0 = 12.7, V_b = 132)  annotation(
    Placement(visible = true, transformation(origin = {-92, 108}, extent = {{-4, -4}, {4, 4}}, rotation = 180)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant2(P_0 = 2.4, Q_0 = 1.2, V_b = 132) annotation(
    Placement(visible = true, transformation(origin = {-18, 56}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant3(P_0 = 7.6, Q_0 = 1.6, V_b = 132) annotation(
    Placement(visible = true, transformation(origin = {-18, 18}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant4(P_0 = 11.2, Q_0 = 7.5, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {-2, 22}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant5(P_0 = 47.1, Q_0 = 9.5, V_b = 132) annotation(
    Placement(visible = true, transformation(origin = {-88, -40}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant6(P_0 = 47.1, Q_0 = 9.5, V_b = 132) annotation(
    Placement(visible = true, transformation(origin = {-82, -40}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant7(P_0 = 22.8, Q_0 = 10.9, V_b = 132) annotation(
    Placement(visible = true, transformation(origin = {-68, -42}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant8(P_0 = 5.8, Q_0 = 2, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {22, -26}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant9(P_0 = 6.2, Q_0 = 1.6, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = { 50, 56}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant10(P_0 = 8.2, Q_0 = 2.5, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {72, 32}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant11(P_0 = 3.5, Q_0 = 1.8, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {34, 22}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant12(P_0 = 9, Q_0 = 5.8, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {28, -4}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant13(P_0 = 3.2, Q_0 = 0.9, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {58, 14}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant14(P_0 = 9.5, Q_0 = 3.4, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {54, -2}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant15(P_0 = 2.2, Q_0 = 0.7, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {39, -5}, extent = {{1, -1}, {-1, 1}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant16(P_0 = 17.5, Q_0 = 11.2, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {48, -10}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant17(P_0 = 3.5, Q_0 = 2.3, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {82, -34}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant18(P_0 = 3.2, Q_0 = 1.6, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {68, 2}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant19(P_0 = 2.4, Q_0 = 0.9, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {118, -14}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant20(P_0 = 10.6, Q_0 = 1.9, V_b = 33) annotation(
    Placement(visible = true, transformation(origin = {120, -2}, extent = {{2, -2}, {-2, 2}}, rotation = 90)));
  OpenIPSL.Electrical.Machines.PSSE.GENROU genrou1(D = 10, H = 4,M_b = 500, R_a = 0.008, S10 = 0.0769, S12 = 0.41, Tpd0 = 1.8, Tppd0 = 0.005, Tppq0 = 0.005, Tpq0 = 9.2, V_0 = 1, V_b = 132, Xd = 1.45, Xl = 0.045, Xpd = 0.28, Xpp = 0.01, Xppd = 0.17, Xppq = 0.2, Xpq = 0.28, Xq = 1.42, angle_0 = 0)  annotation(
    Placement(visible = true, transformation(origin = {-2, 89}, extent = {{8, -7}, {-8, 7}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSSE.GENROU genrou2(D = 10, H = 4,M_b = 150, P_0 = 40, R_a = 0.008, S10 = 0.0769, S12 = 0.41, Tpd0 = 1.8, Tppd0 = 0.005, Tppq0 = 0.005, Tpq0 = 9.2, V_0 = 1.043, V_b = 132, Xd = 1.45, Xl = 0.045, Xpd = 0.28, Xpp = 0.01, Xppd = 0.17, Xppq = 0.2, Xpq = 0.28, Xq = 1.42) annotation(
    Placement(visible = true, transformation(origin = {-110, 93}, extent = {{8, -7}, {-8, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Machines.PSSE.GENROU genrou3(D = 10, H = 4,M_b = 100, P_0 = 49, R_a = 0.008, S10 = 0.0769, S12 = 0.41, Tpd0 = 1.8, Tppd0 = 0.005, Tppq0 = 0.005, Tpq0 = 9.2, V_0 = 1.01, V_b = 132, Xd = 1.45, Xl = 0.045, Xpd = 0.28, Xpp = 0.01, Xppd = 0.17, Xppq = 0.2, Xpq = 0.28, Xq = 1.42) annotation(
    Placement(visible = true, transformation(origin = {-110, -23}, extent = {{8, -7}, {-8, 7}}, rotation = 180)));
  OpenIPSL.Electrical.Machines.PSSE.GENROU genrou4(D = 10, H = 4,M_b = 75, P_0 = 30, R_a = 0.008, S10 = 0.0769, S12 = 0.41, Tpd0 = 1.8, Tppd0 = 0.005, Tppq0 = 0.005, Tpq0 = 9.2, V_0 = 1.01, V_b = 132, Xd = 1.45, Xl = 0.045, Xpd = 0.28, Xpp = 0.01, Xppd = 0.17, Xppq = 0.2, Xpq = 0.28, Xq = 1.42) annotation(
    Placement(visible = true, transformation(origin = {-52, -105}, extent = {{8, -7}, {-8, 7}}, rotation = 270)));
  OpenIPSL.Electrical.Machines.PSSE.GENROU genrou5(D = 10, H = 4,M_b = 65, P_0 = 0, R_a = 0.008, S10 = 0.0769, S12 = 0.41, Tpd0 = 1.8, Tppd0 = 0.005, Tppq0 = 0.005, Tpq0 = 9.2, V_0 = 1.082, V_b = 33, Xd = 1.45, Xl = 0.045, Xpd = 0.28, Xpp = 0.01, Xppd = 0.17, Xppq = 0.2, Xpq = 0.28, Xq = 1.42) annotation(
    Placement(visible = true, transformation(origin = {8, -51}, extent = {{4, -5}, {-4, 5}}, rotation = 270)));
  OpenIPSL.Electrical.Machines.PSSE.GENROU genrou6(D = 10, H = 4,M_b = 80, P_0 = 0, R_a = 0.008, S10 = 0.0769, S12 = 0.41, Tpd0 = 1.8, Tppd0 = 0.005, Tppq0 = 0.005, Tpq0 = 9.2, V_0 = 1.071, V_b = 33, Xd = 1.45, Xl = 0.045, Xpd = 0.28, Xpp = 0.01, Xppd = 0.17, Xppq = 0.2, Xpq = 0.28, Xq = 1.42) annotation(
    Placement(visible = true, transformation(origin = {15, 49}, extent = {{3, -3}, {-3, 3}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer4(Sn = 65, V_b = 33, Vn = 33, m = 0.978, rT = 0, xT = 0.208)  annotation(
    Placement(visible = true, transformation(origin = {-24, -44}, extent = {{6, -6}, {-6, 6}}, rotation = 180)));
  OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0, X = 10e-3, t1 = 4.6, t2 = 5)  annotation(
    Placement(visible = true, transformation(origin = {38, 14}, extent = {{2, -2}, {-2, 2}}, rotation = 0)));
equation
  connect(pwFault1.p, bus18.p) annotation(
    Line(points = {{40, 14}, {42, 14}, {42, 12}, {52, 12}, {52, 14}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.n, bus27.p) annotation(
    Line(points = {{99, -24}, {99, -16.7}}, color = {0, 0, 255}));
  connect(twoWindingTransformer2.p, bus28.p) annotation(
    Line(points = {{99, -30}, {98, -30}, {98, -35.3}, {99, -35.3}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.p, bus6.p) annotation(
    Line(points = {{-22, -12}, {-26, -12}, {-26, -22}, {-34, -22}, {-34, -20}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus10.p) annotation(
    Line(points = {{-10, -12}, {4, -12}, {4, -16}, {10, -16}, {10, -14}, {10, -14}}, color = {0, 0, 255}));
  connect(twoWindingTransformer4.n, bus9.p) annotation(
    Line(points = {{-18, -44}, {-16, -44}, {-16, -30}, {-12, -30}, {-12, -28}}, color = {0, 0, 255}));
  connect(twoWindingTransformer4.p, bus6.p) annotation(
    Line(points = {{-30, -44}, {-32, -44}, {-32, -20}, {-34, -20}, {-34, -20}}, color = {0, 0, 255}));
  connect(twoWindingTransformer3.p, bus4.p) annotation(
    Line(points = {{-18, 34}, {-24, 34}, {-24, 34}, {-24, 34}}, color = {0, 0, 255}));
  connect(twoWindingTransformer3.n, bus12.p) annotation(
    Line(points = {{-6, 34}, {2, 34}, {2, 34}, {4, 34}}, color = {0, 0, 255}));
  connect(genrou6.ETERM, aVRTypeI6.v) annotation(
    Line(points = {{12, 48}, {8, 48}, {8, 42}, {34, 42}, {34, 52}, {32, 52}, {32, 52}}, color = {0, 0, 127}));
  connect(aVRTypeI6.vf0, genrou6.EFD0) annotation(
    Line(points = {{30, 52}, {30, 54}, {22, 54}, {22, 44}, {10, 44}, {10, 48}, {12, 48}}, color = {0, 0, 127}));
  connect(genrou6.EFD, aVRTypeI6.vf) annotation(
    Line(points = {{18, 48}, {24, 48}, {24, 50}, {26, 50}, {26, 50}, {26, 50}}, color = {0, 0, 127}));
  connect(genrou6.PMECH0, genrou6.PMECH) annotation(
    Line(points = {{12, 50}, {10, 50}, {10, 52}, {10, 52}, {10, 54}, {20, 54}, {20, 50}, {18, 50}, {18, 50}}, color = {0, 0, 127}));
  connect(bus13.p, genrou6.p) annotation(
    Line(points = {{6, 50}, {9, 50}, {9, 49}, {12, 49}}, color = {0, 0, 255}));
  connect(bus8.p, pwLine7.p) annotation(
    Line(points = {{-51, -85}, {-53, -85}, {-53, -71}, {-52, -71}, {-52, -62}}, color = {0, 0, 255}));
  connect(pwLine7.n, bus6.p) annotation(
    Line(points = {{-52, -54}, {-52, -46.4}, {-40, -46.4}, {-40, -21}, {-35, -21}}, color = {0, 0, 255}));
  connect(pwCapacitorBank1.p, bus10.p) annotation(
    Line(points = {{-1, -8}, {-3, -8}, {-3, -12}, {3, -12}, {3, -15}, {8, -15}}, color = {0, 0, 255}));
  connect(genrou5.ETERM, aVRTypeI5.v) annotation(
    Line(points = {{6, -46}, {6, -46}, {6, -42}, {26, -42}, {26, -38}, {40, -38}, {40, -46}, {40, -46}}, color = {0, 0, 127}));
  connect(aVRTypeI5.vf0, genrou5.EFD0) annotation(
    Line(points = {{32, -42}, {32, -42}, {32, -40}, {20, -40}, {20, -46}, {6, -46}, {6, -46}, {6, -46}}, color = {0, 0, 127}));
  connect(genrou5.EFD, aVRTypeI5.vf) annotation(
    Line(points = {{6, -56}, {6, -56}, {6, -60}, {16, -60}, {16, -50}, {24, -50}, {24, -50}}, color = {0, 0, 127}));
  connect(genrou5.PMECH0, genrou5.PMECH) annotation(
    Line(points = {{10, -46}, {10, -46}, {10, -44}, {14, -44}, {14, -58}, {10, -58}, {10, -56}, {10, -56}}, color = {0, 0, 127}));
  connect(genrou5.p, bus11.p) annotation(
    Line(points = {{8, -46}, {8, -46}, {8, -38}, {8, -38}}, color = {0, 0, 255}));
  connect(aVRTypeI4.v, genrou4.ETERM) annotation(
    Line(points = {{-14, -104}, {-8, -104}, {-8, -94}, {-54, -94}, {-54, -96}, {-54, -96}}, color = {0, 0, 127}));
  connect(aVRTypeI4.vf0, genrou4.EFD0) annotation(
    Line(points = {{-22, -100}, {-22, -100}, {-22, -94}, {-56, -94}, {-56, -96}, {-56, -96}}, color = {0, 0, 127}));
  connect(genrou4.EFD, aVRTypeI4.vf) annotation(
    Line(points = {{-56, -114}, {-56, -114}, {-56, -118}, {-34, -118}, {-34, -110}, {-30, -110}, {-30, -108}}, color = {0, 0, 127}));
  connect(genrou4.PMECH0, genrou4.PMECH) annotation(
    Line(points = {{-48, -96}, {-48, -96}, {-48, -94}, {-44, -94}, {-44, -118}, {-48, -118}, {-48, -114}, {-48, -114}}, color = {0, 0, 127}));
  connect(genrou4.p, bus8.p) annotation(
    Line(points = {{-52, -96}, {-52, -96}, {-52, -84}, {-50, -84}}, color = {0, 0, 255}));
  connect(aVRTypeI4.vref0, aVRTypeI4.vref) annotation(
    Line(points = {{-22, -117.4}, {-10, -117.4}, {-10, -113.4}, {-14, -113.4}, {-14, -113.4}, {-14, -113.4}}, color = {0, 0, 127}));
  connect(aVRTypeI3.v, genrou3.ETERM) annotation(
    Line(points = {{-108, -56}, {-108, -56}, {-108, -60}, {-100, -60}, {-100, -22}, {-102, -22}, {-102, -20}}, color = {0, 0, 127}));
  connect(aVRTypeI3.vf0, genrou3.EFD0) annotation(
    Line(points = {{-104, -48}, {-100, -48}, {-100, -20}, {-102, -20}, {-102, -20}}, color = {0, 0, 127}));
  connect(aVRTypeI3.vf, genrou3.EFD) annotation(
    Line(points = {{-112, -42}, {-112, -42}, {-112, -36}, {-124, -36}, {-124, -20}, {-120, -20}, {-120, -20}}, color = {0, 0, 127}));
  connect(genrou3.PMECH, genrou3.PMECH0) annotation(
    Line(points = {{-120, -26}, {-122, -26}, {-122, -32}, {-100, -32}, {-100, -26}, {-102, -26}, {-102, -26}, {-102, -26}}, color = {0, 0, 127}));
  connect(genrou3.p, bus5.p) annotation(
    Line(points = {{-102, -22}, {-96, -22}, {-96, -22}, {-94, -22}}, color = {0, 0, 255}));
  connect(genrou2.ETERM, aVRTypeI2.v) annotation(
    Line(points = {{-102, 96}, {-96, 96}, {-96, 54}, {-110, 54}, {-110, 58}, {-110, 58}}, color = {0, 0, 127}));
  connect(aVRTypeI2.vf0, genrou2.EFD0) annotation(
    Line(points = {{-106, 66}, {-98, 66}, {-98, 96}, {-102, 96}, {-102, 96}}, color = {0, 0, 127}));
  connect(aVRTypeI2.vf, genrou2.EFD) annotation(
    Line(points = {{-114, 72}, {-114, 72}, {-114, 78}, {-124, 78}, {-124, 96}, {-120, 96}, {-120, 96}}, color = {0, 0, 127}));
  connect(genrou2.PMECH0, genrou2.PMECH) annotation(
    Line(points = {{-102, 90}, {-98, 90}, {-98, 84}, {-122, 84}, {-122, 90}, {-120, 90}, {-120, 90}, {-120, 90}}, color = {0, 0, 127}));
  connect(genrou2.p, bus2.p) annotation(
    Line(points = {{-102, 94}, {-88, 94}, {-88, 90}, {-82, 90}, {-82, 92}, {-82, 92}}, color = {0, 0, 255}));
  connect(genrou1.ETERM, aVRTypeI1.v) annotation(
    Line(points = {{-10, 86}, {-20, 86}, {-20, 74}, {40, 74}, {40, 94}, {34, 94}, {34, 94}}, color = {0, 0, 127}));
  connect(genrou1.EFD0, aVRTypeI1.vf0) annotation(
    Line(points = {{-10, 86}, {-14, 86}, {-14, 70}, {44, 70}, {44, 104}, {26, 104}, {26, 98}, {26, 98}, {26, 98}}, color = {0, 0, 127}));
  connect(bus1.p, genrou1.p) annotation(
    Line(points = {{-26, 92}, {-22, 92}, {-22, 90}, {-10, 90}, {-10, 90}}, color = {0, 0, 255}));
  connect(genrou1.PMECH, genrou1.PMECH0) annotation(
    Line(points = {{8, 92}, {14, 92}, {14, 102}, {-16, 102}, {-16, 92}, {-12, 92}, {-12, 92}, {-10, 92}}, color = {0, 0, 127}));
  connect(genrou1.EFD, aVRTypeI1.vf) annotation(
    Line(points = {{8, 86}, {16, 86}, {16, 88}, {18, 88}, {18, 90}}, color = {0, 0, 127}));
  connect(voltDependant17.p, bus26.p) annotation(
    Line(points = {{82, -32}, {80, -32}, {80, -26}, {82, -26}}, color = {0, 0, 255}));
  connect(voltDependant20.p, bus30.p) annotation(
    Line(points = {{118, -2}, {110, -2}, {110, 0}, {112, 0}}, color = {0, 0, 255}));
  connect(voltDependant19.p, bus29.p) annotation(
    Line(points = {{116, -14}, {110, -14}, {110, -12}, {112, -12}}, color = {0, 0, 255}));
  connect(voltDependant18.p, bus23.p) annotation(
    Line(points = {{68, 4}, {68, 4}, {68, 6}, {66, 6}, {66, 10}, {66, 10}}, color = {0, 0, 255}));
  connect(voltDependant16.p, bus21.p) annotation(
    Line(points = {{46, -10}, {41, -10}, {41, -13}}, color = {0, 0, 255}));
  connect(pwLine18.p, bus21.p) annotation(
    Line(points = {{29.8, -14}, {39.8, -14}, {39.8, -13}, {41, -13}}, color = {0, 0, 255}));
  connect(pwLine36.n, bus21.p) annotation(
    Line(points = {{44, -14}, {41, -14}, {41, -13}}, color = {0, 0, 255}));
  connect(voltDependant15.p, bus20.p) annotation(
    Line(points = {{40, -4}, {36, -4}, {36, 2}, {36, 2}, {36, 2}, {36, 2}}, color = {0, 0, 255}));
  connect(voltDependant14.p, bus19.p) annotation(
    Line(points = {{52, -2}, {48, -2}, {48, 0}, {48, 0}}, color = {0, 0, 255}));
  connect(pwLine12.n, bus19.p) annotation(
    Line(points = {{44, 6.2}, {44, -1}, {47, -1}}, color = {0, 0, 255}));
  connect(pwLine13.p, bus19.p) annotation(
    Line(points = {{41.8, 0}, {44.8, 0}, {44.8, -1}, {47, -1}}, color = {0, 0, 255}));
  connect(bus18.p, voltDependant13.p) annotation(
    Line(points = {{52, 14}, {56, 14}, {56, 14}, {56, 14}}, color = {0, 0, 255}));
  connect(bus17.p, voltDependant12.p) annotation(
    Line(points = {{22, -4}, {26, -4}, {26, -4}, {26, -4}}, color = {0, 0, 255}));
  connect(bus16.p, voltDependant11.p) annotation(
    Line(points = {{28, 24}, {30, 24}, {30, 22}, {32, 22}}, color = {0, 0, 255}));
  connect(bus15.p, voltDependant10.p) annotation(
    Line(points = {{56, 32}, {70, 32}, {70, 32}, {70, 32}}, color = {0, 0, 255}));
  connect(bus14.p, voltDependant9.p) annotation(
    Line(points = {{42, 58}, {48, 58}, {48, 56}, {48, 56}}, color = {0, 0, 255}));
  connect(bus14.p, pwLine10.p) annotation(
    Line(points = {{41, 57}, {37, 57}, {37, 47}, {45, 47}, {45, 45}, {47, 45}}, color = {0, 0, 255}));
  connect(pwLine9.n, bus14.p) annotation(
    Line(points = {{27.5, 35}, {35.5, 35}, {35.5, 55}, {39.5, 55}, {39.5, 57}, {41.5, 57}}, color = {0, 0, 255}));
  connect(voltDependant8.p, bus10.p) annotation(
    Line(points = {{22, -24}, {22, -24}, {22, -16}, {10, -16}, {10, -14}}, color = {0, 0, 255}));
  connect(voltDependant7.p, bus7.p) annotation(
    Line(points = {{-68, -40}, {-68, -40}, {-68, -20}, {-62, -20}, {-62, -18}}, color = {0, 0, 255}));
  connect(voltDependant6.p, bus5.p) annotation(
    Line(points = {{-82, -38}, {-82, -38}, {-82, -24}, {-94, -24}, {-94, -22}}, color = {0, 0, 255}));
  connect(voltDependant5.p, bus5.p) annotation(
    Line(points = {{-88, -38}, {-88, -38}, {-88, -22}, {-94, -22}, {-94, -22}}, color = {0, 0, 255}));
  connect(voltDependant4.p, bus12.p) annotation(
    Line(points = {{-2, 24}, {-2, 24}, {-2, 32}, {4, 32}, {4, 34}}, color = {0, 0, 255}));
  connect(voltDependant3.p, bus4.p) annotation(
    Line(points = {{-18, 20}, {-18, 20}, {-18, 32}, {-24, 32}, {-24, 34}}, color = {0, 0, 255}));
  connect(voltDependant2.p, bus3.p) annotation(
    Line(points = {{-18, 58}, {-18, 58}, {-18, 60}, {-24, 60}, {-24, 64}, {-24, 64}}, color = {0, 0, 255}));
  connect(voltDependant1.p, bus2.p) annotation(
    Line(points = {{-92, 104}, {-92, 104}, {-92, 90}, {-82, 90}, {-82, 92}}, color = {0, 0, 255}));
  connect(pwLine22.p, bus23.p) annotation(
    Line(points = {{62, -2.2}, {64, -2.2}, {64, 9.8}, {66, 9.8}}, color = {0, 0, 255}));
  connect(pwLine21.n, bus23.p) annotation(
    Line(points = {{66, 18.2}, {64, 18.2}, {64, 9.2}, {65, 9.2}}, color = {0, 0, 255}));
  connect(pwLine25.n, bus10.p) annotation(
    Line(points = {{4, -22}, {4, -16}, {10, -16}, {10, -14}}, color = {0, 0, 255}));
  connect(bus10.p, pwLine19.n) annotation(
    Line(points = {{9, -15}, {11, -15}, {11, -18}, {30, -18}}, color = {0, 0, 255}));
  connect(bus10.p, pwLine18.n) annotation(
    Line(points = {{9, -15}, {25, -15}}, color = {0, 0, 255}));
  connect(bus10.p, pwLine16.n) annotation(
    Line(points = {{9, -15}, {13, -15}, {13, -13}, {17, -13}}, color = {0, 0, 255}));
  connect(bus10.p, pwLine15.n) annotation(
    Line(points = {{9, -15}, {15, -15}, {15, -7}, {15, -7}}, color = {0, 0, 255}));
  connect(pwLine25.p, bus9.p) annotation(
    Line(points = {{4, -26}, {-10, -26}, {-10, -28}, {-12, -28}}, color = {0, 0, 255}));
  connect(pwLine28.n, bus30.p) annotation(
    Line(points = {{108, -4}, {108, -2.2}, {111, -2.2}, {111, -1.2}}, color = {0, 0, 255}));
  connect(bus29.p, pwLine28.p) annotation(
    Line(points = {{111, -13}, {108, -13}, {108, -8}}, color = {0, 0, 255}));
  connect(bus25.p, pwLine23.n) annotation(
    Line(points = {{77, -19}, {77, -24}, {66, -24}}, color = {0, 0, 255}));
  connect(bus24.p, pwLine23.p) annotation(
    Line(points = {{71, -13}, {66, -13}, {66, -20}}, color = {0, 0, 255}));
  connect(pwLine13.n, bus20.p) annotation(
    Line(points = {{38.2, 0}, {35.2, 0}, {35.2, 1}}, color = {0, 0, 255}));
  connect(pwLine8.p, bus9.p) annotation(
    Line(points = {{-6, -28}, {-8, -28}, {-8, -30}, {-12, -30}, {-12, -28}, {-12, -28}}, color = {0, 0, 255}));
  connect(pwLine8.n, bus11.p) annotation(
    Line(points = {{-2, -28}, {2, -28}, {2, -34}, {6, -34}, {6, -38}, {8, -38}}, color = {0, 0, 255}));
  connect(pwLine14.n, bus12.p) annotation(
    Line(points = {{-2, 42}, {-2, 42}, {-2, 36}, {2, 36}, {2, 34}, {4, 34}}, color = {0, 0, 255}));
  connect(pwLine14.p, bus13.p) annotation(
    Line(points = {{-2, 46}, {4, 46}, {4, 50}, {6, 50}}, color = {0, 0, 255}));
  connect(aVRTypeI6.vref0, aVRTypeI6.vref) annotation(
    Line(points = {{29, 47.6}, {33, 47.6}, {33, 48.6}}, color = {0, 0, 127}));
  connect(aVRTypeI5.vref0, aVRTypeI5.vref) annotation(
    Line(points = {{32, -60}, {40, -60}, {40, -56}, {40, -56}}, color = {0, 0, 127}));
  connect(aVRTypeI3.vref, aVRTypeI3.vref0) annotation(
    Line(points = {{-116, -56}, {-116, -56}, {-116, -60}, {-122, -60}, {-122, -48}, {-120, -48}}, color = {0, 0, 127}));
  connect(aVRTypeI2.vref0, aVRTypeI2.vref) annotation(
    Line(points = {{-122, 66}, {-124, 66}, {-124, 56}, {-118, 56}, {-118, 58}, {-118, 58}}, color = {0, 0, 127}));
  connect(aVRTypeI1.vref0, aVRTypeI1.vref) annotation(
    Line(points = {{26, 80}, {26, 80}, {26, 78}, {36, 78}, {36, 84}, {34, 84}, {34, 84}}, color = {0, 0, 127}));
  connect(pwLine37.n, bus22.p) annotation(
    Line(points = {{58, -18}, {58, -18}, {58, -20}, {54, -20}, {54, -18}}, color = {0, 0, 255}));
  connect(pwLine37.p, bus24.p) annotation(
    Line(points = {{62, -18}, {66, -18}, {66, -14}, {72, -14}, {72, -12}}, color = {0, 0, 255}));
  connect(pwLine36.p, bus22.p) annotation(
    Line(points = {{48, -14}, {50, -14}, {50, -20}, {52, -20}, {52, -18}, {54, -18}}, color = {0, 0, 255}));
  connect(pwLine19.p, bus22.p) annotation(
    Line(points = {{34, -18}, {53, -18}, {53, -19}}, color = {0, 0, 255}));
  connect(pwLine35.p, bus12.p) annotation(
    Line(points = {{30, 30}, {4, 30}, {4, 34}, {4, 34}}, color = {0, 0, 255}));
  connect(pwLine35.n, bus15.p) annotation(
    Line(points = {{40, 30}, {54, 30}, {54, 32}, {56, 32}}, color = {0, 0, 255}));
  connect(pwLine16.p, bus17.p) annotation(
    Line(points = {{21.8, -12}, {21.8, -6}, {21, -6}, {21, -5}}, color = {0, 0, 255}));
  connect(pwLine17.n, bus17.p) annotation(
    Line(points = {{22, 4.2}, {22, -5.8}, {21, -5.8}, {21, -5}}, color = {0, 0, 255}));
  connect(pwLine2.p, bus1.p) annotation(
    Line(points = {{-31, 79.5}, {-36, 79.5}, {-36, 90}, {-27, 90}, {-27, 91}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus1.p) annotation(
    Line(points = {{-48.5, 93}, {-34.5, 93}, {-34.5, 91}, {-27, 91}}, color = {0, 0, 255}));
  connect(pwLine29.p, bus27.p) annotation(
    Line(points = {{100, -7.8}, {98, -7.8}, {98, -16.8}, {99, -16.8}}, color = {0, 0, 255}));
  connect(pwLine27.n, bus27.p) annotation(
    Line(points = {{102.2, -12}, {99.2, -12}, {99.2, -17}}, color = {0, 0, 255}));
  connect(pwLine26.p, bus27.p) annotation(
    Line(points = {{87.8, -6}, {95.8, -6}, {95.8, -17}, {98.8, -17}}, color = {0, 0, 255}));
  connect(bus25.p, pwLine26.n) annotation(
    Line(points = {{77, -19}, {81, -19}, {81, -7}, {83, -7}, {83, -7}, {83, -7}}, color = {0, 0, 255}));
  connect(pwLine31.n, bus28.p) annotation(
    Line(points = {{102, -50.2}, {98, -50.2}, {98, -35.2}, {99, -35.2}}, color = {0, 0, 255}));
  connect(pwLine30.n, bus28.p) annotation(
    Line(points = {{96, -50.2}, {96, -35.2}, {99, -35.2}}, color = {0, 0, 255}));
  connect(pwLine27.p, bus29.p) annotation(
    Line(points = {{105.8, -12}, {111.8, -12}, {111.8, -12}, {111.8, -12}}, color = {0, 0, 255}));
  connect(pwLine29.n, bus30.p) annotation(
    Line(points = {{100, -4.2}, {100, -2.2}, {111, -2.2}, {111, -1.2}}, color = {0, 0, 255}));
  connect(pwLine30.p, bus6.p) annotation(
    Line(points = {{96, -53.8}, {96, -53.8}, {96, -63.8}, {-38, -63.8}, {-38, -21.8}, {-34, -21.8}, {-34, -19.8}}, color = {0, 0, 255}));
  connect(pwLine31.p, bus8.p) annotation(
    Line(points = {{102, -53.8}, {100, -53.8}, {100, -75.8}, {-50, -75.8}, {-50, -83.8}, {-50, -83.8}}, color = {0, 0, 255}));
  connect(pwLine10.n, bus15.p) annotation(
    Line(points = {{47, 36.5}, {47, 30.5}, {54, 30.5}, {54, 31.5}}, color = {0, 0, 255}));
  connect(bus15.p, pwLine21.p) annotation(
    Line(points = {{55, 31}, {65, 31}, {65, 21}, {65, 21}}, color = {0, 0, 255}));
  connect(pwLine11.p, bus15.p) annotation(
    Line(points = {{44, 25.8}, {44, 30.8}, {55, 30.8}}, color = {0, 0, 255}));
  connect(pwLine12.p, bus18.p) annotation(
    Line(points = {{44, 9.8}, {50, 9.8}, {50, 12.8}, {51, 12.8}}, color = {0, 0, 255}));
  connect(pwLine11.n, bus18.p) annotation(
    Line(points = {{44, 22.2}, {44, 13.2}, {51, 13.2}}, color = {0, 0, 255}));
  connect(pwLine22.n, bus24.p) annotation(
    Line(points = {{62, -5.8}, {62, -5.8}, {62, -11.8}, {72, -11.8}, {72, -11.8}}, color = {0, 0, 255}));
  connect(bus24.p, pwCapacitorBank2.p) annotation(
    Line(points = {{71, -13}, {77, -13}, {77, -4}}, color = {0, 0, 255}));
  connect(pwLine24.p, bus25.p) annotation(
    Line(points = {{78, -20.2}, {76, -20.2}, {76, -18.2}, {78, -18.2}}, color = {0, 0, 255}));
  connect(pwLine24.n, bus26.p) annotation(
    Line(points = {{78, -23.8}, {80, -23.8}, {80, -26.8}, {81, -26.8}}, color = {0, 0, 255}));
  connect(pwLine9.p, bus12.p) annotation(
    Line(points = {{18.5, 35}, {4.5, 35}, {4.5, 33}, {4.5, 33}}, color = {0, 0, 255}));
  connect(pwLine20.n, bus16.p) annotation(
    Line(points = {{19.5, 27}, {23.5, 27}, {23.5, 23}, {27.5, 23}, {27.5, 23}}, color = {0, 0, 255}));
  connect(pwLine17.p, bus16.p) annotation(
    Line(points = {{22, 7.8}, {26, 7.8}, {26, 23.8}, {28, 23.8}}, color = {0, 0, 255}));
  connect(pwLine15.p, bus20.p) annotation(
    Line(points = {{16, -2.2}, {16, -0.2}, {35, -0.2}, {35, 0.8}}, color = {0, 0, 255}));
  connect(pwLine20.p, bus12.p) annotation(
    Line(points = {{10.5, 27}, {8.5, 27}, {8.5, 31}, {4.5, 31}, {4.5, 33}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.p) annotation(
    Line(points = {{-25, 63}, {-25, 63}, {-25, 53}, {-43, 53}, {-43, 47}, {-41, 47}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus3.p) annotation(
    Line(points = {{-31, 70.5}, {-33, 70.5}, {-33, 68.5}, {-25, 68.5}, {-25, 64.5}, {-25, 64.5}}, color = {0, 0, 255}));
  connect(pwLine34.p, bus4.p) annotation(
    Line(points = {{-43, 25.5}, {-43, 25.5}, {-43, 31.5}, {-25, 31.5}, {-25, 33.5}}, color = {0, 0, 255}));
  connect(pwLine33.n, bus4.p) annotation(
    Line(points = {{-63, 56.5}, {-63, 56.5}, {-63, 32.5}, {-25, 32.5}, {-25, 34.5}}, color = {0, 0, 255}));
  connect(pwLine3.n, bus4.p) annotation(
    Line(points = {{-41, 38.5}, {-41, 38.5}, {-41, 32.5}, {-25, 32.5}, {-25, 34.5}}, color = {0, 0, 255}));
  connect(pwLine34.n, bus6.p) annotation(
    Line(points = {{-43, 16.5}, {-45, 16.5}, {-45, -21.5}, {-35, -21.5}, {-35, -19.5}}, color = {0, 0, 255}));
  connect(pwLine32.n, bus6.p) annotation(
    Line(points = {{-75, 56.5}, {-67, 56.5}, {-67, -1.5}, {-41, -1.5}, {-41, -19.5}, {-35, -19.5}, {-35, -19.5}}, color = {0, 0, 255}));
  connect(pwLine6.p, bus6.p) annotation(
    Line(points = {{-46.5, -21}, {-40.5, -21}, {-40.5, -23}, {-35.5, -23}, {-35.5, -22}}, color = {0, 0, 255}));
  connect(pwLine1.p, bus2.p) annotation(
    Line(points = {{-57.5, 93}, {-75.5, 93}, {-75.5, 90}, {-81.5, 90}, {-81.5, 92}}, color = {0, 0, 255}));
  connect(pwLine32.p, bus2.p) annotation(
    Line(points = {{-75, 65.5}, {-77, 65.5}, {-77, 91.5}, {-83, 91.5}, {-83, 91.5}}, color = {0, 0, 255}));
  connect(bus2.p, pwLine33.p) annotation(
    Line(points = {{-83, 91}, {-65, 91}, {-65, 65}, {-63, 65}}, color = {0, 0, 255}));
  connect(pwLine4.p, bus2.p) annotation(
    Line(points = {{-85, 43.5}, {-95, 43.5}, {-95, 89.5}, {-83, 89.5}, {-83, 91.5}, {-83, 91.5}}, color = {0, 0, 255}));
  connect(pwLine6.n, bus7.p) annotation(
    Line(points = {{-55.5, -21}, {-61.5, -21}, {-61.5, -19}, {-61.5, -19}}, color = {0, 0, 255}));
  connect(pwLine5.p, bus7.p) annotation(
    Line(points = {{-70.5, -23}, {-68.5, -23}, {-68.5, -21}, {-64.5, -21}, {-64.5, -19}, {-62.5, -19}}, color = {0, 0, 255}));
  connect(pwLine4.n, bus5.p) annotation(
    Line(points = {{-85, 34.5}, {-87, 34.5}, {-87, -21.5}, {-95, -21.5}, {-95, -21.5}}, color = {0, 0, 255}));
  connect(bus5.p, pwLine5.n) annotation(
    Line(points = {{-95, -23}, {-81, -23}, {-81, -23}, {-81, -23}}, color = {0, 0, 255}));
  annotation(
    uses(OpenIPSL(version = "1.5.0"), Modelica(version = "3.2.3")),
    Diagram(coordinateSystem(extent = {{-125, -120}, {125, 120}})),
    Icon(coordinateSystem(extent = {{-125, -120}, {125, 120}})),
    version = "",
    __OpenModelica_commandLineOptions = "");end ieee30bus;
