﻿package IslandedOperationControl
  class Copyright "Disclaimer<html>
  <p>The package 'IslandedOperationControl.mo' is a copy of the modified package 'Modelica2018US_paper_15.mo', that includes the models presented in the conference paper 'Modeling of PMU-Based Islanded Operation Controls for 
  Power Distribution Networks using Modelica and OpenIPSL' at American Modelica Conference 2018. </p>
<p>Copyright July 2018 - Biswarup Mukherjee, IIT Bombay, India & Prof. Luigi Vanfretti, Rensselaer Polytechnic Institute, Troy, NY.</p>

<p>&nbsp;</p>
<p>OpenIPSL:</p>
<p>Copyright August 2017 - Prof. Luigi Vanfretti, Rensselaer Polytechnic Institute, Troy, NY.</p>
<p>Copyright April 2016 - July 2017 SmarTS Lab (Sweden)</p>
<ul>
<li>SmarTS Lab, research group at KTH: <a href=\"https://www.kth.se/en\">https://www.kth.se/en</a></li>
</ul>
<p>The authors can be contacted by email: <a href=\"mailto:luigi.vanfretti@gmail.com\">luigi.vanfretti@gmail.com</a></p>
<p>This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. </p>
<p>If a copy of the MPL was not distributed with this file, You can obtain one at <a href=\"http://mozilla.org/MPL/2.0/\"> http://mozilla.org/MPL/2.0</a>.</p>
<p>&nbsp;</p>
<p>iPSL:</p>
<p>Copyright 2015-2016 RTE (France), SmarTS Lab (Sweden), AIA (Spain) and DTU (Denmark)</p>
<ul>
<li>RTE: <a href=\"http://www.rte-france.com\">http://www.rte-france.com</a></li>
<li>SmarTS Lab, research group at KTH: <a href=\"https://www.kth.se/en\">https://www.kth.se/en</a></li>
<li>AIA: <a href=\"http://www.aia.es/en/energy\"> http://www.aia.es/en/energy</a></li>
<li>DTU: <a href=\"http://www.dtu.dk/english\"> http://www.dtu.dk/english</a></li>
</ul>
<p>The authors can be contacted by email: <a href=\"mailto:info@itesla-ipsl.org\">info@itesla-ipsl.org</a></p>

<p>This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. </p>
<p>If a copy of the MPL was not distributed with this file, You can obtain one at <a href=\"http://mozilla.org/MPL/2.0/\"> http://mozilla.org/MPL/2.0</a>.</p>
</html>"

    annotation (
      preferredView="info",
      DocumentationClass=false,
      Icon(graphics={
          Text(
            extent={{-100,140},{100,100}},
            lineColor={0,127,0},
            textString="%name%"),
          Ellipse(
            extent={{-100,100},{100,-100}},
            lineColor={0,127,0},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-60,60},{60,-60}},
            lineColor={0,127,72},
            fillColor={0,127,0},
            fillPattern=FillPattern.Solid),
          Ellipse(
            extent={{-40,40},{40,-40}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid),
          Rectangle(
            extent={{28,22},{64,-20}},
            lineColor={255,255,255},
            fillColor={255,255,255},
            fillPattern=FillPattern.Solid)}),
      Documentation(info="<html>
</html>"));
  end Copyright;

  package Network
    model Network_DL
      extends Modelica.Icons.Example;
      OpenIPSL.Electrical.Buses.Bus B1(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V1, angle_0 = network_10_0_MW_voltages_WL.A1) annotation (
        Placement(transformation(extent = {{-90, 30}, {-70, 50}})));
      OpenIPSL.Electrical.Buses.Bus B2(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V2, angle_0 = network_10_0_MW_voltages_WL.A2) annotation (
        Placement(transformation(extent = {{-50, 30}, {-30, 50}})));
      OpenIPSL.Electrical.Branches.PSSE.TwoWindingTransformer T1(R = 0.001, X = 0.2, G = 0, B = 0, VNOM1 = 220, VB1 = 220, VNOM2 = 24, VB2 = 24) annotation (
        Placement(transformation(extent = {{-6, -4}, {6, 4}}, rotation = 180, origin = {-60, 40})));
      Generators.G1 G1(V_b = 24, V_0 = network_10_0_MW_voltages_WL.V1, angle_0 = network_10_0_MW_voltages_WL.A1, P_0 = network_10_0_MW_machines_WL.P1_1, Q_0 = network_10_0_MW_machines_WL.Q1_1) annotation (
        Placement(transformation(extent = {{-110, 30}, {-90, 50}})));
      OpenIPSL.Electrical.Branches.PwLine L1(G = 0, B = 0, R = 0.001, X = 0.2, displayPF = false) annotation (
        Placement(transformation(extent = {{-30, 36}, {-18, 44}})));
      OpenIPSL.Electrical.Buses.Bus B3(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V3, angle_0 = network_10_0_MW_voltages_WL.A3) annotation (
        Placement(transformation(extent = {{-12, 30}, {8, 50}})));
      OpenIPSL.Electrical.Buses.Bus B4(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V4, angle_0 = network_10_0_MW_voltages_WL.A4) annotation (
        Placement(transformation(extent = {{54, 30}, {74, 50}})));
      OpenIPSL.Electrical.Branches.PwLine L2_1(G = 0, B = 0, R = 0.0005, X = 0.1, displayPF = false) annotation (
        Placement(transformation(extent = {{24, 56}, {36, 64}})));
      OpenIPSL.Electrical.Branches.PwLine L2_2(G = 0, B = 0, R = 0.0005, X = 0.1, displayPF = false) annotation (
        Placement(transformation(extent = {{24, 16}, {36, 24}})));
      OpenIPSL.Electrical.Buses.Bus B6(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V6, angle_0 = network_10_0_MW_voltages_WL.A6) annotation (
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {80, -24})));
      OpenIPSL.Electrical.Branches.PwLine L3(X = 0.2, G = 0, B = 0, R = 0.01, displayPF = false) annotation (
        Placement(transformation(extent = {{-7.99999, -5.00005}, {7.99999, 5}}, rotation = -90, origin = {81, 9.99999})));
      OpenIPSL.Electrical.Buses.Bus B7(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V7, angle_0 = network_10_0_MW_voltages_WL.A7) annotation (
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {60, -60})));
      OpenIPSL.Electrical.Branches.PSSE.TwoWindingTransformer T2(G = 0, B = 0, VNOM1 = 220, VB1 = 220, VNOM2 = 24, VB2 = 24, R = 0.005, X = 0.1) annotation (
        Placement(transformation(extent = {{-6, -4}, {6, 4}}, rotation = 270, origin = {60, -40})));
      inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation (
        Placement(transformation(extent = {{-140, 100}, {-80, 120}})));
      OpenIPSL.Electrical.Loads.PSSE.Load LD1(V_b = 220, V_0 = network_10_0_MW_voltages_WL.V3, angle_0 = network_10_0_MW_voltages_WL.A3, P_0 = network_10_0_MW_loads_WL.PL3_1, Q_0 = network_10_0_MW_loads_WL.QL3_1) annotation (
        Placement(transformation(extent = {{-16, -14}, {-4, -2}})));
      Essentials.Breaker breaker1 annotation (
        Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 90, origin = {80, -16})));
    public
      OpenIPSL.Electrical.Branches.PwLine L2(G = 0, B = 0, R = 0.05, X = 0.5, displayPF = false) annotation (
        Placement(transformation(extent = {{-8.00001, -5.00001}, {8, 5.00001}}, rotation = 0, origin = {96, 41})));
      Essentials.Breaker breaker2 annotation (
        Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 90, origin = {80, 28})));
      OpenIPSL.Electrical.Buses.Bus B8(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V8, angle_0 = network_10_0_MW_voltages_WL.A8) annotation (
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {100, -58})));
      OpenIPSL.Electrical.Branches.PwLine L4(G = 0, B = 0, R = 0.05, X = 0.5) annotation (
        Placement(transformation(extent = {{-6, -4}, {6, 4}}, rotation = -90, origin = {100, -42})));
      OpenIPSL.Electrical.Buses.Bus B5(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V5, angle_0 = network_10_0_MW_voltages_WL.A5) annotation (
        Placement(transformation(extent = {{110, 30}, {130, 50}})));
      OpenIPSL.Electrical.Loads.PSSE.Load load(V_b = 220, V_0 = network_10_0_MW_voltages_WL.V5, angle_0 = network_10_0_MW_voltages_WL.A5, P_0 = network_10_0_MW_loads_WL.PL5_1, Q_0 = network_10_0_MW_loads_WL.QL5_1) annotation (
        Placement(transformation(extent = {{122, -2}, {132, 8}})));
      Generators.G22 g22_IslandedControl(V_0 = network_10_0_MW_voltages_WL.V7, angle_0 = network_10_0_MW_voltages_WL.A7, P_0 = network_10_0_MW_machines_WL.P7_1, Q_0 = network_10_0_MW_machines_WL.Q7_1) annotation (
        Placement(transformation(extent = {{28, -92}, {52, -70}})));
      OpenIPSL.Electrical.Loads.PSSE.Load LD2(V_b = 220, V_0 = network_10_0_MW_voltages_WL.V8, angle_0 = network_10_0_MW_voltages_WL.A8, P_0 = network_10_0_MW_loads_WL.PL8_1, Q_0 = network_10_0_MW_loads_WL.QL8_1) annotation (
        Placement(transformation(extent = {{94, -100}, {106, -88}})));
      Essentials.Event_Islanding event_Islanding(f_DN(u = B6.p.vi, u1 = B6.p.vr)) annotation (
        Placement(transformation(extent = {{-4, -50}, {22, -28}})));
      PowerFlowData.case10_0MW.Network_10_0_MW_loads_WL network_10_0_MW_loads_WL annotation (
        Placement(transformation(extent = {{-72, 92}, {-52, 112}})));
      PowerFlowData.case10_0MW.Network_10_0_MW_machines_WL network_10_0_MW_machines_WL annotation (
        Placement(transformation(extent = {{-38, 92}, {-18, 112}})));
      PowerFlowData.case10_0MW.Network_10_0_MW_voltages_WL network_10_0_MW_voltages_WL annotation (
        Placement(transformation(extent = {{-4, 92}, {16, 112}})));
    equation
      connect(T1.p, B2.p) annotation (
        Line(points = {{-53, 40}, {-40, 40}}, color = {0, 0, 255}));
      connect(B1.p, T1.n) annotation (
        Line(points = {{-80, 40}, {-67, 40}}, color = {0, 0, 255}));
      connect(G1.conn, B1.p) annotation (
        Line(points = {{-89, 40}, {-89, 40}, {-80, 40}}, color = {0, 0, 255}));
      connect(L1.n, B3.p) annotation (
        Line(points = {{-18.6, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(L1.p, B2.p) annotation (
        Line(points = {{-29.4, 40}, {-40, 40}}, color = {0, 0, 255}));
      connect(L2_2.n, B4.p) annotation (
        Line(points = {{35.4, 20}, {56, 20}, {56, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(L2_1.n, B4.p) annotation (
        Line(points = {{35.4, 60}, {56, 60}, {56, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(L2_1.p, B3.p) annotation (
        Line(points = {{24.6, 60}, {24.6, 60}, {4, 60}, {4, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(L2_2.p, B3.p) annotation (
        Line(points = {{24.6, 20}, {4, 20}, {4, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(T2.p, B6.p) annotation (
        Line(points = {{60, -33}, {60, -28}, {80, -28}, {80, -24}}, color = {0, 0, 255}));
      connect(T2.n, B7.p) annotation (
        Line(points = {{60, -47}, {60, -60}}, color = {0, 0, 255}));
      connect(LD1.p, B3.p) annotation (
        Line(points = {{-10, -2}, {-10, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(B6.p, breaker1.p) annotation (
        Line(points = {{80, -24}, {80, -20.5}}, color = {0, 0, 255}));
      connect(L2.p, B4.p) annotation (
        Line(points = {{88.8, 41}, {88.8, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(breaker2.n, B4.p) annotation (
        Line(points = {{80, 32.5}, {80, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(L3.p, breaker2.p) annotation (
        Line(points={{81,17.2},{80,17.2},{80,23.5}},        color = {0, 0, 255}));
      connect(breaker1.n, L3.n) annotation (
        Line(points={{80,-11.5},{80,2.8},{81,2.8}},        color = {0, 0, 255}));
      connect(L4.p, B6.p) annotation (
        Line(points = {{100, -36.6}, {100, -28}, {80, -28}, {80, -24}}, color = {0, 0, 255}));
      connect(B5.p, L2.n) annotation (
        Line(points = {{120, 40}, {112, 40}, {112, 41}, {103.2, 41}}, color = {0, 0, 255}));
      connect(L4.n, B8.p) annotation (
        Line(points = {{100, -47.4}, {100, -47.4}, {100, -58}}, color = {0, 0, 255}));
      connect(B5.p, load.p) annotation (
        Line(points = {{120, 40}, {128, 40}, {128, 8}, {127, 8}}, color = {0, 0, 255}));
      connect(g22_IslandedControl.conn, B7.p) annotation (
        Line(points = {{53.2, -81}, {53.2, -82.27}, {60, -82.27}, {60, -60}}, color = {0, 0, 255}));
      connect(B8.p, LD2.p) annotation (
        Line(points = {{100, -58}, {100, -58}, {100, -88}}, color = {0, 0, 255}));
      connect(event_Islanding.startIslanding, g22_IslandedControl.start_islanding) annotation (
        Line(points = {{9, -50.6}, {9, -98}, {39.76, -98}, {39.76, -92.44}}, color = {255, 0, 255}));
      connect(event_Islanding.y1, g22_IslandedControl.f_DN) annotation (
        Line(points = {{20.4, -41.8}, {26, -41.8}, {26, -74.18}, {28, -74.18}}, color = {0, 0, 127}));
      connect(event_Islanding.Trip_Breaker_To_Island, breaker1.TRIGGER) annotation (
        Line(points = {{20.2, -35.6}, {26, -35.6}, {26, -16}, {75.5, -16}}, color = {255, 0, 255}));
      connect(event_Islanding.y, breaker2.TRIGGER) annotation (
        Line(points = {{8.8, -27.6}, {8.8, -6}, {72, -6}, {72, 28}, {75.5, 28}}, color = {255, 0, 255}));
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-140, -120}, {140, 120}})),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-140, -120}, {140, 120}})),
        experiment(StopTime = 70, Interval = 0.02, __Dymola_fixedstepsize = 0.02, __Dymola_Algorithm = "Rkfix4"),
        __Dymola_experimentFlags(Advanced(GenerateVariableDependencies = false, OutputModelicaCode = false), Evaluate = true, OutputCPUtime = false, OutputFlatModelica = false));
    end Network_DL;

    model Network_CD "islanded operation controller disabled"
      extends Modelica.Icons.Example;
      OpenIPSL.Electrical.Buses.Bus B1(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V1, angle_0 = network_10_0_MW_voltages_WL.A1) annotation (
        Placement(transformation(extent = {{-90, 30}, {-70, 50}})));
      OpenIPSL.Electrical.Buses.Bus B2(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V2, angle_0 = network_10_0_MW_voltages_WL.A2) annotation (
        Placement(transformation(extent = {{-50, 30}, {-30, 50}})));
      OpenIPSL.Electrical.Branches.PSSE.TwoWindingTransformer T1(R = 0.001, X = 0.2, G = 0, B = 0, VNOM1 = 220, VB1 = 220, VNOM2 = 24, VB2 = 24) annotation (
        Placement(transformation(extent = {{-6, -4}, {6, 4}}, rotation = 180, origin = {-60, 40})));
      Generators.G1 G1(V_b = 24, V_0 = network_10_0_MW_voltages_WL.V1, angle_0 = network_10_0_MW_voltages_WL.A1, P_0 = network_10_0_MW_machines_WL.P1_1, Q_0 = network_10_0_MW_machines_WL.Q1_1) annotation (
        Placement(transformation(extent = {{-110, 30}, {-90, 50}})));
      OpenIPSL.Electrical.Branches.PwLine L1(G = 0, B = 0, R = 0.001, X = 0.2, displayPF = false) annotation (
        Placement(transformation(extent = {{-30, 36}, {-18, 44}})));
      OpenIPSL.Electrical.Buses.Bus B3(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V3, angle_0 = network_10_0_MW_voltages_WL.A3) annotation (
        Placement(transformation(extent = {{-12, 30}, {8, 50}})));
      OpenIPSL.Electrical.Buses.Bus B4(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V4, angle_0 = network_10_0_MW_voltages_WL.A4) annotation (
        Placement(transformation(extent = {{54, 30}, {74, 50}})));
      OpenIPSL.Electrical.Branches.PwLine L2_1(G = 0, B = 0, R = 0.0005, X = 0.1, displayPF = false) annotation (
        Placement(transformation(extent = {{24, 56}, {36, 64}})));
      OpenIPSL.Electrical.Branches.PwLine L2_2(G = 0, B = 0, R = 0.0005, X = 0.1, displayPF = false) annotation (
        Placement(transformation(extent = {{24, 16}, {36, 24}})));
      OpenIPSL.Electrical.Buses.Bus B6(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V6, angle_0 = network_10_0_MW_voltages_WL.A6) annotation (
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {80, -24})));
      OpenIPSL.Electrical.Branches.PwLine L3(X = 0.2, G = 0, B = 0, R = 0.01, displayPF = false) annotation (
        Placement(transformation(extent = {{-7.99999, -5.00005}, {7.99999, 5}}, rotation = -90, origin = {81, 9.99999})));
      OpenIPSL.Electrical.Buses.Bus B7(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V7, angle_0 = network_10_0_MW_voltages_WL.A7) annotation (
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {60, -60})));
      OpenIPSL.Electrical.Branches.PSSE.TwoWindingTransformer T2(G = 0, B = 0, VNOM1 = 220, VB1 = 220, VNOM2 = 24, VB2 = 24, R = 0.005, X = 0.1) annotation (
        Placement(transformation(extent = {{-6, -4}, {6, 4}}, rotation = 270, origin = {60, -40})));
      inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation (
        Placement(transformation(extent = {{-140, 100}, {-80, 120}})));
      OpenIPSL.Electrical.Loads.PSSE.Load LD1(V_b = 220, V_0 = network_10_0_MW_voltages_WL.V3, angle_0 = network_10_0_MW_voltages_WL.A3, P_0 = network_10_0_MW_loads_WL.PL3_1, Q_0 = network_10_0_MW_loads_WL.QL3_1) annotation (
        Placement(transformation(extent = {{-16, -14}, {-4, -2}})));
      Essentials.Breaker breaker1 annotation (
        Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 90, origin = {80, -16})));
    public
      OpenIPSL.Electrical.Branches.PwLine L2(G = 0, B = 0, R = 0.05, X = 0.5, displayPF = false) annotation (
        Placement(transformation(extent = {{-8.00001, -5.00001}, {8, 5.00001}}, rotation = 0, origin = {96, 41})));
      Essentials.Breaker breaker2 annotation (
        Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 90, origin = {80, 28})));
      OpenIPSL.Electrical.Buses.Bus B8(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V8, angle_0 = network_10_0_MW_voltages_WL.A8) annotation (
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {100, -58})));
      OpenIPSL.Electrical.Branches.PwLine L4(G = 0, B = 0, R = 0.05, X = 0.5) annotation (
        Placement(transformation(extent = {{-6, -4}, {6, 4}}, rotation = -90, origin = {100, -42})));
      OpenIPSL.Electrical.Buses.Bus B5(displayPF = false, V_0 = network_10_0_MW_voltages_WL.V5, angle_0 = network_10_0_MW_voltages_WL.A5) annotation (
        Placement(transformation(extent = {{110, 30}, {130, 50}})));
      OpenIPSL.Electrical.Loads.PSSE.Load load(V_b = 220, V_0 = network_10_0_MW_voltages_WL.V5, angle_0 = network_10_0_MW_voltages_WL.A5, P_0 = network_10_0_MW_loads_WL.PL5_1, Q_0 = network_10_0_MW_loads_WL.QL5_1) annotation (
        Placement(transformation(extent = {{122, -2}, {132, 8}})));
      Generators.G22_CD g22_IslandedControl(V_0 = network_10_0_MW_voltages_WL.V7, angle_0 = network_10_0_MW_voltages_WL.A7, P_0 = network_10_0_MW_machines_WL.P7_1, Q_0 = network_10_0_MW_machines_WL.Q7_1) annotation (
        Placement(transformation(extent = {{28, -92}, {52, -70}})));
      OpenIPSL.Electrical.Loads.PSSE.Load LD2(V_b = 220, V_0 = network_10_0_MW_voltages_WL.V8, angle_0 = network_10_0_MW_voltages_WL.A8, P_0 = network_10_0_MW_loads_WL.PL8_1, Q_0 = network_10_0_MW_loads_WL.QL8_1) annotation (
        Placement(transformation(extent = {{94, -100}, {106, -88}})));
      Essentials.Event_Islanding event_Islanding(f_DN(u = B6.p.vi, u1 = B6.p.vr)) annotation (
        Placement(transformation(extent = {{-4, -50}, {22, -28}})));
      PowerFlowData.case10_0MW.Network_10_0_MW_loads_WL network_10_0_MW_loads_WL annotation (
        Placement(transformation(extent = {{-72, 92}, {-52, 112}})));
      PowerFlowData.case10_0MW.Network_10_0_MW_machines_WL network_10_0_MW_machines_WL annotation (
        Placement(transformation(extent = {{-38, 92}, {-18, 112}})));
      PowerFlowData.case10_0MW.Network_10_0_MW_voltages_WL network_10_0_MW_voltages_WL annotation (
        Placement(transformation(extent = {{-4, 92}, {16, 112}})));
    equation
      connect(T1.p, B2.p) annotation (
        Line(points = {{-53, 40}, {-40, 40}}, color = {0, 0, 255}));
      connect(B1.p, T1.n) annotation (
        Line(points = {{-80, 40}, {-67, 40}}, color = {0, 0, 255}));
      connect(G1.conn, B1.p) annotation (
        Line(points = {{-89, 40}, {-89, 40}, {-80, 40}}, color = {0, 0, 255}));
      connect(L1.n, B3.p) annotation (
        Line(points = {{-18.6, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(L1.p, B2.p) annotation (
        Line(points = {{-29.4, 40}, {-40, 40}}, color = {0, 0, 255}));
      connect(L2_2.n, B4.p) annotation (
        Line(points = {{35.4, 20}, {56, 20}, {56, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(L2_1.n, B4.p) annotation (
        Line(points = {{35.4, 60}, {56, 60}, {56, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(L2_1.p, B3.p) annotation (
        Line(points = {{24.6, 60}, {24.6, 60}, {4, 60}, {4, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(L2_2.p, B3.p) annotation (
        Line(points = {{24.6, 20}, {4, 20}, {4, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(T2.p, B6.p) annotation (
        Line(points = {{60, -33}, {60, -28}, {80, -28}, {80, -24}}, color = {0, 0, 255}));
      connect(T2.n, B7.p) annotation (
        Line(points = {{60, -47}, {60, -60}}, color = {0, 0, 255}));
      connect(LD1.p, B3.p) annotation (
        Line(points = {{-10, -2}, {-10, 40}, {-2, 40}}, color = {0, 0, 255}));
      connect(B6.p, breaker1.p) annotation (
        Line(points = {{80, -24}, {80, -20.5}}, color = {0, 0, 255}));
      connect(L2.p, B4.p) annotation (
        Line(points = {{88.8, 41}, {88.8, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(breaker2.n, B4.p) annotation (
        Line(points = {{80, 32.5}, {80, 40}, {64, 40}}, color = {0, 0, 255}));
      connect(L3.p, breaker2.p) annotation (
        Line(points = {{81, 17.2}, {80, 17.2}, {80, 23.5}}, color = {0, 0, 255}));
      connect(breaker1.n, L3.n) annotation (
        Line(points = {{80, -11.5}, {80, 2.8}, {81, 2.8}}, color = {0, 0, 255}));
      connect(L4.p, B6.p) annotation (
        Line(points = {{100, -36.6}, {100, -28}, {80, -28}, {80, -24}}, color = {0, 0, 255}));
      connect(B5.p, L2.n) annotation (
        Line(points = {{120, 40}, {112, 40}, {112, 41}, {103.2, 41}}, color = {0, 0, 255}));
      connect(L4.n, B8.p) annotation (
        Line(points = {{100, -47.4}, {100, -47.4}, {100, -58}}, color = {0, 0, 255}));
      connect(B5.p, load.p) annotation (
        Line(points = {{120, 40}, {128, 40}, {128, 8}, {127, 8}}, color = {0, 0, 255}));
      connect(g22_IslandedControl.conn, B7.p) annotation (
        Line(points = {{53.2, -81}, {53.2, -82.27}, {60, -82.27}, {60, -60}}, color = {0, 0, 255}));
      connect(B8.p, LD2.p) annotation (
        Line(points = {{100, -58}, {100, -58}, {100, -88}}, color = {0, 0, 255}));
      connect(event_Islanding.startIslanding, g22_IslandedControl.start_islanding) annotation (
        Line(points = {{9, -50.6}, {9, -98}, {39.76, -98}, {39.76, -92.44}}, color = {255, 0, 255}));
      connect(event_Islanding.y1, g22_IslandedControl.f_DN) annotation (
        Line(points = {{20.4, -41.8}, {26, -41.8}, {26, -74.18}, {28, -74.18}}, color = {0, 0, 127}));
      connect(event_Islanding.Trip_Breaker_To_Island, breaker1.TRIGGER) annotation (
        Line(points = {{20.2, -35.6}, {26, -35.6}, {26, -16}, {75.5, -16}}, color = {255, 0, 255}));
      connect(event_Islanding.y, breaker2.TRIGGER) annotation (
        Line(points = {{8.8, -27.6}, {8.8, -6}, {72, -6}, {72, 28}, {75.5, 28}}, color = {255, 0, 255}));
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-140, -120}, {140, 120}})),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-140, -120}, {140, 120}})),
        experiment(StopTime = 70, Interval = 0.02, __Dymola_fixedstepsize = 0.02, __Dymola_Algorithm = "Rkfix4"),
        __Dymola_experimentFlags(Advanced(GenerateVariableDependencies = false, OutputModelicaCode = false), Evaluate = true, OutputCPUtime = false, OutputFlatModelica = false));
    end Network_CD;
  end Network;

  package Essentials
    model Event_Islanding
      parameter Real L1 = 0.5 "frequency upper limit";
      parameter Real L2 = -3 "frequency lower limit";
      parameter Real dt = 2 "time interval";
      Modelica.Blocks.Sources.BooleanConstant booleanConstant(k = true) annotation (
        Placement(transformation(extent = {{-64, 18}, {-44, 38}})));
      FrequencyCalculationBlock f_DN annotation (
        Placement(transformation(extent = {{-64, -54}, {-42, -32}})));
      Modelica.Blocks.Interfaces.BooleanOutput y annotation (
        Placement(transformation(rotation = 0, extent = {{-14, -12}, {14, 12}}, origin = {14, 34}), iconTransformation(extent = {{-14, -12}, {14, 12}}, rotation = 90, origin = {8, 104})));
      Modelica.Blocks.Interfaces.RealOutput y1 annotation (
        Placement(transformation(rotation = 0, extent = {{110, -50}, {138, -26}}), iconTransformation(extent = {{110, -50}, {138, -26}})));
      Modelica.Blocks.Interfaces.BooleanOutput startIslanding annotation (
        Placement(transformation(rotation = 180, extent = {{14, -12}, {-14, 12}}, origin = {14, -80}), iconTransformation(extent = {{-14, -12}, {14, 12}}, rotation = 270, origin = {10, -126})));
      Modelica.Blocks.Interfaces.BooleanOutput Trip_Breaker_To_Island annotation (
        Placement(transformation(rotation = 0, extent = {{108, 12}, {136, 36}}), iconTransformation(extent = {{108, 12}, {136, 36}})));
      Modelica.Blocks.Sources.BooleanStep booleanStep(startTime = 6.01, startValue = true) annotation (
        Placement(transformation(extent = {{-64, -18}, {-42, 4}})));
      Modelica.Blocks.Sources.BooleanStep booleanStep1(startTime = 7) annotation (
        Placement(transformation(extent = {{-62, -94}, {-40, -72}})));
    equation
      connect(f_DN.y, y1) annotation (
        Line(points = {{-40.9, -43.44}, {-21.45, -43.44}, {-21.45, -38}, {124, -38}}, color = {0, 0, 127}));
      connect(booleanConstant.y, y) annotation (
        Line(points = {{-43, 28}, {-28, 28}, {-28, 34}, {14, 34}}, color = {255, 0, 255}));
      connect(booleanStep1.y, startIslanding) annotation (
        Line(points = {{-38.9, -83}, {-19.45, -83}, {-19.45, -80}, {14, -80}}, color = {255, 0, 255}));
      connect(booleanStep.y, Trip_Breaker_To_Island) annotation (
        Line(points = {{-40.9, -7}, {26, -7}, {26, 24}, {122, 24}}, color = {255, 0, 255}));
      annotation (
        Diagram(coordinateSystem(extent = {{-120, -120}, {140, 100}})),
        Icon(coordinateSystem(extent = {{-120, -120}, {140, 100}}), graphics={  Ellipse(extent = {{-106, 100}, {124, -120}}, lineColor = {28, 108, 200}, fillColor = {85, 170, 255},
                fillPattern =                                                                                                                                                                      FillPattern.Solid)}));
    end Event_Islanding;

    model FrequencyCalculationBlock "frequency calculation for the DN"
      Modelica.Blocks.Interfaces.RealInput u annotation (
        Placement(transformation(extent = {{-120, 34}, {-80, 74}})));
      Modelica.Blocks.Interfaces.RealOutput y "O/P is in rad/sec" annotation (
        Placement(transformation(extent = {{100, -14}, {120, 6}})));
      Modelica.Blocks.Continuous.Derivative derivative annotation (
        Placement(transformation(extent = {{-56, 34}, {-36, 54}})));
      Modelica.Blocks.Math.Product product annotation (
        Placement(transformation(extent = {{-12, 16}, {10, 36}})));
      Modelica.Blocks.Math.Add add(k2 = -1) annotation (
        Placement(transformation(extent = {{30, 0}, {50, 20}})));
      Modelica.Blocks.Math.Division division annotation (
        Placement(transformation(extent = {{70, -14}, {90, 6}})));
      Modelica.Blocks.Interfaces.RealInput u1 annotation (
        Placement(transformation(extent = {{-120, -92}, {-80, -52}})));
      Modelica.Blocks.Math.Product product1 annotation (
        Placement(transformation(extent = {{-12, -10}, {10, 10}})));
      Modelica.Blocks.Math.Product product2 annotation (
        Placement(transformation(extent = {{-10, -88}, {12, -68}})));
      Modelica.Blocks.Math.Product product3 annotation (
        Placement(transformation(extent = {{-10, -54}, {12, -34}})));
      Modelica.Blocks.Math.Add add1(k1 = +1, k2 = +1) annotation (
        Placement(transformation(extent = {{30, -26}, {50, -6}})));
      Modelica.Blocks.Continuous.Derivative derivative1 annotation (
        Placement(transformation(extent = {{-54, -28}, {-34, -8}})));
    equation
      connect(division.y, y) annotation (
        Line(points = {{91, -4}, {91, -4}, {110, -4}}, color = {0, 0, 127}));
      connect(product.y, add.u1) annotation (
        Line(points = {{11.1, 26}, {16, 26}, {16, 16}, {28, 16}}, color = {0, 0, 127}));
      connect(product1.y, add.u2) annotation (
        Line(points = {{11.1, 0}, {16, 0}, {16, 4}, {28, 4}}, color = {0, 0, 127}));
      connect(product3.y, add1.u1) annotation (
        Line(points = {{13.1, -44}, {17.55, -44}, {17.55, -10}, {28, -10}}, color = {0, 0, 127}));
      connect(u, derivative.u) annotation (
        Line(points = {{-100, 54}, {-100, 54}, {-70, 54}, {-70, 44}, {-58, 44}}, color = {0, 0, 127}));
      connect(derivative.y, product.u1) annotation (
        Line(points = {{-35, 44}, {-30, 44}, {-30, 32}, {-14.2, 32}}, color = {0, 0, 127}));
      connect(product.u2, u1) annotation (
        Line(points = {{-14.2, 20}, {-14.2, 20}, {-64, 20}, {-64, -72}, {-100, -72}}, color = {0, 0, 127}));
      connect(product2.u1, u1) annotation (
        Line(points = {{-12.2, -72}, {-46, -72}, {-100, -72}}, color = {0, 0, 127}));
      connect(product2.u2, u1) annotation (
        Line(points = {{-12.2, -84}, {-12.2, -84}, {-34, -84}, {-34, -72}, {-100, -72}}, color = {0, 0, 127}));
      connect(derivative1.y, product1.u2) annotation (
        Line(points = {{-33, -18}, {-26, -18}, {-26, -6}, {-14.2, -6}}, color = {0, 0, 127}));
      connect(product3.u1, derivative.u) annotation (
        Line(points = {{-12.2, -38}, {-70, -38}, {-70, 44}, {-58, 44}}, color = {0, 0, 127}));
      connect(product1.u1, derivative.u) annotation (
        Line(points = {{-14.2, 6}, {-36, 6}, {-70, 6}, {-70, 44}, {-58, 44}}, color = {0, 0, 127}));
      connect(derivative1.u, u1) annotation (
        Line(points = {{-56, -18}, {-64, -18}, {-64, -72}, {-100, -72}}, color = {0, 0, 127}));
      connect(product3.u2, derivative.u) annotation (
        Line(points = {{-12.2, -50}, {-34, -50}, {-34, -38}, {-70, -38}, {-70, 44}, {-58, 44}}, color = {0, 0, 127}));
      connect(add1.u2, product2.y) annotation (
        Line(points = {{28, -22}, {22, -22}, {22, -78}, {13.1, -78}}, color = {0, 0, 127}));
      connect(division.u2, add1.y) annotation (
        Line(points = {{68, -10}, {60, -10}, {60, -16}, {51, -16}}, color = {0, 0, 127}));
      connect(division.u1, add.y) annotation (
        Line(points = {{68, 2}, {60, 2}, {60, 10}, {51, 10}}, color = {0, 0, 127}));
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {28, 108, 200}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-70, 64}, {50, -24}}, lineColor = {28, 108, 200}, textString = "FrequencyCalculationBlock")}),
        Diagram(coordinateSystem(preserveAspectRatio = false)));
    end FrequencyCalculationBlock;

    model Breaker
      import Modelica.ComplexMath.j;
      OpenIPSL.Interfaces.PwPin p annotation (
        Placement(transformation(extent = {{-100, -10}, {-80, 10}}), iconTransformation(extent = {{-100, -10}, {-80, 10}})));
      OpenIPSL.Interfaces.PwPin n annotation (
        Placement(transformation(extent = {{80, -10}, {100, 10}}), iconTransformation(extent = {{80, -10}, {100, 10}})));
      Complex vs(re = p.vr, im = p.vi);
      Complex vr(re = n.vr, im = n.vi);
      Complex is(re = p.ir, im = p.ii);
      Complex ir(re = n.ir, im = n.ii);
      Modelica.Blocks.Interfaces.BooleanInput TRIGGER annotation (
        Placement(transformation(extent = {{-32, 80}, {-12, 100}}), iconTransformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {0, 90})));
    equation
      if not TRIGGER then
        is = 0 + j * 0;
        ir = 0 + j * 0;
      else
        ir = -is;
        vs = vr;
      end if;
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-80, -80}, {80, 80}}), graphics={  Ellipse(extent = {{-80, 80}, {80, -80}}, lineColor = {0, 0, 255},
                lineThickness =                                                                                                                                                            0.5, fillColor = {255, 255, 255},
                fillPattern =                                                                                                                                                                                                        FillPattern.Solid)}),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-80, -80}, {80, 80}})));
    end Breaker;
  end Essentials;

  package Generators
    model G1
      outer OpenIPSL.Electrical.SystemBase SysData;
      extends OpenIPSL.Electrical.Essentials.pfComponent;
      OpenIPSL.Interfaces.PwPin conn annotation (
        Placement(transformation(extent = {{100, -10}, {120, 10}}), iconTransformation(extent = {{100, -10}, {120, 10}})));
      OpenIPSL.Electrical.Machines.PSSE.GENSAL gENROE(M_b = 100, Tpd0 = 5, Tppd0 = 0.07, Tppq0 = 0.09, H = 4.28, D = 0, Xd = 1.84, Xq = 1.75, Xpd = 0.41, Xppd = 0.2, Xl = 0.12, S10 = 0.11, S12 = 0.39, Xppq = 0.2, R_a = 0, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0, SPEED(fixed = true, start = 0), w(fixed = true, start = 0)) annotation (
        Placement(transformation(extent = {{-18, -20}, {22, 20}})));
      OpenIPSL.Electrical.Controls.PSSE.ES.SEXS sEXS(T_AT_B = 0.1, T_B = 1, K = 100, T_E = 0.1, E_MIN = -10, E_MAX = 10) annotation (
        Placement(transformation(extent = {{-60, -28}, {-34, -4}})));
      OpenIPSL.Electrical.Controls.PSSE.TG.HYGOV hYGOV annotation (
        Placement(transformation(extent = {{-62, 0}, {-34, 20}})));
      Modelica.Blocks.Sources.Constant const(k = 0) annotation (
        Placement(transformation(extent = {{-90, -62}, {-76, -48}})));
      Modelica.Blocks.Math.Add add(k2 = +1) annotation (
        Placement(transformation(extent = {{-90, 14}, {-76, 28}})));
      Modelica.Blocks.Sources.Ramp ramp(startTime = 6, duration = 5, height = 0.0101) annotation (
        Placement(transformation(extent = {{-76, -6}, {-90, 8}})));
    equation
      connect(gENROE.p, conn) annotation (
        Line(points = {{22, 0}, {22, 0}, {110, 0}}, color = {0, 0, 255}));
      connect(hYGOV.PMECH0, gENROE.PMECH0) annotation (
        Line(points = {{-60.8333, 4.44444}, {-72, 4.44444}, {-72, 28}, {40, 28}, {40, 10}, {24, 10}}, color = {0, 0, 127}));
      connect(hYGOV.PMECH, gENROE.PMECH) annotation (
        Line(points = {{-33.4167, 11.1111}, {-28, 11.1111}, {-28, 10}, {-22, 10}}, color = {0, 0, 127}));
      connect(sEXS.EFD, gENROE.EFD) annotation (
        Line(points = {{-33.35, -14.6667}, {-30, -14.6667}, {-30, -10}, {-22, -10}}, color = {0, 0, 127}));
      connect(add.u2, ramp.y) annotation (
        Line(points = {{-91.4, 16.8}, {-96, 16.8}, {-96, 1}, {-90.7, 1}}, color = {0, 0, 127}));
      connect(const.y, sEXS.VOTHSG) annotation (
        Line(points = {{-75.3, -55}, {-75.3, -55}, {-68, -55}, {-68, -8.66667}, {-60, -8.66667}}, color = {0, 0, 127}));
      connect(gENROE.ETERM, sEXS.ECOMP) annotation (
        Line(points = {{24, -6}, {38, -6}, {38, -32}, {-82, -32}, {-82, -14.6667}, {-60, -14.6667}}, color = {0, 0, 127}));
      connect(sEXS.EFD0, gENROE.EFD0) annotation (
        Line(points = {{-60, -23.3333}, {-86, -23.3333}, {-86, -40}, {30, -40}, {30, -10}, {24, -10}}, color = {0, 0, 127}));
      connect(add.y, hYGOV.SPEED) annotation (
        Line(points = {{-75.3, 21}, {-66, 21}, {-66, 16.6667}, {-60.8333, 16.6667}}, color = {0, 0, 127}));
      connect(add.u1, gENROE.SPEED) annotation (
        Line(points = {{-91.4, 25.2}, {-96, 25.2}, {-96, 36}, {48, 36}, {48, 14}, {24, 14}}, color = {0, 0, 127}));
      connect(sEXS.VUEL, sEXS.VOTHSG) annotation (
        Line(points = {{-55.45, -28}, {-56, -28}, {-56, -56}, {-68, -56}, {-68, -8.66667}, {-60, -8.66667}}, color = {0, 0, 127}));
      connect(sEXS.VOEL, sEXS.VOTHSG) annotation (
        Line(points = {{-51.55, -28}, {-52, -28}, {-52, -56}, {-68, -56}, {-68, -8.66667}, {-60, -8.66667}}, color = {0, 0, 127}));
      connect(conn, conn) annotation (
        Line(points = {{110, 0}, {110, 0}}, color = {0, 0, 255}));
      connect(sEXS.XADIFD, sEXS.VOTHSG) annotation (
        Line(points = {{-41.15, -27.7333}, {-41.15, -58}, {-52, -58}, {-52, -56}, {-68, -56}, {-68, -8.66667}, {-60, -8.66667}}, color = {0, 0, 127}));
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Ellipse(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255},
                fillPattern =                                                                                                                                                          FillPattern.Solid), Line(points = {{-48, 2}, {-20, 56}, {2, 4}, {24, -28}, {48, 22}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{-52, -18}, {56, -66}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255},
                fillPattern =                                                                                                                                                                                                        FillPattern.Solid, textString = "%name")}),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})));
    end G1;

    model G22
      outer OpenIPSL.Electrical.SystemBase SysData;
      extends OpenIPSL.Electrical.Essentials.pfComponent;
      OpenIPSL.Interfaces.PwPin conn annotation (
        Placement(transformation(extent = {{100, -10}, {120, 10}}), iconTransformation(extent = {{100, -10}, {120, 10}})));
      OpenIPSL.Electrical.Machines.PSSE.GENSAL gENROE(M_b = 100, Tpd0 = 5, Tppd0 = 0.07, Tppq0 = 0.09, H = 4.28, D = 0, Xd = 1.84, Xq = 1.75, Xpd = 0.41, Xppd = 0.2, Xl = 0.12, S10 = 0.11, S12 = 0.39, Xppq = 0.2, R_a = 0, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0) annotation (
        Placement(transformation(extent = {{30, -28}, {70, 12}})));
      OpenIPSL.Electrical.Controls.PSSE.TG.IEESGO iEESGO(P_MAX = 1.5, P_MIN = 0) annotation (
        Placement(transformation(extent = {{-22, -4}, {10, 10}})));
      OpenIPSL.Electrical.Controls.PSSE.ES.SEXS sEXS(T_AT_B = 0.2, K = 50, E_MIN = 0, E_MAX = 5, T_E = 0.01, T_B = 10) annotation (
        Placement(transformation(extent = {{-26, -34}, {-4, -14}})));
      Modelica.Blocks.Interfaces.RealInput f_DN annotation (
        Placement(transformation(extent = {{-110, 52}, {-90, 72}}), iconTransformation(extent = {{-110, 52}, {-90, 72}})));
      Modelica.Blocks.Sources.Constant const1(k = 0) annotation (
        Placement(transformation(extent = {{7, -7}, {-7, 7}}, rotation = 180, origin = {-77, -17})));
      Modelica.Blocks.Logical.Switch switch1 annotation (
        Placement(transformation(extent = {{0, 46}, {18, 64}})));
      Modelica.Blocks.Interfaces.BooleanInput start_islanding annotation (
        Placement(transformation(extent = {{-12, -12}, {12, 12}}, rotation = 0, origin = {-100, 20}), iconTransformation(extent = {{-12, -12}, {12, 12}}, rotation = 90, origin = {-2, -104})));
      Modelica.Blocks.Math.Add add2(k1 = +1) annotation (
        Placement(transformation(extent = {{-6, 28}, {-18, 40}})));
      Modelica.Blocks.Continuous.PI PI(T = 0.00025, k = 0.0000001) annotation (
        Placement(transformation(extent = {{32, 48}, {46, 62}})));
    equation
      connect(add2.u2, gENROE.SPEED) annotation (
        Line(points = {{-4.8, 30.4}, {86, 30.4}, {86, 6}, {72, 6}}, color = {0, 0, 127}));
      connect(iEESGO.PMECH, gENROE.PMECH) annotation (
        Line(points = {{10.6667, 3.77778}, {26, 3.77778}, {26, 2}}, color = {0, 0, 127}));
      connect(sEXS.EFD, gENROE.EFD) annotation (
        Line(points = {{-3.45, -22.8889}, {12.275, -22.8889}, {12.275, -18}, {26, -18}}, color = {0, 0, 127}));
      connect(gENROE.ETERM, sEXS.ECOMP) annotation (
        Line(points = {{72, -14}, {88, -14}, {88, -58}, {-44, -58}, {-44, -22.8889}, {-26, -22.8889}}, color = {0, 0, 127}));
      connect(gENROE.p, conn) annotation (
        Line(points = {{70, -8}, {88, -8}, {88, 0}, {110, 0}}, color = {0, 0, 255}));
      connect(switch1.y, PI.u) annotation (
        Line(points = {{18.9, 55}, {24, 55}, {30.6, 55}}, color = {0, 0, 127}));
      connect(add2.u1, PI.y) annotation (
        Line(points = {{-4.8, 37.6}, {56, 37.6}, {56, 55}, {46.7, 55}}, color = {0, 0, 127}));
      connect(const1.y, switch1.u3) annotation (
        Line(points = {{-69.3, -17}, {-51.75, -17}, {-51.75, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(f_DN, switch1.u1) annotation (
        Line(points = {{-100, 62}, {-52, 62}, {-52, 62.2}, {-1.8, 62.2}}, color = {0, 0, 127}));
      connect(iEESGO.SPEED, add2.y) annotation (
        Line(points = {{-20.6667, 7.66667}, {-42, 7.66667}, {-42, 34}, {-18.6, 34}}, color = {0, 0, 127}));
      connect(gENROE.PMECH0, iEESGO.PMECH0) annotation (
        Line(points = {{72, 2}, {78, 2}, {78, 20}, {-32, 20}, {-32, -0.888889}, {-20.6667, -0.888889}}, color = {0, 0, 127}));
      connect(gENROE.EFD0, sEXS.EFD0) annotation (
        Line(points = {{72, -18}, {76, -18}, {76, -48}, {-36, -48}, {-36, -30.1111}, {-26, -30.1111}}, color = {0, 0, 127}));
      connect(sEXS.VOTHSG, switch1.u3) annotation (
        Line(points = {{-26, -17.8889}, {-52, -17.8889}, {-52, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(sEXS.VUEL, switch1.u3) annotation (
        Line(points = {{-22.15, -34}, {-22, -34}, {-22, -70}, {-52, -70}, {-52, -18}, {-51.75, -17}, {-51.75, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(sEXS.VOEL, switch1.u3) annotation (
        Line(points = {{-18.85, -34}, {-18, -34}, {-18, -70}, {-52, -70}, {-52, -18}, {-51.75, -17}, {-51.75, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(start_islanding, switch1.u2) annotation (
        Line(points = {{-100, 20}, {-88, 20}, {-78, 20}, {-78, 55}, {-1.8, 55}}, color = {255, 0, 255}));
      connect(sEXS.XADIFD, switch1.u3) annotation (
        Line(points = {{-10.05, -33.7778}, {-10.05, -70}, {-52, -70}, {-52, -18}, {-52, -17}, {-52, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Ellipse(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255},
                fillPattern =                                                                                                                                                                                               FillPattern.Solid), Line(points = {{-48, 2}, {-20, 56}, {2, 4}, {24, -28}, {48, 22}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{-52, -18}, {56, -66}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255},
                fillPattern =                                                                                                                                                                                                        FillPattern.Solid, textString = "%name")}),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})));
    end G22;

    model G22_CD
      outer OpenIPSL.Electrical.SystemBase SysData;
      extends OpenIPSL.Electrical.Essentials.pfComponent;
      OpenIPSL.Interfaces.PwPin conn annotation (
        Placement(transformation(extent = {{100, -10}, {120, 10}}), iconTransformation(extent = {{100, -10}, {120, 10}})));
      OpenIPSL.Electrical.Machines.PSSE.GENSAL gENROE(M_b = 100, Tpd0 = 5, Tppd0 = 0.07, Tppq0 = 0.09, H = 4.28, D = 0, Xd = 1.84, Xq = 1.75, Xpd = 0.41, Xppd = 0.2, Xl = 0.12, S10 = 0.11, S12 = 0.39, Xppq = 0.2, R_a = 0, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0) annotation (
        Placement(transformation(extent = {{30, -28}, {70, 12}})));
      OpenIPSL.Electrical.Controls.PSSE.TG.IEESGO iEESGO(P_MAX = 1.5, P_MIN = 0) annotation (
        Placement(transformation(extent = {{-22, -4}, {10, 10}})));
      OpenIPSL.Electrical.Controls.PSSE.ES.SEXS sEXS(T_AT_B = 0.2, K = 50, E_MIN = 0, E_MAX = 5, T_E = 0.01, T_B = 10) annotation (
        Placement(transformation(extent = {{-26, -34}, {-4, -14}})));
      Modelica.Blocks.Interfaces.RealInput f_DN annotation (
        Placement(transformation(extent = {{-110, 52}, {-90, 72}}), iconTransformation(extent = {{-110, 52}, {-90, 72}})));
      Modelica.Blocks.Sources.Constant const1(k = 0) annotation (
        Placement(transformation(extent = {{7, -7}, {-7, 7}}, rotation = 180, origin = {-77, -17})));
      Modelica.Blocks.Logical.Switch switch1 annotation (
        Placement(transformation(extent = {{0, 46}, {18, 64}})));
      Modelica.Blocks.Interfaces.BooleanInput start_islanding annotation (
        Placement(transformation(extent = {{-12, -12}, {12, 12}}, rotation = 0, origin = {-100, 20}), iconTransformation(extent = {{-12, -12}, {12, 12}}, rotation = 90, origin = {-2, -104})));
      Modelica.Blocks.Math.Add add2(k1 = +1) annotation (
        Placement(transformation(extent = {{-6, 28}, {-18, 40}})));
      Modelica.Blocks.Continuous.PI PI(T = 0.00025, k = 0.0000001) annotation (
        Placement(transformation(extent = {{32, 48}, {46, 62}})));
      Modelica.Blocks.Math.Gain gain(k = 0) annotation (
        Placement(transformation(extent = {{56, 50}, {66, 60}})));
    equation
      connect(add2.u2, gENROE.SPEED) annotation (
        Line(points = {{-4.8, 30.4}, {86, 30.4}, {86, 6}, {72, 6}}, color = {0, 0, 127}));
      connect(iEESGO.PMECH, gENROE.PMECH) annotation (
        Line(points = {{10.6667, 3.77778}, {26, 3.77778}, {26, 2}}, color = {0, 0, 127}));
      connect(sEXS.EFD, gENROE.EFD) annotation (
        Line(points = {{-3.45, -22.8889}, {12.275, -22.8889}, {12.275, -18}, {26, -18}}, color = {0, 0, 127}));
      connect(gENROE.ETERM, sEXS.ECOMP) annotation (
        Line(points = {{72, -14}, {88, -14}, {88, -58}, {-44, -58}, {-44, -22.8889}, {-26, -22.8889}}, color = {0, 0, 127}));
      connect(gENROE.p, conn) annotation (
        Line(points = {{70, -8}, {88, -8}, {88, 0}, {110, 0}}, color = {0, 0, 255}));
      connect(switch1.y, PI.u) annotation (
        Line(points = {{18.9, 55}, {24, 55}, {30.6, 55}}, color = {0, 0, 127}));
      connect(const1.y, switch1.u3) annotation (
        Line(points = {{-69.3, -17}, {-51.75, -17}, {-51.75, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(f_DN, switch1.u1) annotation (
        Line(points = {{-100, 62}, {-52, 62}, {-52, 62.2}, {-1.8, 62.2}}, color = {0, 0, 127}));
      connect(iEESGO.SPEED, add2.y) annotation (
        Line(points = {{-20.6667, 7.66667}, {-42, 7.66667}, {-42, 34}, {-18.6, 34}}, color = {0, 0, 127}));
      connect(gENROE.PMECH0, iEESGO.PMECH0) annotation (
        Line(points = {{72, 2}, {78, 2}, {78, 20}, {-32, 20}, {-32, -0.888889}, {-20.6667, -0.888889}}, color = {0, 0, 127}));
      connect(gENROE.EFD0, sEXS.EFD0) annotation (
        Line(points = {{72, -18}, {76, -18}, {76, -48}, {-36, -48}, {-36, -30.1111}, {-26, -30.1111}}, color = {0, 0, 127}));
      connect(sEXS.VOTHSG, switch1.u3) annotation (
        Line(points = {{-26, -17.8889}, {-52, -17.8889}, {-52, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(sEXS.VUEL, switch1.u3) annotation (
        Line(points = {{-22.15, -34}, {-22, -34}, {-22, -70}, {-52, -70}, {-52, -18}, {-51.75, -17}, {-51.75, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(sEXS.VOEL, switch1.u3) annotation (
        Line(points = {{-18.85, -34}, {-18, -34}, {-18, -70}, {-52, -70}, {-52, -18}, {-51.75, -17}, {-51.75, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      connect(start_islanding, switch1.u2) annotation (
        Line(points = {{-100, 20}, {-88, 20}, {-78, 20}, {-78, 55}, {-1.8, 55}}, color = {255, 0, 255}));
      connect(PI.y, gain.u) annotation (
        Line(points = {{46.7, 55}, {49.35, 55}, {55, 55}}, color = {0, 0, 127}));
      connect(add2.u1, gain.y) annotation (
        Line(points = {{-4.8, 37.6}, {76, 37.6}, {76, 55}, {66.5, 55}}, color = {0, 0, 127}));
      connect(sEXS.XADIFD, switch1.u3) annotation (
        Line(points = {{-10.05, -33.7778}, {-10.05, -70}, {-52, -70}, {-52, -18}, {-52, -17}, {-52, 47.8}, {-1.8, 47.8}}, color = {0, 0, 127}));
      annotation (
        Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-48, 2}, {-20, 56}, {2, 4}, {24, -28}, {48, 22}}, color = {0, 0, 0}, smooth = Smooth.Bezier), Text(extent = {{-52, -18}, {56, -66}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name")}),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})));
    end G22_CD;
  end Generators;

  package PowerFlowData
    package case10_0MW
      record Network_10_0_MW_loads_WL
        extends Modelica.Icons.Record;
        // Load 3_1
        parameter Real PL3_1 = 50.000000;
        parameter Real QL3_1 = 10.000000;
        // Load 5_1
        parameter Real PL5_1 = 10.000000;
        parameter Real QL5_1 = 10.000000;
        // Load 8_1
        parameter Real PL8_1 = 10.000000;
        parameter Real QL8_1 = 10.000000;
        annotation ();
      end Network_10_0_MW_loads_WL;

      record Network_10_0_MW_machines_WL
        extends Modelica.Icons.Record;
        // Machine 7_1
        parameter Real P7_1 = 10.000000;
        parameter Real Q7_1 = 27.599998;
        // Machine 1_1
        parameter Real P1_1 = 60.381001;
        parameter Real Q1_1 = 23.062000;
        annotation ();
      end Network_10_0_MW_machines_WL;

      record Network_10_0_MW_trafos_WL
        extends Modelica.Icons.Record;
        // 2WindingTrafo 6_7
        parameter Real t1_6_7 = 1.000000;
        parameter Real t2_6_7 = 1.000000;
        // 2WindingTrafo 1_2
        parameter Real t1_1_2 = 1.000000;
        parameter Real t2_1_2 = 1.000000;
        annotation ();
      end Network_10_0_MW_trafos_WL;

      record Network_10_0_MW_voltages_WL
        extends Modelica.Icons.Record;
        // Bus number 1
        parameter Real V1 = 1.000000;
        parameter Real A1 = 0.000000;
        // Bus number 2
        parameter Real V2 = 0.960860;
        parameter Real A2 = -7.206201;
        // Bus number 3
        parameter Real V3 = 0.938050;
        parameter Real A3 = -14.891100;
        // Bus number 4
        parameter Real V4 = 0.939980;
        parameter Real A4 = -15.226201;
        // Bus number 5
        parameter Real V5 = 0.875770;
        parameter Real A5 = -18.359800;
        // Bus number 6
        parameter Real V6 = 0.971940;
        parameter Real A6 = -15.256498;
        // Bus number 7
        parameter Real V7 = 1.000000;
        parameter Real A7 = -14.748300;
        // Bus number 8
        parameter Real V8 = 0.910260;
        parameter Real A8 = -18.172001;
        annotation ();
      end Network_10_0_MW_voltages_WL;
    end case10_0MW;
  end PowerFlowData;

  package OpenIPSL "Open-Instance Power System Library"
    class Copyright "Disclaimer<html>
<p>OpenIPSL:</p>
<p>Copyright August 2017 - Prof. Luigi Vanfretti, Rensselaer Polytechnic Institute, Troy, NY.</p>
<p>Copyright April 2016 - July 2017 SmarTS Lab (Sweden)</p>
<ul>
<li>SmarTS Lab, research group at KTH: <a href=\"https://www.kth.se/en\">https://www.kth.se/en</a></li>
</ul>
<p>The authors can be contacted by email: <a href=\"mailto:luigi.vanfretti@gmail.com\">luigi.vanfretti@gmail.com</a></p>
<p>This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. </p>
<p>If a copy of the MPL was not distributed with this file, You can obtain one at <a href=\"http://mozilla.org/MPL/2.0/\"> http://mozilla.org/MPL/2.0</a>.</p>
<p>&nbsp;</p>
<p>iPSL:</p>
<p>Copyright 2015-2016 RTE (France), SmarTS Lab (Sweden), AIA (Spain) and DTU (Denmark)</p>
<ul>
<li>RTE: <a href=\"http://www.rte-france.com\">http://www.rte-france.com</a></li>
<li>SmarTS Lab, research group at KTH: <a href=\"https://www.kth.se/en\">https://www.kth.se/en</a></li>
<li>AIA: <a href=\"http://www.aia.es/en/energy\"> http://www.aia.es/en/energy</a></li>
<li>DTU: <a href=\"http://www.dtu.dk/english\"> http://www.dtu.dk/english</a></li>
</ul>
<p>The authors can be contacted by email: <a href=\"mailto:info@itesla-ipsl.org\">info@itesla-ipsl.org</a></p>

<p>This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. </p>
<p>If a copy of the MPL was not distributed with this file, You can obtain one at <a href=\"http://mozilla.org/MPL/2.0/\"> http://mozilla.org/MPL/2.0</a>.</p>
</html>"

      annotation (
        preferredView="info",
        DocumentationClass=false,
        Icon(graphics={
            Text(
              extent={{-100,140},{100,100}},
              lineColor={0,127,0},
              textString="%name%"),
            Ellipse(
              extent={{-100,100},{100,-100}},
              lineColor={0,127,0},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-60,60},{60,-60}},
              lineColor={0,127,72},
              fillColor={0,127,0},
              fillPattern=FillPattern.Solid),
            Ellipse(
              extent={{-40,40},{40,-40}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid),
            Rectangle(
              extent={{28,22},{64,-20}},
              lineColor={255,255,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid)}),
        Documentation);
    end Copyright;

    package Examples
    extends Modelica.Icons.ExamplesPackage;

      package Machines
      extends Modelica.Icons.ExamplesPackage;

        package PSSE
        extends Modelica.Icons.ExamplesPackage;

          model GEN "SMIB system with one load and flexible GEN model (needs replaceable support)"
            extends OpenIPSL.Examples.SMIBpartial;
            Electrical.Machines.PSSE.Plant G1(
              redeclare Electrical.Machines.PSSE.GENROE machine(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2,
                R_a=0,
                Xpq=2,
                Tpq0=2),
              redeclare OpenIPSL.Electrical.Controls.PSSE.TG.ConstantPower governor,
              redeclare OpenIPSL.Electrical.Controls.PSSE.ES.ConstantExcitation exciter,
              redeclare OpenIPSL.Electrical.Controls.PSSE.PSS.DisabledPSS pss)
              annotation (Placement(transformation(extent={{-80,-10},{-60,10}})));
          equation
            connect(G1.pwPin, GEN1.p)
              annotation (Line(points={{-59,0},{-49.5,0},{-40,0}}, color={0,0,255}));

          end GEN;

          model GENSAL "SMIB system with one load and GENSAL model"
            extends OpenIPSL.Examples.SMIBpartial;
            OpenIPSL.Electrical.Machines.PSSE.GENSAL gENSAL(
              M_b=100,
              Tpd0=5,
              Tppd0=0.07,
              Tppq0=0.09,
              H=4.28,
              D=0,
              Xd=1.84,
              Xq=1.75,
              Xpd=0.41,
              Xppd=0.2,
              Xl=0.12,
              S10=0.11,
              S12=0.39,
              V_0=1,
              P_0=40,
              angle_0=4.046276,
              Q_0=5.416582,
              Xppq=0.2,
              R_a=0) annotation (Placement(transformation(extent={{-100,-20},{-60,
                      20}})));
          equation
            connect(gENSAL.PMECH, gENSAL.PMECH0) annotation (Line(points={{-104,10},{-112,
                    10},{-112,26},{-54,26},{-54,10},{-58,10}}, color={0,0,127}));
            connect(gENSAL.EFD, gENSAL.EFD0) annotation (Line(points={{-104,-10},{-112,-10},
                    {-112,-30},{-54,-30},{-54,-10},{-58,-10}}, color={0,0,127}));
            connect(gENSAL.p, GEN1.p)
              annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
            annotation (Documentation, experiment(StopTime=10));
          end GENSAL;

          model GENSAE "SMIB system with one load and GENSAE model"
            extends OpenIPSL.Examples.SMIBpartial;
            OpenIPSL.Electrical.Machines.PSSE.GENSAE gENSAE(
              M_b=100,
              Tpd0=5,
              Tppd0=0.07,
              Tppq0=0.09,
              H=4.28,
              D=0,
              Xd=1.84,
              Xq=1.75,
              Xpd=0.41,
              Xppd=0.2,
              Xl=0.12,
              S10=0.11,
              S12=0.39,
              V_0=1,
              P_0=40,
              angle_0=4.046276,
              Q_0=5.416582,
              Xppq=0.2,
              R_a=0) annotation (Placement(transformation(extent={{-100,-20},{-60,
                      20}})));
          equation
            connect(gENSAE.PMECH, gENSAE.PMECH0) annotation (Line(points={{-104,10},{-112,
                    10},{-112,26},{-54,26},{-54,10},{-58,10}}, color={0,0,127}));
            connect(gENSAE.EFD, gENSAE.EFD0) annotation (Line(points={{-104,-10},{-112,-10},
                    {-112,-30},{-54,-30},{-54,-10},{-58,-10}}, color={0,0,127}));
            connect(gENSAE.p, GEN1.p)
              annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
            annotation (Documentation, experiment(StopTime=10));
          end GENSAE;

          model GENROU
            extends OpenIPSL.Examples.SMIBpartial;
            OpenIPSL.Electrical.Machines.PSSE.GENROU gENROU(
              M_b=100,
              Tpd0=5,
              Tppd0=0.07,
              Tpq0=0.9,
              Tppq0=0.09,
              D=0,
              Xd=1.84,
              Xq=1.75,
              Xpd=0.41,
              Xpq=0.6,
              Xppd=0.2,
              Xl=0.12,
              S10=0.11,
              S12=0.39,
              V_0=1,
              P_0=40,
              angle_0=4.046276,
              Q_0=5.416582,
              Xppq=0.2,
              R_a=0,
              Xpp=0.2,
              H=4.28) annotation (Placement(transformation(extent={{-100,-20},{
                      -60,20}})));
          equation
            connect(gENROU.PMECH, gENROU.PMECH0) annotation (Line(points={{-104,10},{-112,
                    10},{-112,26},{-54,26},{-54,10},{-58,10}}, color={0,0,127}));
            connect(gENROU.EFD, gENROU.EFD0) annotation (Line(points={{-104,-10},{-112,-10},
                    {-112,-30},{-54,-30},{-54,-10},{-58,-10}}, color={0,0,127}));
            connect(gENROU.p, GEN1.p)
              annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
            annotation (Documentation, experiment(StopTime=10));
          end GENROU;

          model GENROE
            extends OpenIPSL.Examples.SMIBpartial;
            OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
              M_b=100,
              Tpd0=5,
              Tppd0=0.07,
              Tpq0=0.9,
              Tppq0=0.09,
              H=4.28,
              D=0,
              Xd=1.84,
              Xq=1.75,
              Xpd=0.41,
              Xpq=0.6,
              Xppd=0.2,
              Xl=0.12,
              S10=0.11,
              S12=0.39,
              V_0=1,
              P_0=40,
              angle_0=4.046276,
              Q_0=5.416582,
              Xppq=0.2,
              R_a=0,
              Xpp=0.2) annotation (Placement(transformation(extent={{-100,-20},
                      {-60,20}})));
          equation
            connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-112,
                    10},{-112,26},{-54,26},{-54,10},{-58,10}}, color={0,0,127}));
            connect(gENROE.EFD, gENROE.EFD0) annotation (Line(points={{-104,-10},{-112,-10},
                    {-112,-30},{-54,-30},{-54,-10},{-58,-10}}, color={0,0,127}));
            connect(gENROE.p, GEN1.p)
              annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
            annotation (Documentation, experiment(StopTime=10));
          end GENROE;
        annotation (Documentation);
        end PSSE;

        package PSAT
        extends Modelica.Icons.ExamplesPackage;

          model Order2test2
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order2 order21(
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(visible=true,
                  transformation(
                  origin={-29.946,0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
          equation
            connect(order21.vf, order21.vf0) annotation (Line(points={{-41.946,5},{-46,5},
                    {-46,14},{-37.946,14},{-37.946,11}}, color={0,0,127}));
            connect(order21.pm, order21.pm0) annotation (Line(points={{-41.946,-5},{-46,-5},
                    {-46,-14},{-37.946,-14},{-37.946,-11}}, color={0,0,127}));
            connect(order21.p, bus.p) annotation (Line(points={{-19.946,0},{-9.473,0},{-9.473,
                    0},{0,0}}, color={0,0,255}));
            annotation (Documentation,experiment(StopTime=20));
          end Order2test2;

          model Order2test2_perturbation
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45,25},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-74.9999,35},
                  extent={{-4.99992,-5.00001},{4.99991,5.00002}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-95,55},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-95,35},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-95,20},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-75,15},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-95,5},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-95,-75},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-75,-65},
                  extent={{-4.99999,-4.99999},{4.99999,4.99999}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-95,-55},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-95,-35},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-95,-15},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-75,-25},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45,-25},
                  extent={{-5.00007,-5.00012},{5.00001,4.99999}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order2 order2_Inputs_Outputs1(
              D=0,
              V_b=400,
              V_0=1,
              angle_0=0,
              Sn=20,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(visible=true,
                  transformation(
                  origin={-20.1083,0.1663},
                  extent={{-8.8917,-9.1663},{8.8916,9.1663}},
                  rotation=0)));
          equation
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-86.308,-30.9083},
                points={{-3.192,-4.0917},{2.3974,-4.0917},{2.3974,2.9083},{5.308,2.9083}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-86.308,-19.6146},
                points={{-3.192,4.6146},{2.3974,4.6146},{2.3974,-2.3854},{5.308,-2.3854}},
                color={0,0,127}));

            connect(order2_Inputs_Outputs1.p, bus.p) annotation (Line(points={{-11.2167,
                    0.1663},{-5.66375,0.1663},{-5.66375,0},{0,0}}, color={0,0,255}));
            connect(add31.y, order2_Inputs_Outputs1.vf) annotation (Line(points={{-39.5,
                    25},{-35,25},{-35,4.74945},{-30.7783,4.74945}}, color={0,0,127}));
            connect(order2_Inputs_Outputs1.vf0, add31.u3) annotation (Line(points={{-27.2217,
                    10.2492},{-27.2217,14},{-55,14},{-55,21},{-51,21}}, color={0,0,127}));
            connect(add32.y, order2_Inputs_Outputs1.pm) annotation (Line(points={{-39.5,-25.0001},
                    {-35,-25.0001},{-35,-4.41685},{-30.7783,-4.41685}}, color={0,0,127}));
            connect(add1.y, add31.u1) annotation (Line(points={{-69.5,35},{-60,35},{-60,
                    29},{-51,29}}, color={0,0,127}));
            connect(add2.y, add31.u2) annotation (Line(points={{-69.5,15},{-60,15},{-60,
                    25},{-51,25}}, color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(points={{-89.5,35},{-87,35},{-87,
                    32},{-80.9998,32}}, color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(points={{-89.5,55},{-87,55},{-87,
                    38},{-80.9998,38}}, color={0,0,127}));
            connect(sine2.y, add2.u2) annotation (Line(points={{-89.5,5},{-86,5},{-86,12},
                    {-81,12}}, color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(points={{-89.5,20},{-86,20},{-86,
                    18},{-81,18}}, color={0,0,127}));
            connect(order2_Inputs_Outputs1.pm0, add32.u1) annotation (Line(points={{-27.2217,
                    -9.91663},{-27.2217,-13},{-54,-13},{-54,-21},{-51.0001,-21}}, color={
                    0,0,127}));
            connect(add4.y, add32.u2) annotation (Line(points={{-69.5,-25},{-60,-25},{-60,
                    -25.0001},{-51.0001,-25.0001}}, color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(points={{-89.5,-55},{-85,-55},{-85,
                    -62},{-81,-62}}, color={0,0,127}));
            connect(sine3.y, add3.u2) annotation (Line(points={{-89.5,-75},{-85,-75},{-85,
                    -68},{-81,-68}}, color={0,0,127}));
            connect(add3.y, add32.u3) annotation (Line(points={{-69.5,-65},{-60,-65},{-60,
                    -29.0001},{-51.0001,-29.0001}}, color={0,0,127}));
            annotation (Documentation,experiment(StopTime=20));
          end Order2test2_perturbation;

          model Order3test2
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order3 order31(
              V_b=400,
              V_0=1,
              angle_0=0,
              Sn=20,
              Vn=400,
              ra=0.01,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(visible=true,
                  transformation(
                  origin={-25,0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
          equation
            connect(order31.vf, order31.vf0) annotation (Line(points={{-37,5},{-40,5},{-40,
                    15},{-33,15},{-33,11}}, color={0,0,127}));
            connect(order31.pm, order31.pm0) annotation (Line(points={{-37,-5},{-40,-5},{
                    -40,-15},{-33,-15},{-33,-11}}, color={0,0,127}));
            connect(order31.p, bus.p)
              annotation (Line(points={{-15,0},{-7,0},{-7,0},{0,0}}, color={0,0,255}));
            annotation (Documentation,experiment(StopTime=20));
          end Order3test2;

          model Order3test2_perturbation
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              V_b=400,
              V_0=1,
              angle_0=0,
              Sn=20,
              Vn=400,
              ra=0.01,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(visible=true,
                  transformation(
                  origin={-18.3443,-0.375609},
                  extent={{-9.6557,-9.62439},{9.6557,9.62439}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45,25},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-74.9999,35},
                  extent={{-4.99992,-5.00001},{4.99991,5.00002}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-95,55},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-95,35},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-95,20},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-75,15},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-95,5},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-95,-75},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-75,-65},
                  extent={{-4.99999,-4.99999},{4.99999,4.99999}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-95,-55},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-95,-35},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-95,-15},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-75,-25},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45,-25},
                  extent={{-5.00007,-5.00012},{5.00001,4.99999}},
                  rotation=0)));
          equation
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-86.308,-30.9083},
                points={{-3.192,-4.0917},{2.3974,-4.0917},{2.3974,2.9083},{5.308,2.9083}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-86.308,-19.6146},
                points={{-3.192,4.6146},{2.3974,4.6146},{2.3974,-2.3854},{5.308,-2.3854}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(points={{-69.5,35},{-60,35},{-60,
                    29},{-51,29}}, color={0,0,127}));
            connect(add2.y, add31.u2) annotation (Line(points={{-69.5,15},{-60,15},{-60,
                    25},{-51,25}}, color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(points={{-89.5,35},{-87,35},{-87,
                    32},{-80.9998,32}}, color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(points={{-89.5,55},{-87,55},{-87,
                    38},{-80.9998,38}}, color={0,0,127}));
            connect(sine2.y, add2.u2) annotation (Line(points={{-89.5,5},{-86,5},{-86,12},
                    {-81,12}}, color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(points={{-89.5,20},{-86,20},{-86,
                    18},{-81,18}}, color={0,0,127}));
            connect(add4.y, add32.u2) annotation (Line(points={{-69.5,-25},{-60,-25},{-60,
                    -25.0001},{-51.0001,-25.0001}}, color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(points={{-89.5,-55},{-85,-55},{-85,
                    -62},{-81,-62}}, color={0,0,127}));
            connect(sine3.y, add3.u2) annotation (Line(points={{-89.5,-75},{-85,-75},{-85,
                    -68},{-81,-68}}, color={0,0,127}));
            connect(add3.y, add32.u3) annotation (Line(points={{-69.5,-65},{-60,-65},{-60,
                    -29.0001},{-51.0001,-29.0001}}, color={0,0,127}));
            connect(order3_Inputs_Outputs1.p, bus.p) annotation (Line(points={{-8.6886,-0.375609},
                    {-3.86151,-0.375609},{-3.86151,0},{0,0}}, color={0,0,255}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(points={{-39.5,
                    25},{-34,25},{-34,4.43659},{-29.9311,4.43659}}, color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(points={{-39.5,-25.0001},
                    {-34,-25.0001},{-34,-5.1878},{-29.9311,-5.1878}}, color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(points={{-26.0689,
                    10.2112},{-26.0689,14},{-56,14},{-56,21},{-51,21}}, color={0,0,127}));
            connect(order3_Inputs_Outputs1.pm0, add32.u1) annotation (Line(points={{-26.0689,
                    -10.9624},{-26.0689,-16},{-56,-16},{-56,-21},{-51.0001,-21}}, color={
                    0,0,127}));
            annotation (Documentation,experiment(StopTime=20));
          end Order3test2_perturbation;

          model Order3test2_TG
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              V_b=400,
              V_0=1,
              angle_0=0,
              Sn=20,
              Vn=400,
              ra=0.01,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(visible=true,
                  transformation(
                  origin={-29.9999,0},
                  extent={{-10.0001,-10},{9.99991,10}},
                  rotation=0)));
            OpenIPSL.Electrical.Controls.PSAT.TG.TGtypeII TGtypeII1 annotation
              (Placement(visible=true, transformation(
                  origin={-63,-5},
                  extent={{-9,-9},{9,9}},
                  rotation=0)));
          equation
            connect(TGtypeII1.pm, order3_Inputs_Outputs1.pm) annotation (Line(points={{-53.1,-5},{-42,-5}},
                                                     color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, order3_Inputs_Outputs1.vf) annotation (
                Line(points={{-38,11},{-38,16},{-48,16},{-48,6},{-48,5},{-42,5}}, color={
                    0,0,127}));
            connect(order3_Inputs_Outputs1.pm0, TGtypeII1.pm0) annotation (Line(points={{-38,-11},{-38,-28},{-86,-28},{-86,10},{-63,10},{-63,5.8}},
                  color={0,0,127}));
            connect(order3_Inputs_Outputs1.p, bus.p)
              annotation (Line(points={{-20,0},{-20,0},{0,0}}, color={0,0,255}));
            connect(order3_Inputs_Outputs1.w, TGtypeII1.w) annotation (Line(points={{-19,9},{-16,9},{-16,22},{-80,22},{-80,-5},{-73.8,-5}}, color={0,0,127}));
            annotation (Documentation,experiment(StopTime=20));
          end Order3test2_TG;

          model Order3test2_AVR
            extends Modelica.Icons.Example;
            extends OpenIPSL.Examples.BaseTest;
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              V_b=400,
              V_0=1,
              angle_0=0,
              Sn=20,
              Vn=400,
              ra=0.01,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(visible=true,
                  transformation(
                  origin={-30,0},
                  extent={{-9.99992,-10},{10,10}},
                  rotation=0)));
            OpenIPSL.Electrical.Controls.PSAT.AVR.AVRtypeIII AVRtypeIII1
              annotation (Placement(visible=true, transformation(
                  origin={-68,0},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            Modelica.Blocks.Sources.Constant const(k=0)
              annotation (Placement(transformation(extent={{-98,-4},{-90,4}})));
          equation
            connect(order3_Inputs_Outputs1.p, bus.p)
              annotation (Line(points={{-20,0},{-20,0},{0,0}}, color={0,0,255}));
            connect(AVRtypeIII1.vf, order3_Inputs_Outputs1.vf) annotation (Line(points={{
                    -57.1667,0},{-50.5,0},{-50.5,5},{-41.9999,5}}, color={0,0,127}));
            connect(AVRtypeIII1.v, order3_Inputs_Outputs1.v) annotation (Line(points={{-77.1667,
                    5},{-88,5},{-88,22},{-15,22},{-15,3},{-19,3}}, color={0,0,127}));
            connect(order3_Inputs_Outputs1.pm0, order3_Inputs_Outputs1.pm) annotation (
                Line(points={{-37.9999,-11},{-37.9999,-14},{-47,-14},{-47,-5},{-41.9999,-5}},
                  color={0,0,127}));
            connect(AVRtypeIII1.vf0, order3_Inputs_Outputs1.vf0) annotation (Line(points=
                    {{-68,9.16667},{-68,16},{-37.9999,16},{-37.9999,11}},color={0,0,127}));
            connect(AVRtypeIII1.vs, const.y) annotation (Line(points={{-77.1667,-5},{-86,
                    -5},{-86,0},{-89.6,0}}, color={0,0,127}));
            annotation (Documentation,experiment(StopTime=20));
          end Order3test2_AVR;

          model Order4test2
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order4 Generator(
              Sn=100,
              Vn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              ra=0.001,
              M=10,
              D=0,
              x1d=0.302,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(transformation(extent=
                      {{-60,-20},{-20,20}})));
          equation
            connect(Generator.vf0, Generator.vf) annotation (Line(points={{-56,22},{-56,
                    28},{-76,28},{-76,10},{-64,10}}, color={0,0,127}));
            connect(Generator.pm, Generator.pm0) annotation (Line(points={{-64,-10},{-72,
                    -10},{-72,-18},{-72,-28},{-56,-28},{-56,-22}}, color={0,0,127}));
            connect(Generator.p, bus.p)
              annotation (Line(points={{-20,0},{-20,0},{0,0}}, color={0,0,255}));
            annotation (experiment(StopTime=20), Documentation);
          end Order4test2;

          model Order4test2_perturbation
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order4 Generator(
              Sn=100,
              Vn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              ra=0.001,
              M=10,
              D=0,
              x1d=0.302,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(transformation(extent=
                      {{-26,-10},{-6,10}})));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45,25},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-74.9999,35},
                  extent={{-4.99992,-5.00001},{4.99991,5.00002}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-95,55},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-95,35},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-95,20},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-75,15},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-95,5},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-95,-75},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-75,-65},
                  extent={{-4.99999,-4.99999},{4.99999,4.99999}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-95,-55},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-95,-35},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-95,-15},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-75,-25},
                  extent={{-5,-5},{5,5}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45,-25},
                  extent={{-5.00007,-5.00012},{5.00001,4.99999}},
                  rotation=0)));
          equation
            connect(Generator.p, bus.p) annotation (Line(points={{-6,0},{-4.25,0},{-4.25,
                    0},{0,0}}, color={0,0,255}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-86.308,-30.9083},
                points={{-3.192,-4.0917},{2.3974,-4.0917},{2.3974,2.9083},{5.308,2.9083}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-86.308,-19.6146},
                points={{-3.192,4.6146},{2.3974,4.6146},{2.3974,-2.3854},{5.308,-2.3854}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(points={{-69.5,35},{-60,35},{-60,
                    29},{-51,29}}, color={0,0,127}));
            connect(add2.y, add31.u2) annotation (Line(points={{-69.5,15},{-60,15},{-60,
                    25},{-51,25}}, color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(points={{-89.5,35},{-87,35},{-87,
                    32},{-80.9998,32}}, color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(points={{-89.5,55},{-87,55},{-87,
                    38},{-80.9998,38}}, color={0,0,127}));
            connect(sine2.y, add2.u2) annotation (Line(points={{-89.5,5},{-86,5},{-86,12},
                    {-81,12}}, color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(points={{-89.5,20},{-86,20},{-86,
                    18},{-81,18}}, color={0,0,127}));
            connect(add4.y, add32.u2) annotation (Line(points={{-69.5,-25},{-60,-25},{-60,
                    -25.0001},{-51.0001,-25.0001}}, color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(points={{-89.5,-55},{-85,-55},{-85,
                    -62},{-81,-62}}, color={0,0,127}));
            connect(sine3.y, add3.u2) annotation (Line(points={{-89.5,-75},{-85,-75},{-85,
                    -68},{-81,-68}}, color={0,0,127}));
            connect(add3.y, add32.u3) annotation (Line(points={{-69.5,-65},{-60,-65},{-60,
                    -29.0001},{-51.0001,-29.0001}}, color={0,0,127}));
            connect(add31.y, Generator.vf) annotation (Line(points={{-39.5,25},{-35,25},{
                    -35,5},{-28,5}}, color={0,0,127}));
            connect(add32.y, Generator.pm) annotation (Line(points={{-39.5,-25.0001},{-35,
                    -25.0001},{-35,-5},{-28,-5}}, color={0,0,127}));
            connect(Generator.vf0, add31.u3) annotation (Line(points={{-24,11},{-24,14},{
                    -55,14},{-55,21},{-51,21}}, color={0,0,127}));
            connect(Generator.pm0, add32.u1) annotation (Line(points={{-24,-11},{-24,-16},
                    {-54,-16},{-54,-21},{-51.0001,-21}}, color={0,0,127}));
            annotation (
              Diagram(coordinateSystem(
                  extent={{-100,-100},{100,100}},
                  preserveAspectRatio=false,
                  initialScale=0.1,
                  grid={1,1})),
              experiment(StopTime=20),
              Documentation);
          end Order4test2_perturbation;

          model Order4test2_TG
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Controls.PSAT.TG.TGtypeII TGtypeII1 annotation
              (Placement(visible=true, transformation(
                  origin={-72.5,-7.5},
                  extent={{-12.5,-12.5},{12.5,12.5}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order4 Generator(
              V_b=200,
              V_0=1,
              angle_0=0,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              Sn=370,
              Vn=200,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(transformation(extent=
                      {{-40,-15},{-10,15}})));
          equation
            connect(Generator.p, bus.p) annotation (Line(points={{-10,0},{-4.25,0},{-4.25,
                    0},{0,0}}, color={0,0,255}));
            connect(TGtypeII1.pm, Generator.pm) annotation (Line(points={{-58.75,-7.5},{-43,-7.5}},
                                       color={0,0,127}));
            connect(Generator.pm0, TGtypeII1.pm0) annotation (Line(points={{-37,-16.5},{-37,-25},{-50,-25},{-50,15},{-72.5,15},{-72.5,7.5}},
                                                                     color={0,0,127}));
            connect(Generator.vf0, Generator.vf) annotation (Line(points={{-37,16.5},{-37,
                    20},{-45,20},{-45,7.5},{-43,7.5}}, color={0,0,127}));
            connect(Generator.w, TGtypeII1.w) annotation (Line(points={{-8.5,13.5},{-4,13.5},{-4,26},{-92,26},{-92,-7.5},{-87.5,-7.5}}, color={0,0,127}));
            annotation (Documentation,experiment(StopTime=20));
          end Order4test2_TG;

          model Order4test2_AVR
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Controls.PSAT.AVR.AVRtypeIII AVRtypeIII1
              annotation (Placement(visible=true, transformation(
                  origin={-67,5},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order4 order4_Inputs_Outputs(
              V_b=200,
              V_0=1,
              angle_0=0,
              Sn=370,
              Vn=200,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(transformation(extent=
                      {{-37,-10},{-17,10}})));
            Modelica.Blocks.Sources.Constant const(k=0)
              annotation (Placement(transformation(extent={{-97,-4},{-87,6}})));
          equation
            connect(AVRtypeIII1.vf, order4_Inputs_Outputs.vf) annotation (Line(
                points={{-56.1667,5},{-47,5},{-47,5},{-39,5}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(const.y, AVRtypeIII1.vs) annotation (Line(points={{-86.5,1},{-81,1},{
                    -81,0},{-76.1667,0}}, color={0,0,127}));
            connect(AVRtypeIII1.v, order4_Inputs_Outputs.v) annotation (Line(points={{-76.1667,
                    10},{-87,10},{-87,20},{-10,20},{-10,3},{-16,3}}, color={0,0,127}));
            connect(order4_Inputs_Outputs.pm0, order4_Inputs_Outputs.pm) annotation (Line(
                  points={{-35,-11},{-35,-13},{-41,-13},{-41,-5},{-39,-5}}, color={0,0,
                    127}));
            connect(order4_Inputs_Outputs.p, bus.p)
              annotation (Line(points={{-17,0},{-8,0},{-8,0},{0,0}}, color={0,0,255}));
            connect(AVRtypeIII1.vf0, order4_Inputs_Outputs.vf0) annotation (Line(points={
                    {-67,14.1667},{-67,23},{-35,23},{-35,11}},color={0,0,127}));
            annotation (Documentation,experiment(StopTime=20));
          end Order4test2_AVR;

          model Order5test2
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order5_Type1 order5Type1_Inputs_Outputs(
              Sn=370,
              Vn=200,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              V_b=400,
              V_0=1,
              angle_0=0,
              P_0=16.0352698692006,
              Q_0=11.859436505981,
              xd=1.9,
              xq=1.7,
              x1q=0.5,
              T1d0=8,
              T1q0=0.8,
              T2q0=0.02) annotation (Placement(transformation(extent={{-32,-10},
                      {-12,10}})));
          equation
            connect(order5Type1_Inputs_Outputs.vf, order5Type1_Inputs_Outputs.vf0)
              annotation (Line(points={{-34,5},{-37,5},{-37,15},{-30,15},{-30,11}},color=
                    {0,0,127}));
            connect(order5Type1_Inputs_Outputs.pm, order5Type1_Inputs_Outputs.pm0)
              annotation (Line(points={{-34,-5},{-37,-5},{-37,-15},{-30,-15},{-30,-11}},
                  color={0,0,127}));
            connect(order5Type1_Inputs_Outputs.p, bus.p)
              annotation (Line(points={{-12,0},{-6,0},{-6,0},{0,0}}, color={0,0,255}));
            annotation (
              Diagram(coordinateSystem(
                  extent={{-100,-100},{100,100}},
                  preserveAspectRatio=false,
                  initialScale=0.1,
                  grid={1,1})),
              experiment(StopTime=20),
              Documentation);
          end Order5test2;

          model Order6test2
            extends OpenIPSL.Examples.BaseTest;
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order6 order6Type2_1(
              Sn=100,
              V_0=1,
              angle_0=0,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              V_b=400,
              Vn=20,
              xd=1.9,
              xq=1.7,
              x1q=0.5,
              x2d=0.204,
              x2q=0.3,
              T1d0=8,
              T1q0=0.8,
              T2d0=0.04,
              T2q0=0.02,
              Taa=2e-3,
              P_0=16.0352698692006,
              Q_0=11.859436505981) annotation (Placement(transformation(extent=
                      {{-61,-20},{-21,20}})));
          equation
            connect(order6Type2_1.vf0, order6Type2_1.vf) annotation (Line(points={{-57,22},
                    {-57,25},{-71,25},{-71,10},{-65,10}}, color={0,0,127}));
            connect(order6Type2_1.pm, order6Type2_1.pm0) annotation (Line(points={{-65,-10},
                    {-71,-10},{-71,-25},{-57,-25},{-57,-22}}, color={0,0,127}));
            connect(order6Type2_1.p, bus.p)
              annotation (Line(points={{-21,0},{-10,0},{-10,0},{0,0}}, color={0,0,255}));
            annotation (
              Diagram(coordinateSystem(
                  extent={{-100,-100},{100,100}},
                  preserveAspectRatio=false,
                  initialScale=0.1,
                  grid={1,1})),
              experiment(StopTime=20),
              Documentation);
          end Order6test2;

          model InductiveMotorI_SIMBOpenline_Test
            "Order 1 inductive machine from PSAT, line opened at 2 s for 1 s"
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.MotorTypeI motorTypeI(
              Sup=0,
              V_0=1.0336,
              angle_0=-0.02173,
              P_0=0.5,
              Q_0=0.286) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={70,0})));
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              G=0,
              B=0,
              R=0.01,
              X=0.1) annotation (Placement(transformation(
                  extent={{-10,-10},{10,9.99999}},
                  rotation=180,
                  origin={0,-20})));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              G=0,
              B=0,
              R=0.01,
              X=0.1,
              t1=2,
              t2=3,
              opening=1) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={0,20})));
            OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus(V_0=1.05, angle_0
                =0) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-70,0})));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{-100,80},{-40,100}})));
          equation
            connect(infiniteBus.p, pwLine2.n) annotation (Line(
                points={{-60,0},{-40.175,0},{-40.175,20},{-9,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine1.n, infiniteBus.p) annotation (Line(
                points={{-9,-20},{-40,-20},{-40,0},{-60,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine2.p, motorTypeI.p) annotation (Line(
                points={{9,20},{40,20},{40,0},{60,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine1.p, motorTypeI.p) annotation (Line(
                points={{9,-20},{40,-20},{40,1.33227e-15},{60,1.33227e-15}},
                color={0,0,255},
                smooth=Smooth.None));
            annotation (Documentation,experiment(StopTime=20));
          end InductiveMotorI_SIMBOpenline_Test;

          model InductiveMotorIII_SIMBOpenline_Test
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.MotorTypeIII motorTypeI(
              Sup=0,
              V_0=1.0336,
              angle_0=-0.02173,
              P_0=0.251061717038311,
              Q_0=0.226568616630697) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={70,0})));
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              G=0,
              R=0.01,
              X=0.1,
              B=1e-3) annotation (Placement(transformation(
                  extent={{-10,-10},{10,9.99999}},
                  rotation=180,
                  origin={0,-20})));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              G=0,
              R=0.01,
              X=0.1,
              t1=2,
              t2=3,
              B=1e-3,
              opening=1) annotation (Placement(transformation(
                  extent={{-10,-9.99992},{10,10.0001}},
                  rotation=180,
                  origin={0,20.0001})));
            OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus(V_0=1.05, angle_0
                =0) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-70,0})));
            inner OpenIPSL.Electrical.SystemBase SysData(fn=60) annotation (
                Placement(transformation(extent={{-100,80},{-40,100}})));
          equation
            connect(infiniteBus.p, pwLine2.n) annotation (Line(
                points={{-60,0},{-40.175,0},{-40.175,20},{-9,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine2.p, motorTypeI.p)
              annotation (Line(points={{9,20},{40,20},{40,0},{60,0}}, color={0,0,255}));
            connect(pwLine1.p, motorTypeI.p) annotation (Line(points={{9,-20},{40,-20},{
                    40,0},{60,0}}, color={0,0,255}));
            connect(pwLine1.n, pwLine2.n) annotation (Line(points={{-9,-20},{-40,-20},{-40,
                    0},{-40.175,0},{-40.175,20},{-9,20}}, color={0,0,255}));
            annotation (Documentation,experiment(StopTime=20));
          end InductiveMotorIII_SIMBOpenline_Test;

          model InductiveMotorV_SIMBOpenline_Test
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.MotorTypeV motorTypeI(
              Sup=0,
              V_0=1.0336,
              angle_0=-0.02173,
              P_0=0.251061717038311,
              Q_0=0.226568616630697) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={70,0})));
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              G=0,
              B=0,
              R=0.01,
              X=0.1) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={0,-20})));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              G=0,
              B=0,
              R=0.01,
              X=0.1,
              t1=2,
              t2=3,
              opening=1) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=180,
                  origin={0,20})));
            OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus(V_0=1.05, angle_0
                =0) annotation (Placement(transformation(
                  extent={{-10,-10},{10,10}},
                  rotation=0,
                  origin={-70,0})));
            inner OpenIPSL.Electrical.SystemBase SysData(fn=60) annotation (
                Placement(transformation(extent={{-100,80},{-40,100}})));
          equation
            connect(pwLine1.n, infiniteBus.p) annotation (Line(
                points={{-9,-20},{-40,-20},{-40,0},{-60,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine2.n, infiniteBus.p) annotation (Line(points={{-9,20},{-40,20},{
                    -40,0},{-60,0},{-60,0}}, color={0,0,255}));
            connect(pwLine2.p, motorTypeI.p) annotation (Line(points={{9,20},{40,20},{40,
                    0},{60,0},{60,1.33227e-15}}, color={0,0,255}));
            connect(pwLine1.p, motorTypeI.p) annotation (Line(points={{9,-20},{40,-20},{
                    40,0},{60,0},{60,1.22125e-15}}, color={0,0,255}));
            annotation (Documentation,experiment(StopTime=20));
          end InductiveMotorV_SIMBOpenline_Test;
        annotation (Documentation);
        end PSAT;
      annotation (Documentation);
      end Machines;

      package Controls
      extends Modelica.Icons.ExamplesPackage;

        package PSSE
        extends Modelica.Icons.ExamplesPackage;

          package ES
          extends Modelica.Icons.ExamplesPackage;

            model EXAC2 "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.EXAC2 eXAC2_1(
                K_B=2,
                K_H=2,
                K_A=400,
                T_A=0.02,
                V_AMAX=9,
                V_AMIN=-5.34,
                T_E=0.8,
                K_F=0.03,
                T_F=1,
                K_C=0.2,
                K_D=0.48,
                K_E=1,
                E_1=5.25,
                E_2=7,
                S_EE_1=0.03,
                S_EE_2=0.1,
                T_R=0.005,
                T_B=0.005,
                T_C=0.005,
                V_RMAX=4,
                V_RMIN=-4,
                K_L=1,
                V_LR=10) annotation (Placement(transformation(extent={{-54,-52},
                        {-100,-30}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-4,-4},{4,4}},
                    rotation=180,
                    origin={-44,-44})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(gENROE.EFD0, eXAC2_1.EFD0) annotation (Line(points={{-58,-10},{-48,-10},
                      {-48,-47.7222},{-54,-47.7222}}, color={0,0,127}));
              connect(gENROE.XADIFD, eXAC2_1.XADIFD) annotation (Line(points={{-58.4,-18},{
                      -50,-18},{-50,-44.0556},{-54.23,-44.0556}}, color={0,0,127}));
              connect(gENROE.ETERM, eXAC2_1.ECOMP) annotation (Line(points={{-58,-6},{-46,-6},
                      {-46,-39.7778},{-54,-39.7778}}, color={0,0,127}));
              connect(eXAC2_1.EFD, gENROE.EFD) annotation (Line(points={{-101.15,-39.7778},
                      {-110,-39.7778},{-110,-10},{-104,-10}},color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              connect(eXAC2_1.VOTHSG, const.y) annotation (Line(points={{-54,-34.2778},{-51.1437,
                      -34.2778},{-51.1437,-44},{-48.4,-44}}, color={0,0,127}));
              connect(eXAC2_1.VUEL, const.y) annotation (Line(points={{-62.05,-52},{-50,-52},
                      {-50,-44},{-48.4,-44}}, color={0,0,127}));
              connect(eXAC2_1.VOEL, const.y) annotation (Line(points={{-68.95,-52},{-50,-52},
                      {-50,-44},{-48.4,-44}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end EXAC2;

            model ESAC2A "SMIB model example of GENROU with Excitation System ESAC2A"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROU generator(
                Xppd=0.2,
                Xppq=0.2,
                Xpp=0.2,
                Xl=0.12,
                V_0=1,
                P_0=100*0.399999529123306,
                angle_0=4.04626655578613,
                Q_0=100*0.0541657134890556,
                M_b=100,
                Tpd0=5,
                Tppd0=0.50000E-01,
                Tppq0=0.1,
                H=4.0000,
                D=0,
                Xd=1.41,
                Xq=1.3500,
                Xpd=0.3,
                S10=0.1,
                S12=0.5,
                Xpq=0.6,
                Tpq0=0.7) annotation (Placement(transformation(extent={{-108,-14},
                        {-80,16}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-4,-4},{4,4}},
                    rotation=180,
                    origin={-42,-26})));
              Modelica.Blocks.Sources.Constant const2(k=0)
                annotation (Placement(transformation(extent={{-110,166},{-94,182}})));
              Modelica.Blocks.Sources.Constant const4(k=1000) annotation (Placement(
                    transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=180,
                    origin={-41,-45})));
              Modelica.Blocks.Sources.Constant const5(k=-1000) annotation (Placement(
                    transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=180,
                    origin={-41,-61})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESAC2A eSAC2A(
                V_RMAX=4,
                V_RMIN=-4,
                V_FEMAX=10) annotation (Placement(transformation(extent={{-74,-70},
                        {-144,-24}})));
            equation
              connect(eSAC2A.EFD0, generator.EFD0) annotation (Line(
                  points={{-74,-61.0556},{-60,-61.0556},{-60,-6.5},{-78.6,-6.5}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(const.y, eSAC2A.VOTHSG) annotation (Line(
                  points={{-46.4,-26},{-63.25,-26},{-63.25,-32.9444},{-74,-32.9444}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.XADIFD, eSAC2A.XADIFD) annotation (Line(
                  points={{-78.88,-12.5},{-56,-12.5},{-56,-53.3889},{-74,-53.3889}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(eSAC2A.VOEL, const4.y) annotation (Line(
                  points={{-96.75,-70},{-58.6875,-70},{-58.6875,-45},{-46.5,-45}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(const5.y, eSAC2A.VUEL) annotation (Line(
                  points={{-46.5,-61},{-54,-61},{-54,-70},{-86.25,-70}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.PELEC, eSAC2A.ECOMP) annotation (Line(
                  points={{-78.6,5.5},{-64,5.5},{-64,-44.4444},{-74,-44.4444}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.PMECH0, generator.PMECH) annotation (Line(
                  points={{-78.6,8.5},{-74,8.5},{-74,20},{-110,20},{-110,8.5},{-110.8,8.5}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(eSAC2A.EFD, generator.EFD) annotation (Line(points={{-145.75,-44.4444},
                      {-150,-44.4444},{-150,-6.5},{-110.8,-6.5}}, color={0,0,127}));
              connect(generator.p, GEN1.p) annotation (Line(points={{-80,1},{-58.3,1},{-58.3,
                      0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ESAC2A;

            model ESST4B "SMIB model example of GENROU with Excitation System ESST4B"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROU generator(
                Xppd=0.2,
                Xppq=0.2,
                Xpp=0.2,
                Xl=0.12,
                V_0=1,
                P_0=100*0.399999529123306,
                angle_0=4.04626655578613,
                Q_0=100*0.0541657134890556,
                M_b=100,
                Tpd0=5,
                Tppd0=0.50000E-01,
                Tppq0=0.1,
                H=4.0000,
                D=0,
                Xd=1.41,
                Xq=1.3500,
                Xpd=0.3,
                S10=0.1,
                S12=0.5,
                Xpq=0.6,
                Tpq0=0.7) annotation (Placement(transformation(extent={{-120,-16},
                        {-92,18}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-4,-4},{4,4}},
                    rotation=0,
                    origin={-98,-52})));
              Modelica.Blocks.Sources.Constant const2(k=0)
                annotation (Placement(transformation(extent={{-110,166},{-94,182}})));
              Modelica.Blocks.Sources.Constant const5(k=0) annotation (Placement(
                    transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=0,
                    origin={-97,-37})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESST4B eSST4B annotation (
                  Placement(transformation(
                    extent={{-14,-10},{14,10}},
                    rotation=0,
                    origin={-64,-4})));
              inner Electrical.SystemBase SysData
                annotation (Placement(transformation(extent={{-100,80},{-40,100}})));
              Modelica.Blocks.Sources.Constant const1(k=Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-40,-48},{-56,-32}})));
            equation
              connect(generator.p, eSST4B.Gen_terminal) annotation (Line(
                  points={{-92,1},{-66.7,1},{-66.7,4.33333},{-75.9,4.33333}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(const.y, eSST4B.VOTHSG) annotation (Line(
                  points={{-93.6,-52},{-86,-52},{-86,2.11111},{-78,2.11111}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, eSST4B.EFD0) annotation (Line(
                  points={{-90.6,-7.5},{-90,-7.5},{-90,-10.1111},{-78,-10.1111}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(const5.y, eSST4B.VUEL) annotation (Line(
                  points={{-91.5,-37},{-84,-37},{-84,-14},{-73.1,-14}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.PMECH0, generator.PMECH) annotation (Line(
                  points={{-90.6,9.5},{-70,9.5},{-70,22},{-102,22},{-102,9.5},{-122.8,9.5}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(eSST4B.EFD, generator.EFD) annotation (Line(
                  points={{-49.3,-2.88889},{-48,-2.88889},{-48,-24},{-124,-24},{-124,-7.5},
                      {-122.8,-7.5}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.XADIFD, eSST4B.XADIFD) annotation (Line(
                  points={{-90.88,-14.3},{-90.88,-20},{-94,-20},{-94,-6.77778},{-78,-6.77778}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(generator.PELEC, eSST4B.ECOMP) annotation (Line(
                  points={{-90.6,6.1},{-68,6.1},{-68,-2.88889},{-78,-2.88889}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(eSST4B.Bus, GEN1.p) annotation (Line(points={{-52.1,4.33333},{-47.5818,
                      4.33333},{-47.5818,0},{-40,0}}, color={0,0,255}));
              connect(const1.y, eSST4B.VOEL) annotation (Line(points={{-56.8,-40},{-68.9,-40},
                      {-68.9,-14}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ESST4B;

            model URST5T "SMIB model example of GENROU with Excitation System URST5T"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROU generator(
                Xppd=0.2,
                Xppq=0.2,
                Xpp=0.2,
                Xl=0.12,
                V_0=1,
                P_0=100*0.399999529123306,
                angle_0=4.04626655578613,
                Q_0=100*0.0541657134890556,
                M_b=100,
                Tpd0=5,
                Tppd0=0.50000E-01,
                Tppq0=0.1,
                H=4.0000,
                D=0,
                Xd=1.41,
                Xq=1.3500,
                Xpd=0.3,
                S10=0.1,
                S12=0.5,
                Xpq=0.6,
                Tpq0=0.7) annotation (Placement(transformation(extent={{-104,-16},
                        {-76,18}})));
              Modelica.Blocks.Sources.Constant const2(k=0)
                annotation (Placement(transformation(extent={{-110,166},{-94,182}})));
              Modelica.Blocks.Sources.Constant VOEL(k=1000) annotation (Placement(
                    transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=0,
                    origin={-87,-67})));
              OpenIPSL.Electrical.Controls.PSSE.ES.URST5T uRST5T annotation (
                  Placement(transformation(extent={{-56,-40},{-34,-20}})));
              Modelica.Blocks.Sources.Constant VUEL(k=-1000) annotation (Placement(
                    transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=0,
                    origin={-73,-81})));
              Modelica.Blocks.Sources.Constant VOTHSG(k=0) annotation (Placement(
                    transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=0,
                    origin={-73,-55})));
              inner Electrical.SystemBase SysData
                annotation (Placement(transformation(extent={{-100,80},{-40,100}})));
            equation
              connect(VUEL.y, uRST5T.VUEL) annotation (Line(
                  points={{-67.5,-81},{-58.25,-81},{-58.25,-40},{-52.15,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(VOEL.y, uRST5T.VOEL) annotation (Line(
                  points={{-81.5,-67},{-60,-67},{-60,-40},{-48.85,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(VOTHSG.y, uRST5T.VOTHSG) annotation (Line(
                  points={{-67.5,-55},{-62,-55},{-62,-23.8889},{-56,-23.8889}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.XADIFD, uRST5T.XADIFD) annotation (Line(
                  points={{-74.88,-14.3},{-74.88,-32.7778},{-56,-32.7778}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, uRST5T.EFD0) annotation (Line(
                  points={{-74.6,-7.5},{-64,-7.5},{-64,-36.1111},{-56,-36.1111}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.PMECH0, generator.PMECH) annotation (Line(
                  points={{-74.6,9.5},{-70,9.5},{-70,22},{-104,22},{-104,9.5},{-106.8,9.5}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(generator.PELEC, uRST5T.ECOMP) annotation (Line(
                  points={{-74.6,6.1},{-66,6.1},{-66,-28.8889},{-56,-28.8889}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(uRST5T.EFD, generator.EFD) annotation (Line(
                  points={{-33.45,-28.8889},{-14,-28.8889},{-14,-44},{-104,-44},{-104,-7.5},
                      {-106.8,-7.5}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.p, GEN1.p) annotation (Line(points={{-76,1},{-57.3,1},{-57.3,
                      0},{-40,0}}, color={0,0,255}));
              connect(uRST5T.VT, uRST5T.ECOMP) annotation (Line(points={{-56,-26.1111},{-58,
                      -26.1111},{-58,-26},{-60,-26},{-60,-28.8889},{-56,-28.8889}}, color={
                      0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end URST5T;

            model SEXS "SMIB model example of GENROU with Excitation System EXST1"
              extends OpenIPSL.Examples.SMIBpartial;
              Modelica.Blocks.Sources.Constant const2(k=0)
                annotation (Placement(transformation(extent={{-110,166},{-94,182}})));
              OpenIPSL.Electrical.Machines.PSSE.GENROU gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2,
                R_a=0,
                Xpp=0.2,
                H=4.28) annotation (Placement(transformation(extent={{-110,-20},
                        {-70,20}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.SEXS sEXS(
                T_AT_B=0.1,
                T_B=1,
                K=100,
                T_E=0.1,
                E_MIN=-10,
                E_MAX=10) annotation (Placement(transformation(extent={{-70,-54},
                        {-108,-26}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{4,-4},{-4,4}},
                    rotation=0,
                    origin={-50,-40})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-114,10},{-114,
                      10},{-114,26},{-60,26},{-60,10},{-68,10}}, color={0,0,127}));
              connect(gENROE.EFD0, sEXS.EFD0) annotation (Line(points={{-68,-10},{-60,-10},{-60,-48.5556},{-70,-48.5556}},
                                                     color={0,0,127}));
              connect(gENROE.ETERM, sEXS.ECOMP) annotation (Line(points={{-68,-6},{-64,-6},{-64,-38.4444},{-70,-38.4444}},
                                                     color={0,0,127}));
              connect(sEXS.VOEL, const.y) annotation (Line(points={{-82.35,-54},{-68,-54},{
                      -68,-40},{-54.4,-40}}, color={0,0,127}));
              connect(sEXS.VOTHSG, const.y) annotation (Line(points={{-70,-31.4444},{-64,-31.4444},{-64,-40},{-54.4,-40}},
                                              color={0,0,127}));
              connect(sEXS.VUEL, const.y) annotation (Line(points={{-76.65,-54},{-64,-54},{
                      -64,-40},{-54.4,-40}}, color={0,0,127}));
              connect(sEXS.EFD, gENROE.EFD) annotation (Line(points={{-108.95,-38.4444},{-114,-38.4444},{-114,-10},{-114,-10}},
                                                        color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-70,0},{-40,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, sEXS.XADIFD) annotation (Line(points={{-68.4,-18},{-62,-18},{-62,-60},{-97.55,-60},{-97.55,-53.6889}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-120,-100},{
                        120,100}})),
                Documentation,
                Icon(coordinateSystem(extent={{-120,-100},{120,100}})),
                experiment(StopTime=10));
            end SEXS;

            model SCRX "SMIB model example of GENROU with Excitation System EXST1"
              extends OpenIPSL.Examples.SMIBpartial;
              Modelica.Blocks.Sources.Constant const2(k=0)
                annotation (Placement(transformation(extent={{-110,166},{-94,182}})));
              OpenIPSL.Electrical.Machines.PSSE.GENROU gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2,
                R_a=0,
                Xpp=0.2,
                H=4.28) annotation (Placement(transformation(extent={{-112,-20},
                        {-72,20}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{4,-4},{-4,4}},
                    rotation=0,
                    origin={-52,-36})));
              OpenIPSL.Electrical.Controls.PSSE.ES.SCRX sCRX(
                T_AT_B=0.1,
                T_B=1,
                K=100,
                E_MIN=-10,
                E_MAX=10,
                C_SWITCH=false,
                r_cr_fd=0,
                T_E=0.005) annotation (Placement(transformation(extent={{-74,-58},
                        {-108,-30}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-116,10},{-116,
                      10},{-116,26},{-62,26},{-62,10},{-70,10}}, color={0,0,127}));
              connect(sCRX.EFD, gENROE.EFD) annotation (Line(points={{-108.85,-42.4444},{-116,-42.4444},{-116,-10},{-116,-10}},
                                                        color={0,0,127}));
              connect(gENROE.ETERM, sCRX.ECOMP) annotation (Line(points={{-70,-6},{-66,-6},{-66,-42.4444},{-74,-42.4444}},
                                                     color={0,0,127}));
              connect(const.y, sCRX.VOTHSG) annotation (Line(points={{-56.4,-36},{-74,-36},{-74,-35.4444}},
                                      color={0,0,127}));
              connect(sCRX.VOEL, sCRX.VOTHSG) annotation (Line(points={{-85.05,-58},{-70,-58},{-70,-36},{-74,-36},{-74,-35.4444}},
                                                           color={0,0,127}));
              connect(sCRX.VUEL, sCRX.VOTHSG) annotation (Line(points={{-79.95,-58},{-70,-58},{-70,-36},{-74,-36},{-74,-35.4444}},
                                                           color={0,0,127}));
              connect(sCRX.XADIFD, gENROE.XADIFD) annotation (Line(points={{-98.65,-57.6889},{-64,-57.6889},{-64,-18},{-70.4,-18}},
                                                            color={0,0,127}));
              connect(sCRX.EFD0, gENROE.EFD0) annotation (Line(points={{-74,-52.5556},{-62,-52.5556},{-62,-10},{-70,-10}},
                                                      color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-72,0},{-72,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-120,-100},{
                        120,100}})),
                Documentation,
                Icon(coordinateSystem(extent={{-120,-100},{120,100}})),
                experiment(StopTime=10));
            end SCRX;

            model EXAC1 "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-56},{-40,-36}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.EXAC1 eXAC1_1(
                K_A=400,
                T_A=0.02,
                V_RMAX=9,
                V_RMIN=-5.43,
                T_E=0.8,
                K_F=0.03,
                T_F=1,
                K_C=0.2,
                K_D=0.48,
                K_E=1,
                E_1=5.25,
                E_2=7,
                S_EE_1=0.03,
                S_EE_2=0.1,
                T_R=0.004,
                T_B=0.004,
                T_C=0.004) annotation (Placement(transformation(extent={{-60,-50},
                        {-98,-24}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(eXAC1_1.EFD, gENROE.EFD) annotation (Line(points={{-98.95,-35.5556},{
                      -110,-35.5556},{-110,-10},{-104,-10}}, color={0,0,127}));
              connect(eXAC1_1.XADIFD, gENROE.XADIFD) annotation (Line(points={{-60,-40.6111},
                      {-56,-40.6111},{-56,-18},{-58.4,-18}}, color={0,0,127}));
              connect(eXAC1_1.VOTHSG, const.y) annotation (Line(points={{-60,-29.0556},{-48,
                      -29.0556},{-48,-46},{-41,-46}}, color={0,0,127}));
              connect(eXAC1_1.VUEL, const.y) annotation (Line(points={{-66.65,-50},{-48,-50},
                      {-48,-46},{-41,-46}}, color={0,0,127}));
              connect(eXAC1_1.VOEL, const.y) annotation (Line(points={{-72.35,-50},{-48,-50},
                      {-48,-46},{-41,-46}}, color={0,0,127}));
              connect(eXAC1_1.ECOMP, gENROE.ETERM) annotation (Line(points={{-60,-35.5556},
                      {-52,-35.5556},{-52,-6},{-58,-6}},color={0,0,127}));
              connect(eXAC1_1.EFD0, gENROE.EFD0) annotation (Line(points={{-60,-44.9444},{-54,
                      -44.9444},{-54,-10},{-58,-10}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end EXAC1;

            model EXST1 "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-56},{-40,-36}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.EXST1 eXST1_1(
                V_IMAX=10,
                V_IMIN=-10,
                T_R=0.02,
                T_B=1,
                K_A=80,
                T_A=0.05,
                V_RMAX=8,
                V_RMIN=-3,
                K_C=0.2,
                K_F=0.1,
                T_F=1,
                T_C=0.1) annotation (Placement(transformation(extent={{-58,-58},
                        {-100,-28}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(eXST1_1.EFD, gENROE.EFD) annotation (Line(points={{-101.05,-41.3333},
                      {-110,-41.3333},{-110,-10},{-104,-10}},color={0,0,127}));
              connect(eXST1_1.ECOMP, gENROE.ETERM) annotation (Line(points={{-58,-41.3333},
                      {-50,-41.3333},{-50,-6},{-58,-6}},color={0,0,127}));
              connect(const.y, eXST1_1.VOEL) annotation (Line(points={{-41,-46},{-71.65,-46},
                      {-71.65,-58}}, color={0,0,127}));
              connect(eXST1_1.VOTHSG, eXST1_1.VOEL) annotation (Line(points={{-58,-33.8333},
                      {-50,-33.8333},{-50,-46},{-71.65,-46},{-71.65,-58}}, color={0,0,127}));
              connect(eXST1_1.VUEL, eXST1_1.VOEL) annotation (Line(points={{-65.35,-58},{-50,
                      -58},{-50,-46},{-71.65,-46},{-71.65,-58}}, color={0,0,127}));
              connect(eXST1_1.XADIFD, gENROE.XADIFD) annotation (Line(points={{-58,-47.1667},
                      {-54,-47.1667},{-54,-18},{-58.4,-18}}, color={0,0,127}));
              connect(eXST1_1.EFD0, gENROE.EFD0) annotation (Line(points={{-58,-52.1667},{-58,
                      -60},{-48,-60},{-48,-10},{-58,-10}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end EXST1;

            model ESST1A "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-56},{-40,-36}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESST1A eSST1A(
                V_IMAX=0.3,
                V_IMIN=-0.3,
                T_C=2,
                T_B=10,
                T_C1=0.08,
                T_B1=0.083,
                K_A=300,
                V_AMAX=7,
                V_AMIN=-7,
                V_RMAX=5.2,
                V_RMIN=-5.2,
                K_C=0.38,
                K_F=1,
                T_F=1,
                K_LR=1,
                I_LR=0,
                T_A=0.1,
                T_R=0.1) annotation (Placement(transformation(extent={{-58,-60},
                        {-86,-34}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-20,-90},{-40,-70}})));
              Modelica.Blocks.Sources.Constant const2(k=Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-18,-120},{-38,-100}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(const1.y, eSST1A.VUEL2) annotation (Line(points={{-41,-80},{-71.307,-80},
                      {-71.307,-59.9928}}, color={0,0,127}));
              connect(eSST1A.VUEL3, eSST1A.VUEL2) annotation (Line(points={{-75.4895,-59.9964},
                      {-75.4895,-80},{-71.307,-80},{-71.307,-59.9928}}, color={0,0,127}));
              connect(const2.y, eSST1A.VOEL) annotation (Line(points={{-39,-110},{-67.1,-110},
                      {-67.1,-60}}, color={0,0,127}));
              connect(eSST1A.EFD, gENROE.EFD) annotation (Line(points={{-86.7,-45.5556},{-112,
                      -45.5556},{-112,-10},{-104,-10}}, color={0,0,127}));
              connect(gENROE.ETERM, eSST1A.ECOMP) annotation (Line(points={{-58,-6},{-52,-6},
                      {-52,-45.5556},{-58,-45.5556}}, color={0,0,127}));
              connect(eSST1A.VT, eSST1A.ECOMP) annotation (Line(points={{-58.0175,-41.9625},
                      {-52,-41.9625},{-52,-45.5556},{-58,-45.5556}}, color={0,0,127}));
              connect(eSST1A.EFD0, gENROE.EFD0) annotation (Line(points={{-58,-54.9444},{-50,
                      -54.9444},{-50,-10},{-58,-10}}, color={0,0,127}));
              connect(eSST1A.XADIFD, gENROE.XADIFD) annotation (Line(points={{-58,-50.6111},
                      {-48,-50.6111},{-48,-18},{-58.4,-18}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              connect(eSST1A.VOTHSG2, const.y) annotation (Line(points={{-58,-36.1667},{-52,
                      -36.1667},{-52,-36},{-44,-36},{-44,-46},{-41,-46}}, color={0,0,127}));
              connect(eSST1A.VOTHSG, const.y) annotation (Line(points={{-58,-39.0556},{-56,
                      -39.0556},{-56,-36},{-52,-36},{-44,-36},{-44,-46},{-41,-46}}, color={
                      0,0,127}));
              connect(eSST1A.VUEL, const.y) annotation (Line(points={{-62.9,-60},{-62,-60},
                      {-62,-64},{-44,-64},{-44,-46},{-41,-46}},color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ESST1A;

            model IEEEX1 "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-52},{-40,-32}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.IEEEX1 iEEEX1_1(
                T_R=0.04,
                K_A=75,
                T_A=0.05,
                T_B=1,
                T_C=1,
                V_RMAX=3.9,
                V_RMIN=-3.9,
                T_E=0.5,
                K_F=0.07,
                T_F1=1,
                E_1=2.47,
                S_EE_1=0.035,
                E_2=4.5,
                S_EE_2=0.47,
                K_E=0) annotation (Placement(transformation(extent={{-68,-60},{
                        -92,-38}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(iEEEX1_1.EFD, gENROE.EFD) annotation (Line(points={{-92.6,-47.7778},{-102,-47.7778},{-102,-48},{-110,-48},{-110,-10},{-104,-10}},
                                                                                   color={0,
                      0,127}));
              connect(iEEEX1_1.VOTHSG, const.y) annotation (Line(points={{-68,-42.2778},{-48.1116,-42.2778},{-48.1116,-42},{-41,-42}},
                                                           color={0,0,127}));
              connect(iEEEX1_1.EFD0, gENROE.EFD0) annotation (Line(points={{-68,-55.7222},{-54,-55.7222},{-54,-10},{-58,-10}},
                                                          color={0,0,127}));
              connect(iEEEX1_1.ECOMP, gENROE.ETERM) annotation (Line(points={{-68,-47.7778},{-52,-47.7778},{-52,-6},{-58,-6}},
                                                         color={0,0,127}));
              connect(iEEEX1_1.VOEL, const.y) annotation (Line(points={{-75.8,-60},{-48,-60},
                      {-48,-42},{-41,-42}}, color={0,0,127}));
              connect(iEEEX1_1.VUEL, const.y) annotation (Line(points={{-72.2,-60},{-48,-60},
                      {-48,-42},{-41,-42}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, iEEEX1_1.XADIFD) annotation (Line(points={{-58.4,-18},{-56,-18},{-56,-66},{-85.4,-66},{-85.4,-59.7556}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end IEEEX1;

            model ESAC1A "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-28,-58},{-38,-48}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-28,-80},{-38,-70}})));
              Modelica.Blocks.Sources.Constant const2(k=Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-28,-100},{-38,-90}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESAC1A eSAC1A(
                T_R=0.04,
                T_B=2,
                T_C=10,
                K_A=400,
                T_A=0.02,
                V_AMAX=9,
                V_AMIN=-5.34,
                T_E=0.8,
                K_F=0.03,
                T_F=1,
                K_C=0.2,
                K_D=0.48,
                K_E=1,
                E_1=5.25,
                E_2=7,
                S_EE_1=0.03,
                S_EE_2=0.1,
                V_RMAX=3,
                V_RMIN=-3) annotation (Placement(transformation(extent={{-52,-58},
                        {-106,-38}})));
              inner OpenIPSL.Electrical.SystemBase SysData annotation (
                  Placement(transformation(extent={{-100,80},{-40,100}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(eSAC1A.VOTHSG, const.y) annotation (Line(points={{-52,-41.8889},{-52,
                      -53},{-38.5,-53}}, color={0,0,127}));
              connect(gENROE.ETERM, eSAC1A.ECOMP) annotation (Line(points={{-58,-6},{-32,-6},
                      {-32,-46.8889},{-52,-46.8889}}, color={0,0,127}));
              connect(eSAC1A.EFD0, gENROE.EFD0) annotation (Line(points={{-52,-54.1111},{-52,
                      -62},{-46,-62},{-46,-10},{-58,-10}}, color={0,0,127}));
              connect(gENROE.XADIFD, eSAC1A.XADIFD) annotation (Line(points={{-58.4,-18},{-44,
                      -18},{-44,-64},{-52,-64},{-52,-50.7778}}, color={0,0,127}));
              connect(eSAC1A.EFD, gENROE.EFD) annotation (Line(points={{-107.35,-46.8889},{
                      -110,-46.8889},{-110,-10},{-104,-10}}, color={0,0,127}));
              connect(const1.y, eSAC1A.VUEL) annotation (Line(points={{-38.5,-75},{-61.45,-75},
                      {-61.45,-58}}, color={0,0,127}));
              connect(const2.y, eSAC1A.VOEL) annotation (Line(points={{-38.5,-95},{-38.5,-95},
                      {-69.55,-95},{-69.55,-58}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ESAC1A;

            model ESDC1A "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-28,-46},{-38,-36}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-28,-60},{-38,-50}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESDC1A eSDC1A(
                T_R=0.04,
                T_F1=1,
                E_1=2.47,
                S_EE_1=0.035,
                E_2=4.5,
                S_EE_2=0.47,
                K_A=75,
                T_A=0.05,
                T_B=1,
                T_C=1,
                V_RMIN=-3.9,
                K_E=0,
                T_E=0.5,
                K_F=0.07,
                V_RMAX=0) annotation (Placement(transformation(extent={{-60,-50},
                        {-100,-36}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(eSDC1A.EFD, gENROE.EFD) annotation (Line(points={{-101,-42.2222},{-106,-42.2222},{-106,-10},{-104,-10}},
                                                        color={0,0,127}));
              connect(eSDC1A.EFD0, gENROE.EFD0) annotation (Line(points={{-60,-47.2778},{-60,-58},{-48,-58},{-48,-10},{-58,-10}},
                                                           color={0,0,127}));
              connect(gENROE.ETERM, eSDC1A.ECOMP) annotation (Line(points={{-58,-6},{-54,-6},{-54,-38},{-58,-38},{-58,-42.2222},{-60,-42.2222}},
                                                                          color={0,0,127}));
              connect(eSDC1A.VOTHSG, const.y) annotation (Line(points={{-60,-38.7222},{-49.5556,-38.7222},{-49.5556,-41},{-38.5,-41}},
                                                             color={0,0,127}));
              connect(eSDC1A.VOEL, const.y) annotation (Line(points={{-73,-50},{-42,-50},{-42,
                      -41},{-38.5,-41}}, color={0,0,127}));
              connect(eSDC1A.VUEL, const1.y) annotation (Line(points={{-67,-50},{-54,-50},{
                      -54,-55},{-38.5,-55}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, eSDC1A.XADIFD) annotation (Line(points={{-58.4,-18},{-56,-18},{-56,-62},{-89,-62},{-89,-49.8444}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ESDC1A;

            model ESDC2A "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-104,-20},
                        {-64,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-32,-46},{-42,-36}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-32,-60},{-42,-50}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESDC2A eSDC2A(
                T_R=0.04,
                T_F1=1,
                E_1=2.47,
                S_EE_1=0.035,
                E_2=4.5,
                S_EE_2=0.47,
                K_A=75,
                T_A=0.05,
                T_B=1,
                T_C=1,
                V_RMIN=-3.9,
                T_E=0.5,
                K_F=0.07,
                V_RMAX=0,
                K_E=0) annotation (Placement(transformation(extent={{-62,-50},{
                        -104,-32}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-108,10},{-114,
                      10},{-114,26},{-52,26},{-52,10},{-62,10}}, color={0,0,127}));
              connect(eSDC2A.EFD, gENROE.EFD) annotation (Line(points={{-105.05,-40},{-112,
                      -40},{-112,-10},{-108,-10}}, color={0,0,127}));
              connect(gENROE.ETERM, eSDC2A.ECOMP) annotation (Line(points={{-62,-6},{-56,-6},
                      {-56,-40},{-62,-40}}, color={0,0,127}));
              connect(eSDC2A.VOTHSG, const.y) annotation (Line(points={{-62,-35.5},{-46,-35.5},
                      {-46,-41},{-42.5,-41}}, color={0,0,127}));
              connect(eSDC2A.VT, eSDC2A.ECOMP) annotation (Line(points={{-62,-43.5},{-62,-56},
                      {-56,-56},{-56,-40},{-62,-40}}, color={0,0,127}));
              connect(eSDC2A.EFD0, gENROE.EFD0) annotation (Line(points={{-62,-46.5},{-62,-54},
                      {-58,-54},{-58,-10},{-62,-10}}, color={0,0,127}));
              connect(eSDC2A.VOEL, const.y) annotation (Line(points={{-75.65,-50},{-46,-50},
                      {-46,-41},{-42.5,-41}}, color={0,0,127}));
              connect(const1.y, eSDC2A.VUEL) annotation (Line(points={{-42.5,-55},{-50,-55},
                      {-50,-50},{-69.35,-50}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-64,0},{-64,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, eSDC2A.XADIFD) annotation (Line(points={{-62.4,-18},{-54,-18},{-54,-60},{-92.45,-60},{-92.45,-49.8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ESDC2A;

            model IEEET2 "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-108,-20},
                        {-68,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-28,-50},{-48,-30}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.IEEET2 iEEET2_1(
                T_R=0.02,
                K_A=200,
                T_A=0.001,
                T_E=0.55,
                K_F=0.06,
                T_F1=0.3,
                T_F2=0.6,
                E_1=2.85,
                S_EE_1=0.3,
                E_2=3.8,
                S_EE_2=0.6,
                V_RMAX=2,
                V_RMIN=-2,
                K_E=0.1) annotation (Placement(transformation(extent={{-74,-58},
                        {-106,-32}})));
              inner OpenIPSL.Electrical.SystemBase SysData annotation (
                  Placement(transformation(extent={{-100,80},{-40,100}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-112,10},{-118,
                      10},{-118,26},{-56,26},{-56,10},{-66,10}}, color={0,0,127}));
              connect(iEEET2_1.EFD, gENROE.EFD) annotation (Line(points={{-106.8,-43.5556},{-118,-43.5556},{-118,-10},{-112,-10}},
                                                             color={0,0,127}));
              connect(iEEET2_1.ECOMP, gENROE.ETERM) annotation (Line(points={{-74,-43.5556},{-58,-43.5556},{-58,-6},{-66,-6}},
                                                         color={0,0,127}));
              connect(iEEET2_1.EFD0, gENROE.EFD0) annotation (Line(points={{-74,-52.9444},{-56,-52.9444},{-56,-10},{-66,-10}},
                                                          color={0,0,127}));
              connect(iEEET2_1.VOTHSG, const.y) annotation (Line(points={{-74,-37.0556},{-55.3333,-37.0556},{-55.3333,-40},{-49,-40}},
                                                           color={0,0,127}));
              connect(iEEET2_1.VOEL, const.y) annotation (Line(points={{-84.4,-58},{-50,-58},
                      {-50,-40},{-49,-40}}, color={0,0,127}));
              connect(iEEET2_1.VUEL, const.y) annotation (Line(points={{-79.6,-58},{-50,-58},
                      {-50,-40},{-49,-40}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-68,0},{-68,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, iEEET2_1.XADIFD) annotation (Line(points={{-66.4,-18},{-62,-18},{-62,-64},{-97.2,-64},{-97.2,-57.7111}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end IEEET2;

            model ST5B "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Controls.PSSE.ES.ST5B sT5B(
                T_R=0,
                T_C1=0.8,
                T_B1=6,
                T_C2=0.08,
                T_B2=0.01,
                T_UC1=2,
                T_UB1=10,
                T_UC2=0.1,
                T_UB2=0.05,
                T_OC1=0.1,
                T_OB1=2,
                T_OC2=0.08,
                T_OB2=0.08,
                K_C=0.004,
                T_1=0.001,
                K_R=200,
                V_RMAX=5,
                V_RMIN=-4) annotation (Placement(transformation(extent={{-64,-76},
                        {-124,-44}})));
              Modelica.Blocks.Sources.Constant PSS_off(k=0)
                annotation (Placement(transformation(extent={{-140,-102},{-128,-90}})));
              Modelica.Blocks.Sources.Constant VOEL(k=100)
                annotation (Placement(transformation(extent={{-140,-122},{-128,-110}})));
              Modelica.Blocks.Sources.Constant VUEL(k=-100)
                annotation (Placement(transformation(extent={{-140,-142},{-128,-130}})));
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-112,-20},
                        {-72,20}})));
            equation
              connect(PSS_off.y, sT5B.VOTHSG) annotation (Line(points={{-127.4,-96},{-64,-96},
                      {-64,-50.2222}}, color={0,0,127}));
              connect(VOEL.y, sT5B.VOEL) annotation (Line(points={{-127.4,-116},{-83.5,-116},
                      {-83.5,-76}}, color={0,0,127}));
              connect(VUEL.y, sT5B.VUEL) annotation (Line(points={{-127.4,-136},{-74.5,-136},
                      {-74.5,-76}}, color={0,0,127}));
              connect(gENROE.ETERM, sT5B.ECOMP) annotation (Line(points={{-70,-6},{-50,-6},
                      {-50,-58.2222},{-64,-58.2222}},color={0,0,127}));
              connect(sT5B.XADIFD, gENROE.XADIFD) annotation (Line(points={{-64,-63.5556},{
                      -60,-63.5556},{-60,-18},{-70.4,-18}}, color={0,0,127}));
              connect(sT5B.EFD0, gENROE.EFD0) annotation (Line(points={{-64,-69.7778},{-56,
                      -69.7778},{-56,-10},{-70,-10}}, color={0,0,127}));
              connect(sT5B.EFD, gENROE.EFD) annotation (Line(points={{-125.5,-58.2222},{-128,
                      -58.2222},{-128,-10},{-116,-10}}, color={0,0,127}));
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-116,10},{-128,
                      10},{-128,30},{-60,30},{-60,10},{-70,10}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-72,0},{-72,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end ST5B;

            model IEEET1 "SMIB system with one load and GENROE model"
              import iPSL = IslandedOperationControl.OpenIPSL;
              extends iPSL.Examples.SMIBpartial;
              iPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2)
                annotation (Placement(transformation(extent={{-108,-20},{-68,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-28,-50},{-48,-30}})));
              iPSL.Electrical.Controls.PSSE.ES.IEEET1 iEEET2_1(
                T_R=0.02,
                K_A=200,
                T_A=0.001,
                T_E=0.55,
                K_F=0.06,
                E_1=2.85,
                S_EE_1=0.3,
                E_2=3.8,
                S_EE_2=0.6,
                V_RMAX=2,
                V_RMIN=-2,
                K_E=0.1)
                annotation (Placement(transformation(extent={{-74,-58},{-106,-32}})));
              inner iPSL.Electrical.SystemBase SysData
                annotation (Placement(transformation(extent={{-100,80},{-40,100}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-112,10},{-118,
                      10},{-118,26},{-56,26},{-56,10},{-66,10}}, color={0,0,127}));
              connect(iEEET2_1.EFD, gENROE.EFD) annotation (Line(points={{-106.8,-43.5556},{-118,-43.5556},{-118,-10},{-112,-10}},
                                                             color={0,0,127}));
              connect(iEEET2_1.ECOMP, gENROE.ETERM) annotation (Line(points={{-74,-43.5556},{-58,-43.5556},{-58,-6},{-66,-6}},
                                                         color={0,0,127}));
              connect(iEEET2_1.EFD0, gENROE.EFD0) annotation (Line(points={{-74,-52.9444},{-56,-52.9444},{-56,-10},{-66,-10}},
                                                          color={0,0,127}));
              connect(iEEET2_1.VOTHSG, const.y) annotation (Line(points={{-74,-37.0556},{-55.3333,-37.0556},{-55.3333,-40},{-49,-40}},
                                                           color={0,0,127}));
              connect(iEEET2_1.VOEL, const.y) annotation (Line(points={{-84.4,-58},{-50,-58},
                      {-50,-40},{-49,-40}}, color={0,0,127}));
              connect(iEEET2_1.VUEL, const.y) annotation (Line(points={{-79.6,-58},{-50,-58},
                      {-50,-40},{-49,-40}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-68,0},{-68,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, iEEET2_1.XADIFD) annotation (Line(points={{-66.4,-18},{-62,-18},{-62,-66},{-97.2,-66},{-97.2,-57.7111}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end IEEET1;

            model EXNI "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-56},{-40,-36}})));
              Electrical.Controls.PSSE.ES.EXNI eXNI
                annotation (Placement(transformation(extent={{-64,-54},{-94,-26}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              connect(eXNI.VOTHSG, const.y) annotation (Line(points={{-64,-31.4444},{-60,-31.4444},
                      {-60,-32},{-41,-32},{-41,-46}}, color={0,0,127}));
              connect(eXNI.ECOMP, gENROE.ETERM) annotation (Line(points={{-64,-38.4444},{-60,
                      -38.4444},{-60,-38},{-52,-38},{-52,-6},{-58,-6}}, color={0,0,127}));
              connect(eXNI.XADIFD, gENROE.XADIFD) annotation (Line(points={{-64,-43.8889},{
                      -60,-43.8889},{-60,-44},{-60,-18},{-58.4,-18}}, color={0,0,127}));
              connect(eXNI.EFD0, gENROE.EFD0) annotation (Line(points={{-64,-48.5556},{-60,
                      -48.5556},{-60,-48},{-56,-48},{-56,-10},{-58,-10}}, color={0,0,127}));
              connect(eXNI.VUEL, const.y) annotation (Line(points={{-69.25,-54},{-70,-54},{
                      -70,-60},{-46,-60},{-46,-46},{-41,-46}}, color={0,0,127}));
              connect(eXNI.VOEL, const.y) annotation (Line(points={{-73.75,-54},{-74,-54},{
                      -74,-60},{-46,-60},{-46,-46},{-41,-46}}, color={0,0,127}));
              connect(eXNI.EFD, gENROE.EFD) annotation (Line(points={{-94.75,-38.4444},{-110,
                      -38.4444},{-110,-10},{-104,-10}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end EXNI;
          annotation (Documentation);
          end ES;

          package TG
          extends Modelica.Icons.ExamplesPackage;

            model IEESGO
              "Simple Machine Infinite Bus with Machine, Governor and Excitation system"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENSAL generator(
                Xppd=0.2,
                Xppq=0.2,
                Xl=0.12,
                V_0=1,
                angle_0=4.05,
                P_0=39.99995,
                Q_0=5.416571,
                M_b=100,
                Tpd0=6.7000,
                Tppd0=0.028,
                Tppq0=0.0358,
                H=4.4100,
                D=0,
                Xd=1.2200,
                Xq=0.76000,
                Xpd=0.29700,
                S10=0.18600,
                S12=0.802) annotation (Placement(transformation(extent={{-90,-10},
                        {-70,10}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.SCRX SCRX(
                T_B=10,
                K=100,
                T_E=0.05,
                E_MIN=0,
                E_MAX=5,
                r_cr_fd=0,
                C_SWITCH=false,
                T_AT_B=0.1) annotation (Placement(transformation(
                    extent={{-18,-16},{18,16}},
                    rotation=180,
                    origin={-80,-34})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-2,-2},{2,2}},
                    rotation=180,
                    origin={-50,-34})));
              OpenIPSL.Electrical.Controls.PSSE.TG.IEESGO iEESGO(
                T_1=0.01,
                T_2=0.0,
                T_3=0.15,
                T_4=0.3,
                T_5=8.0,
                T_6=0.4,
                K_2=0.7,
                K_3=0.43,
                P_MAX=1.0,
                P_MIN=0.0,
                K_1=0.1) annotation (Placement(transformation(extent={{-64,24},
                        {-96,38}})));
            equation
              connect(SCRX.VUEL, const.y) annotation (Line(
                  points={{-68.3,-18},{-53.67,-18},{-53.67,-34},{-52.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.VOEL, const.y) annotation (Line(
                  points={{-73.7,-18},{-53.67,-18},{-53.67,-34},{-52.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.VOTHSG, const.y) annotation (Line(
                  points={{-62,-43.7778},{-53.67,-43.7778},{-53.67,-34},{-52.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, SCRX.EFD0) annotation (Line(
                  points={{-69,-5},{-69,-24.2222},{-62,-24.2222}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.EFD, generator.EFD) annotation (Line(points={{-98.9,-35.7778},{-104,
                      -35.7778},{-104,-5},{-92,-5}}, color={0,0,127}));
              connect(generator.ETERM, SCRX.ECOMP) annotation (Line(points={{-69,-3},{-44,-3},
                      {-44,-35.7778},{-62,-35.7778}}, color={0,0,127}));
              connect(generator.XADIFD, SCRX.XADIFD) annotation (Line(points={{-69.2,-9},{-52,
                      -9},{-52,-29.5556},{-62,-29.5556}}, color={0,0,127}));
              connect(iEESGO.SPEED, generator.SPEED) annotation (Line(points={{-64.8,35},{-62,
                      35},{-62,7},{-69,7}}, color={0,0,127}));
              connect(iEESGO.PMECH, generator.PMECH) annotation (Line(points={{-97,32},{-104,
                      32},{-104,5},{-92,5}}, color={0,0,127}));
              connect(iEESGO.PMECH0, generator.PMECH0) annotation (Line(points={{-64.8,28},
                      {-62,28},{-62,5},{-69,5}},color={0,0,127}));
              connect(generator.p, GEN1.p)
                annotation (Line(points={{-70,0},{-70,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-120},{
                        100,80}})),
                Icon(coordinateSystem(extent={{-100,-120},{100,80}})),
                Documentation,
                experiment(StopTime=10));
            end IEESGO;

            model HYGOV
              "Simple Machine Infinite Bus with Machine, Governor and Excitation system"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENSAL generator(
                Xppd=0.2,
                Xppq=0.2,
                Xl=0.12,
                V_0=1,
                angle_0=4.05,
                P_0=39.99995,
                Q_0=5.416571,
                M_b=100,
                Tpd0=6.7000,
                Tppd0=0.028,
                Tppq0=0.0358,
                H=4.4100,
                D=0,
                Xd=1.2200,
                Xq=0.76000,
                Xpd=0.29700,
                S10=0.18600,
                S12=0.802) annotation (Placement(transformation(extent={{-96,-10},
                        {-76,10}})));
              OpenIPSL.Electrical.Controls.PSSE.TG.HYGOV HYGOV(
                VELM=0.02,
                G_MAX=0.415,
                R=0.05,
                r=0.3,
                T_r=5,
                T_f=0.05,
                T_g=0.5,
                G_MIN=0,
                T_w=1.25,
                A_t=1.2,
                D_turb=0.2,
                q_NL=0.08) annotation (Placement(transformation(
                    extent={{-19,-14},{19,14}},
                    rotation=180,
                    origin={-81,38})));
              OpenIPSL.Electrical.Controls.PSSE.ES.SCRX SCRX(
                T_B=10,
                K=100,
                T_E=0.05,
                E_MIN=0,
                E_MAX=5,
                r_cr_fd=0,
                C_SWITCH=false,
                T_AT_B=0.1) annotation (Placement(transformation(
                    extent={{-18,-16},{18,16}},
                    rotation=180,
                    origin={-86,-34})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-2,-2},{2,2}},
                    rotation=180,
                    origin={-56,-34})));
            equation
              connect(SCRX.VUEL, const.y) annotation (Line(
                  points={{-74.3,-18},{-59.67,-18},{-59.67,-34},{-58.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.VOEL, const.y) annotation (Line(
                  points={{-79.7,-18},{-59.67,-18},{-59.67,-34},{-58.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.VOTHSG, const.y) annotation (Line(
                  points={{-68,-43.7778},{-59.67,-43.7778},{-59.67,-34},{-58.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, SCRX.EFD0) annotation (Line(
                  points={{-75,-5},{-75,-24.2222},{-68,-24.2222}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.PMECH0, HYGOV.PMECH0) annotation (Line(points={{-75,5},{-52,
                      5},{-52,45},{-62.475,45}}, color={0,0,127}));
              connect(generator.SPEED, HYGOV.SPEED) annotation (Line(points={{-75,7},{-58,7},
                      {-58,31},{-62.475,31}}, color={0,0,127}));
              connect(HYGOV.PMECH, generator.PMECH) annotation (Line(points={{-100.95,38},{
                      -110,38},{-110,5},{-98,5}}, color={0,0,127}));
              connect(SCRX.EFD, generator.EFD) annotation (Line(points={{-104.9,-35.7778},{
                      -110,-35.7778},{-110,-5},{-98,-5}}, color={0,0,127}));
              connect(generator.ETERM, SCRX.ECOMP) annotation (Line(points={{-75,-3},{-50,-3},
                      {-50,-35.7778},{-68,-35.7778}}, color={0,0,127}));
              connect(generator.XADIFD, SCRX.XADIFD) annotation (Line(points={{-75.2,-9},{-58,
                      -9},{-58,-29.5556},{-68,-29.5556}}, color={0,0,127}));
              connect(generator.p, GEN1.p)
                annotation (Line(points={{-76,0},{-76,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-120},{
                        100,80}})),
                Icon(coordinateSystem(extent={{-100,-120},{100,80}})),
                Documentation,
                experiment(StopTime=10));
            end HYGOV;

            model GGOV "three phase to ground fault test of GGOV"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROU generator(
                Xppd=0.2,
                Xppq=0.2,
                Xpp=0.2,
                Xl=0.12,
                M_b=100,
                Tpd0=5,
                Tppd0=0.50000E-01,
                Tppq0=0.1,
                H=4.0000,
                D=0,
                Xd=1.41,
                Xq=1.3500,
                Xpd=0.3,
                S10=0.1,
                S12=0.5,
                Xpq=0.6,
                Tpq0=0.7,
                V_0=1,
                angle_0=4.05,
                P_0=39.99995,
                Q_0=5.416571) annotation (Placement(transformation(extent={{-100,
                        -16},{-60,18}})));
              OpenIPSL.Electrical.Controls.PSSE.TG.GGOV1.GGOV1 gGOV1pele(
                R=0.04,
                T_pelec=1,
                maxerr=0.05,
                minerr=-0.05,
                Kpgov=10,
                Kigov=2,
                Kdgov=0,
                Tdgov=1,
                Vmax=1,
                Vmin=0.15,
                Tact=0.5,
                Kturb=1.5,
                Wfnl=0.2,
                Tb=0.1,
                Tc=0,
                Teng=0,
                Tfload=3,
                Kpload=2,
                Kiload=0.67,
                Ldref=1,
                Dm=0,
                Ropen=0.1,
                Rclose=-0.1,
                Kimw=0,
                Aset=0.1,
                Ka=10,
                Ta=0.1,
                Trate=0,
                db=0,
                Tsa=4,
                Tsb=5,
                Rup=99,
                Rdown=-99,
                DELT=0.005,
                Flag=0) annotation (Placement(transformation(
                    extent={{-20,-18},{20,18}},
                    rotation=180,
                    origin={-68,40})));
            equation
              connect(gGOV1pele.PELEC, generator.PELEC) annotation (Line(
                  points={{-47.3793,46.9652},{-34,46.9652},{-34,6.1},{-58,6.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, generator.EFD) annotation (Line(
                  points={{-58,-7.5},{-52,-7.5},{-52,-30},{-102,-30},{-102,-7.5},{-104,-7.5}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(gGOV1pele.PMECH, generator.PMECH) annotation (Line(points={{-88.6897,
                      39.2174},{-106,39.2174},{-106,9.5},{-104,9.5}}, color={0,0,127}));
              connect(generator.SPEED, gGOV1pele.SPEED) annotation (Line(points={{-58,12.9},
                      {-40,12.9},{-40,29.8261},{-47.4483,29.8261}}, color={0,0,127}));
              connect(generator.p, GEN1.p) annotation (Line(points={{-60,1},{-50,1},{-50,0},
                      {-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end GGOV;

            model TGOV1 "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              OpenIPSL.Electrical.Controls.PSSE.TG.TGOV1 tGOV1_1(
                R=0.04,
                D_t=0,
                T_1=0.4,
                T_2=2,
                T_3=6,
                V_MAX=0.86,
                V_MIN=0.3) annotation (Placement(transformation(extent={{-72,32},
                        {-88,44}})));
            equation
              connect(gENROE.EFD, gENROE.EFD0) annotation (Line(points={{-104,-10},{-110,-10},
                      {-110,-30},{-48,-30},{-48,-10},{-58,-10}}, color={0,0,127}));
              connect(tGOV1_1.SPEED, gENROE.SPEED) annotation (Line(points={{-73,41},{-52,
                      41},{-52,14},{-58,14}}, color={0,0,127}));
              connect(tGOV1_1.PMECH0, gENROE.PMECH0) annotation (Line(points={{-73,35},{-48,
                      35},{-48,10},{-58,10}}, color={0,0,127}));
              connect(tGOV1_1.PMECH, gENROE.PMECH) annotation (Line(points={{-89,38},{-110,
                      38},{-110,10},{-104,10}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end TGOV1;
          annotation (Documentation);
          end TG;

          package PSS
          extends Modelica.Icons.ExamplesPackage;

            model STAB3
              "Simple Machine Infinite Bus with Machine, Governor and Excitation system"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENSAL generator(
                Xppd=0.2,
                Xppq=0.2,
                Xl=0.12,
                V_0=1,
                angle_0=4.05,
                P_0=39.99995,
                Q_0=5.416571,
                M_b=100,
                Tpd0=6.7000,
                Tppd0=0.28000E-01,
                Tppq0=0.35000E-01,
                H=4.4100,
                D=0,
                Xd=1.2200,
                Xq=0.76000,
                Xpd=0.29700,
                S10=0.18600,
                S12=0.802) annotation (Placement(transformation(extent={{-106,-12},
                        {-78,14}})));
              OpenIPSL.Electrical.Controls.PSSE.TG.HYGOV HYGOV(VELM=0.02, G_MAX
                  =0.415) annotation (Placement(transformation(
                    extent={{-19,-14},{19,14}},
                    rotation=180,
                    origin={-83,30})));
              OpenIPSL.Electrical.Controls.PSSE.ES.SCRX SCRX(
                T_AT_B=0.01,
                T_B=10,
                K=100,
                T_E=0.05,
                E_MIN=0,
                E_MAX=5,
                r_cr_fd=0,
                C_SWITCH=false) annotation (Placement(transformation(
                    extent={{-18,-16},{18,16}},
                    rotation=180,
                    origin={-94,-36})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-2,-2},{2,2}},
                    rotation=180,
                    origin={-68,-34})));
            equation
              connect(SCRX.VUEL, const.y) annotation (Line(
                  points={{-82.3,-20},{-71.67,-20},{-71.67,-34},{-70.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.VOEL, const.y) annotation (Line(
                  points={{-87.7,-20},{-71.67,-20},{-71.67,-34},{-70.2,-34}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, SCRX.EFD0) annotation (Line(
                  points={{-76.6,-5.5},{-74,-5.5},{-74,-26.2222},{-76,-26.2222}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.XADIFD, SCRX.XADIFD) annotation (Line(points={{-76.88,-10.7},
                      {-70,-10.7},{-70,-31.5556},{-76,-31.5556}}, color={0,0,127}));
              connect(SCRX.ECOMP, generator.ETERM) annotation (Line(points={{-76,-37.7778},
                      {-66,-37.7778},{-66,-2.9},{-76.6,-2.9}},color={0,0,127}));
              connect(generator.SPEED, HYGOV.SPEED) annotation (Line(points={{-76.6,10.1},{
                      -58,10.1},{-58,23},{-64.475,23}}, color={0,0,127}));
              connect(generator.PMECH0, HYGOV.PMECH0) annotation (Line(points={{-76.6,7.5},
                      {-64,7.5},{-64,10},{-48,10},{-48,37},{-64.475,37}},color={0,0,127}));
              connect(HYGOV.PMECH, generator.PMECH) annotation (Line(points={{-102.95,30},{
                      -112,30},{-112,7.5},{-108.8,7.5}}, color={0,0,127}));
              connect(generator.EFD, SCRX.EFD) annotation (Line(points={{-108.8,-5.5},{-116,
                      -5.5},{-116,-37.7778},{-112.9,-37.7778}}, color={0,0,127}));
              connect(SCRX.VOTHSG, const.y) annotation (Line(points={{-76,-45.7778},{-74,-45.7778},
                      {-74,-36},{-71.67,-36},{-71.67,-34},{-70.2,-34}}, color={0,0,127}));
              connect(generator.p, GEN1.p) annotation (Line(points={{-78,1},{-58.3,1},{-58.3,
                      0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-120},{
                        100,80}})),
                Icon(coordinateSystem(extent={{-100,-120},{100,80}})),
                Documentation,
                experiment(StopTime=10));
            end STAB3;

            model STABNI
              "Simple Machine Infinite Bus with Machine, Governor and Excitation system"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENSAL generator(
                Xppd=0.2,
                Xppq=0.2,
                Xl=0.12,
                V_0=1,
                angle_0=4.05,
                P_0=39.99995,
                Q_0=5.416571,
                M_b=100,
                Tpd0=6.7000,
                Tppd0=0.28000E-01,
                Tppq0=0.35000E-01,
                H=4.4100,
                D=0,
                Xd=1.2200,
                Xq=0.76000,
                Xpd=0.29700,
                S10=0.18600,
                S12=0.802) annotation (Placement(transformation(extent={{-98,-14},
                        {-70,12}})));
              OpenIPSL.Electrical.Controls.PSSE.TG.HYGOV HYGOV(VELM=0.02, G_MAX
                  =0.415) annotation (Placement(transformation(
                    extent={{-19,-14},{19,14}},
                    rotation=180,
                    origin={-75,28})));
              OpenIPSL.Electrical.Controls.PSSE.ES.SCRX SCRX(
                T_AT_B=0.01,
                T_B=10,
                K=100,
                T_E=0.05,
                E_MIN=0,
                E_MAX=5,
                r_cr_fd=0,
                C_SWITCH=false) annotation (Placement(transformation(
                    extent={{-18,-16},{18,16}},
                    rotation=180,
                    origin={-86,-38})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{-2,-2},{2,2}},
                    rotation=180,
                    origin={-60,-36})));
            equation
              connect(SCRX.VUEL, const.y) annotation (Line(
                  points={{-74.3,-22},{-63.67,-22},{-63.67,-36},{-62.2,-36}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(SCRX.VOEL, const.y) annotation (Line(
                  points={{-79.7,-22},{-63.67,-22},{-63.67,-36},{-62.2,-36}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.EFD0, SCRX.EFD0) annotation (Line(
                  points={{-68.6,-7.5},{-66,-7.5},{-66,-28.2222},{-68,-28.2222}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(generator.PMECH0, HYGOV.PMECH0) annotation (Line(points={{-68.6,5.5},
                      {-58,5.5},{-58,8},{-48,8},{-48,35},{-56.475,35}},color={0,0,127}));
              connect(generator.SPEED, HYGOV.SPEED) annotation (Line(points={{-68.6,8.1},{-56,
                      8.1},{-52,8.1},{-52,22},{-52,21},{-56.475,21}}, color={0,0,127}));
              connect(generator.XADIFD, SCRX.XADIFD) annotation (Line(points={{-68.88,-12.7},
                      {-62,-12.7},{-62,-33.5556},{-68,-33.5556}}, color={0,0,127}));
              connect(SCRX.VOTHSG, const.y) annotation (Line(points={{-68,-47.7778},{-64,-47.7778},
                      {-64,-38},{-64,-37.2},{-64,-36},{-62.2,-36}}, color={0,0,127}));
              connect(generator.PMECH, HYGOV.PMECH0) annotation (Line(points={{-100.8,5.5},
                      {-110,5.5},{-110,14},{-48,14},{-48,35},{-56.475,35}},color={0,0,127}));
              connect(SCRX.EFD, generator.EFD) annotation (Line(points={{-104.9,-39.7778},{
                      -110,-39.7778},{-110,-7.5},{-100.8,-7.5}}, color={0,0,127}));
              connect(generator.p, GEN1.p) annotation (Line(points={{-70,-1},{-53.3,-1},{-53.3,
                      0},{-40,0}}, color={0,0,255}));
              connect(SCRX.ECOMP, generator.ETERM) annotation (Line(points={{-68,-39.7778},
                      {-66,-39.7778},{-66,-4.9},{-68.6,-4.9}},color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-120},{
                        100,80}})),
                Icon(coordinateSystem(extent={{-100,-120},{100,80}})),
                Documentation,
                experiment(StopTime=10));
            end STABNI;

            model PSS2A "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-86},{-40,-66}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESST1A eSST1A(
                V_IMAX=0.3,
                V_IMIN=-0.3,
                T_C=2,
                T_B=10,
                T_C1=0.08,
                T_B1=0.083,
                K_A=300,
                V_AMAX=7,
                V_AMIN=-7,
                V_RMAX=5.2,
                V_RMIN=-5.2,
                K_C=0.38,
                K_F=1,
                T_F=1,
                K_LR=1,
                I_LR=0,
                T_A=0.1,
                T_R=0.1) annotation (Placement(transformation(extent={{-56,-90},
                        {-108,-60}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-20,-120},{-40,-100}})));
              Modelica.Blocks.Sources.Constant const2(k=Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-18,-150},{-38,-130}})));
              OpenIPSL.Electrical.Controls.PSSE.PSS.PSS2A pSS2A(
                T_w2=5,
                T_6=0,
                T_w3=5,
                T_w4=5,
                T_7=5,
                K_S2=0.758,
                K_S3=1,
                T_8=0.12,
                T_9=0.1,
                K_S1=2,
                T_1=0.47,
                T_2=0.07,
                T_3=0.47,
                T_4=0.07,
                V_STMAX=0.1,
                V_STMIN=-0.1,
                M=5,
                N=1,
                T_w1=0) annotation (Placement(transformation(extent={{-156,-40},
                        {-118,-32}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(eSST1A.ECOMP, gENROE.ETERM) annotation (Line(points={{-56,-73.3333},{
                      -52,-73.3333},{-52,-6},{-58,-6}}, color={0,0,127}));
              connect(const1.y, eSST1A.VUEL2) annotation (Line(points={{-41,-110},{-80.713,
                      -110},{-80.713,-89.9917}}, color={0,0,127}));
              connect(eSST1A.VUEL, const.y) annotation (Line(points={{-65.1,-90},{-65.1,-94},
                      {-46,-94},{-46,-76},{-41,-76}}, color={0,0,127}));
              connect(eSST1A.VUEL3, eSST1A.VUEL2) annotation (Line(points={{-88.4805,-89.9958},
                      {-88.4805,-110},{-80.713,-110},{-80.713,-89.9917}}, color={0,0,127}));
              connect(const2.y, eSST1A.VOEL) annotation (Line(points={{-39,-140},{-72.9,-140},
                      {-72.9,-90}}, color={0,0,127}));
              connect(pSS2A.V_S2, gENROE.PELEC) annotation (Line(points={{-156,-38},{-158,-38},
                      {-158,-48},{-46,-48},{-46,6},{-58,6}}, color={0,0,127}));
              connect(pSS2A.V_S1, gENROE.SPEED) annotation (Line(points={{-156,-34},{-158,-34},
                      {-158,30},{-44,30},{-44,14},{-58,14}}, color={0,0,127}));
              connect(eSST1A.EFD, gENROE.EFD) annotation (Line(points={{-109.3,-73.3333},{-114,
                      -73.3333},{-114,-10},{-104,-10}}, color={0,0,127}));
              connect(eSST1A.VT, gENROE.ETERM) annotation (Line(points={{-56.0325,-69.1875},
                      {-52,-69.1875},{-52,-6},{-58,-6}}, color={0,0,127}));
              connect(eSST1A.EFD0, gENROE.EFD0) annotation (Line(points={{-56,-84.1667},{-50,
                      -84.1667},{-50,-10},{-58,-10}}, color={0,0,127}));
              connect(eSST1A.XADIFD, gENROE.XADIFD) annotation (Line(points={{-56,-79.1667},
                      {-48,-79.1667},{-48,-18},{-58.4,-18}}, color={0,0,127}));
              connect(eSST1A.VOTHSG2, pSS2A.VOTHSG) annotation (Line(points={{-56,-62.5},{-44,
                      -62.5},{-44,-36},{-117.4,-36}}, color={0,0,127}));
              connect(eSST1A.VOTHSG, const.y) annotation (Line(points={{-56,-65.8333},{-46,
                      -65.8333},{-46,-76},{-41,-76}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end PSS2A;

            model IEEEST "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-102,-20},
                        {-62,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-22,-86},{-42,-66}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESST1A eSST1A(
                V_IMAX=0.3,
                V_IMIN=-0.3,
                T_C=2,
                T_B=10,
                T_C1=0.08,
                T_B1=0.083,
                K_A=300,
                V_AMAX=7,
                V_AMIN=-7,
                V_RMAX=5.2,
                V_RMIN=-5.2,
                K_C=0.38,
                K_F=1,
                T_F=1,
                K_LR=1,
                I_LR=0,
                T_A=0.1,
                T_R=0.1) annotation (Placement(transformation(extent={{-58,-90},
                        {-110,-60}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-22,-120},{-42,-100}})));
              Modelica.Blocks.Sources.Constant const2(k=Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-20,-150},{-40,-130}})));
              OpenIPSL.Electrical.Controls.PSSE.PSS.IEEEST iEEEST(
                A_1=48.7435,
                A_2=4.7488,
                A_3=0.0,
                A_4=0.0,
                A_5=-85.7761,
                A_6=0.0459,
                T_1=0.7361,
                T_2=1.5868,
                T_3=0.0,
                T_4=0.02,
                T_5=13.8921,
                T_6=0.1057,
                K_S=0.0099,
                L_SMAX=0.1,
                L_SMIN=-0.1,
                V_CU=0.0,
                V_CL=0.0) annotation (Placement(transformation(extent={{-96,-44},
                        {-68,-32}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-106,10},{-112,
                      10},{-112,26},{-50,26},{-50,10},{-60,10}}, color={0,0,127}));
              connect(eSST1A.ECOMP, gENROE.ETERM) annotation (Line(points={{-58,-73.3333},{
                      -54,-73.3333},{-54,-6},{-60,-6}}, color={0,0,127}));
              connect(const1.y, eSST1A.VUEL2) annotation (Line(points={{-43,-110},{-82.713,
                      -110},{-82.713,-89.9917}}, color={0,0,127}));
              connect(eSST1A.VUEL, const.y) annotation (Line(points={{-67.1,-90},{-67.1,-94},
                      {-48,-94},{-48,-76},{-43,-76}}, color={0,0,127}));
              connect(eSST1A.VUEL3, eSST1A.VUEL2) annotation (Line(points={{-90.4805,-89.9958},
                      {-90.4805,-110},{-82.713,-110},{-82.713,-89.9917}}, color={0,0,127}));
              connect(const2.y, eSST1A.VOEL) annotation (Line(points={{-41,-140},{-74.9,-140},
                      {-74.9,-90}}, color={0,0,127}));
              connect(eSST1A.EFD, gENROE.EFD) annotation (Line(points={{-111.3,-73.3333},{-116,
                      -73.3333},{-116,-10},{-106,-10}}, color={0,0,127}));
              connect(eSST1A.VT, gENROE.ETERM) annotation (Line(points={{-58.0325,-69.1875},
                      {-54,-69.1875},{-54,-6},{-60,-6}}, color={0,0,127}));
              connect(eSST1A.EFD0, gENROE.EFD0) annotation (Line(points={{-58,-84.1667},{-52,
                      -84.1667},{-52,-10},{-60,-10}}, color={0,0,127}));
              connect(eSST1A.XADIFD, gENROE.XADIFD) annotation (Line(points={{-58,-79.1667},
                      {-50,-79.1667},{-50,-18},{-60.4,-18}}, color={0,0,127}));
              connect(iEEEST.V_CT, gENROE.ETERM) annotation (Line(points={{-95.7667,-35},{-102,
                      -35},{-102,-28},{-54,-28},{-54,-6},{-60,-6}}, color={0,0,127}));
              connect(iEEEST.V_S, gENROE.PELEC) annotation (Line(points={{-95.7667,-41},{-102,
                      -41},{-102,-52},{-56,-52},{-56,6},{-60,6}}, color={0,0,127}));
              connect(eSST1A.VOTHSG2, const.y) annotation (Line(points={{-58,-62.5},{-46,-62.5},
                      {-46,-76},{-43,-76}}, color={0,0,127}));
              connect(iEEEST.VOTHSG, eSST1A.VOTHSG) annotation (Line(points={{-66.8333,-38},
                      {-48,-38},{-48,-65.8333},{-58,-65.8333}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-62,0},{-62,0},{-40,0}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end IEEEST;

            model PSS2B "SMIB system with one load and GENROE model"
              extends OpenIPSL.Examples.SMIBpartial;
              OpenIPSL.Electrical.Machines.PSSE.GENROE gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                H=4.28,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2) annotation (Placement(transformation(extent={{-100,-20},
                        {-60,20}})));
              Modelica.Blocks.Sources.Constant const(k=0)
                annotation (Placement(transformation(extent={{-20,-86},{-40,-66}})));
              OpenIPSL.Electrical.Controls.PSSE.ES.ESST1A eSST1A(
                V_IMAX=0.3,
                V_IMIN=-0.3,
                T_C=2,
                T_B=10,
                T_C1=0.08,
                T_B1=0.083,
                K_A=300,
                V_AMAX=7,
                V_AMIN=-7,
                V_RMAX=5.2,
                V_RMIN=-5.2,
                K_C=0.38,
                K_F=1,
                T_F=1,
                K_LR=1,
                I_LR=0,
                T_A=0.1,
                T_R=0.1) annotation (Placement(transformation(extent={{-56,-90},
                        {-108,-60}})));
              Modelica.Blocks.Sources.Constant const1(k=-Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-20,-120},{-40,-100}})));
              Modelica.Blocks.Sources.Constant const2(k=Modelica.Constants.inf)
                annotation (Placement(transformation(extent={{-18,-150},{-38,-130}})));
              OpenIPSL.Electrical.Controls.PSSE.PSS.PSS2B pSS2B(
                T_w1=2,
                T_w2=2,
                T_6=0,
                T_w3=2,
                T_w4=0,
                T_7=2,
                K_S2=0.1564,
                K_S3=1,
                T_8=0,
                T_9=0,
                K_S1=10,
                T_1=0.25,
                T_2=0.03,
                T_3=0.15,
                T_4=0.015,
                T_10=0,
                T_11=0,
                V_S1MAX=999,
                V_S1MIN=-999,
                V_S2MAX=999,
                V_S2MIN=-999,
                V_STMAX=0.1,
                V_STMIN=-0.1,
                M=0,
                N=0) annotation (Placement(transformation(extent={{-156,-28},{-120,
                        -20}})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-104,10},{-110,
                      10},{-110,26},{-48,26},{-48,10},{-58,10}}, color={0,0,127}));
              connect(eSST1A.ECOMP, gENROE.ETERM) annotation (Line(points={{-56,-73.3333},{
                      -52,-73.3333},{-52,-6},{-58,-6}}, color={0,0,127}));
              connect(const1.y, eSST1A.VUEL2) annotation (Line(points={{-41,-110},{-80.713,
                      -110},{-80.713,-89.9917}}, color={0,0,127}));
              connect(eSST1A.VUEL, const.y) annotation (Line(points={{-65.1,-90},{-65.1,-94},
                      {-46,-94},{-46,-76},{-41,-76}}, color={0,0,127}));
              connect(eSST1A.VUEL3, eSST1A.VUEL2) annotation (Line(points={{-88.4805,-89.9958},
                      {-88.4805,-110},{-80.713,-110},{-80.713,-89.9917}}, color={0,0,127}));
              connect(const2.y, eSST1A.VOEL) annotation (Line(points={{-39,-140},{-72.9,-140},
                      {-72.9,-90}}, color={0,0,127}));
              connect(eSST1A.EFD, gENROE.EFD) annotation (Line(points={{-109.3,-73.3333},{-114,
                      -73.3333},{-114,-10},{-104,-10}}, color={0,0,127}));
              connect(eSST1A.VT, gENROE.ETERM) annotation (Line(points={{-56.0325,-69.1875},
                      {-52,-69.1875},{-52,-6},{-58,-6}}, color={0,0,127}));
              connect(eSST1A.EFD0, gENROE.EFD0) annotation (Line(points={{-56,-84.1667},{-50,
                      -84.1667},{-50,-10},{-58,-10}}, color={0,0,127}));
              connect(eSST1A.XADIFD, gENROE.XADIFD) annotation (Line(points={{-56,-79.1667},
                      {-48,-79.1667},{-48,-18},{-58.4,-18}}, color={0,0,127}));
              connect(eSST1A.VOTHSG, const.y) annotation (Line(points={{-56,-65.8333},{-46,
                      -65.8333},{-46,-76},{-41,-76}}, color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-60,0},{-60,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.SPEED, pSS2B.V_S1) annotation (Line(points={{-58,14},{-44,14},
                      {-44,30},{-158,30},{-158,-22},{-156,-22}},color={0,0,127}));
              connect(gENROE.PELEC, pSS2B.V_S2) annotation (Line(points={{-58,6},{-46,6},{-46,
                      -30},{-158,-30},{-158,-26},{-156,-26}}, color={0,0,127}));
              connect(pSS2B.VOTHSG, eSST1A.VOTHSG2) annotation (Line(points={{-119.4,-24},{
                      -82,-24},{-44,-24},{-44,-62.5},{-56,-62.5}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Documentation,
                experiment(StopTime=10));
            end PSS2B;
          annotation (Documentation);
          end PSS;
        annotation (Documentation);
        end PSSE;

        package PSAT
        extends Modelica.Icons.ExamplesPackage;

          package AVR
          extends Modelica.Icons.ExamplesPackage;

            model AVRTypeI_Test
              extends Modelica.Icons.Example;
              OpenIPSL.Electrical.Machines.PSAT.Order6 order6Type2_Inputs_Outputs(
                V_0=1,
                angle_0=0,
                V_b=200,
                Sn=370,
                Vn=200,
                ra=0.001,
                x1d=0.302,
                M=10,
                D=0,
                P_0=16.0352698692006,
                Q_0=11.859436505981) annotation (Placement(transformation(
                      extent={{-86,-10},{-50,26}})));
              inner OpenIPSL.Electrical.SystemBase SysData annotation (
                  Placement(transformation(extent={{58,78},{82,98}})));
              Electrical.Branches.PwLine pwLine1(
                X=0.1,
                R=0.01,
                G=0,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={0,2},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLinewithOpening1(
                G=0,
                R=0.01,
                X=0.1,
                opening=1,
                B=0.0005,
                t1=2,
                t2=2.15) annotation (Placement(visible=true, transformation(
                    origin={40,22},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLine2(
                G=0,
                R=0.01,
                X=0.1,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={0,16},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLine3(
                G=0,
                R=0.01,
                X=0.1,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={42,-6},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLine4(
                G=0,
                R=0.01,
                X=0.1,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={40,40},
                    extent={{-5.99999,-5.99998},{5.99999,6}},
                    rotation=0)));
              Electrical.Loads.PSAT.LOADPQ pwLoadPQ1(
                P_0=8,
                Q_0=6,
                V_0=1,
                angle_0=0) annotation (Placement(visible=true, transformation(
                    origin={74,32},
                    extent={{-6,-6},{6,6}},
                    rotation=90)));
              Electrical.Loads.PSAT.LOADPQ pwLoadPQ2(
                P_0=8,
                Q_0=6,
                V_0=1,
                angle_0=0) annotation (Placement(visible=true, transformation(
                    origin={74.034,-6.2889},
                    extent={{-6.2889,-6.0335},{6.2889,6.0335}},
                    rotation=90)));
              Electrical.Buses.Bus bus
                annotation (Placement(transformation(extent={{-30,-2},{-10,18}})));
              Electrical.Buses.Bus bus1
                annotation (Placement(transformation(extent={{10,-2},{30,18}})));
              Electrical.Buses.Bus bus2
                annotation (Placement(transformation(extent={{50,22},{70,42}})));
              Electrical.Buses.Bus bus3
                annotation (Placement(transformation(extent={{50,-16},{70,4}})));
              Electrical.Controls.PSAT.AVR.AVRTypeI aVRI
                annotation (Placement(transformation(extent={{-72,36},{-92,54}})));
              Modelica.Blocks.Sources.Ramp ramp(
                duration=20,
                startTime=1,
                height=-0.1) annotation (Placement(transformation(
                    extent={{6,-6},{-6,6}},
                    rotation=0,
                    origin={-34,48})));
              Modelica.Blocks.Math.Add add
                annotation (Placement(transformation(extent={{-50,46},{-60,56}})));
            equation

              connect(pwLine2.p, pwLine1.p) annotation (Line(points={{-5.4,16},{-14,16},{-14,
                      2},{-5.4,2}}, color={0,0,255}));
              connect(pwLine2.n, pwLine1.n) annotation (Line(points={{5.4,16},{14,16},{14,2},
                      {5.4,2}}, color={0,0,255}));
              connect(pwLine4.p, pwLinewithOpening1.p) annotation (Line(points={{34.6,40},{
                      28,40},{28,22},{34.6,22}}, color={0,0,255}));
              connect(pwLine4.n, pwLinewithOpening1.n) annotation (Line(points={{45.4,40},{
                      52,40},{52,22},{45.4,22}}, color={0,0,255}));
              connect(bus.p, pwLine1.p) annotation (Line(points={{-20,8},{-14,8},{-14,2},{-5.4,
                      2}}, color={0,0,255}));
              connect(bus1.p, pwLine1.n)
                annotation (Line(points={{20,8},{14,8},{14,2},{5.4,2}}, color={0,0,255}));
              connect(bus1.p, pwLinewithOpening1.p) annotation (Line(points={{20,8},{24,8},
                      {24,28},{28,28},{28,22},{34.6,22}},color={0,0,255}));
              connect(pwLine3.p, pwLinewithOpening1.p) annotation (Line(points={{36.6,-6},{
                      24,-6},{24,28},{28,28},{28,22},{34.6,22}}, color={0,0,255}));
              connect(bus2.p, pwLoadPQ1.p)
                annotation (Line(points={{60,32},{68,32}}, color={0,0,255}));
              connect(bus2.p, pwLinewithOpening1.n) annotation (Line(points={{60,32},{52,32},
                      {52,22},{45.4,22}}, color={0,0,255}));
              connect(bus3.p, pwLoadPQ2.p) annotation (Line(points={{60,-6},{68.0005,-6},{
                      68.0005,-6.2889}}, color={0,0,255}));
              connect(pwLine3.n, bus3.p)
                annotation (Line(points={{47.4,-6},{60,-6}}, color={0,0,255}));
              connect(bus.p, order6Type2_Inputs_Outputs.p)
                annotation (Line(points={{-20,8},{-50,8}}, color={0,0,255}));
              connect(aVRI.vf, order6Type2_Inputs_Outputs.vf) annotation (Line(points={{-94,
                      45},{-96,45},{-96,17},{-89.6,17}}, color={0,0,127}));
              connect(aVRI.v, order6Type2_Inputs_Outputs.v) annotation (Line(points={{-70,
                      39.6},{-44,39.6},{-44,13.4},{-48.2,13.4}}, color={0,0,127}));
              connect(aVRI.vf0, order6Type2_Inputs_Outputs.vf0) annotation (Line(points={{-82,
                      34.2},{-82,27.8},{-82.4,27.8}}, color={0,0,127}));
              connect(aVRI.vref0, add.u1) annotation (Line(points={{-82,55.8},{-82,62},{-49,
                      62},{-49,54}}, color={0,0,127}));
              connect(ramp.y, add.u2) annotation (Line(points={{-40.6,48},{-43.25,48},{-49,
                      48}}, color={0,0,127}));
              connect(add.y, aVRI.vref) annotation (Line(points={{-60.5,51},{-65.25,51},{-65.25,
                      50.4},{-70,50.4}}, color={0,0,127}));
              connect(order6Type2_Inputs_Outputs.pm, order6Type2_Inputs_Outputs.pm0)
                annotation (Line(points={{-89.6,-1},{-96,-1},{-96,-16},{-82.4,-16},{-82.4,-11.8}},
                    color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-100,-100},{100,100}},
                      preserveAspectRatio=false)),
                Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
                Documentation,
                experiment(StopTime=60),
                __Dymola_experimentSetupOutput);
            end AVRTypeI_Test;

            model AVRTypeII_Test
              extends Modelica.Icons.Example;
              OpenIPSL.Electrical.Machines.PSAT.Order6 order6Type2_Inputs_Outputs(
                V_0=1,
                angle_0=0,
                V_b=200,
                Sn=370,
                Vn=200,
                ra=0.001,
                x1d=0.302,
                M=10,
                D=0,
                P_0=16.0352698692006,
                Q_0=11.859436505981) annotation (Placement(transformation(
                      extent={{-86,-10},{-50,26}})));
              inner OpenIPSL.Electrical.SystemBase SysData annotation (
                  Placement(transformation(extent={{58,78},{82,98}})));
              Electrical.Branches.PwLine pwLine1(
                X=0.1,
                R=0.01,
                G=0,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={0,2},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLinewithOpening1(
                G=0,
                R=0.01,
                X=0.1,
                opening=1,
                B=0.0005,
                t1=2,
                t2=2.15) annotation (Placement(visible=true, transformation(
                    origin={40,22},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLine2(
                G=0,
                R=0.01,
                X=0.1,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={0,16},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLine3(
                G=0,
                R=0.01,
                X=0.1,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={42,-6},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              Electrical.Branches.PwLine pwLine4(
                G=0,
                R=0.01,
                X=0.1,
                B=0.0005) annotation (Placement(visible=true, transformation(
                    origin={40,40},
                    extent={{-5.99999,-5.99998},{5.99999,6}},
                    rotation=0)));
              Electrical.Loads.PSAT.LOADPQ pwLoadPQ1(
                P_0=8,
                Q_0=6,
                V_0=1,
                angle_0=0) annotation (Placement(visible=true, transformation(
                    origin={74,32},
                    extent={{-6,-6},{6,6}},
                    rotation=90)));
              Electrical.Loads.PSAT.LOADPQ pwLoadPQ2(
                P_0=8,
                Q_0=6,
                V_0=1,
                angle_0=0) annotation (Placement(visible=true, transformation(
                    origin={74.034,-6.2889},
                    extent={{-6.2889,-6.0335},{6.2889,6.0335}},
                    rotation=90)));
              Electrical.Buses.Bus bus
                annotation (Placement(transformation(extent={{-30,-2},{-10,18}})));
              Electrical.Buses.Bus bus1
                annotation (Placement(transformation(extent={{10,-2},{30,18}})));
              Electrical.Buses.Bus bus2
                annotation (Placement(transformation(extent={{50,22},{70,42}})));
              Electrical.Buses.Bus bus3
                annotation (Placement(transformation(extent={{50,-16},{70,4}})));
              Electrical.Controls.PSAT.AVR.AVRTypeII aVRI
                annotation (Placement(transformation(extent={{-72,36},{-92,54}})));
              Modelica.Blocks.Sources.Ramp ramp(
                duration=20,
                startTime=1,
                height=-0.1) annotation (Placement(transformation(
                    extent={{6,-6},{-6,6}},
                    rotation=0,
                    origin={-34,48})));
              Modelica.Blocks.Math.Add add
                annotation (Placement(transformation(extent={{-50,46},{-60,56}})));
            equation

              connect(pwLine2.p, pwLine1.p) annotation (Line(points={{-5.4,16},{-14,16},{-14,
                      2},{-5.4,2}}, color={0,0,255}));
              connect(pwLine2.n, pwLine1.n) annotation (Line(points={{5.4,16},{14,16},{14,2},
                      {5.4,2}}, color={0,0,255}));
              connect(pwLine4.p, pwLinewithOpening1.p) annotation (Line(points={{34.6,40},{
                      28,40},{28,22},{34.6,22}}, color={0,0,255}));
              connect(pwLine4.n, pwLinewithOpening1.n) annotation (Line(points={{45.4,40},{
                      52,40},{52,22},{45.4,22}}, color={0,0,255}));
              connect(bus.p, pwLine1.p) annotation (Line(points={{-20,8},{-14,8},{-14,2},{-5.4,
                      2}}, color={0,0,255}));
              connect(bus1.p, pwLine1.n)
                annotation (Line(points={{20,8},{14,8},{14,2},{5.4,2}}, color={0,0,255}));
              connect(bus1.p, pwLinewithOpening1.p) annotation (Line(points={{20,8},{24,8},
                      {24,28},{28,28},{28,22},{34.6,22}},color={0,0,255}));
              connect(pwLine3.p, pwLinewithOpening1.p) annotation (Line(points={{36.6,-6},{
                      24,-6},{24,28},{28,28},{28,22},{34.6,22}}, color={0,0,255}));
              connect(bus2.p, pwLoadPQ1.p)
                annotation (Line(points={{60,32},{68,32}}, color={0,0,255}));
              connect(bus2.p, pwLinewithOpening1.n) annotation (Line(points={{60,32},{52,32},
                      {52,22},{45.4,22}}, color={0,0,255}));
              connect(bus3.p, pwLoadPQ2.p) annotation (Line(points={{60,-6},{68.0005,-6},{
                      68.0005,-6.2889}}, color={0,0,255}));
              connect(pwLine3.n, bus3.p)
                annotation (Line(points={{47.4,-6},{60,-6}}, color={0,0,255}));
              connect(bus.p, order6Type2_Inputs_Outputs.p)
                annotation (Line(points={{-20,8},{-50,8}}, color={0,0,255}));
              connect(aVRI.vf, order6Type2_Inputs_Outputs.vf) annotation (Line(points={{-94,
                      45},{-96,45},{-96,17},{-89.6,17}}, color={0,0,127}));
              connect(aVRI.v, order6Type2_Inputs_Outputs.v) annotation (Line(points={{-70,
                      39.6},{-44,39.6},{-44,13.4},{-48.2,13.4}}, color={0,0,127}));
              connect(aVRI.vf0, order6Type2_Inputs_Outputs.vf0) annotation (Line(points={{-82,
                      34.2},{-82,27.8},{-82.4,27.8}}, color={0,0,127}));
              connect(aVRI.vref0, add.u1) annotation (Line(points={{-82,55.8},{-82,62},{-49,
                      62},{-49,54}}, color={0,0,127}));
              connect(ramp.y, add.u2) annotation (Line(points={{-40.6,48},{-40.6,48},{-49,
                      48}}, color={0,0,127}));
              connect(add.y, aVRI.vref) annotation (Line(points={{-60.5,51},{-65.25,51},{-65.25,
                      50.4},{-70,50.4}}, color={0,0,127}));
              connect(order6Type2_Inputs_Outputs.pm, order6Type2_Inputs_Outputs.pm0)
                annotation (Line(points={{-89.6,-1},{-96,-1},{-96,-16},{-82.4,-16},{-82.4,-11.8}},
                    color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-100,-100},{100,100}},
                      preserveAspectRatio=false)),
                Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
                Documentation,
                experiment(StopTime=60),
                __Dymola_experimentSetupOutput);
            end AVRTypeII_Test;
          annotation (Documentation);
          end AVR;

          package OEL
          extends Modelica.Icons.ExamplesPackage;

            model AVRTypeII_OEL_Test
              extends OpenIPSL.Examples.BaseTest(
                pwLoadPQ2(
                  t_start_1=1,
                  t_end_1=21,
                  dQ1=3.2,
                  forcePQ=true),
                pwLinewithOpening1(t1=100, t2=100),
                pwLoadPQ1(forcePQ=false));
              extends Modelica.Icons.Example;
              Electrical.Machines.PSAT.Order4 order4(
                V_0=1,
                angle_0=0,
                ra=0.001,
                x1d=0.302,
                M=10,
                D=0,
                P_0=16.0352698692006,
                Q_0=11.859436505981,
                Sn=20,
                Vn=370,
                V_b=400) annotation (Placement(transformation(extent={{-45,-10},{-25,10}})));
              Electrical.Controls.PSAT.AVR.AVRTypeII exciter_Type_II(
                vrmin=-5,
                vrmax=5,
                Ta=0.1,
                Te=1,
                Tr=0.001,
                Ae=0.0006,
                Be=0.9,
                Kf=0.45,
                Tf=1,
                Ka=400,
                Ke=0.01) annotation (Placement(transformation(extent={{-70,18},{-90,38}})));
              Electrical.Controls.PSAT.OEL.OEL oXL(
                vOEL_max=0.05,
                T0=5,
                xd=order4.xd,
                xq=order4.xq,
                Sn=order4.Sn,
                Vn=order4.Vn,
                if_lim=3.07)
                annotation (Placement(transformation(extent={{-18,24},{-38,44}})));
            equation
              connect(order4.pm0, order4.pm) annotation (Line(points={{-43,-11},{-43,-16},{
                      -60,-16},{-60,-5},{-47,-5}}, color={0,0,127}));
              connect(order4.p, bus.p)
                annotation (Line(points={{-25,0},{-25,0},{0,0}}, color={0,0,255}));
              connect(order4.vf, exciter_Type_II.vf) annotation (Line(points={{-47,5},{-96.75,
                      5},{-96.75,28},{-92,28}}, color={0,0,127}));
              connect(exciter_Type_II.vf0, order4.vf0) annotation (Line(points={{-80,16},{-80,
                      16},{-80,11},{-43,11}}, color={0,0,127}));
              connect(exciter_Type_II.vref0, oXL.v_ref0) annotation (Line(points={{-80,40},
                      {-80,40},{-80,72},{-27.8,72},{-27.8,45.2}},color={0,0,127}));
              connect(oXL.v, order4.v) annotation (Line(points={{-18.8,40},{-12,40},{-12,3},
                      {-24,3}}, color={0,0,127}));
              connect(order4.P, oXL.p) annotation (Line(points={{-24,-3},{-14,-3},{-14,36},
                      {-18.8,36}},color={0,0,127}));
              connect(order4.Q, oXL.q) annotation (Line(points={{-24,-7},{-16,-7},{-16,32},
                      {-18.8,32}},color={0,0,127}));
              connect(exciter_Type_II.v, order4.v) annotation (Line(points={{-68,22},{-20,
                      22},{-20,3},{-24,3}}, color={0,0,127}));
              connect(oXL.v_ref, exciter_Type_II.vref)
                annotation (Line(points={{-38.4,34},{-54,34},{-68,34}}, color={0,0,127}));
              annotation (
                Documentation,
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                experiment(StopTime=50),
                __Dymola_experimentSetupOutput);
            end AVRTypeII_OEL_Test;
          annotation (Documentation);
          end OEL;

          package TG
          extends Modelica.Icons.ExamplesPackage;

            model TGTypeI_test
              extends TGTestBase;
              extends Modelica.Icons.Example;
              parameter Real p0=0.160352698692006 "Power flow, node active power";
              OpenIPSL.Electrical.Controls.PSAT.TG.TGTypeI tGTypeI(
                wref=1,
                pref=p0,
                R=0.2,
                pmax=1,
                pmin=0,
                Ts=0.1,
                Tc=1,
                T3=0.04,
                T4=5,
                T5=0.04) annotation (Placement(transformation(extent={{-68,-24},
                        {-40,4}})));
            equation

              connect(tGTypeI.pm, gen.pm) annotation (Line(points={{-38.6,-10},{-24,-10}}, color={0,0,127}));
              connect(tGTypeI.w, gen.w) annotation (Line(points={{-70.8,-10},{-80,-10},{-80,40},{30,40},{30,18},{22,18}}, color={0,0,127}));
              annotation (experiment(StopTime=10));
            end TGTypeI_test;

            model TGTypeII_test
              extends TGTestBase;
              extends Modelica.Icons.Example;
              Electrical.Controls.PSAT.TG.TGtypeII           tGtypeII(S_b=SysData.S_b)
                         annotation (Placement(transformation(extent={{-68,-24},{-40,4}})));
            equation
              connect(tGtypeII.pm, gen.pm) annotation (Line(points={{-38.6,-10},{-24,-10}}, color={0,0,127}));
              connect(tGtypeII.w, gen.w) annotation (Line(points={{-70.8,-10},{-80,-10},{-80,40},{30,40},{30,18},{22,18}}, color={0,0,127}));
              connect(tGtypeII.pm0, gen.pm0) annotation (Line(points={{-54,6.8},{-54,20},{-90,20},{-90,-32},{-16,-32},{-16,-22}}, color={0,0,127}));
              annotation (experiment(StopTime=10));
            end TGTypeII_test;

            model TGTypeIII_test
              extends Modelica.Icons.Example;
              extends TGTestBase;
              OpenIPSL.Electrical.Controls.PSAT.TG.TGTypeIII tGTypeIII(
                Tg=0.2,
                Tp=0.04,
                delta=0.3,
                sigma=0.04,
                Tr=5,
                vmin=-0.1,
                vmax=0.1,
                gmax=1,
                gmin=0,
                Tw=1,
                a11=0.5,
                a13=1,
                a21=1.5,
                a23=1,
                int3=2.712336,
                P_0=0.1) annotation (Placement(transformation(extent={{-68,-24},
                        {-40,4}})));
            equation

              connect(tGTypeIII.pm, gen.pm) annotation (Line(points={{-38.6,-10},{-24,-10}}, color={0,0,127}));
              connect(tGTypeIII.w, gen.w) annotation (Line(points={{-70.8,-10},{-80,-10},{-80,40},{30,40},{30,18},{22,18}}, color={0,0,127}));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                        -100},{100,100}})),              Documentation,
                experiment(StopTime=10));
            end TGTypeIII_test;

            model TGTypeIV_test
              extends TGTestBase;
              extends Modelica.Icons.Example;
              OpenIPSL.Electrical.Controls.PSAT.TG.TGTypeIV tGTypeIV(
                Ki=0.105,
                Tg=0.2,
                Tp=0.04,
                delta=0.3,
                sigma=0.05,
                Tr=5,
                vmin=-0.1,
                vmax=0.1,
                gmax=1,
                gmin=0,
                Tw=1,
                a11=0.5,
                a13=1,
                a21=1.5,
                a23=1,
                Kp=1.163,
                Pref=0.080199,
                wref=1) annotation (Placement(transformation(extent={{-68,-24},
                        {-40,4}})));
            equation

              connect(tGTypeIV.Pm, gen.pm) annotation (Line(points={{-38.6,-10},{-24,-10}}, color={0,0,127}));
              connect(tGTypeIV.w, gen.w) annotation (Line(points={{-70.8,-10},{-80,-10},{-80,40},{30,40},{30,18},{22,18}}, color={0,0,127}));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                        -100},{100,100}})),    Documentation,
                experiment(StopTime=10));
            end TGTypeIV_test;

            model TGTypeV_test
              extends TGTestBase;
              extends Modelica.Icons.Example;
              OpenIPSL.Electrical.Controls.PSAT.TG.TGTypeV tGTypeV(
                Ki=0.5,
                Kp=3.0,
                Tg=0.2,
                Tp=0.05,
                sigma=0.04,
                vmin=-0.1,
                vmax=0.1,
                gmax=1,
                gmin=0,
                Tw=1,
                Pref=0.160552) annotation (Placement(transformation(extent={{-68,
                        -24},{-40,4}})));
              Modelica.Blocks.Sources.Sine sine2(
                amplitude=0.001,
                freqHz=0.2,
                offset=1,
                startTime=5) annotation (Placement(transformation(
                    extent={{-6,6},{6,-6}},
                    rotation=180,
                    origin={-26,-60})));
              Modelica.Blocks.Sources.Sine sine1(
                amplitude=-0.001,
                freqHz=0.2,
                startTime=10,
                offset=0) annotation (Placement(transformation(
                    extent={{6,-6},{-6,6}},
                    rotation=0,
                    origin={-26,-40})));
              Modelica.Blocks.Math.Add pertubation annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={-60,-50})));
            equation

              connect(sine2.y, pertubation.u1) annotation (Line(
                  points={{-32.6,-60},{-40,-60},{-40,-44},{-48,-44}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(sine1.y, pertubation.u2) annotation (Line(
                  points={{-32.6,-40},{-40,-40},{-40,-56},{-48,-56}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(pertubation.y, tGTypeV.wref) annotation (Line(
                  points={{-71,-50},{-80,-50},{-80,-18.4},{-70.8,-18.4}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(tGTypeV.Pm, gen.pm) annotation (Line(points={{-38.6,-10},{-24,-10}}, color={0,0,127}));
              connect(tGTypeV.pref, gen.pm0) annotation (Line(points={{-70.8,-1.6},{-90,-1.6},{-90,-30},{-16,-30},{-16,-22}}, color={0,0,127}));
              connect(tGTypeV.w, gen.w) annotation (Line(points={{-70.8,-10},{-80,-10},{-80,40},{30,40},{30,18},{22,18}}, color={0,0,127}));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                        -100},{100,100}}), graphics={Text(
                      extent={{-14,-46},{60,-58}},
                      lineColor={0,0,255},
                      textString="Wref perturbation with sine signal 5-10s")}),
                                            Documentation);
            end TGTypeV_test;

            model TGTypeVI_test
              extends TGTestBase;
              extends Modelica.Icons.Example;
              OpenIPSL.Electrical.Controls.PSAT.TG.TGTypeVI tGTypeVI(
                Ka=3.33333,
                Ta=0.07,
                vmin=-0.1,
                vmax=0.1,
                gmax=0.97518,
                gmin=0.01,
                Rp=0.05,
                Kp=1.163,
                Ki=0.105,
                Kd=0,
                Td=0.01,
                beta=0.1,
                Tw=2.67,
                dref=0,
                po=0.16074) annotation (Placement(transformation(extent={{-68,-24},
                        {-40,4}})));
              Modelica.Blocks.Sources.Sine sine2(
                freqHz=0.2,
                startTime=10,
                amplitude=-0.001,
                offset=0) annotation (Placement(visible=true, transformation(
                    origin={-26,-60},
                    extent={{6,-6},{-6,6}},
                    rotation=0)));
              Modelica.Blocks.Math.Add Perturbation(k2=+1) annotation (Placement(visible=
                      true, transformation(
                    origin={-60,-50},
                    extent={{9.99996,-9.99996},{-10,10}},
                    rotation=0)));
              Modelica.Blocks.Sources.Sine sine1(
                freqHz=0.2,
                startTime=5,
                amplitude=0.001,
                offset=1) annotation (Placement(visible=true, transformation(
                    origin={-26,-40},
                    extent={{6.00002,-6.00001},{-6,6.00001}},
                    rotation=0)));
            equation

              connect(sine1.y, Perturbation.u1) annotation (Line(
                  points={{-32.6,-40},{-39.6999,-40},{-39.6999,-44},{-48,-44}},
                  color={0,0,127},
                  smooth=Smooth.None));

              connect(tGTypeVI.Pm, gen.pm) annotation (Line(points={{-38.6,-10},{-24,-10}}, color={0,0,127}));
              connect(Perturbation.u2,sine2. y) annotation (Line(points={{-48,-56},{-40,-56},{-40,-60},{-32.6,-60}}, color={0,0,127}));
              connect(Perturbation.y, tGTypeVI.wref) annotation (Line(points={{-71,-50},{-88,-50},{-88,1.2},{-70.8,1.2}}, color={0,0,127}));
              connect(gen.pm0, tGTypeVI.pref) annotation (Line(points={{-16,-22},{-16,-28},{-80,-28},{-80,-21.2},{-70.8,-21.2}}, color={0,0,127}));
              connect(gen.P, tGTypeVI.pe) annotation (Line(points={{22,-6},{32,-6},{32,-30},{-84,-30},{-84,-14.2},{-70.8,-14.2}}, color={0,0,127}));
              connect(gen.w, tGTypeVI.we) annotation (Line(points={{22,18},{30,18},{30,40},{-80,40},{-80,-5.8},{-70.8,-5.8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics={       Text(
                      extent={{-14,-46},{60,-58}},
                      lineColor={0,0,255},
                      textString="Wref perturbation with sine signal 5-10s")}),
                Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
                Documentation,
                experiment(StopTime=10));
            end TGTypeVI_test;

            partial model TGTestBase
              OpenIPSL.Electrical.Loads.PSAT.LOADPQ pwLoadPQ1(
                P_0=0.08,
                Q_0=0.06,
                V_0=1,
                angle_0=0) annotation (Placement(visible=true, transformation(
                    origin={90.0709,0},
                    extent={{-5.92912,-6.00002},{5.92911,6.00001}},
                    rotation=0)));
              OpenIPSL.Electrical.Branches.PwLine pwLineFault(
                B=0.001/2,
                G=0,
                R=0.01,
                X=0.1,
                t1=8,
                t2=8.1) annotation (Placement(visible=true, transformation(
                    origin={70,30},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              OpenIPSL.Electrical.Branches.PwLine pwLine3(
                B=0.001/2,
                G=0,
                R=0.01,
                X=0.1) annotation (Placement(visible=true, transformation(
                    origin={70,10},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              OpenIPSL.Electrical.Branches.PwLine pwLine4(
                B=0.001/2,
                G=0,
                R=0.01,
                X=0.1) annotation (Placement(visible=true, transformation(
                    origin={70,-10},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              OpenIPSL.Electrical.Loads.PSAT.LOADPQ pwLoadPQ2(
                P_0=0.08,
                Q_0=0.06,
                V_0=1,
                angle_0=0) annotation (Placement(visible=true, transformation(
                    origin={90,-26},
                    extent={{-6,-6},{6,6}},
                    rotation=0)));
              OpenIPSL.Electrical.Branches.PwLine pwLine1(
                B=0.001/2,
                G=0,
                R=0.01,
                X=0.1,
                displayPF=false) annotation (Placement(visible=true,
                    transformation(
                    origin={46,10},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              OpenIPSL.Electrical.Branches.PwLine pwLine2(
                B=0.001/2,
                G=0,
                R=0.01,
                X=0.1) annotation (Placement(visible=true, transformation(
                    origin={46,-10},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              OpenIPSL.Electrical.Events.PwFaultPQ pwFault(
                X=0.001,
                t1=3,
                t2=3.1,
                R=10) annotation (Placement(transformation(extent={{76,-36},{64,
                        -24}})));
              parameter Real p0=0.160352698692006 "Power flow, node active power";
              inner OpenIPSL.Electrical.SystemBase SysData annotation (
                  Placement(transformation(extent={{-100,80},{-60,100}})));
              Electrical.Machines.PSAT.Order3 gen(
                P_0=0.16041,
                Q_0=0.12012,
                V_b=400,
                V_0=1,
                angle_0=0,
                Sn=20,
                Vn=400,
                ra=0.001,
                x1d=0.302,
                M=10,
                D=0,
                xd=1.9,
                T1d0=8,
                xq=1.7) annotation (Placement(visible=true, transformation(
                    origin={0,0},
                    extent={{-20,-20},{20,20}},
                    rotation=0)));
            equation
              connect(pwLine1.n, pwLine3.p) annotation (Line(
                  points={{55,10},{61,10}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pwLine2.n,pwLine4. p) annotation (Line(
                  points={{55,-10},{61,-10}},
                  color={0,0,255},
                  smooth=Smooth.None));

              connect(pwLine3.p, pwLineFault.p) annotation (Line(points={{61,10},{61,30}}, color={0,0,255}));
              connect(pwLineFault.n, pwLine3.n) annotation (Line(points={{79,30},{79,10}}, color={0,0,255}));
              connect(pwFault.p, pwLine4.n) annotation (Line(points={{77,-30},{79,-30},{79,-10}}, color={0,0,255}));
              connect(pwLoadPQ2.p, pwLine4.n) annotation (Line(points={{90,-20},{90,-10},{79,-10}}, color={0,0,255}));
              connect(pwLoadPQ1.p, pwLine3.n) annotation (Line(points={{90.0709,6},{90,6},{90,10},{79,10}}, color={0,0,255}));
              connect(pwLine1.n, pwLine2.n) annotation (Line(points={{55,10},{55,10},{55,-10}}, color={0,0,255}));
              connect(gen.vf0, gen.vf) annotation (Line(points={{-16,22},{-16,28},{-32,28},{-32,10},{-24,10}}, color={0,0,127}));
              connect(gen.p, pwLine1.p) annotation (Line(points={{20,0},{37,0},{37,10}}, color={0,0,255}));
              connect(gen.p, pwLine2.p) annotation (Line(points={{20,0},{37,0},{37,-10}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(extent={{-100,-100},{100,100}},
                      preserveAspectRatio=false)),
                Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
                Documentation);
            end TGTestBase;
          annotation (Documentation);
          end TG;
        annotation (Documentation);
        end PSAT;

        package CGMES
          package ES
            model ExcSEXS "SMIB model example of GENROU with Excitation System ExcSEXS"
              extends OpenIPSL.Examples.SMIBpartial;
              Modelica.Blocks.Sources.Constant const2(k=0)
                annotation (Placement(transformation(extent={{-110,166},{-94,182}})));
              OpenIPSL.Electrical.Machines.PSSE.GENROU gENROE(
                M_b=100,
                Tpd0=5,
                Tppd0=0.07,
                Tpq0=0.9,
                Tppq0=0.09,
                D=0,
                Xd=1.84,
                Xq=1.75,
                Xpd=0.41,
                Xpq=0.6,
                Xppd=0.2,
                Xl=0.12,
                S10=0.11,
                S12=0.39,
                V_0=1,
                P_0=40,
                angle_0=4.046276,
                Q_0=5.416582,
                Xppq=0.2,
                R_a=0,
                Xpp=0.2,
                H=4.28) annotation (Placement(transformation(extent={{-110,-20},
                        {-70,20}})));
              Electrical.Controls.CGMES.ES.ExcSEXS sEXS(
                T_AT_B=0.1,
                T_B=1,
                K=100,
                T_E=0.1,
                E_MIN=-10,
                E_MAX=10,
                K_C=0.08,
                EFD_MAX=5,
                EFD_MIN=-5,
                T_C=1) annotation (Placement(transformation(extent={{-70,-54},{-108,-26}})));
              Modelica.Blocks.Sources.Constant const(k=0) annotation (Placement(
                    transformation(
                    extent={{4,-4},{-4,4}},
                    rotation=0,
                    origin={-50,-40})));
            equation
              connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-114,10},{-114,
                      10},{-114,26},{-60,26},{-60,10},{-68,10}}, color={0,0,127}));
              connect(gENROE.EFD0, sEXS.EFD0) annotation (Line(points={{-68,-10},{-60,-10},{-60,-48.5556},{-70,-48.5556}},
                                                     color={0,0,127}));
              connect(gENROE.ETERM, sEXS.ECOMP) annotation (Line(points={{-68,-6},{-64,-6},{-64,-38.4444},{-70,-38.4444}},
                                                     color={0,0,127}));
              connect(sEXS.VOEL, const.y) annotation (Line(points={{-82.35,-54},{-68,-54},{
                      -68,-40},{-54.4,-40}}, color={0,0,127}));
              connect(sEXS.VOTHSG, const.y) annotation (Line(points={{-70,-31.4444},{-64,-31.4444},{-64,-40},{-54.4,-40}},
                                              color={0,0,127}));
              connect(sEXS.VUEL, const.y) annotation (Line(points={{-76.65,-54},{-64,-54},{
                      -64,-40},{-54.4,-40}}, color={0,0,127}));
              connect(sEXS.EFD, gENROE.EFD) annotation (Line(points={{-108.95,-38.4444},{-114,-38.4444},{-114,-10},{-114,-10}},
                                                        color={0,0,127}));
              connect(gENROE.p, GEN1.p)
                annotation (Line(points={{-70,0},{-40,0},{-40,0}}, color={0,0,255}));
              connect(gENROE.XADIFD, sEXS.XADIFD) annotation (Line(points={{-68.4,-18},{-62,-18},{-62,-60},{-97.55,-60},{-97.55,-53.6889}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-120,-100},{
                        120,100}})),
                Documentation,
                Icon(coordinateSystem(extent={{-120,-100},{120,100}})),
                experiment(StopTime=10));
            end ExcSEXS;
          annotation (Icon(graphics={Rectangle(
                  lineColor={200,200,200},
                  fillColor={248,248,248},
                  fillPattern=FillPattern.HorizontalCylinder,
                  extent={{-100,-100},{100,100}},
                  radius=25.0),Polygon(
                  origin={18,24},
                  lineColor={78,138,73},
                  fillColor={78,138,73},
                  pattern=LinePattern.None,
                  fillPattern=FillPattern.Solid,
                  points={{-58.0,46.0},{42.0,-14.0},{-58.0,-74.0},{-58.0,46.0}})}),
              Documentation);
          end ES;
        annotation (Icon(graphics={Rectangle(
                lineColor={200,200,200},
                fillColor={248,248,248},
                fillPattern=FillPattern.HorizontalCylinder,
                extent={{-100,-100},{100,100}},
                radius=25.0),Polygon(
                origin={18,24},
                lineColor={78,138,73},
                fillColor={78,138,73},
                pattern=LinePattern.None,
                fillPattern=FillPattern.Solid,
                points={{-58.0,46.0},{42.0,-14.0},{-58.0,-74.0},{-58.0,46.0}})}),
            Documentation);
        end CGMES;
      annotation (Documentation);
      end Controls;

      package Events
        extends Modelica.Icons.ExamplesPackage;

        model TestBreaker "Example model to test the breaker model"
          extends Modelica.Icons.Example;

          inner Electrical.SystemBase SysData annotation (Placement(transformation(extent={{-100,80},{-76,100}})));
          Electrical.Buses.InfiniteBus infiniteBusExt(displayPF=true) annotation (Placement(transformation(extent={{-80,20},{-60,40}})));
          Electrical.Loads.PSAT.LOADPQ lOADPQExt annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={50,30})));
          Electrical.Events.Breaker breakerExt(t_o=0.5, enableTrigger=true) annotation (Placement(transformation(extent={{-10,20},{10,40}})));
          Electrical.Buses.InfiniteBus infiniteBusPara(displayPF=true) annotation (Placement(transformation(extent={{-80,-40},{-60,-20}})));
          Electrical.Loads.PSAT.LOADPQ lOADPQPara annotation (Placement(transformation(
                extent={{-10,-10},{10,10}},
                rotation=90,
                origin={50,-30})));
          Electrical.Events.Breaker breakerPara(
            t_o=0.5,
            rc_enabled=true,
            t_rc=0.7) annotation (Placement(transformation(extent={{-10,-40},{10,-20}})));
          Modelica.Blocks.Sources.BooleanPulse booleanPulse(period=0.1, startTime=0.1) annotation (Placement(transformation(extent={{-40,60},{-20,80}})));
          Electrical.Branches.PwLine pwLineExt(
            R=1,
            X=1,
            G=1,
            B=1,
            displayPF=true)
                 annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
          Electrical.Branches.PwLine pwLinePara(
            R=1,
            X=1,
            G=1,
            B=1,
            displayPF=true)
                 annotation (Placement(transformation(extent={{-40,-40},{-20,-20}})));
        equation
          connect(lOADPQExt.p, breakerExt.r) annotation (Line(points={{40,30},{10,30}}, color={0,0,255}));
          connect(lOADPQPara.p, breakerPara.r) annotation (Line(points={{40,-30},{10,-30}}, color={0,0,255}));
          connect(booleanPulse.y, breakerExt.Trigger) annotation (Line(points={{-19,70},{0,70},{0,42}}, color={255,0,255}));
          connect(breakerExt.s, pwLineExt.n) annotation (Line(points={{-10,30},{-21,30}}, color={0,0,255}));
          connect(pwLineExt.p, infiniteBusExt.p) annotation (Line(points={{-39,30},{-60,30}}, color={0,0,255}));
          connect(breakerPara.s, pwLinePara.n) annotation (Line(points={{-10,-30},{-21,-30}}, color={0,0,255}));
          connect(pwLinePara.p, infiniteBusPara.p) annotation (Line(points={{-39,-30},{-60,-30}}, color={0,0,255}));
          annotation (experiment(StopTime=1.0));
        end TestBreaker;
      end Events;

      package Loads
      extends Modelica.Icons.ExamplesPackage;

        package PSAT
        extends Modelica.Icons.ExamplesPackage;

          model Loadtestpq
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ LOADPQ1(
              Sn=10,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={122.1536,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData
              annotation (Placement(transformation(extent={{50,80},{75,100}})));
          equation
            connect(pwLine4.n, LOADPQ1.p) annotation (Line(
                visible=true,
                origin={101.5768,-15.0},
                points={{-7.5768,0},{20.5768,0},{20.5768,10}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestpq;

          model Loadtestexponentialrecovery
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.ExponentialRecovery exponentialRecovery1(
              V_0=0.993325452568749,
              alpha_t=1.5,
              beta_t=1.5,
              Sn=10,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={125.0,-17.844},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{100,80},{125,100}})));
          equation
            connect(pwLine4.n, exponentialRecovery1.p) annotation (Line(
                visible=true,
                origin={107.0,-16.422},
                points={{-13,1.422},{4,1.422},{4,8.578},{18,8.578}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestexponentialrecovery;

          model Loadtestvoltagedependantload
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDepend1(
              Sn=10,
              V_0=0.993325452568749,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={125.0,-45.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{100,80},{125,100}})));
          equation
            connect(pwLine3.n, voltDepend1.p) annotation (Line(
                visible=true,
                origin={107.0,-40.0},
                points={{-13,5},{4,5},{4,5},{18,5}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestvoltagedependantload;

          model Loadtestzip
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.ZIP ZIP1(
              Sn=10,
              V_0=0.993325452568749,
              Pz=0.5,
              Pi=0.3,
              Qz=0.5,
              Qi=0.3,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={123.3697,-10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{100,80},{125,100}})));
          equation
            connect(pwLine4.n, ZIP1.p) annotation (Line(
                visible=true,
                origin={105.7773,-12.5},
                points={{-11.7773,-2.5},{3.5924,-2.5},{3.5924,12.5},{17.5924,12.5}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestzip;

          model Loadtestfreq
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.FrequencyDependentLoad frequencyDependentLoad1(
              alpha_p=0,
              beta_p=1,
              beta_q=1,
              Sn=10,
              V_0=0.993325452568749,
              angle_0=-0.00746932024404292,
              alpha_q=0,
              Tf=0.1,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={123.3697,-45.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{100,80},{125,100}})));
          equation
            connect(pwLine3.n, frequencyDependentLoad1.p) annotation (Line(
                visible=true,
                origin={105.7773,-40.0},
                points={{-11.7773,5},{3.5924,5},{3.5924,5},{17.5924,5}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestfreq;

          model Loadtestmixed
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.Mixed_Load mixed_Load1(
              V_0=0.993325452568749,
              Sn=10,
              Tpv=0.1,
              Tqv=0.1,
              Tfv=0.1,
              Tft=0.1,
              Kpf=1,
              Kqf=1,
              alpha=1,
              beta=1,
              angle_0=-0.00746932024404292,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={125.0,-40.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{100,80},{125,100}})));
          equation
            connect(mixed_Load1.p, pwLine3.n) annotation (Line(
                visible=true,
                origin={100.5,-37.5},
                points={{24.5,7.5},{-2.5,7.5},{-2.5,2.5},{-6.5,2.5}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestmixed;

          model Loadtestzipjimma
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              X=0.1,
              R=0.01,
              G=0,
              B=0.001/2) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-35.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={39.8634,-15.6714},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-35.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={85.0,-15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add31 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,13.9829},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,34.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(height=0.0005, startTime=2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,40.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(height=-0.0005, startTime=2.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,25.985},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,10.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,14.6621},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine3(
              amplitude=0.001,
              freqHz=0.2,
              startTime=10) annotation (Placement(visible=true, transformation(
                  origin={-107.3823,-76.5048},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-56.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine4(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-107.7833,-60.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step3(height=-0.0005, startTime=7.1) annotation (
               Placement(visible=true, transformation(
                  origin={-107.7833,-45.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step4(height=0.0005, startTime=7) annotation (
                Placement(visible=true, transformation(
                  origin={-107.7833,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add4 annotation (Placement(visible=true,
                  transformation(
                  origin={-79.1062,-36.3229},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Math.Add3 add32 annotation (Placement(visible=true,
                  transformation(
                  origin={-45.0,-57.0021},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order3_Inputs_Outputs1(
              P_0=0.0800989878477798,
              Q_0=0.0570163388727956,
              Sn=20,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={3.3113,-20.7513},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.ZIP_Jimma ZIP_Jimma1(
              V_0=0.993325565105317,
              Sn=10,
              Tf=0.1,
              P_0=0.8,
              Q_0=0.6) annotation (Placement(visible=true, transformation(
                  origin={125.0,-5.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{100,80},{135,100}})));
          equation
            connect(pwLine4.n, ZIP_Jimma1.p) annotation (Line(
                visible=true,
                origin={107.0,-10.0},
                points={{-13,-5},{4,-5},{4,15},{18,15}}));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                visible=true,
                origin={92.0,-25.0},
                points={{2,10},{2,5},{5,5},{5,0},{2,0},{2,-10}}));
            connect(pwLine3.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={78.0,-25.0},
                points={{-2,-10},{-2,-5},{-5,-5},{-5,0},{-2,0},{-2,10}}));
            connect(pwLine1.n, pwLine3.p) annotation (Line(
                visible=true,
                origin={67.2159,-35.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(pwLine2.n, pwLine4.p) annotation (Line(
                visible=true,
                origin={67.2159,-15.3357},
                points={{-18.3525,-0.3357},{4.7841,-0.3357},{4.7841,0.3357},{8.7841,0.3357}}));
            connect(order3_Inputs_Outputs1.pm0, add32.u3) annotation (Line(
                visible=true,
                origin={-19.0108,-51.4898},
                points={{14.3221,19.7385},{41.1619,19.7385},{41.1619,-23.5102},{-38.8284,
                    -23.5102},{-38.8284,-13.5123},{-37.9892,-13.5123}},
                color={0,0,127}));
            connect(order3_Inputs_Outputs1.vf0, add31.u3) annotation (Line(
                visible=true,
                origin={-21.3443,-2.9483},
                points={{16.6556,-6.803},{38.6557,-6.803},{38.6557,-0.1282},{-38.6557,-0.1282},
                    {-38.6557,8.9312},{-35.6557,8.9312}},
                color={0,0,127}));
            connect(add31.y, order3_Inputs_Outputs1.vf) annotation (Line(
                visible=true,
                origin={-28.1135,-5.371},
                points={{-5.8865,19.3539},{-2.8865,19.3539},{-2.8865,-9.629},{-3.8826,-9.629},{-3.8826,-10.3803},{19.4248,-10.3803}},
                color={0,0,127}));
            connect(add32.y, order3_Inputs_Outputs1.pm) annotation (Line(
                visible=true,
                origin={-28.216,-45.5845},
                points={{-5.784,-11.4176},{-2.784,-11.4176},{-2.784,-9.4155},{-4.0877,-9.4155},{-4.0877,19.8332},{19.5273,19.8332}},
                color={0,0,127}));
            connect(step3.y, add4.u2) annotation (Line(
                visible=true,
                origin={-92.0911,-42.5583},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(add3.y, add32.u2) annotation (Line(
                visible=true,
                origin={-62.2878,-56.6625},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(step4.y, add4.u1) annotation (Line(
                visible=true,
                origin={-92.0911,-31.2646},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add4.y, add32.u1) annotation (Line(
                visible=true,
                origin={-62.2878,-42.6625},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add3.u2, sine3.y) annotation (Line(
                visible=true,
                origin={-95.6692,-69.1821},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(sine4.y, add3.u1) annotation (Line(
                visible=true,
                origin={-93.5606,-55.5207},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(sine1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-93.5606,15.4643},
                points={{-9.29448,-4.9991},{-1.4394,-0.9841},{3.8669,2.9916},{6.86692,
                    2.99154}},
                color={0,0,127}));
            connect(add2.u2, sine2.y) annotation (Line(
                visible=true,
                origin={-95.6692,1.8029},
                points={{8.97552,9.06546},{2.2971,9.06546},{2.2971,-5.4041},{-6.78488,-5.4041},
                    {-6.78488,-7.3227}},
                color={0,0,127}));
            connect(step2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-92.0911,28.4267},
                points={{-10.1922,-2.4417},{2.3974,-2.4417},{2.3974,2.44166},{5.39742,
                    2.44166}},
                color={0,0,127}));
            connect(step1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-92.0911,39.7204},
                points={{-10.1922,1.2646},{2.3974,1.2646},{2.3974,-1.26456},{5.39742,-1.26456}},
                color={0,0,127}));

            connect(add1.y, add31.u1) annotation (Line(
                visible=true,
                origin={-62.2878,28.3225},
                points={{-9.86321,6.3396},{2.2878,6.3396},{2.2878,-6.3396},{5.2878,-6.3396}},
                color={0,0,127}));

            connect(add2.y, add31.u2) annotation (Line(
                visible=true,
                origin={-62.2878,14.3225},
                points={{-9.86321,0.3396},{2.2878,0.3396},{2.2878,-0.3396},{5.2878,-0.3396}},
                color={0,0,127}));

            connect(order3_Inputs_Outputs1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={25.2254,-18.2865},
                points={{-11.9141,-2.4648},{1.638,-2.4648},{1.638,2.6151},{5.638,2.6151}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={32.8634,-25.6714},
                points={{-2,10},{-2,5},{-5,5},{-5,0},{-2,0},{-2,-10}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={39.8634,3.4703},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end Loadtestzipjimma;
        annotation (Documentation);
        end PSAT;
      annotation (Documentation);
      end Loads;

      package Solar
      extends Modelica.Icons.ExamplesPackage;

        package PSAT
        extends Modelica.Icons.ExamplesPackage;

          model SolarPQtest
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Solar.PSAT.ConstantPQPV.PQ1 PQ11(
              P_0=0.4,
              Q_0=0.3,
              V_0=1.00018548610126,
              angle_0=-0.0000253046024029618) annotation (Placement(visible=
                    true, transformation(
                  origin={35.0,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-70.0,-10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Events.PwFault pwFault1(
              R=20,
              X=1,
              t1=3,
              t2=3.1) annotation (Placement(visible=true, transformation(
                  origin={20.0,-57.3},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLinewithOpening1(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1,
              t1=8,
              t2=8.1) annotation (Placement(visible=true, transformation(
                  origin={-25.0,0.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-70.0,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-25.0,-30.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-25.0,15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ pwLoadPQ2(
              P_0=0.08,
              Q_0=0.06,
              V_0=1,
              angle_0=0) annotation (Placement(visible=true, transformation(
                  origin={15.0,-30.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order31(
              Sn=20,
              P_0=0.0401256732154526,
              Q_0=0.0262725307404601,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={-110.0,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus1 annotation (Placement(visible=
                    true, transformation(
                  origin={-87.5421,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus2 annotation (Placement(visible=
                    true, transformation(
                  origin={-46.7243,11.8063},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus3 annotation (Placement(visible=
                    true, transformation(
                  origin={5.0,12.1033},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus4 annotation (Placement(visible=
                    true, transformation(
                  origin={-3.3112,-30.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData
              annotation (Placement(transformation(extent={{50,50},{75,70}})));
          equation
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={-77.0,0.0},
                points={{-4.66667,10},{-4.66667,5},{-5,5},{-5,0},{-4.66667,0},{-4.66667,-10}}));
            connect(pwLine1.n, pwLine2.n) annotation (Line(
                visible=true,
                origin={-63.0,0.0},
                points={{4.66667,-10},{4.66667,-5},{5,-5},{5,0},{4.66667,0},{4.66667,10}}));
            connect(pwLine4.p, pwLinewithOpening1.p) annotation (Line(
                visible=true,
                origin={-32.0,7.5},
                points={{0.0,7.5},{0.0,-7.5}}));
            connect(pwLinewithOpening1.n, pwLine4.n) annotation (Line(
                visible=true,
                origin={-18.0,7.5},
                points={{0.0,-7.5},{0.0,7.5}}));
            connect(bus1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={-82.2711,10.0},
                points={{-5.271,0},{0.604433,0}}));
            connect(pwLine2.n, bus2.p) annotation (Line(
                visible=true,
                origin={-52.1495,10.6021},
                points={{-6.18383,-0.6021},{5.4252,-0.6021},{5.4252,1.2042}}));
            connect(bus2.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={-41.8162,13.9354},
                points={{-4.9081,-2.1291},{-4.9081,1.0646},{5.14953,1.0646}}));
            connect(bus2.p, pwLine3.p) annotation (Line(
                visible=true,
                origin={-41.8162,-16.0646},
                points={{-4.9081,27.8709},{-4.9081,-13.9354},{5.14953,-13.9354}}));
            connect(pwLine4.n, bus3.p) annotation (Line(
                visible=true,
                origin={-7.25,13.5517},
                points={{-6.08333,1.4483},{-0.75,1.4483},{-0.75,-1.4484},{12.25,-1.4484}}));
            connect(pwLine3.n, bus4.p) annotation (Line(
                visible=true,
                origin={-10.6556,-30.0},
                points={{-2.67773,0},{7.3444,0}}));
            connect(bus4.p, pwLoadPQ2.p) annotation (Line(
                visible=true,
                origin={0.4592,-29.3333},
                points={{-3.7704,-0.6667},{-3.7704,10.3333},{14.5408,10.3333}}));
            connect(bus4.p, pwFault1.p) annotation (Line(
                visible=true,
                origin={2.1259,-47.5333},
                points={{-5.4371,17.5333},{-5.4371,-9.7667},{6.20743,-9.7667}}));
            connect(bus1.p, order31.p) annotation (Line(
                visible=true,
                origin={-91.3614,9.8998},
                points={{3.8193,0.1002},{3.8193,0.14984},{-7.6386,0.14984}}));
            connect(PQ11.p, bus3.p) annotation (Line(
                visible=true,
                origin={17.4388,13.7927},
                points={{6.5612,-3.7927},{6.2194,-1.6893},{-12.4388,-1.6894}}));
            connect(order31.vf0, order31.vf) annotation (Line(points={{-118,21},{-118,25},
                    {-125,25},{-125,15},{-120,15}}, color={0,0,127}));
            connect(order31.pm, order31.pm0) annotation (Line(points={{-120,5},{-125,5},{
                    -125,-5},{-118,-5},{-118,-1}}, color={0,0,127}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105},{148.5,105}},
                  preserveAspectRatio=false,
                  initialScale=0.1,
                  grid={5,5})), Documentation);
          end SolarPQtest;

          model SolarPVtest
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-70.0,-10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Events.PwFault pwFault1(
              R=20,
              X=1,
              t1=3,
              t2=3.1) annotation (Placement(visible=true, transformation(
                  origin={20.0,-57.3},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLinewithOpening1(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1,
              t1=8,
              t2=8.1) annotation (Placement(visible=true, transformation(
                  origin={-25.0,0.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-70.0,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-25.0,-30.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-25.0,15.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ pwLoadPQ2(
              P_0=0.08,
              Q_0=0.06,
              V_0=1,
              angle_0=0) annotation (Placement(visible=true, transformation(
                  origin={15.0,-30.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order3 order31(
              Sn=20,
              P_0=0.0401256732154526,
              Q_0=0.0262725307404601,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10,
              D=0,
              xd=1.9,
              T1d0=8,
              xq=1.7) annotation (Placement(visible=true, transformation(
                  origin={-110.0,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus1 annotation (Placement(visible=
                    true, transformation(
                  origin={-87.5421,10.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus2 annotation (Placement(visible=
                    true, transformation(
                  origin={-46.7243,11.8063},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus3 annotation (Placement(visible=
                    true, transformation(
                  origin={5.0,12.1033},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.Bus bus4 annotation (Placement(visible=
                    true, transformation(
                  origin={-3.3112,-30.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Solar.PSAT.ConstantPQPV.PV1 PV11(
              Q_0=0.283430554716626,
              angle_0=-0.00000839852213846341,
              V_0=1.00002,
              vref=1.00002,
              P_0=0.4) annotation (Placement(visible=true, transformation(
                  origin={30.0,12.1033},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData
              annotation (Placement(transformation(extent={{55,50},{80,70}})));
          equation
            connect(bus3.p, PV11.p) annotation (Line(
                visible=true,
                origin={12.0,12.1033},
                points={{-7,0},{7,0}}));
            connect(pwLine2.p, pwLine1.p) annotation (Line(
                visible=true,
                origin={-77.0,0.0},
                points={{-4.66667,10},{-4.66667,5},{-5,5},{-5,0},{-4.66667,0},{-4.66667,-10}}));
            connect(pwLine1.n, pwLine2.n) annotation (Line(
                visible=true,
                origin={-63.0,0.0},
                points={{4.66667,-10},{4.66667,-5},{5,-5},{5,0},{4.66667,0},{4.66667,10}}));
            connect(pwLine4.p, pwLinewithOpening1.p) annotation (Line(
                visible=true,
                origin={-32.0,7.5},
                points={{0.0,7.5},{0.0,-7.5}}));
            connect(pwLinewithOpening1.n, pwLine4.n) annotation (Line(
                visible=true,
                origin={-18.0,7.5},
                points={{0.0,-7.5},{0.0,7.5}}));
            connect(bus1.p, pwLine2.p) annotation (Line(
                visible=true,
                origin={-82.2711,10.0},
                points={{-5.271,0},{0.604433,0}}));
            connect(pwLine2.n, bus2.p) annotation (Line(
                visible=true,
                origin={-52.1495,10.6021},
                points={{-6.18383,-0.6021},{5.4252,-0.6021},{5.4252,1.2042}}));
            connect(bus2.p, pwLine4.p) annotation (Line(
                visible=true,
                origin={-41.8162,13.9354},
                points={{-4.9081,-2.1291},{-4.9081,1.0646},{5.14953,1.0646}}));
            connect(bus2.p, pwLine3.p) annotation (Line(
                visible=true,
                origin={-41.8162,-16.0646},
                points={{-4.9081,27.8709},{-4.9081,-13.9354},{5.14953,-13.9354}}));
            connect(pwLine4.n, bus3.p) annotation (Line(
                visible=true,
                origin={-7.25,13.5517},
                points={{-6.08333,1.4483},{-0.75,1.4483},{-0.75,-1.4484},{12.25,-1.4484}}));
            connect(pwLine3.n, bus4.p) annotation (Line(
                visible=true,
                origin={-10.6556,-30.0},
                points={{-2.67773,0},{7.3444,0}}));
            connect(bus4.p, pwLoadPQ2.p) annotation (Line(
                visible=true,
                origin={0.4592,-29.3333},
                points={{-3.7704,-0.6667},{-3.7704,10.3333},{14.5408,10.3333}}));
            connect(bus4.p, pwFault1.p) annotation (Line(
                visible=true,
                origin={2.1259,-47.5333},
                points={{-5.4371,17.5333},{-5.4371,-9.7667},{6.20743,-9.7667}}));
            connect(bus1.p, order31.p) annotation (Line(
                visible=true,
                origin={-91.3614,9.8998},
                points={{3.8193,0.1002},{3.8193,0.14984},{-7.6386,0.14984}}));
            connect(order31.vf0, order31.vf) annotation (Line(points={{-118,21},{-118,25},
                    {-130,25},{-130,15},{-120,15}}, color={0,0,127}));
            connect(order31.pm, order31.pm0) annotation (Line(points={{-120,5},{-130,5},{
                    -130,-5},{-118,-5},{-118,-1}}, color={0,0,127}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105},{148.5,105}},
                  preserveAspectRatio=false,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={-70.0,29.1417},
                    fillPattern=FillPattern.Solid,
                    extent={{-35.0,-5.8583},{35.0,5.8583}},
                    textString="SystemSbase=100 MVA",
                    fontName="Arial")}), Documentation);
          end SolarPVtest;

          model testTemperature
            extends Modelica.Icons.Example;
            Modelica.Blocks.Sources.Constant const(k=1000) annotation (Placement(visible=
                    true, transformation(
                  origin={-73.3987,11.6013},
                  extent={{-3.3987,-3.3987},{3.3987,3.3987}},
                  rotation=0)));
            Modelica.Blocks.Sources.Constant const1(k=25) annotation (Placement(visible=
                    true, transformation(
                  origin={-85.0,-8.3987},
                  extent={{-3.3987,-3.3987},{3.3987,3.3987}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine13(
              B=0,
              G=0,
              R=0,
              X=0.04*1/0.63) annotation (Placement(visible=true, transformation(
                  origin={49.0376,0.0024},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine14(
              B=0.001884956/2*100,
              G=0,
              R=0,
              X=0.848230016469244/100) annotation (Placement(visible=true,
                  transformation(
                  origin={83.1777,5.4501},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus8(angle_0=0, V_0=1)
              annotation (Placement(visible=true, transformation(
                  origin={117.9874,-1.1504},
                  extent={{10.0,-10.0},{-10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine15(
              B=0.001884956/2*100,
              G=0,
              R=0,
              X=0.848230016469244/100) annotation (Placement(visible=true,
                  transformation(
                  origin={83.2752,-9.5499},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-50.0,-16.424},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(startTime=0.3, height=15) annotation (
                Placement(visible=true, transformation(
                  origin={-110.8976,-31.3287},
                  extent={{-4.1024,-4.1024},{4.1024,4.1024}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(startTime=0.7, height=-15) annotation (
                Placement(visible=true, transformation(
                  origin={-110.0,-61.3488},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2 annotation (Placement(visible=true,
                  transformation(
                  origin={-82.1332,-43.3987},
                  extent={{-2.8669,-2.8669},{2.8669,2.8669}},
                  rotation=0)));
            OpenIPSL.Electrical.Solar.KTH.PFmodelmpptCorrected05MW PFmodel1(
              anglev0=0.030372922116265,
              p0=0.44884,
              q0=0.00003,
              v0=1.0003436) annotation (Placement(visible=true, transformation(
                  origin={-7.9875,0.0},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData
              annotation (Placement(transformation(extent={{50,50},{70,70}})));
          equation
            connect(add1.y, PFmodel1.T) annotation (Line(
                visible=true,
                origin={-26.2406,-10.712},
                points={{-12.7594,-5.712},{3.2531,-5.712},{3.2531,5.712},{6.2531,5.712}},
                color={0,0,127}));

            connect(const.y, PFmodel1.E) annotation (Line(
                visible=true,
                origin={-33.9057,8.3006},
                points={{-35.7544,3.3007},{10.9182,3.3007},{10.9182,-3.3006},{13.9182,-3.3006}},
                color={0,0,127}));

            connect(PFmodel1.pwPin1, pwLine13.p) annotation (Line(
                visible=true,
                origin={32.2688,0.1454},
                points={{-29.2563,-0.1454},{9.7437,-0.1454},{9.7437,-0.143},{5.10213,-0.143}}));
            connect(const1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-68.3155,-9.4113},
                points={{-12.9459,1.0126},{3.3154,1.0126},{3.3154,-1.0127},{6.3155,-1.0127}},
                color={0,0,127}));

            connect(add2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-73.3198,-29.4155},
                points={{-5.65981,-13.9832},{-5.65981,6.9916},{11.3198,6.9915}},
                color={0,0,127}));
            connect(step1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-92.2764,-36.5036},
                points={{-14.1086,5.1749},{3.7029,5.1749},{3.7029,-5.17496},{6.70292,-5.17496}},
                color={0,0,127}));

            connect(add2.u2, step2.y) annotation (Line(
                visible=true,
                origin={-98.2684,-53.2338},
                points={{12.6949,8.11496},{-3.2317,8.11496},{-3.2317,-8.115},{-6.2316,-8.115}},
                color={0,0,127}));

            connect(pwLine13.n, pwLine14.p) annotation (Line(
                visible=true,
                origin={68.1427,2.7263},
                points={{-7.43843,-2.7239},{2.035,-2.7239},{2.035,2.7238},{3.36833,2.7238}}));
            connect(pwLine14.n, pwLine15.n) annotation (Line(
                visible=true,
                origin={90.2103,-4.5499},
                points={{4.63407,10},{4.63407,-5},{4.73157,-5}}));
            connect(pwLine14.p, pwLine15.p) annotation (Line(
                visible=true,
                origin={76.2102,-4.5499},
                points={{-4.69917,10},{-4.69917,-5},{-4.60167,-5}}));
            connect(infiniteBus8.p, pwLine14.n) annotation (Line(
                visible=true,
                origin={97.3801,2.1498},
                points={{31.6073,-3.3002},{-1.2024,-3.3002},{-1.2024,3.3003},{-2.53573,
                    3.3003}}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={136.1319,30.0},
                    fillPattern=FillPattern.Solid,
                    extent={{-41.1319,-13.2857},{41.1319,13.2857}},
                    textString="VoltageGrid=10000 (1p.u.)",
                    fontName="Arial")}), Documentation);
          end testTemperature;

          model testIrradation
            extends Modelica.Icons.Example;
            Modelica.Blocks.Sources.Constant const(k=25) annotation (Placement(visible=
                    true, transformation(
                  origin={-59.5887,-17.0499},
                  extent={{-3.3987,-3.3987},{3.3987,3.3987}},
                  rotation=0)));
            Modelica.Blocks.Sources.Constant const1(k=1000) annotation (Placement(visible=
                   true, transformation(
                  origin={-87.9874,22.9501},
                  extent={{-3.3987,-3.3987},{3.3987,3.3987}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine13(
              B=0,
              G=0,
              R=0,
              X=0.04*1/0.63) annotation (Placement(visible=true, transformation(
                  origin={49.0376,0.0024},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine14(
              B=0.001884956/2*100,
              G=0,
              R=0,
              X=0.848230016469244/100) annotation (Placement(visible=true,
                  transformation(
                  origin={83.1777,5.4501},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus8(angle_0=0, V_0=1)
              annotation (Placement(visible=true, transformation(
                  origin={117.9874,-1.1504},
                  extent={{10.0,-10.0},{-10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine15(
              B=0.001884956/2*100,
              G=0,
              R=0,
              X=0.848230016469244/100) annotation (Placement(visible=true,
                  transformation(
                  origin={83.2752,-9.5499},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add1 annotation (Placement(visible=true,
                  transformation(
                  origin={-52.9874,14.9248},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step1(startTime=0.3, height=-500) annotation (
                Placement(visible=true, transformation(
                  origin={-113.885,0.0201},
                  extent={{-4.1024,-4.1024},{4.1024,4.1024}},
                  rotation=0)));
            Modelica.Blocks.Sources.Step step2(startTime=0.7, height=500) annotation (
                Placement(visible=true, transformation(
                  origin={-112.9874,-30.0},
                  extent={{-5.0,-5.0},{5.0,5.0}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2 annotation (Placement(visible=true,
                  transformation(
                  origin={-85.1206,-12.0499},
                  extent={{-2.8669,-2.8669},{2.8669,2.8669}},
                  rotation=0)));
            OpenIPSL.Electrical.Solar.KTH.PFmodelmpptCorrected05MW PFmodel1(
              anglev0=0.030372922116265,
              p0=0.44884,
              q0=0.00003,
              v0=1.00034051839501) annotation (Placement(visible=true,
                  transformation(
                  origin={-7.9875,0.2883},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            inner OpenIPSL.Electrical.SystemBase SysData
              annotation (Placement(transformation(extent={{50,50},{75,70}})));
          equation
            connect(const1.y, add1.u1) annotation (Line(
                visible=true,
                origin={-71.3029,21.9375},
                points={{-12.9459,1.0126},{3.3154,1.0126},{3.3154,-1.0127},{6.3155,-1.0127}},
                color={0,0,127}));

            connect(add2.y, add1.u2) annotation (Line(
                visible=true,
                origin={-76.3072,1.9333},
                points={{-5.65981,-13.9832},{-5.65981,6.9915},{11.3198,6.9915}},
                color={0,0,127}));
            connect(step1.y, add2.u1) annotation (Line(
                visible=true,
                origin={-95.2638,-5.1548},
                points={{-14.1086,5.1749},{3.7029,5.1749},{3.7029,-5.17496},{6.70292,-5.17496}},
                color={0,0,127}));

            connect(add2.u2, step2.y) annotation (Line(
                visible=true,
                origin={-101.2558,-21.885},
                points={{12.6949,8.11496},{-3.2317,8.11496},{-3.2317,-8.115},{-6.2316,-8.115}},
                color={0,0,127}));

            connect(pwLine13.n, pwLine14.p) annotation (Line(
                visible=true,
                origin={68.1427,2.7263},
                points={{-7.43843,-2.7239},{2.035,-2.7239},{2.035,2.7238},{3.36833,2.7238}}));
            connect(pwLine14.n, pwLine15.n) annotation (Line(
                visible=true,
                origin={90.2103,-4.5499},
                points={{4.63407,10},{4.63407,-5},{4.73157,-5}}));
            connect(pwLine14.p, pwLine15.p) annotation (Line(
                visible=true,
                origin={76.2102,-4.5499},
                points={{-4.69917,10},{-4.69917,-5},{-4.60167,-5}}));
            connect(infiniteBus8.p, pwLine14.n) annotation (Line(
                visible=true,
                origin={97.3801,2.1498},
                points={{31.6073,-3.3002},{-1.2024,-3.3002},{-1.2024,3.3003},{-2.53573,
                    3.3003}}));
            connect(const.y, PFmodel1.T) annotation (Line(
                visible=true,
                origin={-30.4532,-10.8808},
                points={{-25.3969,-6.1691},{7.4657,-6.1691},{7.4657,6.1691},{10.4657,
                    6.1691}},
                color={0,0,127}));
            connect(PFmodel1.pwPin1, pwLine13.p) annotation (Line(
                visible=true,
                origin={32.2688,0.1454},
                points={{-29.2563,0.1429},{9.7437,0.1429},{9.7437,-0.143},{5.10213,-0.143}}));
            connect(add1.y, PFmodel1.E) annotation (Line(
                visible=true,
                origin={-26.9875,10.1066},
                points={{-14.9999,4.8182},{4,4.8183},{4,-4.8183},{7,-4.8183}},
                color={0,0,127}));
            annotation (Diagram(coordinateSystem(
                  extent={{-148.5,-105.0},{148.5,105.0}},
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={5,5}), graphics={Text(
                    visible=true,
                    origin={136.1319,30.0},
                    fillPattern=FillPattern.Solid,
                    extent={{-41.1319,-13.2857},{41.1319,13.2857}},
                    textString="VoltageGrid=10000 (1p.u.)",
                    fontName="Arial")}), Documentation);
          end testIrradation;
        annotation (Documentation);
        end PSAT;
      annotation (Documentation);
      end Solar;

      package Wind
      extends Modelica.Icons.ExamplesPackage;

        model PSAT_WT_Test
          extends Modelica.Icons.Example;
          OpenIPSL.Electrical.Wind.PSAT.PSAT_Type_3.PSAT_WT dfig_Turbine1(
            V_b=1,
            angle_0=0.00161587015139445,
            P_0=0.016,
            Q_0=-0.002086945,
            fn=50,
            poles=2,
            vw_base=15,
            Pnom=10,
            ngb=1/89) annotation (Placement(visible=true, transformation(
                origin={46.6515,15.0},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine5(
            B=0.001,
            G=0,
            R=0.01,
            X=0.1) annotation (Placement(visible=true, transformation(
                origin={6.551,15.0},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Wind.WindGenerator windGenerator1(
            v0=0.537631527453836,
            typ=3,
            tstop=15,
            sigma=1,
            vmax=25/15,
            wmag=-0.2) annotation (Placement(visible=true, transformation(
                origin={25.0,40.0},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0=1, angle_0=0)
            annotation (Placement(visible=true, transformation(
                origin={-28.2108,15.0},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
        equation
          connect(infiniteBus1.p, pwLine5.p) annotation (Line(
              visible=true,
              origin={-8.8299,15.0},
              points={{-30.3809,0},{3.71423,0}},
              color={0,0,255}));
          connect(windGenerator1.Vw, dfig_Turbine1.Wind_Speed) annotation (Line(
              visible=true,
              origin={43.101,34.2663},
              points={{-7.101,5.7337},{3.5505,5.7337},{3.5505,-11.4673}},
              color={0,0,127}));
          connect(pwLine5.n, dfig_Turbine1.pin) annotation (Line(
              visible=true,
              origin={24.6013,15.0},
              points={{-6.38363,0},{11.0502,0}},
              color={0,0,255}));
          annotation (Diagram(coordinateSystem(
                extent={{-148.5,-105.0},{148.5,105.0}},
                preserveAspectRatio=true,
                initialScale=0.1,
                grid={5,5})), Documentation);
        end PSAT_WT_Test;

        model GE_WT_Test
          extends Modelica.Icons.Example;
          OpenIPSL.Electrical.Wind.GE.Type_3.GE_WT GE_WT_init1 annotation (
              Placement(visible=true, transformation(
                origin={75.0,1.7487},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Buses.InfiniteBus infBus2(angle_0=-0.000216626610049175,
              V_0=1.05999999985841) annotation (Placement(visible=true,
                transformation(
                origin={-42.5798,1.9703},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine2(
            R=0.009,
            X=0.065,
            B=0.063,
            G=0) annotation (Placement(visible=true, transformation(
                origin={-1.6888,1.6478},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine3(
            R=0.0006,
            X=0.0333,
            G=0,
            B=0) annotation (Placement(visible=true, transformation(
                origin={16.9703,1.7398},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine4(
            R=0.05,
            X=0.015,
            B=0.045,
            G=0) annotation (Placement(visible=true, transformation(
                origin={35.0,1.6888},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine5(
            R=0.00222,
            X=0.0222,
            G=0,
            B=0) annotation (Placement(visible=true, transformation(
                origin={53.0297,1.8373},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Wind.WindGenerator windGenerator1 annotation (
              Placement(visible=true, transformation(
                origin={50.0,17.493},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine1(
            R=0.013,
            X=0.13,
            G=0,
            B=0) annotation (Placement(visible=true, transformation(
                origin={-20.0,1.7863},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Events.PwFault pwFault1(
            R=1/99999.999,
            t1=10,
            t2=10.1,
            X=1/99999.999) annotation (Placement(visible=true, transformation(
                origin={0.9428,15.0},
                extent={{-14.0572,-11.7143},{14.0572,11.7143}},
                rotation=0)));
        equation
          connect(infBus2.p, pwLine1.p) annotation (Line(
              visible=true,
              origin={-30.0532,1.8477},
              points={{-23.5266,0.1226},{-23.5266,-0.0614},{-1.61347,-0.0614}},
              color={0,0,255}));
          connect(pwLine1.n, pwFault1.p) annotation (Line(
              visible=true,
              origin={-11.6324,11.3764},
              points={{3.29907,-9.5901},{3.29907,3.6236},{-3.82487,3.6236}},
              color={0,0,255}));
          connect(pwLine1.n, pwLine2.p) annotation (Line(
              visible=true,
              origin={-11.5629,1.694},
              points={{3.22957,0.0923},{3.22957,-0.0462},{-1.79257,-0.0462}},
              color={0,0,255}));
          connect(pwLine2.n, pwLine3.p) annotation (Line(
              visible=true,
              origin={6.8642,1.7091},
              points={{3.11367,-0.0613},{3.11367,0.0307},{-1.56057,0.0307}},
              color={0,0,255}));
          connect(windGenerator1.Vw, GE_WT_init1.Wind_Speed) annotation (Line(
              visible=true,
              origin={70.3333,14.8446},
              points={{-9.3333,2.6484},{4.6667,2.6484},{4.6667,-5.29687}},
              color={0,0,127}));
          connect(pwLine5.n, GE_WT_init1.pwPin1) annotation (Line(
              visible=true,
              origin={61.3531,1.7782},
              points={{3.34327,0.0591},{3.34327,-0.0295},{2.6469,-0.0295}},
              color={0,0,255}));
          connect(pwLine4.n, pwLine5.p) annotation (Line(
              visible=true,
              origin={43.3432,1.7878},
              points={{3.32347,-0.099},{3.32347,0.0495},{-1.98017,0.0495}},
              color={0,0,255}));
          connect(pwLine3.n, pwLine4.p) annotation (Line(
              visible=true,
              origin={25.3135,1.7058},
              points={{3.32347,0.034},{3.32347,-0.017},{-1.98017,-0.017}},
              color={0,0,255}));
          annotation (Diagram(coordinateSystem(
                extent={{-148.5,-105},{148.5,105}},
                preserveAspectRatio=false,
                initialScale=0.1,
                grid={5,5}), graphics), Documentation);
        end GE_WT_Test;

        package PSSE
        extends Modelica.Icons.ExamplesPackage;

          package WT4G
          extends Modelica.Icons.ExamplesPackage;

            model WT4G1_WT4E1
              extends Modelica.Icons.Example;
              constant Real pi=Modelica.Constants.pi;
              parameter Real V1=1.00000;
              parameter Real A1=-1.570655e-005;
              parameter Real V3=0.9999999;
              parameter Real A3=0.02574992;
              parameter Real P1=-1.4988;
              parameter Real Q1=-4.3340;
              parameter Real Zr=0.00000E+0;
              parameter Real Zi=2.00000E-1;
              parameter Real P3=1.500;
              parameter Real Q3=-5.6658;
              parameter Real R1=2.50000E-2;
              parameter Real X1=2.50000E-2;
              parameter Real B1=0.05000;
              parameter Real dyrw[1, 9]=[0.20000E-01, 0.20000E-01, 0.40000, 0.90000, 1.1100,
                  1.2000, 2.0000, 2.0000, 0.20000E-01];
              OpenIPSL.Electrical.Branches.PwLine pwLine(
                R=R1,
                X=X1,
                G=0,
                B=B1/2) annotation (Placement(transformation(extent={{30,10},{
                        50,30}})));
              OpenIPSL.Electrical.Branches.PwLine pwLine1(
                R=R1,
                X=X1,
                G=0,
                B=B1/2) annotation (Placement(transformation(extent={{30,-30},{
                        50,-10}})));
              OpenIPSL.Electrical.Machines.PSSE.GENCLS gENCLS2_1(
                V_0=V1,
                angle_0=A1,
                P_0=P1,
                Q_0=Q1,
                R_a=Zr,
                X_d=Zi,
                M_b=100) annotation (Placement(transformation(extent={{102,-12},
                        {90,12}})));
              OpenIPSL.Electrical.Branches.PwLine pwLine2(
                G=0,
                B=0,
                R=2.50000E-3,
                X=2.50000E-3) annotation (Placement(transformation(extent={{-20,
                        -10},{0,10}})));
              OpenIPSL.Electrical.Wind.PSSE.WT4G.WT4G1 wT4G1(
                V_0=V3,
                angle_0=A3,
                M_b=100,
                P_0=P3,
                Q_0=Q3,
                T_IQCmd=0.02,
                T_IPCmd=0.02,
                V_LVPL1=0.4,
                V_LVPL2=0.9,
                G_LVPL=1.11,
                V_HVRCR=1.2,
                CUR_HVRCR=2,
                RIp_LVPL=2,
                T_LVPL=0.02) annotation (Placement(transformation(
                    extent={{12,12},{-12,-12}},
                    rotation=180,
                    origin={-52,0})));
              OpenIPSL.Electrical.Events.PwFault pwFault(
                R=0.5,
                X=0.5,
                t1=1,
                t2=1.5) annotation (Placement(transformation(extent={{20,-60},{
                        40,-40}})));
              OpenIPSL.Electrical.Wind.PSSE.WT4G.WT4E1 wT4E1_1(
                PFAFLG=false,
                VARFLG=true,
                Tfv=0.15,
                Kpv=18,
                KIV=5,
                Kpp=0.05,
                KIP=0.15,
                Kf=0,
                Tf=0.08,
                QMX=0.48,
                QMN=-0.47,
                IPMAX=1.1,
                TRV=0.1,
                dPMX=0.5,
                dPMN=-0.5,
                T_Power=0.05,
                KQI=0.15,
                VMINCL=0.9,
                VMAXCL=1.1,
                KVI=120,
                Tv=0.05,
                Tp=0.05,
                ImaxTD=1.7,
                Iphl=1.11,
                Iqhl=1.11,
                PQFLAG=false) annotation (Placement(transformation(extent={{-96,
                        12},{-72,-12}})));
              inner OpenIPSL.Electrical.SystemBase SysData(S_b=100, fn=60)
                annotation (Placement(transformation(extent={{-100,80},{-48,100}})));
              OpenIPSL.Electrical.Buses.Bus GEN annotation (Placement(
                    transformation(extent={{-40,-10},{-20,10}})));
              OpenIPSL.Electrical.Buses.Bus BUS1 annotation (Placement(
                    transformation(extent={{0,-10},{20,10}})));
              OpenIPSL.Electrical.Buses.Bus INF annotation (Placement(
                    transformation(extent={{60,-10},{80,10}})));
            equation
              connect(wT4G1.p, GEN.p) annotation (Line(points={{-38.8,-1.77636e-015},{-40,-1.77636e-015},
                      {-40,0},{-30,0}}, color={0,0,255}));
              connect(GEN.p, pwLine2.p)
                annotation (Line(points={{-30,0},{-19,0}}, color={0,0,255}));
              connect(pwLine2.n, BUS1.p)
                annotation (Line(points={{-1,0},{-1,0},{10,0}}, color={0,0,255}));
              connect(BUS1.p, pwLine.p)
                annotation (Line(points={{10,0},{20,0},{20,20},{31,20}}, color={0,0,255}));
              connect(pwLine1.p, pwLine.p) annotation (Line(points={{31,-20},{20,-20},{20,
                      20},{31,20}}, color={0,0,255}));
              connect(pwFault.p, BUS1.p) annotation (Line(points={{18.3333,-50},{14,-50},{
                      14,0},{10,0}}, color={0,0,255}));
              connect(pwLine.n, INF.p)
                annotation (Line(points={{49,20},{60,20},{60,0},{70,0}}, color={0,0,255}));
              connect(pwLine1.n, INF.p) annotation (Line(points={{49,-20},{60,-20},{60,0},{
                      70,0}}, color={0,0,255}));
              connect(INF.p, gENCLS2_1.p)
                annotation (Line(points={{70,0},{90,0},{90,0}}, color={0,0,255}));
              connect(wT4E1_1.WIQCMD, wT4G1.I_qcmd) annotation (Line(points={{-70.8,8.4},{-68,
                      8.4},{-68,9.6},{-62.8,9.6}}, color={0,0,127}));
              connect(wT4E1_1.WIPCMD, wT4G1.I_pcmd) annotation (Line(points={{-70.8,3.6},{-68,
                      3.6},{-68,4.8},{-62.8,4.8}}, color={0,0,127}));
              connect(wT4G1.P, wT4E1_1.P) annotation (Line(points={{-65.2,-4.8},{-68,-4.8},
                      {-68,-2.4},{-73.2,-2.4}}, color={0,0,127}));
              connect(wT4G1.V, wT4E1_1.V) annotation (Line(points={{-65.2,0},{-70,0},{-70,-9.6},
                      {-73.2,-9.6}}, color={0,0,127}));
              connect(wT4G1.Q, wT4E1_1.Q) annotation (Line(points={{-65.2,-9.6},{-68,-9.6},
                      {-68,-6},{-73.2,-6}}, color={0,0,127}));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                        -100},{100,100}})), Documentation);
            end WT4G1_WT4E1;

            model WT4G1
              extends Modelica.Icons.Example;
              constant Real pi=Modelica.Constants.pi;
              parameter Real V1=1.00000;
              parameter Real A1=-1.570655e-005;
              parameter Real V3=0.9999999;
              parameter Real A3=0.02574992;
              parameter Real P1=-1.4988;
              parameter Real Q1=-4.3340;
              parameter Real Zr=0.00000E+0;
              parameter Real Zi=2.00000E-1;
              parameter Real P3=1.500;
              parameter Real Q3=-5.6658;
              parameter Real R1=2.50000E-2;
              parameter Real X1=2.50000E-2;
              parameter Real B1=0.05000;
              parameter Real dyrw[1, 9]=[0.20000E-01, 0.20000E-01, 0.40000, 0.90000, 1.1100,
                  1.2000, 2.0000, 2.0000, 0.20000E-01];
              OpenIPSL.Electrical.Branches.PwLine pwLine(
                R=R1,
                X=X1,
                G=0,
                B=B1/2) annotation (Placement(transformation(extent={{30,10},{
                        50,30}})));
              OpenIPSL.Electrical.Branches.PwLine pwLine1(
                R=R1,
                X=X1,
                G=0,
                B=B1/2) annotation (Placement(transformation(extent={{30,-30},{
                        50,-10}})));
              OpenIPSL.Electrical.Machines.PSSE.GENCLS gENCLS2_1(
                V_0=V1,
                angle_0=A1,
                P_0=P1,
                Q_0=Q1,
                R_a=Zr,
                X_d=Zi,
                M_b=100) annotation (Placement(transformation(extent={{102,-12},
                        {90,12}})));
              OpenIPSL.Electrical.Branches.PwLine pwLine2(
                G=0,
                B=0,
                R=2.50000E-3,
                X=2.50000E-3) annotation (Placement(transformation(extent={{-20,
                        -10},{0,10}})));
              OpenIPSL.Electrical.Wind.PSSE.WT4G.WT4G1 wT4G1(
                V_0=V3,
                angle_0=A3,
                M_b=100,
                P_0=P3,
                Q_0=Q3,
                T_IQCmd=0.02,
                T_IPCmd=0.02,
                V_LVPL1=0.4,
                V_LVPL2=0.9,
                G_LVPL=1.11,
                V_HVRCR=1.2,
                CUR_HVRCR=2,
                RIp_LVPL=2,
                T_LVPL=0.02) annotation (Placement(transformation(
                    extent={{12,12},{-12,-12}},
                    rotation=180,
                    origin={-52,0})));
              OpenIPSL.Electrical.Events.PwFault pwFault(
                R=0.5,
                X=0.5,
                t1=1,
                t2=1.5) annotation (Placement(transformation(extent={{20,-60},{
                        40,-40}})));
              inner OpenIPSL.Electrical.SystemBase SysData(S_b=100, fn=60)
                annotation (Placement(transformation(extent={{-100,80},{-48,100}})));
              OpenIPSL.Electrical.Buses.Bus GEN annotation (Placement(
                    transformation(extent={{-40,-10},{-20,10}})));
              OpenIPSL.Electrical.Buses.Bus BUS1 annotation (Placement(
                    transformation(extent={{0,-10},{20,10}})));
              OpenIPSL.Electrical.Buses.Bus INF annotation (Placement(
                    transformation(extent={{60,-10},{80,10}})));
            equation
              connect(wT4G1.p, GEN.p) annotation (Line(points={{-38.8,-1.77636e-015},{-40,-1.77636e-015},
                      {-40,0},{-30,0}}, color={0,0,255}));
              connect(GEN.p, pwLine2.p)
                annotation (Line(points={{-30,0},{-21.6667,0}}, color={0,0,255}));
              connect(pwLine2.n, BUS1.p) annotation (Line(points={{1.66667,0},{1.66667,0},{
                      10,0}}, color={0,0,255}));
              connect(BUS1.p, pwLine.p) annotation (Line(points={{10,0},{20,0},{20,20},{
                      28.3333,20}}, color={0,0,255}));
              connect(pwLine1.p, pwLine.p) annotation (Line(points={{28.3333,-20},{20,-20},
                      {20,20},{28.3333,20}}, color={0,0,255}));
              connect(pwFault.p, BUS1.p) annotation (Line(points={{18.3333,-50},{14,-50},{
                      14,0},{10,0}}, color={0,0,255}));
              connect(pwLine.n, INF.p) annotation (Line(points={{51.6667,20},{60,20},{60,0},
                      {70,0}}, color={0,0,255}));
              connect(pwLine1.n, INF.p) annotation (Line(points={{51.6667,-20},{60,-20},{60,
                      0},{70,0}}, color={0,0,255}));
              connect(INF.p, gENCLS2_1.p) annotation (Line(points={{70,0},{88.8,0},{88.8,-0.180432}},
                    color={0,0,255}));
              connect(wT4G1.I_qcmd, wT4G1.I_qcmd0) annotation (Line(points={{-62.8,9.6},{-66,
                      9.6},{-66,16},{-59.2,16},{-59.2,13.2}}, color={0,0,127}));
              connect(wT4G1.I_pcmd, wT4G1.I_pcmd0) annotation (Line(points={{-62.8,4.8},{-68,
                      4.8},{-68,18},{-54.4,18},{-54.4,13.2}}, color={0,0,127}));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                        -100},{100,100}})), Documentation);
            end WT4G1;
          annotation (Documentation);
          end WT4G;
        annotation (Documentation);
        end PSSE;
      annotation (Documentation);
      end Wind;

      package Branches
      extends Modelica.Icons.ExamplesPackage;

        package PSAT
        extends Modelica.Icons.ExamplesPackage;

          model TwoWindingTransformer_Test
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Machines.PSAT.Order2 order2_1(
              Sn=100,
              D=5,
              V_0=1,
              angle_0=0,
              Vn=13800,
              V_b=13800,
              P_0=0.050249405357958,
              Q_0=0.010496891745129,
              ra=0.001,
              x1d=0.302,
              M=10) annotation (Placement(transformation(extent={{-80,-10},{-60,
                      10}})));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ lOADPQ(Q_0=0.001, P_0=0.03)
              annotation (Placement(transformation(extent={{60,-30},{80,-10}})));
            OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer(
              Vn=13800,
              xT=0.1,
              rT=0.01,
              V_b=13800) annotation (Placement(transformation(extent={{-40,-10},
                      {-20,10}})));
            OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus(V_0=1, angle_0=0)
              annotation (Placement(transformation(extent={{-80,-50},{-60,-30}})));
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              R=0.01,
              X=0.1,
              G=0,
              B=0.001/2)
              annotation (Placement(transformation(extent={{10,0},{30,20}})));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              R=0.01,
              X=0.1,
              G=0,
              B=0.001)
              annotation (Placement(transformation(extent={{10,-20},{30,0}})));
            OpenIPSL.Electrical.Buses.Bus bus1 annotation (Placement(
                  transformation(extent={{-60,-10},{-40,10}})));
            OpenIPSL.Electrical.Buses.Bus bus2
              annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
            OpenIPSL.Electrical.Buses.Bus bus3
              annotation (Placement(transformation(extent={{40,-10},{60,10}})));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{-100,80},{-60,100}})));
          equation
            connect(infiniteBus.p, order2_1.p) annotation (Line(
                points={{-60,-40},{-55,-40},{-55,0},{-60,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(bus3.p,pwLine2. n) annotation (Line(
                points={{50,0},{40,0},{40,-10},{29,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(twoWindingTransformer.n, bus2.p) annotation (Line(
                points={{-19,0},{-10,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(twoWindingTransformer.p, bus1.p) annotation (Line(
                points={{-41,0},{-50,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(bus1.p, order2_1.p) annotation (Line(
                points={{-50,0},{-60,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(bus2.p,pwLine2. p) annotation (Line(
                points={{-10,0},{6,0},{6,-10},{11,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(order2_1.vf0, order2_1.vf) annotation (Line(points={{-78,11},{-78,14},{-88,14},{-88,5},{-82,5}},
                                                      color={0,0,127}));
            connect(order2_1.pm, order2_1.pm0) annotation (Line(points={{-82,-5},{-88,-5},{-88,-14},{-78,-14},{-78,-11}},
                                                       color={0,0,127}));
            connect(bus3.p, lOADPQ.p) annotation (Line(points={{50,0},{70,0},{70,-10}}, color={0,0,255}));
            connect(pwLine1.p, bus2.p) annotation (Line(points={{11,10},{6,10},{6,0},{-10,0}}, color={0,0,255}));
            connect(pwLine1.n, bus3.p) annotation (Line(points={{29,10},{40,10},{40,0},{50,0}}, color={0,0,255}));
          end TwoWindingTransformer_Test;

          model ThreeWindingTransformer_Test
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-2,-10},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={-2,10},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-91.783,9.4652},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add add2(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-78,2},
                  extent={{-4,-4},{4,4}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-91.382,-5.5198},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order2 Gen1(
              Sn=370,
              D=5,
              P_0=0.080124489663871,
              Q_0=0.059251697676828,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10) annotation (Placement(transformation(extent={{-52,-10},{-32,
                      10}})));
            Modelica.Blocks.Math.Add add
              annotation (Placement(transformation(extent={{-70,10},{-60,0}})));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ(
              t_start_1=5,
              t_end_1=8,
              t_start_2=8,
              t_end_2=12,
              dP1=0,
              dP2=0,
              P_0=0.04,
              Q_0=0.02,
              dQ1=0.01,
              dQ2=-0.01) annotation (Placement(transformation(extent={{80,-10},
                      {100,10}})));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ1(
              P_0=0.04,
              Q_0=0.04,
              t_start_1=0,
              t_end_1=0,
              t_start_2=0,
              t_end_2=0,
              dP1=0,
              dQ1=0,
              dP2=0,
              dQ2=0) annotation (Placement(transformation(extent={{80,-50},{100,
                      -30}})));
            Electrical.Branches.PSAT.ThreeWindingTransformer threeWindingTransformer annotation (Placement(transformation(extent={{28,-10},{48,10}})));
            OpenIPSL.Electrical.Buses.Bus Bus1 annotation (Placement(
                  transformation(extent={{-32,-10},{-12,10}})));
            OpenIPSL.Electrical.Buses.Bus Bus2
              annotation (Placement(transformation(extent={{8,-10},{28,10}})));
            OpenIPSL.Electrical.Buses.Bus Bus3
              annotation (Placement(transformation(extent={{60,10},{80,30}})));
            OpenIPSL.Electrical.Buses.Bus Bus4 annotation (Placement(
                  transformation(extent={{60,-30},{80,-10}})));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{-100,80},{-60,100}})));
          equation
            connect(add2.y, add.u1) annotation (Line(
                points={{-73.6,2},{-71,2}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(add.y, Gen1.vf) annotation (Line(
                points={{-59.5,5},{-54,5}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(Gen1.vf0, add.u2) annotation (Line(
                points={{-50,11},{-50,16},{-74,16},{-74,8},{-71,8}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(Gen1.pm0, Gen1.pm) annotation (Line(
                points={{-50,-11},{-50,-16},{-60,-16},{-60,-5},{-54,-5}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(pwLine4.n, pwLine3.n) annotation (Line(
                points={{7,10},{13,10},{13,-10},{7,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine4.p, pwLine3.p) annotation (Line(
                points={{-11,10},{-17,10},{-17,-10},{-11,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(Gen1.p, Bus1.p) annotation (Line(
                points={{-32,0},{-22,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(Bus1.p, pwLine3.p) annotation (Line(
                points={{-22,0},{-17,0},{-17,-10},{-11,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(Bus2.p, pwLine3.n) annotation (Line(
                points={{18,0},{13,0},{13,-10},{7,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(Bus2.p, threeWindingTransformer.b1) annotation (Line(
                points={{18,0},{27,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(threeWindingTransformer.b2, Bus3.p) annotation (Line(
                points={{49,3},{63,3},{63,20},{70,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(lOADPQ.p, Bus3.p) annotation (Line(
                points={{90,10},{90,20},{70,20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(threeWindingTransformer.b3, Bus4.p) annotation (Line(
                points={{49,-3},{63,-3},{63,-20},{70,-20}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(Bus4.p, lOADPQ1.p) annotation (Line(
                points={{70,-20},{90,-20},{90,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(sine1.y, add2.u1) annotation (Line(points={{-86.8548,9.4652},{-84,9.4652},{-84,4},{-82.8,4},{-82.8,4.4}}, color={0,0,127}));
            connect(sine2.y, add2.u2) annotation (Line(points={{-86.4538,-5.5198},{-84.2269,-5.5198},{-84.2269,-0.4},{-82.8,-0.4}}, color={0,0,127}));
            annotation (Documentation(info="<html>
<table cellspacing=\"2\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>KTH own Model, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end ThreeWindingTransformer_Test;

          model PhaseShiftingTransformer_Test
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ lOADPQ_B3(Q_0=0.001, P_0=0.03)
              annotation (Placement(transformation(extent={{30,-50},{50,-30}})));
            OpenIPSL.Electrical.Branches.PwLine pwLine1(
              R=0.01,
              X=0.1,
              G=0,
              B=0.001/2)
              annotation (Placement(transformation(extent={{0,0},{20,20}})));
            OpenIPSL.Electrical.Branches.PwLine pwLine2(
              R=0.01,
              X=0.1,
              G=0,
              B=0.001)
              annotation (Placement(transformation(extent={{0,-20},{20,0}})));
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              R=0.01,
              X=0.1,
              G=0,
              B=0.001/2)
              annotation (Placement(transformation(extent={{50,0},{70,20}})));
            OpenIPSL.Electrical.Branches.PSAT.PhaseShiftingTransformer.PSTransformer
              pSTransformer
              annotation (Placement(transformation(extent={{50,-20},{70,0}})));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ_B4(
              P_0=0.02,
              Q_0=0.01,
              t_start_1=5,
              t_end_1=7.99,
              t_start_2=8,
              t_end_2=12,
              dQ1=0.01,
              dQ2=-0.01,
              dP1=0.02,
              dP2=-0.02) annotation (Placement(transformation(extent={{80,-50},
                      {100,-30}})));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-26,40},
                  extent={{4.4802,-4.4802},{-4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add diff(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-47,31},
                  extent={{4.99999,-4.99999},{-5,5}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-26,22},
                  extent={{4.4802,-4.4802},{-4.4802,4.4802}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order2 Gen1(
              D=5,
              Sn=100,
              Vn=13800,
              V_b=13800,
              V_0=1,
              P_0=0.050249405357958,
              Q_0=0.010496891745129,
              angle_0=0,
              ra=0.001,
              x1d=0.302,
              M=10) annotation (Placement(transformation(extent={{-80,-10},{-60,
                      10}})));
            Modelica.Blocks.Math.Add add
              annotation (Placement(transformation(extent={{-64,24},{-78,38}})));
            OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer(
              Vn=13800,
              rT=0.01,
              xT=0.1,
              V_b=13800) annotation (Placement(transformation(extent={{-40,-10},
                      {-20,10}})));
            OpenIPSL.Electrical.Buses.Bus B1 annotation (Placement(
                  transformation(extent={{-60,-10},{-40,10}})));
            OpenIPSL.Electrical.Buses.Bus B2
              annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
            OpenIPSL.Electrical.Buses.Bus B3
              annotation (Placement(transformation(extent={{20,-10},{40,10}})));
            OpenIPSL.Electrical.Buses.Bus B4 annotation (Placement(
                  transformation(extent={{80,-10},{100,10}})));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{-100,80},{-60,100}})));
          equation
            connect(pSTransformer.pk, pSTransformer.u) annotation (Line(
                points={{71,-14},{74,-14},{74,-20},{44,-20},{44,-4.4},{48,-4.4}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(sine1.y,diff. u1) annotation (Line(
                points={{-30.9282,40},{-36,40},{-36,34},{-41,34}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(sine2.y,diff. u2) annotation (Line(
                points={{-30.9282,22},{-36,22},{-36,28},{-41,28}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(Gen1.vf0, add.u2) annotation (Line(
                points={{-78,11},{-78,20},{-58,20},{-58,26.8},{-62.6,26.8}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(Gen1.p, B1.p) annotation (Line(
                points={{-60,0},{-50,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B1.p, twoWindingTransformer.p) annotation (Line(
                points={{-50,0},{-41,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(twoWindingTransformer.n, B2.p) annotation (Line(
                points={{-19,0},{-10,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B3.p, lOADPQ_B3.p) annotation (Line(
                points={{30,0},{40,0},{40,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B4.p, lOADPQ_B4.p) annotation (Line(
                points={{90,0},{96,0},{96,-22},{90,-22},{90,-30}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(pwLine3.p, B3.p) annotation (Line(points={{51,10},{40,10},{40,0},{30,0}}, color={0,0,255}));
            connect(pSTransformer.p, B3.p) annotation (Line(points={{49,-10},{40,-10},{40,0},{30,0}}, color={0,0,255}));
            connect(pSTransformer.n, B4.p) annotation (Line(points={{71,-10},{76,-10},{76,0},{90,0}}, color={0,0,255}));
            connect(pwLine3.n, B4.p) annotation (Line(points={{69,10},{76,10},{76,0},{90,0}}, color={0,0,255}));
            connect(pwLine1.n, B3.p) annotation (Line(points={{19,10},{24,10},{24,0},{30,0}}, color={0,0,255}));
            connect(pwLine2.n, B3.p) annotation (Line(points={{19,-10},{24,-10},{24,0},{30,0}}, color={0,0,255}));
            connect(pwLine1.p, B2.p) annotation (Line(points={{1,10},{-4,10},{-4,0},{-10,0}}, color={0,0,255}));
            connect(pwLine2.p, B2.p) annotation (Line(points={{1,-10},{-4,-10},{-4,0},{-10,0}}, color={0,0,255}));
            connect(add.y, Gen1.vf) annotation (Line(points={{-78.7,31},{-92,31},{-92,5},{-82,5}}, color={0,0,127}));
            connect(Gen1.pm0, Gen1.pm) annotation (Line(points={{-78,-11},{-78,-14},{-86,-14},{-86,-5},{-82,-5}}, color={0,0,127}));
            connect(diff.y, add.u1) annotation (Line(points={{-52.5,31},{-58,31},{-58,35.2},{-62.6,35.2}}, color={0,0,127}));
            annotation (Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>KTH own Model, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end PhaseShiftingTransformer_Test;

          model ULTC_Test
            extends Modelica.Icons.Example;
            OpenIPSL.Electrical.Branches.PwLine pwLine3(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={20,-10},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            OpenIPSL.Electrical.Branches.PwLine pwLine4(
              B=0.001/2,
              G=0,
              R=0.01,
              X=0.1) annotation (Placement(visible=true, transformation(
                  origin={20,10},
                  extent={{-10.0,-10.0},{10.0,10.0}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine1(amplitude=0.001, freqHz=0.2) annotation (
                Placement(visible=true, transformation(
                  origin={-92,10},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            Modelica.Blocks.Math.Add diff(k2=-1) annotation (Placement(visible=true,
                  transformation(
                  origin={-72,0},
                  extent={{-6.3229,-6.3229},{6.3229,6.3229}},
                  rotation=0)));
            Modelica.Blocks.Sources.Sine sine2(
              amplitude=0.001,
              freqHz=0.2,
              startTime=5) annotation (Placement(visible=true, transformation(
                  origin={-92,-10},
                  extent={{-4.4802,-4.4802},{4.4802,4.4802}},
                  rotation=0)));
            OpenIPSL.Electrical.Machines.PSAT.Order2 order2_Inputs_Outputs(
              Sn=370,
              P_0=0.081032877181982,
              Q_0=0.058523044412627,
              D=5,
              V_b=400,
              V_0=1,
              angle_0=0,
              Vn=400,
              ra=0.001,
              x1d=0.302,
              M=10) annotation (Placement(transformation(extent={{-30,-10},{-10,
                      10}})));
            Modelica.Blocks.Math.Add add
              annotation (Placement(transformation(extent={{-56,-6},{-44,6}})));
            OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ_B3(
              P_0=0.08,
              Q_0=0.06,
              t_start_1=5,
              t_end_1=8,
              t_start_2=8,
              t_end_2=12,
              dP1=0,
              dP2=0,
              dQ1=-0.05,
              dQ2=0.05) annotation (Placement(transformation(extent={{80,-40},{
                      100,-20}})));
            OpenIPSL.Electrical.Branches.PSAT.ULTC_VoltageControl uLTC_VoltageControl
              annotation (Placement(transformation(extent={{50,-10},{70,10}})));
            OpenIPSL.Electrical.Buses.Bus B1 annotation (Placement(
                  transformation(extent={{-10,-10},{10,10}})));
            OpenIPSL.Electrical.Buses.Bus B2
              annotation (Placement(transformation(extent={{30,-10},{50,10}})));
            OpenIPSL.Electrical.Buses.Bus B3
              annotation (Placement(transformation(extent={{70,-10},{90,10}})));
            inner OpenIPSL.Electrical.SystemBase SysData annotation (Placement(
                  transformation(extent={{-100,80},{-40,100}})));
          equation
            connect(add.y, order2_Inputs_Outputs.vf) annotation (Line(
                points={{-43.4,0},{-39,0},{-39,5},{-32,5}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(order2_Inputs_Outputs.pm0, order2_Inputs_Outputs.pm) annotation (Line(
                points={{-28,-11},{-28,-14},{-36,-14},{-36,-5},{-32,-5}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(sine1.y,diff. u1) annotation (Line(
                points={{-87.0718,10},{-82,10},{-82,4},{-79.5875,4},{-79.5875,3.79374}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(sine2.y,diff. u2) annotation (Line(
                points={{-87.0718,-10},{-82,-10},{-82,-4},{-79.5875,-4},{-79.5875,-3.79374}},
                color={0,0,127},
                smooth=Smooth.None));
            connect(pwLine4.p, pwLine3.p) annotation (Line(
                points={{11,10},{6,10},{6,-10},{11,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(order2_Inputs_Outputs.p, B1.p) annotation (Line(
                points={{-10,0},{0,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B1.p, pwLine3.p) annotation (Line(
                points={{0,0},{6,0},{6,-10},{11,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B2.p, pwLine3.n) annotation (Line(
                points={{40,0},{34,0},{34,-10},{29,-10}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(uLTC_VoltageControl.n, B3.p) annotation (Line(
                points={{71,0},{80,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(lOADPQ_B3.p, B3.p) annotation (Line(
                points={{90,-20},{90,0},{80,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B2.p, uLTC_VoltageControl.p) annotation (Line(
                points={{40,0},{49,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(B2.p, pwLine4.n) annotation (Line(points={{40,0},{34,0},{34,10},{29,10}}, color={0,0,255}));
            connect(diff.y, add.u2) annotation (Line(points={{-65.0448,0},{-62,0},{-62,-3.6},{-57.2,-3.6}}, color={0,0,127}));
            connect(add.u1, order2_Inputs_Outputs.vf0) annotation (Line(points={{-57.2,3.6},{-62,3.6},{-62,18},{-28,18},{-28,11}}, color={0,0,127}));
            annotation (Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>KTH own Model, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end ULTC_Test;
        annotation (Documentation);
        end PSAT;
      annotation (Documentation);
      end Branches;

      package FACTS
      extends Modelica.Icons.ExamplesPackage;

        model StatcomCode_Test
          import Modelica.Constants.pi;
          extends Modelica.Icons.Example;
          OpenIPSL.Electrical.Branches.PwLine pwLine4(
            B=0.001/2,
            G=0,
            R=0.01,
            X=0.1) annotation (Placement(visible=true, transformation(
                origin={-13,13},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine2(
            B=0.001/2,
            G=0,
            R=0.01,
            X=0.1) annotation (Placement(visible=true, transformation(
                origin={-15,-17},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Machines.PSAT.Order2 Syn2(
            D=1,
            Sn=370,
            V_0=1.027606413803688,
            V_b=400,
            ra=0.001,
            x1d=0.302,
            M=10,
            angle_0=0.036282466109908*180/pi,
            P_0=0.800000000076548*SysData.S_b,
            Q_0=0.500000000133379*SysData.S_b,
            Vn=400) annotation (Placement(transformation(
                extent={{-15,-16},{15,16}},
                rotation=180,
                origin={123,0})));
          OpenIPSL.Electrical.Branches.PwLine pwLine1(
            B=0.001/2,
            G=0,
            R=0.01,
            X=0.1) annotation (Placement(visible=true, transformation(
                origin={53,17},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Branches.PwLine pwLine3(
            B=0.001/2,
            G=0,
            R=0.01,
            X=0.1) annotation (Placement(visible=true, transformation(
                origin={55,-17},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0)));
          OpenIPSL.Electrical.Machines.PSAT.Order2 order2_Inputs_Outputs(
            Sn=370,
            D=5,
            V_b=400,
            V_0=1,
            angle_0=0,
            Vn=400,
            ra=0.001,
            x1d=0.302,
            M=10,
            P_0=0.004219210312137*SysData.S_b,
            Q_0=-0.001421467052118*SysData.S_b)
            annotation (Placement(transformation(extent={{-78,-8},{-58,12}})));
          Modelica.Blocks.Sources.Pulse pulse(
            period=10,
            startTime=4.2,
            amplitude=0.045,
            width=58,
            nperiod=-1,
            offset=0.999885177318814)
            annotation (Placement(transformation(extent={{-158,14},{-138,34}})));
          Modelica.Blocks.Sources.Pulse pulse1(
            period=10,
            amplitude=-0.045,
            width=42,
            startTime=0,
            nperiod=-1)
            annotation (Placement(transformation(extent={{-156,-22},{-136,-2}})));
          Modelica.Blocks.Math.Add3 add3_1(
            k3=0,
            k1=1,
            k2=1) annotation (Placement(transformation(extent={{-118,-10},{-98,10}})));
          OpenIPSL.Electrical.FACTS.PSAT.STATCOM sTATCOM3_1(V_0=1, angle_0=-0.000213067852480
                *180/pi)
            annotation (Placement(transformation(extent={{-14,-54},{6,-34}})));
          OpenIPSL.Electrical.Buses.Bus bus
            annotation (Placement(transformation(extent={{4,-8},{24,12}})));
          OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ(
            t_start_1=7,
            t_end_1=7.001,
            dP1=0,
            t_start_2=8,
            dP2=0,
            P_0=0.8*SysData.S_b,
            Q_0=0.6*SysData.S_b,
            t_end_2=50,
            angle_0=-0.000213067852480*180/pi,
            dQ1=0.1*SysData.S_b,
            dQ2=0.42*SysData.S_b)
            annotation (Placement(transformation(extent={{38,-52},{58,-32}})));
          inner OpenIPSL.Electrical.SystemBase SysData
            annotation (Placement(transformation(extent={{-116,60},{-76,80}})));
        equation
          connect(pwLine1.n, pwLine3.n) annotation (Line(
              points={{62,17},{78,17},{78,-17},{64,-17}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(bus.p, lOADPQ.p) annotation (Line(
              points={{14,2},{24,2},{24,-32},{48,-32}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(sTATCOM3_1.p, lOADPQ.p) annotation (Line(
              points={{7,-44},{20,-44},{20,2},{24,2},{24,-32},{48,-32}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(pwLine3.p, lOADPQ.p) annotation (Line(
              points={{46,-17},{38,-17},{38,2},{24,2},{24,-32},{48,-32}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(pwLine1.p, lOADPQ.p) annotation (Line(
              points={{44,17},{38,17},{38,2},{24,2},{24,-32},{48,-32}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(Syn2.p, pwLine3.n) annotation (Line(
              points={{108,1.83187e-015},{78,1.83187e-015},{78,-17},{64,-17}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(pwLine2.n, bus.p) annotation (Line(
              points={{-6,-17},{0,-17},{0,2},{14,2}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(pwLine4.n, bus.p) annotation (Line(
              points={{-4,13},{0,13},{0,2},{14,2}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(pwLine4.p, pwLine2.p) annotation (Line(
              points={{-22,13},{-28,13},{-28,-17},{-24,-17}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(order2_Inputs_Outputs.p, pwLine2.p) annotation (Line(
              points={{-58,2},{-28,2},{-28,-17},{-24,-17}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(add3_1.y, order2_Inputs_Outputs.vf) annotation (Line(
              points={{-97,0},{-92,0},{-92,7},{-80,7}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(order2_Inputs_Outputs.vf0, add3_1.u3) annotation (Line(
              points={{-76,13},{-48,13},{-48,-22},{-120,-22},{-120,-8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pulse1.y, add3_1.u2) annotation (Line(
              points={{-135,-12},{-126,-12},{-126,0},{-120,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pulse.y, add3_1.u1) annotation (Line(
              points={{-137,24},{-130,24},{-130,8},{-120,8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(order2_Inputs_Outputs.pm0, order2_Inputs_Outputs.pm) annotation (Line(
              points={{-76,-9},{-54,-9},{-54,-16},{-90,-16},{-90,-3},{-80,-3}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Syn2.pm, Syn2.pm0) annotation (Line(points={{141,8},{148,8},{148,26},
                  {135,26},{135,17.6}}, color={0,0,127}));
          connect(Syn2.vf0, Syn2.vf) annotation (Line(points={{135,-17.6},{135,-26},{
                  152,-26},{152,-8},{141,-8}}, color={0,0,127}));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                    100,100}})),
            Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
            Documentation(info="<html>
<table cellspacing=\"2\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>KTH own Model, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
        end StatcomCode_Test;

        model TCSC_Reactance_Test
          extends Modelica.Icons.Example;
          OpenIPSL.Electrical.Machines.PSAT.Order2 Gen1(
            Sn=370,
            P_0=0.080101913348342,
            Q_0=0.060948619430301,
            D=5,
            V_b=400,
            V_0=1,
            angle_0=0,
            Vn=400,
            ra=0.001,
            x1d=0.302,
            M=10)
            annotation (Placement(transformation(extent={{-22,-10},{-2,10}})));
          Modelica.Blocks.Sources.Pulse pulse(
            period=10,
            startTime=4.2,
            amplitude=0.045,
            width=58,
            offset=1.005017533847740,
            nperiod=2)
            annotation (Placement(transformation(extent={{-116,10},{-96,30}})));
          Modelica.Blocks.Sources.Pulse pulse1(
            period=10,
            amplitude=-0.045,
            width=42,
            startTime=0,
            nperiod=2)
            annotation (Placement(transformation(extent={{-118,-26},{-98,-6}})));
          Modelica.Blocks.Math.Add3 add3_1(
            k3=0,
            k1=1,
            k2=1) annotation (Placement(transformation(extent={{-58,-10},{-38,10}})));
          OpenIPSL.Electrical.Branches.PwLine pwLine1(
            R=0.01,
            X=0.1,
            G=0,
            B=0.001/2)
            annotation (Placement(transformation(extent={{62,-10},{82,10}})));
          OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ(
            P_0=0.08,
            Q_0=0.06,
            t_start_1=2,
            t_end_1=10,
            t_start_2=12,
            t_end_2=20,
            dP1=0,
            dQ1=0.01,
            dP2=0,
            dQ2=-0.01)
            annotation (Placement(transformation(extent={{96,-10},{116,10}})));
          OpenIPSL.Electrical.FACTS.PSAT.TCSCReactance tCSCReactance
            annotation (Placement(transformation(extent={{26,-10},{46,10}})));
          inner OpenIPSL.Electrical.SystemBase SysData
            annotation (Placement(transformation(extent={{-100,60},{-76,80}})));
        equation
          connect(pulse1.y, add3_1.u2) annotation (Line(
              points={{-97,-16},{-68,-16},{-68,0},{-60,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pulse.y, add3_1.u1) annotation (Line(
              points={{-95,20},{-70,20},{-70,8},{-60,8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pwLine1.n, lOADPQ.p) annotation (Line(
              points={{81,0},{92,0},{92,10},{106,10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(add3_1.y, Gen1.vf) annotation (Line(
              points={{-37,0},{-32,0},{-32,5},{-24,5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Gen1.pm0, Gen1.pm) annotation (Line(
              points={{-20,-11},{8,-11},{8,-20},{-32,-20},{-32,-5},{-24,-5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Gen1.vf0, add3_1.u3) annotation (Line(
              points={{-20,11},{4,11},{4,22},{-36,22},{-36,-20},{-60,-20},{-60,-8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tCSCReactance.n, pwLine1.p) annotation (Line(
              points={{47,0},{63,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(Gen1.p, tCSCReactance.p) annotation (Line(
              points={{-2,0},{11.5,0},{11.5,0.2},{25.1,0.2}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics),
            Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
            Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>KTH own Model, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
        end TCSC_Reactance_Test;

        model TCSC_Alpha_Test
          extends Modelica.Icons.Example;
          OpenIPSL.Electrical.Machines.PSAT.Order2 Gen1(
            Sn=370,
            P_0=0.080101913348342,
            Q_0=0.060948619430301,
            D=5,
            angle_0=0,
            V_0=1,
            Vn=400,
            ra=0.001,
            x1d=0.302,
            M=10)
            annotation (Placement(transformation(extent={{-24,-10},{-4,10}})));
          Modelica.Blocks.Sources.Pulse pulse(
            period=10,
            startTime=4.2,
            amplitude=0.045,
            width=58,
            offset=1.005017533847740,
            nperiod=2)
            annotation (Placement(transformation(extent={{-126,6},{-106,26}})));
          Modelica.Blocks.Sources.Pulse pulse1(
            period=10,
            amplitude=-0.045,
            width=42,
            startTime=0,
            nperiod=2)
            annotation (Placement(transformation(extent={{-128,-28},{-108,-8}})));
          Modelica.Blocks.Math.Add3 add3_1(
            k3=0,
            k1=1,
            k2=1) annotation (Placement(transformation(extent={{-78,-10},{-58,10}})));
          OpenIPSL.Electrical.Branches.PwLine pwLine1(
            R=0.01,
            G=0,
            B=0.001/2,
            X=0.1)
            annotation (Placement(transformation(extent={{56,-10},{76,10}})));
          OpenIPSL.Electrical.Loads.PSAT.LOADPQ_variation lOADPQ(
            P_0=0.08,
            Q_0=0.06,
            t_start_1=2,
            t_end_1=10,
            dP1=0.01,
            dQ1=0.01,
            t_start_2=12,
            t_end_2=20,
            dP2=-0.01,
            dQ2=-0.01)
            annotation (Placement(transformation(extent={{94,-10},{114,10}})));
          OpenIPSL.Electrical.FACTS.PSAT.TCSCAlpha tCSCAlpha
            annotation (Placement(transformation(extent={{18,-10},{38,10}})));
          inner OpenIPSL.Electrical.SystemBase SysData
            annotation (Placement(transformation(extent={{-120,60},{-96,80}})));
        equation
          connect(pulse1.y, add3_1.u2) annotation (Line(
              points={{-107,-18},{-92,-18},{-92,0},{-80,0}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pulse.y, add3_1.u1) annotation (Line(
              points={{-105,16},{-94,16},{-94,8},{-80,8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(pwLine1.n, lOADPQ.p) annotation (Line(
              points={{75,0},{88,0},{88,10},{104,10}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(add3_1.y, Gen1.vf) annotation (Line(
              points={{-57,0},{-32,0},{-32,5},{-26,5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Gen1.vf0, add3_1.u3) annotation (Line(
              points={{-22,11},{2,11},{2,22},{-42,22},{-42,-16},{-86,-16},{-86,-8},{-80,
                  -8}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(Gen1.pm0, Gen1.pm) annotation (Line(
              points={{-22,-11},{4,-11},{4,-20},{-32,-20},{-32,-5},{-26,-5}},
              color={0,0,127},
              smooth=Smooth.None));
          connect(tCSCAlpha.n, pwLine1.p) annotation (Line(
              points={{39,0},{57,0}},
              color={0,0,255},
              smooth=Smooth.None));
          connect(Gen1.p, tCSCAlpha.p) annotation (Line(
              points={{-4,0},{7.5,0},{7.5,0},{17.1,0}},
              color={0,0,255},
              smooth=Smooth.None));
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                    100}}), graphics),
            Icon(coordinateSystem(extent={{-100,-100},{100,100}})),
            Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>KTH own Model, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
        end TCSC_Alpha_Test;
      annotation (Documentation);
      end FACTS;

      model TwoWindingTransformer "SMIB system with one load and GENROE model"
        extends Modelica.Icons.Example;
        OpenIPSL.Electrical.Branches.PwLine pwLine1(
          R=0.001,
          X=0.2,
          G=0,
          B=0) annotation (Placement(transformation(extent={{40,20},{60,40}})));
        OpenIPSL.Electrical.Branches.PwLine pwLine3(
          t2=100,
          R=0.0005,
          X=0.1,
          G=0,
          B=0,
          t1=100)
          annotation (Placement(transformation(extent={{20,-40},{40,-20}})));
        OpenIPSL.Electrical.Branches.PwLine pwLine4(
          t2=100,
          t1=100,
          R=0.0005,
          X=0.1,
          G=0,
          B=0)
          annotation (Placement(transformation(extent={{60,-40},{80,-20}})));
        OpenIPSL.Electrical.Machines.PSSE.GENCLS gENCLS(
          M_b=100,
          D=0,
          V_0=1,
          angle_0=0,
          X_d=0.2,
          H=0,
          P_0=10.0278,
          Q_0=32.05072)
          annotation (Placement(transformation(extent={{118,-12},{106,12}})));
        OpenIPSL.Electrical.Loads.PSSE.Load_variation constantLoad(
          d_t=0,
          d_P=0,
          t1=0,
          V_0=0.9679495,
          angle_0=-0.5840921,
          P_0=50,
          Q_0=10)
          annotation (Placement(transformation(extent={{-4,-52},{8,-40}})));
        OpenIPSL.Electrical.Events.PwFault pwFault(
          t1=2,
          t2=2.15,
          R=0.1,
          X=0.1) annotation (Placement(transformation(
              extent={{-6,-6},{6,6}},
              rotation=-90,
              origin={54,-58})));
        OpenIPSL.Electrical.Machines.PSSE.GENSAL gENROE(
          M_b=100,
          Tpd0=5,
          D=0,
          Xppd=0.2,
          Xl=0.12,
          Xppq=0.2,
          Tppd0=0.05,
          Tppq0=0.1,
          H=4,
          Xd=1.41,
          Xq=1.35,
          Xpd=0.3,
          S10=0.1,
          S12=0.5,
          R_a=0.002,
          V_b=14.7,
          V_0=1,
          angle_0=4.747869,
          P_0=40,
          Q_0=-16.46028)
          annotation (Placement(transformation(extent={{-92,-20},{-58,20}})));
        OpenIPSL.Electrical.Branches.PSSE.TwoWindingTransformer twoWindingTransformer(
          CZ=1,
          R=0.001,
          X=0.2,
          G=0,
          B=0,
          S_n=1,
          ANG1=1,
          VB1=14.7,
          VB2=130,
          t1=0.8085,
          VNOM1=20,
          t2=1.02,
          VNOM2=130,
          CW=3)
          annotation (Placement(transformation(extent={{-26,-4},{-14,4}})));
        OpenIPSL.Electrical.Buses.Bus BUS01
          annotation (Placement(transformation(extent={{-50,-10},{-30,10}})));
        OpenIPSL.Electrical.Buses.Bus BUS02
          annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
        OpenIPSL.Electrical.Buses.Bus BUS03
          annotation (Placement(transformation(extent={{40,-40},{60,-20}})));
        OpenIPSL.Electrical.Buses.Bus BUS1
          annotation (Placement(transformation(extent={{80,-10},{100,10}})));
        inner OpenIPSL.Electrical.SystemBase SysData(S_b=100, fn=50)
          annotation (Placement(transformation(extent={{-100,80},{-40,100}})));
      equation
        connect(gENROE.PMECH, gENROE.PMECH0) annotation (Line(points={{-91.66,10},{-98,
                10},{-98,26},{-50,26},{-50,-6},{-56.64,-6}}, color={0,0,127}));
        connect(gENROE.EFD, gENROE.EFD0) annotation (Line(points={{-91.66,-10},{-98,-10},
                {-98,-24},{-50,-24},{-50,-14},{-56.64,-14}}, color={0,0,127}));
        connect(gENROE.p, BUS01.p)
          annotation (Line(points={{-56.3,0},{-40,0}}, color={0,0,255}));
        connect(BUS01.p, twoWindingTransformer.p)
          annotation (Line(points={{-40,0},{-27,0}}, color={0,0,255}));
        connect(twoWindingTransformer.n, BUS02.p)
          annotation (Line(points={{-13,0},{0,0}}, color={0,0,255}));
        connect(pwLine1.p, BUS02.p) annotation (Line(points={{38.3333,30},{4,30},{4,0},
                {0,0}}, color={0,0,255}));
        connect(pwLine3.p, BUS02.p) annotation (Line(points={{18.3333,-30},{4,-30},{4,
                0},{0,0}}, color={0,0,255}));
        connect(constantLoad.p, BUS02.p)
          annotation (Line(points={{2,-39.4},{2,0},{0,0}}, color={0,0,255}));
        connect(pwLine3.n, BUS03.p) annotation (Line(points={{41.6667,-30},{41.6667,-30},
                {50,-30}}, color={0,0,255}));
        connect(BUS03.p, pwLine4.p)
          annotation (Line(points={{50,-30},{58.3333,-30}}, color={0,0,255}));
        connect(BUS1.p, gENCLS.p) annotation (Line(points={{90,0},{104.8,0},{104.8,-0.180432}},
              color={0,0,255}));
        connect(pwLine1.n, BUS1.p) annotation (Line(points={{61.6667,30},{86,30},{86,
                0},{90,0}}, color={0,0,255}));
        connect(pwLine4.n, BUS1.p) annotation (Line(points={{81.6667,-30},{86,-30},{
                86,0},{90,0}}, color={0,0,255}));
        connect(pwFault.p, BUS03.p)
          annotation (Line(points={{54,-51},{54,-30},{50,-30}}, color={0,0,255}));
        annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                  -100},{100,100}})), Documentation);
      end TwoWindingTransformer;

      partial model SMIBpartial "SMIB system with one load"
        extends Modelica.Icons.Example;
        OpenIPSL.Electrical.Branches.PwLine pwLine(
          R=0.001,
          X=0.2,
          G=0,
          B=0) annotation (Placement(transformation(extent={{-26,-4},{-14,4}})));
        OpenIPSL.Electrical.Branches.PwLine pwLine1(
          R=0.001,
          G=0,
          B=0,
          X=0.2)
          annotation (Placement(transformation(extent={{34,26},{46,34}})));
        OpenIPSL.Electrical.Branches.PwLine pwLine3(
          R=0.0005,
          X=0.1,
          G=0,
          B=0)
          annotation (Placement(transformation(extent={{14,-34},{26,-26}})));
        OpenIPSL.Electrical.Branches.PwLine pwLine4(
          R=0.0005,
          X=0.1,
          G=0,
          B=0)
          annotation (Placement(transformation(extent={{54,-34},{66,-26}})));
        OpenIPSL.Electrical.Machines.PSSE.GENCLS gENCLS(
          M_b=100,
          D=0,
          V_0=1,
          angle_0=0,
          X_d=0.2,
          P_0=10.01711,
          Q_0=8.006544,
          H=0)
          annotation (Placement(transformation(extent={{112,-12},{98,12}})));
        OpenIPSL.Electrical.Loads.PSSE.Load_variation constantLoad(
          PQBRAK=0.7,
          d_t=0,
          d_P=0,
          V_0=0.9919935,
          angle_0=-0.5762684,
          t1=0,
          characteristic=2,
          P_0=50,
          Q_0=10)
          annotation (Placement(transformation(extent={{-4,-52},{8,-40}})));
        OpenIPSL.Electrical.Events.PwFault pwFault(
          t1=2,
          t2=2.15,
          R=0,
          X=0) annotation (Placement(transformation(
              extent={{-6,-6},{6,6}},
              rotation=-90,
              origin={44,-60})));
        OpenIPSL.Electrical.Buses.Bus GEN1
          annotation (Placement(transformation(extent={{-50,-10},{-30,10}})));
        inner OpenIPSL.Electrical.SystemBase SysData
          annotation (Placement(transformation(extent={{-100,80},{-40,100}})));
        OpenIPSL.Electrical.Buses.Bus LOAD
          annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
        OpenIPSL.Electrical.Buses.Bus GEN2
          annotation (Placement(transformation(extent={{70,-10},{90,10}})));
        OpenIPSL.Electrical.Buses.Bus FAULT
          annotation (Placement(transformation(extent={{30,-40},{50,-20}})));
      equation
        connect(GEN1.p, pwLine.p)
          annotation (Line(points={{-40,0},{-40,0},{-25.4,0}}, color={0,0,255}));
        connect(pwLine.n, LOAD.p)
          annotation (Line(points={{-14.6,0},{-14.6,0},{0,0}}, color={0,0,255}));
        connect(pwLine3.p, LOAD.p) annotation (Line(points={{14.6,-30},{4,-30},{4,0},
                {0,0}},color={0,0,255}));
        connect(constantLoad.p, LOAD.p)
          annotation (Line(points={{2,-40},{2,0},{0,0}}, color={0,0,255}));
        connect(pwLine1.p, LOAD.p)
          annotation (Line(points={{34.6,30},{4,30},{4,0},{0,0}}, color={0,0,255}));
        connect(GEN2.p, gENCLS.p)
          annotation (Line(points={{80,0},{98,0},{98,0}}, color={0,0,255}));
        connect(pwLine4.n, GEN2.p) annotation (Line(points={{65.4,-30},{76,-30},{76,0},
                {80,0}}, color={0,0,255}));
        connect(pwLine1.n, GEN2.p) annotation (Line(points={{45.4,30},{76,30},{76,0},
                {80,0}},color={0,0,255}));
        connect(FAULT.p, pwLine4.p)
          annotation (Line(points={{40,-30},{54.6,-30}}, color={0,0,255}));
        connect(FAULT.p, pwLine3.n)
          annotation (Line(points={{40,-30},{25.4,-30}}, color={0,0,255}));
        connect(pwFault.p, pwLine4.p)
          annotation (Line(points={{44,-53},{44,-30},{54.6,-30}}, color={0,0,255}));
        annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                  -100},{100,100}})), Documentation);
      end SMIBpartial;

      partial model BaseTest
        extends Modelica.Icons.Example;
        Electrical.Branches.PwLine pwLine1(
          X=0.1,
          R=0.01,
          G=0,
          B=0.0005) annotation (Placement(visible=true, transformation(
              origin={20,-12},
              extent={{-6,-6},{6,6}},
              rotation=0)));
        Electrical.Branches.PwLine pwLinewithOpening1(
          G=0,
          R=0.01,
          X=0.1,
          opening=1,
          B=0.0005,
          t1=2,
          t2=2.15) annotation (Placement(visible=true, transformation(
              origin={60,12},
              extent={{-6,-6},{6,6}},
              rotation=0)));
        Electrical.Branches.PwLine pwLine2(
          G=0,
          R=0.01,
          X=0.1,
          B=0.0005) annotation (Placement(visible=true, transformation(
              origin={20,12},
              extent={{-6,-6},{6,6}},
              rotation=0)));
        Electrical.Branches.PwLine pwLine3(
          G=0,
          R=0.01,
          X=0.1,
          B=0.0005) annotation (Placement(visible=true, transformation(
              origin={62,-14},
              extent={{-6,-6},{6,6}},
              rotation=0)));
        Electrical.Branches.PwLine pwLine4(
          G=0,
          R=0.01,
          X=0.1,
          B=0.0005) annotation (Placement(visible=true, transformation(
              origin={60,36},
              extent={{-5.99999,-5.99998},{5.99999,6}},
              rotation=0)));
        Electrical.Loads.PSAT.LOADPQ pwLoadPQ1(
          P_0=8,
          Q_0=6,
          V_0=1,
          angle_0=0) annotation (Placement(visible=true, transformation(
              origin={94,24},
              extent={{-6,-6},{6,6}},
              rotation=90)));
        Electrical.Loads.PSAT.LOADPQ_variation pwLoadPQ2(
          P_0=8,
          Q_0=6,
          V_0=1,
          angle_0=0) annotation (Placement(visible=true, transformation(
              origin={94.0335,-14.2889},
              extent={{-6.2889,-6.0335},{6.2889,6.0335}},
              rotation=90)));
        inner Electrical.SystemBase SysData
          annotation (Placement(transformation(extent={{-100,80},{-40,100}})));
        Electrical.Buses.Bus bus
          annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
        Electrical.Buses.Bus bus1
          annotation (Placement(transformation(extent={{30,-10},{50,10}})));
        Electrical.Buses.Bus bus2
          annotation (Placement(transformation(extent={{70,14},{90,34}})));
        Electrical.Buses.Bus bus3
          annotation (Placement(transformation(extent={{70,-24},{90,-4}})));
      equation
        connect(pwLine2.p, pwLine1.p) annotation (Line(points={{14.6,12},{6,12},{6,-12},
                {14.6,-12}}, color={0,0,255}));
        connect(pwLine2.n, pwLine1.n) annotation (Line(points={{25.4,12},{34,12},{34,
                -12},{25.4,-12}}, color={0,0,255}));
        connect(pwLine4.p, pwLinewithOpening1.p) annotation (Line(points={{54.6,36},{
                48,36},{48,12},{54.6,12}}, color={0,0,255}));
        connect(pwLine4.n, pwLinewithOpening1.n) annotation (Line(points={{65.4,36},{
                72,36},{72,12},{65.4,12}}, color={0,0,255}));
        connect(bus.p, pwLine1.p) annotation (Line(points={{0,0},{6,0},{6,-12},{14.6,
                -12}}, color={0,0,255}));
        connect(bus1.p, pwLine1.n) annotation (Line(points={{40,0},{34,0},{34,-12},{
                25.4,-12}}, color={0,0,255}));
        connect(bus1.p, pwLinewithOpening1.p) annotation (Line(points={{40,0},{44,0},
                {44,20},{48,20},{48,12},{54.6,12}}, color={0,0,255}));
        connect(pwLine3.p, pwLinewithOpening1.p) annotation (Line(points={{56.6,-14},
                {44,-14},{44,20},{48,20},{48,12},{54.6,12}}, color={0,0,255}));
        connect(bus2.p, pwLoadPQ1.p)
          annotation (Line(points={{80,24},{84,24},{87.4,24}}, color={0,0,255}));
        connect(bus2.p, pwLinewithOpening1.n) annotation (Line(points={{80,24},{72,24},
                {72,12},{65.4,12}}, color={0,0,255}));
        connect(bus3.p, pwLoadPQ2.p) annotation (Line(points={{80,-14},{87.3966,-14},
                {87.3966,-14.2889}}, color={0,0,255}));
        connect(pwLine3.n, bus3.p) annotation (Line(points={{67.4,-14},{67.4,-14},{80,
                -14}}, color={0,0,255}));
        annotation (
          Icon(coordinateSystem(preserveAspectRatio=false)),
          Diagram(coordinateSystem(preserveAspectRatio=false)),
          Documentation);
      end BaseTest;
    annotation (Documentation);
    end Examples;

    package Electrical
      record SystemBase "System Base Definition"
        parameter OpenIPSL.Types.ApparentPowerMega S_b=100 "System base";
        parameter Modelica.SIunits.Frequency fn=50 "System Frequency";
        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=false,
              extent={{-120,-100},{120,100}},
              initialScale=0.1), graphics={Rectangle(extent={{-120,100},{120,-100}},
                lineColor={28,108,200}),Text(
                extent={{-100,40},{100,0}},
                lineColor={28,108,200},
                horizontalAlignment=TextAlignment.Left,
                textString="System Base: %S_b MVA"),Text(
                extent={{-100,-20},{100,-60}},
                lineColor={28,108,200},
                horizontalAlignment=TextAlignment.Left,
                textString="Frequency: %fn Hz"),Text(
                extent={{-100,100},{100,60}},
                lineColor={28,108,200},
                horizontalAlignment=TextAlignment.Center,
                textString="System Data")}),
          defaultComponentName="SysData",
          defaultComponentPrefixes="inner",
          missingInnerMessage="
No 'System Data' component is defined. A default component will be used, and generate a system base of 100 MVA, and a frequency of 50 Hz",
          Diagram(coordinateSystem(
              extent={{-120,-100},{120,100}},
              preserveAspectRatio=false,
              initialScale=0.1)),
          defaultComponentPrefixes="inner",
          Documentation);

      end SystemBase;

      package Buses
        model Bus "Bus model (2014/03/10)"
          extends OpenIPSL.Electrical.Essentials.pfComponent;
          OpenIPSL.Interfaces.PwPin p(vr(start=V_0*cos(angle_0*Modelica.Constants.pi
                  /180)), vi(start=V_0*sin(angle_0*Modelica.Constants.pi/180)))
            annotation (Placement(
              visible=true,
              transformation(
                origin={0,0},
                extent={{-10.0,-10.0},{10.0,10.0}},
                rotation=0),
              iconTransformation(
                origin={0,0},
                extent={{-10,-10},{10,10}},
                rotation=0)));
          Real V(start=V_0) "Bus voltage magnitude (pu)";
          Modelica.SIunits.Conversions.NonSIunits.Angle_deg angle(start=angle_0)
            "Bus voltage angle";
          parameter Boolean displayPF=true "Display voltage values:" annotation (Dialog(
              group="Visualisation",
              __Dymola_compact=true,
              __Dymola_descriptionLabel=true), choices(checkBox=true));
        equation
          V = sqrt(p.vr^2 + p.vi^2);
          angle = atan2(p.vi, p.vr)*180/Modelica.Constants.pi;
          p.ir = 0;
          p.ii = 0;
          annotation (Icon(graphics={Rectangle(
                  visible=true,
                  fillPattern=FillPattern.Solid,
                  extent={{-10,-100},{10,100}}),Text(
                  visible=true,
                  origin={-0.02605,120.133},
                  fillPattern=FillPattern.Solid,
                  extent={{-100,-20},{100,20}},
                  textString="%name"),Text(
                  visible=displayPF,
                  origin={0,-120},
                  extent={{-60,-20},{60,20}},
                  lineColor={170,0,0},
                  textString=DynamicSelect("Vpu", String(V, significantDigits=3))),Text(
                  visible=displayPF,
                  origin={0,-160},
                  extent={{-60,-20},{60,20}},
                  lineColor={170,0,0},
                  textString=DynamicSelect("Angle", String(angle, significantDigits=3)
                     + "°"))}), Documentation);
        end Bus;

        model InfiniteBus "PSAT Infinite Bus"
          extends OpenIPSL.Electrical.Essentials.pfComponent;
          Real P "Active Power absorbed by the Infinite bus (MW)";
          Real Q "Reactive Power absorbed by the Infinite bus (MVAr)";
          Interfaces.PwPin p
            annotation (Placement(transformation(extent={{90,-10},{110,10}})));
          parameter Boolean displayPF=false "Display power flow results:" annotation (
              Dialog(
              group="Visualisation",
              __Dymola_compact=true,
              __Dymola_descriptionLabel=true), choices(checkBox=true));
        equation
          p.vr = V_0*cos(angle_0*Modelica.Constants.pi/180);
          p.vi = V_0*sin(angle_0*Modelica.Constants.pi/180);
          P = -(p.vr*p.ir + p.vi*p.ii)*S_b;
          Q = -(p.vr*p.ii - p.vi*p.ir)*S_b;
          annotation (
            Icon(coordinateSystem(
                extent={{-100,-100},{100,100}},
                preserveAspectRatio=false,
                initialScale=0.1,
                grid={2,2}), graphics={Rectangle(
                  extent={{-100,-100},{100,100}},
                  lineColor={0,0,0},
                  fillColor={241,241,241},
                  fillPattern=FillPattern.Solid),Text(
                  visible=displayPF,
                  extent={{-80,100},{80,20}},
                  lineColor={255,0,0},
                  textString=DynamicSelect("0.0 MW",
                    OpenIPSL.NonElectrical.Functions.displayPower(P, " MW"))),Polygon(
                  visible=displayPF,
                  points=DynamicSelect({{-20,30},{-20,10},{20,20},{-20,30}}, if P >= 0
                     then {{-20,30},{-20,10},{20,20},{-20,30}} else {{20,30},{20,10},{-20,
                    20},{20,30}}),
                  lineColor={255,0,0},
                  fillColor={255,0,0},
                  fillPattern=FillPattern.Solid),Text(
                  visible=displayPF,
                  extent={{-80,-20},{80,-100}},
                  lineColor={0,255,0},
                  textString=DynamicSelect("0.0 Mvar",
                    OpenIPSL.NonElectrical.Functions.displayPower(Q, " Mvar"))),Polygon(
                  visible=displayPF,
                  points=DynamicSelect({{-20,-30},{-20,-10},{20,-20},{-20,-30}}, if Q
                     >= 0 then {{-20,-30},{-20,-10},{20,-20},{-20,-30}} else {{20,-30},
                    {20,-10},{-20,-20},{20,-30}}),
                  lineColor={0,255,0},
                  fillColor={0,255,0},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{-100,160},{100,120}},
                  lineColor={0,0,255},
                  textString="%name")}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                initialScale=0.1,
                grid={2,2})),
            Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>None</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>2015-12-14</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Maxime Baudette, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
        end InfiniteBus;

        model InternalBus "Bus for change base"
          outer OpenIPSL.Electrical.SystemBase SysData;
          constant Real pi=Modelica.Constants.pi;
          parameter Real M_b=120 "Machine base power rating (MVA)"
            annotation (Dialog(group="Power flow data"));
          parameter Real S_b=SysData.S_b "System base power rating (MVA)"
            annotation (Dialog(group="Power flow data"));
          OpenIPSL.Interfaces.PwPin p "Machine base" annotation (Placement(
                transformation(extent={{-32,-4},{-12,16}}), iconTransformation(
                  extent={{-32,-4},{-12,16}})));
          OpenIPSL.Interfaces.PwPin n "System base" annotation (Placement(
                transformation(extent={{8,-4},{28,16}}), iconTransformation(
                  extent={{8,-4},{28,16}})));
        protected
          parameter Real CoB=M_b/S_b;
        equation
          0 = n.vr - p.vr;
          0 = n.vi - p.vi;
          0 = p.ir*CoB + n.ir;
          0 = p.ii*CoB + n.ii;
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                    100}}), graphics={Rectangle(
                  extent={{8,96},{-12,-88}},
                  lineColor={0,0,255},
                  fillColor={95,95,95},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{-46,34},{-22,2}},
                  lineColor={0,0,255},
                  textString="*")}),
            Diagram(graphics),
            Documentation);
        end InternalBus;

        model BusExt
          outer OpenIPSL.Electrical.SystemBase SysData
            "Must add this line in all models";
          parameter Integer np(min=0) = 0 "Number of left connection"
            annotation (Dialog(connectorSizing=true), HideResult=true);
          parameter Integer nn(min=0) = 0 "Number of right connections"
            annotation (Dialog(connectorSizing=true), HideResult=true);
          OpenIPSL.Interfaces.PwPin p[np] annotation (Placement(
              visible=true,
              transformation(
                origin={-20.0001,1},
                extent={{-9.99994,-99},{10.0001,99}},
                rotation=0),
              iconTransformation(
                origin={20,0},
                extent={{-4,-60},{4,60}},
                rotation=0)));
          OpenIPSL.Interfaces.PwPin n[nn] annotation (Placement(
              visible=true,
              transformation(
                origin={20,0},
                extent={{-12,-100},{12,100}},
                rotation=0),
              iconTransformation(
                origin={0,0},
                extent={{-4,-60},{4,60}},
                rotation=0)));
          Real V(start=V_0) "Bus voltage magnitude (pu)";
          Real angle(start=angle_0) "Bus voltage angle (deg)";
          parameter Real V_0=1 "Voltage magnitude (pu)"
            annotation (Dialog(group="Power flow data"));
          parameter Real angle_0=0 "Voltage angle (deg)"
            annotation (Dialog(group="Power flow data"));
          parameter Real V_b=130 "Base voltage (kV)"
            annotation (Dialog(group="Power flow data"));
          parameter Real S_b=SysData.S_b "System base power (MVA)"
            annotation (Dialog(group="Power flow data"));
        protected
          parameter Real vr0=V_0*cos(angle_0*Modelica.Constants.pi/180);
          parameter Real vi0=V_0*sin(angle_0*Modelica.Constants.pi/180);
        equation
          if np > 1 then
            for i in 2:np loop
              connect(p[1], p[i]);
            end for;
          end if;
          if nn > 1 then
            for i in 2:nn loop
              connect(n[1], n[i]);
            end for;
          end if;
          if np > 0 and nn > 0 then
            connect(p[1], n[1]);
          end if;
          if np > 0 then
            V = sqrt(p[1].vr^2 + p[1].vi^2);
            angle = atan2(p[1].vi, p[1].vr)*180/Modelica.Constants.pi;
          elseif nn > 0 then
            V = sqrt(n[1].vr^2 + n[1].vi^2);
            angle = atan2(n[1].vi, n[1].vr)*180/Modelica.Constants.pi;
          else
            V = 0;
            angle = 0;
          end if;
          annotation (
            Diagram(coordinateSystem(extent={{0,-100},{20,100}})),
            Icon(coordinateSystem(extent={{0,-100},{20,100}}, preserveAspectRatio=false),
                graphics={Rectangle(
                  extent={{0,100},{20,-100}},
                  lineColor={0,0,255},
                  fillColor={85,170,255},
                  fillPattern=FillPattern.Solid)}),
            Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>None</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>2017-07-07</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Jan Lavenius, Giuseppe Laera, KTH Royal Institute of Technology; <a href=\"https://github.com/tbeu\">tbeu</a> </p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
        end BusExt;
      annotation (Documentation);
      end Buses;

      package Branches
        model PwLine "Model for a transmission Line based on the pi-equivalent circuit"
          outer OpenIPSL.Electrical.SystemBase SysData;
          import Modelica.ComplexMath.conj;
          import Modelica.ComplexMath.real;
          import Modelica.ComplexMath.imag;
          import Modelica.ComplexMath.j;
          OpenIPSL.Interfaces.PwPin p annotation (Placement(transformation(
                  extent={{-100,-10},{-80,10}}), iconTransformation(extent={{-100,
                    -10},{-80,10}})));
          OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                  extent={{80,-10},{100,10}}), iconTransformation(extent={{80,-10},
                    {100,10}})));
          parameter Modelica.SIunits.PerUnit R "Resistance (pu)"
            annotation (Dialog(group="Line parameters"));
          parameter Modelica.SIunits.PerUnit X "Reactance (pu)"
            annotation (Dialog(group="Line parameters"));
          parameter Modelica.SIunits.PerUnit G "Shunt half conductance (pu)"
            annotation (Dialog(group="Line parameters"));
          parameter Modelica.SIunits.PerUnit B "Shunt half susceptance (pu)"
            annotation (Dialog(group="Line parameters"));
          parameter OpenIPSL.Types.ApparentPowerMega S_b=SysData.S_b
            "System base power (MVA)"
            annotation (Dialog(group="Line parameters", enable=false));
          parameter Modelica.SIunits.Time t1=Modelica.Constants.inf
            annotation (Dialog(group="Perturbation parameters"));
          parameter Modelica.SIunits.Time t2=Modelica.Constants.inf
            annotation (Dialog(group="Perturbation parameters"));
          parameter Integer opening=1 annotation (Dialog(group=
                  "Perturbation parameters"), choices(
              choice=1 "Line opening at both ends",
              choice=2 "Line opening at sending end",
              choice=3 "Line opening at receiving end"));
          parameter Boolean displayPF=false "Display power flow results:" annotation (
              Dialog(
              group="Visualisation",
              __Dymola_compact=true,
              __Dymola_descriptionLabel=true), choices(checkBox=true));
          OpenIPSL.Types.ActivePowerMega P12;
          OpenIPSL.Types.ActivePowerMega P21;
          OpenIPSL.Types.ReactivePowerMega Q12;
          OpenIPSL.Types.ReactivePowerMega Q21;
          Complex vs(re=p.vr, im=p.vi);
          Complex is(re=p.ir, im=p.ii);
          Complex vr(re=n.vr, im=n.vi);
          Complex ir(re=n.ir, im=n.ii);
        protected
          parameter Complex Y(re=G, im=B);
          parameter Complex Z(re=R, im=X);
        equation
          //Calculations for the power flow display
          P12 = real(vs*conj(is))*S_b;
          P21 = -real(vr*conj(ir))*S_b;
          Q12 = imag(vs*conj(is))*S_b;
          Q21 = -imag(vr*conj(ir))*S_b;
          //PI model with different line openings
          if time >= t1 and time < t2 then
            if opening == 1 then
              is = Complex(0);
              ir = Complex(0);
            elseif opening == 2 then
              is = Complex(0);
              ir = (vr - ir*Z)*Y;
            else
              ir = Complex(0);
              is = (vs - is*Z)*Y;
            end if;
          else
            vs - vr = Z*(is - vs*Y);
            vr - vs = Z*(ir - vr*Y);
          end if;
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, initialScale=0.1),
                graphics={Rectangle(
                  extent={{-80,40},{80,-40}},
                  lineColor={0,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),Rectangle(
                  extent={{-60,20},{60,-20}},
                  lineColor={0,0,255},
                  fillColor={95,95,95},
                  fillPattern=FillPattern.Solid),Text(
                  visible=displayPF,
                  extent={{-200,160},{-20,40}},
                  lineColor={255,0,0},
                  textString=DynamicSelect("0.0 MW",
                    OpenIPSL.NonElectrical.Functions.displayPower(P12, " MW"))),Polygon(
                  visible=displayPF,
                  points=DynamicSelect({{-120,70},{-120,50},{-80,60},{-120,70}}, if P12
                     >= 0 then {{-120,70},{-120,50},{-80,60},{-120,70}} else {{-80,70},
                    {-80,50},{-120,60},{-80,70}}),
                  lineColor={255,0,0},
                  fillColor={255,0,0},
                  fillPattern=FillPattern.Solid),Text(
                  visible=displayPF,
                  extent={{20,160},{200,40}},
                  lineColor={255,0,0},
                  textString=DynamicSelect("0.0 MW",
                    OpenIPSL.NonElectrical.Functions.displayPower(P21, " MW"))),Polygon(
                  visible=displayPF,
                  points=DynamicSelect({{80,70},{80,50},{120,60},{80,70}}, if P21 >= 0
                     then {{80,70},{80,50},{120,60},{80,70}} else {{120,70},{120,50},{
                    80,60},{120,70}}),
                  lineColor={255,0,0},
                  fillColor={255,0,0},
                  fillPattern=FillPattern.Solid),Text(
                  visible=displayPF,
                  extent={{-200,-40},{-20,-160}},
                  lineColor={0,255,0},
                  textString=DynamicSelect("0.0 Mvar",
                    OpenIPSL.NonElectrical.Functions.displayPower(Q12, " Mvar"))),
                  Polygon(
                  visible=displayPF,
                  points=DynamicSelect({{-120,-70},{-120,-50},{-80,-60},{-120,-70}},
                    if Q12 >= 0 then {{-120,-70},{-120,-50},{-80,-60},{-120,-70}} else
                    {{-80,-70},{-80,-50},{-120,-60},{-80,-70}}),
                  lineColor={0,255,0},
                  fillColor={0,255,0},
                  fillPattern=FillPattern.Solid),Text(
                  visible=displayPF,
                  extent={{20,-40},{200,-160}},
                  lineColor={0,255,0},
                  textString=DynamicSelect("0.0 Mvar",
                    OpenIPSL.NonElectrical.Functions.displayPower(Q21, " Mvar"))),
                  Polygon(
                  visible=displayPF,
                  points=DynamicSelect({{80,-70},{80,-50},{120,-60},{80,-70}}, if Q21
                     >= 0 then {{80,-70},{80,-50},{120,-60},{80,-70}} else {{120,-70},{
                    120,-50},{80,-60},{120,-70}}),
                  lineColor={0,255,0},
                  fillColor={0,255,0},
                  fillPattern=FillPattern.Solid),Text(
                  extent={{-60,20},{60,-20}},
                  lineColor={255,255,0},
                  textString="%name")}), Documentation);
        end PwLine;

        package Simulink
          package LTC
            model LTC
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator(
                outMax=1,
                k=1,
                outMin=-delay1,
                y_start=-delay1,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{62,8},{78,24}})));
              LTC_deadband deadband1(Uplim=Uplim, Downlim=Downlim)
                annotation (Placement(transformation(extent={{-12,-14},{54,42}})));
              parameter Real Uplim=0.01;
              parameter Real Downlim=-0.01;
              parameter Real Ymin=0.88 "Min Ratio";
              parameter Real Ymax=1.2 "Max Ratio";
              parameter Real delay1;
              parameter Real delay2;
              parameter Real positionNo=33;
              parameter Real r0=1 "Transformer Ratio";
              LTC_switch lTC_switch
                annotation (Placement(transformation(extent={{88,6},{108,26}})));
              Modelica.Blocks.Sources.Constant imSetPoint(k=0)
                annotation (Placement(transformation(extent={{62,-20},{82,0}})));
              Modelica.Blocks.Sources.Constant imSetPoint1(k=1)
                annotation (Placement(transformation(extent={{-76,-38},{-56,-18}})));
              Modelica.Blocks.Interfaces.RealOutput r annotation (Placement(transformation(
                      extent={{178,6},{198,26}}), iconTransformation(extent={{78,0},{114,38}})));
              LTC_lookup lTC_lookup(Uplim=Uplim, Downlim=Downlim)
                annotation (Placement(transformation(extent={{-2,42},{42,86}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator1(
                outMin=Ymin,
                outMax=Ymax,
                k=(Ymax - Ymin)/(positionNo*delay2),
                y_start=r0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{120,8},{136,24}})));
              LTC_quantizer lTC_quantizer
                annotation (Placement(transformation(extent={{150,6},{170,26}})));
              Modelica.Blocks.Interfaces.RealInput u annotation (Placement(transformation(
                      extent={{-84,12},{-64,32}}), iconTransformation(extent={{-116,4},{-80,
                        42}})));
              Modelica.Blocks.Math.Add add(k2=-1)
                annotation (Placement(transformation(extent={{-34,6},{-14,26}})));
            equation
              connect(lTC_lookup.out, lTC_switch.LTCin) annotation (Line(
                  points={{36.94,64.22},{84,64.22},{84,20.9},{91.6,20.9}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(r, lTC_quantizer.n) annotation (Line(
                  points={{188,16},{182,16},{182,16.1},{168.5,16.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(imLimitedIntegrator1.y, lTC_quantizer.p)
                annotation (Line(points={{136.8,16},{152.7,16}}, color={0,0,127}));
              connect(imLimitedIntegrator1.u, lTC_switch.r) annotation (Line(points={{118.4,
                      16},{105.1,16},{105.1,16.8}}, color={0,0,127}));
              connect(imLimitedIntegrator.y, lTC_switch.Signalin)
                annotation (Line(points={{78.8,16},{91.7,16}}, color={0,0,127}));
              connect(deadband1.signal, imLimitedIntegrator.u) annotation (Line(points={{
                      42.78,16.24},{51.39,16.24},{51.39,16},{60.4,16}}, color={0,0,127}));
              connect(imSetPoint.y, lTC_switch.Normalin) annotation (Line(points={{83,-10},
                      {88,-10},{88,10.7},{91.7,10.7}}, color={0,0,127}));
              connect(add.y, deadband1.u)
                annotation (Line(points={{-13,16},{1.2,16},{1.2,16.24}}, color={0,0,127}));
              connect(lTC_lookup.u, deadband1.u) annotation (Line(points={{3.72,63.78},{-8,
                      63.78},{-8,16},{1.2,16},{1.2,16.24}}, color={0,0,127}));
              connect(add.u1, u)
                annotation (Line(points={{-36,22},{-74,22}}, color={0,0,127}));
              connect(imSetPoint1.y, add.u2) annotation (Line(points={{-55,-28},{-44,-28},{
                      -44,10},{-36,10}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        200,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{200,
                        100}}), graphics={Rectangle(
                      extent={{-78,70},{80,-32}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-60,32},{66,-58}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="LTC
    ")}),       Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Load Tap Changer</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end LTC;

            model LTC_deadband
              Modelica.Blocks.Interfaces.RealOutput signal annotation (Placement(
                    transformation(extent={{56,-2},{76,18}}), iconTransformation(extent={{
                        56,-2},{76,18}})));
              Modelica.Blocks.Interfaces.RealInput u annotation (Placement(transformation(
                      extent={{-68,0},{-48,20}}), iconTransformation(extent={{-70,-2},{-50,
                        18}})));
              parameter Real Uplim;
              parameter Real Downlim;
            equation
              if u > Uplim or u < Downlim then
                signal = 1;
              else
                signal = -100;
              end if;
              annotation (
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(
                      extent={{-50,52},{56,-38}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-34,32},{40,-24}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid,
                      textString="deadband")}),
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Load Tap Changer with a deadband</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end LTC_deadband;

            model LTC_switch
              Modelica.Blocks.Interfaces.RealInput Signalin annotation (Placement(
                    transformation(extent={{-68,-4},{-48,16}}), iconTransformation(extent={
                        {-78,-16},{-48,16}})));
              Modelica.Blocks.Interfaces.RealInput LTCin annotation (Placement(
                    transformation(extent={{-68,46},{-48,66}}), iconTransformation(extent={
                        {-80,32},{-48,66}})));
              Modelica.Blocks.Interfaces.RealInput Normalin annotation (Placement(
                    transformation(extent={{-68,-58},{-48,-38}}), iconTransformation(extent=
                       {{-78,-68},{-48,-38}})));
              Modelica.Blocks.Interfaces.RealOutput r annotation (Placement(transformation(
                      extent={{54,0},{74,20}}), iconTransformation(extent={{56,-8},{86,24}})));
            equation
              if Signalin > 0 then
                r = LTCin;
              else
                r = Normalin;
              end if;
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(
                      extent={{-46,94},{56,-94}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Line(
                      points={{-46,0},{-32,0},{-32,18}},
                      color={0,0,255},
                      smooth=Smooth.None,
                      thickness=1),Line(
                      points={{-32,0},{-32,-18}},
                      color={0,0,255},
                      smooth=Smooth.None,
                      thickness=1)}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Load Tap Changer with switching</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end LTC_switch;

            model LTC_quantizer
              Modelica.Blocks.Interfaces.RealInput p annotation (Placement(transformation(
                      extent={{-76,-2},{-56,18}}), iconTransformation(extent={{-90,-18},{-56,
                        18}})));
              Modelica.Blocks.Interfaces.RealOutput n annotation (Placement(transformation(
                      extent={{70,-4},{90,16}}), iconTransformation(extent={{70,-14},{100,
                        16}})));
              parameter Real Ratio[1, 33]=[0.88, 0.89, 0.9, 0.91, 0.92, 0.93, 0.94, 0.95,
                  0.96, 0.97, 0.98, 0.99, 1, 1.01, 1.02, 1.03, 1.04, 1.05, 1.06, 1.07, 1.08,
                  1.09, 1.1, 1.11, 1.12, 1.13, 1.14, 1.15, 1.16, 1.17, 1.18, 1.19, 1.2];
            equation
              if 0.77 <= p and p < Ratio[1, 2] then
                n = Ratio[1, 1];
              elseif Ratio[1, 2] <= p and p < Ratio[1, 3] then
                n = Ratio[1, 2];
              elseif Ratio[1, 3] <= p and p < Ratio[1, 4] then
                n = Ratio[1, 3];
              elseif Ratio[1, 4] <= p and p < Ratio[1, 5] then
                n = Ratio[1, 4];
              elseif Ratio[1, 5] <= p and p < Ratio[1, 6] then
                n = Ratio[1, 5];
              elseif Ratio[1, 6] <= p and p < Ratio[1, 7] then
                n = Ratio[1, 6];
              elseif Ratio[1, 7] <= p and p < Ratio[1, 8] then
                n = Ratio[1, 7];
              elseif Ratio[1, 8] <= p and p < Ratio[1, 9] then
                n = Ratio[1, 8];
              elseif Ratio[1, 9] <= p and p < Ratio[1, 10] then
                n = Ratio[1, 9];
              elseif Ratio[1, 10] <= p and p < Ratio[1, 11] then
                n = Ratio[1, 10];
              elseif Ratio[1, 11] <= p and p < Ratio[1, 12] then
                n = Ratio[1, 11];
              elseif Ratio[1, 12] <= p and p < Ratio[1, 13] then
                n = Ratio[1, 12];
              elseif Ratio[1, 13] <= p and p < Ratio[1, 14] then
                n = Ratio[1, 13];
              elseif Ratio[1, 14] <= p and p < Ratio[1, 15] then
                n = Ratio[1, 14];
              elseif Ratio[1, 15] <= p and p < Ratio[1, 16] then
                n = Ratio[1, 15];
              elseif Ratio[1, 16] <= p and p < Ratio[1, 17] then
                n = Ratio[1, 16];
              elseif Ratio[1, 17] <= p and p < Ratio[1, 18] then
                n = Ratio[1, 17];
              elseif Ratio[1, 18] <= p and p < Ratio[1, 19] then
                n = Ratio[1, 18];
              elseif Ratio[1, 19] <= p and p < Ratio[1, 20] then
                n = Ratio[1, 19];
              elseif Ratio[1, 20] <= p and p < Ratio[1, 21] then
                n = Ratio[1, 20];
              elseif Ratio[1, 21] <= p and p < Ratio[1, 22] then
                n = Ratio[1, 21];
              elseif Ratio[1, 22] <= p and p < Ratio[1, 23] then
                n = Ratio[1, 22];
              elseif Ratio[1, 23] <= p and p < Ratio[1, 24] then
                n = Ratio[1, 23];
              elseif Ratio[1, 24] <= p and p < Ratio[1, 25] then
                n = Ratio[1, 24];
              elseif Ratio[1, 25] <= p and p < Ratio[1, 26] then
                n = Ratio[1, 25];
              elseif Ratio[1, 26] <= p and p < Ratio[1, 27] then
                n = Ratio[1, 26];
              elseif Ratio[1, 27] <= p and p < Ratio[1, 28] then
                n = Ratio[1, 27];
              elseif Ratio[1, 28] <= p and p < Ratio[1, 29] then
                n = Ratio[1, 28];
              elseif Ratio[1, 29] <= p and p < Ratio[1, 30] then
                n = Ratio[1, 29];
              elseif Ratio[1, 30] <= p and p < Ratio[1, 31] then
                n = Ratio[1, 30];
              elseif Ratio[1, 31] <= p and p < Ratio[1, 32] then
                n = Ratio[1, 31];
              elseif Ratio[1, 32] <= p and p < Ratio[1, 33] then
                n = Ratio[1, 32];
              else
                n = Ratio[1, 33];
              end if;
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-54,46},{70,-42}}, lineColor={
                      0,0,255}),Line(
                      points={{-36,-36},{-26,-36},{-26,-28},{-16,-28},{-16,-18},{-8,-18},{-8,
                        -8},{2,-8},{2,2},{10,2},{10,10},{18,10},{18,18},{26,18},{26,26},{34,
                        26},{34,32},{42,32},{42,38},{50,38},{50,44},{60,44}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Load Tap Changer's quantizer</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end LTC_quantizer;

            model LTC_lookup
              Modelica.Blocks.Interfaces.RealInput u annotation (Placement(transformation(
                      extent={{-76,-2},{-56,18}}), iconTransformation(extent={{-92,-20},{-56,
                        18}})));
              Modelica.Blocks.Interfaces.RealOutput out annotation (Placement(
                    transformation(extent={{62,-12},{82,8}}), iconTransformation(extent={{
                        62,-16},{92,18}})));
              parameter Real Uplim;
              parameter Real Downlim;
            equation
              if u > Uplim then
                out = 1;
              elseif u < Downlim then
                out = -1;
              else
                out = 0;
              end if;
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-54,32},{62,-34}}, lineColor={
                      0,0,255}),Line(
                      points={{-46,-18},{-12,-18},{-10,-18}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-10,0},{12,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-10,0},{-10,-18}},
                      color={0,0,255},
                      smooth=Smooth.None,
                      pattern=LinePattern.Dash),Line(
                      points={{12,20},{12,0}},
                      color={0,0,255},
                      smooth=Smooth.None,
                      pattern=LinePattern.Dash),Line(
                      points={{12,20},{34,20},{52,20}},
                      color={0,0,255},
                      smooth=Smooth.None)}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Load Tap Changer's lookup</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end LTC_lookup;
          annotation (Documentation);
          end LTC;
        annotation (Documentation);
        end Simulink;

        package PSSE
          model TwoWindingTransformer
            "Static Two-winding transformer according to PSS/E, without phase shift"
            outer OpenIPSL.Electrical.SystemBase SysData;
            import Modelica.Constants.pi;
            import Modelica.ComplexMath.j;
            import Modelica.ComplexMath.conj;
            OpenIPSL.Interfaces.PwPin p annotation (Placement(transformation(
                    extent={{-80,-10},{-60,10}}), iconTransformation(extent={{-80,
                      -10},{-60,10}})));
            OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                    extent={{60,-10},{80,10}}), iconTransformation(extent={{60,
                      -10},{80,10}})));
            parameter Real S_b=SysData.S_b "System base power (MVA)"
              annotation (Dialog(enable=false));
            parameter Integer CZ=1 "Impedance I/O code" annotation (Dialog(tab=
                    "Transformer impedance data"), choices(
                choice=1 "Z pu (winding kV system MVA)",
                choice=2 "Z pu (winding kV widing MVA)",
                choice=3 "Load loss (W) & |Z| (pu)"));
            parameter Real R "Specified R (pu)"
              annotation (Dialog(tab="Transformer impedance data"));
            parameter Real X "Specified X (pu)"
              annotation (Dialog(tab="Transformer impedance data"));
            parameter Real G "Magnetizing G"
              annotation (Dialog(tab="Transformer impedance data"));
            parameter Real B "Magnetizing B"
              annotation (Dialog(tab="Transformer impedance data"));
            parameter Integer CW=1 "Winding I/O code" annotation (Dialog(tab=
                    "Transformer Nominal Ratings Data"), choices(
                choice=1 "Turns ratio (pu on bus base kV)",
                choice=2 "Winding voltage (kV)",
                choice=3 "Turns ratio (pu on nom wind kV)"));
            parameter Real t1=1 "Winding 1 ratio (pu)"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real VNOM1=0 "Winding 1 Nominal kV"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real VB1=300 "Bus Base kV on the side of winding 1"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real t2=1 "Secondary winding tap ratio"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real VNOM2=0 "Winding 2 Nominal kV"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real VB2=300 "Bus Base kV on the side of winding 2"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real ANG1=0 "Winding (1-2) Angle (degrees)"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
            parameter Real S_n=S_b "Winding MVA"
              annotation (Dialog(tab="Transformer Nominal Ratings Data"));
          protected
            parameter Real VNOM1_int=if abs(VNOM1) < Modelica.Constants.eps then VB1
                 else VNOM1;
            parameter Real VNOM2_int=if abs(VNOM2) < Modelica.Constants.eps then VB2
                 else VNOM2;
            parameter Real r=if CZ == 1 then R else R*S_b/S_n;
            parameter Real x=if CZ == 1 then X else X*S_b/S_n;
            parameter Complex t=T1/T2*(cos(ANG1/180*pi) + j*sin(ANG1/180*pi));
            parameter Real T2=if CW == 1 then t2 elseif CW == 3 then t2*(VNOM2_int/VB2)
                 else t2/VB2;
            parameter Real T1=if CW == 1 then t1 elseif CW == 3 then t1*(VNOM1_int/VB1)
                 else t1/VB1;
            parameter Complex Ym(re=G, im=B);
            parameter Complex xeq(re=r*abs(T2)^2, im=x*abs(T2)^2);
            Complex ei(re=p.vr, im=p.vi);
            Complex ej(re=n.vr, im=n.vi);
            Complex ii(re=p.ir, im=p.ii);
            Complex ij(re=n.ir, im=n.ii);
          equation
            ej = ei/t + xeq*ij;
            (ii - ei*Ym)*conj(t) = -ij;
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-60,-40},{60,40}}),
                  graphics={Rectangle(
                    extent={{-60,40},{60,-40}},
                    lineColor={255,255,255},
                    fillColor={255,255,255},
                    fillPattern=FillPattern.Solid),Ellipse(extent={{-50,30},{10,-30}},
                    lineColor={28,108,200}),Ellipse(extent={{-12,30},{52,-30}}, lineColor=
                     {28,108,200}),Line(
                    points={{-60,0},{-50,0}},
                    color={28,108,200},
                    arrow={Arrow.None,Arrow.Filled}),Line(points={{52,0},{60,0}}, color={
                    28,108,200}),Polygon(
                    points={{-56,4},{-50,0},{-56,-4},{-56,4}},
                    lineColor={28,108,200},
                    fillColor={28,108,200},
                    fillPattern=FillPattern.Solid)}),
              Diagram(coordinateSystem(extent={{-60,-40},{60,40}}, preserveAspectRatio=
                      false)),
              Documentation);
          end TwoWindingTransformer;
        annotation (Documentation);
        end PSSE;

        package PSAT
          model TwoWindingTransformer "Modeled as series reactances without iron losses"
            outer OpenIPSL.Electrical.SystemBase SysData;
            OpenIPSL.Interfaces.PwPin p annotation (Placement(transformation(
                    extent={{-120,-10},{-100,10}})));
            OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                    extent={{100,-10},{120,10}})));
            parameter Real S_b=SysData.S_b "System base power (MVA)"
              annotation (Dialog(group="Power flow"));
            parameter Real V_b=40 "Sending end bus voltage (kV)"
              annotation (Dialog(group="Power flow"));
          //  parameter Real fn=SysData.fn "Frequency rating (Hz)"
          //    annotation (Dialog(group="Power flow"));
            parameter Real Sn=100 "Power rating (MVA)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real Vn=40 "Voltage rating of transformer (kV)"
              annotation (Dialog(group="Transformer parameters"));
          //  parameter Real kT=1 "Nominal tap ratio (kV1/kV2)"
          //    annotation (Dialog(group="Transformer parameters"));
            parameter Real rT=0.01 "Resistance (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real xT=0.2 "Reactance (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real m=1.0 "Optional fixed tap ratio"
              annotation (Dialog(group="Transformer parameters"));

          protected
            parameter Real Zn = Vn^2/Sn "Transformer base impedance";
            parameter Real Zb = V_b^2/S_b "System base impedance";
            parameter Real r = rT * Zn/Zb "Resistance (pu, system base)";
            parameter Real x = xT * Zn/Zb "Reactance (pu, system base)";
            parameter Boolean tc = m <> 1.0 "Internal parameter to switch on the icon arrow";
          equation
            r*p.ir - x*p.ii = 1/m^2*p.vr - 1/m*n.vr;
            r*p.ii + x*p.ir = 1/m^2*p.vi - 1/m*n.vi;
            r*n.ir - x*n.ii = n.vr - 1/m*p.vr;
            x*n.ir + r*n.ii = n.vi - 1/m*p.vi;
            annotation (
              Icon(graphics={Ellipse(extent={{-46,30},{8,-30}}, lineColor={0,0,255}),
                    Ellipse(extent={{-10,30},{44,-30}}, lineColor={0,0,255}),Line(
                    points={{100,0},{44,0},{44,0}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{-100,0},{-46,0}},
                    color={0,0,255},
                    smooth=Smooth.None),Text(
                    extent={{-38,20},{-4,-20}},
                    lineColor={28,108,200},
                    textString="1"),Text(
                    extent={{4,18},{32,-16}},
                    lineColor={28,108,200},
                    textString="2"),
                  Text(
                    extent={{-100,100},{100,40}},
                    lineColor={0,0,255},
                    textString="%name"),
                  Line(
                    visible= tc,
                    points={{-60,-40},{0,40}},
                    color={28,108,200}),
                  Line(
                    points={{0,40},{-10,36}},
                    color={28,108,200},
                    visible=tc),
                  Line(
                    visible=tc,
                    points={{0,40},{0,30}},
                    color={28,108,200}),
                  Text(
                    visible=tc,
                    extent={{-80,-40},{-40,-60}},
                    lineColor={28,108,200},
                    textString="TC")}),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>29/09/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end TwoWindingTransformer;

          model ThreeWindingTransformer
            outer OpenIPSL.Electrical.SystemBase SysData;
            OpenIPSL.Interfaces.PwPin b1 annotation (Placement(transformation(
                    extent={{-120,-10},{-100,10}}), iconTransformation(extent={
                      {-120,-10},{-100,10}})));
            OpenIPSL.Interfaces.PwPin b2 annotation (Placement(transformation(
                    extent={{100,20},{120,40}})));
            OpenIPSL.Interfaces.PwPin b3 annotation (Placement(transformation(
                    extent={{100,-40},{120,-20}})));
            parameter Real S_b=SysData.S_b "System base power (MVA)"
              annotation (Dialog(group="Power flow"));
            parameter Real V_b=400000 "Sending end bus voltage (kV)"
              annotation (Dialog(group="Power flow"));
            parameter Real Sn=100 "Power rating (MVA)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real Vn=400000 "Voltage rating for transformer (V)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real r12=0.01 "Resistance of the branch 1-2 (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real r13=0.01 "Resistance of the branch 1-3 (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real r23=0.01 "Resistance of the branch 2-3 (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real x12=0.1 "Reactance of the branch 1-2 (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real x13=0.1 "Reactance of the branch 1-3 (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real x23=0.1 "Reactance of the branch 2-3 (pu, transformer base)"
              annotation (Dialog(group="Transformer parameters"));
            parameter Real m=0.98 "Fixed tap ratio"
              annotation (Dialog(group="Transformer parameters"));
            Real v0 "Voltage of the fictious bus";
            Real v1;
            Real v2;
            Real v3;
            Real anglev0 "Angle of the fictious bus";
            Real anglev1;
            Real anglev2;
            Real anglev3;
            TwoWindingTransformer branch1(
              V_b=V_b,
              Sn=Sn,
              Vn=Vn,
              rT=0.5*(r12 + r13 - r23),
              xT=0.5*(x12 + x13 - x23),
              m=m) annotation (Placement(transformation(extent={{-58,-10},{-38,10}})));
            TwoWindingTransformer branch2(
              V_b=V_b,                    Sn=Sn,
              Vn=Vn,
              rT=0.5*(r12 + r23 - r13),
              xT=0.5*(x12 + x23 - x13))                annotation (Placement(transformation(extent={{40,20},{60,40}})));
            TwoWindingTransformer branch3(
              V_b=V_b,                    Sn=Sn,
              Vn=Vn,
              rT=0.5*(r23 + r13 - r12),
              xT=0.5*(x23 + x13 - x12))                annotation (Placement(transformation(extent={{40,-40},{60,-20}})));
          equation
            v0 = sqrt(branch1.n.vr^2 + branch1.n.vi^2);
            v1 = sqrt(b1.vr^2 + b1.vi^2);
            v2 = sqrt(b2.vr^2 + b2.vi^2);
            v3 = sqrt(b3.vr^2 + b3.vi^2);
            anglev0 = atan2(branch1.n.vi, branch1.n.vr);
            anglev1 = atan2(b1.vi, b1.vr);
            anglev2 = atan2(b2.vi, b2.vr);
            anglev3 = atan2(b3.vi, b3.vr);
            connect(branch1.p, b1) annotation (Line(
                points={{-59,0},{-110,0}},
                color={0,0,255},
                smooth=Smooth.None));
            connect(branch1.n, branch2.p) annotation (Line(points={{-37,0},{0,0},{0,30},{39,30}}, color={0,0,255}));
            connect(branch2.n, b2) annotation (Line(points={{61,30},{110,30}}, color={0,0,255}));
            connect(branch1.n, branch3.p) annotation (Line(points={{-37,0},{0,0},{0,-30},{39,-30}}, color={0,0,255}));
            connect(branch3.n, b3) annotation (Line(points={{61,-30},{110,-30}}, color={0,0,255}));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}})),
              Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics={Ellipse(extent={{-52,34},{12,-28}}, lineColor={0,
                    0,255}),Ellipse(extent={{-4,64},{60,2}}, lineColor={0,0,255}),Ellipse(
                    extent={{-2,16},{62,-46}}, lineColor={0,0,255}),Line(
                    points={{-54,-22},{10,42},{10,42}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{2,40},{10,42},{10,42}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{8,34},{10,42}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{60,32},{100,32},{100,32}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{58,-28},{102,-28},{100,-28}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{-100,0},{-52,0}},
                    color={0,0,255},
                    smooth=Smooth.None),Text(
                    extent={{-60,-50},{60,-92}},
                    lineColor={0,128,0},
                    textString="TWT"),
                  Text(
                    extent={{-100,140},{100,80}},
                    lineColor={0,0,255},
                    textString="%name")}),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>15/07/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end ThreeWindingTransformer;

          model ULTC_VoltageControl
            "Under Load Tap Changer, continuous model, secondary voltage control"
            OpenIPSL.Interfaces.PwPin p annotation (Placement(transformation(
                    extent={{-120,-10},{-100,10}})));
            OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                    extent={{100,-10},{120,10}})));
            parameter Real S_b=100 "System base power (MVA)"
              annotation (Dialog(group="Power flow data"));
            parameter Real Vbus1=400000 "Sending end Bus nominal voltage (V)"
              annotation (Dialog(group="Power flow data"));
            parameter Real Vbus2=100000 "Receiving end Bus nominal voltage (V)"
              annotation (Dialog(group="Power flow data"));
            parameter Real Sn=100 "Power rating (MVA)"
              annotation (Dialog(group="ULTC data"));
            parameter Real Vn=400000 "Voltage rating (V)"
              annotation (Dialog(group="ULTC data"));
            parameter Real V_0=1.008959700699460
              "Initial voltage magnitude of the controlled bus (pu)"
              annotation (Dialog(group="Power flow data"));
            parameter Real m0=0.98 "Initial tap ratio"
              annotation (Dialog(group="Power flow data"));
            parameter Real kT=4 "Nominal tap ratio (V1/V2)"
              annotation (Dialog(group="ULTC data"));
            parameter Real H=0.001 "Integral deviation (pu)"
              annotation (Dialog(group="ULTC data"));
            parameter Real K=0.10 "Inverse time constant (1/s)"
              annotation (Dialog(group="ULTC data"));
            parameter Real m_max=0.98 "Maximum tap ratio (p.u./p.u.)"
              annotation (Dialog(group="ULTC data"));
            parameter Real m_min=0.9785 "Minimum tap ratio (p.u./p.u.)"
              annotation (Dialog(group="ULTC data"));
          //    annotation (Dialog(group="ULTC data"));
          //  parameter Real deltam=0 "Tap ratio step (p.u./p.u.)"
            parameter Real v_ref=1.0 "Reference voltage (power) (pu)"
              annotation (Dialog(group="ULTC data"));
            parameter Real xT=0.001 "Transformer reactance (pu)"
              annotation (Dialog(group="ULTC data"));
            parameter Real rT=0.1 "Transformer resistance (pu)"
              annotation (Dialog(group="ULTC data"));
          //  parameter Real d=0.05 "Dead zone percentage"
          //    annotation (Dialog(group="ULTC data"));
            Real m "Tap ratio";
            Real vk "Voltage at primary, p.u.";
            Real vm(start=V_0) "Voltage at secondary p.u.";
            Real anglevk "Angle at primary";
            Real anglevm "Angle at secondary ";
          protected
            parameter Real V2=Vn/kT "Secondary voltage";
            parameter Real Zn = Vn^2/Sn "Transformer base impedance";
            parameter Real Zb = Vbus1^2/S_b "System base impedance";
            parameter Real r = rT * Zn/Zb "Resistance (pu, system base)";
            parameter Real x = xT * Zn/Zb "Reactance (pu, system base)";
            parameter Real vref=v_ref*(V2/Vbus2);
          initial equation
            m = m0;
          equation
            vk = sqrt(p.vr^2 + p.vi^2);
            vm = sqrt(n.vr^2 + n.vi^2);
            anglevk = atan2(p.vi, p.vr);
            anglevm = atan2(n.vi, n.vr);
            if m > m_max and der(m) > 0 then
              r*p.ir - x*p.ii = 1/m_max^2*p.vr - 1/m_max*n.vr;
              r*p.ii + x*p.ir = 1/m_max^2*p.vi - 1/m_max*n.vi;
              r*n.ir - x*n.ii = n.vr - 1/m_max*p.vr;
              x*n.ir + r*n.ii = n.vi - 1/m_max*p.vi;
              der(m) = 0;
            elseif m < m_min and der(m) < 0 then
              r*p.ir - x*p.ii = 1/m_min^2*p.vr - 1/m_min*n.vr;
              r*p.ii + x*p.ir = 1/m_min^2*p.vi - 1/m_min*n.vi;
              r*n.ir - x*n.ii = n.vr - 1/m_min*p.vr;
              x*n.ir + r*n.ii = n.vi - 1/m_min*p.vi;
              der(m) = 0;
            else
              r*p.ir - x*p.ii = 1/m^2*p.vr - 1/m*n.vr;
              r*p.ii + x*p.ir = 1/m^2*p.vi - 1/m*n.vi;
              r*n.ir - x*n.ii = n.vr - 1/m*p.vr;
              x*n.ir + r*n.ii = n.vi - 1/m*p.vi;
              der(m) = (-H*m) + K*(vm - vref);
            end if;
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics),
              Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics={Ellipse(extent={{-46,30},{8,-30}}, lineColor={0,0,
                    255}),Ellipse(extent={{-10,30},{44,-30}}, lineColor={0,0,255}),Line(
                    points={{100,0},{44,0},{44,0}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{-100,0},{-46,0}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{70,0},{70,-40},{-36,-40},{-20,18},{-20,18}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{-30,6},{-20,18}},
                    color={0,0,255},
                    smooth=Smooth.None),Line(
                    points={{-20,2},{-20,16}},
                    color={0,0,255},
                    smooth=Smooth.None),Text(
                    extent={{-100,-40},{100,-100}},
                    lineColor={0,128,0},
                    textString="ULTC"),
                  Text(
                    extent={{-100,100},{100,40}},
                    lineColor={0,0,255},
                    textString="%name")}),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>15/07/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end ULTC_VoltageControl;

          package PhaseShiftingTransformer
            model PSTransformer
              constant Real pi=Modelica.Constants.pi;
              parameter Real SystemBase=100;
              parameter Real Vbus1=20000 "Sending end Bus nominal voltage, change of base";
              parameter Real Vbus2=20000 "Receiving end Bus voltage, change of base";
              parameter Real Sn=100 "Power rating MVA";
              parameter Real Vn1=20000 "Primary Voltage rating,KV";
              parameter Real Vn2=20000 "Secondary voltage rating, KV";
              parameter Real fn=50 "Frequency rating Hz";
              parameter Real Tm=0.001 "Measurement time constant, s";
              parameter Real Kp=0.05 "Proportional gain";
              parameter Real Ki=0.01 "Integral gain";
              parameter Real p_ref=0.01 "Reference Power, p.u.";
              parameter Real alpha_max=pi/2 "Maximum phase angle, rad";
              parameter Real alpha_min=-pi/2 "Minimum phase angle, rad";
              parameter Real xT=0.1 "Transformer Reactance, p.u.";
              parameter Real rT=0.01 "Transformer Resistance, p.u.";
              parameter Real m=0.98 "Transformer fixed tap  ratio, p.u./p.u.";
              parameter Real alpha0=0.002062339234360;
              parameter Real pmes0=0.01;
              parameter Real vk0=0.997649085060455;
              parameter Real vm0=1.007257703014177;
              parameter Real anglevk0=-0.007392164704867;
              parameter Real anglevm0=-0.009372077496959;
              Real vk(start=vk0);
              Real vm(start=vm0);
              Real anglevk(start=anglevk0);
              Real anglevm(start=anglevm0);
              OpenIPSL.Interfaces.PwPin p annotation (Placement(transformation(
                      extent={{-120,-10},{-100,10}})));
              OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                      extent={{100,-10},{120,10}})));
              Modelica.Blocks.Interfaces.RealOutput pk(start=p_ref) annotation (Placement(
                    transformation(extent={{100,-50},{120,-30}}), iconTransformation(extent=
                       {{100,-50},{120,-30}})));
              Modelica.Blocks.Interfaces.RealInput u
                annotation (Placement(transformation(extent={{-140,36},{-100,76}})));
              pst1 pst1_1(
                SystemBase=SystemBase,
                Vbus1=Vbus1,
                Vbus2=Vbus2,
                Sn=Sn,
                Vn1=Vn1,
                Vn2=Vn2,
                fn=fn,
                Tm=Tm,
                Kp=Kp,
                Ki=Ki,
                p_ref=p_ref,
                alpha_max=alpha_max,
                alpha_min=alpha_min,
                xT=xT,
                rT=rT,
                m=m,
                alpha0=alpha0,
                pmes0=pmes0,
                vk0=vk0,
                anglevk0=anglevk0)
                annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              pst2 pst2_1(
                SystemBase=SystemBase,
                Vbus1=Vbus1,
                Vbus2=Vbus2,
                Sn=Sn,
                Vn1=Vn1,
                Vn2=Vn2,
                fn=fn,
                Tm=Tm,
                Kp=Kp,
                Ki=Ki,
                p_ref=p_ref,
                alpha_max=alpha_max,
                alpha_min=alpha_min,
                xT=xT,
                rT=rT,
                m=m,
                alpha0=alpha0,
                pmes0=pmes0,
                vm0=vm0,
                anglevm0=anglevm0)
                annotation (Placement(transformation(extent={{20,-10},{40,10}})));
            protected
              parameter Real Vb2new=Vbus1*Vbus1;
              parameter Real Vb2old=Vn1*Vn1;
              parameter Real R=rT*(Vb2old*SystemBase)/(Vb2new*Sn)
                "Transformer Resistance, p.u.";
              parameter Real X=xT*(Vb2old*SystemBase)/(Vb2new*Sn)
                "Transformer Reactance, p.u.";
              parameter Real pref=p_ref*(Sn/SystemBase);
              parameter Real gt=R/(R^2 + X^2) "Converting resistance to conductance p.u.";
              parameter Real bt=-X/(R^2 + X^2) "Converting reactance to susceptance p.u.";
            equation
              vk = sqrt(p.vr^2 + p.vi^2);
              vm = sqrt(n.vr^2 + n.vi^2);
              anglevk = atan2(p.vi, p.vr);
              anglevm = atan2(n.vi, n.vr);
              pk = p.vr*p.ir + p.vi*p.ii;
              connect(pst2_1.n, n) annotation (Line(
                  points={{41,0},{70.5,0},{70.5,0},{110,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pst2_1.p, pst1_1.n) annotation (Line(
                  points={{19,0},{-2,0},{-2,0},{-19,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(pst1_1.p, p) annotation (Line(
                  points={{-41,0},{-76.5,0},{-76.5,0},{-110,0}},
                  color={0,0,255},
                  smooth=Smooth.None));
              connect(u, pst2_1.pk) annotation (Line(
                  points={{-120,56},{-8,56},{-8,-4},{18,-4}},
                  color={0,0,127},
                  smooth=Smooth.None));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Ellipse(extent={{-48,24},{10,-32}}, lineColor={0,
                      0,255}),Ellipse(extent={{-6,26},{52,-30}}, lineColor={0,0,255}),Line(
                      points={{-104,0},{-48,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Rectangle(extent={{66,10},{94,-12}}, lineColor={0,
                      0,255}),Line(
                      points={{52,0},{66,0},{66,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{100,0},{94,0},{96,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{80,-12},{80,-44},{-50,-44},{-50,0},{-50,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Text(
                      extent={{74,4},{84,-2}},
                      lineColor={0,0,255},
                      textString="%Angle%"),Text(
                      extent={{-40,-52},{40,-92}},
                      lineColor={0,128,0},
                      textString="PST"),
                    Text(
                      extent={{-100,100},{100,40}},
                      lineColor={0,0,255},
                      textString="%name")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"><tr>
<td><p>Reference</p></td>
<td><p>PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td><p>15/07/2015</p></td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end PSTransformer;

            model pst1
              constant Real pi=Modelica.Constants.pi;
              parameter Real SystemBase=100;
              parameter Real Vbus1=20000 "Sending end Bus nominal voltage, change of base";
              parameter Real Vbus2=20000 "Receiving end Bus voltage, change of base";
              parameter Real Sn=100 "Power rating MVA";
              parameter Real Vn1=20000 "Primary Voltage rating,KV";
              parameter Real Vn2=20000 "Secondary voltage rating, KV";
              parameter Real fn=50 "Frequency rating Hz";
              parameter Real Tm=0.001 "Measurement time constant, s";
              parameter Real Kp=0.05 "Proportional gain";
              parameter Real Ki=0.01 "Integral gain";
              parameter Real p_ref=0.01 "Reference Power, p.u.";
              parameter Real alpha_max=pi/2 "Maximum phase angle, rad";
              parameter Real alpha_min=-pi/2 "Minimum phase angle, rad";
              parameter Real xT=0.1 "Transformer Reactance, p.u.";
              parameter Real rT=0.01 "Transformer Resistance, p.u.";
              parameter Real m=0.98 "Transformer fixed tap  ratio, p.u./p.u.";
              parameter Real alpha0=0.002062339234360;
              parameter Real pmes0=0.01;
              parameter Real vk0=0.997649085060455;
              parameter Real anglevk0=-0.007392164704867;
              Real vk(start=vk0) "Voltage at primary, p.u.";
              Real vm;
              Real anglevk(start=anglevk0);
              Real anglevm;
              OpenIPSL.Interfaces.PwPin p annotation (Placement(visible=true,
                    transformation(extent={{-120,-10},{-100,10}})));
              OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                      extent={{100,-10},{120,10}})));
            protected
              parameter Real Vb2new=Vbus1*Vbus1;
              parameter Real Vb2old=Vn1*Vn1;
              parameter Real R=rT*(Vb2old*SystemBase)/(Vb2new*Sn)
                "Transformer Resistance, p.u.";
              parameter Real X=xT*(Vb2old*SystemBase)/(Vb2new*Sn)
                "Transformer Reactance, p.u.";
              parameter Real pref=p_ref*(Sn/SystemBase);
              parameter Real gt=R/(R^2 + X^2) "Converting resistance to conductance p.u.";
              parameter Real bt=-X/(R^2 + X^2) "Converting reactance to susceptance p.u.";
            equation
              vk = sqrt(p.vr^2 + p.vi^2);
              vm = sqrt(n.vr^2 + n.vi^2);
              anglevk = atan2(p.vi, p.vr);
              anglevm = atan2(n.vi, n.vr);
              R*p.ir - X*p.ii = 1/m^2*p.vr - 1/m*n.vr;
              R*p.ii + X*p.ir = 1/m^2*p.vi - 1/m*n.vi;
              R*n.ir - X*n.ii = n.vr - 1/m*p.vr;
              X*n.ir + R*n.ii = n.vi - 1/m*p.vi;
            end pst1;

            model pst2
              constant Real pi=Modelica.Constants.pi;
              parameter Real SystemBase=100;
              parameter Real Vbus1=20000 "Sending end Bus nominal voltage, change of base";
              parameter Real Vbus2=20000 "Receiving end Bus voltage, change of base";
              parameter Real Sn=100 "Power rating MVA";
              parameter Real Vn1=20000 "Primary Voltage rating,KV";
              parameter Real Vn2=20000 "Secondary voltage rating, KV";
              parameter Real fn=50 "Frequency rating Hz";
              parameter Real Tm=0.001 "Measurement time constant, s";
              parameter Real Kp=0.05 "Proportional gain";
              parameter Real Ki=0.01 "Integral gain";
              parameter Real p_ref=0.01 "Reference Power, p.u.";
              parameter Real alpha_max=pi/2 "Maximum phase angle, rad";
              parameter Real alpha_min=-pi/2 "Minimum phase angle, rad";
              parameter Real xT=0.1 "Transformer Reactance, p.u.";
              parameter Real rT=0.01 "Transformer Resistance, p.u.";
              parameter Real m=0.98 "Transformer fixed tap  ratio, p.u./p.u.";
              parameter Real alpha0=0.002062339234360;
              parameter Real pmes0=0.01;
              parameter Real vm0=1.007257703014177;
              parameter Real anglevm0=-0.009372077496959;
              Real vk "Voltage at primary, p.u.";
              Real vm(start=vm0) "Voltage at secondary p.u.";
              Real anglevk "Angle at primary";
              Real anglevm;
              Real alpha;
              Real pmes;
              OpenIPSL.Interfaces.PwPin p annotation (Placement(visible=true,
                    transformation(extent={{-120,-10},{-100,10}})));
              OpenIPSL.Interfaces.PwPin n annotation (Placement(transformation(
                      extent={{100,-10},{120,10}})));
              Modelica.Blocks.Interfaces.RealInput pk
                annotation (Placement(transformation(extent={{-140,-60},{-100,-20}})));
            protected
              parameter Real Vb2new=Vbus1*Vbus1;
              parameter Real Vb2old=Vn1*Vn1;
              parameter Real R=rT*(Vb2old*SystemBase)/(Vb2new*Sn)
                "Transformer Resistance, p.u.";
              parameter Real X=xT*(Vb2old*SystemBase)/(Vb2new*Sn)
                "Transformer Reactance, p.u.";
              parameter Real pref=p_ref*(Sn/SystemBase);
              parameter Real gt=R/(R^2 + X^2) "Converting resistance to conductance p.u.";
              parameter Real bt=-X/(R^2 + X^2) "Converting reactance to susceptance p.u.";
            initial equation
              alpha = alpha0;
              pmes = pmes0;
            equation
              vk = sqrt(p.vr^2 + p.vi^2);
              vm = sqrt(n.vr^2 + n.vi^2);
              anglevk = atan2(p.vi, p.vr);
              anglevm = atan2(n.vi, n.vr);
              if alpha > alpha_max and der(alpha) > 0 and der(pmes) > 0 then
                der(alpha) = 0;
                der(pmes) = (pk - pmes)/Tm;
                p.vr = n.vr*cos(alpha_max) - n.vi*sin(alpha_max);
                p.vi = n.vr*sin(alpha_max) + n.vi*cos(alpha_max);
                // pk=p.vr*p.ir + p.vi*p.ii;
                p.ir + n.ir = 0;
                p.ii + n.ii = 0;
              elseif alpha < alpha_min and der(alpha) < 0 and der(pmes) < 0 then
                der(alpha) = 0;
                der(pmes) = (pk - pmes)/Tm;
                p.vr = n.vr*cos(alpha_min) - n.vi*sin(alpha_min);
                p.vi = n.vr*sin(alpha_min) + n.vi*cos(alpha_min);
                // pk=p.vr*p.ir + p.vi*p.ii;
                p.ir + n.ir = 0;
                p.ii + n.ii = 0;
              else
                der(alpha) = Kp*(pk - pmes)/Tm + Ki*(pmes - pref);
                der(pmes) = (pk - pmes)/Tm;
                p.vr = n.vr*cos(alpha) - n.vi*sin(alpha);
                p.vi = n.vr*sin(alpha) + n.vi*cos(alpha);
                // pk=p.vr*p.ir + p.vi*p.ii;
                p.ir + n.ir = 0;
                p.ii + n.ii = 0;
              end if;
            end pst2;
          annotation (Documentation);
          end PhaseShiftingTransformer;
        annotation (Documentation);
        end PSAT;
      annotation (Documentation);
      end Branches;

      package Machines
        package PSAT
          model Order2 "Second Order Synchronous Machine with Inputs and Outputs"
            extends BaseClasses.baseMachine(vf(start=vf00), xq0=x1d);
          protected
            parameter Real K=1/(ra^2 + x1d^2) "a constant for scaling";
            parameter Real c1=ra*K "scaled ra";
            parameter Real c2=x1d*K "scaled x'd";
            parameter Real c3=x1d*K "scaled x'd";
            parameter Real vf00=V_MBtoSB*(vq0 + ra*iq0 + x1d*id0) "Init. val. (pu, SB)";
          equation
            id = -c1*vd - c3*vq + vf_MB*c3;
            iq = c2*vd - c1*vq + vf_MB*c1;
            vf0 = vf00;
            annotation (Documentation(info="<html> 
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\"> 
<tr> 
<td><p>Reference</p></td> 
<td><p>Order II Synchonous Machine, PSAT Manual 2.1.8</p></td> 
</tr> 
<tr> 
<td><p>Last update</p></td> 
<td>September 2015</td> 
</tr> 
<tr> 
<td><p>Author</p></td> 
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td> 
</tr> 
<tr> 
<td><p>Contact</p></td> 
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td> 
</tr> 
</table> 
</html>"),           Icon(coordinateSystem(extent={{-100,-100},{100,100}}, initialScale=
                      0.1), graphics={Text(
                    origin={0,60},
                    extent={{-60,-20},{60,20}},
                    lineColor={28,108,200},
                    textString="Order II")}));
          end Order2;

          model Order3 "Third Order Synchronous Machine with Inputs and Outputs"
            extends BaseClasses.baseMachine(vf(start=vf00), xq0=xq);
            parameter Real xd "d-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1d0 "d-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real xq "q-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            Real e1q(start=e1q0) "q-axis transient voltage (pu)";

          protected
            parameter Real K=1/(ra^2 + xq*x1d) "a constant for scaling";
            parameter Real c1=ra*K "scaled ra";
            parameter Real c2=x1d*K "scaled x'd";
            parameter Real c3=xq*K " scaled xq";
            parameter Real vf00=V_MBtoSB*(e1q0 + (xd - x1d)*id0) "Init. val. (pu, SB)";
            parameter Real e1q0=vq0 + ra*iq0 + x1d*id0 "Initialitation";
          initial equation
            der(e1q) = 0;
          equation
            der(e1q) = ((-e1q) - (xd - x1d)*id + vf_MB)/T1d0;
            id = (-c1*vd) - c3*vq + e1q*c3;
            iq = c2*vd - c1*vq + e1q*c1;
            vf0 = vf00;
            annotation (Icon(coordinateSystem(extent={{-100,-100},{100,100}},
                    initialScale=0.1), graphics={Text(
                    origin={0,60},
                    extent={{-60,-20},{60,20}},
                    lineColor={28,108,200},
                    textString="Order III")}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>Order III Synchonous Machine, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end Order3;

          model Order4 "Fourth Order Synchronous Machine with Inputs and Outputs"
            extends BaseClasses.baseMachine(vf(start=vf00), xq0=xq);
            parameter Real xd=1.9 "d-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real xq=1.7 "q-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x1q=0.5 "q-axis transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1d0=8 "d-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1q0=0.8 "q-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            Real e1q(start=e1q0) "q-axis transient voltage (pu)";
            Real e1d(start=e1d0) "d-axis transient voltage (pu)";
          protected
            parameter Real vf00=V_MBtoSB*(e1q0 + (xd - x1d)*id0) "Init. val. (pu, SB)";
            parameter Real e1q0=vq0 + ra*iq0 + x1d*id0 "Initialization";
            parameter Real e1d0=vd0 + ra*id0 - x1q*iq0 "Initialization";
          initial equation
            der(e1q) = 0;

          equation
            der(e1q) = ((-e1q) - (xd - x1d)*id + vf_MB)/T1d0;
            if xq <> x1q then
              // safe-guard against division by zero.
              der(e1d) = ((-e1d) + (xq - x1q)*iq)/T1q0 "differential equations *";
            else
              der(e1d) = (-e1d)/T1q0 "differential equations *";
            end if;
            e1q = vq + ra*iq + x1d*id;
            e1d = vd + ra*id - x1q*iq "relation between voltages and currents *";
            vf0 = vf00;
            annotation (Icon(coordinateSystem(extent={{-100,-100},{100,100}},
                    initialScale=0.1), graphics={Text(
                    origin={0,60},
                    extent={{-60,-20},{60,20}},
                    lineColor={28,108,200},
                    textString="Order IV")}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Generator Order IV, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end Order4;

          model Order5_Type1
            extends BaseClasses.baseMachine(vf(start=vf00), xq0=xq);
            parameter Real xd=1.9 "d-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real xq=1.7 "q-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x1q=0.5 "q-axis transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1d0=8 "d-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1q0=0.8 "q-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T2q0=0.02
              "q-axis open circuit sub-transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            Real e1q(start=e1q0) "q-axis transient voltage";
            Real e1d(start=e1d0) "d-axis transient voltage";
            Real e2d(start=e2d0) "d-axis sub-transient voltage";
          protected
            parameter Real vf00=V_MBtoSB*(e1q0 + (xd - x1d)*id0) "Init. val. (pu, SB)";
            parameter Real e1q0=vq0 + ra*iq0 + x1d*id0 "Initialization";
            parameter Real e1d0=vd0 + ra*id0 - x1q*iq0 "Initialization*";
            parameter Real e2d0=vd0 + ra*id0 - x1q*iq0 "Initialization";
          initial equation
            der(delta) = 0;
            der(e1q) = 0;
            der(e1d) = 0;
            der(e2d) = 0;
          equation
            der(e1q) = ((-e1q) - (xd - x1d)*id + vf_MB)/T1d0;
            der(e1d) = ((-e1d) + (xq - x1q - T2q0/T1q0*x1d/x1q*(xq - x1q))*iq)/T1q0
              "differential equations/";
            der(e2d) = ((-e2d) + e1d + (x1q - x1d + T2q0/T1q0*x1d/x1q*(xq - x1q))*iq)/
              T2q0 "differential equations/";
            e1q = vq + ra*iq + x1d*id;
            e2d = vd + ra*id - x1q*iq "relation between voltages and currents/";
            vf0 = vf00;
            annotation (Icon(coordinateSystem(extent={{-100,-100},{100,100}},
                    initialScale=0.1), graphics={Text(
                    origin={0,60},
                    fillPattern=FillPattern.Solid,
                    extent={{-60,-20},{60,20}},
                    fontName="Arial",
                    lineColor={28,108,200},
                    textString="Order V - Type 1")}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Generator Order V Type 1, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end Order5_Type1;

          model Order5_Type2
            extends BaseClasses.baseMachine(vf(start=vf00), xq0=xq);
            parameter Real xd=1.9 "d-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real xq=1.7 "q-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x2d=0.204 "d-axis sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x2q=0.3 "q-axis sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1d0=8 "d-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T2d0=0.8 "d-axis open circuit sub-transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T2q0=0.02 "q-axis open circuit sub-transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Taa=0.002 "d-axis aditional leakage time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            Real e1q(start=e1q0) "q-axis transient voltage";
            Real e2q(start=e2q0) "q-axis sub-transient voltage";
            Real e2d(start=e2d0) "d-axis sub-transient voltage";
          protected
            parameter Real e2q0=vq0 + ra*iq0 + x2d*id0 "Initialitation";
            parameter Real e2d0=vd0 + ra*id0 - x2q*iq0 "Initialitation";
            parameter Real K1=xd - x1d - (T2d0*x2d*(xd - x1d))/(T1d0*x1d);
            parameter Real K2=x1d - x2d + (T2d0*x2d*(xd - x1d))/(T1d0*x1d);
            parameter Real e1q0=(-K1*Taa/T1d0*id0) + (1 - Taa/T1d0)*(e2q0 + K2*id0);
            parameter Real vf00=V_MBtoSB*(K1*id0 + e1q0)/(1 - Taa/T1d0)
              "Init. val. (pu, SB)";
          initial equation
            //der(e1q) = 0;
            der(e2q) = 0;
            der(e2d) = 0;
          equation
            der(e1q) = ((-e1q) - (xd - x1d - T2d0/T1d0*x2d/x1d*(xd - x1d))*id + (1 - Taa/
              T1d0)*vf_MB)/T1d0;
            der(e2d) = ((-e2d) + (xq - x2q)*iq)/T2q0;
            der(e2q) = ((-e2q) + e1q - (x1d - x2d + T2d0/T1d0*x2d/x1d*(xd - x1d))*id +
              Taa/T1d0*vf_MB)/T2d0 "differential equations";
            e2q = vq + ra*iq + x2d*id;
            e2d = vd + ra*id - x2q*iq "relation between voltages and currents";
            vf0 = vf00;
            annotation (Icon(coordinateSystem(extent={{-100,-100},{100,100}},
                    initialScale=0.1), graphics={Rectangle(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-100.0,-100.0},{100.0,100.0}}),Text(
                    origin={0,60},
                    extent={{-60,-20},{60,20}},
                    lineColor={28,108,200},
                    textString="Order V - Type 2")}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Generator Order V Type 2, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end Order5_Type2;

          model Order6
            extends BaseClasses.baseMachine(vf(start=vf00), xq0=xq);
            parameter Real xd=1.9 "d-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real xq=1.7 "q-axis synchronous reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x1q=0.5 "q-axis transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x2d=0.204 "d-axis sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real x2q=0.3 "q-axis sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1d0=8 "d-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T1q0=0.8 "q-axis open circuit transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T2d0=0.04 "d-axis open circuit sub-transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real T2q0=0.02 "q-axis open circuit sub-transient time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Taa=2e-3 "d-axis aditional leakage time constant (s)"
              annotation (Dialog(group="Machine parameters"));

            Real e1q(start=e1q0, fixed=true) "q-axis transient voltage";
            Real e1d(start=e1d0) "d-axis transient voltage";
            Real e2q(start=e2q0, fixed=true) "q-axis sub-transient voltage";
            Real e2d(start=e2d0) "d-axis sub-transient voltage";
          protected
            parameter Real e2q0=vq0 + ra*iq0 + x2d*id0 "Initialitation";
            parameter Real e2d0=vd0 + ra*id0 - x2q*iq0 "Initialitation";
            parameter Real e1d0=(xq - x1q - T2q0*x2q*(xq - x1q)/(T1q0*x1q))*iq0;
            parameter Real K1=xd - x1d - T2d0*x2d*(xd - x1d)/(T1d0*x1d);
            parameter Real K2=x1d - x2d + T2d0*x2d*(xd - x1d)/(T1d0*x1d);
            parameter Real e1q0=e2q0 + K2*id0 - Taa/T1d0*((K1 + K2)*id0 + e2q0);
            parameter Real vf00=V_MBtoSB*(K1*id0 + e1q0)/(1 - Taa/T1d0)
              "Init. val. (pu, SB)";
          initial equation
            der(e1d) = 0;
            // der(e1d) = 0;
            der(e2d) = 0;
            // der(e2q) = 0;
          equation

            der(e1q) = ((-e1q) - (xd - x1d - T2d0/T1d0*x2d/x1d*(xd - x1d))*id + (1 - Taa/
              T1d0)*vf_MB)/T1d0;
            der(e1d) = ((-e1d) + (xq - x1q - T2q0/T1q0*x2q/x1q*(xq - x1q))*iq)/T1q0;
            der(e2d) = ((-e2d) + e1d + (x1q - x2q + T2q0/T1q0*x2q/x1q*(xq - x1q))*iq)/
              T2q0;
            der(e2q) = ((-e2q) + e1q - (x1d - x2d + T2d0/T1d0*x2d/x1d*(xd - x1d))*id +
              Taa/T1d0*vf_MB)/T2d0;
            e2q = vq + ra*iq + x2d*id;
            e2d = vd + ra*id - x2q*iq;
            vf0 = vf00;
            annotation (Icon(coordinateSystem(extent={{-100,-100},{100,100}},
                    initialScale=0.1), graphics={Rectangle(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-100.0,-100.0},{100.0,100.0}}),Text(
                    origin={0,60},
                    extent={{-60,-20},{60,20}},
                    lineColor={28,108,200},
                    textString="Order VI")}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Generator Order VI, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end Order6;

          model MotorTypeI "Induction Machine - Order I"
            extends OpenIPSL.Electrical.Essentials.pfComponent;
            parameter Integer Sup=1 "Start-up control" annotation (Dialog(group=
                    "Machine parameters"), choices(choice=0, choice=1));
            parameter Real Rs=0.01 "Stator resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xs=0.15 "Stator reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Rr1=0.05 "1st cage rotor resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xr1=0.15 "1st cage rotor reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xm=5 "Magnetizing reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Hm=3 "Inertia constant (kWs/KVA)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real a=0.5 "1st coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real b=0.00 "2nd coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real c=0.00 "3rd coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real tup=0 "Start up time (s)"
              annotation (Dialog(group="Machine parameters"));
            Real v(start=V_0) "Bus voltage magnitude";
            Real anglev(start=angle_0) " Bus voltage angle";
            Real s(start=Rr1*P_0*(Q_0 + V_0*V_0/Xm)/(V_0*V_0*V_0*V_0*(Xs + Xr1)));
            Real Tm;
            Real P(start=P_0);
            Real Q(start=Q_0);
            Real Re;
            OpenIPSL.Interfaces.PwPin p(
              vr(start=vr0),
              vi(start=vi0),
              ir(start=ir0),
              ii(start=ii0)) annotation (Placement(transformation(extent={{90,-10},
                      {110,10}})));
          protected
            constant Real pi=Modelica.Constants.pi;
            parameter Real vr0=V_0*cos(angle_0);
            parameter Real vi0=V_0*sin(angle_0);
            parameter Real ir0=(P_0*vr0 + Q_0*vi0)/(vr0^2 + vi0^2);
            parameter Real ii0=(P_0*vi0 - Q_0*vr0)/(vr0^2 + vi0^2);
            parameter Real A=a + b + c;
            parameter Real B=(-b) - 2*c;
            parameter Real C=c;
            parameter Real Xe=Xs + Xr1;
          initial equation
            der(s) = 0;
          equation
            P = p.vr*p.ir + p.vi*p.ii;
            Q = (-p.vr*p.ii) + p.vi*p.ir;
            anglev = atan2(p.vi, p.vr);
            v = sqrt(p.vr^2 + p.vi^2);
            Tm = A + B*s + C*s*s;
            Re = Rs + Rr1/s;
            //s=Rr1/(Re-Rs);
            der(s) = (Tm - P)/(2*Hm);
            p.ii = (-p.vr/Xm) + (p.vi*Re - p.vr*Xe)/(Re*Re + Xe*Xe);
            p.ir = p.vi/Xm + (p.vr*Re + p.vi*Xe)/(Re*Re + Xe*Xe);
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={Rectangle(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-100,-100},{100,100}}),Ellipse(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-56,-58},{55.9318,54}}),Text(
                    extent={{-50,48},{50,-52}},
                    lineColor={0,0,0},
                    textString="M"),Text(
                    origin={0,-76.0978},
                    fillPattern=FillPattern.Solid,
                    extent={{-57.2101,-15.0},{57.2101,15.0}},
                    fontName="Arial",
                    textString="%name",
                    lineColor={0,0,0})}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>Induction Machine, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>

<html>
<pre><span style=\"font-family: Courier New,courier; color: #006400;\">&nbsp;with&nbsp;the&nbsp;problem&nbsp;of&nbsp;a&nbsp;constant&nbsp;offset&nbsp;mismatch&nbsp;-0.00012</span></pre>
</html>"));
          end MotorTypeI;

          model MotorTypeIII "Induction Machine - Order III"
            extends OpenIPSL.Electrical.Essentials.pfComponent;
            parameter Integer Sup=1 "Start up control" annotation (Dialog(group=
                    "Machine parameters"), choices(choice=0, choice=1));
            parameter Real Rs=0.01 "Stator resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xs=0.15 "Stator reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Rr1=0.05 "1st cage rotor resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xr1=0.15 "1st cage rotor reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xm=5 "Magnetizing reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Hm=3 "Inertia constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real a=0.25 "1st coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real b=0.00 "2nd coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real c=0.00 "3rd coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real tup=0 "Start up time (s)"
              annotation (Dialog(group="Machine parameters"));
            Real v(start=V_0) "Bus voltage magnitude";
            Real anglev(start=angle_0) " Bus voltage angle";
            Real s(start=S0);
            Real Tm;
            Real Te;
            Real P(start=P_0);
            Real Q(start=Q_0);
            Real Vr;
            Real Vm;
            Real Ir;
            Real Im;
            Real epr(start=epr0);
            Real epm(start=epm0);
            Real I;
            Real anglei;
            OpenIPSL.Interfaces.PwPin p(
              vr(start=vr0),
              vi(start=vi0),
              ir(start=ir0),
              ii(start=ii0)) annotation (Placement(transformation(extent={{90,-10},
                      {110,10}})));
          protected
            constant Real pi=Modelica.Constants.pi;
            parameter Real Omegab=2*pi*fn "Base freq in rad/s";
            parameter Real vr0=V_0*cos(angle_0);
            parameter Real vi0=V_0*sin(angle_0);
            parameter Real ir0=(P_0*vr0 + Q_0*vi0)/(vr0^2 + vi0^2);
            parameter Real ii0=(P_0*vi0 - Q_0*vr0)/(vr0^2 + vi0^2);
            parameter Real i2=ir0*ir0 + ii0*ii0;
            parameter Real A=a + b + c;
            parameter Real B=(-b) - 2*c;
            parameter Real C=c;
            parameter Real X0=Xs + Xm;
            parameter Real Xp=Xs + Xr1*Xm/(Xr1 + Xm);
            parameter Real Tp0=(Xr1 + Xm)/(Omegab*Rr1);
            parameter Real RZs2=1/(Rs*Rs + Xp*Xp);
            parameter Real K=Rr1/((Xr1 + Xm)*A);
            parameter Real K2=1 + Tp0*Tp0*Omegab*Omegab*S0*S0;
            parameter Real K1=Tp0*Omegab*S0;
            parameter Real a03=Rs*Rs + Xp*Xp;
            //r1^2+(xS +xR1xm/(xR1 + xm))^2
            parameter Real a13=Rs/a03;
            parameter Real a23=Xp/a03;
            parameter Real S0=K*((-Q_0) + X0*i2);
            parameter Real epm0=(K1*(X0 - Xp)*ir0 + (X0 - Xp)*(-1)*ii0)/K2;
            parameter Real epr0=(K1*(X0 - Xp)*(-1)*ii0 - (X0 - Xp)*ir0)/K2;
          initial equation
            der(s) = 0;
            der(epr) = 0;
            der(epm) = 0;
          equation
            anglev = atan2(p.vi, p.vr);
            anglei = atan2(p.ii, p.ir);
            v = sqrt(p.vr^2 + p.vi^2);
            I = sqrt(p.ii^2 + p.ir^2);
            Vr = p.vi;
            Vm = p.vr;
            Im = p.ir;
            Ir = -p.ii;
            P = p.vr*p.ir + p.vi*p.ii;
            Q = (-p.vr*p.ii) + p.vi*p.ir;
            der(s) = (Tm - Te)/(2*Hm);
            Tm = A + B*s + C*s*s;
            Te = epr*Ir + epm*Im;
            der(epr) = Omegab*s*epm - (epr + (X0 - Xp)*Im)/Tp0;
            der(epm) = (-Omegab*s*epr) - (epm - (X0 - Xp)*Ir)/Tp0;
            Im = (-a23*((-Vr) - epr)) + a13*(Vm - epm);
            Ir = a13*((-Vr) - epr) + a23*(Vm - epm);
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={Rectangle(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-100,-100},{100,100}}),Ellipse(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-56,-58},{55.9318,54}}),Text(
                    extent={{-50,48},{50,-52}},
                    lineColor={0,0,0},
                    textString="M"),Text(
                    origin={0,-76.0978},
                    fillPattern=FillPattern.Solid,
                    extent={{-57.2101,-15.0},{57.2101,15.0}},
                    fontName="Arial",
                    textString="%name",
                    lineColor={0,0,0})}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>Induction Machine, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end MotorTypeIII;

          model MotorTypeV "Induction Machine - Order V"
            extends OpenIPSL.Electrical.Essentials.pfComponent;
            parameter Integer Sup=1 "Start up control" annotation (Dialog(group=
                    "Machine parameters"), choices(choice=0, choice=1));
            parameter Real Rs=0.01 "Stator resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xs=0.15 "Stator reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Rr1=0.05 "1st cage rotor resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xr1=0.15 "1st cage rotor reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Rr2=0.001 "2nd cage rotor resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xr2=0.04 "2nd cage rotor reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xm=5 "Magnetizing reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Hm=3 "Inertia constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real a=0.13 "1st coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real b=0.02 "2nd coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real c=0.024 "3rd coefficient of tau_m(w) (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real tup=0 "Start up time"
              annotation (Dialog(group="Machine parameters"));
            Real v(start=V_0) "Bus voltage magnitude";
            Real anglev(start=angle_0) " Bus voltage angle";
            Real s(start=S0);
            //(start=Rr1*P_0*(Q_0+V_0*V_0/Xm)/(V_0*V_0*V_0*V_0*(Xs + Xr1)));
            Real Tm;
            Real Te;
            Real P(start=P_0);
            Real Q(start=Q_0);
            Real e1r(start=epr0);
            Real e1m(start=epm0);
            Real e2r(start=0.0353);
            Real e2m(start=0.9995);
            Real Vr;
            Real Vm;
            Real Ir;
            Real Im;
            OpenIPSL.Interfaces.PwPin p(
              vr(start=vr0),
              vi(start=vi0),
              ir(start=ir0),
              ii(start=ii0)) annotation (Placement(transformation(extent={{90,-10},
                      {110,10}})));
          protected
            constant Real pi=Modelica.Constants.pi;
            parameter Real Omegab=2*pi*fn "Base freq in rad/s";
            parameter Real vr0=V_0*cos(angle_0);
            parameter Real vi0=V_0*sin(angle_0);
            parameter Real ir0=(P_0*vr0 + Q_0*vi0)/(vr0^2 + vi0^2);
            parameter Real ii0=(P_0*vi0 - Q_0*vr0)/(vr0^2 + vi0^2);
            parameter Real A=a + b + c;
            parameter Real B=(-b) - 2*c;
            parameter Real C=c;
            parameter Real X0=Xs + Xm;
            parameter Real X1=Xs + Xr1*Xm/(Xr1 + Xm);
            parameter Real T10=(Xr1 + Xm)/(Omegab*Rr1);
            parameter Real X2=Xs + Xr1*Xm*Xr2/(Xr1*Xr2 + Xr1*Xm + Xr2*Xm);
            parameter Real T20=(Xr2 + Xr1*Xm/(Xr1 + Xm))/(Omegab*Rr2);
            parameter Real a05=Rs^2 + X2^2;
            parameter Real a15=Rs/a05;
            parameter Real a25=X2/a05;
            parameter Real a35=X0 - X1;
            parameter Real a45=X1 - X2;
            parameter Real i2=ir0*ir0 + ii0*ii0;
            parameter Real K=Rr1/((Xr1 + Xm)*A);
            parameter Real K2=1 + T10*T10*Omegab*Omegab*S0*S0;
            parameter Real K1=T10*Omegab*S0;
            parameter Real S0=K*((-Q_0) + X0*i2);
            parameter Real epm0=(K1*(X0 - X1)*ir0 + (X0 - X1)*(-1)*ii0)/K2;
            parameter Real epr0=(K1*(X0 - X1)*(-1)*ii0 - (X0 - X1)*ir0)/K2;
          initial equation
            der(e2r) = 0;
            der(e2m) = 0;
            der(s) = 0;
            der(e1r) = 0;
            der(e1m) = 0;
          equation
            anglev = atan2(p.vi, p.vr);
            v = sqrt(p.vr^2 + p.vi^2);
            Vr = p.vi;
            Vm = p.vr;
            Im = p.ir;
            Ir = -p.ii;
            P = p.vr*p.ir + p.vi*p.ii;
            Q = (-p.vr*p.ii) + p.vi*p.ir;
            Ir = a15*((-Vr) - e2r) + a25*(Vm - e2m);
            Im = (-a25*((-Vr) - e2r)) + a15*(Vm - e2m);
            der(s) = (Tm - Te)/(2*Hm);
            Te = e2r*Ir + e2m*Im;
            der(e1r) = Omegab*s*e1m - (e1r + a35*Im)/T10;
            der(e1m) = (-Omegab*s*e1r) - (e1m - a35*Ir)/T10;
            der(e2r) = (-Omegab*s*(e1m - e2m)) + der(e1r) + (e1r - e2r - a45*Im)/T20;
            der(e2m) = Omegab*s*(e1r - e2r) + der(e1m) + (e1m - e2m + a45*Ir)/T20;
            Tm = A + B*s + C*s*s;
            annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                      {100,100}}), graphics={Rectangle(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-100,-100},{100,100}}),Ellipse(
                    visible=true,
                    fillColor={255,255,255},
                    extent={{-56,-58},{55.9318,54}}),Text(
                    extent={{-50,48},{50,-52}},
                    lineColor={0,0,0},
                    textString="M"),Text(
                    origin={0,-76.0978},
                    fillPattern=FillPattern.Solid,
                    extent={{-57.2101,-15.0},{57.2101,15.0}},
                    fontName="Arial",
                    textString="%name",
                    lineColor={0,0,0})}), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>Induction Machine, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end MotorTypeV;

          package BaseClasses
            partial model baseMachine
              extends OpenIPSL.Electrical.Essentials.pfComponent;
              import Modelica.Constants.pi;
              import SI = Modelica.SIunits;
              import CM = Modelica.ComplexMath;
              import Complex;
              parameter OpenIPSL.Types.ApparentPowerMega Sn
                "Power rating (MVA)"
                annotation (Dialog(group="Machine parameters"));
              parameter OpenIPSL.Types.VoltageKilo Vn "Voltage rating (kV)"
                annotation (Dialog(group="Machine parameters"));
              parameter SI.PerUnit ra "Armature resistance (pu)"
                annotation (Dialog(group="Machine parameters"));
              parameter SI.PerUnit x1d "d-axis transient reactance (pu)"
                annotation (Dialog(group="Machine parameters"));
              parameter Real M "Mechanical starting time (2H), kWs/kVA"
                annotation (Dialog(group="Machine parameters"));
              parameter Real D "Damping coefficient"
                annotation (Dialog(group="Machine parameters"));

              OpenIPSL.Interfaces.PwPin p(
                vr(start=vr0),
                vi(start=vi0),
                ir(start=ir0),
                ii(start=ii0)) annotation (Placement(visible=true,
                    transformation(
                    origin={100,0},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput delta(
                start=delta0,
                quantity="Angle",
                unit="rad",
                displayUnit="rad") "Rotor angle (rad)" annotation (Placement(visible=true,
                    transformation(
                    origin={110,60},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput w(start=1) "Rotor speed (pu)"
                annotation (Placement(visible=true, transformation(
                    origin={110,90},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput v(start=V_0)
                "Generator terminal voltage (pu)" annotation (Placement(visible=true,
                    transformation(
                    origin={110,30},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput P(start=p0) "Active power (pu)"
                annotation (Placement(visible=true, transformation(
                    origin={110,-30},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput Q(start=q0) "Reactive power (pu)"
                annotation (Placement(visible=true, transformation(
                    origin={110,-70},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealInput vf "Field voltage (pu)" annotation (
                  Placement(visible=true, transformation(
                    origin={-120,50},
                    extent={{-20,-20},{20,20}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput vf0 "Initial field voltage (pu)"
                annotation (Placement(visible=true, transformation(
                    origin={-80,110},
                    extent={{-10,-10},{10,10}},
                    rotation=90)));
              Modelica.Blocks.Interfaces.RealOutput pm0(start=pm00)
                "Initial mechanical power (pu)" annotation (Placement(visible=true,
                    transformation(
                    origin={-80,-110},
                    extent={{-10,-10},{10,10}},
                    rotation=270)));
              Modelica.Blocks.Interfaces.RealInput pm(start=pm00) "Mechanical power (pu)"
                annotation (Placement(visible=true, transformation(
                    origin={-120,-50},
                    extent={{-20,-20},{20,20}},
                    rotation=0)));
              SI.Angle anglev(start=SI.Conversions.from_deg(angle_0))
                " Bus voltage angle (rad)";
              Real vd(start=vd0) "d-axis voltage (pu)";
              Real vq(start=vq0) "q-axis voltage (pu)";
              Real id(start=id0) "d-axis currrent (pu)";
              Real iq(start=iq0) "q-axis current (pu)";
            protected
              SI.PerUnit pe(start=pm00) "electrical power transmitted through the air-gap";
              SI.PerUnit vf_MB=vf*V_b/Vn "field voltage on machine base";
              parameter SI.AngularVelocity w_b=2*pi*fn "Base frequency in rad/s";
              // Define multiplicative transforms to go from one pu-base to another:
              parameter Real S_SBtoMB=S_b/Sn "S(system base) -> S(machine base)";
              parameter Real I_MBtoSB=(Sn*V_b)/(S_b*Vn) "I(machine base) -> I(system base)";
              parameter Real V_MBtoSB=Vn/V_b "V(machine base) -> V(system base)";
              parameter Real Z_MBtoSB=(S_b*Vn^2)/(Sn*V_b^2)
                "Z(machine base) -> Z(system base)";

              // Initialize stator quantities (system base):
              parameter SI.PerUnit p0=P_0/S_b
                "Initial active power generation in pu (system base)";
              parameter SI.PerUnit q0=Q_0/S_b
                "Initial reactive power generation in pu (system base)";
              parameter Complex Vt0=CM.fromPolar(V_0, SI.Conversions.from_deg(angle_0))
                "Init. val., conjugate";
              parameter Complex S0(re=p0, im=-q0) "Init. val., conjugate";
              parameter Complex I0=S0/(CM.conj(Vt0)) "Init. val., conjugate";
              parameter SI.PerUnit vr0=CM.real(Vt0) "Init. val.";
              parameter SI.PerUnit vi0=CM.imag(Vt0) "Init. val.";
              parameter SI.PerUnit ir0=-CM.real(I0) "Init. val.";
              parameter SI.PerUnit ii0=-CM.imag(I0) "Init. val.";

              // Initialize DQ-quantities (pu, machine base)
              parameter SI.PerUnit xq0 "used for setting the initial rotor angle";
              parameter SI.Angle delta0=CM.arg((Vt0 + ((ra + CM.j*xq0)*Z_MBtoSB*I0)))
                "Init. val. rotor angle";
              parameter Complex Vdq0=Vt0*CM.fromPolar(1/V_MBtoSB, (-delta0 + (pi/2)))
                "Init. val (pu, machine base)";
              parameter Complex Idq0=I0*CM.fromPolar(1/I_MBtoSB, (-delta0 + (pi/2)))
                "(pu, machine base)";
              parameter SI.PerUnit vd0=CM.real(Vdq0) "Init. val.";
              parameter SI.PerUnit vq0=CM.imag(Vdq0) "Init. val.";
              parameter SI.PerUnit id0=CM.real(Idq0) "Init. val.";
              parameter SI.PerUnit iq0=CM.imag(Idq0) "Init. val.";

              parameter SI.PerUnit pm00=((vq0 + ra*iq0)*iq0 + (vd0 + ra*id0)*id0)/S_SBtoMB
                "Init. val. (pu, system base)";
            initial equation
              w = 1;
              delta = delta0;
            equation
              v = sqrt(p.vr^2 + p.vi^2);
              anglev = atan2(p.vi, p.vr);
              der(delta) = w_b*(w - 1);
              if D > Modelica.Constants.eps then
                der(w) = (pm*S_SBtoMB - pe - D*(w - 1))/M;
              else
                der(w) = (pm*S_SBtoMB - pe)/M;
              end if;
              [p.ir; p.ii] = -[sin(delta), cos(delta); -cos(delta), sin(delta)]*[id; iq]*
                I_MBtoSB;
              [p.vr; p.vi] = [sin(delta), cos(delta); -cos(delta), sin(delta)]*[vd; vq]*
                V_MBtoSB;
              P = -p.vr*p.ir - p.vi*p.ii;
              Q = -p.vi*p.ir + p.vr*p.ii;
              pe = (vq + ra*iq)*iq + (vd + ra*id)*id "pu, machine base";
              pm0 = pm00 "pu, system base";
              annotation (
                Icon(coordinateSystem(extent={{-100,-100},{100,100}}, initialScale=0.1),
                    graphics={Rectangle(
                      fillColor={255,255,255},
                      extent={{-100,-100},{100,100}},
                      lineColor={28,108,200},
                      fillPattern=FillPattern.Solid),Text(
                      origin={-80,50},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="vf"),Text(
                      origin={-80,-50},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="pm"),Text(
                      origin={-80,90},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="vf0"),Text(
                      origin={-80,-90},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="pm0"),Text(
                      origin={85,60},
                      extent={{-15,-10},{15,10}},
                      lineColor={28,108,200},
                      textString="delta"),Text(
                      origin={90,90},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="w"),Text(
                      origin={90,30},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="v"),Ellipse(extent={{-40,40},{40,-40}}, lineColor={28,108,
                      200}),Line(
                      points={{-20,0},{-9,15},{9,-15},{20,0}},
                      color={28,108,200},
                      smooth=Smooth.Bezier),Text(
                      origin={0,-60},
                      extent={{-60,-20},{60,20}},
                      lineColor={28,108,200},
                      textString="%name"),Text(
                      origin={90,-31},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="P"),Text(
                      origin={90,-70},
                      extent={{-10,-10},{10,10}},
                      lineColor={28,108,200},
                      textString="Q")}),
                Documentation,
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})));
            end baseMachine;
          annotation (Documentation);
          end BaseClasses;
        annotation (Documentation);
        end PSAT;

        package PSSE
          model Plant
            extends Interfaces.Generator;

            replaceable
              OpenIPSL.Electrical.Machines.PSSE.BaseClasses.baseMachine machine
              annotation (choicesAllMatching=true, Placement(transformation(
                    extent={{40,-10},{60,10}})));
            replaceable Controls.PSSE.ES.BaseClasses.BaseExciter exciter
              annotation (choicesAllMatching=true,
                Placement(transformation(extent={{-28,-24},{10,10}})));
            Modelica.Blocks.Sources.Constant const(k=0)
              annotation (Placement(transformation(extent={{-40,-54},{-32,-46}})));
            Modelica.Blocks.Sources.Constant const1(k=0)
              annotation (Placement(transformation(extent={{-40,-72},{-32,-64}})));
            replaceable Controls.PSSE.TG.BaseClasses.BaseGovernor governor
              annotation (choicesAllMatching=true,
              Placement(transformation(extent={{-30,40},{-10,60}})));
            replaceable
              OpenIPSL.Electrical.Controls.PSSE.PSS.BaseClasses.BasePSS pss
              annotation (Placement(visible=true, transformation(extent={{-88,-6},
                      {-48,12}}, rotation=0)));
          equation
            connect(pss.V_S2, governor.PMECH0) annotation (
              Line(points={{-87.3684,-1.5},{-94,-1.5},{-94,30},{-40,30},{-40,45.4545},{-29.1667,45.4545}},
                                                                                                    color = {0, 0, 127}));
            connect(pss.V_S1, machine.SPEED) annotation (
              Line(points={{-87.3684,7.5},{-98,7.5},{-98,68},{80,68},{80,7},{61,7}},           color = {0, 0, 127}));
            connect(pss.VOTHSG, exciter.VOTHSG) annotation (
              Line(points={{-47.3684,3},{-40,3},{-40,3.38889},{-28,3.38889}},     color = {0, 0, 127}));
            connect(exciter.EFD, machine.EFD) annotation (Line(points={{10.95,-5.11111},{38,-5.11111},{38,-5}},
                                                color={0,0,127}));
            connect(machine.p, pwPin)
              annotation (Line(points={{60,0},{110,0}},         color={0,0,255}));
            connect(exciter.XADIFD, machine.XADIFD) annotation (Line(points={{-0.45,-23.6222},{-0.45,-30},{64,-30},{64,-9},{60.8,-9}},
                                                             color={0,0,127}));
            connect(machine.EFD0, exciter.EFD0) annotation (Line(points={{61,-5},{66,-5},{66,-34},{-32,-34},{-32,-17.3889},{-28,-17.3889}},
                                                                           color={0,0,127}));
            connect(exciter.ECOMP, machine.ETERM) annotation (Line(points={{-28,-5.11111},{-32,-5.11111},{-32,20},{68,20},{68,-3},{61,-3}},
                                                                      color={0,0,127}));
            connect(const.y, exciter.VUEL) annotation (Line(points={{-31.6,-50},{-21.35,
                    -50},{-21.35,-24}}, color={0,0,127}));
            connect(const1.y, exciter.VOEL) annotation (Line(points={{-31.6,-68},{-15.65,
                    -68},{-15.65,-24}}, color={0,0,127}));
            connect(governor.PMECH, machine.PMECH) annotation (Line(points={{-9.58333,50.9091},{28,50.9091},{28,5},{38,5}},
                                          color={0,0,127}));
            connect(governor.SPEED, machine.SPEED) annotation (Line(points={{-29.1667,55.4545},{-40,55.4545},{-40,68},{80,68},{80,7},{61,7}},
                                                               color={0,0,127}));
            connect(machine.PMECH0, governor.PMECH0) annotation (Line(points={{61,5},{74,5},{74,30},{-40,30},{-40,45.4545},{-29.1667,45.4545}},
                                                                 color={0,0,127}));

          end Plant;

          model GENSAL "SALIENT POLE GENERATOR MODEL (QUADRATIC SATURATION ON D-AXIS)"
            // Import of Dependencies
            import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
            import Modelica.Constants.pi;
            import Complex;
            import Modelica.ComplexMath.arg;
            import Modelica.ComplexMath.real;
            import Modelica.ComplexMath.imag;
            import Modelica.ComplexMath.'abs';
            import Modelica.ComplexMath.conj;
            import Modelica.ComplexMath.fromPolar;
            import Modelica.ComplexMath.j;
            //Extending machine base class
            extends BaseClasses.baseMachine(
              w(start=0),
              EFD(start=efd0),
              XADIFD(start=efd0),
              PMECH(start=pm0),
              ANGLE(start=delta0),
              delta(start=delta0),
              id(start=id0),
              iq(start=iq0),
              ud(start=ud0),
              uq(start=uq0),
              Te(start=pm0));
            Real Epq(start=Epq0) "q-axis voltage behind transient reactance (pu)";
            Real PSIkd(start=PSIkd0) "d-axis rotor flux linkage (pu)";
            Real PSIppq(start=PSIppq0) "q-axis subtransient flux linkage (pu)";
            Real PSIppd(start=PSIppd0) "d-axis subtransient flux linkage (pu)";
            Real PSId(start=PSId0) "d-axis flux linkage (pu)";
            Real PSIq(start=PSIq0) "q-axis flux linkage (pu)";
            Real XadIfd(start=efd0) "Machine field current (pu)";
          protected
            parameter Complex Zs=R_a + j*Xppd "Equivalent impedance";
            parameter Complex Is=real(It + VT/Zs) + j*imag(It + VT/Zs);
            parameter Complex PSIpp0=real(Zs*Is) + j*imag(Zs*Is);
            parameter Complex a=0 + j*(Xq - Xppd);
            parameter Complex Epqp=real(PSIpp0 + a*It) + j*imag(PSIpp0 + a*It);
            parameter Real delta0=arg(Epqp) "rotor angle in radians";
            parameter Complex VT=V_0*cos(anglev_rad) + j*V_0*sin(anglev_rad)
              "Complex terminal voltage";
            parameter Complex S=p0 + j*q0 "Complex power on machine base";
            parameter Complex It=real(S/VT) - j*imag(S/VT) "Terminal current";
            parameter Complex DQ_dq=cos(delta0) - j*sin(delta0) "Parks transformation";
            parameter Complex I_dq=real(It*DQ_dq) - j*imag(It*DQ_dq);
            //Initialization of current and voltage components in synchronous reference frame.
            parameter Real iq0=real(I_dq) "q-axis component of intitial current";
            parameter Real id0=imag(I_dq) "d-axis component of intitial current";
            parameter Real ud0=V_0*cos(anglev_rad - delta0 + pi/2)
              "d-axis component of intitial voltage";
            parameter Real uq0=V_0*sin(anglev_rad - delta0 + pi/2)
              "q-axis component of intitial voltage";
            parameter Complex PSIpp0_dq=real(PSIpp0*DQ_dq) + j*imag(PSIpp0*DQ_dq)
              "Flux linkage in rotor reference frame";
            parameter Real PSIppq0=-imag(PSIpp0_dq)
              "q-axis component of the sub-transient flux linkage";
            parameter Real PSIppd0=real(PSIpp0_dq)
              "d-axis component of the sub-transient flux linkage";
            parameter Real PSIkd0=(PSIppd0 - (Xpd - Xl)*K3d*id0)/(K3d + K4d)
              "d-axis initial rotor flux linkage";
            parameter Real PSId0=PSIppd0 - Xppd*id0;
            parameter Real PSIq0=(-PSIppq0) - Xppq*iq0;
            //Initialization mechanical power and field voltage.
            parameter Real Epq0=uq0 + Xpd*id0 + R_a*iq0;
            parameter Real dsat=SE(
                Epq0,
                S10,
                S12,
                1,
                1.2);
            parameter Real efd0=Epq0*(1 + dsat) + (Xd - Xpd)*id0
              "Initial field voltage magnitude";
            parameter Real pm0=p0 + R_a*iq0*iq0 + R_a*id0*id0
              "Initial mechanical power, machine base";
            // Constants
            parameter Real K1d=(Xpd - Xppd)*(Xd - Xpd)/(Xpd - Xl)^2;
            parameter Real K2d=(Xpd - Xl)*(Xppd - Xl)/(Xpd - Xppd);
            parameter Real K3d=(Xppd - Xl)/(Xpd - Xl);
            parameter Real K4d=(Xpd - Xppd)/(Xpd - Xl);
          initial equation
            der(Epq) = 0;
            der(PSIkd) = 0;
            der(PSIppq) = 0;
            delta = delta0;
            w = 0;
          equation
            //Interfacing outputs with the internal variables
            XADIFD = XadIfd;
            PMECH0 = pm0;
            EFD0 = efd0;
            ISORCE = XadIfd;
            der(Epq) = 1/Tpd0*(EFD - XadIfd);
            der(PSIkd) = 1/Tppd0*(Epq - PSIkd - (Xpd - Xl)*id);
            der(PSIppq) = 1/Tppq0*((-PSIppq) + (Xq - Xppq)*iq);
            PSIppd = Epq*K3d + PSIkd*K4d;
            PSId = PSIppd - Xppd*id;
            PSIq = (-PSIppq) - Xppq*iq;
            XadIfd = K1d*(Epq - PSIkd - (Xpd - Xl)*id) + (Xd - Xpd)*id + (SE(
              Epq,
              S10,
              S12,
              1,
              1.2) + 1)*Epq;
            Te = PSId*iq - PSIq*id;
            ud = (-PSIq) - R_a*id;
            uq = PSId - R_a*iq;
            //flow, changed from machine base to system bas
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}})),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={Text(
                    extent={{-58,62},{52,-64}},
                    lineColor={0,0,255},
                    textString="GENSAL")}),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end GENSAL;

          model GENROU "ROUND ROTOR GENERATOR MODEL (QUADRATIC SATURATION)"
            //Import of dependencies
            import Complex;
            import Modelica.ComplexMath.arg;
            import Modelica.ComplexMath.real;
            import Modelica.ComplexMath.imag;
            import Modelica.ComplexMath.'abs';
            import Modelica.ComplexMath.conj;
            import Modelica.ComplexMath.fromPolar;
            import Modelica.ComplexMath.j;
            import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
            import Modelica.Constants.pi;
            extends BaseClasses.baseMachine(
              w(start=0),
              XADIFD(start=efd0),
              ANGLE(start=delta0),
              delta(start=delta0),
              id(start=id0),
              iq(start=iq0),
              ud(start=ud0),
              uq(start=uq0),
              Te(start=pm0));
            //Machine parameters
            parameter Real Xpq "q-axis transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Tpq0 "q-axis transient open-circuit time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xpp=Xppd "Sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            Real Epd(start=Epd0) "d-axis voltage behind transient reactance (pu)";
            Real Epq(start=Epq0) "q-axis voltage behind transient reactance ";
            Real PSIkd(start=PSIkd0) "d-axis rotor flux linkage (pu)";
            Real PSIkq(start=PSIkq0) "q-axis rotor flux linkage (pu)";
            //State variables
            Real PSId(start=PSId0) "d-axis flux linkage (pu)";
            Real PSIq(start=PSIq0) "q-axis flux linkage (pu)";
            Real PSIppd(start=PSIppd0) "d-axis subtransient flux linkage (pu)";
            Real PSIppq(start=PSIppq0) "q-axis subtransient flux linkage (pu)";
            Real PSIpp "Air-gap flux (pu)";
            Real XadIfd(start=efd0) "d-axis machine field current (pu)";
            Real XaqIlq(start=0) "q-axis Machine field current (pu)";
          protected
            parameter Complex Zs=R_a + j*Xpp "Equivalent impedance";
            parameter Complex VT=V_0*cos(anglev_rad) + j*V_0*sin(anglev_rad)
              "Complex terminal voltage";
            parameter Complex S=p0 + j*q0 "Complex power on machine base";
            parameter Complex It=real(S/VT) - j*imag(S/VT)
              "Complex current, machine base";
            parameter Complex Is=real(It + VT/Zs) + j*imag(It + VT/Zs)
              "Equivalent internal current source";
            parameter Complex PSIpp0=real(Zs*Is) + j*imag(Zs*Is)
              "Sub-transient flux linkage in stator reference frame";
            parameter Real ang_PSIpp0=arg(PSIpp0) "flux angle";
            parameter Real ang_It=arg(It) "current angle";
            parameter Real ang_PSIpp0andIt=ang_PSIpp0 - ang_It "angle difference";
            parameter Real abs_PSIpp0='abs'(PSIpp0)
              "magnitude of sub-transient flux linkage";
            parameter Real dsat=SE(
                abs_PSIpp0,
                S10,
                S12,
                1,
                1.2) "To include saturation of during initialization";
            parameter Real a=abs_PSIpp0 + abs_PSIpp0*dsat*(Xq - Xl)/(Xd - Xl);
            parameter Real b=(It.re^2 + It.im^2)^0.5*(Xpp - Xq);
            //Initializion rotor angle position
            parameter Real delta0=atan(b*cos(ang_PSIpp0andIt)/(b*sin(ang_PSIpp0andIt) - a))
                 + ang_PSIpp0 "initial rotor angle in radians";
            parameter Complex DQ_dq=cos(delta0) - j*sin(delta0)
              "Parks transformation, from stator to rotor reference frame";
            parameter Complex PSIpp0_dq=PSIpp0*DQ_dq
              "Flux linkage in rotor reference frame";
            parameter Complex I_dq=conj(It*DQ_dq);
            //"The terminal current in rotor reference frame"
            parameter Real PSIppq0=imag(PSIpp0_dq)
              "q-axis component of the sub-transient flux linkage";
            parameter Real PSIppd0=real(PSIpp0_dq)
              "d-axis component of the sub-transient flux linkage";
            //Initialization of current and voltage components in rotor reference frame (dq-axes).
            parameter Real delta1=delta0*180/pi "rotor angle in degrees";
            parameter Real iq0=real(I_dq) "q-axis component of intitial current";
            parameter Real id0=imag(I_dq) "d-axis component of intitial current";
            parameter Real ud0=(-(PSIppq0 - Xppq*iq0)) - R_a*id0
              "d-axis component of intitial voltage";
            parameter Real uq0=PSIppd0 - Xppd*id0 - R_a*iq0
              "q-axis component of intitial voltage";
            //Initialization current and voltage components in synchronous reference frame.
            parameter Real vr0=V_0*cos(anglev_rad)
              "Real component of initial terminal voltage";
            parameter Real vi0=V_0*sin(anglev_rad)
              "Imaginary component of intitial terminal voltage";
            parameter Real ir0=-CoB*(p0*vr0 + q0*vi0)/(vr0^2 + vi0^2)
              "Real component of initial armature current, systembase";
            parameter Real ii0=-CoB*(p0*vi0 - q0*vr0)/(vr0^2 + vi0^2)
              "Imaginary component of initial armature current, systembase";
            //Initialization mechanical power and field voltage.
            parameter Real pm0=p0 + R_a*iq0*iq0 + R_a*id0*id0
              "Initial mechanical power, machine base";
            parameter Real efd0=dsat*PSIppd0 + PSIppd0 + (Xpd - Xpp)*id0 + (Xd - Xpd)*id0
              "Initial field voltage magnitude";
            parameter Real Epq0=PSIkd0 + (Xpd - Xl)*id0;
            parameter Real Epd0=PSIkq0 - (Xpq - Xl)*iq0;
            //Initialize remaining states:
            parameter Real PSIkd0=(PSIppd0 - (Xpd - Xl)*K3d*id0)/(K3d + K4d)
              "d-axis initial rotor flux linkage";
            parameter Real PSIkq0=((-PSIppq0) + (Xpq - Xl)*K3q*iq0)/(K3q + K4q)
              "q-axis initial rotor flux linkage";
            parameter Real PSId0=PSIppd0 - Xppd*id0;
            parameter Real PSIq0=(-PSIppq0) - Xppq*iq0;
            // Constants
            parameter Real K1d=(Xpd - Xppd)*(Xd - Xpd)/(Xpd - Xl)^2;
            parameter Real K2d=(Xpd - Xl)*(Xppd - Xl)/(Xpd - Xppd);
            parameter Real K1q=(Xpq - Xppq)*(Xq - Xpq)/(Xpq - Xl)^2;
            parameter Real K2q=(Xpq - Xl)*(Xppq - Xl)/(Xpq - Xppq);
            parameter Real K3d=(Xppd - Xl)/(Xpd - Xl);
            parameter Real K4d=(Xpd - Xppd)/(Xpd - Xl);
            parameter Real K3q=(Xppq - Xl)/(Xpq - Xl);
            parameter Real K4q=(Xpq - Xppq)/(Xpq - Xl);
            parameter Real CoB=M_b/S_b
              "Constant to change from system base to machine base";
          initial equation
            der(Epd) = 0;
            der(Epq) = 0;
            der(PSIkd) = 0;
            der(PSIkq) = 0;
            delta = delta0;
            w = 0;
          equation
            //Interfacing outputs with the internal variables
            XADIFD = XadIfd;
            ISORCE = XadIfd;
            EFD0 = efd0;
            PMECH0 = pm0;
            der(Epq) = 1/Tpd0*(EFD - XadIfd);
            der(Epd) = 1/Tpq0*(-1)*XaqIlq;
            der(PSIkd) = 1/Tppd0*(Epq - PSIkd - (Xpd - Xl)*id);
            der(PSIkq) = 1/Tppq0*(Epd - PSIkq + (Xpq - Xl)*iq);
            Te = PSId*iq - PSIq*id;
            PSId = PSIppd - Xppd*id;
            PSIq = (-PSIppq) - Xppq*iq;
            PSIppd = Epq*K3d + PSIkd*K4d;
            -PSIppq = (-Epd*K3q) - PSIkq*K4q;
            PSIpp = sqrt(PSIppd*PSIppd + PSIppq*PSIppq);
            XadIfd = K1d*(Epq - PSIkd - (Xpd - Xl)*id) + Epq + id*(Xd - Xpd) + SE(
              PSIpp,
              S10,
              S12,
              1,
              1.2)*PSIppd;
            XaqIlq = K1q*(Epd - PSIkq + (Xpq - Xl)*iq) + Epd - iq*(Xq - Xpq) - SE(
              PSIpp,
              S10,
              S12,
              1,
              1.2)*(-1)*PSIppq*(Xq - Xl)/(Xd - Xl);
            //change sign for PSIppq 3/3
            ud = (-PSIq) - R_a*id;
            uq = PSId - R_a*iq;
            //flow
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}})),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={Text(
                    extent={{-54,24},{54,-26}},
                    lineColor={0,0,255},
                    textString="GENROU")}),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end GENROU;

          model GENROE "ROUND ROTOR GENERATOR MODEL (EXPONENTIAL SATURATION)"
            //Import of dependencies
            import Complex;
            import Modelica.ComplexMath.arg;
            import Modelica.ComplexMath.real;
            import Modelica.ComplexMath.imag;
            import Modelica.ComplexMath.'abs';
            import Modelica.ComplexMath.conj;
            import Modelica.ComplexMath.fromPolar;
            import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE_exp;
            import Modelica.Constants.pi;
            import Modelica.ComplexMath.j;
            extends BaseClasses.baseMachine(
              w(start=0),
              EFD(start=efd0),
              XADIFD(start=efd0),
              PMECH(start=pm0),
              ANGLE(start=delta0),
              delta(start=delta0),
              id(start=id0),
              iq(start=iq0),
              ud(start=ud0),
              uq(start=uq0),
              Te(start=pm0));
            //Machine parameters
            parameter Real Xpq "Sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Tpq0 "q-axis transient open-circuit time constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real Xpp=Xppd "Sub-transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            Real Epd(start=Epd0) "d-axis voltage behind transient reactance (pu)";
            Real Epq(start=Epq0) "q-axis voltage behind transient reactance ";
            Real PSIkd(start=PSIkd0) "d-axis rotor flux linkage (pu)";
            Real PSIkq(start=PSIkq0) "q-axis rotor flux linkage (pu)";
            //State variables
            Real PSId(start=PSId0) "d-axis flux linkage (pu)";
            Real PSIq(start=PSIq0) "q-axis flux linkage (pu)";
            Real PSIppd(start=PSIppd0) "d-axis subtransient flux linkage (pu)";
            Real PSIppq(start=PSIppq0) "q-axis subtransient flux linkage (pu)";
            Real PSIpp "Air-gap flux (pu)";
            Real XadIfd(start=efd0) "d-axis machine field current (pu)";
            Real XaqIlq(start=0) "q-axis Machine field current (pu)";
          protected
            parameter Complex Zs=R_a + j*Xpp "Equivalent impedance";
            parameter Complex VT=V_0*cos(anglev_rad) + j*V_0*sin(anglev_rad)
              "Complex terminal voltage";
            parameter Complex S=p0 + j*q0 "Complex power on machine base";
            parameter Complex It=real(S/VT) - j*imag(S/VT)
              "Complex current, machine base";
            parameter Complex Is=real(It + VT/Zs) + j*imag(It + VT/Zs)
              "Equivalent internal current source";
            parameter Complex PSIpp0=real(Zs*Is) + j*imag(Zs*Is)
              "Sub-transient flux linkage in stator reference frame";
            parameter Real ang_PSIpp0=arg(PSIpp0) "flux angle";
            parameter Real ang_It=arg(It) "current angle";
            parameter Real ang_PSIpp0andIt=ang_PSIpp0 - ang_It "angle difference";
            parameter Real abs_PSIpp0='abs'(PSIpp0)
              "magnitude of sub-transient flux linkage";
            parameter Real dsat=SE_exp(
                abs_PSIpp0,
                S10,
                S12,
                1,
                1.2) "To include saturation of during initialization";
            parameter Real a=abs_PSIpp0 + abs_PSIpp0*dsat*(Xq - Xl)/(Xd - Xl);
            parameter Real b=(It.re^2 + It.im^2)^0.5*(Xpp - Xq);
            //Initializion rotor angle position
            parameter Real delta0=atan(b*cos(ang_PSIpp0andIt)/(b*sin(ang_PSIpp0andIt) - a))
                 + ang_PSIpp0 "initial rotor angle in radians";
            parameter Complex DQ_dq=cos(delta0) - j*sin(delta0)
              "Parks transformation, from stator to rotor reference frame";
            parameter Complex PSIpp0_dq=real(PSIpp0*DQ_dq) + j*imag(PSIpp0*DQ_dq)
              "Flux linkage in rotor reference frame";
            parameter Complex I_dq=real(It*DQ_dq) - j*imag(It*DQ_dq);
            //"The terminal current in rotor reference frame"
            parameter Real PSIppq0=imag(PSIpp0_dq)
              "q-axis component of the sub-transient flux linkage";
            parameter Real PSIppd0=real(PSIpp0_dq)
              "d-axis component of the sub-transient flux linkage";
            //Initialization of current and voltage components in rotor reference frame (dq-axes).
            parameter Real delta1=delta0*180/pi "rotor angle in degrees";
            parameter Real iq0=real(I_dq) "q-axis component of intitial current";
            parameter Real id0=imag(I_dq) "d-axis component of intitial current";
            parameter Real ud0=(-(PSIppq0 - Xppq*iq0)) - R_a*id0
              "d-axis component of intitial voltage";
            parameter Real uq0=PSIppd0 - Xppd*id0 - R_a*iq0
              "q-axis component of intitial voltage";
            //Initialization current and voltage components in synchronous reference frame.
            parameter Real vr0=V_0*cos(anglev_rad)
              "Real component of initial terminal voltage";
            parameter Real vi0=V_0*sin(anglev_rad)
              "Imaginary component of intitial terminal voltage";
            parameter Real ir0=-CoB*(p0*vr0 + q0*vi0)/(vr0^2 + vi0^2)
              "Real component of initial armature current, systembase";
            parameter Real ii0=-CoB*(p0*vi0 - q0*vr0)/(vr0^2 + vi0^2)
              "Imaginary component of initial armature current, systembase";
            //Initialization mechanical power and field voltage.
            parameter Real pm0=p0 + R_a*iq0*iq0 + R_a*id0*id0
              "Initial mechanical power, machine base";
            parameter Real efd0=dsat*PSIppd0 + PSIppd0 + (Xpd - Xpp)*id0 + (Xd - Xpd)*id0
              "Initial field voltage magnitude";
            parameter Real Epq0=PSIkd0 + (Xpd - Xl)*id0;
            parameter Real Epd0=PSIkq0 - (Xpq - Xl)*iq0;
            //Initialize remaining states:
            parameter Real PSIkd0=(PSIppd0 - (Xpd - Xl)*K3d*id0)/(K3d + K4d)
              "d-axis initial rotor flux linkage";
            parameter Real PSIkq0=((-PSIppq0) + (Xpq - Xl)*K3q*iq0)/(K3q + K4q)
              "q-axis initial rotor flux linkage";
            parameter Real PSId0=PSIppd0 - Xppd*id0;
            parameter Real PSIq0=PSIppq0 - Xppq*iq0;
            // Constants
            parameter Real K1d=(Xpd - Xppd)*(Xd - Xpd)/(Xpd - Xl)^2;
            parameter Real K2d=(Xpd - Xl)*(Xppd - Xl)/(Xpd - Xppd);
            parameter Real K1q=(Xpq - Xppq)*(Xq - Xpq)/(Xpq - Xl)^2;
            parameter Real K2q=(Xpq - Xl)*(Xppq - Xl)/(Xpq - Xppq);
            parameter Real K3d=(Xppd - Xl)/(Xpd - Xl);
            parameter Real K4d=(Xpd - Xppd)/(Xpd - Xl);
            parameter Real K3q=(Xppq - Xl)/(Xpq - Xl);
            parameter Real K4q=(Xpq - Xppq)/(Xpq - Xl);
            parameter Real CoB=M_b/S_b
              "Constant to change from system base to machine base";
          initial equation
            der(Epd) = 0;
            der(Epq) = 0;
            der(PSIkd) = 0;
            der(PSIkq) = 0;
            delta = delta0;
            w = 0;
          equation
            //Interfacing outputs with the internal variables
            XADIFD = XadIfd;
            ISORCE = XadIfd;
            EFD0 = efd0;
            PMECH0 = pm0;
            der(Epq) = 1/Tpd0*(EFD - XadIfd);
            der(Epd) = 1/Tpq0*(-1)*XaqIlq;
            der(PSIkd) = 1/Tppd0*(Epq - PSIkd - (Xpd - Xl)*id);
            der(PSIkq) = 1/Tppq0*(Epd - PSIkq + (Xpq - Xl)*iq);
            Te = PSId*iq - PSIq*id;
            PSId = PSIppd - Xppd*id;
            PSIq = (-PSIppq) - Xppq*iq;
            PSIppd = Epq*K3d + PSIkd*K4d;
            -PSIppq = (-Epd*K3q) - PSIkq*K4q;
            PSIpp = sqrt(PSIppd*PSIppd + PSIppq*PSIppq);
            XadIfd = K1d*(Epq - PSIkd - (Xpd - Xl)*id) + Epq + id*(Xd - Xpd) + SE_exp(
              PSIpp,
              S10,
              S12,
              1,
              1.2)*PSIppd;
            XaqIlq = K1q*(Epd - PSIkq + (Xpq - Xl)*iq) + Epd - iq*(Xq - Xpq) - SE_exp(
              PSIpp,
              S10,
              S12,
              1,
              1.2)*(-1)*PSIppq*(Xq - Xl)/(Xd - Xl);
            //change sign for PSIppq 3/3
            ud = (-PSIq) - R_a*id;
            uq = PSId - R_a*iq;
            //flow
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}})),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={Text(
                    extent={{-54,24},{54,-26}},
                    lineColor={0,0,255},
                    textString="GENROE")}),
              Documentation);
          end GENROE;

          model GENSAE "SALIENT POLE GENERATOR MODEL (EXPONENTIAL SATURATION)"
            // Import of Dependencies
            import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE_exp;
            import Modelica.Constants.pi;
            import Complex;
            import Modelica.ComplexMath.arg;
            import Modelica.ComplexMath.real;
            import Modelica.ComplexMath.imag;
            import Modelica.ComplexMath.'abs';
            import Modelica.ComplexMath.conj;
            import Modelica.ComplexMath.fromPolar;
            import Modelica.ComplexMath.j;
            //Extending machine base
            extends BaseClasses.baseMachine(
              w(start=0),
              EFD(start=efd0),
              XADIFD(start=efd0),
              PMECH(start=pm0),
              ANGLE(start=delta0),
              delta(start=delta0),
              id(start=id0),
              iq(start=iq0),
              ud(start=ud0),
              uq(start=uq0),
              Te(start=pm0));
            Real Epq(start=Epq0) "q-axis voltage behind transient reactance (pu)";
            Real PSIkd(start=PSIkd0) "d-axis rotor flux linkage (pu)";
            Real PSIppq(start=PSIppq0) "q-axis subtransient flux linkage (pu)";
            Real PSIppd(start=PSIppd0) "d-axis subtransient flux linkage (pu)";
            Real PSId(start=PSId0) "d-axis flux linkage (pu)";
            Real PSIq(start=PSIq0) "q-axis flux linkage (pu)";
            Real XadIfd(start=efd0) "Machine field current (pu)";
          protected
            parameter Complex Zs=R_a + j*Xppd "Equivalent impedance";
            parameter Complex Is=real(It + VT/Zs) + j*imag(It + VT/Zs);
            parameter Complex PSIpp0=real(Zs*Is) + j*imag(Zs*Is);
            parameter Complex a=0 + j*(Xq - Xppd);
            parameter Complex Epqp=real(PSIpp0 + a*It) + j*imag(PSIpp0 + a*It);
            parameter Real delta0=arg(Epqp) "rotor angle in radians";
            parameter Complex VT=V_0*cos(anglev_rad) + j*V_0*sin(anglev_rad)
              "Complex terminal voltage";
            parameter Complex S=p0 + j*q0 "Complex power on machine base";
            parameter Complex It=real(S/VT) - j*imag(S/VT) "Terminal current";
            parameter Complex DQ_dq=cos(delta0) - j*sin(delta0) "Parks transformation";
            parameter Complex I_dq=real(It*DQ_dq) - j*imag(It*DQ_dq);
            //Initialization of current and voltage components in synchronous reference frame.
            parameter Real iq0=real(I_dq) "q-axis component of intitial current";
            parameter Real id0=imag(I_dq) "d-axis component of intitial current";
            parameter Real ud0=V_0*cos(anglev_rad - delta0 + pi/2)
              "d-axis component of intitial voltage";
            parameter Real uq0=V_0*sin(anglev_rad - delta0 + pi/2)
              "q-axis component of intitial voltage";
            parameter Complex PSIpp0_dq=real(PSIpp0*DQ_dq) + j*imag(PSIpp0*DQ_dq)
              "Flux linkage in rotor reference frame";
            parameter Real PSIppq0=-imag(PSIpp0_dq)
              "q-axis component of the sub-transient flux linkage";
            parameter Real PSIppd0=real(PSIpp0_dq)
              "d-axis component of the sub-transient flux linkage";
            parameter Real PSIkd0=(PSIppd0 - (Xpd - Xl)*K3d*id0)/(K3d + K4d)
              "d-axis initial rotor flux linkage";
            parameter Real PSId0=PSIppd0 - Xppd*id0;
            parameter Real PSIq0=(-PSIppq0) - Xppq*iq0;
            //Initialization mechanical power and field voltage.
            parameter Real Epq0=uq0 + Xpd*id0 + R_a*iq0;
            parameter Real dsat=SE_exp(
                Epq0,
                S10,
                S12,
                1,
                1.2);
            parameter Real efd0=Epq0*(1 + dsat) + (Xd - Xpd)*id0
              "Initial field voltage magnitude";
            parameter Real pm0=p0 + R_a*iq0*iq0 + R_a*id0*id0
              "Initial mechanical power, machine base";
            // Constants
            parameter Real K1d=(Xpd - Xppd)*(Xd - Xpd)/(Xpd - Xl)^2;
            parameter Real K2d=(Xpd - Xl)*(Xppd - Xl)/(Xpd - Xppd);
            parameter Real K3d=(Xppd - Xl)/(Xpd - Xl);
            parameter Real K4d=(Xpd - Xppd)/(Xpd - Xl);
          initial equation
            der(Epq) = 0;
            der(PSIkd) = 0;
            der(PSIppq) = 0;
            delta = delta0;
            w = 0;
          equation
            //Interfacing outputs with the internal variables
            XADIFD = XadIfd;
            PMECH0 = pm0;
            EFD0 = efd0;
            ISORCE = XadIfd;
            der(Epq) = 1/Tpd0*(EFD - XadIfd);
            der(PSIkd) = 1/Tppd0*(Epq - PSIkd - (Xpd - Xl)*id);
            der(PSIppq) = 1/Tppq0*((-PSIppq) + (Xq - Xppq)*iq);
            PSIppd = Epq*K3d + PSIkd*K4d;
            PSId = PSIppd - Xppd*id;
            PSIq = (-PSIppq) - Xppq*iq;
            XadIfd = K1d*(Epq - PSIkd - (Xpd - Xl)*id) + (Xd - Xpd)*id + (SE_exp(
              Epq,
              S10,
              S12,
              1,
              1.2) + 1)*Epq;
            Te = PSId*iq - PSIq*id;
            ud = (-PSIq) - R_a*id;
            uq = PSId - R_a*iq;
            //flow, changed from machine base to system bas
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                      100,100}})),
              Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                      100}}), graphics={Text(
                    extent={{-58,62},{52,-64}},
                    lineColor={0,0,255},
                    textString="GENSAE")}),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end GENSAE;

          model GENCLS
            import Modelica.Constants.pi;
            import Modelica.Constants.eps;
            extends OpenIPSL.Electrical.Essentials.pfComponent;
            OpenIPSL.Interfaces.PwPin p(
              vr(start=vr0),
              vi(start=vi0),
              ir(start=ir0),
              ii(start=ii0)) annotation (Placement(visible=true, transformation(
                  origin={100,0},
                  extent={{-10,-10},{10,10}},
                  rotation=0)));
            parameter Real M_b "Machine base power rating (MVA)"
              annotation (Dialog(group="Power flow data"));
            parameter Real H=0 "Inertia constant (s)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real D=0 "Damping coefficient"
              annotation (Dialog(group="Machine parameters"));
            parameter Real R_a=0 "Amature resistance (pu)"
              annotation (Dialog(group="Machine parameters"));
            parameter Real X_d=0.2 "d-axis transient reactance (pu)"
              annotation (Dialog(group="Machine parameters"));
            Real delta(start=delta0, fixed=true) "Rotor angle (deg)";
            Real omega(start=0, fixed=true) "Rotor speed (pu)";
            Real V(start=V_0) "Bus voltage magnitude (pu)";
            Real anglev(start=anglev_rad) "Bus voltage angle (rad)";
            Real eq(start=vf0, fixed=true) "Constant emf behind transient reactance (pu)";
            Real vd(start=vd0) "d-axis voltage (pu)";
            Real vq(start=vq0) "q-axis voltage (pu)";
            Real id(start=id0) "d-axis current (pu)";
            Real iq(start=iq0) "q-axis current (pu)";
            Real P(start=P_0/S_b) "Active power (pu. of S_b)";
            Real Q(start=Q_0/S_b) "Reactive power (pu of S_b)";
          protected
            parameter Real CoB=M_b/S_b "Change from system to machine base";
            parameter Real anglev_rad=angle_0*pi/180 "Initial bus voltage angle (rad)";
            parameter Real p0=P_0/M_b "Initial active power (pu on M_b)";
            parameter Real q0=Q_0/M_b "Initial reactive power in (pu on M_b)";
            parameter Real vr0=V_0*cos(anglev_rad);
            parameter Real vi0=V_0*sin(anglev_rad);
            parameter Real ir0=(p0*vr0 + q0*vi0)/(vr0^2 + vi0^2);
            parameter Real ii0=(p0*vi0 - q0*vr0)/(vr0^2 + vi0^2);
            parameter Real delta0=atan2(vi0 + R_a*ii0 + X_d*ir0, vr0 + R_a*ir0 - X_d*ii0);
            parameter Real vd0=vr0*cos(pi/2 - delta0) - vi0*sin(pi/2 - delta0);
            parameter Real vq0=vr0*sin(pi/2 - delta0) + vi0*cos(pi/2 - delta0);
            parameter Real id0=ir0*cos(pi/2 - delta0) - ii0*sin(pi/2 - delta0);
            parameter Real iq0=ir0*sin(pi/2 - delta0) + ii0*cos(pi/2 - delta0);
            parameter Real vf0=vq0 + R_a*iq0 + X_d*id0;
          equation
            //Swing equation
            //in PSS/E setting to zero is equivalent to removing the swing equation
            if abs(H) > eps then
              der(delta) = omega*2*pi*50;
              der(omega) = (P_0/S_b - P - D*omega)/(2*H);
            else
              der(delta) = 0;
              omega = 0;
            end if;
            // d-q voltage and current equations
            der(eq) = 0 "Classical model assumes constant emf";
            vq = eq - R_a*iq - X_d*id "q-axis voltage equation";
            vd = X_d*iq - R_a*id "d-axis voltage equation";
            // Park's transformation
            [p.ir; p.ii] = -CoB*[sin(delta), cos(delta); -cos(delta), sin(delta)]*[id; iq];
            [p.vr; p.vi] = [sin(delta), cos(delta); -cos(delta), sin(delta)]*[vd; vq];
            //Power injections
            -P = p.vr*p.ir + p.vi*p.ii;
            -Q = p.vi*p.ir - p.vr*p.ii;
            // Terminal voltage magnitude and angle
            V = sqrt(p.vr^2 + p.vi^2);
            anglev = atan2(p.vi, p.vr);
            annotation (
              Icon(coordinateSystem(preserveAspectRatio=false, initialScale=0.1),
                  graphics={Text(
                    extent={{50,150},{100,110}},
                    lineColor={0,0,255},
                    lineThickness=0.5,
                    fillColor={0,0,255},
                    fillPattern=FillPattern.Solid,
                    textStyle={TextStyle.Bold},
                    textString="INF"),Line(points={{-40,88},{0,68}}, color={0,0,255}),
                    Line(points={{-40,70},{0,50}}, color={0,0,255}),Line(points={{-40,50},
                    {0,30}}, color={0,0,255}),Line(points={{-40,30},{0,10}}, color={0,0,
                    255}),Line(points={{-40,10},{0,-10}}, color={0,0,255}),Line(points={{
                    -40,-10},{0,-30}}, color={0,0,255}),Line(points={{-40,-30},{0,-50}},
                    color={0,0,255}),Line(points={{-40,-50},{0,-70}}, color={0,0,255}),
                    Line(points={{0,80},{0,-80}}, color={0,0,255}),Line(points={{100,0},{
                    96,0},{0,0}}, color={0,0,255}),Rectangle(extent={{-100,100},{100,-100}},
                    lineColor={0,0,255})}),
              Diagram(coordinateSystem(
                  preserveAspectRatio=true,
                  initialScale=0.1,
                  grid={2,2})),
              Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
          end GENCLS;

          package BaseClasses
            partial model baseMachine
              import Modelica.Constants.pi;
              import Complex;
              import Modelica.ComplexMath.arg;
              import Modelica.ComplexMath.real;
              import Modelica.ComplexMath.imag;
              import Modelica.ComplexMath.'abs';
              import Modelica.ComplexMath.conj;
              import Modelica.Blocks.Interfaces.*;
              extends OpenIPSL.Electrical.Essentials.pfComponent;
              //Machine parameters
              parameter Real M_b "Machine base power (MVA)"
                annotation (Dialog(group="Power flow data"));
              parameter Real Tpd0 "d-axis transient open-circuit time constant (s)"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Tppd0 "d-axis sub-transient open-circuit time constant (s)"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Tppq0 "q-axis transient open-circuit time constant (s)"
                annotation (Dialog(group="Machine parameters"));
              parameter Real H "Inertia constant (s)"
                annotation (Dialog(group="Machine parameters"));
              parameter Real D "Speed damping"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Xd "d-axis reactance"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Xq "q-axis reactance"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Xpd "d-axis transient reactance"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Xppd "d-axis sub-transient reactance"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Xppq "q-axis sub-transient reactance"
                annotation (Dialog(group="Machine parameters"));
              parameter Real Xl "leakage reactance"
                annotation (Dialog(group="Machine parameters"));
              parameter Real S10 "Saturation factor at 1.0 pu"
                annotation (Dialog(group="Machine parameters"));
              parameter Real S12 "Saturation factor at 1.2 pu"
                annotation (Dialog(group="Machine parameters"));
              parameter Real R_a=0 "amature resistance"
                annotation (Dialog(group="Machine parameters"));
              //Initialization
              OpenIPSL.Interfaces.PwPin p(
                vr(start=vr0),
                vi(start=vi0),
                ir(start=ir0),
                ii(start=ii0)) annotation (Placement(transformation(extent={{90,
                        -10},{110,10}})));
              RealOutput SPEED(start=0) "Machine speed deviation from nominal (pu)"
                annotation (Placement(transformation(extent={{100,60},{120,80}})));
              RealInput PMECH "Turbine mechanical power (pu on M_b)"
                annotation (Placement(transformation(extent={{-140,30},{-100,70}})));
              RealOutput PMECH0 "Initial value of machine electrical power (pu on M_b)"
                annotation (Placement(transformation(extent={{100,40},{120,60}})));
              RealOutput ETERM(start=V_0) "Machine terminal voltage (pu)"
                annotation (Placement(transformation(extent={{100,-40},{120,-20}})));
              RealInput EFD "Generator main field voltage (pu)"
                annotation (Placement(transformation(extent={{-140,-70},{-100,-30}})));
              RealOutput EFD0 "Initial generator main field voltage (pu)"
                annotation (Placement(transformation(extent={{100,-60},{120,-40}})));
              RealOutput PELEC(start=p0) "Machine electrical power (pu on M_b)"
                annotation (Placement(transformation(extent={{100,20},{120,40}})));
              RealOutput ISORCE "Machine source current (pu)"
                annotation (Placement(transformation(extent={{100,-80},{120,-60}})));
              RealOutput ANGLE "Machine relative rotor angle (deg.)"
                annotation (Placement(transformation(extent={{100,78},{120,98}})));
              RealOutput XADIFD "Machine field current (pu)" annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={110,-90}), iconTransformation(
                    extent={{-8,-8},{8,8}},
                    rotation=0,
                    origin={108,-90})));
              Real w(start=0) "Machine speed deviation (pu)";
              Real delta "Rotor angle (deg.)";
              Real Vt(start=V_0) "Bus voltage magnitude (pu)";
              Real anglev(start=anglev_rad) "Bus voltage angle (deg.)";
              Real I(start=sqrt(ir0^2 + ii0^2)) "Terminal current magnitude (pu)";
              Real anglei(start=atan2(ii0, ir0)) "Terminal current angle (deg.)";
              Real P(start=P_0/S_b) "Active power (p.u. on S_b)";
              Real Q(start=Q_0/S_b) "Reactive power (p.u. on S_b)";
              Real Te "Electrical torque (pu)";
              Real id "d-axis armature current (pu)";
              Real iq "q-axis armature current (pu)";
              Real ud "d-axis terminal voltage (pu)";
              Real uq "q-axis terminal voltage (pu)";
            protected
              parameter Real w_b=2*pi*fn "System base speed (rad/s)";
              parameter Real anglev_rad=angle_0*pi/180
                "initial value of bus voltage angle in rad";
              parameter Real CoB=M_b/S_b;
              parameter Real vr0=V_0*cos(anglev_rad)
                "Real component of initial terminal voltage";
              parameter Real vi0=V_0*sin(anglev_rad)
                "Imaginary component of intitial terminal voltage";
              parameter Real ir0=-CoB*(p0*vr0 + q0*vi0)/(vr0^2 + vi0^2)
                "Real component of initial armature current, systembase";
              parameter Real ii0=-CoB*(p0*vi0 - q0*vr0)/(vr0^2 + vi0^2)
                "Imaginary component of initial armature current, systembase";
              parameter Real p0=P_0/M_b "initial active power generation in pu machinebase";
              parameter Real q0=Q_0/M_b
                "initial reactive power generation in pu machinebase";
            equation
              //Interfacing outputs with the internal variables
              ANGLE = delta;
              SPEED = w;
              ETERM = Vt;
              PELEC = P/CoB;
              [p.ir; p.ii] = -CoB*[sin(delta), cos(delta); -cos(delta), sin(delta)]*[id; iq];
              [p.vr; p.vi] = [sin(delta), cos(delta); -cos(delta), sin(delta)]*[ud; uq];
              -P = p.vr*p.ir + p.vi*p.ii;
              -Q = p.vi*p.ir - p.vr*p.ii;
              Vt = sqrt(p.vr^2 + p.vi^2);
              anglev = atan2(p.vi, p.vr);
              I = sqrt(p.ii^2 + p.ir^2);
              anglei = atan2(p.ii, p.ir);
              der(w) = ((PMECH - D*w)/(w + 1) - Te)/(2*H);
              der(delta) = w_b*w;
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-100,100},{100,-100}},
                      lineColor={0,0,255}),Text(
                      extent={{64,75},{92,65}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="SPEED"),Text(
                      extent={{60,-66},{92,-76}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="ISORCE"),Text(
                      extent={{64,-25},{92,-35}},
                      lineColor={0,0,255},
                      textString="ETERM"),Text(
                      extent={{64,94},{92,84}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="ANGLE"),Text(
                      extent={{58,56},{92,46}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="PMECH0"),Text(
                      extent={{64,34},{92,24}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="PELEC"),Text(
                      extent={{72,-46},{92,-56}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="EFD0"),Text(
                      extent={{56,-86},{92,-96}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="XADIFD0"),Text(
                      extent={{-84,56},{-44,46}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="PMECH0"),Text(
                      extent={{-88,-46},{-58,-56}},
                      lineColor={0,0,255},
                      lineThickness=0.5,
                      textString="EFD")}),
                Documentation);
            end baseMachine;
          annotation (Documentation);
          end BaseClasses;
        annotation (Documentation);
        end PSSE;
      annotation (Documentation);
      end Machines;

      package Controls
        package PSAT
          package TG "Turbine and its governor (the mathematical models are taken from PSAT)"
            model TGTypeI
              Modelica.Blocks.Interfaces.RealInput w "Rotor speed (pu)" annotation (
                  Placement(transformation(extent={{-140,-20},{-100,20}})));
              Modelica.Blocks.Interfaces.RealOutput pm "Mechanical power (pu)" annotation (
                  Placement(transformation(extent={{100,-10},{120,10}})));
              parameter Real wref=1 "Speed reference (pu)";
              parameter Real pref "Active power reference (pu)";
              parameter Real R "Droop (pu)";
              parameter Real pmax "Maximum turbine output (pu)";
              parameter Real pmin "Minimum turbine output (pu)";
              parameter Real Ts "Governor time constant (s)";
              parameter Real Tc "Servo time constant (s)";
              parameter Real T3 "Transient gain time constant (s)";
              parameter Real T4 "Power fraction time constant (s)";
              parameter Real T5 "Reheat time constant (s)";
              Real pin "Turbine output (pu)";
            protected
              parameter Real pin0=pref "Initialization";
              parameter Real xg10=pin0 "Initialization";
              parameter Real xg20=(1 - T3/Tc)*xg10 "Initialization";
              parameter Real xg30=(1 - T4/T5)*(xg20 + T3*xg10/Tc) "Initialization";
              Real pinstar;
              Real xg1(start=xg10, fixed=true);
              Real xg2(start=xg20, fixed=true);
              Real xg3(start=xg30, fixed=true);
            equation
              pinstar = pref + (wref - w)/R;
              if pinstar >= pmin and pinstar <= pmax then
                pin = pinstar;
              elseif pinstar > pmax then
                pin = pmax;
              else
                pin = pmin;
              end if;
              der(xg1) = (pin - xg1)/Ts;
              der(xg2) = ((1 - T3/Tc)*xg1 - xg2)/Tc;
              der(xg3) = ((1 - T4/T5)*(xg2 + T3*xg1/Tc) - xg3)/T5;
              pm = xg3 + (xg2 + T3*xg1/Tc)*T4/T5;
              annotation (
                Icon(graphics={ Text(
                      extent={{-100,10},{-60,-10}},
                      lineColor={0,0,0},
                      textString="w"),Text(
                      extent={{60,10},{100,-10}},
                      lineColor={0,0,0},
                      textString="pm"),
                   Text(
                      extent={{-60,0},{60,-80}},
                      lineColor={0,0,255},
                      textString="TGTypeI"),
                    Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0}),
                    Text(
                      extent={{-80,80},{80,20}},
                      lineColor={0,0,0},
                      textString="%name")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Turbine and Governor - control scheme Type I</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end TGTypeI;

            model TGtypeII "TG Type II"
              Modelica.Blocks.Interfaces.RealInput pm0 "Initial mechanical power (pu)"
                annotation (Placement(
                  visible=true,
                  transformation(
                    origin={0,120},
                    extent={{-20,-20},{20,20}},
                    rotation=-90),
                  iconTransformation(
                    origin={0.0,120.0},
                    extent={{-20.0,-20.0},{20.0,20.0}},
                    rotation=-90)));
              Modelica.Blocks.Interfaces.RealOutput pm "Mechanical power (pu)" annotation (
                  Placement(
                  visible=true,
                  transformation(
                    origin={109.815,0},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0),
                  iconTransformation(
                    origin={110.0,-0.0},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealInput w "Rotor speed (pu)" annotation (
                  Placement(
                  visible=true,
                  transformation(
                    origin={-120,5e-06},
                    extent={{-20,-20},{20,20}},
                    rotation=0),
                  iconTransformation(
                    origin={-120.0,-0.0},
                    extent={{-20.0,-20.0},{20.0,20.0}},
                    rotation=0)));
              Modelica.Blocks.Math.Add add1(k2=-1) annotation (Placement(visible=true,
                    transformation(
                    origin={-50,6.66134e-16},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              Modelica.Blocks.Continuous.TransferFunction transferFunction1(a={Ts,1}, b={T3,
                    1}) annotation (Placement(visible=true, transformation(
                    origin={10,4.44089e-16},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              parameter Real wref=1 "Reference speed (pu)";
              parameter Real R=0.2 "Droop (pu)";
              parameter Real pmax0=1 "Maximum turbine output (pu)";
              parameter Real pmin0=0 "Minimum turbine output (pu)";
              parameter Real Ts=0.1 "Governor Time constant (s)";
              parameter Real T3=-0.1 "Transient gain time constant (s)";
              parameter Real S_b=100 "System base power (MVA)"
                annotation (Dialog(group="Power flow data"));
              parameter Real Sn=20 "Nominal power (MVA)";
              Modelica.Blocks.Math.Gain gain1(k=1/Ro) annotation (Placement(visible=true,
                    transformation(
                    origin={-20,6.66134e-16},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              Modelica.Blocks.Sources.Constant const(k=wref) annotation (Placement(visible=
                      true, transformation(
                    origin={-90,20},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Math.Add add2 annotation (Placement(visible=true,
                    transformation(
                    origin={50,0},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=pmax, uMin=pmin) annotation (
                  Placement(visible=true, transformation(
                    origin={80,-5.55112e-16},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
            protected
              parameter Real Ro=R*S_b/Sn;
              parameter Real pmax=pmax0*Sn/S_b;
              parameter Real pmin=pmin0*Sn/S_b;
            equation

              connect(add2.u1, pm0) annotation (Line(points={{38,6},{32,6},{32,50},{0,50},{0,120}}, color={0,0,127}));
              connect(add1.u1, const.y) annotation (Line(points={{-62,6},{-68,6},{-68,20},{-79,20}}, color={0,0,127}));
              connect(w, add1.u2) annotation (Line(points={{-120,0},{-80,0},{-80,-6},{-62,-6}}, color={0,0,127}));
              connect(add2.u2, transferFunction1.y) annotation (Line(points={{38,-6},{30,-6},{30,0},{21,0}}, color={0,0,127}));
              connect(gain1.y, transferFunction1.u) annotation (Line(points={{-9,0},{-2,0}}, color={0,0,127}));
              connect(add1.y, gain1.u) annotation (Line(points={{-39,0},{-32,0}}, color={0,0,127}));
              connect(add2.y, limiter1.u) annotation (Line(points={{61,0},{68,0}}, color={0,0,127}));
              connect(limiter1.y, pm) annotation (Line(points={{91,0},{109.815,0}}, color={0,0,127}));
              annotation (
                Icon( graphics={Rectangle(lineColor={0,0,0}, extent={{-100,-100},{100,100}}),
                                                              Text(
                      origin={0,-40},
                      extent={{-60,40},{60,-40}},
                      fontName="Arial",
                      lineColor={0,0,255},
                      textString="TGTypeII"),
                                        Text(
                      origin={0,80},
                      fillPattern=FillPattern.Solid,
                      extent={{-20,10},{20,-10}},
                      textString="pm0"),Text(
                      origin={-80,0},
                      extent={{-20,10},{20,-10}},
                      lineColor={0,0,0},
                      textString="w"),  Text(
                      origin={80,0},
                      extent={{-20,10},{20,-10}},
                      lineColor={0,0,0},
                      textString="pm"),
                    Text(
                      extent={{-80,80},{80,20}},
                      lineColor={0,0,0},
                      textString="%name")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>TG Type II, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end TGtypeII;

            model TGTypeIII
              "Hydro Turbine (Linear model) and Governor (Standard model)- control scheme Type 3"
              parameter Real P_0 "Active power (pu)"
                annotation (Dialog(group="Power flow data"));
              parameter Real wref=1 "Reference speed (pu)";
              parameter Real Tg "Pilot valve droop (pu)";
              parameter Real gmax "Maximum gate opening (pu)";
              parameter Real gmin "Minimum gate opening (pu)";
              parameter Real vmax "Maximum gate opening rate (pu)";
              parameter Real vmin "Minimum gate opening rate (pu)";
              parameter Real Tp "Pilot valve time constant (s)";
              parameter Real Tr "Dashpot time constant (s)";
              parameter Real delta "Transient speed droop (p.u./p.u.)";
              parameter Real sigma "Permanent speed droop (p.u./p.u.)";
              parameter Real Tw "Water starting time (s)";
              parameter Real a11 "Deriv. of flow rate vs. turbine head";
              parameter Real a13 "Deriv. of flow rate vs. gate position";
              parameter Real a21 "Deriv. of torque vs. turbine head";
              parameter Real a23 "Deriv. of torque vs. gate position";
              parameter Real int3;
              Real deltaG "Gate position variation (pu)";
              Real G "Gate position (pu)";
              Modelica.Blocks.Continuous.Integrator integrator(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=0) annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
              Modelica.Blocks.Math.Gain gain(k=1/(Tg*Tp))
                annotation (Placement(transformation(extent={{-140,-10},{-120,10}})));
              Modelica.Blocks.Math.Gain gain1(k=1/Tp) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={-76,-30})));
              Modelica.Blocks.Continuous.Integrator integrator1(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=0)
                annotation (Placement(transformation(extent={{-86,-10},{-66,10}})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{-116,-10},{-96,10}})));
              Modelica.Blocks.Math.Gain gain2(k=delta + sigma) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={-76,30})));
              Modelica.Blocks.Math.Gain gain3(k=sigma/Tr) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={-130,-60})));
              Modelica.Blocks.Math.Gain gain5(k=1/Tr) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-74,-90})));
              Modelica.Blocks.Continuous.Integrator integrator2(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=0) annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={-76,-60})));
              Modelica.Blocks.Math.Feedback feedback1 annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=180,
                    origin={-40,-60})));
              Modelica.Blocks.Math.Gain gain4(k=1/(a11*Tw)) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={140,-70})));
              Modelica.Blocks.Continuous.Integrator integrator3(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=int3) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={150,-40})));
              Modelica.Blocks.Math.Feedback feedback2 annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={120,-40})));
              Modelica.Blocks.Math.Gain G6(k=(a11*a23 - a13*a21)/a11)
                annotation (Placement(transformation(extent={{84,-10},{104,10}})));
              Modelica.Blocks.Math.Gain gain7(k=a13*a21/(a11*a11*Tw))
                annotation (Placement(transformation(extent={{84,-50},{104,-30}})));
              Modelica.Blocks.Interfaces.RealInput w "Rotor speed (pu)" annotation (
                  Placement(transformation(extent={{-280,-20},{-240,20}}), iconTransformation(extent={{-140,-20},{-100,20}})));
              Modelica.Blocks.Interfaces.RealOutput pm "Mechanical power (pu)" annotation (
                  Placement(transformation(extent={{200,-10},{220,10}}), iconTransformation(extent={{100,-10},{120,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=vmax, uMin=vmin)
                annotation (Placement(transformation(extent={{-50,-10},{-30,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=gmax, uMin=gmin)
                annotation (Placement(transformation(extent={{10,-10},{30,10}})));
              Modelica.Blocks.Math.Add add(k1=+1, k2=-1)
                annotation (Placement(transformation(extent={{-200,-10},{-180,10}})));
              Modelica.Blocks.Math.Add3 add3_1(
                k1=-1,
                k2=1,
                k3=1) annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add add1
                annotation (Placement(transformation(extent={{50,-10},{70,10}})));
              Modelica.Blocks.Math.Add add2
                annotation (Placement(transformation(extent={{172,-10},{192,10}})));
              Modelica.Blocks.Sources.Constant const(k=P_0)
                annotation (Placement(transformation(extent={{10,40},{30,60}})));
              Modelica.Blocks.Sources.Constant const1(k=wref)
                annotation (Placement(transformation(extent={{-240,10},{-220,30}})));
            equation
              deltaG = limiter1.y;
              G = add1.y;
              connect(gain1.y, feedback.u2) annotation (Line(
                  points={{-87,-30},{-106,-30},{-106,-8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback.y, integrator1.u) annotation (Line(
                  points={{-97,0},{-88,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain.y, feedback.u1) annotation (Line(
                  points={{-119,0},{-114,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain5.y, feedback1.u2) annotation (Line(
                  points={{-63,-90},{-40,-90},{-40,-68}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback1.y, integrator2.u) annotation (Line(
                  points={{-49,-60},{-64,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator2.y, gain3.u) annotation (Line(
                  points={{-87,-60},{-118,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain4.y, feedback2.u2) annotation (Line(
                  points={{129,-70},{120,-70},{120,-48}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback2.y, integrator3.u) annotation (Line(
                  points={{129,-40},{138,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain7.y, feedback2.u1) annotation (Line(
                  points={{105,-40},{112,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain1.u, integrator1.y) annotation (Line(
                  points={{-64,-30},{-58.6,-30},{-58.6,0},{-65,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator2.y, gain5.u) annotation (Line(
                  points={{-87,-60},{-93.7,-60},{-93.7,-90},{-86,-90}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator3.y, gain4.u) annotation (Line(
                  points={{161,-40},{166,-40},{166,-70},{152,-70}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator1.y, limiter.u) annotation (Line(
                  points={{-65,0},{-52,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter.y, integrator.u) annotation (Line(
                  points={{-29,0},{-22,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator.y, limiter1.u) annotation (Line(
                  points={{1,0},{8,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback1.u1, limiter1.y) annotation (Line(
                  points={{-32,-60},{36,-60},{36,0},{31,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, gain2.u) annotation (Line(
                  points={{31,0},{36,0},{36,30},{-64,30}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(w, add.u2) annotation (Line(
                  points={{-260,0},{-219,0},{-219,-6},{-202,-6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain2.y, add3_1.u1) annotation (Line(
                  points={{-87,30},{-175.7,30},{-175.7,8},{-172,8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add.y, add3_1.u2) annotation (Line(
                  points={{-179,0},{-172,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain3.y, add3_1.u3) annotation (Line(
                  points={{-141,-60},{-176.7,-60},{-176.7,-8},{-172,-8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add3_1.y, gain.u) annotation (Line(
                  points={{-149,0},{-142,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, add1.u2) annotation (Line(
                  points={{31,0},{36,0},{36,-6},{48,-6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.y, G6.u) annotation (Line(
                  points={{71,0},{82,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.y, gain7.u) annotation (Line(
                  points={{71,0},{74.3,0},{74.3,-40},{82,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(G6.y, add2.u1) annotation (Line(
                  points={{105,0},{160.9,0},{160.9,6},{170,6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator3.y, add2.u2) annotation (Line(
                  points={{161,-40},{166,-40},{166,-6},{170,-6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(const.y, add1.u1) annotation (Line(points={{31,50},{43.3,50},{43.3,6},{48,6}},
                                              color={0,0,127}));
              connect(const1.y, add.u1) annotation (Line(points={{-219,20},{-210,20},{-210,6},{-202,6}},
                              color={0,0,127}));
              connect(add2.y, pm) annotation (Line(points={{193,0},{210,0}}, color={0,0,127}));
              annotation (
                Icon(graphics={Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0}),
                                           Text(
                      extent={{-60,0},{60,-80}},
                      lineColor={0,0,255},
                      textString="TGTypeIII"),Text(
                      extent={{-100,10},{-60,-10}},
                      lineColor={0,0,0},
                      textString="w"),  Text(
                      extent={{60,10},{100,-10}},
                      lineColor={0,0,0},
                      textString="pm"),
                    Text(
                      extent={{-80,80},{80,20}},
                      lineColor={0,0,0},
                      textString="%name")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Hydro Turbine (Linear model) and Governor (Standard model) - control scheme Type 3, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tetiana Bogodorova, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"),      Diagram(coordinateSystem(extent={{-240,-120},{200,80}})));
            end TGTypeIII;

            model TGTypeIV
              "Hydro Turbine (Linear model) and Governor (Standard model with PI controller)- control scheme Type 4"
              parameter Real wref "Reference speed (pu)";
              parameter Real Tg "Pilot valve droop (pu)";
              parameter Real gmax "Maximum gate opening (pu)";
              parameter Real gmin "Minimum gate opening (pu)";
              parameter Real vmax "Maxmimum gate opening rate (pu)";
              parameter Real vmin "Maximum gate opening rate (pu)";
              parameter Real Tp "Pilot valve time constant (s)";
              parameter Real Tr "Dashpot time constant (s)";
              parameter Real sigma "Permanent speed droop (p.u./p.u.)";
              parameter Real delta "Transient speed droop (p.u./p.u.)";
              parameter Real Tw "Water starting time (s)";
              parameter Real a11 "Deriv. of flow rate vs. turbine head";
              parameter Real a13 "Deriv. of flow rate vs. gate position";
              parameter Real a21 "Deriv. of torque vs. turbine head";
              parameter Real a23 "Deriv. of torque vs. gate position";
              parameter Real Kp "Proportional droop";
              parameter Real Ki "Integral droop";
              parameter Real Pref;
              Real deltaG "Gate position variation (pu)";
              Real v "Gate opening rate (pu)";
              Modelica.Blocks.Continuous.Integrator integrator3(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=int3)
                annotation (Placement(transformation(extent={{34,-6},{46,6}})));
              Modelica.Blocks.Math.Gain gain(k=1/(Tg*Tp))
                annotation (Placement(transformation(extent={{-56,-6},{-44,6}})));
              Modelica.Blocks.Math.Gain gain1(k=1/Tp) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-10,-20})));
              Modelica.Blocks.Continuous.Integrator integrator2(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=int2)
                annotation (Placement(transformation(extent={{-16,-6},{-4,6}})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{-36,-6},{-24,6}})));
              Modelica.Blocks.Math.Gain gain2(k=delta + sigma) annotation (Placement(
                    transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-12,20})));
              Modelica.Blocks.Math.Gain gain3(k=delta/Tr) annotation (Placement(
                    transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-44,-40})));
              Modelica.Blocks.Math.Gain gain5(k=1/Tr) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={-10,-60})));
              Modelica.Blocks.Continuous.Integrator integrator4(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=int4) annotation (Placement(transformation(
                    extent={{-6,6},{6,-6}},
                    rotation=180,
                    origin={-10,-40})));
              Modelica.Blocks.Math.Feedback feedback1 annotation (Placement(transformation(
                    extent={{-6,6},{6,-6}},
                    rotation=180,
                    origin={10,-40})));
              Modelica.Blocks.Math.Gain gain4(k=1/(a11*Tw)) annotation (Placement(
                    transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={110,-40})));
              Modelica.Blocks.Continuous.Integrator integrator5(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=int5) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={120,-20})));
              Modelica.Blocks.Math.Feedback feedback2 annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={100,-20})));
              Modelica.Blocks.Math.Gain G6(k=(a11*a23 - a13*a21)/a11)
                annotation (Placement(transformation(extent={{74,-6},{86,6}})));
              Modelica.Blocks.Math.Gain gain7(k=a13*a21/(a11*a11*Tw))
                annotation (Placement(transformation(extent={{74,-26},{86,-14}})));
              Modelica.Blocks.Interfaces.RealInput w "Rotor speed (pu)" annotation (
                  Placement(transformation(extent={{-240,-20},{-200,20}}),
                                                                      iconTransformation(
                      extent={{-140,-20},{-100,20}})));
              Modelica.Blocks.Interfaces.RealOutput Pm "Mechanical power (pu)" annotation (
                  Placement(transformation(extent={{160,-10},{180,10}}),
                                                                     iconTransformation(
                      extent={{100,-10},{120,10}})));
              Modelica.Blocks.Continuous.Integrator integrator1(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=int1)
                annotation (Placement(transformation(extent={{-126,-6},{-114,6}})));
              Modelica.Blocks.Math.Gain gain6(k=Ki)
                annotation (Placement(transformation(extent={{-146,-6},{-134,6}})));
              Modelica.Blocks.Math.Gain gain8(k=Kp)
                annotation (Placement(transformation(extent={{-146,14},{-134,26}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=vmax, uMin=vmin)
                annotation (Placement(transformation(extent={{14,-6},{26,6}})));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=gmax, uMin=gmin)
                annotation (Placement(transformation(extent={{54,-6},{66,6}})));
              Modelica.Blocks.Math.Add add1(k1=+1, k2=-1)
                annotation (Placement(transformation(extent={{-177,-7},{-163,7}})));
              Modelica.Blocks.Math.Add add2
                annotation (Placement(transformation(extent={{-101,-7},{-87,7}})));
              Modelica.Blocks.Math.Add3 add3_1(
                k1=-1,
                k2=+1,
                k3=+1) annotation (Placement(transformation(extent={{-77,-7},{-63,7}})));
              Modelica.Blocks.Math.Add add3
                annotation (Placement(transformation(extent={{144,-6},{156,6}})));
              Modelica.Blocks.Sources.Constant const1(k=wref)
                annotation (Placement(transformation(extent={{-196,4},{-184,16}})));
            protected
              parameter Real int1=sigma*Pref;
              parameter Real int2=0;
              parameter Real int3=Pref;
              parameter Real int4=Tr*Pref;
              parameter Real int5=a13*a21/a11*Pref;
            equation
              deltaG = limiter1.y;
              v = limiter.y;
              connect(gain1.y, feedback.u2) annotation (Line(
                  points={{-16.6,-20},{-30,-20},{-30,-4.8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback.y, integrator2.u) annotation (Line(
                  points={{-24.6,0},{-17.2,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain.y, feedback.u1) annotation (Line(
                  points={{-43.4,0},{-34.8,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain5.y, feedback1.u2) annotation (Line(
                  points={{-3.4,-60},{10,-60},{10,-44.8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback1.y, integrator4.u) annotation (Line(
                  points={{4.6,-40},{-2.8,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator4.y, gain3.u) annotation (Line(
                  points={{-16.6,-40},{-36.8,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain4.y, feedback2.u2) annotation (Line(
                  points={{103.4,-40},{100,-40},{100,-24.8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback2.y, integrator5.u) annotation (Line(
                  points={{105.4,-20},{112.8,-20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain7.y, feedback2.u1) annotation (Line(
                  points={{86.6,-20},{95.2,-20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain1.u, integrator2.y) annotation (Line(
                  points={{-2.8,-20},{2,-20},{2,0},{-3.4,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator4.y, gain5.u) annotation (Line(
                  points={{-16.6,-40},{-26,-40},{-26,-60},{-17.2,-60}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator5.y, gain4.u) annotation (Line(
                  points={{126.6,-20},{131.4,-20},{131.4,-40},{117.2,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain6.y, integrator1.u) annotation (Line(
                  points={{-133.4,0},{-127.2,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter.y, integrator3.u) annotation (Line(
                  points={{26.6,0},{32.8,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator2.y, limiter.u) annotation (Line(
                  points={{-3.4,0},{12.8,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator3.y, limiter1.u) annotation (Line(
                  points={{46.6,0},{52.8,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, gain2.u) annotation (Line(
                  points={{66.6,0},{70,0},{70,20},{-4.8,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, feedback1.u1) annotation (Line(
                  points={{66.6,0},{70,0},{70,-40},{14.8,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.y, gain8.u) annotation (Line(
                  points={{-162.3,8.88178e-16},{-153.65,8.88178e-16},{-153.65,20},{-147.2,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.y, gain6.u) annotation (Line(
                  points={{-162.3,8.88178e-16},{-147.2,8.88178e-16},{-147.2,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.u2, w) annotation (Line(
                  points={{-178.4,-4.2},{-180,-4.2},{-180,0},{-220,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator1.y, add2.u2) annotation (Line(
                  points={{-113.4,0},{-105.4,0},{-105.4,-4.2},{-102.4,-4.2}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add2.u1, gain8.y) annotation (Line(
                  points={{-102.4,4.2},{-106,4.2},{-106,20},{-133.4,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain2.y, add3_1.u1) annotation (Line(
                  points={{-18.6,20},{-84,20},{-84,5.6},{-78.4,5.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add2.y, add3_1.u2) annotation (Line(
                  points={{-86.3,8.88178e-16},{-78.4,8.88178e-16}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add3_1.u3, gain3.y) annotation (Line(
                  points={{-78.4,-5.6},{-84,-5.6},{-84,-40},{-50.6,-40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(G6.y, add3.u1) annotation (Line(
                  points={{86.6,0},{120,0},{120,3.6},{142.8,3.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator5.y, add3.u2) annotation (Line(
                  points={{126.6,-20},{131.3,-20},{131.3,-3.6},{142.8,-3.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add3.y, Pm) annotation (Line(
                  points={{156.6,0},{170,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, G6.u) annotation (Line(
                  points={{66.6,0},{72.8,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, gain7.u) annotation (Line(
                  points={{66.6,0},{70,0},{70,-20},{72.8,-20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(const1.y, add1.u1) annotation (Line(points={{-183.4,10},{-182,10},{-182,4},{-178,4},{-178,4.2},{-178.4,4.2}},
                                     color={0,0,127}));
              connect(add3_1.y, gain.u) annotation (Line(points={{-62.3,0},{-57.2,0}}, color={0,0,127}));
              annotation (
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0}),
                                           Text(
                      extent={{-60,0},{60,-80}},
                      lineColor={0,0,255},
                      textString="TGTypeIV"),Text(
                      origin={-80,0},
                      extent={{-20,10},{20,-10}},
                      fontName="Arial",
                      textString="w",
                      lineColor={0,0,0}),
                                        Text(
                      origin={80,0},
                      extent={{-20,10},{20,-10}},
                      fontName="Arial",
                      lineColor={0,0,0},
                      textString="pm"),
                    Text(
                      extent={{-80,80},{80,20}},
                      lineColor={0,0,0},
                      textString="%name")}),
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-200,-80},{160,40}})),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Hydro Turbine (Linear model) and Governor (Standard model) - control scheme Type 4, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tetiana Bogodorova, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end TGTypeIV;

            model TGTypeV
              "Hydro Turbine (Nonlinear model) and Governor (PI controller combined with servomotor)- control scheme Type 5"
              parameter Real Tg "Servomotor droop (pu)";
              parameter Real gmax "Maximum gate opening (pu)";
              parameter Real gmin "Minimum gate opening (pu)";
              parameter Real vmax "Maximum gate opening rate (pu)";
              parameter Real vmin "Minimum gate opening rate (pu)";
              parameter Real Tp "Pilot valve time constant (s)";
              parameter Real Tw "Water starting time (s)";
              parameter Real Kp "Proportional droop (p.u./p.u.)";
              parameter Real Ki "Integral droop (p.u./p.u.)";
              parameter Real sigma "Permanent speed droop (p.u./p.u.)";
              parameter Real Pref;
              Real G "Gate opening (pu)";
              Modelica.Blocks.Continuous.Integrator integrator(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=Pref)
                annotation (Placement(transformation(extent={{64,-6},{76,6}})));
              Modelica.Blocks.Math.Gain gain(k=1/Tg, y(start=0))
                annotation (Placement(transformation(extent={{24,-6},{36,6}})));
              Modelica.Blocks.Continuous.Integrator integrator3(initType=Modelica.Blocks.Types.Init.SteadyState,
                  y_start=Pref) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={190,0})));
              Modelica.Blocks.Math.Gain gain7(k=1/Tw)
                annotation (Placement(transformation(extent={{164,-6},{176,6}})));
              Modelica.Blocks.Math.MultiSum multiSum3(k={-1,1}, nu=2)
                annotation (Placement(transformation(extent={{144,-6},{156,6}})));
              Modelica.Blocks.Interfaces.RealInput w "Rotor speed (pu)" annotation (
                  Placement(transformation(extent={{-180,-10},{-160,10}}),
                                                                        iconTransformation(
                      extent={{-140,-20},{-100,20}})));
              Modelica.Blocks.Interfaces.RealOutput Pm "Power Pm (pu)" annotation (
                  Placement(transformation(extent={{220,-6},{232,6}}),iconTransformation(
                      extent={{100,-10},{120,10}})));
              Modelica.Blocks.Continuous.Integrator integrator4(initType=Modelica.Blocks.Types.Init.SteadyState,
                  y_start=Pref)
                annotation (Placement(transformation(extent={{-36,-6},{-24,6}})));
              Modelica.Blocks.Math.Gain Integral(k=Ki)
                annotation (Placement(transformation(extent={{-56,-6},{-44,6}})));
              Modelica.Blocks.Math.Gain gain9(k=1/Tp)
                annotation (Placement(transformation(extent={{-116,-6},{-104,6}})));
              Modelica.Blocks.Math.MultiSum multiSum6(      k={-1,1}, nu=2)
                annotation (Placement(transformation(extent={{-136,-6},{-124,6}})));
              Modelica.Blocks.Math.Gain gain6(k=sigma) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-110,20})));
              Modelica.Blocks.Continuous.Integrator integrator5(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=0)
                annotation (Placement(transformation(extent={{-76,-6},{-64,6}})));
              Modelica.Blocks.Math.Gain Proportional(k=Kp)
                annotation (Placement(transformation(extent={{-46,-26},{-34,-14}})));
              Modelica.Blocks.Math.Gain gain8(k=1/Tp) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-80,-20})));
              Modelica.Blocks.Math.Division division(y(start=1))
                annotation (Placement(transformation(extent={{108,-6},{120,6}})));
              Modelica.Blocks.Math.Product product1
                annotation (Placement(transformation(extent={{204,-6},{216,6}})));
              Modelica.Blocks.Math.MultiProduct square(nu=2) annotation (Placement(transformation(extent={{124,-6},{136,6}})));
              Modelica.Blocks.Sources.Constant one(k=1) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={130,-20})));
              Modelica.Blocks.Interfaces.RealInput pref "Reference power (pu)" annotation (Placement(transformation(extent={{-180,20},{-160,40}}), iconTransformation(extent={{-140,40},{-100,80}})));
              Modelica.Blocks.Math.Feedback p_feedback annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-80,20})));
              Modelica.Blocks.Nonlinear.Limiter limiter2(uMax=vmax, uMin=vmin)
                annotation (Placement(transformation(extent={{44,-6},{56,6}})));
              Modelica.Blocks.Nonlinear.Limiter limiter3(uMax=gmax, uMin=gmin)
                annotation (Placement(transformation(extent={{84,-6},{96,6}})));
              Modelica.Blocks.Math.Add add1
                annotation (Placement(transformation(extent={{-15,-5},{-5,5}})));
              Modelica.Blocks.Math.Add add2(k1=+1, k2=-1)
                annotation (Placement(transformation(extent={{4,-6},{16,6}})));
              Modelica.Blocks.Math.Add add3(k1=+1, k2=-1)
                annotation (Placement(transformation(extent={{-95,-5},{-85,5}})));
              Modelica.Blocks.Interfaces.RealInput wref "Reference rotor speed (pu)"
                annotation (Placement(transformation(extent={{-180,-30},{-160,-10}}),
                    iconTransformation(extent={{-140,-80},{-100,-40}})));
              Modelica.Blocks.Math.Feedback w_feedback annotation (Placement(transformation(extent={{-152,6},{-140,-6}})));
            equation
              G = limiter3.y;
              connect(division.y, square.u[1]) annotation (Line(
                  points={{120.6,0},{122,0},{122,2},{124,2},{124,2.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(division.y, square.u[2]) annotation (Line(
                  points={{120.6,0},{122,0},{122,-2},{124,-2},{124,-2.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(square.y, product1.u1) annotation (Line(
                  points={{137.02,0},{140,0},{140,12},{200,12},{200,3.6},{202.8,3.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(square.y, multiSum3.u[1]) annotation (Line(
                  points={{137.02,0},{144,0},{144,2.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(one.y, multiSum3.u[2]) annotation (Line(
                  points={{136.6,-20},{140,-20},{140,-2.1},{144,-2.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator3.y, division.u1) annotation (Line(
                  points={{196.6,0},{200,0},{200,-30},{102,-30},{102,3.6},{106.8,3.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter3.y, division.u2) annotation (Line(
                  points={{96.6,0},{100,0},{100,-3.6},{106.8,-3.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.y, p_feedback.u1) annotation (Line(
                  points={{-4.5,0},{0,0},{0,20},{-75.2,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(Proportional.y, add1.u2) annotation (Line(
                  points={{-33.4,-20},{-20,-20},{-20,-3},{-16,-3}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator4.y, add1.u1) annotation (Line(
                  points={{-23.4,0},{-20,0},{-20,3},{-16,3}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain8.y, add3.u2) annotation (Line(
                  points={{-86.6,-20},{-99,-20},{-99,-3},{-96,-3}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add3.y, integrator5.u) annotation (Line(
                  points={{-84.5,0},{-77.2,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add1.y, add2.u1) annotation (Line(points={{-4.5,0},{0,0},{0,3.6},{2.8,3.6}}, color={0,0,127}));
              connect(pref, p_feedback.u2) annotation (Line(points={{-170,30},{-80,30},{-80,24.8}}, color={0,0,127}));
              connect(wref, w_feedback.u1) annotation (Line(points={{-170,-20},{-154,-20},{-154,0},{-150.8,0}}, color={0,0,127}));
              connect(w, w_feedback.u2) annotation (Line(points={{-170,0},{-156,0},{-156,10},{-146,10},{-146,4.8}}, color={0,0,127}));
              connect(gain6.y, multiSum6.u[1]) annotation (Line(points={{-116.6,20},{-140,20},{-140,2.1},{-136,2.1}}, color={0,0,127}));
              connect(w_feedback.y, multiSum6.u[2]) annotation (Line(points={{-140.6,0},{-136,0},{-136,-2.1}}, color={0,0,127}));
              connect(multiSum6.y, gain9.u) annotation (Line(points={{-122.98,0},{-117.2,0}}, color={0,0,127}));
              connect(gain9.y, add3.u1) annotation (Line(points={{-103.4,0},{-100,0},{-100,3},{-96,3}}, color={0,0,127}));
              connect(gain6.u, p_feedback.y) annotation (Line(points={{-102.8,20},{-85.4,20}}, color={0,0,127}));
              connect(integrator5.y, gain8.u) annotation (Line(points={{-63.4,0},{-60,0},{-60,-20},{-72.8,-20}}, color={0,0,127}));
              connect(integrator5.y, Proportional.u) annotation (Line(points={{-63.4,0},{-60,0},{-60,-20},{-47.2,-20}}, color={0,0,127}));
              connect(integrator5.y, Integral.u) annotation (Line(points={{-63.4,0},{-57.2,0}}, color={0,0,127}));
              connect(Integral.y, integrator4.u) annotation (Line(points={{-43.4,0},{-37.2,0}}, color={0,0,127}));
              connect(limiter3.y, add2.u2) annotation (Line(points={{96.6,0},{100,0},{100,-20},{0,-20},{0,-3.6},{2.8,-3.6}}, color={0,0,127}));
              connect(gain.y, limiter2.u) annotation (Line(points={{36.6,0},{42.8,0}}, color={0,0,127}));
              connect(limiter2.y, integrator.u) annotation (Line(points={{56.6,0},{62.8,0}}, color={0,0,127}));
              connect(integrator.y, limiter3.u) annotation (Line(points={{76.6,0},{82.8,0}}, color={0,0,127}));
              connect(add2.y, gain.u) annotation (Line(points={{16.6,0},{22.8,0}}, color={0,0,127}));
              connect(gain7.y, integrator3.u) annotation (Line(points={{176.6,0},{182.8,0}}, color={0,0,127}));
              connect(multiSum3.y, gain7.u) annotation (Line(points={{157.02,0},{162.8,0}}, color={0,0,127}));
              connect(integrator3.y, product1.u2) annotation (Line(points={{196.6,0},{200,0},{200,-4},{202,-4},{202,-3.6},{202.8,-3.6}}, color={0,0,127}));
              connect(product1.y, Pm) annotation (Line(points={{216.6,0},{226,0}}, color={0,0,127}));
              annotation (
                Icon(coordinateSystem(extent={{-100,-100},{100,100}},preserveAspectRatio=
                        false), graphics={Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0}),
                                           Text(
                      extent={{-60,0},{62,-82}},
                      lineColor={0,0,255},
                      textString="TGTypeV"),Text(
                      origin={-80,0},
                      extent={{-20,-10},{20,10}},
                      textString="w",
                      lineColor={0,0,0}),
                                        Text(
                      origin={80,0},
                      extent={{-20,-10},{20,10}},
                      lineColor={0,0,0},
                      textString="pm"),  Text(
                      origin={-80,62},
                      extent={{-20,-10},{20,10}},
                      lineColor={0,0,0},
                      textString="pref"),Text(
                      origin={-80,-60},
                      extent={{-20,10},{20,-10}},
                      lineColor={0,0,0},
                      textString="wref"),
                    Text(
                      extent={{-60,80},{60,20}},
                      lineColor={0,0,0},
                      textString="%name")}),
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-160,-40},{220,40}})),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Hydro Turbine (Linear model) and Governor (Standard model) - control scheme Type 5, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tetiana Bogodorova, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end TGTypeV;

            model TGTypeVI
              "Hydro Turbine (Nonlinear model) and Governor (PID controller combined with servomotor)- control scheme Type 6"
              parameter Real gmax "Maximum gate opening (pu)";
              parameter Real gmin "Minimum gate opening (pu)";
              parameter Real vmax "Maximum gate opening rate (pu)";
              parameter Real vmin "Minimum gate opening rate (pu)";
              parameter Real Ta "Pilot valve time constant (s)";
              parameter Real Tw "Water starting time (s)";
              parameter Real beta "Transient speed droop (p.u./p.u.)";
              parameter Real Kp "Proportional droop (p.u./p.u.)";
              parameter Real Ki "Integral droop (p.u./p.u.)";
              parameter Real Kd "Derivative droop (p.u./p.u.)";
              parameter Real Td "Derivative droop time constant (s)";
              parameter Real Rp "Permanent droop (p.u./p.u.)";
              parameter Real Ka;
              parameter Real dref;
              parameter Real po;
              Real G "Gate opening (pu)";
              Modelica.Blocks.Continuous.Integrator integrator(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=po*(gmax - gmin))
                annotation (Placement(transformation(extent={{-8,14},{4,26}})));
              Modelica.Blocks.Sources.Constant one(k=1) annotation (Placement(transformation(
                    extent={{6,6},{-6,-6}},
                    rotation=180,
                    origin={110,0})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{-176,-36},{-164,-24}})));
              Modelica.Blocks.Continuous.Integrator integrator3(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=po) annotation (Placement(transformation(
                    extent={{6,6},{-6,-6}},
                    rotation=180,
                    origin={170,20})));
              Modelica.Blocks.Math.MultiSum multiSum3(nu=2, k={1,-1})
                annotation (Placement(transformation(extent={{104,14},{116,26}})));
              Modelica.Blocks.Interfaces.RealOutput Pm "Mechanical power (pu)" annotation (
                  Placement(transformation(extent={{200,10},{220,30}}),iconTransformation(
                      extent={{100,-10},{120,10}})));
              Modelica.Blocks.Math.Gain gain9(k=Kp)
                annotation (Placement(transformation(extent={{-116,34},{-104,46}})));
              Modelica.Blocks.Math.MultiSum multiSum5(      k={1,1,1}, nu=3)
                annotation (Placement(transformation(extent={{-76,14},{-64,26}})));
              Modelica.Blocks.Math.Feedback feedback1
                annotation (Placement(transformation(extent={{-146,14},{-134,26}})));
              Modelica.Blocks.Math.Gain gain6(k=Rp) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=90,
                    origin={-140,0})));
              Modelica.Blocks.Math.Feedback w_fb annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={-160,20})));
              Modelica.Blocks.Continuous.Integrator integrator5(initType=Modelica.Blocks.Types.Init.NoInit,
                  y_start=po*(gmax - gmin))
                annotation (Placement(transformation(extent={{-96,14},{-84,26}})));
              Modelica.Blocks.Math.Gain Proportional(k=beta)
                annotation (Placement(transformation(extent={{64,44},{76,56}})));
              Modelica.Blocks.Math.Gain gain8(k=Ki) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={-110,20})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=vmax, uMin=vmin)
                annotation (Placement(transformation(extent={{-26,14},{-14,26}})));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=gmax, uMin=gmin)
                annotation (Placement(transformation(extent={{10,14},{22,26}})));
              Modelica.Blocks.Math.Division division
                annotation (Placement(transformation(extent={{64,14},{76,26}})));
              Modelica.Blocks.Math.Product product1
                annotation (Placement(transformation(extent={{184,14},{196,26}})));
              Modelica.Blocks.Math.MultiProduct square(nu=2) annotation (Placement(transformation(extent={{84,14},{96,26}})));
              Modelica.Blocks.Interfaces.RealInput pe "Active power (pu)" annotation (
                  Placement(transformation(extent={{-200,-40},{-180,-20}}),
                    iconTransformation(extent={{-140,-50},{-100,-10}})));
              Modelica.Blocks.Continuous.Derivative derivative(k=Kd, T=Td)
                annotation (Placement(transformation(extent={{-106,-6},{-94,6}})));
              Modelica.Blocks.Continuous.TransferFunction transferFunction(a={Ta,1}, b={Ka})
                annotation (Placement(transformation(extent={{-44,14},{-32,26}})));
              Modelica.Blocks.Math.Feedback servo_fb
                annotation (Placement(transformation(extent={{-60,14},{-48,26}})));
              Modelica.Blocks.Math.Gain Gain10(k=1/(gmax - gmin))
                annotation (Placement(transformation(extent={{42,14},{54,26}})));
              Modelica.Blocks.Math.MultiSum multiSum4(nu=2, k={-1,1}) annotation (Placement(
                    transformation(
                    extent={{6,6},{-6,-6}},
                    rotation=180,
                    origin={130,20})));
              Modelica.Blocks.Math.Gain gain7(k=1/Tw) annotation (Placement(transformation(
                    extent={{6,6},{-6,-6}},
                    rotation=180,
                    origin={150,20})));
              Modelica.Blocks.Logical.Switch switch1 annotation (Placement(transformation(
                    extent={{-4,4},{4,-4}},
                    rotation=90,
                    origin={-140,-16})));
              Modelica.Blocks.Math.RealToBoolean realToBoolean(threshold=0.5) annotation (
                  Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-130,-40})));
              Modelica.Blocks.Sources.Constant const(k=dref) annotation (Placement(
                    transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=180,
                    origin={-110,-40})));
              Modelica.Blocks.Interfaces.RealInput pref "Active power reference (pu)"
                annotation (Placement(transformation(extent={{-200,-60},{-180,-40}}),
                    iconTransformation(extent={{-140,-100},{-100,-60}})));
              Modelica.Blocks.Interfaces.RealInput wref "Rotor speed reference (pu)"
                annotation (Placement(transformation(extent={{-200,10},{-180,30}}),
                    iconTransformation(extent={{-140,100},{-100,60}})));
              Modelica.Blocks.Interfaces.RealInput we "Rotor speed (pu)" annotation (
                  Placement(transformation(extent={{-200,-10},{-180,10}}),
                                                                         iconTransformation(
                      extent={{-140,10},{-100,50}})));
            equation
              G = Gain10.y;
              connect(division.y, square.u[1]) annotation (Line(
                  points={{76.6,20},{80,20},{80,22},{84,22},{84,22.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(division.y, square.u[2]) annotation (Line(
                  points={{76.6,20},{80,20},{80,18},{84,18},{84,17.9}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(square.y, multiSum3.u[1]) annotation (Line(
                  points={{97.02,20},{104,20},{104,22.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(product1.y, Pm) annotation (Line(
                  points={{196.6,20},{210,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain8.y, integrator5.u) annotation (Line(
                  points={{-103.4,20},{-97.2,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback1.y, gain9.u) annotation (Line(
                  points={{-134.6,20},{-129,20},{-129,40},{-117.2,40}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback1.y, gain8.u) annotation (Line(
                  points={{-134.6,20},{-117.2,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(feedback1.y, derivative.u) annotation (Line(
                  points={{-134.6,20},{-129,20},{-129,0},{-107.2,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, Gain10.u) annotation (Line(
                  points={{22.6,20},{40.8,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(Proportional.y, multiSum3.u[2]) annotation (Line(
                  points={{76.6,50},{100,50},{100,22},{104,22},{104,17.9}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(multiSum3.y, multiSum4.u[1]) annotation (Line(
                  points={{117.02,20},{124,20},{124,22.1}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(one.y, multiSum4.u[2]) annotation (Line(
                  points={{116.6,0},{120,0},{120,18},{124,18},{124,17.9}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(multiSum4.y, gain7.u) annotation (Line(
                  points={{137.02,20},{142.8,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(gain7.y, integrator3.u) annotation (Line(
                  points={{156.6,20},{162.8,20}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(multiSum3.y, product1.u1) annotation (Line(
                  points={{117.02,20},{120.09,20},{120.09,34},{180,34},{180,23.6},{182.8,23.6}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(switch1.y, gain6.u) annotation (Line(
                  points={{-140,-11.6},{-140,-7.2}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(limiter1.y, switch1.u1) annotation (Line(
                  points={{22.6,20},{30,20},{30,-26},{-136.8,-26},{-136.8,-20.8}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(w_fb.y, Proportional.u) annotation (Line(
                  points={{-154.6,20},{-150,20},{-150,50},{62.8,50}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(integrator3.y, division.u1) annotation (Line(points={{176.6,20},{180,20},{180,-10},{60,-10},{60,23.6},{62.8,23.6}},
                                                                                                                                        color={0,0,127}));
              connect(limiter1.y, servo_fb.u2) annotation (Line(points={{22.6,20},{30,20},{30,6},{-54,6},{-54,15.2}},
                                                                                                                    color={0,0,127}));
              connect(we, w_fb.u2) annotation (Line(points={{-190,0},{-160,0},{-160,15.2}}, color={0,0,127}));
              connect(wref, w_fb.u1) annotation (Line(points={{-190,20},{-164.8,20}}, color={0,0,127}));
              connect(feedback.y, switch1.u3) annotation (Line(points={{-164.6,-30},{-143.2,-30},{-143.2,-20.8}}, color={0,0,127}));
              connect(pe, feedback.u1) annotation (Line(points={{-190,-30},{-174.8,-30}}, color={0,0,127}));
              connect(pref, feedback.u2) annotation (Line(points={{-190,-50},{-170,-50},{-170,-34.8}}, color={0,0,127}));
              connect(switch1.u2, realToBoolean.y) annotation (Line(points={{-140,-20.8},{-140,-40},{-136.6,-40}}, color={255,0,255}));
              connect(realToBoolean.u, const.y) annotation (Line(points={{-122.8,-40},{-116.6,-40}}, color={0,0,127}));
              connect(feedback1.u2, gain6.y) annotation (Line(points={{-140,15.2},{-140,6.6}}, color={0,0,127}));
              connect(w_fb.y, feedback1.u1) annotation (Line(points={{-154.6,20},{-144.8,20}}, color={0,0,127}));
              connect(gain9.y, multiSum5.u[1]) annotation (Line(points={{-103.4,40},{-80,40},{-80,22},{-76,22},{-76,22.8}}, color={0,0,127}));
              connect(integrator5.y, multiSum5.u[2]) annotation (Line(points={{-83.4,20},{-80,20},{-80,20},{-76,20}}, color={0,0,127}));
              connect(derivative.y, multiSum5.u[3]) annotation (Line(points={{-93.4,0},{-80,0},{-80,18},{-76,18},{-76,17.2}}, color={0,0,127}));
              connect(multiSum5.y, servo_fb.u1) annotation (Line(points={{-62.98,20},{-58.8,20}}, color={0,0,127}));
              connect(servo_fb.y, transferFunction.u) annotation (Line(points={{-48.6,20},{-45.2,20}}, color={0,0,127}));
              connect(transferFunction.y, limiter.u) annotation (Line(points={{-31.4,20},{-27.2,20}}, color={0,0,127}));
              connect(limiter.y, integrator.u) annotation (Line(points={{-13.4,20},{-9.2,20}}, color={0,0,127}));
              connect(integrator.y, limiter1.u) annotation (Line(points={{4.6,20},{8.8,20}}, color={0,0,127}));
              connect(Gain10.y, division.u2) annotation (Line(points={{54.6,20},{58,20},{58,16.4},{62.8,16.4}}, color={0,0,127}));
              connect(integrator3.y, product1.u2) annotation (Line(points={{176.6,20},{180,20},{180,16.4},{182.8,16.4}}, color={0,0,127}));
              annotation (
                Icon(coordinateSystem(extent={{-100,-100},{100,100}},preserveAspectRatio=
                        false), graphics={Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,0}),
                                           Text(
                      extent={{-60,-20},{60,-80}},
                      lineColor={0,0,255},
                      textString="TGTypeVI"),Text(
                      extent={{-100,90},{-60,70}},
                      lineColor={0,0,0},
                      textString="wref"),Text(
                      extent={{-100,40},{-60,20}},
                      lineColor={0,0,0},
                      textString="we"),Text(
                      extent={{-100,-20},{-60,-40}},
                      lineColor={0,0,0},
                      textString="pe"),  Text(
                      extent={{-100,-70},{-60,-90}},
                      lineColor={0,0,0},
                      textString="pref"),Text(
                      extent={{60,10},{100,-10}},
                      lineColor={0,0,0},
                      textString="pm"),
                    Text(
                      extent={{-60,80},{60,20}},
                      lineColor={0,0,0},
                      textString="%name")}),
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-180,-60},{200,60}})),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Hydro Turbine (Linear model) and Governor (Standard model) - control scheme Type 6, PSAT Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tetiana Bogodorova, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end TGTypeVI;
          annotation (Documentation(info="<html>
</html>"));
          end TG;

          package AVR
            model AVRTypeI "PSAT AVR Type 1"

              Modelica.Blocks.Interfaces.RealInput v "Generator termminal voltage (pu)"
                annotation (Placement(transformation(extent={{-140,-80},{-100,-40}}),
                    iconTransformation(extent={{-140,-80},{-100,-40}})));
              Modelica.Blocks.Interfaces.RealOutput vf "Filed voltage (pu)" annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={110,0}), iconTransformation(extent={{100,-20},{140,20}})));
              Modelica.Blocks.Interfaces.RealInput vref
                "Reference generator terminal voltage (pu)" annotation (Placement(
                    transformation(extent={{-140,40},{-100,80}}), iconTransformation(extent=
                       {{-140,40},{-100,80}})));
              parameter Real vrmax=7.57 "Maximum regulator voltage (pu)";
              parameter Real vrmin=0 "Minimum regulator voltage (pu)";
              parameter Real K0=7.04 "Regulator gain, (pu/pu)";
              parameter Real T1=6.67 "First pole (s)";
              parameter Real T2=1 "First zero (s)";
              parameter Real T3=1 "Second pole (s";
              parameter Real T4=1 "Second pole (s)";
              parameter Real Te=0.4 "Field circuit time constant (s)";
              parameter Real Tr=0.05 "Measurement time constant (s)";
              parameter Real Ae=0.0006 "1st ceiling coefficient";
              parameter Real Be=0.9 "2nd ceiling coefficient";
              parameter Real v0=1 "Initialization (pu)";
            protected
              parameter Real vf00(fixed=false) "Initialization";
              parameter Real vr0=vf00 - Ae*Modelica.Math.exp(Be*abs(vf00)) "Initialization";
            public
              Modelica.Blocks.Interfaces.RealOutput vref0 "Voltage reference at t=0 (pu)"
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={0,110}), iconTransformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={0,120})));
              Modelica.Blocks.Interfaces.RealInput vf0
                "Reference generator terminal voltage (pu)" annotation (Placement(
                    transformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={0,-112}), iconTransformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={0,-120})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{26,10},{46,-10}})));
              Modelica.Blocks.Continuous.FirstOrder firstOrder(
                y_start=vf00,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                k=1,
                T=Te) annotation (Placement(transformation(extent={{52,-10},{72,10}})));
              NonElectrical.Nonlinear.CeilingBlock ceilingBlock
                annotation (Placement(transformation(extent={{70,30},{50,50}})));
              Modelica.Blocks.Continuous.FirstOrder firstOrder2(
                k=1,
                T=Tr,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=v0)
                annotation (Placement(transformation(extent={{-90,-70},{-70,-50}})));
              Modelica.Blocks.Math.Feedback feedback2
                annotation (Placement(transformation(extent={{-70,-10},{-50,10}})));
              Modelica.Blocks.Continuous.TransferFunction transferFunction(
                b={(K0*T2*T4),K0*(T2 + T4),K0},
                a={(T1*T3),(T1 + T3),1},
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=vr0)
                annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=vrmax, uMin=vrmin)
                annotation (Placement(transformation(extent={{-8,-10},{12,10}})));
            initial algorithm
              vf00 := vf0;
            algorithm
              vref0 := v0 + (vr0/K0);

            equation
              connect(firstOrder.y, vf)
                annotation (Line(points={{73,0},{88,0},{110,0}}, color={0,0,127}));
              connect(ceilingBlock.u, vf) annotation (Line(points={{72,40},{80,40},{80,0},{
                      110,0}}, color={0,0,127}));
              connect(ceilingBlock.y, feedback.u2)
                annotation (Line(points={{49,40},{36,40},{36,8}}, color={0,0,127}));
              connect(v, firstOrder2.u) annotation (Line(points={{-120,-60},{-106,-60},{-92,
                      -60}}, color={0,0,127}));
              connect(feedback2.u2, firstOrder2.y) annotation (Line(points={{-60,-8},{-60,-8},
                      {-60,-60},{-69,-60}}, color={0,0,127}));
              connect(feedback2.u1, vref) annotation (Line(points={{-68,0},{-80,0},{-80,60},
                      {-120,60}}, color={0,0,127}));
              connect(feedback.y, firstOrder.u)
                annotation (Line(points={{45,0},{47.5,0},{50,0}}, color={0,0,127}));
              connect(feedback2.y, transferFunction.u)
                annotation (Line(points={{-51,0},{-46.5,0},{-42,0}}, color={0,0,127}));
              connect(transferFunction.y, limiter.u)
                annotation (Line(points={{-19,0},{-14.5,0},{-10,0}}, color={0,0,127}));
              connect(limiter.y, feedback.u1)
                annotation (Line(points={{13,0},{28,0}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    initialScale=0.1,
                    preserveAspectRatio=false)),
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    initialScale=0.1,
                    preserveAspectRatio=false), graphics={Rectangle(
                      extent={{-100,100},{100,-100}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-90,80},{-50,40}},
                      lineColor={0,0,255},
                      textString="vref"),Text(
                      extent={{-100,-40},{-60,-70}},
                      lineColor={0,0,255},
                      textString="v"),Text(
                      extent={{60,20},{100,-20}},
                      lineColor={0,0,255},
                      textString="vf"),Text(
                      extent={{-40,40},{40,-40}},
                      lineColor={0,0,255},
                      textString="AVR1"),Text(
                      extent={{16,-60},{56,-100}},
                      lineColor={0,0,255},
                      textString="vf0
"),            Text(  extent={{2,102},{42,62}},
                      lineColor={0,0,255},
                      textString="vref0")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>AVR Type II, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end AVRTypeI;

            model AVRTypeII "PSAT AVR Type 2"

              Modelica.Blocks.Interfaces.RealInput v "Generator termminal voltage (pu)"
                annotation (Placement(transformation(extent={{-140,-80},{-100,-40}}),
                    iconTransformation(extent={{-140,-80},{-100,-40}})));
              Modelica.Blocks.Interfaces.RealOutput vf "Filed voltage (pu)" annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={110,0}), iconTransformation(extent={{100,-20},{140,20}})));
              Modelica.Blocks.Interfaces.RealInput vref
                "Reference generator terminal voltage (pu)" annotation (Placement(
                    transformation(extent={{-140,40},{-100,80}}), iconTransformation(extent=
                       {{-140,40},{-100,80}})));
              parameter Modelica.SIunits.PerUnit vrmin=-5 "Minimum regulator voltage (pu)";
              parameter Modelica.SIunits.PerUnit vrmax=5 "Maximum regulator voltage (pu)";
              parameter Real Ka=100 "Amplifier gain (pu/pu)";
              parameter Modelica.SIunits.Time Ta=0.5 "Amplifier time constant (s)";
              parameter Real Kf=0.15 "Stabilizer gain (pu/pu)";
              parameter Modelica.SIunits.Time Tf=0.1 "Stabilizer time constant (s)";
              parameter Real Ke=0 "Field circuit integral deviation (pu/pu)";
              parameter Modelica.SIunits.Time Te=0.2 "Field circuit time constant (s)";
              parameter Modelica.SIunits.Time Tr=0.001 "Measurement time constant (s)";
              parameter Real Ae=0.0006 "1st ceiling coefficient";
              parameter Real Be=0.9 "2nd ceiling coefficient";
              parameter Modelica.SIunits.PerUnit v0=1 "Initial measured voltage";
            protected
              parameter Modelica.SIunits.PerUnit vfstate=vr10 - (Ae*Modelica.Math.exp(Be*
                  abs(vf00))*vf00);
              parameter Modelica.SIunits.PerUnit vf00(fixed=false) "Initialization of vf";
              parameter Modelica.SIunits.PerUnit vr10=Ke*vf00 + Ae*Modelica.Math.exp(Be*abs(
                  vf00))*vf00 "Initialization";
              parameter Modelica.SIunits.PerUnit vr20=-vf00*Kf/Tf "Initialization";
            public
              Modelica.Blocks.Interfaces.RealOutput vref0 "Voltage reference at t=0 (pu)"
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={0,110}), iconTransformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={0,120})));
              Modelica.Blocks.Interfaces.RealInput vf0
                "Reference generator terminal voltage (pu)" annotation (Placement(
                    transformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={0,-112}), iconTransformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={0,-120})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{30,10},{50,-10}})));
              Modelica.Blocks.Continuous.TransferFunction ExcitationSystem(
                y_start=vf00,
                a={Te,Ke},
                x_start={vfstate},
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{52,-10},{72,10}})));
              NonElectrical.Nonlinear.CeilingBlock ceilingBlock(Ae=Ae, Be=Be)
                annotation (Placement(transformation(extent={{72,30},{52,50}})));
              Modelica.Blocks.Continuous.Derivative derivativeBlock(
                y_start=0,
                initType=Modelica.Blocks.Types.Init.SteadyState,
                T=Tf,
                x_start=vf00,
                k=Kf) annotation (Placement(transformation(extent={{72,-50},{52,-30}})));
              Modelica.Blocks.Math.Feedback feedback1
                annotation (Placement(transformation(extent={{-50,-10},{-30,10}})));
              Modelica.Blocks.Continuous.FirstOrder firstOrder2(
                k=1,
                T=Tr,
                y_start=v0,
                initType=Modelica.Blocks.Types.Init.SteadyState) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-60,-34})));
              Modelica.Blocks.Math.Feedback Verr
                annotation (Placement(transformation(extent={{-70,-10},{-50,10}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                outMax=vrmax,
                outMin=vrmin,
                K=Ka,
                T=Ta,
                y_start=vr10)
                annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
            initial algorithm
              vf00 := vf0;
            algorithm
              vref0 := v0 + vr10/Ka;

            equation
              connect(ExcitationSystem.y, vf)
                annotation (Line(points={{73,0},{88,0},{110,0}}, color={0,0,127}));
              connect(ceilingBlock.y, feedback.u2)
                annotation (Line(points={{51,40},{40,40},{40,8}}, color={0,0,127}));
              connect(v, firstOrder2.u) annotation (Line(points={{-120,-60},{-60,-60},{-60,
                      -46}}, color={0,0,127}));
              connect(Verr.u2, firstOrder2.y)
                annotation (Line(points={{-60,-8},{-60,-23}}, color={0,0,127}));
              connect(Verr.y, feedback1.u1)
                annotation (Line(points={{-51,0},{-48,0}}, color={0,0,127}));
              connect(Verr.u1, vref) annotation (Line(points={{-68,0},{-80,0},{-80,60},{-120,
                      60}}, color={0,0,127}));
              connect(feedback.y, ExcitationSystem.u)
                annotation (Line(points={{49,0},{49,0},{50,0}}, color={0,0,127}));
              connect(ceilingBlock.u, vf) annotation (Line(points={{74,40},{80,40},{80,0},{
                      110,0}}, color={0,0,127}));
              connect(derivativeBlock.u, vf) annotation (Line(points={{74,-40},{86,-40},{86,
                      0},{110,0}}, color={0,0,127}));
              connect(feedback1.u2, derivativeBlock.y) annotation (Line(points={{-40,-8},{-40,
                      -8},{-40,-40},{51,-40}}, color={0,0,127}));
              connect(feedback1.y, simpleLagLim.u)
                annotation (Line(points={{-31,0},{-12,0}}, color={0,0,127}));
              connect(simpleLagLim.y, feedback.u1)
                annotation (Line(points={{11,0},{11,0},{32,0}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    initialScale=0.1,
                    preserveAspectRatio=false), graphics={Text(
                      extent={{32,-28},{46,-36}},
                      lineColor={28,108,200},
                      textString="vr2"),Text(
                      extent={{-2,0},{-8,12}},
                      lineColor={28,108,200},
                      textString="vr1"),Text(
                      extent={{-72,-14},{-64,-20}},
                      lineColor={28,108,200},
                      textString="Vm"),Text(
                      extent={{24,12},{30,2}},
                      lineColor={28,108,200},
                      textString="vr")}),
                Icon(coordinateSystem(
                    extent={{-100,-100},{100,100}},
                    initialScale=0.1,
                    preserveAspectRatio=false), graphics={Rectangle(
                      extent={{-100,100},{100,-100}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-90,80},{-50,40}},
                      lineColor={0,0,255},
                      textString="vref"),Text(
                      extent={{-100,-40},{-60,-70}},
                      lineColor={0,0,255},
                      textString="v"),Text(
                      extent={{60,20},{100,-20}},
                      lineColor={0,0,255},
                      textString="vf"),Text(
                      extent={{-40,40},{40,-40}},
                      lineColor={0,0,255},
                      textString="AVR2"),Text(
                      extent={{16,-60},{56,-100}},
                      lineColor={0,0,255},
                      textString="vf0
"),            Text(  extent={{2,102},{42,62}},
                      lineColor={0,0,255},
                      textString="vref0")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>AVR Type II, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end AVRTypeII;

            model AVRtypeIII
              parameter Real vfmax=5;
              parameter Real vfmin=-5;
              parameter Real K0=20 "regulator gain";
              parameter Real T2=0.1 "regulator pole";
              parameter Real T1=0.45 "Regulator zero";
              parameter Real Te=0.1 "Field circuit time constant";
              parameter Real Tr=0.0015 "Measurement time constant";
              Real vm;
              Real vr;
              Real vf1;
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=vfmax, uMin=vfmin)
                annotation (Placement(visible=true, transformation(
                    origin={5,0},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealInput v(start=1) annotation (Placement(
                  visible=true,
                  transformation(
                    origin={-119.972,50},
                    extent={{-20.0,-20.0},{20.0,20.0}},
                    rotation=0),
                  iconTransformation(
                    origin={-110,60},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealOutput vf annotation (Placement(
                  visible=true,
                  transformation(
                    origin={130,0},
                    extent={{-10.0,-10.0},{10.0,10.0}},
                    rotation=0),
                  iconTransformation(
                    origin={130,0},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              Modelica.Blocks.Interfaces.RealInput vs annotation (Placement(transformation(
                      extent={{-140,-82},{-100,-42}}), iconTransformation(extent={{-120,-70},
                        {-100,-50}})));
              Modelica.Blocks.Interfaces.RealInput vf0(start=1) annotation (Placement(
                  visible=true,
                  transformation(
                    origin={0.028,120},
                    extent={{-20.0,-20.0},{20.0,20.0}},
                    rotation=-90),
                  iconTransformation(
                    origin={0,110},
                    extent={{-10,-10},{10,10}},
                    rotation=-90)));
            protected
              parameter Real vref(fixed=false);
              parameter Real s0(fixed=false);
            initial equation
              vref = v;
              s0 = vs;
              vf1 = vf0;
              vm = v;
              vr = K0*(1 - T1/T2)*(vref + vs - vm);
            equation
              der(vm) = (v - vm)/Tr;
              der(vr) = (K0*(1 - T1/T2)*(vref + vs - vm) - vr)/T2;
              der(vf1) = ((vr + K0*(T1/T2)*(vref + vs - vm) + vf0)*(1 + s0*(v/vm - 1)) -
                vf1)/Te;
              limiter1.u = vf1;
              limiter1.y = vf;
              annotation (
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-120,-120},{120,
                        120}}), graphics={Rectangle(
                      extent={{-120,120},{120,-120}},
                      lineColor={0,0,255},
                      fillColor={255,255,255},
                      fillPattern=FillPattern.Solid),Text(
                      extent={{-104,72},{-72,50}},
                      lineColor={0,0,255},
                      textString="v"),Text(
                      extent={{-100,-48},{-68,-70}},
                      lineColor={0,0,255},
                      textString="vs"),Text(
                      extent={{88,10},{120,-12}},
                      lineColor={0,0,255},
                      textString="vf"),Text(
                      extent={{-34,36},{42,-24}},
                      lineColor={0,0,255},
                      textString="AVRTypeIII"),Text(
                      extent={{-16,100},{16,78}},
                      lineColor={0,0,255},
                      textString="vf0")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td><p>AVR Type III, PSAT Manual 2.1.8</p></td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>September 2015</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Joan Russinol, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"),      Diagram(coordinateSystem(extent={{-120,-120},{120,120}})));
            end AVRtypeIII;
          annotation (Documentation);
          end AVR;

          package OEL
            model OEL "PSATs Over-Excitation Limiter"
              outer OpenIPSL.Electrical.SystemBase SysData;
              Modelica.Blocks.Interfaces.RealInput v "Generator terminal voltage (pu)"
                annotation (Placement(transformation(extent={{-112,50},{-92,70}}),
                    iconTransformation(extent={{-104,48},{-80,72}})));
              Modelica.Blocks.Interfaces.RealInput p "Active power (pu)" annotation (
                  Placement(transformation(extent={{-112,-10},{-92,10}}),
                    iconTransformation(extent={{-104,8},{-80,32}})));
              Modelica.Blocks.Interfaces.RealInput q "Reactive power (pu)" annotation (
                  Placement(transformation(extent={{-112,-70},{-92,-50}}),
                    iconTransformation(extent={{-104,-32},{-80,-8}})));
              FieldCurrent field_current(xd=Z_MBtoSB*xd, xq=Z_MBtoSB*xq)
                annotation (Placement(transformation(extent={{-40,-32},{-20,-8}})));
              Modelica.Blocks.Interfaces.RealOutput v_ref annotation (Placement(
                    transformation(extent={{94,-10},{114,10}}), iconTransformation(extent={
                        {92,-12},{116,12}})));
              parameter Modelica.SIunits.Time T0=10 "Integrator time constant (s)";
              parameter Modelica.SIunits.PerUnit xd
                "d-axis estimated generator reactance (pu, machine base)";
              parameter Modelica.SIunits.PerUnit xq
                "q-axis estimated generator reactance (pu, machine base)";
              parameter Modelica.SIunits.PerUnit if_lim
                "Maximum field current (pu, system base)";
              parameter Modelica.SIunits.PerUnit vOEL_max
                "Maximum output signal (pu, machine base)";
              parameter OpenIPSL.Types.ApparentPowerMega Sn=SysData.S_b
                "Power rating (MVA)"
                annotation (Dialog(group="Machine parameters"));
              parameter OpenIPSL.Types.VoltageKilo Vn=V_b "Voltage rating (kV)"
                annotation (Dialog(group="Machine parameters"));
              parameter OpenIPSL.Types.VoltageKilo V_b=400
                "Base voltage of the bus (kV)";
            protected
              parameter Real Z_MBtoSB=(SysData.S_b*Vn^2)/(Sn*V_b^2)
                "Z(machine base) -> Z(system base)";
              parameter Real I_MBtoSB=(Sn*V_b)/(SysData.S_b*Vn)
                "I(machine base) -> I(system base)";
            public
              Modelica.Blocks.Math.Feedback add
                annotation (Placement(transformation(extent={{-10,-30},{10,-10}})));
              Modelica.Blocks.Sources.Constant currentLimit(k=if_lim) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={0,-60})));
              Modelica.Blocks.Continuous.LimIntegrator limIntegrator(
                k=1/T0,
                outMax=vOEL_max,
                outMin=0,
                strict=true)
                annotation (Placement(transformation(extent={{22,-30},{42,-10}})));
              Modelica.Blocks.Interfaces.RealInput v_ref0 "Generator terminal voltage (pu)"
                annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=-90,
                    origin={0,110}), iconTransformation(
                    extent={{-12,-12},{12,12}},
                    rotation=-90,
                    origin={-2,112})));
              Modelica.Blocks.Math.Feedback difference annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,0})));
            equation
              connect(field_current.ifield, add.u1)
                annotation (Line(points={{-19,-20},{-19,-20},{-8,-20}}, color={0,0,127}));
              connect(currentLimit.y, add.u2) annotation (Line(points={{8.88178e-016,-49},{
                      8.88178e-016,-38},{8.88178e-016,-28},{0,-28}}, color={0,0,127}));
              connect(v_ref, difference.y)
                annotation (Line(points={{104,0},{89,0}}, color={0,0,127}));
              connect(field_current.v, v) annotation (Line(points={{-40,-12.8},{-60,-12.8},
                      {-60,60},{-102,60}},color={0,0,127}));
              connect(limIntegrator.y, difference.u2) annotation (Line(points={{43,-20},{44,
                      -20},{80,-20},{80,-8}}, color={0,0,127}));
              connect(difference.u1, v_ref0) annotation (Line(points={{72,0},{72,0},{40,0},
                      {40,60},{0,60},{0,110}},color={0,0,127}));
              connect(p, field_current.p) annotation (Line(points={{-102,0},{-102,0},{-80,0},
                      {-80,-20},{-40,-20}}, color={0,0,127}));
              connect(q, field_current.q) annotation (Line(points={{-102,-60},{-60,-60},{-60,
                      -27.2},{-40,-27.2}}, color={0,0,127}));
              connect(add.y, limIntegrator.u)
                annotation (Line(points={{9,-20},{9,-20},{20,-20}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-100,100},{100,-100}},
                      lineColor={0,0,255}),Text(
                      extent={{-88,82},{-50,46}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="v"),Text(
                      extent={{-84,42},{-50,8}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="p"),Text(
                      extent={{-82,-2},{-54,-36}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="q"),Text(
                      extent={{10,98},{46,66}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="vref0"),Text(
                      extent={{60,-4},{94,-38}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="v_ref"),Text(
                      extent={{-26,38},{36,-40}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="OXL")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Over Excitation Limiter, PSAT manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end OEL;

            model FieldCurrent
              "Estimates the field current from P,Q,V and the d- and q-axis reactances"

              Modelica.Blocks.Interfaces.RealInput v "generator terminal voltage (pu)"
                annotation (Placement(transformation(extent={{-70,30},{-50,50}}),
                    iconTransformation(extent={{-116,43},{-84,77}})));
              Modelica.Blocks.Interfaces.RealInput p "active power (pu)" annotation (
                  Placement(transformation(extent={{-70,-10},{-50,10}}), iconTransformation(
                      extent={{-117,-17},{-83,17}})));
              Modelica.Blocks.Interfaces.RealInput q "reactive power (pu)" annotation (
                  Placement(transformation(extent={{-70,-50},{-50,-30}}),
                    iconTransformation(extent={{-117,-77},{-83,-43}})));
              Modelica.Blocks.Interfaces.RealOutput ifield "estimated field current (pu)"
                annotation (Placement(transformation(extent={{96,-10},{116,10}}),
                    iconTransformation(extent={{94,-17},{126,17}})));
              parameter Real xd;
              parameter Real xq;
            protected
              Real gamma_p;
              Real gamma_q;
            equation
              gamma_p = xq*p/v;
              gamma_q = xq*q/v;
              ifield = sqrt((v + gamma_q)^2 + p^2) + ((xd/xq - 1)*(gamma_q*(v + gamma_q) +
                gamma_p^2)/sqrt((v + gamma_q)^2 + p^2));

              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-100,100},{100,-100}},
                      lineColor={0,0,255}),Text(
                      extent={{-90,80},{-58,60}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="v"),Text(
                      extent={{-90,-44},{-62,-60}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="p"),Text(
                      extent={{-88,16},{-60,0}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="q"),Text(
                      extent={{64,16},{92,0}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="if")}),
                Documentation);
            end FieldCurrent;
          annotation (Documentation);
          end OEL;

          package PSS
            model PSSTypeII "PSAT PSS TypeII"
              parameter Real vsmax "Max stabilizer output signal (pu)";
              parameter Real vsmin "Min stabilizer output signal (pu)";
              parameter Real Kw "Stabilizer gain (pu/pu)";
              parameter Real Tw "Wash-out time constant (s)";
              parameter Real T1 "First stabilizer time constant (s)";
              parameter Real T2 "Second stabilizer time constant (s)";
              parameter Real T3 "Third stabilizer time constant (s)";
              parameter Real T4 "Fourth stabilizer time constant (s)";
              Modelica.Blocks.Interfaces.RealInput vSI "PSS input signal "
                annotation (Placement(transformation(extent={{-130,-20},{-90,20}})));
              Modelica.Blocks.Interfaces.RealOutput vs "PSS output signal"
                annotation (Placement(transformation(extent={{100,-10},{120,10}})));
              NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T1,
                T2=T2,
                y_start=0)
                annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
              NonElectrical.Continuous.LeadLag imLeadLag1(
                K=1,
                T1=T3,
                T2=T4,
                y_start=0) annotation (Placement(transformation(extent={{28,-10},{48,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=vsmax, uMin=vsmin)
                annotation (Placement(transformation(extent={{60,-10},{80,10}})));
              NonElectrical.Continuous.DerivativeLag derivativeLag(
                K=Kw*Tw,
                T=Tw,
                y_start=0,
                x_start=0)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
            equation
              connect(vs, limiter.y)
                annotation (Line(points={{110,0},{96,0},{81,0}}, color={0,0,127}));
              connect(imLeadLag1.y, limiter.u)
                annotation (Line(points={{49,0},{53.5,0},{58,0}}, color={0,0,127}));
              connect(imLeadLag.y, imLeadLag1.u)
                annotation (Line(points={{11,0},{26,0}}, color={0,0,127}));
              connect(vSI, derivativeLag.u)
                annotation (Line(points={{-110,0},{-62,0},{-62,0}}, color={0,0,127}));
              connect(derivativeLag.y, imLeadLag.u)
                annotation (Line(points={{-39,0},{-12,0},{-12,0}}, color={0,0,127}));
              annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                        -100},{100,100}})), Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS Type II, PSAT manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-08-24</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end PSSTypeII;
          annotation (Documentation(info="<html>
</html>"));
          end PSS;
        annotation (Documentation);
        end PSAT;

        package Simulink
          package OEL
            model OEL "OverExcitation Limiter"
              parameter Real ifd_lim "OEL parameter";
              parameter Real r "OEL parameter";
              parameter Real f "OEL parameter";
              parameter Real L1 "OEL parameter";
              parameter Real init_OEL_Timer=L1 "Initial output value";
              Modelica.Blocks.Sources.Constant ifd_lim_value(k=ifd_lim)
                "Limitation of filed current"
                annotation (Placement(transformation(extent={{-98,-28},{-80,-10}})));
              OpenIPSL.NonElectrical.Nonlinear.SaturationBlockTan block_1_1(r=r, f=f)
                annotation (Placement(transformation(extent={{-42,-16},{18,38}})));
              Modelica.Blocks.Continuous.LimIntegrator Timer(
                k=1,
                y_start=init_OEL_Timer,
                outMax=10000.0,
                outMin=L1,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{10,8},{24,22}})));
              Modelica.Blocks.Math.Gain imGain(k=-1)
                annotation (Placement(transformation(extent={{10,28},{22,40}})));
              Modelica.Blocks.Interfaces.RealInput ifd "Field current" annotation (
                  Placement(transformation(extent={{-94,-4},{-76,16}}), iconTransformation(
                      extent={{-94,-4},{-76,16}})));
              Modelica.Blocks.Interfaces.RealInput VolContinput "Voltage control input"
                annotation (Placement(transformation(extent={{-94,-48},{-76,-28}}),
                    iconTransformation(extent={{-94,-48},{-76,-28}})));
              Modelica.Blocks.Interfaces.RealOutput OEL_output annotation (Placement(
                    transformation(extent={{74,-30},{94,-10}}), iconTransformation(extent={
                        {74,-30},{94,-10}})));
              Modelica.Blocks.Math.Add add(k2=-1)
                annotation (Placement(transformation(extent={{-60,0},{-40,20}})));
              Modelica.Blocks.Math.Min min
                annotation (Placement(transformation(extent={{68,6},{78,16}})));
              NonElectrical.Logical.Relay relay
                annotation (Placement(transformation(extent={{40,8},{52,20}})));
            equation
              connect(ifd_lim_value.y, add.u2) annotation (Line(points={{-79.1,-19},{-68,-19},
                      {-68,4},{-62,4}}, color={0,0,127}));
              connect(ifd, add.u1) annotation (Line(points={{-85,6},{-72,6},{-72,16},{-62,
                      16}}, color={0,0,127}));
              connect(add.y, block_1_1.p1) annotation (Line(points={{-39,10},{-36,10},{-36,
                      11},{-47,11}}, color={0,0,127}));
              connect(imGain.u, block_1_1.p1) annotation (Line(points={{8.8,34},{-36,34},{-36,
                      11},{-47,11}}, color={0,0,127}));
              connect(block_1_1.n1, Timer.u) annotation (Line(points={{21,11},{5.5,11},{5.5,
                      15},{8.6,15}}, color={0,0,127}));
              connect(min.y, OEL_output)
                annotation (Line(points={{78.5,11},{84,11},{84,-20}}, color={0,0,127}));
              connect(VolContinput, min.u2) annotation (Line(points={{-85,-38},{-12,-38},{
                      60,-38},{60,8},{67,8}}, color={0,0,127}));
              connect(relay.y, min.u1)
                annotation (Line(points={{53.2,14},{67,14},{67,14}}, color={0,0,127}));
              connect(Timer.y, relay.u1) annotation (Line(points={{24.7,15},{30,15},{30,
                      18.5},{38.5,18.5}}, color={0,0,127}));
              connect(imGain.y, relay.u2) annotation (Line(points={{22.6,34},{32,34},{32,14},
                      {38.5,14}}, color={0,0,127}));
              connect(relay.u3, min.u2) annotation (Line(points={{38.5,9.5},{32,9.5},{32,-38},
                      {60,-38},{60,8},{67,8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-74,26},{74,-62}}, lineColor={
                      0,0,127}),Text(
                      extent={{-84,6},{-36,-14}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="ifd"),Text(
                      extent={{-86,-38},{-40,-54}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="V"),Text(
                      extent={{-52,6},{58,-42}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="OEL")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Over Excitation Limiter</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end OEL;
          annotation (Documentation);
          end OEL;

          package PSS
            model PSS "Power system stabilizer"
              parameter Real Kp "Washout gain";
              parameter Real Tw "Washout time constant";
              parameter Real T1 "Lead-lag filter time constant";
              parameter Real T2 "Lead-lag filter time constant";
              parameter Real C "PSS output limiation";
              parameter Real init_PSS_Leadlag1=0 "initial output value";
              parameter Real init_PSS_Leadlag2=0 "initial output value";
              Modelica.Blocks.Interfaces.RealInput omega "Speed" annotation (Placement(
                    transformation(extent={{-106,12},{-94,24}}), iconTransformation(extent=
                        {{-100,8},{-88,20}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag Leadlag1(
                K=1,
                T1=T1,
                T2=T2,
                y_start=init_PSS_Leadlag1) annotation (Placement(transformation(
                      extent={{-22,4},{-4,22}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag Leadlag2(
                K=1,
                T1=T1,
                T2=T2,
                y_start=init_PSS_Leadlag2)
                annotation (Placement(transformation(extent={{4,4},{22,22}})));
              Modelica.Blocks.Interfaces.RealOutput Upss "PSS output" annotation (Placement(
                    transformation(extent={{56,6},{68,18}}), iconTransformation(extent={{56,
                        6},{68,18}})));
              Modelica.Blocks.Nonlinear.Limiter limit(uMin=-C, uMax=C)
                annotation (Placement(transformation(extent={{30,4},{48,22}})));
              Modelica.Blocks.Math.Gain imGain(k=Kp/Tw)
                annotation (Placement(transformation(extent={{-90,12},{-78,24}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag(
                K=1,
                T=Tw,
                y_start=0) annotation (Placement(transformation(extent={{-68,10},
                        {-52,26}})));
              Modelica.Blocks.Math.Add add(k1=-1)
                annotation (Placement(transformation(extent={{-46,4},{-28,22}})));
            equation
              connect(limit.y, Upss) annotation (Line(points={{48.9,13},{51.45,13},{51.45,
                      12},{62,12}}, color={0,0,127}));
              connect(Leadlag2.y, limit.u)
                annotation (Line(points={{22.9,13},{22.9,13},{28.2,13}}, color={0,0,127}));
              connect(Leadlag1.y, Leadlag2.u)
                annotation (Line(points={{-3.1,13},{-3.1,13},{2.2,13}}, color={0,0,127}));
              connect(add.y, Leadlag1.u) annotation (Line(points={{-27.1,13},{-25.55,13},{-23.8,
                      13}}, color={0,0,127}));
              connect(omega, imGain.u)
                annotation (Line(points={{-100,18},{-96,18},{-91.2,18}}, color={0,0,127}));
              connect(imSimpleLag.y, add.u1) annotation (Line(points={{-51.2,18},{-47.8,18},
                      {-47.8,18.4}}, color={0,0,127}));
              connect(imGain.y, imSimpleLag.u) annotation (Line(points={{-77.4,18},{-69.6,
                      18},{-69.6,18}}, color={0,0,127}));
              connect(add.u2, imSimpleLag.u) annotation (Line(points={{-47.8,7.6},{-74,7.6},
                      {-74,18},{-69.6,18}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-88,44},{56,-18}}, lineColor={
                      0,0,255}),Text(
                      extent={{-44,28},{22,-2}},
                      lineColor={0,0,255},
                      textString="PSS"),Text(
                      extent={{-86,24},{-62,4}},
                      lineColor={0,0,255},
                      textString="omega"),Text(
                      extent={{34,20},{54,0}},
                      lineColor={0,0,255},
                      textString="Upss")}),
                Documentation);
            end PSS;
          annotation (Documentation);
          end PSS;

          package ES
            model ExcitationSystem
              "This ES is composed by the OEL and PSS and exitation part"
              parameter Real V0=1 "Reference value of terminal voltage";
              parameter Real L2=4 "Exciter parameter";
              parameter Real G=70 "Exciter parameter";
              parameter Real Ta=10 "Exciter parameter";
              parameter Real Tb=20 "Exciter parameter";
              parameter Real vfd0 "Initial Filed voltage";
              parameter Real r "OEL parameter";
              parameter Real f "OEL parameter";
              parameter Real L1 "OEL parameter";
              parameter Real ifd_lim "OEL parameter";
              parameter Real Kp "Washout gain";
              parameter Real Tw "Washout time constant";
              parameter Real T1 "Lead-lag filter time constant";
              parameter Real T2 "Lead-lag filter time constant";
              parameter Real C "PSS output limiation";
              OpenIPSL.Electrical.Controls.Simulink.OEL.OEL oEL(
                init_OEL_Timer=0,
                ifd_lim=ifd_lim,
                r=r,
                f=f,
                L1=L1) annotation (Placement(transformation(extent={{-28,40},{
                        20,76}})));
              Modelica.Blocks.Sources.Constant V_0(k=V0) "Reference terminal voltage "
                annotation (Placement(transformation(extent={{-88,34},{-70,52}})));
              Modelica.Blocks.Interfaces.RealInput ifd "Field current"
                annotation (Placement(transformation(extent={{-96,62},{-84,74}})));
              Modelica.Blocks.Interfaces.RealInput V "Terminal voltage "
                annotation (Placement(transformation(extent={{-96,22},{-84,34}})));
              Modelica.Blocks.Interfaces.RealInput omega "Speed"
                annotation (Placement(transformation(extent={{-96,-10},{-84,2}})));
              Modelica.Blocks.Interfaces.RealOutput vfd "Field voltage"
                annotation (Placement(transformation(extent={{128,22},{140,34}})));
              Modelica.Blocks.Math.Gain Ka(k=10)
                annotation (Placement(transformation(extent={{88,48},{100,60}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator(
                outMin=0,
                outMax=L2,
                k=1,
                y_start=vfd0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{108,46},{124,62}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag tgr(
                K=G,
                T1=Ta,
                T2=Tb,
                y_start=vfd0) "Transient gain rudection" annotation (Placement(
                    transformation(extent={{36,44},{56,64}})));
              OpenIPSL.Electrical.Controls.Simulink.PSS.PSS pSS(
                Kp=Kp,
                Tw=Tw,
                T1=T1,
                T2=T2,
                C=C) annotation (Placement(transformation(extent={{-78,-28},{-44,
                        14}})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{62,44},{82,64}})));
              Modelica.Blocks.Math.Add3 add3_1(k2=-1)
                annotation (Placement(transformation(extent={{-46,18},{-26,38}})));
            equation
              connect(oEL.ifd, ifd) annotation (Line(
                  points={{-24.4,59.08},{-77.44,59.08},{-77.44,68},{-90,68}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(omega, pSS.omega) annotation (Line(
                  points={{-90,-4},{-84,-4},{-84,-4.06},{-76.98,-4.06}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(imLimitedIntegrator.y, vfd)
                annotation (Line(points={{124.8,54},{134,54},{134,28}}, color={0,0,127}));
              connect(Ka.y, imLimitedIntegrator.u) annotation (Line(points={{100.6,54},{
                      106.4,54},{106.4,54}}, color={0,0,127}));
              connect(oEL.OEL_output, tgr.u) annotation (Line(points={{16.16,54.4},{25.08,
                      54.4},{25.08,54},{34,54}}, color={0,0,127}));
              connect(feedback.y, Ka.u)
                annotation (Line(points={{81,54},{86.8,54},{86.8,54}}, color={0,0,127}));
              connect(tgr.y, feedback.u1)
                annotation (Line(points={{57,54},{64,54},{64,54}}, color={0,0,127}));
              connect(feedback.u2, vfd) annotation (Line(points={{72,46},{72,40},{134,40},{
                      134,28}}, color={0,0,127}));
              connect(V, add3_1.u2)
                annotation (Line(points={{-90,28},{-74,28},{-48,28}}, color={0,0,127}));
              connect(V_0.y, add3_1.u1)
                annotation (Line(points={{-69.1,43},{-48,43},{-48,36}}, color={0,0,127}));
              connect(pSS.Upss, add3_1.u3) annotation (Line(points={{-50.46,-4.48},{-48,-4.48},
                      {-48,20}}, color={0,0,127}));
              connect(add3_1.y, oEL.VolContinput) annotation (Line(points={{-25,28},{-18,28},
                      {-18,42},{-24.4,42},{-24.4,51.16}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        140,100}})),
                Icon(coordinateSystem(extent={{-100,-100},{140,100}}, preserveAspectRatio=
                        false), graphics={Rectangle(extent={{-84,78},{128,-20}}, lineColor=
                      {0,0,255}),Text(
                      extent={{-80,72},{-62,60}},
                      lineColor={0,0,255},
                      textString="ifd"),Text(
                      extent={{-80,34},{-62,22}},
                      lineColor={0,0,255},
                      textString="V "),Text(
                      extent={{-78,2},{-54,-12}},
                      lineColor={0,0,255},
                      textString="omega"),Text(
                      extent={{106,36},{130,22}},
                      lineColor={0,0,255},
                      textString="vfd"),Text(
                      extent={{-34,58},{88,0}},
                      lineColor={0,0,255},
                      textString="Exciter AVR OEL PSS")}),
                Documentation);
            end ExcitationSystem;

            model ExcitationSystemKp0 "Excitation system without PSS included"
              parameter Real V0=1 "Reference value of terminal voltage";
              parameter Real L2=4 "Exciter parameter";
              parameter Real G=70 "Exciter parameter";
              parameter Real Ta=10 "Exciter parameter";
              parameter Real Tb=20 "Exciter parameter";
              parameter Real vfd0 "Initial Filed voltage";
              parameter Real r "OEL parameter";
              parameter Real f "OEL parameter";
              parameter Real L1 "OEL parameter";
              parameter Real ifd_lim "OEL parameter";
              OpenIPSL.Electrical.Controls.Simulink.OEL.OEL oEL(
                init_OEL_Timer=0,
                ifd_lim=ifd_lim,
                r=r,
                f=f,
                L1=L1) annotation (Placement(transformation(extent={{-28,40},{
                        20,76}})));
              Modelica.Blocks.Sources.Constant V_0(k=V0) "Reference terminal voltage "
                annotation (Placement(transformation(extent={{-88,34},{-70,52}})));
              Modelica.Blocks.Interfaces.RealInput ifd "Field current"
                annotation (Placement(transformation(extent={{-96,62},{-84,74}})));
              Modelica.Blocks.Interfaces.RealInput V "Terminal voltage "
                annotation (Placement(transformation(extent={{-96,22},{-84,34}})));
              Modelica.Blocks.Interfaces.RealOutput vfd "Field voltage"
                annotation (Placement(transformation(extent={{128,22},{140,34}})));
              Modelica.Blocks.Math.Gain Ka(k=10)
                annotation (Placement(transformation(extent={{92,48},{104,60}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator(
                outMin=0,
                outMax=L2,
                k=1,
                y_start=vfd0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{110,46},{126,62}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag tgr(
                K=G,
                T1=Ta,
                T2=Tb,
                y_start=vfd0) "Transient gain rudection" annotation (Placement(
                    transformation(extent={{32,44},{52,64}})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{62,44},{82,64}})));
              Modelica.Blocks.Math.Add add(k2=-1)
                annotation (Placement(transformation(extent={{-58,26},{-38,46}})));
            equation
              connect(oEL.ifd, ifd) annotation (Line(
                  points={{-24.4,59.08},{-77.44,59.08},{-77.44,68},{-90,68}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(imLimitedIntegrator.y, vfd)
                annotation (Line(points={{126.8,54},{134,54},{134,28}}, color={0,0,127}));
              connect(imLimitedIntegrator.u, Ka.y) annotation (Line(points={{108.4,54},{106,
                      54},{104.6,54}}, color={0,0,127}));
              connect(oEL.OEL_output, tgr.u) annotation (Line(points={{16.16,54.4},{23.08,
                      54.4},{23.08,54},{30,54}}, color={0,0,127}));
              connect(feedback.y, Ka.u)
                annotation (Line(points={{81,54},{90.8,54},{90.8,54}}, color={0,0,127}));
              connect(feedback.u2, vfd) annotation (Line(points={{72,46},{72,40},{134,40},{
                      134,28}}, color={0,0,127}));
              connect(tgr.y, feedback.u1)
                annotation (Line(points={{53,54},{58.5,54},{64,54}}, color={0,0,127}));
              connect(V_0.y, add.u1) annotation (Line(points={{-69.1,43},{-64.55,43},{-64.55,
                      42},{-60,42}}, color={0,0,127}));
              connect(V, add.u2) annotation (Line(points={{-90,28},{-76,28},{-76,30},{-60,
                      30}}, color={0,0,127}));
              connect(add.y, oEL.VolContinput) annotation (Line(points={{-37,36},{-34,36},{
                      -34,40},{-34,51.16},{-24.4,51.16}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        140,100}})),
                Icon(coordinateSystem(extent={{-100,-100},{140,100}}, preserveAspectRatio=
                        false), graphics={Rectangle(extent={{-84,78},{128,-20}}, lineColor=
                      {0,0,255}),Text(
                      extent={{-80,72},{-62,60}},
                      lineColor={0,0,255},
                      textString="ifd"),Text(
                      extent={{-80,34},{-62,22}},
                      lineColor={0,0,255},
                      textString="V "),Text(
                      extent={{106,36},{130,22}},
                      lineColor={0,0,255},
                      textString="vfd"),Text(
                      extent={{-34,58},{88,0}},
                      lineColor={0,0,255},
                      textString="Exciter AVR OEL PSS")}),
                Documentation);
            end ExcitationSystemKp0;
          annotation (Documentation);
          end ES;

          package TG
            model TurbineTm "Hydraulic turbine model. Mechanical torque as output"
              Modelica.Blocks.Interfaces.RealInput z "Gate openning" annotation (Placement(
                    transformation(extent={{-95,2},{-88,10}}), iconTransformation(extent={{
                        -92,20},{-78,34}})));
              Modelica.Blocks.Sources.Constant Hs(k=1)
                annotation (Placement(transformation(extent={{-74,-12},{-58,4}})));
              Modelica.Blocks.Math.Gain Tw(k=1/1) "Water time constant"
                annotation (Placement(transformation(extent={{0,-8},{20,12}})));
              Modelica.Blocks.Continuous.Integrator imIntegrator(
                k=1,
                y_start=init_Turbine_V1,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{28,-6},{44,10}})));
              Modelica.Blocks.Interfaces.RealInput Omega "Rotor speed in p.u" annotation (
                  Placement(transformation(extent={{-96,-26},{-90,-18}}),
                    iconTransformation(extent={{-92,-22},{-78,-8}})));
              Modelica.Blocks.Interfaces.RealOutput Tm "Mechanical Torque Tm as output"
                annotation (Placement(transformation(extent={{106,-2},{112,6}}),
                    iconTransformation(extent={{30,-4},{46,14}})));
              parameter Real init_Turbine_V1;
              Modelica.Blocks.Math.Product product
                annotation (Placement(transformation(extent={{52,-6},{68,10}})));
              Modelica.Blocks.Math.Division division
                annotation (Placement(transformation(extent={{84,-6},{100,10}})));
              Modelica.Blocks.Math.Add add(k1=-1)
                annotation (Placement(transformation(extent={{-28,-8},{-8,12}})));
              Modelica.Blocks.Math.Division division1
                annotation (Placement(transformation(extent={{-78,14},{-64,28}})));
              Modelica.Blocks.Math.Product product1
                annotation (Placement(transformation(extent={{-52,14},{-38,28}})));
            equation
              connect(Tw.y, imIntegrator.u)
                annotation (Line(points={{21,2},{21,2},{26.4,2}}, color={0,0,127}));
              connect(imIntegrator.y, product.u2) annotation (Line(points={{44.8,2},{48,2},
                      {48,-2.8},{50.4,-2.8}}, color={0,0,127}));
              connect(division.y, Tm)
                annotation (Line(points={{100.8,2},{109,2}}, color={0,0,127}));
              connect(product.y, division.u1) annotation (Line(points={{68.8,2},{76,2},{76,
                      6.8},{82.4,6.8}}, color={0,0,127}));
              connect(division.u2, Omega) annotation (Line(points={{82.4,-2.8},{76,-2.8},{
                      76,-22},{-93,-22}}, color={0,0,127}));
              connect(add.y, Tw.u)
                annotation (Line(points={{-7,2},{-5.55,2},{-2,2}}, color={0,0,127}));
              connect(Hs.y, add.u2) annotation (Line(points={{-57.2,-4},{-57.2,-4},{-30,-4}},
                    color={0,0,127}));
              connect(product1.y, add.u1) annotation (Line(points={{-37.3,21},{-34,21},{-34,
                      8},{-30,8}}, color={0,0,127}));
              connect(division1.y, product1.u1) annotation (Line(points={{-63.3,21},{-58,21},
                      {-58,25.2},{-53.4,25.2}}, color={0,0,127}));
              connect(product1.u2, product1.u1) annotation (Line(points={{-53.4,16.8},{-58,
                      16.8},{-58,25.2},{-53.4,25.2}}, color={0,0,127}));
              connect(division1.u1, imIntegrator.y) annotation (Line(points={{-79.4,25.2},{
                      -84,25.2},{-84,46},{44.8,46},{44.8,2}}, color={0,0,127}));
              connect(z, division1.u2) annotation (Line(points={{-91.5,6},{-84,6},{-84,16.8},
                      {-79.4,16.8}}, color={0,0,127}));
              connect(product.u1, add.u1) annotation (Line(points={{50.4,6.8},{46,6.8},{46,
                      28},{-34,28},{-34,8},{-30,8}}, color={0,0,127}));
              annotation (
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-78,46},{32,-44}}, lineColor={
                      0,0,255}),Text(
                      extent={{-78,32},{-64,20}},
                      lineColor={0,0,255},
                      textString="z"),Text(
                      extent={{-76,-8},{-56,-28}},
                      lineColor={0,0,255},
                      textString="omega"),Text(
                      extent={{18,14},{28,0}},
                      lineColor={0,0,255},
                      textString="Tm"),Text(
                      extent={{-52,18},{8,-20}},
                      lineColor={0,0,255},
                      textString="Hy turbine")}),
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics={Text(
                      extent={{-96,0},{-80,-2}},
                      lineColor={0,0,127},
                      textString="z (gate opening)"),Text(
                      extent={{-96,-28},{-80,-30}},
                      lineColor={0,0,127},
                      textString="w (rotor speed)"),Text(
                      extent={{102,10},{128,8}},
                      lineColor={0,0,127},
                      textString="Tm (mech. torque)"),Text(
                      extent={{52,14},{70,14}},
                      lineColor={0,0,127},
                      textString="Pm (mech. power)"),Text(
                      extent={{-8,-6},{22,-8}},
                      lineColor={0,0,127},
                      textString="1/Tw (water time constant)")}),
                Documentation);
            end TurbineTm;

            model TurbinePm "Hydraulic turbine model. Mechanical Power Pm as output"
              parameter Real p0 "Initialization, initial electrical power";
              Modelica.Blocks.Interfaces.RealInput z "Gate openning" annotation (Placement(
                    transformation(extent={{-95,2},{-88,10}}), iconTransformation(extent={{
                        -92,-6},{-78,8}})));
              Modelica.Blocks.Sources.Constant Hs(k=1) "set point"
                annotation (Placement(transformation(extent={{-78,-14},{-58,6}})));
              Modelica.Blocks.Math.Gain Tw(k=1) "Water constant"
                annotation (Placement(transformation(extent={{-16,0},{0,16}})));
              Modelica.Blocks.Continuous.Integrator imIntegrator(
                k=1,
                y_start=p0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{12,0},{28,16}})));
              Modelica.Blocks.Interfaces.RealOutput Pm "Mechanical power" annotation (
                  Placement(transformation(extent={{88,2},{94,10}}), iconTransformation(
                      extent={{32,-6},{48,12}})));
              Modelica.Blocks.Math.Product product1
                annotation (Placement(transformation(extent={{-54,26},{-40,40}})));
              Modelica.Blocks.Math.Division division1
                annotation (Placement(transformation(extent={{-80,26},{-66,40}})));
              Modelica.Blocks.Math.Add add(k1=-1)
                annotation (Placement(transformation(extent={{-46,-2},{-26,18}})));
              Modelica.Blocks.Math.Product product
                annotation (Placement(transformation(extent={{42,4},{58,20}})));
            equation
              connect(division1.y, product1.u1) annotation (Line(points={{-65.3,33},{-60,33},
                      {-60,37.2},{-55.4,37.2}}, color={0,0,127}));
              connect(product1.u2, product1.u1) annotation (Line(points={{-55.4,28.8},{-60,
                      28.8},{-60,37.2},{-55.4,37.2}}, color={0,0,127}));
              connect(Tw.y, imIntegrator.u)
                annotation (Line(points={{0.8,8},{6,8},{10.4,8}}, color={0,0,127}));
              connect(add.y, Tw.u)
                annotation (Line(points={{-25,8},{-17.6,8},{-17.6,8}}, color={0,0,127}));
              connect(Hs.y, add.u2) annotation (Line(points={{-57,-4},{-54,-4},{-54,2},{-48,
                      2}}, color={0,0,127}));
              connect(imIntegrator.y, product.u2) annotation (Line(points={{28.8,8},{34,8},
                      {34,7.2},{40.4,7.2}}, color={0,0,127}));
              connect(product.y, Pm) annotation (Line(points={{58.8,12},{74,12},{74,6},{91,
                      6}}, color={0,0,127}));
              connect(product.u1, product1.y) annotation (Line(points={{40.4,16.8},{34,16.8},
                      {34,33},{-39.3,33}}, color={0,0,127}));
              connect(division1.u1, product.u2) annotation (Line(points={{-81.4,37.2},{-88,
                      37.2},{-88,50},{32,50},{32,8},{34,8},{34,7.2},{40.4,7.2}}, color={0,0,
                      127}));
              connect(division1.u2, z) annotation (Line(points={{-81.4,28.8},{-84,28.8},{-84,
                      6},{-91.5,6}}, color={0,0,127}));
              connect(add.u1, product1.y) annotation (Line(points={{-48,14},{-56,14},{-56,
                      24},{-34,24},{-34,33},{-39.3,33}}, color={0,0,127}));
              annotation (
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{100,
                        100}}), graphics={Rectangle(extent={{-78,46},{32,-44}}, lineColor={
                      0,0,255}),Text(
                      extent={{-78,10},{-64,-2}},
                      lineColor={0,0,255},
                      textString="z"),Text(
                      extent={{20,10},{30,-4}},
                      lineColor={0,0,255},
                      textString="Pm"),Text(
                      extent={{-52,18},{8,-20}},
                      lineColor={0,0,255},
                      textString="Hy turbine")}),
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        100,100}}), graphics={Text(
                      extent={{-28,40},{-12,38}},
                      lineColor={0,0,127},
                      textString="q (water flow)"),Text(
                      extent={{-28,28},{-14,26}},
                      lineColor={0,0,127},
                      textString="H (head)"),Text(
                      extent={{60,12},{78,12}},
                      lineColor={0,0,127},
                      textString="Pm (mech. power)"),Text(
                      extent={{-98,-4},{-82,4}},
                      lineColor={0,0,127},
                      textString="z (gate opening)")}),
                Documentation);
            end TurbinePm;

            model Governor "Speed governor model for hydro turbines"
              Modelica.Blocks.Interfaces.RealInput Omega "Rotor speed in p.u" annotation (
                  Placement(transformation(extent={{-96,26},{-86,38}}), iconTransformation(
                      extent={{-14,30},{-4,40}})));
              Modelica.Blocks.Sources.Constant Omega_n(k=1) "Nominal rotor speed in p.u"
                annotation (Placement(transformation(extent={{-94,6},{-82,18}})));
              Modelica.Blocks.Math.Gain Gain1(k=2)
                annotation (Placement(transformation(extent={{10,18},{24,32}})));
              Modelica.Blocks.Math.Gain Gain2(k=0.4)
                annotation (Placement(transformation(extent={{10,0},{24,14}})));
              Modelica.Blocks.Continuous.Integrator Integrator(
                k=1,
                y_start=p0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{30,0},{44,14}})));
              Modelica.Blocks.Math.Gain Droop(k=D) "Permanent speed droop" annotation (
                  Placement(transformation(
                    extent={{5.5,-5.5},{-5.5,5.5}},
                    rotation=270,
                    origin={-53.5,6.5})));
              Modelica.Blocks.Math.Gain Gain3(k=5)
                annotation (Placement(transformation(extent={{92,10},{106,24}})));
              Modelica.Blocks.Nonlinear.Limiter Limited(uMin=-0.1, uMax=0.1)
                annotation (Placement(transformation(extent={{112,10},{126,24}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator(
                outMax=1,
                k=1,
                outMin=0,
                y_start=p0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{132,10},{146,24}})));
              Modelica.Blocks.Interfaces.RealOutput z "Gate opening" annotation (Placement(
                    transformation(extent={{156,12},{166,22}}), iconTransformation(extent={
                        {148,12},{158,22}})));
              parameter Real D "Permanent speed droop, g19=g20=0.08, all others=0.04";
              parameter Real p0 "Initialization, initial electrical power";
              Modelica.Blocks.Interfaces.RealInput Pm_set annotation (Placement(
                    transformation(
                    extent={{5,-6},{-5,6}},
                    rotation=180,
                    origin={-90,-17}), iconTransformation(
                    extent={{5,-6},{-5,6}},
                    rotation=180,
                    origin={-10,14})));
              Modelica.Blocks.Interfaces.RealInput Pe annotation (Placement(transformation(
                    extent={{5,-6},{-5,6}},
                    rotation=180,
                    origin={-90,-33}), iconTransformation(
                    extent={{5,-6},{-5,6}},
                    rotation=180,
                    origin={-10,-8})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag SimpleLag1(
                K=1,
                T=2,
                y_start=p0) annotation (Placement(transformation(extent={{-72,-40},
                        {-58,-26}})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{68,6},{88,26}})));
              Modelica.Blocks.Math.Add add(k2=-1) annotation (Placement(transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=90,
                    origin={-53,-9})));
              Modelica.Blocks.Math.Add add1 annotation (Placement(transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=0,
                    origin={-41,25})));
              Modelica.Blocks.Math.Add add2(k1=-1) annotation (Placement(transformation(
                    extent={{-5,-5},{5,5}},
                    rotation=0,
                    origin={-65,29})));
              Modelica.Blocks.Math.Add add3 annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=0,
                    origin={58,16})));
            equation
              connect(Gain3.y, Limited.u) annotation (Line(points={{106.7,17},{106.7,17},{
                      110.6,17}}, color={0,0,127}));
              connect(Limited.y, imLimitedIntegrator.u) annotation (Line(points={{126.7,17},
                      {128.35,17},{128.35,17},{130.6,17}}, color={0,0,127}));
              connect(imLimitedIntegrator.y, z) annotation (Line(points={{146.7,17},{153.35,
                      17},{153.35,17},{161,17}}, color={0,0,127}));
              connect(feedback.y, Gain3.u) annotation (Line(points={{87,16},{88,16},{88,17},
                      {90.6,17}}, color={0,0,127}));
              connect(feedback.u2, z) annotation (Line(points={{78,8},{78,-6},{152,-6},{152,
                      17},{153.35,17},{161,17}}, color={0,0,127}));
              connect(Pe, SimpleLag1.u) annotation (Line(points={{-90,-33},{-81,-33},{-73.4,
                      -33}}, color={0,0,127}));
              connect(add.y, Droop.u) annotation (Line(points={{-53,-3.5},{-53,-0.1},{-53.5,
                      -0.1}}, color={0,0,127}));
              connect(add.u2, SimpleLag1.y) annotation (Line(points={{-50,-15},{-50,-33},{-57.3,
                      -33}}, color={0,0,127}));
              connect(Pm_set, add.u1)
                annotation (Line(points={{-90,-17},{-56,-17},{-56,-15}}, color={0,0,127}));
              connect(Droop.y, add1.u2) annotation (Line(points={{-53.5,12.55},{-53.5,22},{
                      -47,22}}, color={0,0,127}));
              connect(add2.u1, Omega)
                annotation (Line(points={{-71,32},{-82,32},{-91,32}}, color={0,0,127}));
              connect(Omega_n.y, add2.u2) annotation (Line(points={{-81.4,12},{-78,12},{-78,
                      26},{-71,26}}, color={0,0,127}));
              connect(add2.y, add1.u1) annotation (Line(points={{-59.5,29},{-53.75,29},{-53.75,
                      28},{-47,28}}, color={0,0,127}));
              connect(Gain1.u, add1.y) annotation (Line(points={{8.6,25},{-13.7,25},{-35.5,
                      25}}, color={0,0,127}));
              connect(Gain2.u, add1.y) annotation (Line(points={{8.6,7},{0,7},{0,25},{-13.7,
                      25},{-35.5,25}}, color={0,0,127}));
              connect(Gain2.y, Integrator.u) annotation (Line(points={{24.7,7},{26.35,7},{
                      26.35,7},{28.6,7}}, color={0,0,127}));
              connect(add3.y, feedback.u1)
                annotation (Line(points={{64.6,16},{67.3,16},{70,16}}, color={0,0,127}));
              connect(Integrator.y, add3.u2) annotation (Line(points={{44.7,7},{48,7},{48,
                      12.4},{50.8,12.4}}, color={0,0,127}));
              connect(Gain1.y, add3.u1) annotation (Line(points={{24.7,25},{44,25},{44,19.6},
                      {50.8,19.6}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,-100},{
                        160,100}}), graphics={Text(
                      extent={{90,-6},{128,-10}},
                      lineColor={0,0,127},
                      textString="Servomotor"),Text(
                      extent={{14,34},{52,30}},
                      lineColor={0,0,127},
                      textString="PI Control"),Text(
                      extent={{-102,36},{-78,34}},
                      lineColor={0,0,127},
                      textString="w (rotor speed)"),Text(
                      extent={{-100,-40},{-76,-42}},
                      lineColor={0,0,127},
                      textString="P (active power)"),Text(
                      extent={{-98,-8},{-74,-10}},
                      lineColor={0,0,127},
                      textString="P0 (power set point)"),Text(
                      extent={{-50,6},{-32,8}},
                      lineColor={0,0,127},
                      textString="Speed drop")}),
                Icon(coordinateSystem(extent={{-100,-100},{160,100}}, preserveAspectRatio=
                        false), graphics={Rectangle(extent={{-4,46},{150,-20}}, lineColor={
                      0,0,255}),Text(
                      extent={{24,30},{126,6}},
                      lineColor={0,0,255},
                      textString="Speed Governor"),Text(
                      extent={{0,42},{20,26}},
                      lineColor={0,0,255},
                      textString="Omega"),Text(
                      extent={{136,24},{152,12}},
                      lineColor={0,0,255},
                      textString="z"),Text(
                      extent={{0,20},{20,4}},
                      lineColor={0,0,255},
                      textString="Pmset"),Text(
                      extent={{0,-2},{20,-18}},
                      lineColor={0,0,255},
                      textString="Pe")}),
                Documentation);
            end Governor;
          annotation (Documentation);
          end TG;
        annotation (Documentation);
        end Simulink;

        package PSSE
          package OEL
            model OEL
              Modelica.Blocks.Interfaces.RealInput IFD "Field current" annotation (
                  Placement(transformation(extent={{-140,-20},{-100,20}}),
                                                                         iconTransformation(
                    extent={{5,-6},{-5,6}},
                    rotation=180,
                    origin={-105,0})));
              Modelica.Blocks.Sources.Constant IFDSetpoint(k=IFDdes)
                annotation (Placement(transformation(extent={{-90,30},{-70,50}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator(
                outMin=Vmin,
                outMax=Vmax,
                k=KMX,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{10,50},{30,70}})));
              Modelica.Blocks.Interfaces.RealOutput VOEL "OEL output" annotation (Placement(
                    transformation(extent={{100,-10},{120,10}}),
                                                              iconTransformation(extent={{
                        100,-6},{110,6}})));
              parameter Real IFD1=1.1 "Low OEL limit (pu)";
              parameter Real IFD2=1.2 "Medium OEL limit (pu)";
              parameter Real IFD3=1.5 "High OEL limit (pu)";
              parameter Real TIME1=60 "Timing for low OEL (s)";
              parameter Real TIME2=30 "Timimg for medium OEL (s)";
              parameter Real TIME3=15 "Timing for high OEL (s)";
              parameter Real IFDdes=1 "IFD setpoint (pu)";
              parameter Real Vmax=0 "Max. OEL output (pu)";
              parameter Real Vmin=-0.05 "Min. OEL output (pu)";
              parameter Real KMX=1 "Control constant";
              IF_comparisor comparisor(
                HighCurrentLimit=IFD3,
                MediumCurrentLimit=IFD2,
                LowCurrentLimit=IFD1)
                annotation (Placement(transformation(extent={{-30,-10},{-10,10}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator1(
                outMin=Vmin,
                outMax=Vmax,
                k=KMX,
                y_start=6,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{10,10},{30,30}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator2(
                outMin=Vmin,
                outMax=Vmax,
                k=KMX,
                y_start=6,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{10,-30},{30,-10}})));
              Modelica.Blocks.Continuous.LimIntegrator imLimitedIntegrator3(
                outMin=Vmin,
                outMax=Vmax,
                k=KMX,
                y_start=7.5,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{10,-70},{30,-50}})));
              Modelica.Blocks.Math.Add add(k1=-1)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              Modelica.Blocks.Math.MultiSum multiSum(nu=4)
                annotation (Placement(transformation(extent={{60,-10},{80,10}})));
            equation
              connect(comparisor.n1, imLimitedIntegrator.u) annotation (Line(points={{-9,6},{-3.84,6},{-3.84,60},{8,60}},
                                                            color={0,0,127}));
              connect(comparisor.n2, imLimitedIntegrator1.u) annotation (Line(points={{-9,2},{0.16,2},{0.16,20},{8,20}},
                                                        color={0,0,127}));
              connect(comparisor.n3, imLimitedIntegrator2.u) annotation (Line(points={{-9,-2},{0.16,-2},{0.16,-20},{8,-20}},
                                                            color={0,0,127}));
              connect(comparisor.n4, imLimitedIntegrator3.u) annotation (Line(points={{-9,-6},{-3.84,-6},{-3.84,-60},{8,-60}},
                                                            color={0,0,127}));
              connect(add.y,comparisor. p) annotation (Line(points={{-39,0},{-32,0}},
                                            color={0,0,127}));
              connect(add.u2, IFD) annotation (Line(points={{-62,-6},{-80.5,-6},{-80.5,0},{-120,0}},
                                     color={0,0,127}));
              connect(IFDSetpoint.y, add.u1) annotation (Line(points={{-69,40},{-65.6,40},{-65.6,6},{-62,6}},
                                               color={0,0,127}));
              connect(multiSum.y, VOEL)
                annotation (Line(points={{81.7,0},{110,0}},           color={0,0,127}));
              connect(imLimitedIntegrator.y, multiSum.u[1]) annotation (Line(points={{31,60},{48.6,60},{48.6,5.25},{60,5.25}},
                                                          color={0,0,127}));
              connect(imLimitedIntegrator1.y, multiSum.u[2]) annotation (Line(points={{31,20},{40.6,20},{40.6,1.75},{60,1.75}},
                                                          color={0,0,127}));
              connect(imLimitedIntegrator2.y, multiSum.u[3]) annotation (Line(points={{31,-20},{44.6,-20},{44.6,-1.75},{60,-1.75}},
                                                          color={0,0,127}));
              connect(imLimitedIntegrator3.y, multiSum.u[4]) annotation (Line(points={{31,-60},{48.6,-60},{48.6,-5.25},{60,-5.25}},
                                                          color={0,0,127}));
              annotation (
                Icon(
                    graphics={Rectangle(extent={{-100,100},{100,-100}},
                                                                      lineColor={0,0,255}),
                      Text(
                      extent={{-40,-40},{40,-80}},
                      lineColor={0,0,255},
                      textString="OEL"),Text(
                      extent={{-96,4},{-72,-6}},
                      lineColor={0,0,255},
                      textString="IFD/EFD"),Text(
                      extent={{82,4},{100,-4}},
                      lineColor={0,0,255},
                      textString="VOEL"),
                    Text(
                      extent={{-100,100},{100,40}},
                      lineColor={0,0,255},
                      textString="%name")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Over Excitation Limiter, PSSE manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end OEL;

            model IF_comparisor
              Modelica.Blocks.Interfaces.RealInput p
                annotation (Placement(transformation(extent={{-140,-20},{-100,20}})));
              Modelica.Blocks.Interfaces.RealOutput n1
                annotation (Placement(transformation(extent={{100,50},{120,70}})));
              Modelica.Blocks.Interfaces.RealOutput n2 annotation (Placement(transformation(
                      extent={{100,10},{120,30}}),
                                                 iconTransformation(extent={{100,10},{120,30}})));
              parameter Real HighCurrentLimit=1.5;
              parameter Real MediumCurrentLimit=1.2;
              parameter Real LowCurrentLimit=1.1;
              parameter Real LL=1 - HighCurrentLimit;
              parameter Real ML=1 - MediumCurrentLimit;
              parameter Real HL=1 - LowCurrentLimit;
              Modelica.Blocks.Interfaces.RealOutput n3
                annotation (Placement(transformation(extent={{100,-30},{120,-10}})));
              Modelica.Blocks.Interfaces.RealOutput n4
                annotation (Placement(transformation(extent={{100,-70},{120,-50}})));
            equation
              if p >= HL then
                n1 = 100;
                n2 = 0;
                n3 = 0;
                n4 = 0;
              elseif p >= ML and p < HL then
                n1 = 0;
                n2 = -0.1;
                n3 = 0;
                n4 = 0;
              elseif p >= LL and p < ML then
                n1 = 0;
                n2 = 0;
                n3 = -0.2;
                n4 = 0;
              else
                n1 = 0;
                n2 = 0;
                n3 = 0;
                n4 = -0.5;
              end if;
              annotation (
                 Icon(graphics={Rectangle(extent={{-100,100},{100,-100}},
                      lineColor={
                      0,0,255}),Text(
                      extent={{40,-14},{80,-54}},
                      lineColor={0,0,255},
                      textString=">"),Text(
                      extent={{40,66},{80,26}},
                      lineColor={0,0,255},
                      textString="<"),Line(
                      points={{-100,0},{-40,0}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,60},{50,60}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{0,-20},{50,-20}},
                      color={0,0,255},
                      smooth=Smooth.None),Line(
                      points={{-40,0},{-16,-10}},
                      color={0,0,255},
                      smooth=Smooth.None),Ellipse(extent={{-16,-8},{-10,-14}}, lineColor={0,
                      0,255},
                      startAngle=0,
                      endAngle=360),
                              Ellipse(extent={{-4,62},{0,58}},    lineColor={0,0,255}),
                      Ellipse(extent={{-4,-18},{0,-22}},    lineColor={0,0,255}),Line(
                      points={{0,20},{50,20}},
                      color={0,0,255},
                      smooth=Smooth.None),Ellipse(extent={{-4,22},{0,18}},    lineColor={0,
                      0,255}),Line(
                      points={{0,-60},{48,-60}},
                      color={0,0,255},
                      smooth=Smooth.None),Ellipse(extent={{-4,-58},{0,-62}},    lineColor={
                      0,0,255}),
                    Text(
                      extent={{-120,140},{120,100}},
                      lineColor={0,0,255},
                      textString="%name")}));
            end IF_comparisor;
          annotation (Documentation);
          end OEL;

          package ES
            model ConstantExcitation
            extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
            initial equation
              V_REF = 0;
            equation
              connect(DiffV.u2, DiffV.u1) annotation (Line(points={{-122,-6},{-132,-6},{-132,
                      6},{-122,6}}, color={0,0,127}));
              connect(EFD0, EFD) annotation (Line(points={{-200,-130},{-20,-130},{160,-130},
                      {160,0},{210,0}}, color={0,0,127}));
              annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
                    coordinateSystem(preserveAspectRatio=false)));
            end ConstantExcitation;

            model ESST4B " IEEE type ST4B potential or compounded
  source-controlled rectifier exciter "
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import Modelica.ComplexMath.j;
              import Modelica.ComplexMath.'abs';
              parameter Real T_R=0.3;
              parameter Real K_PR=2.97;
              parameter Real K_IR=2.97;
              parameter Real V_RMAX=1;
              parameter Real V_RMIN=-0.87;
              parameter Real T_A=0.01;
              parameter Real K_PM=1;
              parameter Real K_IM=0.2;
              parameter Real V_MMAX=1;
              parameter Real V_MMIN=-0.87;
              parameter Real K_G=0.1;
              parameter Real K_P=6.73;
              parameter Real K_I=0.1;
              parameter Real V_BMAX=8.41;
              parameter Real K_C=0.1;
              parameter Real X_L=0;
              parameter Real THETAP=0;
              NonElectrical.Logical.LV_GATE lV_Gate
                annotation (Placement(transformation(extent={{120,-70},{144,-58}})));
              Modelica.Blocks.Interfaces.RealInput XADIFD annotation (Placement(
                    transformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={50,-180}), iconTransformation(extent={{-10,-10},{10,10}},
                      origin={-200,-70})));
              Modelica.Blocks.Math.Product product
                annotation (Placement(transformation(extent={{160,-80},{180,-60}})));
              NonElectrical.Continuous.SimpleLag VA(
                K=1,
                T=T_A,
                y_start=VR0) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={60,0})));
              Modelica.Blocks.Continuous.LimIntegrator VR1(
                outMax=V_RMAX/K_PR,
                outMin=V_RMIN/K_PR,
                k=K_IR,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=VR0)
                annotation (Placement(transformation(extent={{-40,-30},{-20,-10}})));
              Modelica.Blocks.Math.Gain Gain1(k=K_PR)
                annotation (Placement(transformation(extent={{-40,10},{-20,30}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{20,-10},{40,10}})));
              Modelica.Blocks.Math.Add add
                annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
              Modelica.Blocks.Math.Add add1(k1=-1)
                annotation (Placement(transformation(extent={{80,-10},{100,10}})));
              Modelica.Blocks.Math.Gain gain(k=K_G) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={120,60})));
              Modelica.Blocks.Continuous.LimIntegrator VM1(
                outMax=V_MMAX/K_PM,
                outMin=V_MMIN/K_PM,
                k=K_IR,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=VA0)
                annotation (Placement(transformation(extent={{110,-30},{130,-10}})));
              Modelica.Blocks.Math.Gain Gain2(k=K_PM)
                annotation (Placement(transformation(extent={{110,10},{130,30}})));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{170,-10},{190,10}})));
              Modelica.Blocks.Math.Add add2
                annotation (Placement(transformation(extent={{140,-10},{160,10}})));
              Modelica.Blocks.Nonlinear.Limiter maxLimiter(uMin=-Modelica.Constants.inf,
                  uMax=V_BMAX)
                annotation (Placement(transformation(extent={{100,-120},{120,-100}})));
              OpenIPSL.Interfaces.PwPin Gen_terminal annotation (Placement(
                    transformation(extent={{-180,120},{-160,140}}),
                    iconTransformation(extent={{-180,120},{-160,140}})));
              OpenIPSL.Interfaces.PwPin Bus annotation (Placement(
                    transformation(extent={{160,120},{180,140}}),
                    iconTransformation(extent={{160,120},{180,140}})));
              Modelica.Blocks.Math.Add3 add3_1
                annotation (Placement(transformation(extent={{-80,-10},{-60,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              BaseClasses.RectifierCommutationVoltageDrop rectifierCommutationVoltageDrop(
                  K_C=K_C)
                annotation (Placement(transformation(extent={{40,-120},{60,-100}})));
            protected
              Modelica.Blocks.Interfaces.RealOutput VE
                annotation (Placement(transformation(extent={{10,-120},{30,-100}})));
              Complex V_T;
              Complex I_T;
              parameter Complex K_P_comp=K_P*cos(THETAP) + j*K_P*sin(THETAP);
              parameter Real Ifd0(fixed=false);
              parameter Real IN0(fixed=false);
              parameter Real VB0(fixed=false);
              parameter Real VA0(fixed=false);
              parameter Real VR0(fixed=false);
              parameter Real VE0(fixed=false);
            initial equation
              Ifd0 = XADIFD;
              VE0 = VE;
              IN0 = K_C*Ifd0/VE0;
              if IN0 <= 0 then
                VB0 = IN0*1;
              elseif IN0 > 0 and IN0 <= 0.433 then
                VB0 = IN0*(1 - 0.577*IN0);
              elseif IN0 > 0.433 and IN0 < 0.75 then
                VB0 = IN0*sqrt(0.75 - IN0^2);
              elseif IN0 >= 0.75 and IN0 <= 1 then
                VB0 = IN0*1.732*(1 - IN0);
              else
                VB0 = IN0*0;
              end if;
              VA0 = Efd0/VB0;
              VR0 = Efd0*K_G;
              V_REF = ECOMP;
            equation
              VE = 'abs'(K_P_comp*V_T + j*(K_I + K_P_comp*X_L)*I_T);
              V_T = Gen_terminal.vr + j*Gen_terminal.vi;
              I_T = Gen_terminal.ir - Bus.ir + j*(Gen_terminal.ii - Bus.ii);
              connect(add.y, limiter.u) annotation (Line(
                  points={{11,0},{18,0}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(maxLimiter.y, product.u2) annotation (Line(
                  points={{121,-110},{148,-110},{148,-76},{158,-76}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(lV_Gate.p, product.u1) annotation (Line(
                  points={{142.5,-64},{158,-64}},
                  color={0,0,127},
                  smooth=Smooth.None));
              connect(add3_1.y, Gain1.u) annotation (Line(points={{-59,0},{-52,0},{-52,20},
                      {-42,20}}, color={0,0,127}));
              connect(VR1.u, Gain1.u) annotation (Line(points={{-42,-20},{-52,-20},{-52,20},
                      {-42,20}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-82,0},{-82,0}}, color={0,0,127}));
              connect(VOTHSG, add3_1.u1) annotation (Line(points={{-200,90},{-92,90},{-92,8},
                      {-82,8}}, color={0,0,127}));
              connect(VUEL, add3_1.u3) annotation (Line(points={{-130,-200},{-130,-20},{-92,
                      -20},{-92,-8},{-82,-8}}, color={0,0,127}));
              connect(VR1.y, add.u2) annotation (Line(points={{-19,-20},{-16,-20},{-16,-6},
                      {-12,-6}}, color={0,0,127}));
              connect(Gain1.y, add.u1) annotation (Line(points={{-19,20},{-16,20},{-16,6},{
                      -12,6}}, color={0,0,127}));
              connect(limiter.y, VA.u)
                annotation (Line(points={{41,0},{44.5,0},{48,0}}, color={0,0,127}));
              connect(VA.y, add1.u2)
                annotation (Line(points={{71,0},{74,0},{74,-6},{78,-6}}, color={0,0,127}));
              connect(add1.y, Gain2.u) annotation (Line(points={{101,0},{104,0},{104,20},{
                      108,20}}, color={0,0,127}));
              connect(VM1.u, Gain2.u) annotation (Line(points={{108,-20},{104,-20},{104,20},
                      {108,20}}, color={0,0,127}));
              connect(Gain2.y, add2.u1) annotation (Line(points={{131,20},{134,20},{134,6},
                      {138,6}}, color={0,0,127}));
              connect(VM1.y, add2.u2) annotation (Line(points={{131,-20},{134,-20},{134,-6},
                      {138,-6}}, color={0,0,127}));
              connect(add2.y, limiter1.u)
                annotation (Line(points={{161,0},{164.5,0},{168,0}}, color={0,0,127}));
              connect(product.y, EFD) annotation (Line(points={{181,-70},{198,-70},{198,0},
                      {210,0}}, color={0,0,127}));
              connect(lV_Gate.n2, VOEL) annotation (Line(points={{118.5,-67},{0,-67},{0,-160},
                      {-70,-160},{-70,-200}}, color={0,0,127}));
              connect(limiter1.y, lV_Gate.n1) annotation (Line(points={{191,0},{194,0},{194,
                      -50},{112,-50},{112,-61},{118.5,-61}}, color={0,0,127}));
              connect(gain.u, EFD) annotation (Line(points={{132,60},{198,60},{198,0},{210,
                      0}}, color={0,0,127}));
              connect(gain.y, add1.u1) annotation (Line(points={{109,60},{74,60},{74,6},{78,
                      6}}, color={0,0,127}));
              connect(XADIFD, rectifierCommutationVoltageDrop.XADIFD)
                annotation (Line(points={{50,-180},{50,-180},{50,-121}}, color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.EFD, maxLimiter.u)
                annotation (Line(points={{61,-110},{98,-110}}, color={0,0,127}));
              connect(VE, rectifierCommutationVoltageDrop.V_EX)
                annotation (Line(points={{20,-110},{39,-110}}, color={0,0,127}));
              connect(Gen_terminal, Bus) annotation (Line(points={{-170,130},{170,130},{170,
                      130}}, color={0,0,255}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{210,-4},{234,-18}},
                      lineColor={255,0,0},
                      textString="VB")}),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-146,158},{-96,100}},
                      lineColor={0,0,255},
                      textString="GenT"),Text(
                      extent={{-186,-60},{-116,-80}},
                      lineColor={28,108,200},
                      textString="XADIFD")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ESST4B;

            model EXNI "Bus or Solid Fed SCR Bridge Excitation System Model Type NI (NVE)"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0.60000E-01 "Voltage input time constant (s)";
              //0
              parameter Real K_A=150.00 "AVR gain";
              //400
              parameter Real T_A=0 "AVR time constant (s)";
              parameter Real V_RMAX=4 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-4 "Minimum AVR output (pu)";
              parameter Real K_F=0.110000E-01 "Rate feedback gain (pu)";
              parameter Real T_F1=0.40000 "Rate feedback time constant (s)";
              parameter Real T_F2=0.70000 "Rate feedback time constant (s)";
              parameter Boolean SWITCH=false;
              parameter Real r_cr_fd=10;
              OpenIPSL.NonElectrical.Logical.NegCurLogic negCurLogic(RC_rfd=
                    r_cr_fd, nstartvalue=Efd0) annotation (Placement(
                    transformation(extent={{140,-14},{182,14}})));
              Modelica.Blocks.Math.Add3 add3_1 annotation (Placement(transformation(extent={{-80,-10},{-60,10}})));
              Modelica.Blocks.Continuous.Derivative derivativeLag(
                k=K_F,
                T=T_F1,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{34,-60},{14,-40}})));
              NonElectrical.Continuous.SimpleLag simpleLag1(
                K=1,
                T=T_F2,
                y_start=0)
                annotation (Placement(transformation(extent={{0,-60},{-20,-40}})));
              Modelica.Blocks.Math.Add add(k2=-1)
                annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{16,-10},{36,10}})));
              Modelica.Blocks.Math.Product product
                annotation (Placement(transformation(extent={{50,30},{70,50}})));
              Modelica.Blocks.Logical.Switch switch1
                annotation (Placement(transformation(extent={{94,-14},{114,6}})));
              Modelica.Blocks.Sources.BooleanConstant booleanConstant(k=SWITCH)
                annotation (Placement(transformation(extent={{48,60},{68,80}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add Limiters annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-150})));
            protected
              parameter Real VR0(fixed=false);
              NonElectrical.Continuous.SimpleLag VR(
                K=K_A,
                T=T_A,
                y_start=VR0)
                annotation (Placement(transformation(extent={{-12,-10},{8,10}})));
            initial equation
              if SWITCH then
                VR0 = Efd0;
                V_REF = VR0/K_A + ECOMP0;
              else
                VR0 = Efd0/ECOMP0;
                V_REF = VR0/K_A + ECOMP0;
              end if;
            equation
              connect(simpleLag1.u, derivativeLag.y) annotation (Line(points={{2,-50},{2,-50},{13,-50}}, color={0,0,127}));
              connect(add.y, VR.u) annotation (Line(points={{-19,0},{-19,0},{-14,0}}, color={0,0,127}));
              connect(VR.y, limiter.u) annotation (Line(points={{9,0},{9,0},{14,0}}, color={0,0,127}));
              connect(derivativeLag.u, limiter.y) annotation (Line(points={{36,-50},{64,-50},{64,0},{37,0}}, color={0,0,127}));
              connect(product.u2, limiter.y) annotation (Line(points={{48,34},{44,34},{44,20},{44,0},{37,0}}, color={0,0,127}));
              connect(product.y, switch1.u3) annotation (Line(points={{71,40},{80,40},{80,-12},{92,-12}}, color={0,0,127}));
              connect(booleanConstant.y, switch1.u2) annotation (Line(points={{69,70},{84,70},{84,-4},{92,-4}}, color={255,0,255}));
              connect(negCurLogic.Efd, EFD) annotation (Line(points={{185.5,0},{210,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u) annotation (Line(points={{-200,0},{-186,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2) annotation (Line(points={{-99,0},{-82,0},{-82,0}}, color={0,0,127}));
              connect(VOTHSG, add3_1.u1) annotation (Line(points={{-200,90},{-90,90},{-90,8},{-82,8}}, color={0,0,127}));
              connect(Limiters.u1, VUEL) annotation (Line(points={{-106,-162},{-106,-170},{-130,-170},{-130,-200}}, color={0,0,127}));
              connect(Limiters.u2, VOEL) annotation (Line(points={{-94,-162},{-94,-170},{-70,-170},{-70,-200}}, color={0,0,127}));
              connect(Limiters.y, add3_1.u3) annotation (Line(points={{-100,-139},{-100,-139},{-100,-30},{-100,-20},{-88,-20},{-88,-8},{-82,-8}}, color={0,0,127}));
              connect(add3_1.y, add.u1) annotation (Line(points={{-59,0},{-48,0},{-48,6},{-42,6}}, color={0,0,127}));
              connect(simpleLag1.y, add.u2) annotation (Line(points={{-21,-50},{-34,-50},{-48,-50},{-48,-6},{-42,-6}}, color={0,0,127}));
              connect(switch1.y, negCurLogic.Vd) annotation (Line(points={{115,-4},{120,-4},{120,7},{136.5,7}}, color={0,0,127}));
              connect(switch1.u1, limiter.y) annotation (Line(points={{92,4},{64,4},{64,0},{37,0}}, color={0,0,127}));
              connect(product.u1, TransducerDelay.u) annotation (Line(points={{48,46},{-140,46},{-140,24},{-178,24},{-178,0},{-172,0}}, color={0,0,127}));
              connect(XADIFD, negCurLogic.XadIfd) annotation (Line(points={{80,-200},{80,
                      -200},{80,-54},{120,-54},{120,-7},{128,-7},{136.5,-7}}, color={0,0,
                      127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-200,-200},{200,
                        160}})),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"),      Icon(coordinateSystem(extent={{-200,-200},{200,160}}), graphics={Text(
                      extent={{-184,-60},{-114,-80}},
                      lineColor={28,108,200},
                      textString="XADIFD")}));
            end EXNI;

            model ST5B "IEEE 421.5 2005 ST5B Excitation System"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0.025 "Regulator input filter time constant (s)";
              parameter Real T_C1=0.1
                "Lead time constant of first lead-lag block (voltage regulator channel) (s)";
              parameter Real T_B1=0.2
                "Lag time constant of first lead-lag block (voltage regulator channel) (s)";
              parameter Real T_C2=1
                "Lead time constant of second lead-lag block (voltage regulator channel) (s)";
              parameter Real T_B2=1
                "Lag time constant of second lead-lag block (voltage regulator channel) (s)";
              parameter Real K_R=1 "Voltage regulator gain (pu)";
              parameter Real V_RMAX=10 "Voltage regulator maximum limit (pu)";
              parameter Real V_RMIN=-10 "Voltage regulator minimum limit (pu)";
              parameter Real T_1=0.58 "voltage regulator time constant (s)";
              parameter Real K_C=0.3 "(pu)";
              parameter Real T_UC1=1
                "Lead time constant of first lead-lag block (under- excitation channel) (s)";
              parameter Real T_UB1=1
                "Lag time constant of first lead-lag block (under- excitation channel) (s)";
              parameter Real T_UC2=1
                "Lead time constant of second lead-lag block (under- excitation channel) (s)";
              parameter Real T_UB2=1
                "Lag time constant of second lead-lag block (under- excitation channel) (s)";
              parameter Real T_OC1=1
                "Lead time constant of first lead-lag block (over- excitation channel) (s)";
              parameter Real T_OB1=1
                "Lag time constant of first lead-lag block (over- excitation channel) (s)";
              parameter Real T_OC2=1
                "Lead time constant of second lead-lag block (over- excitation channel) (s)";
              parameter Real T_OB2=1
                "Lag time constant of second lead-lag block (over- excitation channel) (s)";
              Modelica.Blocks.Math.Add VERR1 annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=0,
                    origin={-10,0})));
              NonElectrical.Logical.LV_GATE lV_Gate
                annotation (Placement(transformation(extent={{-48,0},{-26,12}})));
              NonElectrical.Logical.HV_GATE hV_Gate
                annotation (Placement(transformation(extent={{-84,-4},{-58,10}})));
              NonElectrical.Continuous.LeadLagLim imLimitedLeadLag(
                K=1,
                outMax=V_RMAX/K_R,
                T1=T_C1,
                T2=T_B1,
                outMin=V_RMIN/K_R,
                y_start=VR0/K_R)
                annotation (Placement(transformation(extent={{20,-10},{40,10}})));
              NonElectrical.Continuous.LeadLagLim imLimitedLeadLag2(
                K=1,
                outMax=V_RMAX/K_R,
                T1=T_C2,
                T2=T_B2,
                outMin=V_RMIN/K_R,
                y_start=VR0/K_R)
                annotation (Placement(transformation(extent={{50,-10},{70,10}})));
              Modelica.Blocks.Math.Gain K_r(k=K_R) annotation (Placement(transformation(
                    extent={{-10,-9.5},{10,9.5}},
                    rotation=0,
                    origin={90,0.5})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{108,-10},{128,10}})));
              Modelica.Blocks.Math.Add VERR2(k1=-1, k2=1) annotation (Placement(
                    transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=0,
                    origin={150,0})));
              Modelica.Blocks.Math.Gain K_c(k=K_C) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={130,-92})));
              NonElectrical.Continuous.LeadLagLim imLimitedLeadLag1(
                K=1,
                T1=T_UC1,
                T2=T_UB1,
                outMin=V_RMIN/K_R,
                y_start=VR0/K_R,
                outMax=V_RMAX/K_R)
                annotation (Placement(transformation(extent={{20,-60},{40,-40}})));
              NonElectrical.Continuous.LeadLagLim imLimitedLeadLag3(
                K=1,
                outMax=V_RMAX/K_R,
                T1=T_UC1,
                T2=T_UB1,
                outMin=V_RMIN/K_R,
                y_start=VR0/K_R)
                annotation (Placement(transformation(extent={{50,-60},{70,-40}})));
              NonElectrical.Continuous.LeadLagLim imLimitedLeadLag4(
                K=1,
                outMax=V_RMAX/K_R,
                T1=T_OC1,
                T2=T_OB1,
                outMin=V_RMIN/K_R,
                y_start=VR0/K_R)
                annotation (Placement(transformation(extent={{20,-100},{40,-80}})));
              NonElectrical.Continuous.LeadLagLim imLimitedLeadLag5(
                K=1,
                outMax=V_RMAX/K_R,
                T1=T_OC1,
                T2=T_OB1,
                outMin=V_RMIN/K_R,
                y_start=VR0/K_R)
                annotation (Placement(transformation(extent={{50,-100},{70,-80}})));
              NonElectrical.Continuous.SimpleLagLimVar simpleLagLimVar(
                K=1,
                T=T_1,
                y_start=Efd0)
                annotation (Placement(transformation(extent={{174,-10},{194,10}})));
              Modelica.Blocks.Math.Gain high(k=V_RMAX) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={106,-30})));
              Modelica.Blocks.Math.Gain low(k=V_RMIN) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={104,-70})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0) annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
            protected
              parameter Real VR0(fixed=false);
            initial equation
              VR0 = Efd0 + K_C*XADIFD;
              V_REF = VR0/K_R + ECOMP;
            equation
              connect(VERR1.y, imLimitedLeadLag.u) annotation (Line(points={{1,0},{1,0},{18,0}}, color={0,0,127}));
              connect(imLimitedLeadLag.y, imLimitedLeadLag2.u) annotation (Line(points={{41,0},{41,0},{48,0}}, color={0,0,127}));
              connect(imLimitedLeadLag1.u, imLimitedLeadLag.u) annotation (Line(points={{18,-50},{8,-50},{8,0},{18,0}}, color={0,0,127}));
              connect(imLimitedLeadLag1.y, imLimitedLeadLag3.u) annotation (Line(points={{41,-50},{41,-50},{48,-50}}, color={0,0,127}));
              connect(imLimitedLeadLag4.u, imLimitedLeadLag.u) annotation (Line(points={{18,-90},{8,-90},{8,0},{18,0}}, color={0,0,127}));
              connect(VERR2.y, simpleLagLimVar.u) annotation (Line(points={{161,0},{161,0},{172,0}}, color={0,0,127}));
              connect(low.y, simpleLagLimVar.outMin) annotation (Line(points={{115,-70},{176,-70},{176,-14}}, color={0,0,127}));
              connect(high.y, simpleLagLimVar.outMax) annotation (Line(points={{117,-30},{168,-30},{168,32},{192,32},{192,14}}, color={0,0,127}));
              connect(K_c.y, VERR2.u1) annotation (Line(points={{130,-81},{130,-81},{130,-6},{138,-6}}, color={0,0,127}));
              connect(imLimitedLeadLag4.y, imLimitedLeadLag5.u) annotation (Line(points={{41,-90},{41,-90},{48,-90}}, color={0,0,127}));
              connect(imLimitedLeadLag2.y, K_r.u) annotation (Line(points={{71,0},{78,0},{78,0.5}}, color={0,0,127}));
              connect(lV_Gate.p, VERR1.u2) annotation (Line(points={{-27.375,6},{-22,6}}, color={0,0,127}));
              connect(hV_Gate.p, lV_Gate.n2) annotation (Line(points={{-59.625,3},{-54.8125,3},{-54.8125,3},{-49.375,3}}, color={0,0,127}));
              connect(hV_Gate.n2, DiffV.y) annotation (Line(points={{-85.625,-0.5},{-91.8125,-0.5},{-91.8125,0},{-99,0}}, color={0,0,127}));
              connect(hV_Gate.n1, VUEL) annotation (Line(points={{-85.625,6.5},{-92,6.5},{-92,-160},{-130,-160},{-130,-200}}, color={0,0,127}));
              connect(lV_Gate.n1, VOEL) annotation (Line(points={{-49.375,9},{-54,9},{-54,-160},{-70,-160},{-70,-200}}, color={0,0,127}));
              connect(K_r.y, limiter.u) annotation (Line(points={{101,0.5},{104.5,0.5},{104.5,0},{106,0}}, color={0,0,127}));
              connect(limiter.y, VERR2.u2) annotation (Line(points={{129,0},{132,0},{132,6},{138,6}}, color={0,0,127}));
              connect(simpleLagLimVar.y, EFD) annotation (Line(points={{195,0},{210,0},{210,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u) annotation (Line(points={{-200,0},{-172,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(high.u, TransducerDelay.u) annotation (Line(points={{94,-30},{-178,-30},{-178,0},{-172,0}}, color={0,0,127}));
              connect(low.u, TransducerDelay.u) annotation (Line(points={{92,-70},{80,-70},{80,-30},{-178,-30},{-178,0},{-172,0}}, color={0,0,127}));
              connect(VOTHSG, VERR1.u1) annotation (Line(points={{-200,90},{-26,90},{-26,-6},{-22,-6}}, color={0,0,127}));
              connect(XADIFD, K_c.u) annotation (Line(points={{80,-200},{80,-200},{80,-124},
                      {80,-120},{130,-120},{130,-104}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    preserveAspectRatio=true,
                    extent={{-200,-200},{200,160}},
                    grid={2,2})),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    preserveAspectRatio=true,
                    grid={2,2}), graphics={Text(
                      extent={{-60,154},{62,110}},
                      lineColor={28,108,200},
                      textString="ST5B"),Text(
                      extent={{-184,-52},{-114,-72}},
                      lineColor={28,108,200},
                      textString="XADIFD")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ST5B;

            model IEEEX1
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import
                IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.calculate_dc_exciter_params;
              parameter Real T_R "Voltage input time constant (s)";
              parameter Real K_A "AVR gain";
              parameter Real T_A "AVR time constant (s)";
              parameter Real T_B "(s)";
              parameter Real T_C "(s)";
              parameter Real V_RMAX "Maximum AVR output (pu)";
              parameter Real V_RMIN "Minimum AVR output (pu)";
              parameter Real K_E "Exciter field gain";
              parameter Real T_E "Exciter time constant (s)";
              parameter Real K_F "Rate feedback gain (pu)";
              parameter Real T_F1 "Rate feedback time constant (s)";
              parameter Real E_1 "Exciter saturation point 1 (pu)";
              parameter Real S_EE_1 "Saturation at E1";
              parameter Real E_2 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_2 "Saturation at E2";
              NonElectrical.Continuous.LeadLag LL(
                T1=T_C,
                T2=T_B,
                K=1,
                y_start=VR0/K_A,
                x_start=V_REF - ECOMP0)
                annotation (Placement(transformation(extent={{0,-10},{20,10}})));
              Modelica.Blocks.Math.Add3 V_Erro1(k3=-1)
                annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                k=K_F,
                T=T_F1,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=Efd0)
                annotation (Placement(transformation(extent={{80,-60},{60,-40}})));
              Modelica.Blocks.Math.Add3 V_Erro2
                annotation (Placement(transformation(extent={{-80,40},{-60,60}})));
              NonElectrical.Continuous.SimpleLagLim SL(
                K=K_A,
                T=T_A,
                y_start=VR0,
                outMax=V_RMAX0,
                outMin=V_RMIN0)
                annotation (Placement(transformation(extent={{60,-10},{80,10}})));
              BaseClasses.RotatingExciter rotatingExciter(
                T_E=T_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                Efd0=Efd0,
                K_E=K_E0)
                annotation (Placement(transformation(extent={{120,-20},{160,20}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
            protected
              parameter Real SE_Efd0(fixed=false);
              parameter Real VR0(fixed=false);
              parameter Real V_RMAX0(fixed=false);
              parameter Real K_E0(fixed=false);
              parameter Real V_RMIN0(fixed=false);
            initial equation
              SE_Efd0 = OpenIPSL.NonElectrical.Functions.SE(
                            EFD0,
                            S_EE_1,
                            S_EE_2,
                            E_1,
                            E_2);
              (V_RMAX0,V_RMIN0,K_E0) = calculate_dc_exciter_params(
                V_RMAX,
                V_RMIN,
                K_E,
                E_2,
                S_EE_2,
                Efd0,
                SE_Efd0);
              VR0 = Efd0*(K_E0 + SE_Efd0);
              V_REF = VR0/K_A + ECOMP0;
            equation
              connect(V_Erro1.y, LL.u)
                annotation (Line(points={{-19,0},{-2,0}}, color={0,0,127}));
              connect(LL.y, SL.u)
                annotation (Line(points={{21,0},{58,0}}, color={0,0,127}));
              connect(DiffV.y, V_Erro1.u2)
                annotation (Line(points={{-99,0},{-42,0}}, color={0,0,127}));
              connect(SL.y, rotatingExciter.I_C)
                annotation (Line(points={{81,0},{117.5,0}}, color={0,0,127}));
              connect(rotatingExciter.EFD, EFD)
                annotation (Line(points={{162.5,0},{210,0}}, color={0,0,127}));
              connect(imDerivativeLag.y, V_Erro1.u3) annotation (Line(points={{59,-50},{-50,
                      -50},{-50,-8},{-42,-8}}, color={0,0,127}));
              connect(imDerivativeLag.u, EFD) annotation (Line(points={{82,-50},{180,-50},{
                      180,0},{210,0}}, color={0,0,127}));
              connect(VOTHSG, V_Erro2.u1) annotation (Line(points={{-200,90},{-100,90},{-100,
                      58},{-82,58}}, color={0,0,127}));
              connect(VUEL, V_Erro2.u2) annotation (Line(points={{-130,-200},{-130,-200},{-130,
                      -30},{-130,-28},{-94,-28},{-94,50},{-82,50}}, color={0,0,127}));
              connect(VOEL, V_Erro2.u3) annotation (Line(points={{-70,-200},{-70,20},{-88,
                      20},{-88,42},{-82,42}}, color={0,0,127}));
              connect(V_Erro2.y, V_Erro1.u1) annotation (Line(points={{-59,50},{-50,50},{-50,
                      8},{-42,8}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(TransducerDelay.u, ECOMP)
                annotation (Line(points={{-172,0},{-200,0}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1), graphics={Text(
                      extent={{-130,160},{130,100}},
                      lineColor={28,108,200},
                      textString="IEEEX1")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end IEEEX1;

            model SEXS "Simplified excitation system model"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_AT_B;
              parameter Real T_B;
              parameter Real K;
              parameter Real T_E;
              parameter Real E_MIN;
              parameter Real E_MAX;
              Modelica.Blocks.Math.Add3 V_erro(
                k3=1,
                k1=1,
                k2=1) annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K,
                T=T_E,
                y_start=Efd0,
                outMax=E_MAX,
                outMin=E_MIN)
                annotation (Placement(transformation(extent={{120,-10},{140,10}})));
              Modelica.Blocks.Math.Add DiffV1 annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-50})));
              NonElectrical.Continuous.LeadLag leadLag(
                K=1,
                T1=T_AT_B*T_B,
                T2=T_B,
                y_start=Efd0/K,
                x_start=Efd0/K)
                annotation (Placement(transformation(extent={{40,-10},{60,10}})));
            initial equation
              V_REF = Efd0/K + ECOMP0;
            equation
              connect(simpleLagLim.y, EFD)
                annotation (Line(points={{141,0},{210,0}}, color={0,0,127}));
              connect(DiffV1.u1, VUEL) annotation (Line(points={{-106,-62},{-106,-80},{-130,
                      -80},{-130,-200}}, color={0,0,127}));
              connect(DiffV1.u2, VOEL) annotation (Line(points={{-94,-62},{-94,-80},{-70,-80},
                      {-70,-200}}, color={0,0,127}));
              connect(DiffV1.y, V_erro.u3) annotation (Line(points={{-100,-39},{-100,-20},{
                      -52,-20},{-52,-8},{-42,-8}}, color={0,0,127}));
              connect(DiffV.y, V_erro.u2)
                annotation (Line(points={{-99,0},{-42,0}}, color={0,0,127}));
              connect(V_erro.u1, VOTHSG) annotation (Line(points={{-42,8},{-52,8},{-52,90},
                      {-200,90}}, color={0,0,127}));
              connect(ECOMP, DiffV.u2) annotation (Line(points={{-200,0},{-166,0},{-132,0},
                      {-132,-6},{-122,-6}}, color={0,0,127}));
              connect(leadLag.y, simpleLagLim.u)
                annotation (Line(points={{61,0},{118,0}}, color={0,0,127}));
              connect(leadLag.u, V_erro.y)
                annotation (Line(points={{38,0},{-19,0}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-100,160},{100,100}},
                      lineColor={28,108,200},
                      textString="SEXS")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end SEXS;

            model ESDC1A
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              import
                IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.calculate_dc_exciter_params;
              parameter Real T_R=0 "Voltage input time constant (s)";
              parameter Real K_A=400 "AVR gain";
              parameter Real T_A=0.02 "AVR time constant (s)";
              parameter Real T_B=0 "AVR lead-lag time constant (s)";
              parameter Real T_C=0 "AVR lead-lag time constant (s)";
              parameter Real V_RMAX=9 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real K_E=1 "Exciter field factor (pu)";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F1=1 "Rate feedback time constant (s)";
              parameter Real E_1=5.25 "Exciter saturation point 1 (pu)";
              parameter Real E_2=7 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_1=0.03 "Saturation at E_1";
              parameter Real S_EE_2=0.1 "Saturation at E_2";
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                k=K_F,
                T=T_F1,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=Efd0)
                annotation (Placement(transformation(extent={{0,-60},{-20,-40}})));
              NonElectrical.Logical.HV_GATE hV_GATE
                annotation (Placement(transformation(extent={{40,-6},{62,6}})));
              NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=V_R0/K_A)
                annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
              Modelica.Blocks.Math.Add3 add3_1(k3=-1)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K_A,
                T=T_A,
                y_start=V_R0,
                outMax=V_RMAX0,
                outMin=V_RMIN0) annotation (Placement(transformation(extent={{
                        80,-10},{100,10}})));
              BaseClasses.RotatingExciterLimited rotatingExciterLimited(
                T_E=T_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                Efd0=Efd0,
                K_E=K_E0)
                annotation (Placement(transformation(extent={{120,-10},{140,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add DiffV1
                annotation (Placement(transformation(extent={{-90,30},{-70,50}})));
            protected
              parameter Real V_R0(fixed=false);
              parameter Real V_RMAX0(fixed=false);
              parameter Real K_E0(fixed=false);
              parameter Real V_RMIN0(fixed=false);
              parameter Real SE_Efd0(fixed=false);
            initial equation
              SE_Efd0 = OpenIPSL.NonElectrical.Functions.SE(
                            Efd0,
                            S_EE_1,
                            S_EE_2,
                            E_1,
                            E_2);
              (V_RMAX0,V_RMIN0,K_E0) = calculate_dc_exciter_params(
                V_RMAX,
                V_RMIN,
                K_E,
                E_2,
                S_EE_2,
                Efd0,
                SE_Efd0);
              V_R0 = Efd0*(K_E0 + SE_Efd0);
              V_REF = V_R0/K_A + ECOMP0;
            equation
              connect(add3_1.y, imLeadLag.u)
                annotation (Line(points={{-39,0},{-36,0},{-22,0}}, color={0,0,127}));
              connect(hV_GATE.p, simpleLagLim.u)
                annotation (Line(points={{60.625,0},{60.625,0},{78,0}}, color={0,0,127}));
              connect(simpleLagLim.y, rotatingExciterLimited.I_C)
                annotation (Line(points={{101,0},{101,0},{118.75,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(rotatingExciterLimited.EFD, EFD)
                annotation (Line(points={{141.25,0},{210,0},{210,0}}, color={0,0,127}));
              connect(imLeadLag.y, hV_GATE.n1) annotation (Line(points={{1,0},{32,0},{32,3},
                      {38.625,3}}, color={0,0,127}));
              connect(VUEL, hV_GATE.n2) annotation (Line(points={{-130,-200},{-128,-200},{-128,
                      -80},{32,-80},{32,-3},{38.625,-3}}, color={0,0,127}));
              connect(imDerivativeLag.u, EFD) annotation (Line(points={{2,-50},{160,-50},{
                      160,0},{210,0}}, color={0,0,127}));
              connect(imDerivativeLag.y, add3_1.u3) annotation (Line(points={{-21,-50},{-46,
                      -50},{-72,-50},{-72,-8},{-62,-8}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-62,0},{-62,0}}, color={0,0,127}));
              connect(VOTHSG, DiffV1.u1) annotation (Line(points={{-200,90},{-150,90},{-96,
                      90},{-96,46},{-92,46}}, color={0,0,127}));
              connect(VOEL, DiffV1.u2) annotation (Line(points={{-70,-200},{-70,-200},{-70,
                      -60},{-96,-60},{-96,34},{-92,34}}, color={0,0,127}));
              connect(DiffV1.y, add3_1.u1) annotation (Line(points={{-69,40},{-66,40},{-66,
                      8},{-62,8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1), graphics={Text(
                      extent={{-120,154},{140,94}},
                      lineColor={28,108,200},
                      textString="ESDC1A")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>ESDC1A, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Major change - 2016-01-19</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ESDC1A;

            model ESDC2A
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              import
                IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.calculate_dc_exciter_params;
              parameter Real T_R=0 "Voltage input time constant (s)";
              parameter Real K_A=400 "AVR gain";
              parameter Real T_A=0.02 "AVR time constant (s)";
              parameter Real T_B=0 "AVR lead-lag time constant (s)";
              parameter Real T_C=0 "AVR lead-lag time constant (s)";
              parameter Real V_RMAX=9 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real K_E=1 "Exciter field factor (pu)";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F1=1 "Rate feedback time constant (s)";
              parameter Real E_1=5.25 "Exciter saturation point 1 (pu)";
              parameter Real E_2=7 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_1=0.03 "Saturation at E_1";
              parameter Real S_EE_2=0.1 "Saturation at E_2";
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                k=K_F,
                T=T_F1,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=Efd0)
                annotation (Placement(transformation(extent={{0,-60},{-20,-40}})));
              NonElectrical.Logical.HV_GATE hV_GATE
                annotation (Placement(transformation(extent={{40,-6},{62,6}})));
              NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=V_R0/K_A)
                annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
              Modelica.Blocks.Math.Add3 add3_1(k3=-1)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              BaseClasses.RotatingExciterLimited rotatingExciterLimited(
                T_E=T_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                Efd0=Efd0,
                K_E=K_E0)
                annotation (Placement(transformation(extent={{120,-10},{140,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add DiffV1
                annotation (Placement(transformation(extent={{-90,30},{-70,50}})));
              NonElectrical.Continuous.SimpleLagLimVar simpleLagLimVar(
                K=K_A,
                T=T_A,
                y_start=V_R0)
                annotation (Placement(transformation(extent={{80,-10},{100,10}})));
              Modelica.Blocks.Interfaces.RealInput VT annotation (Placement(transformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={102,-120}), iconTransformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-200,-70})));
              Modelica.Blocks.Math.Gain gain(k=V_RMIN0) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={82,-70})));
              Modelica.Blocks.Math.Gain gain1(k=V_RMAX0) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={110,-70})));
            protected
              parameter Real V_R0(fixed=false);
              parameter Real V_RMAX0(fixed=false);
              parameter Real K_E0(fixed=false);
              parameter Real V_RMIN0(fixed=false);
              parameter Real SE_Efd0(fixed=false);
            initial equation
              SE_Efd0 = OpenIPSL.NonElectrical.Functions.SE(
                            Efd0,
                            S_EE_1,
                            S_EE_2,
                            E_1,
                            E_2);
              (V_RMAX0,V_RMIN0,K_E0) = calculate_dc_exciter_params(
                V_RMAX,
                V_RMIN,
                K_E,
                E_2,
                S_EE_2,
                Efd0,
                SE_Efd0);
              V_R0 = Efd0*(K_E0 + SE_Efd0);
              V_REF = V_R0/K_A + ECOMP0;
            equation
              connect(add3_1.y, imLeadLag.u)
                annotation (Line(points={{-39,0},{-36,0},{-22,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(rotatingExciterLimited.EFD, EFD)
                annotation (Line(points={{141.25,0},{210,0},{210,0}}, color={0,0,127}));
              connect(imLeadLag.y, hV_GATE.n1) annotation (Line(points={{1,0},{32,0},{32,3},
                      {38.625,3}}, color={0,0,127}));
              connect(VUEL, hV_GATE.n2) annotation (Line(points={{-130,-200},{-128,-200},{-128,
                      -80},{32,-80},{32,-3},{38.625,-3}}, color={0,0,127}));
              connect(imDerivativeLag.u, EFD) annotation (Line(points={{2,-50},{160,-50},{
                      160,0},{210,0}}, color={0,0,127}));
              connect(imDerivativeLag.y, add3_1.u3) annotation (Line(points={{-21,-50},{-46,
                      -50},{-72,-50},{-72,-8},{-62,-8}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-62,0},{-62,0}}, color={0,0,127}));
              connect(VOTHSG, DiffV1.u1) annotation (Line(points={{-200,90},{-150,90},{-96,
                      90},{-96,46},{-92,46}}, color={0,0,127}));
              connect(VOEL, DiffV1.u2) annotation (Line(points={{-70,-200},{-70,-200},{-70,
                      -60},{-96,-60},{-96,34},{-92,34}}, color={0,0,127}));
              connect(DiffV1.y, add3_1.u1) annotation (Line(points={{-69,40},{-66,40},{-66,
                      8},{-62,8}}, color={0,0,127}));
              connect(simpleLagLimVar.u, hV_GATE.p)
                annotation (Line(points={{78,0},{60.625,0}}, color={0,0,127}));
              connect(simpleLagLimVar.y, rotatingExciterLimited.I_C)
                annotation (Line(points={{101,0},{118.75,0}}, color={0,0,127}));
              connect(VT, gain.u) annotation (Line(points={{102,-120},{102,-92},{82,-92},{
                      82,-82}}, color={0,0,127}));
              connect(gain.y, simpleLagLimVar.outMin)
                annotation (Line(points={{82,-59},{82,-36},{82,-14}}, color={0,0,127}));
              connect(gain1.y, simpleLagLimVar.outMax) annotation (Line(points={{110,-59},{
                      110,-59},{110,20},{98,20},{98,14}}, color={0,0,127}));
              connect(gain1.u, gain.u) annotation (Line(points={{110,-82},{110,-92},{82,-92},
                      {82,-82}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1), graphics={Text(
                      extent={{-120,154},{140,94}},
                      lineColor={28,108,200},
                      textString="ESDC1A"),Text(
                      extent={{-186,-60},{-150,-80}},
                      lineColor={28,108,200},
                      textString="VT")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>ESDC1A, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Major change - 2016-01-19</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ESDC2A;

            model EXAC1
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.invFEX;
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              Modelica.Blocks.Interfaces.RealInput XADIFD "Field current" annotation (
                  Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={150,-50}), iconTransformation(extent={{-210,-80},{-190,-60}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLagLim imLimitedSimpleLag(
                K=K_A,
                T=T_A,
                outMin=V_RMIN,
                outMax=V_RMAX,
                y_start=VR0) annotation (Placement(transformation(extent={{60,-10},
                        {80,10}})));
              parameter Real T_R=0 "Voltage input time constant (s)";
              parameter Real T_B=0 "AVR lead-lag time constant (s)";
              parameter Real T_C=0 "AVR lead-lag time constant (s)";
              parameter Real K_A=400 "AVR gain (pu)";
              parameter Real T_A=0.02 "AVR time constant (s)";
              parameter Real V_RMAX=9 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F=1 "Rate feedback time const (s)";
              parameter Real K_C=0.2 "Rectifier load factor (pu)";
              parameter Real K_D=0.48 "Exciter demagnetizing factor (pu)";
              parameter Real K_E=1 "Exciter field factor (pu)";
              parameter Real E_1=5.25 "Exciter saturation point 1 (pu)";
              parameter Real E_2=7 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_1=0.03 "Saturation at E1";
              parameter Real S_EE_2=0.1 "Saturation at E2";
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                k=K_F,
                T=T_F,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=VFE0)
                annotation (Placement(transformation(extent={{20,-60},{0,-40}})));
              NonElectrical.Continuous.LeadLag leadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=VR0/K_A,
                x_start=VR0/K_A)
                annotation (Placement(transformation(extent={{0,-10},{20,10}})));
              Modelica.Blocks.Math.Add3 add3_1(k3=-1)
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              BaseClasses.RectifierCommutationVoltageDrop rectifierCommutationVoltageDrop(
                  K_C=K_C)
                annotation (Placement(transformation(extent={{140,-10},{160,10}})));
              BaseClasses.RotatingExciterWithDemagnetizationLimited
                rotatingExciterWithDemagnetizationLimited(
                T_E=T_E,
                K_E=K_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                K_D=K_D,
                Efd0=VE0)
                annotation (Placement(transformation(extent={{100,-10},{120,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add3 add3_2 annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-90})));
            protected
              parameter Real VR0(fixed=false);
              parameter Real Ifd0(fixed=false);
              parameter Real VE0(fixed=false);
              parameter Real VFE0(fixed=false);
            initial equation
              Ifd0 = XADIFD;
              // Finding initial value of excitation voltage, VE0, via going through conditions of FEX function
              VE0 = invFEX(
                K_C=K_C,
                Efd0=Efd0,
                Ifd0=Ifd0);
              // Case IN>0 not checked because it will be resolved in the next iteration
              VFE0 = VE0*(SE(
                VE0,
                S_EE_1,
                S_EE_2,
                E_1,
                E_2) + K_E) + Ifd0*K_D;
              VR0 = VFE0;
              V_REF = VR0/K_A + ECOMP0;
            equation
              connect(leadLag.y, imLimitedSimpleLag.u)
                annotation (Line(points={{21,0},{58,0}}, color={0,0,127}));
              connect(add3_1.y, leadLag.u)
                annotation (Line(points={{-39,0},{-22,0},{-2,0}}, color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.XADIFD, XADIFD)
                annotation (Line(points={{150,-11},{150,-50}}, color={0,0,127}));
              connect(rotatingExciterWithDemagnetizationLimited.EFD,
                rectifierCommutationVoltageDrop.V_EX)
                annotation (Line(points={{121.25,0},{139,0}}, color={0,0,127}));
              connect(imLimitedSimpleLag.y, rotatingExciterWithDemagnetizationLimited.I_C)
                annotation (Line(points={{81,0},{98.75,0}}, color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.EFD, EFD)
                annotation (Line(points={{161,0},{210,0}}, color={0,0,127}));
              connect(rotatingExciterWithDemagnetizationLimited.XADIFD, XADIFD) annotation (
                 Line(points={{110,-11.25},{112,-11.25},{112,-36},{150,-36},{150,-50}},
                    color={0,0,127}));
              connect(imDerivativeLag.u, rotatingExciterWithDemagnetizationLimited.V_FE)
                annotation (Line(points={{22,-50},{56,-50},{90,-50},{90,-6.25},{98.75,-6.25}},
                    color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-80,0},{-62,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(VOEL, add3_2.u3) annotation (Line(points={{-70,-200},{-70,-114},{-92,
                      -114},{-92,-102}}, color={0,0,127}));
              connect(VUEL, add3_2.u2) annotation (Line(points={{-130,-200},{-130,-114},{-100,
                      -114},{-100,-102}}, color={0,0,127}));
              connect(VOTHSG, add3_2.u1) annotation (Line(points={{-200,90},{-178,90},{-178,
                      -110},{-108,-110},{-108,-102}}, color={0,0,127}));
              connect(add3_2.y, add3_1.u1) annotation (Line(points={{-100,-79},{-98,-79},{-98,
                      -20},{-90,-20},{-90,8},{-62,8}}, color={0,0,127}));
              connect(imDerivativeLag.y, add3_1.u3) annotation (Line(points={{-1,-50},{-26,
                      -50},{-70,-50},{-70,-8},{-62,-8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-184,-62},{-114,-82}},
                      lineColor={28,108,200},
                      textString="XADIFD"),Text(
                      extent={{-120,158},{140,98}},
                      lineColor={28,108,200},
                      textString="EXAC1")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>EXAC2, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-11-26</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end EXAC1;

            model EXAC2
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.invFEX;
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              Modelica.Blocks.Interfaces.RealInput XADIFD "Field current" annotation (
                  Placement(
                  visible=true,
                  transformation(
                    origin={160,-48},
                    extent={{-10,-10},{10,10}},
                    rotation=90),
                  iconTransformation(
                    origin={-198,-70},
                    extent={{-10,-10},{10,10}},
                    rotation=0)));
              OpenIPSL.NonElectrical.Continuous.SimpleLagLim imLimitedSimpleLag(
                K=K_A,
                T=T_A,
                outMax=V_AMAX,
                outMin=V_AMIN,
                y_start=VA0) annotation (Placement(transformation(extent={{-20,
                        -10},{0,10}})));
              parameter Real T_R=0 "Voltage input time constant (s)";
              parameter Real T_B=0 "AVR lead-lag time constant (s)";
              parameter Real T_C=0 "AVR lead-lag time constant (s)";
              parameter Real K_A=400 "AVR gain (pu)";
              parameter Real T_A=0.02 "AVR time constant (s)";
              parameter Real K_B;
              parameter Real V_RMAX=9 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real V_AMAX=9 "Maximum AVR output (pu)";
              parameter Real V_AMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real K_L;
              parameter Real K_H;
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F=1 "Rate feedback time const (s)";
              parameter Real K_C=0.2 "Rectifier load factor (pu)";
              parameter Real K_D=0.48 "Exciter demagnetizing factor (pu)";
              parameter Real K_E=1 "Exciter field factor (pu)";
              parameter Real V_LR "Limit value of excitation voltage (pu)";
              parameter Real E_1=5.25 "Exciter saturation point 1 (pu)";
              parameter Real E_2=7 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_1=0.03 "Saturation at E1";
              parameter Real S_EE_2=0.1 "Saturation at E2";
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                k=K_F,
                T=T_F,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=VFE0)
                annotation (Placement(transformation(extent={{20,-100},{0,-80}})));
              NonElectrical.Continuous.LeadLag leadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=VA0/K_A,
                x_start=VA0/K_A)
                annotation (Placement(transformation(extent={{-50,-10},{-30,10}})));
              Modelica.Blocks.Math.Add3 add3_1(k3=-1)
                annotation (Placement(transformation(extent={{-80,-10},{-60,10}})));
              BaseClasses.RectifierCommutationVoltageDrop rectifierCommutationVoltageDrop(
                  K_C=K_C)
                annotation (Placement(transformation(extent={{170,-10},{190,10}})));
              BaseClasses.RotatingExciterWithDemagnetizationLimited
                rotatingExciterWithDemagnetizationLimited(
                T_E=T_E,
                K_E=K_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                K_D=K_D,
                Efd0=VE0)
                annotation (Placement(transformation(extent={{130,-10},{150,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add3 add3_2 annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-90})));
              Modelica.Blocks.Math.Add DiffV1(k2=-1)
                annotation (Placement(transformation(extent={{20,-10},{40,10}})));
              Modelica.Blocks.Math.Gain gain(k=K_H)
                annotation (Placement(transformation(extent={{60,-80},{40,-60}})));
              OpenIPSL.NonElectrical.Logical.LV_GATE lV_GATE
                annotation (Placement(transformation(extent={{46,-6},{68,6}})));
              Modelica.Blocks.Math.Gain gain1(k=K_B)
                annotation (Placement(transformation(extent={{76,-8},{92,8}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{100,-10},{120,10}})));
              Modelica.Blocks.Math.Gain gain3(k=K_L) annotation (Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=0,
                    origin={62,-30})));
              Modelica.Blocks.Math.Add add3(k1=-1, k2=+1) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=180,
                    origin={90,-30})));
              Modelica.Blocks.Sources.Constant Vref1(k=V_LR) annotation (Placement(
                    transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=0,
                    origin={150,-90})));
            protected
              parameter Real VA0(fixed=false);
              parameter Real VR0(fixed=false);
              parameter Real VFE0(fixed=false);
              parameter Real Ifd0(fixed=false);
              parameter Real VE0(fixed=false);
            initial equation
              Ifd0 = XADIFD;
              // Finding initial value of excitation voltage, VE0, via going through conditions of FEX function
              VE0 = invFEX(
                K_C=K_C,
                Efd0=Efd0,
                Ifd0=Ifd0);
              // Case IN>0 not checked because it will be resolved in the next iteration
              VFE0 = VE0*(SE(
                VE0,
                S_EE_1,
                S_EE_2,
                E_1,
                E_2) + K_E) + Ifd0*K_D;
              VR0 = VFE0;
              VA0 = VR0/K_B + VFE0*K_H;
              V_REF = VA0/K_A + ECOMP0;
            equation
              connect(rectifierCommutationVoltageDrop.XADIFD, XADIFD) annotation (Line(
                    points={{180,-11},{180,-30.5},{160,-30.5},{160,-48}}, color={0,0,127}));
              connect(rotatingExciterWithDemagnetizationLimited.XADIFD, XADIFD) annotation (
                 Line(points={{140,-11.25},{140,-30},{160,-30},{160,-48}}, color={0,0,127}));
              connect(leadLag.y, imLimitedSimpleLag.u)
                annotation (Line(points={{-29,0},{-29,0},{-22,0}}, color={0,0,127}));
              connect(add3_1.y, leadLag.u)
                annotation (Line(points={{-59,0},{-52,0}}, color={0,0,127}));
              connect(rotatingExciterWithDemagnetizationLimited.EFD,
                rectifierCommutationVoltageDrop.V_EX)
                annotation (Line(points={{151.25,0},{151.25,0},{169,0}}, color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.EFD, EFD)
                annotation (Line(points={{191,0},{192,0},{210,0}}, color={0,0,127}));
              connect(imDerivativeLag.u, rotatingExciterWithDemagnetizationLimited.V_FE)
                annotation (Line(points={{22,-90},{22,-90},{124,-90},{124,-6.25},{128.75,-6.25}},
                    color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-82,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(VOEL, add3_2.u3) annotation (Line(points={{-70,-200},{-70,-114},{-92,
                      -114},{-92,-102}}, color={0,0,127}));
              connect(VUEL, add3_2.u2) annotation (Line(points={{-130,-200},{-130,-114},{-100,
                      -114},{-100,-102}}, color={0,0,127}));
              connect(VOTHSG, add3_2.u1) annotation (Line(points={{-200,90},{-178,90},{-178,
                      -110},{-108,-110},{-108,-102}}, color={0,0,127}));
              connect(add3_2.y, add3_1.u1) annotation (Line(points={{-100,-79},{-98,-79},{-98,
                      -20},{-90,-20},{-90,8},{-82,8}}, color={0,0,127}));
              connect(imDerivativeLag.y, add3_1.u3) annotation (Line(points={{-1,-90},{-1,-90},
                      {-86,-90},{-86,-8},{-82,-8}}, color={0,0,127}));
              connect(imLimitedSimpleLag.y, DiffV1.u1)
                annotation (Line(points={{1,0},{18,0},{18,6}}, color={0,0,127}));
              connect(gain.y, DiffV1.u2) annotation (Line(points={{39,-70},{10,-70},{10,-6},
                      {18,-6}}, color={0,0,127}));
              connect(gain.u, rotatingExciterWithDemagnetizationLimited.V_FE) annotation (
                  Line(points={{62,-70},{124,-70},{124,-6.25},{128.75,-6.25}}, color={0,0,
                      127}));
              connect(limiter.y, rotatingExciterWithDemagnetizationLimited.I_C)
                annotation (Line(points={{121,0},{128.75,0},{128.75,0}}, color={0,0,127}));
              connect(add3.u1, rotatingExciterWithDemagnetizationLimited.V_FE) annotation (
                  Line(points={{102,-36},{124,-36},{124,-6.25},{128.75,-6.25}}, color={0,0,
                      127}));
              connect(gain3.u, add3.y)
                annotation (Line(points={{74,-30},{79,-30}}, color={0,0,127}));
              connect(Vref1.y, add3.u2) annotation (Line(points={{139,-90},{130,-90},{130,-24},
                      {102,-24}}, color={0,0,127}));
              connect(gain1.y, limiter.u)
                annotation (Line(points={{92.8,0},{94,0},{98,0}}, color={0,0,127}));
              connect(lV_GATE.p, gain1.u)
                annotation (Line(points={{66.625,0},{74.4,0}}, color={0,0,127}));
              connect(gain3.y, lV_GATE.n2) annotation (Line(points={{51,-30},{44.625,-30},{
                      44.625,-3}}, color={0,0,127}));
              connect(DiffV1.y, lV_GATE.n1)
                annotation (Line(points={{41,0},{44.625,0},{44.625,3}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-184,-62},{-114,-82}},
                      lineColor={28,108,200},
                      textString="XADIFD"),Text(
                      extent={{-120,158},{140,98}},
                      lineColor={28,108,200},
                      textString="EXAC2")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>EXAC2, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-11-26</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end EXAC2;

            model SCRX "Bus Fed or Solid Fed Static Exciter"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_AT_B;
              parameter Real T_B;
              parameter Real K;
              parameter Real T_E;
              parameter Real E_MIN;
              parameter Real E_MAX;
              parameter Boolean C_SWITCH;
              parameter Real r_cr_fd;
              Modelica.Blocks.Math.Add3 V_erro
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                y_start=VR0/K,
                T1=T_AT_B*T_B,
                T2=T_B) annotation (Placement(transformation(extent={{-20,-10},
                        {0,10}})));
              OpenIPSL.NonElectrical.Logical.NegCurLogic negCurLogic(
                  nstartvalue=Efd0, RC_rfd=r_cr_fd) annotation (Placement(
                    transformation(extent={{150,-10},{180,10}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K,
                T=T_E,
                y_start=VR0,
                outMax=E_MAX,
                outMin=E_MIN)
                annotation (Placement(transformation(extent={{10,-10},{30,10}})));
              Modelica.Blocks.Logical.Switch switch1
                annotation (Placement(transformation(extent={{72,18},{84,30}})));
              Modelica.Blocks.Sources.BooleanConstant booleanConstant(k=C_SWITCH)
                annotation (Placement(transformation(extent={{40,46},{52,58}})));
              Modelica.Blocks.Math.Product product
                annotation (Placement(transformation(extent={{42,14},{54,26}})));
              Modelica.Blocks.Math.Add DiffV1(k2=-1) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-150})));
            protected
              parameter Real VR0(fixed=false);
            initial equation
              if not C_SWITCH then
                VR0 = Efd0/ECOMP0;
                V_REF = VR0/K + ECOMP0;
              else
                VR0 = Efd0;
                V_REF = VR0/K + ECOMP0;
              end if;
            equation
              connect(V_erro.y, imLeadLag.u)
                annotation (Line(points={{-39,0},{-39,0},{-22,0}}, color={0,0,127}));
              connect(imLeadLag.y, simpleLagLim.u)
                annotation (Line(points={{1,0},{8,0}}, color={0,0,127}));
              connect(booleanConstant.y, switch1.u2) annotation (Line(points={{52.6,52},{66,
                      52},{66,24},{70.8,24}}, color={255,0,255}));
              connect(product.u2, simpleLagLim.y) annotation (Line(points={{40.8,16.4},{36,
                      16.4},{36,0},{31,0}}, color={0,0,127}));
              connect(product.y, switch1.u3) annotation (Line(points={{54.6,20},{70.8,20},{
                      70.8,19.2}}, color={0,0,127}));
              connect(switch1.u1, simpleLagLim.y) annotation (Line(points={{70.8,28.8},{62,
                      28.8},{62,0},{31,0}}, color={0,0,127}));
              connect(ECOMP, DiffV.u2) annotation (Line(points={{-200,0},{-132,0},{-132,-6},
                      {-122,-6}}, color={0,0,127}));
              connect(DiffV.y, V_erro.u2)
                annotation (Line(points={{-99,0},{-62,0}}, color={0,0,127}));
              connect(VOTHSG, V_erro.u1) annotation (Line(points={{-200,90},{-140,90},{-80,
                      90},{-80,8},{-62,8}}, color={0,0,127}));
              connect(DiffV1.u2, VOEL) annotation (Line(points={{-94,-162},{-94,-170},{-70,
                      -170},{-70,-200}}, color={0,0,127}));
              connect(DiffV1.u1, VUEL) annotation (Line(points={{-106,-162},{-106,-170},{-130,
                      -170},{-130,-200}}, color={0,0,127}));
              connect(DiffV1.y, V_erro.u3) annotation (Line(points={{-100,-139},{-100,-139},
                      {-100,-20},{-80,-20},{-80,-8},{-62,-8}}, color={0,0,127}));
              connect(negCurLogic.Efd, EFD)
                annotation (Line(points={{182.5,0},{210,0},{210,0}}, color={0,0,127}));
              connect(product.u1, DiffV.u2) annotation (Line(points={{40.8,23.6},{-160,23.6},
                      {-160,0},{-132,0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(switch1.y, negCurLogic.Vd) annotation (Line(points={{84.6,24},{120,24},
                      {120,5},{147.5,5}}, color={0,0,127}));
              connect(XADIFD, negCurLogic.XadIfd) annotation (Line(points={{80,-200},{80,-5},{147.5,-5}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(
                    preserveAspectRatio=true,
                    extent={{-200,-200},{200,160}},
                    initialScale=0.1), graphics={Text(
                      extent={{-186,-62},{-116,-82}},
                      lineColor={28,108,200},
                      textString="XADIFD"),Text(
                      extent={{-100,156},{100,96}},
                      lineColor={28,108,200},
                      textString="SCRX")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end SCRX;

            model IEEET1 "IEEE Type 1 excitation system"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              import
                IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.calculate_dc_exciter_params;
              parameter Real T_R=1 "Voltage input time constant (s)";
              parameter Real K_A=40 "AVR gain";
              parameter Real T_A=0.04 "AVR time constant (s)";
              parameter Real V_RMAX=7.3 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-7.3 "Minimum AVR output (pu)";
              parameter Real K_E=1 "Exciter field gain, s";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F=1 "Rate feedback time constant (s)";
              parameter Real E_1=2.400 "Exciter saturation point 1 (pu)";
              parameter Real S_EE_1=0.30000E-01 "Saturation at E1";
              parameter Real E_2=5.0000 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_2=0.50000 "Saturation at E2";
              Modelica.Blocks.Math.Add3 sum2
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              Modelica.Blocks.Math.Add sum3(k2=-1)
                annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
              Modelica.Blocks.Continuous.Derivative derivativeLag(
                k=K_F,
                T=T_F,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=Efd0)
                annotation (Placement(transformation(extent={{80,-60},{60,-40}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K_A,
                T=T_A,
                y_start=VR0,
                outMax=V_RMAX,
                outMin=V_RMIN)
                annotation (Placement(transformation(extent={{60,-10},{80,10}})));
              BaseClasses.RotatingExciter rotatingExciter(
                T_E=T_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                Efd0=Efd0,
                K_E=KE0) annotation (Placement(transformation(extent={{140,-10},{160,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add DiffV1 annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-130})));
            protected
              parameter Real VRMAX0(fixed=false) "Maximum AVR output (pu)";
              parameter Real VRMIN0(fixed=false) "Minimum AVR output (pu)";
              parameter Real KE0(fixed=false) "Exciter field gain, s";
              parameter Real SE_Efd0(fixed=false);
              parameter Real VR0(fixed=false);
            initial equation
              SE_Efd0 = SE(
                Efd0,
                S_EE_1,
                S_EE_2,
                E_1,
                E_2);
              (VRMAX0,VRMIN0,KE0) = calculate_dc_exciter_params(
                V_RMAX,
                V_RMIN,
                K_E,
                E_2,
                S_EE_2,
                Efd0,
                SE_Efd0);
              VR0 = Efd0*(KE0 + SE_Efd0);
              V_REF = VR0/K_A + ECOMP0;
            equation
              connect(sum3.u2, derivativeLag.y) annotation (Line(points={{-22,-6},{-34,-6},
                      {-34,-28},{-34,-50},{59,-50}}, color={0,0,127}));
              connect(sum3.y, simpleLagLim.u)
                annotation (Line(points={{1,0},{58,0}}, color={0,0,127}));
              connect(rotatingExciter.EFD, EFD)
                annotation (Line(points={{161.25,0},{210,0}}, color={0,0,127}));
              connect(simpleLagLim.y, rotatingExciter.I_C)
                annotation (Line(points={{81,0},{138.75,0}}, color={0,0,127}));
              connect(derivativeLag.u, EFD) annotation (Line(points={{82,-50},{180,-50},{
                      180,0},{210,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-140,
                      0},{-132,0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(sum2.y, sum3.u1) annotation (Line(points={{-39,0},{-34,0},{-34,6},{-22,
                      6}}, color={0,0,127}));
              connect(DiffV.y, sum2.u2)
                annotation (Line(points={{-99,0},{-62,0},{-62,0}}, color={0,0,127}));
              connect(VOTHSG, sum2.u1) annotation (Line(points={{-200,90},{-138,90},{-80,90},
                      {-80,8},{-62,8}}, color={0,0,127}));
              connect(DiffV1.u1, VUEL) annotation (Line(points={{-106,-142},{-106,-142},{-106,
                      -160},{-130,-160},{-130,-200}}, color={0,0,127}));
              connect(DiffV1.u2, VOEL) annotation (Line(points={{-94,-142},{-94,-160},{-70,
                      -160},{-70,-200}}, color={0,0,127}));
              connect(DiffV1.y, sum2.u3) annotation (Line(points={{-100,-119},{-100,-20},{-80,
                      -20},{-80,-8},{-62,-8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-100,154},{100,94}},
                      lineColor={28,108,200},
                      textString="IEEET1")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end IEEET1;

            model IEEET2 "IEEE Type 2 excitation system"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              import
                IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.calculate_dc_exciter_params;
              parameter Real T_R=0.02 "Voltage input time constant (s)";
              parameter Real K_A=200.0 "AVR gain";
              parameter Real T_A=0.001 "AVR time constant (s)";
              parameter Real V_RMAX=6.08 "Maximum AVR output (pu)";
              parameter Real V_RMIN=-6.08 "Minimum AVR output (pu)";
              parameter Real K_E=1 "Exciter field gain";
              parameter Real T_E=0.55 "Exciter time constant s";
              parameter Real K_F=0.06 "Rate feedback gain (pu)";
              parameter Real T_F1=0.3 "Rate feedback time constant (s)";
              parameter Real T_F2=0.6 "Rate feedback time constant (s)";
              parameter Real E_1=2.85 "Exciter saturation point 1 (pu)";
              parameter Real S_EE_1=0.3 "Saturation at E_1";
              parameter Real E_2=3.8 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_2=0.6 "Saturation at E_2";
              Modelica.Blocks.Math.Add3 add3_1
                annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
              Modelica.Blocks.Math.Add add(k2=-1)
                annotation (Placement(transformation(extent={{-20,-10},{0,10}})));
              NonElectrical.Continuous.SimpleLag simpleLag(
                K=1,
                T=T_F2,
                y_start=0) annotation (Placement(transformation(extent={{20,-60},{0,-40}})));
              Modelica.Blocks.Continuous.Derivative derivativeLag(
                k=K_F,
                y_start=0,
                T=T_F1,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=VR0)
                annotation (Placement(transformation(extent={{80,-60},{60,-40}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K_A,
                T=T_A,
                y_start=VR0,
                outMax=V_RMAX0,
                outMin=V_RMIN0)
                annotation (Placement(transformation(extent={{60,-10},{80,10}})));
              BaseClasses.RotatingExciter rotatingExciter(
                T_E=T_E,
                K_E=K_E0,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                Efd0=Efd0)
                annotation (Placement(transformation(extent={{140,-10},{160,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add Limiters annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-150})));
            protected
              parameter Real V_RMAX0(fixed=false);
              parameter Real V_RMIN0(fixed=false);
              parameter Real K_E0(fixed=false);
              parameter Real Efd0(fixed=false);
              parameter Real SE_Efd0(fixed=false);
              parameter Real VR0(fixed=false);
            initial equation
              SE_Efd0 = OpenIPSL.NonElectrical.Functions.SE(
                            EFD0,
                            S_EE_1,
                            S_EE_2,
                            E_1,
                            E_2);
              (V_RMAX0,V_RMIN0,K_E0) = calculate_dc_exciter_params(
                V_RMAX,
                V_RMIN,
                K_E,
                E_2,
                S_EE_2,
                Efd0,
                SE_Efd0);
              VR0 = Efd0*(K_E0 + SE_Efd0);
              V_REF = VR0/K_A + ECOMP0;
            equation
              connect(add3_1.y, add.u1) annotation (Line(points={{-39,0},{-33.65,0},{-33.65,
                      6},{-22,6}}, color={0,0,127}));
              connect(simpleLag.y, add.u2) annotation (Line(points={{-1,-50},{-34,-50},{-34,
                      -6},{-22,-6}}, color={0,0,127}));
              connect(simpleLag.u, derivativeLag.y)
                annotation (Line(points={{22,-50},{59,-50}}, color={0,0,127}));
              connect(add.y, simpleLagLim.u)
                annotation (Line(points={{1,0},{58,0}}, color={0,0,127}));
              connect(rotatingExciter.EFD, EFD)
                annotation (Line(points={{161.25,0},{210,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(simpleLagLim.y, rotatingExciter.I_C)
                annotation (Line(points={{81,0},{122,0},{138.75,0}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-62,0},{-62,0}}, color={0,0,127}));
              connect(VOTHSG, add3_1.u1) annotation (Line(points={{-200,90},{-80,90},{-80,8},
                      {-62,8}}, color={0,0,127}));
              connect(VUEL, Limiters.u1) annotation (Line(points={{-130,-200},{-130,-172},{
                      -106,-172},{-106,-162}}, color={0,0,127}));
              connect(Limiters.u2, VOEL) annotation (Line(points={{-94,-162},{-94,-172},{-70,
                      -172},{-70,-200}}, color={0,0,127}));
              connect(Limiters.y, add3_1.u3) annotation (Line(points={{-100,-139},{-100,-139},
                      {-100,-20},{-80,-20},{-80,-8},{-62,-8}}, color={0,0,127}));
              connect(derivativeLag.u, rotatingExciter.I_C) annotation (Line(points={{82,-50},
                      {120,-50},{120,0},{138.75,0}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(
                    preserveAspectRatio=true,
                    extent={{-200,-200},{200,160}},
                    initialScale=0.1), graphics={Text(
                      extent={{-100,152},{100,92}},
                      lineColor={28,108,200},
                      textString="IEEET2")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end IEEET2;

            model EXST1 "IEEE Type AC2A Excitation System"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0.02;
              parameter Real V_IMAX=0.2;
              parameter Real V_IMIN=0;
              parameter Real T_C=1;
              parameter Real T_B=1;
              parameter Real K_A=80;
              parameter Real T_A=0.05;
              parameter Real V_RMAX=8;
              parameter Real V_RMIN=-3;
              parameter Real K_C=0.2;
              parameter Real K_F=0.1;
              parameter Real T_F=1;
              OpenIPSL.NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=Efd0/K_A,
                x_start=Efd0/K_A) annotation (Placement(transformation(extent={
                        {40,-10},{60,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=V_IMAX, uMin=V_IMIN)
                annotation (Placement(transformation(extent={{0,-10},{20,10}})));
              NonElectrical.Continuous.SimpleLag Vm1(
                y_start=Efd0,
                K=1,
                T=T_A) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={130,0})));
              Modelica.Blocks.Math.Gain K_a(k=K_A) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={90,0})));
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                k=K_F,
                T=T_F,
                y_start=0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{92,-70},{72,-50}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add3 add3_2
                annotation (Placement(transformation(extent={{-80,-10},{-60,10}})));
              Modelica.Blocks.Math.Add Limiters annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={-100,-150})));
              Modelica.Blocks.Math.Feedback feedback
                annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
            protected
              Modelica.Blocks.Interfaces.RealOutput EFD1 annotation (Placement(
                    transformation(extent={{180,-10},{200,10}}), iconTransformation(extent=
                        {{302,-64},{322,-44}})));
            initial equation
              V_REF = Efd0/K_A + ECOMP0;
            equation
              if EFD > ECOMP*V_RMAX - K_C*XADIFD then
                EFD = ECOMP*V_RMAX - K_C*XADIFD;
              elseif EFD < ECOMP*V_RMIN - K_C*XADIFD then
                EFD = ECOMP*V_RMIN - K_C*XADIFD;
              else
                EFD = EFD1;
              end if;
              connect(imLeadLag.y, K_a.u)
                annotation (Line(points={{61,0},{70,0},{78,0}}, color={0,0,127}));
              connect(imLeadLag.u, limiter.y)
                annotation (Line(points={{38,0},{30,0},{21,0}}, color={0,0,127}));
              connect(K_a.y, Vm1.u)
                annotation (Line(points={{101,0},{118,0}}, color={0,0,127}));
              connect(Vm1.y, EFD1)
                annotation (Line(points={{141,0},{170,0},{190,0}}, color={0,0,127}));
              connect(imDerivativeLag.u, EFD1) annotation (Line(points={{94,-60},{170,-60},
                      {170,0},{190,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-186,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(VOTHSG, add3_2.u1) annotation (Line(points={{-200,90},{-148,90},{-90,
                      90},{-90,8},{-82,8}}, color={0,0,127}));
              connect(DiffV.y, add3_2.u2)
                annotation (Line(points={{-99,0},{-90.5,0},{-82,0}}, color={0,0,127}));
              connect(VUEL, Limiters.u1) annotation (Line(points={{-130,-200},{-130,-172},{
                      -106,-172},{-106,-162}}, color={0,0,127}));
              connect(Limiters.u2, VOEL) annotation (Line(points={{-94,-162},{-94,-174},{-70,
                      -174},{-70,-200}}, color={0,0,127}));
              connect(Limiters.y, add3_2.u3) annotation (Line(points={{-100,-139},{-100,-139},
                      {-100,-20},{-90,-20},{-90,-8},{-82,-8}}, color={0,0,127}));
              connect(feedback.y, limiter.u)
                annotation (Line(points={{-21,0},{-11.5,0},{-2,0}}, color={0,0,127}));
              connect(feedback.u1, add3_2.y)
                annotation (Line(points={{-38,0},{-59,0},{-59,0}}, color={0,0,127}));
              connect(feedback.u2, imDerivativeLag.y) annotation (Line(points={{-30,-8},{-30,
                      -8},{-30,-60},{71,-60}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    preserveAspectRatio=true,
                    initialScale=0.1), graphics={Text(
                      extent={{-186,-62},{-112,-82}},
                      lineColor={28,108,200},
                      textString="XADIFD")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end EXST1;

            model ESAC1A
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              import IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.invFEX;
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0 "Voltage input time constant (s)";
              parameter Real T_B=0 "AVR lead-lag time constant (s)";
              parameter Real T_C=0 "AVR lead-lag time constant (s)";
              parameter Real K_A=400 "AVR gain";
              parameter Real T_A=0.02 "AVR time constant (s)";
              parameter Real V_AMAX=9 "Maximum AVR output (pu)";
              parameter Real V_AMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F=1 "Rate feedback time const (s)";
              parameter Real K_C=0.2 "Rectifier load factor (pu)";
              parameter Real K_D=0.48 "Exciter demagnetizing factor (pu)";
              parameter Real K_E=1 "Exciter field factor (pu)";
              parameter Real E_1=5.25 "Exciter satutartion point 1 (pu)";
              parameter Real E_2=7 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_1=0.03 "Saturation at E1";
              parameter Real S_EE_2=0.1 "Saturation at E2";
              parameter Real V_RMAX "Maximum AVR output (pu)";
              parameter Real V_RMIN "Minimum AVR output (pu)";
              NonElectrical.Logical.HV_GATE hV_GATE
                annotation (Placement(transformation(extent={{20,46},{44,34}})));
              NonElectrical.Logical.LV_GATE lV_GATE
                annotation (Placement(transformation(extent={{58,46},{82,34}})));
              NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=VR0/K_A,
                x_start=VR0/K_A)
                annotation (Placement(transformation(extent={{-52,30},{-32,50}})));
              NonElectrical.Continuous.SimpleLag imSimpleLag(
                K=1,
                y_start=ECOMP0,
                T=T_R) annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{94,30},{114,50}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K_A,
                T=T_A,
                y_start=VR0,
                outMax=V_AMAX,
                outMin=V_AMIN)
                annotation (Placement(transformation(extent={{-16,30},{4,50}})));
              Modelica.Blocks.Continuous.Derivative derivative(
                k=K_F,
                T=T_F,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=0,
                x_start=VFE0)
                annotation (Placement(transformation(extent={{40,-10},{20,10}})));
              BaseClasses.RotatingExciterWithDemagnetizationLimited
                rotatingExciterWithDemagnetization(
                T_E=T_E,
                K_E=K_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                K_D=K_D,
                Efd0=VE0) annotation (Placement(transformation(extent={{124,30},{144,50}})));
              Modelica.Blocks.Math.Add3 add3_1(k3=-1)
                annotation (Placement(transformation(extent={{-88,30},{-68,50}})));
              BaseClasses.RectifierCommutationVoltageDrop rectifierCommutationVoltageDrop(
                  K_C=K_C)
                annotation (Placement(transformation(extent={{160,30},{180,50}})));
            protected
              parameter Real VR0(fixed=false);
              parameter Real Efd0(fixed=false);
              parameter Real Ifd0(fixed=false);
              parameter Real VE0(fixed=false);
              parameter Real VFE0(fixed=false);
            initial equation
              Ifd0 = XADIFD;
              VE0 = invFEX(
                K_C=K_C,
                Efd0=Efd0,
                Ifd0=Ifd0);
              VFE0 = VE0*(SE(
                VE0,
                S_EE_1,
                S_EE_2,
                E_1,
                E_2) + K_E) + Ifd0*K_D;
              VR0 = VFE0;
              V_REF = VR0/K_A + ECOMP0;
            equation
              connect(imLeadLag.y, simpleLagLim.u)
                annotation (Line(points={{-31,40},{-18,40}}, color={0,0,127}));
              connect(limiter1.y, rotatingExciterWithDemagnetization.I_C)
                annotation (Line(points={{115,40},{122.75,40}}, color={0,0,127}));
              connect(ECOMP, imSimpleLag.u)
                annotation (Line(points={{-200,0},{-172,0}}, color={0,0,127}));
              connect(simpleLagLim.y, hV_GATE.n1) annotation (Line(points={{5,40},{12,40},{
                      12,37},{18.5,37}}, color={0,0,127}));
              connect(VUEL, hV_GATE.n2) annotation (Line(points={{-130,-200},{-130,-40},{14,
                      -40},{14,43},{18.5,43}}, color={0,0,127}));
              connect(imSimpleLag.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,0},{
                      -132,-6},{-122,-6}}, color={0,0,127}));
              connect(add3_1.y, imLeadLag.u)
                annotation (Line(points={{-67,40},{-54,40}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2) annotation (Line(points={{-99,0},{-96,0},{-96,40},
                      {-90,40}}, color={0,0,127}));
              connect(VOTHSG, add3_1.u1) annotation (Line(points={{-200,90},{-150,90},{-96,
                      90},{-96,48},{-90,48}}, color={0,0,127}));
              connect(derivative.y, add3_1.u3) annotation (Line(points={{19,0},{-94,0},{-94,
                      32},{-90,32}}, color={0,0,127}));
              connect(derivative.u, rotatingExciterWithDemagnetization.V_FE) annotation (
                  Line(points={{42,0},{82,0},{120,0},{120,33.75},{122.75,33.75}}, color={0,
                      0,127}));
              connect(rotatingExciterWithDemagnetization.EFD,
                rectifierCommutationVoltageDrop.V_EX)
                annotation (Line(points={{145.25,40},{159,40}}, color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.EFD, EFD) annotation (Line(points={{
                      181,40},{190,40},{190,0},{210,0}}, color={0,0,127}));
              connect(hV_GATE.p, lV_GATE.n2) annotation (Line(points={{42.5,40},{50,40},{50,
                      43},{56.5,43}}, color={0,0,127}));
              connect(VOEL, lV_GATE.n1) annotation (Line(points={{-70,-200},{-70,-200},{-70,
                      -60},{50,-60},{50,37},{56.5,37}}, color={0,0,127}));
              connect(lV_GATE.p, limiter1.u)
                annotation (Line(points={{80.5,40},{92,40}}, color={0,0,127}));
              connect(XADIFD, rotatingExciterWithDemagnetization.XADIFD) annotation (Line(points={{80,-200},{80,-120},{134,-120},{134,28.75}}, color={0,0,127}));
              connect(XADIFD, rectifierCommutationVoltageDrop.XADIFD) annotation (Line(points={{80,-200},{80,-120},{170,-120},{170,29}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-186,-60},{-116,-80}},
                      lineColor={28,108,200},
                      textString="XADIFD"),Text(
                      extent={{-100,152},{100,92}},
                      lineColor={28,108,200},
                      textString="ESAC1A")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>ESAC1A, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Major change - 2016-01-19</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ESAC1A;

            model ESAC2A
              import IslandedOperationControl.OpenIPSL.NonElectrical.Functions.SE;
              import IslandedOperationControl.OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.invFEX;
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0 "Voltage input time constant (s)";
              parameter Real T_B=0 "AVR lead-lag time constant (s)";
              parameter Real T_C=0 "AVR lead-lag time constant (s)";
              parameter Real K_A=400 "AVR gain";
              parameter Real T_A=0.02 "AVR time constant (s)";
              parameter Real V_AMAX=9 "Maximum AVR output (pu)";
              parameter Real V_AMIN=-5.43 "Minimum AVR output (pu)";
              parameter Real T_E=0.8 "Exciter time constant (s)";
              parameter Real V_FEMAX=-5.43 "Minimum AVR output (pu)";
              parameter Real K_F=0.03 "Rate feedback gain (pu)";
              parameter Real T_F=1 "Rate feedback time const (s)";
              parameter Real K_C=0.2 "Rectifier load factor (pu)";
              parameter Real K_D=0.48 "Exciter demagnetizing factor (pu)";
              parameter Real K_E=1 "Exciter field factor (pu)";
              parameter Real E_1=5.25 "Exciter satutartion point 1 (pu)";
              parameter Real E_2=7 "Exciter saturation point 2 (pu)";
              parameter Real S_EE_1=0.03 "Saturation at E1";
              parameter Real S_EE_2=0.1 "Saturation at E2";
              parameter Real V_RMAX "Maximum AVR output (pu)";
              parameter Real V_RMIN "Minimum AVR output (pu)";
              NonElectrical.Logical.HV_GATE hV_GATE
                annotation (Placement(transformation(extent={{20,46},{44,34}})));
              NonElectrical.Logical.LV_GATE lV_GATE
                annotation (Placement(transformation(extent={{58,46},{82,34}})));
              NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=VR0/K_A,
                x_start=VR0/K_A)
                annotation (Placement(transformation(extent={{-52,30},{-32,50}})));
              NonElectrical.Continuous.SimpleLag imSimpleLag(
                K=1,
                y_start=ECOMP0,
                T=T_R) annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter1(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{94,30},{114,50}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K_A,
                T=T_A,
                y_start=VR0,
                outMax=V_AMAX,
                outMin=V_AMIN)
                annotation (Placement(transformation(extent={{-16,30},{4,50}})));
              Modelica.Blocks.Continuous.Derivative derivative(
                k=K_F,
                T=T_F,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=0,
                x_start=VFE0)
                annotation (Placement(transformation(extent={{40,-10},{20,10}})));
              BaseClasses.RotatingExciterWithDemagnetizationVarLim
                rotatingExciterWithDemagnetization(
                T_E=T_E,
                K_E=K_E,
                E_1=E_1,
                E_2=E_2,
                S_EE_1=S_EE_1,
                S_EE_2=S_EE_2,
                K_D=K_D,
                Efd0=VE0) annotation (Placement(transformation(extent={{124,30},{144,50}})));
              Modelica.Blocks.Math.Add3 add3_1(k3=-1)
                annotation (Placement(transformation(extent={{-88,30},{-68,50}})));
              BaseClasses.RectifierCommutationVoltageDrop rectifierCommutationVoltageDrop(
                  K_C=K_C)
                annotation (Placement(transformation(extent={{160,30},{180,50}})));
              Modelica.Blocks.Sources.Constant lowLim(k=0)
                annotation (Placement(transformation(extent={{180,70},{160,90}})));
              Modelica.Blocks.Sources.Constant FEMAX(k=V_FEMAX)
                annotation (Placement(transformation(extent={{40,120},{60,140}})));
              Modelica.Blocks.Math.Add DiffV1(k2=-1)
                annotation (Placement(transformation(extent={{80,120},{100,140}})));
              NonElectrical.Functions.ImSE se1(
                SE1=S_EE_1,
                SE2=S_EE_2,
                E1=E_1,
                E2=E_2) annotation (Placement(transformation(
                    extent={{-9,-6},{9,6}},
                    rotation=180,
                    origin={171,108})));
              Modelica.Blocks.Sources.Constant const(k=K_E)
                annotation (Placement(transformation(extent={{180,120},{160,140}})));
              Modelica.Blocks.Math.Add DiffV2
                annotation (Placement(transformation(extent={{150,108},{130,128}})));
              Modelica.Blocks.Math.Division division annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=-90,
                    origin={110,80})));
            protected
              parameter Real VR0(fixed=false);
              parameter Real Efd0(fixed=false);
              parameter Real Ifd0(fixed=false);
              parameter Real VE0(fixed=false);
              parameter Real VFE0(fixed=false);
            initial equation
              Ifd0 = XADIFD;
              // Finding initial value of excitation voltage, VE0, via going through conditions of FEX function
              VE0 = invFEX(
                K_C=K_C,
                Efd0=Efd0,
                Ifd0=Ifd0);
              // Case IN>0 not checked because it will be resolved in the next iteration
              VFE0 = VE0*(SE(
                VE0,
                S_EE_1,
                S_EE_2,
                E_1,
                E_2) + K_E) + Ifd0*K_D;
              VR0 = VFE0;
              V_REF = VR0/K_A + ECOMP0;
            equation
              connect(imLeadLag.y, simpleLagLim.u)
                annotation (Line(points={{-31,40},{-18,40}}, color={0,0,127}));
              connect(limiter1.y, rotatingExciterWithDemagnetization.I_C)
                annotation (Line(points={{115,40},{122.75,40}}, color={0,0,127}));
              connect(ECOMP, imSimpleLag.u)
                annotation (Line(points={{-200,0},{-172,0}}, color={0,0,127}));
              connect(simpleLagLim.y, hV_GATE.n1) annotation (Line(points={{5,40},{12,40},{
                      12,37},{18.5,37}}, color={0,0,127}));
              connect(VUEL, hV_GATE.n2) annotation (Line(points={{-130,-200},{-130,-40},{14,
                      -40},{14,43},{18.5,43}}, color={0,0,127}));
              connect(imSimpleLag.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,0},{
                      -132,-6},{-122,-6}}, color={0,0,127}));
              connect(add3_1.y, imLeadLag.u)
                annotation (Line(points={{-67,40},{-54,40}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2) annotation (Line(points={{-99,0},{-96,0},{-96,40},
                      {-90,40}}, color={0,0,127}));
              connect(VOTHSG, add3_1.u1) annotation (Line(points={{-200,90},{-150,90},{-96,
                      90},{-96,48},{-90,48}}, color={0,0,127}));
              connect(derivative.y, add3_1.u3) annotation (Line(points={{19,0},{-94,0},{-94,
                      32},{-90,32}}, color={0,0,127}));
              connect(derivative.u, rotatingExciterWithDemagnetization.V_FE) annotation (
                  Line(points={{42,0},{82,0},{120,0},{120,33.75},{122.75,33.75}}, color={0,
                      0,127}));
              connect(rotatingExciterWithDemagnetization.EFD,
                rectifierCommutationVoltageDrop.V_EX)
                annotation (Line(points={{145.25,40},{159,40}}, color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.XADIFD,
                rotatingExciterWithDemagnetization.XADIFD) annotation (Line(points={{170,29},{170,-20},{134,-20},{134,28.75}},
                                                                   color={0,0,127}));
              connect(rectifierCommutationVoltageDrop.EFD, EFD) annotation (Line(points={{
                      181,40},{190,40},{190,0},{210,0}}, color={0,0,127}));
              connect(hV_GATE.p, lV_GATE.n2) annotation (Line(points={{42.5,40},{50,40},{50,
                      43},{56.5,43}}, color={0,0,127}));
              connect(VOEL, lV_GATE.n1) annotation (Line(points={{-70,-200},{-70,-200},{-70,
                      -60},{50,-60},{50,37},{56.5,37}}, color={0,0,127}));
              connect(lV_GATE.p, limiter1.u)
                annotation (Line(points={{80.5,40},{92,40},{92,40}}, color={0,0,127}));
              connect(lowLim.y, rotatingExciterWithDemagnetization.outMin) annotation (Line(
                    points={{159,80},{150,80},{150,47.5},{145.25,47.5}}, color={0,0,127}));
              connect(FEMAX.y, DiffV1.u1) annotation (Line(points={{61,130},{68,130},{68,
                      136},{78,136}}, color={0,0,127}));
              connect(DiffV1.u2, rotatingExciterWithDemagnetization.XADIFD) annotation (
                  Line(points={{78,124},{66,124},{66,100},{86,100},{86,-20},{134,-20},{134,
                      28.75}}, color={0,0,127}));
              connect(se1.VE_IN, EFD) annotation (Line(points={{180.9,108},{190,108},{190,0},
                      {210,0}}, color={0,0,127}));
              connect(DiffV2.u1, const.y) annotation (Line(points={{152,124},{156,124},{156,
                      130},{159,130}}, color={0,0,127}));
              connect(DiffV2.u2, se1.VE_OUT) annotation (Line(points={{152,112},{156,112},{
                      156,108},{161.46,108}}, color={0,0,127}));
              connect(division.u1, DiffV1.y) annotation (Line(points={{116,92},{116,92},{
                      116,128},{116,130},{101,130}}, color={0,0,127}));
              connect(DiffV2.y, division.u2)
                annotation (Line(points={{129,118},{104,118},{104,92}}, color={0,0,127}));
              connect(division.y, rotatingExciterWithDemagnetization.outMax) annotation (
                  Line(points={{110,69},{110,60},{118,60},{118,47.5},{122.75,47.5}}, color=
                      {0,0,127}));
              connect(XADIFD, rotatingExciterWithDemagnetization.XADIFD) annotation (Line(points={{80,-200},{80,-140},{134,-140},{134,28.75}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                    graphics={Text(
                      extent={{-186,-60},{-116,-80}},
                      lineColor={28,108,200},
                      textString="XADIFD"),Text(
                      extent={{-100,152},{100,92}},
                      lineColor={28,108,200},
                      textString="ESAC1A")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>ESAC1A, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Major change - 2016-01-19</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ESAC2A;

            model ESST1A "IEEE Type ST1A Excitation System"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0 "Voltage input time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real V_IMAX
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real V_IMIN
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real T_C=0 "AVR lead-lag time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real T_B=0 "AVR lead-lag time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real T_C1=0 "AVR lead-lag time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real T_B1=0 "AVR lead-lag time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real K_A=400 "AVR gain"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real T_A=0.02 "AVR time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real V_AMAX "Maximum AVR output (pu)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real V_AMIN "Minimum AVR output (pu)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real V_RMAX=9
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real V_RMIN=-5.43
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real K_C=0.2 "Rectifier load factor (pu)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real K_F=0.03 "Rate feedback gain (pu)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real T_F=1 "Rate feedback time constant (s)"
                annotation (Dialog(group="Excitation system parameters"));
              parameter Real K_LR annotation (Dialog(group="Excitation system parameters"));
              parameter Real I_LR annotation (Dialog(group="Excitation system parameters"));
              Modelica.Blocks.Continuous.Derivative imDerivativeLag(
                y_start=0,
                k=K_F,
                T=T_F,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                x_start=Efd0)
                annotation (Placement(transformation(extent={{20,60},{0,80}})));
              Modelica.Blocks.Interfaces.RealInput VOTHSG2 "VOS=2" annotation (Placement(
                    transformation(extent={{-210,122},{-190,142}}), iconTransformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={-200,130})));
              Modelica.Blocks.Interfaces.RealInput VUEL3 "UEL=3" annotation (Placement(
                    transformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={50,-200}), iconTransformation(
                    extent={{9.95,-10.15},{-9.95,10.15}},
                    rotation=270,
                    origin={49.85,-199.95})));
              Modelica.Blocks.Nonlinear.Limiter imLimited(uMin=V_IMIN, uMax=V_IMAX)
                annotation (Placement(transformation(extent={{-64,-10},{-44,10}})));
              NonElectrical.Logical.HV_GATE hV_GATE
                annotation (Placement(transformation(extent={{-36.7,-5.5},{-14,6}})));
              Modelica.Blocks.Interfaces.RealInput VUEL2 "UEL=2" annotation (Placement(
                    transformation(
                    extent={{-20,-20},{20,20}},
                    rotation=90,
                    origin={-10,-200}), iconTransformation(
                    extent={{9.9,-9.9},{-9.9,9.9}},
                    rotation=270,
                    origin={-9.9,-199.9})));
              Modelica.Blocks.Math.Gain imGain(k=K_LR) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={40,-70})));
              NonElectrical.Logical.HV_GATE hV_GATE1
                annotation (Placement(transformation(extent={{105.3,-2.7},{126,8}})));
              NonElectrical.Logical.LV_GATE lV_GATE
                annotation (Placement(transformation(extent={{130.8,-6.7},{156,6}})));
              Modelica.Blocks.Interfaces.RealInput VT "sensed VT" annotation (Placement(
                    transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={150,-140}), iconTransformation(
                    extent={{-9.75,-10.25},{9.75,10.25}},
                    rotation=0,
                    origin={-199.75,49.75})));
              Modelica.Blocks.Sources.Constant Vref1(k=I_LR)
                annotation (Placement(transformation(extent={{0,-150},{20,-130}})));
              NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_C,
                T2=T_B,
                y_start=VA0/K_A,
                x_start=V_REF - ECOMP0)
                annotation (Placement(transformation(extent={{-8,-10},{12,10}})));
              NonElectrical.Continuous.LeadLag imLeadLag1(
                K=1,
                y_start=VA0/K_A,
                T1=T_C1,
                T2=T_B1,
                x_start=VA0/K_A)
                annotation (Placement(transformation(extent={{22,-9},{42,10}})));
              Modelica.Blocks.Math.Add3 add3_1(k1=-1)
                annotation (Placement(transformation(extent={{-92,-10},{-72,10}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=K_A,
                T=T_A,
                y_start=VA0,
                outMax=V_AMAX,
                outMin=V_AMIN)
                annotation (Placement(transformation(extent={{50,-10},{70,10}})));
              Modelica.Blocks.Math.Add add2(k1=-1) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={40,-120})));
              Modelica.Blocks.Nonlinear.Limiter imLimited1(uMax=Modelica.Constants.inf,
                  uMin=0) annotation (Placement(transformation(
                    extent={{-10,-9.6},{10,9.6}},
                    rotation=90,
                    origin={40.4,-40})));
              Modelica.Blocks.Math.Add3 add3_2(k3=-1)
                annotation (Placement(transformation(extent={{78,-10},{98,10}})));
              Modelica.Blocks.Math.Gain imGain1(k=V_RMIN) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={136,-30})));
              Modelica.Blocks.Math.Gain imGain2(k=V_RMAX) annotation (Placement(
                    transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={150,-70})));
              Modelica.Blocks.Math.Add add3(k1=-1) annotation (Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=270,
                    origin={170,-30})));
              Modelica.Blocks.Math.Gain imGain3(k=K_C) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={190,-70})));
              Modelica.Blocks.Nonlinear.VariableLimiter variableLimiter
                annotation (Placement(transformation(extent={{178,-10},{198,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Math.Add Limiters
                annotation (Placement(transformation(extent={{-120,-60},{-100,-40}})));
            protected
              parameter Real IFD0(fixed=false);
              parameter Real VA0(fixed=false);
            initial equation
              IFD0 = XADIFD;
              VA0 = Efd0 + K_LR*(IFD0 - I_LR);
              V_REF = VA0/K_A + ECOMP0;
            equation
              connect(add3_1.y, imLimited.u)
                annotation (Line(points={{-71,0},{-66,0}}, color={0,0,127}));
              connect(imLeadLag.y, imLeadLag1.u)
                annotation (Line(points={{13,0},{13,0.5},{20,0.5}}, color={0,0,127}));
              connect(simpleLagLim.u, imLeadLag1.y)
                annotation (Line(points={{48,0},{43,0},{43,0.5}}, color={0,0,127}));
              connect(Vref1.y, add2.u1)
                annotation (Line(points={{21,-140},{34,-140},{34,-132}}, color={0,0,127}));
              connect(imGain1.y, variableLimiter.limit2)
                annotation (Line(points={{136,-19},{136,-8},{176,-8}}, color={0,0,127}));
              connect(add3_1.u1, imDerivativeLag.y) annotation (Line(points={{-94,8},{-98,8},
                      {-98,70},{-1,70}}, color={0,0,127}));
              connect(VUEL2, hV_GATE.n2) annotation (Line(points={{-10,-200},{-10,-174},{-42,-174},{-42,-2.625},{-38.1188,-2.625}},
                                                             color={0,0,127}));
              connect(variableLimiter.y, EFD)
                annotation (Line(points={{199,0},{210,0}}, color={0,0,127}));
              connect(imGain3.y, add3.u1) annotation (Line(points={{190,-59},{190,-50},{176,
                      -50},{176,-42}}, color={0,0,127}));
              connect(imGain2.y, add3.u2) annotation (Line(points={{150,-59},{150,-50},{164,
                      -50},{164,-42}}, color={0,0,127}));
              connect(VT, imGain2.u) annotation (Line(points={{150,-140},{150,-111},{150,-82}},
                    color={0,0,127}));
              connect(VOEL, lV_GATE.n2) annotation (Line(points={{-70,-200},{-70,-200},{-70,
                      -100},{100,-100},{100,-3.525},{129.225,-3.525}}, color={0,0,127}));
              connect(imGain1.u, imGain2.u) annotation (Line(points={{136,-42},{136,-120},{
                      150,-120},{150,-82}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(DiffV.y, add3_1.u2)
                annotation (Line(points={{-99,0},{-94,0}}, color={0,0,127}));
              connect(VUEL, Limiters.u2) annotation (Line(points={{-130,-200},{-130,-200},{
                      -130,-56},{-122,-56}}, color={0,0,127}));
              connect(VOTHSG, Limiters.u1) annotation (Line(points={{-200,90},{-170,90},{-140,
                      90},{-140,-44},{-122,-44}}, color={0,0,127}));
              connect(Limiters.y, add3_1.u3) annotation (Line(points={{-99,-50},{-98,-50},{
                      -98,-8},{-94,-8}}, color={0,0,127}));
              connect(imLimited.y, hV_GATE.n1) annotation (Line(points={{-43,0},{-42,0},{-42,3.125},{-38.1188,3.125}},
                                                color={0,0,127}));
              connect(VOTHSG2, add3_2.u1) annotation (Line(points={{-200,132},{70,132},{70,
                      8},{76,8}}, color={0,0,127}));
              connect(lV_GATE.p, variableLimiter.u) annotation (Line(points={{154.425,-0.35},
                      {164.213,-0.35},{164.213,0},{176,0}}, color={0,0,127}));
              connect(hV_GATE1.p, lV_GATE.n1) annotation (Line(points={{124.706,2.65},{124.228,2.65},{124.228,2.825},{129.225,2.825}},
                                                                      color={0,0,127}));
              connect(add3_2.y, hV_GATE1.n1) annotation (Line(points={{99,0},{100,0},{100,5.325},{104.006,5.325}},
                                               color={0,0,127}));
              connect(imDerivativeLag.u, hV_GATE1.n1) annotation (Line(points={{22,70},{102,70},{102,5.325},{104.006,5.325}},
                                                        color={0,0,127}));
              connect(imGain.u, add2.y)
                annotation (Line(points={{40,-82},{40,-109},{40,-109}}, color={0,0,127}));
              connect(imLimited1.u, imGain.y)
                annotation (Line(points={{40.4,-52},{40,-52},{40,-59}}, color={0,0,127}));
              connect(imLimited1.y, add3_2.u3) annotation (Line(points={{40.4,-29},{40.4,-20},
                      {70,-20},{70,-8},{76,-8}}, color={0,0,127}));
              connect(add3.y, variableLimiter.limit1)
                annotation (Line(points={{170,-19},{170,8},{176,8}}, color={0,0,127}));
              connect(simpleLagLim.y, add3_2.u2)
                annotation (Line(points={{71,0},{76,0}}, color={0,0,127}));
              connect(hV_GATE.p, imLeadLag.u) annotation (Line(points={{-15.4187,0.25},{-12.7094,0.25},{-12.7094,0},{-10,0}},
                                                   color={0,0,127}));
              connect(VUEL3, hV_GATE1.n2) annotation (Line(points={{50,-200},{50,-200},{50,-174},{110,-174},{110,-20},{104.006,-20},{104.006,-0.025}},
                                                                                  color={0,
                      0,127}));
              connect(XADIFD, add2.u2) annotation (Line(points={{80,-200},{80,-160},{46,-160},{46,-132}}, color={0,0,127}));
              connect(XADIFD, imGain3.u) annotation (Line(points={{80,-200},{80,-160},{190,-160},{190,-82}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    grid={2,2},
                    initialScale=0.1), graphics={Text(
                      extent={{-162,112},{-134,95}},
                      lineColor={0,128,0},
                      textString="(VOS=1)"),Text(
                      extent={{-23,-160},{5,-174}},
                      lineColor={0,128,0},
                      textString="(UEL=2)"),Text(
                      extent={{-144,-160},{-116,-174}},
                      lineColor={0,128,0},
                      textString="(UEL=1)"),Text(
                      extent={{33,-160},{61,-174}},
                      lineColor={0,128,0},
                      textString="(UEL=3)"),Text(
                      extent={{-190,140},{-108,120}},
                      lineColor={28,108,200},
                      textString="VOTHSG2"),Text(
                      extent={{-162,152},{-134,135}},
                      lineColor={0,128,0},
                      textString="(VOS=2)"),Text(
                      extent={{-184,60},{-156,40}},
                      lineColor={28,108,200},
                      textString="VT"),Text(
                      extent={{-184,-62},{-114,-82}},
                      lineColor={28,108,200},
                      textString="XADIFD"),Text(
                      extent={{-36,-170},{16,-190}},
                      lineColor={28,108,200},
                      textString="VUEL"),Text(
                      extent={{24,-170},{76,-190}},
                      lineColor={28,108,200},
                      textString="VUEL")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end ESST1A;

            model URST5T "IEEE Proposed Type ST5B Excitation System"
              extends
                OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.BaseExciter;
              parameter Real T_R=0.025;
              parameter Real T_C1=0.1;
              parameter Real T_B1=0.2;
              parameter Real T_C2=1;
              parameter Real T_B2=1;
              parameter Real KR=1;
              parameter Real V_RMAX=10;
              parameter Real V_RMIN=-10;
              parameter Real T_1=0.58;
              parameter Real K_C=0.3;
              Modelica.Blocks.Math.Add VERR1 annotation (Placement(transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=0,
                    origin={-10,0})));
              NonElectrical.Logical.LV_GATE lV_Gate
                annotation (Placement(transformation(extent={{-56,-6},{-32,6}})));
              NonElectrical.Logical.HV_GATE hV_Gate
                annotation (Placement(transformation(extent={{-86,-6},{-64,6}})));
              NonElectrical.Continuous.LeadLagLim LL1(
                K=1,
                outMax=V_RMAX/KR,
                outMin=V_RMIN/KR,
                T1=T_C1,
                T2=T_B1,
                y_start=VR0/KR)
                annotation (Placement(transformation(extent={{10,-10},{30,10}})));
              NonElectrical.Continuous.LeadLagLim LL2(
                K=1,
                outMax=V_RMAX/KR,
                outMin=V_RMIN/KR,
                T1=T_C2,
                T2=T_B2,
                y_start=VR0/KR)
                annotation (Placement(transformation(extent={{40,-10},{60,10}})));
              Modelica.Blocks.Math.Gain K_R(k=KR) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=0,
                    origin={80,0})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=V_RMAX, uMin=V_RMIN)
                annotation (Placement(transformation(extent={{100,-10},{120,10}})));
              Modelica.Blocks.Math.Add VERR2(k1=-1, k2=1) annotation (Placement(
                    transformation(
                    extent={{-10,10},{10,-10}},
                    rotation=0,
                    origin={178,0})));
              Modelica.Blocks.Math.Gain K_c(k=K_C) annotation (Placement(transformation(
                    extent={{-10,-10},{10,10}},
                    rotation=90,
                    origin={160,-30})));
              Modelica.Blocks.Math.Gain Vmin(k=V_RMIN) annotation (Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=0,
                    origin={150,50})));
              Modelica.Blocks.Math.Gain Vmax(k=V_RMAX) annotation (Placement(transformation(
                    extent={{10,-10},{-10,10}},
                    rotation=0,
                    origin={150,90})));
              NonElectrical.Continuous.SimpleLagLimVar simpleLagLimVar(
                K=1,
                T=T_1,
                y_start=VR0)
                annotation (Placement(transformation(extent={{130,-10},{150,10}})));
              NonElectrical.Continuous.SimpleLag TransducerDelay(
                K=1,
                T=T_R,
                y_start=ECOMP0)
                annotation (Placement(transformation(extent={{-170,-10},{-150,10}})));
              Modelica.Blocks.Interfaces.RealInput VT annotation (Placement(transformation(
                    extent={{20,-20},{-20,20}},
                    rotation=0,
                    origin={200,70}), iconTransformation(extent={{-10,-10},{10,10}}, origin=
                       {-200,50})));
            protected
              parameter Real VR0(fixed=false);
            initial equation
              VR0 = Efd0 + K_C*XADIFD;
              V_REF = VR0/KR + ECOMP;
            equation
              connect(LL1.u, VERR1.y)
                annotation (Line(points={{8,0},{8,0},{1,0}}, color={0,0,127}));
              connect(LL1.y, LL2.u)
                annotation (Line(points={{31,0},{31,0},{38,0}}, color={0,0,127}));
              connect(ECOMP, TransducerDelay.u)
                annotation (Line(points={{-200,0},{-186,0},{-172,0}}, color={0,0,127}));
              connect(TransducerDelay.y, DiffV.u2) annotation (Line(points={{-149,0},{-132,
                      0},{-132,-6},{-122,-6}}, color={0,0,127}));
              connect(VUEL, hV_Gate.n1) annotation (Line(points={{-130,-200},{-130,-200},{-130,
                      -20},{-90,-20},{-90,3},{-87.375,3}}, color={0,0,127}));
              connect(DiffV.y, hV_Gate.n2) annotation (Line(points={{-99,0},{-92,0},{-92,-3},
                      {-87.375,-3}}, color={0,0,127}));
              connect(VOEL, lV_Gate.n2) annotation (Line(points={{-70,-200},{-70,-200},{-70,
                      -34},{-70,-20},{-60,-20},{-60,-3},{-57.5,-3}}, color={0,0,127}));
              connect(hV_Gate.p, lV_Gate.n1) annotation (Line(points={{-65.375,0},{-62,0},{
                      -62,3},{-57.5,3}}, color={0,0,127}));
              connect(lV_Gate.p, VERR1.u1) annotation (Line(points={{-33.5,0},{-30,0},{-30,
                      -6},{-22,-6}}, color={0,0,127}));
              connect(VOTHSG, VERR1.u2) annotation (Line(points={{-200,90},{-200,90},{-30,
                      90},{-30,6},{-22,6}}, color={0,0,127}));
              connect(LL2.y, K_R.u)
                annotation (Line(points={{61,0},{61,0},{68,0}}, color={0,0,127}));
              connect(K_R.y, limiter.u)
                annotation (Line(points={{91,0},{98,0}}, color={0,0,127}));
              connect(limiter.y, simpleLagLimVar.u)
                annotation (Line(points={{121,0},{124.5,0},{128,0}}, color={0,0,127}));
              connect(VERR2.y, EFD)
                annotation (Line(points={{189,0},{210,0}}, color={0,0,127}));
              connect(K_c.y, VERR2.u1) annotation (Line(points={{160,-19},{160,-19},{160,-6},
                      {166,-6}}, color={0,0,127}));
              connect(simpleLagLimVar.y, VERR2.u2) annotation (Line(points={{151,0},{160,0},
                      {160,6},{166,6}}, color={0,0,127}));
              connect(VT, Vmax.u) annotation (Line(points={{200,70},{172,70},{172,90},{162,
                      90}}, color={0,0,127}));
              connect(Vmin.u, Vmax.u) annotation (Line(points={{162,50},{172,50},{172,90},{
                      162,90}}, color={0,0,127}));
              connect(Vmin.y, simpleLagLimVar.outMin) annotation (Line(points={{139,50},{
                      124,50},{124,-20},{132,-20},{132,-14}}, color={0,0,127}));
              connect(Vmax.y, simpleLagLimVar.outMax) annotation (Line(points={{139,90},{
                      128,90},{128,20},{148,20},{148,14}}, color={0,0,127}));
              connect(K_c.u, XADIFD) annotation (Line(points={{160,-42},{160,-140},{80,-140},{80,-200}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-200,-200},{200,160}},
                    preserveAspectRatio=true,
                    initialScale=0.1), graphics={Text(
                      extent={{-188,60},{-154,40}},
                      lineColor={28,108,200},
                      textString="VT"),Text(
                      extent={{-178,-62},{-114,-82}},
                      lineColor={28,108,200},
                      textString="XADIFD")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-29</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
            end URST5T;

            package BaseClasses
              model SelectLogic
                "Selection of voltage signal depending on the Excitation limiters"
                Modelica.Blocks.Interfaces.RealInput V1
                  annotation (Placement(transformation(extent={{-138,40},{-98,80}})));
                Modelica.Blocks.Interfaces.RealInput V2
                  annotation (Placement(transformation(extent={{-138,-20},{-98,20}})));
                Modelica.Blocks.Interfaces.RealInput V3
                  annotation (Placement(transformation(extent={{-138,-80},{-98,-40}})));
                Modelica.Blocks.Interfaces.RealInput VOEL annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=270,
                      origin={-60,96}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=270,
                      origin={-60,112})));
                Modelica.Blocks.Interfaces.RealInput VUEL annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=270,
                      origin={0,96}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=270,
                      origin={0,112})));
                Modelica.Blocks.Interfaces.RealInput VERR annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=270,
                      origin={60,96}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=270,
                      origin={60,112})));
                Modelica.Blocks.Interfaces.RealOutput Vout
                  annotation (Placement(transformation(extent={{100,10},{120,30}})));
              equation
                Vout = if VOEL > 0 then V3 else if VUEL > 0 then V2 else V1;
                annotation (
                  Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                          100}}), graphics),
                  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                          100}}), graphics={Text(
                        extent={{-42,54},{38,-48}},
                        lineColor={0,0,255},
                        textString="Select
Logic"),              Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,0,255})}),
                  Documentation);
              end SelectLogic;

              partial model BaseExciter
                Modelica.Blocks.Interfaces.RealInput VUEL annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={-130,-200}), iconTransformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={-130,-200})));
                Modelica.Blocks.Interfaces.RealInput VOEL annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={-70,-200}), iconTransformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={-70,-200})));
                Modelica.Blocks.Interfaces.RealOutput EFD "Excitation Voltage (pu)"
                  annotation (Placement(transformation(extent={{200,-10},{220,10}})));
                Modelica.Blocks.Interfaces.RealInput EFD0 annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=0,
                      origin={-200,-130}), iconTransformation(extent={{-10,-10},{10,10}},
                        origin={-200,-130})));
                Modelica.Blocks.Interfaces.RealInput VOTHSG annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=0,
                      origin={-200,90}), iconTransformation(extent={{-10,-10},{10,10}},
                        origin={-200,90})));
                Modelica.Blocks.Interfaces.RealInput ECOMP annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=0,
                      origin={-200,0}), iconTransformation(extent={{-10,-10},{10,10}}, origin=
                         {-200,0})));
                Modelica.Blocks.Sources.Constant VoltageReference(k=V_REF)
                  annotation (Placement(transformation(extent={{-170,40},{-150,60}})));
                Modelica.Blocks.Math.Add DiffV(k2=-1)
                  annotation (Placement(transformation(extent={{-120,-10},{-100,10}})));
              protected
                parameter Real Efd0(fixed=false);
                parameter Real V_REF(fixed=false);
                parameter Real ECOMP0(fixed=false);
              public
                Modelica.Blocks.Interfaces.RealInput XADIFD annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={80,-200}), iconTransformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={90,-196})));
              initial equation
                Efd0 = EFD0;
                ECOMP0 = ECOMP;
              equation
                connect(VoltageReference.y, DiffV.u1) annotation (Line(points={{-149,50},{-132,
                        50},{-132,6},{-122,6}}, color={0,0,127}));
                annotation (
                  Icon(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1),
                      graphics={Rectangle(
                        extent={{-200,160},{200,-200}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid),Text(
                        extent={{-154,-170},{-102,-190}},
                        lineColor={28,108,200},
                        textString="VUEL"),Text(
                        extent={{-92,-170},{-40,-190}},
                        lineColor={28,108,200},
                        textString="VOEL"),Text(
                        extent={{-184,8},{-114,-12}},
                        lineColor={28,108,200},
                        textString="ECOMP"),Text(
                        extent={{-188,100},{-106,80}},
                        lineColor={28,108,200},
                        textString="VOTHSG"),Text(
                        extent={{-182,-122},{-130,-142}},
                        lineColor={28,108,200},
                        textString="EFD0"),Text(
                        extent={{152,12},{194,-8}},
                        lineColor={28,108,200},
                        textString="EFD")}),
                  Diagram(coordinateSystem(extent={{-200,-200},{200,160}}, initialScale=0.1)),
                  Documentation);
              end BaseExciter;

              model RotatingExciter
                extends
                  OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.RotatingExciterBase(
                    redeclare replaceable Modelica.Blocks.Continuous.Integrator
                    sISO(
                    k=1/T_E,
                    initType=Modelica.Blocks.Types.Init.InitialOutput,
                    y_start=Efd0));
                annotation (
                  Icon(coordinateSystem(initialScale=0.05, extent={{-80,-80},{80,80}}),
                      graphics={Rectangle(
                        extent={{-80,80},{80,-80}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid),Text(
                        extent={{-52,70},{44,56}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Rotating Exciter"),Text(
                        extent={{-81,4},{-57,-6}},
                        lineColor={28,108,200},
                        textString="I_C"),Text(
                        extent={{56,6},{77,-4}},
                        lineColor={28,108,200},
                        textString="V_E")}),
                  Diagram(coordinateSystem(initialScale=0.05, extent={{-80,-80},{80,80}})),
                  Documentation);
              end RotatingExciter;

              model RotatingExciterLimited
                extends RotatingExciterBase(redeclare replaceable
                    Modelica.Blocks.Continuous.LimIntegrator sISO(
                    k=1/T_E,
                    y_start=Efd0,
                    outMin=0,
                    outMax=Modelica.Constants.inf,
                    initType=Modelica.Blocks.Types.Init.InitialOutput));
                annotation (Icon(graphics={Text(
                        extent={{-56,56},{52,44}},
                        lineColor={255,0,0},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Limited")}), Documentation);
              end RotatingExciterLimited;

              model RotatingExciterWithDemagnetization
                extends
                  OpenIPSL.Electrical.Controls.PSSE.ES.BaseClasses.RotatingExciterBase(
                    redeclare Modelica.Blocks.Math.Add3 Sum(k3=K_D), redeclare
                    replaceable Modelica.Blocks.Continuous.Integrator sISO(
                    k=1/T_E,
                    initType=Modelica.Blocks.Types.Init.InitialOutput,
                    y_start=Efd0));
                parameter Real K_D "Exciter demagnetizing factor (pu)";
                Modelica.Blocks.Interfaces.RealInput XADIFD annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={10,-100}), iconTransformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={0,-90})));
                Modelica.Blocks.Interfaces.RealOutput V_FE annotation (Placement(
                      transformation(
                      extent={{-10,10},{10,-10}},
                      rotation=180,
                      origin={-90,-40}), iconTransformation(extent={{-80,-60},{-100,-40}})));
              equation
                connect(XADIFD, Sum.u3) annotation (Line(points={{10,-100},{0,-100},{0,-38},{
                        -18,-38}}, color={0,0,127}));
                connect(V_FE, feedback.u2)
                  annotation (Line(points={{-90,-40},{-50,-40},{-50,12}}, color={0,0,127}));
                annotation (
                  Icon(coordinateSystem(initialScale=0.05, extent={{-80,-80},{80,80}}),
                      graphics={Rectangle(
                        extent={{-80,80},{80,-80}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid),Text(
                        extent={{-50,70},{46,56}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Rotating Exciter"),Text(
                        extent={{-81,4},{-57,-6}},
                        lineColor={28,108,200},
                        textString="I_C"),Text(
                        extent={{56,6},{77,-4}},
                        lineColor={28,108,200},
                        textString="V_E"),Text(
                        extent={{-56,60},{52,44}},
                        lineColor={255,0,0},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="with Demagnetization Effect"),Text(
                        extent={{-19,-64},{18,-74}},
                        lineColor={28,108,200},
                        textString="XADIFD"),Text(
                        extent={{-77,-44},{-53,-54}},
                        lineColor={28,108,200},
                        textString="V_FE")}),
                  Diagram(coordinateSystem(initialScale=0.05, extent={{-80,-80},{80,80}})),
                  Documentation);
              end RotatingExciterWithDemagnetization;

              model RotatingExciterWithDemagnetizationLimited
                extends RotatingExciterWithDemagnetization(redeclare replaceable
                    Modelica.Blocks.Continuous.LimIntegrator sISO(
                    outMin=0,
                    k=1/T_E,
                    initType=Modelica.Blocks.Types.Init.InitialOutput,
                    y_start=Efd0,
                    outMax=Modelica.Constants.inf));
                annotation (Icon(graphics={Text(
                        extent={{-54,48},{52,36}},
                        lineColor={255,0,0},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Limited")}), Documentation);
              end RotatingExciterWithDemagnetizationLimited;

              model RotatingExciterWithDemagnetizationVarLim
                extends RotatingExciterBase(redeclare replaceable
                    OpenIPSL.NonElectrical.Continuous.IntegratorLimVar sISO(K=1/T_E,
                      y_start=Efd0),
                               redeclare Modelica.Blocks.Math.Add3 Sum(k3=K_D));
                parameter Real K_D "Exciter demagnetizing factor (pu)";
                Modelica.Blocks.Interfaces.RealInput outMin annotation (Placement(
                      transformation(extent={{-120,50},{-80,90}}), iconTransformation(extent=
                          {{100,50},{80,70}})));
                Modelica.Blocks.Interfaces.RealInput outMax annotation (Placement(
                      transformation(extent={{120,50},{80,90}}), iconTransformation(extent={{
                          -100,50},{-80,70}})));
                Modelica.Blocks.Interfaces.RealInput XADIFD annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={20,-100}), iconTransformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={0,-90})));
                Modelica.Blocks.Interfaces.RealOutput V_FE annotation (Placement(
                      transformation(
                      extent={{-10,10},{10,-10}},
                      rotation=180,
                      origin={-82,-32}), iconTransformation(extent={{-80,-60},{-100,-40}})));
              equation
                connect(outMax, sISO.outMax)
                  annotation (Line(points={{100,70},{8,70},{8,34}}, color={0,0,127}));
                connect(outMin, sISO.outMin) annotation (Line(points={{-100,70},{-60,70},{-20,
                        70},{-20,0},{-8,0},{-8,6}}, color={0,0,127}));
                connect(XADIFD, Sum.u3) annotation (Line(points={{20,-100},{8,-100},{8,-38},{
                        -18,-38}}, color={0,0,127}));
                connect(V_FE, feedback.u2)
                  annotation (Line(points={{-82,-32},{-50,-32},{-50,12}}, color={0,0,127}));
                annotation (Icon(graphics={Text(
                        extent={{-54,48},{52,36}},
                        lineColor={255,0,0},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Limited"),Text(
                        extent={{-79,66},{-48,56}},
                        lineColor={28,108,200},
                        textString="outMax"),Text(
                        extent={{47,66},{78,56}},
                        lineColor={28,108,200},
                        textString="outMin"),Text(
                        extent={{-52,60},{56,44}},
                        lineColor={255,0,0},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="with Demagnetization Effect")}), Documentation);
              end RotatingExciterWithDemagnetizationVarLim;

              model RectifierCommutationVoltageDrop
                parameter Real K_C "Rectifier load factor (pu)";
                Modelica.Blocks.Interfaces.RealInput V_EX annotation (Placement(
                      transformation(extent={{-140,-20},{-100,20}}), iconTransformation(
                        extent={{-120,-10},{-100,10}})));
                Modelica.Blocks.Interfaces.RealInput XADIFD annotation (Placement(
                      transformation(
                      extent={{-20,-20},{20,20}},
                      rotation=0,
                      origin={-120,50}), iconTransformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={0,-110})));
                Modelica.Blocks.Interfaces.RealOutput EFD annotation (Placement(
                      transformation(extent={{100,-10},{120,10}}), iconTransformation(extent=
                          {{100,-10},{120,10}})));
                Modelica.Blocks.Math.Gain gain2(k=K_C) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=0,
                      origin={-70,50})));
                NonElectrical.Nonlinear.FEX fEX annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=0,
                      origin={10,0})));
                Modelica.Blocks.Math.Product product1 annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=0,
                      origin={70,0})));
                Modelica.Blocks.Math.Division division
                  annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
              equation
                connect(V_EX, division.u2) annotation (Line(points={{-120,0},{-80,0},{-80,-6},
                        {-42,-6}}, color={0,0,127}));
                connect(XADIFD, gain2.u)
                  annotation (Line(points={{-120,50},{-82,50},{-82,50}}, color={0,0,127}));
                connect(gain2.y, division.u1) annotation (Line(points={{-59,50},{-52,50},{-52,
                        6},{-42,6}}, color={0,0,127}));
                connect(division.y, fEX.u)
                  annotation (Line(points={{-19,0},{-9.5,0},{0,0}}, color={0,0,127}));
                connect(product1.y, EFD)
                  annotation (Line(points={{81,0},{110,0}}, color={0,0,127}));
                connect(fEX.y, product1.u2)
                  annotation (Line(points={{21,0},{48,0},{48,-6},{58,-6}}, color={0,0,127}));
                connect(product1.u1, division.u2) annotation (Line(points={{58,6},{48,6},{48,
                        20},{-80,20},{-80,-6},{-42,-6}}, color={0,0,127}));
                annotation (
                  Icon(coordinateSystem(initialScale=0.1), graphics={Rectangle(
                        extent={{-100,100},{100,-100}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid),Text(
                        extent={{-68,96},{70,60}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Rectifier Commutation 
Voltage Drop"),              Text(
                        extent={{-99,4},{-70,-6}},
                        lineColor={28,108,200},
                        textString="V_EX"),Text(
                        extent={{-19,-86},{18,-96}},
                        lineColor={28,108,200},
                        textString="XADIFD"),Text(
                        extent={{76,6},{98,-4}},
                        lineColor={28,108,200},
                        textString="EFD")}),
                  Diagram(coordinateSystem(initialScale=0.1)),
                  Documentation);
              end RectifierCommutationVoltageDrop;

              function calculate_dc_exciter_params
                "Automatic Calculation of DC Exciter Parameters"
                input Real V_RMAX_init;
                input Real V_RMIN_init;
                input Real K_E_init;
                input Real E_2;
                input Real S_EE_2;
                input Real Efd0;
                input Real SE_Efd0;
                output Real V_RMAX;
                output Real V_RMIN;
                output Real K_E;
              algorithm
                if V_RMAX_init == 0 then
                  if K_E_init <= 0 then
                    V_RMAX := S_EE_2*E_2;
                  else
                    V_RMAX := S_EE_2 + K_E_init;
                  end if;
                else
                  V_RMAX := V_RMAX_init;
                end if;
                if K_E_init == 0 then
                  K_E := V_RMAX/(10*Efd0) - SE_Efd0;
                else
                  K_E := K_E_init;
                end if;
                if V_RMAX_init == 0 then
                  V_RMIN := -V_RMAX;
                else
                  V_RMIN := V_RMIN_init;
                end if;
                annotation (Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PAGV2 - Section 15.2.4, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-19</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
              end calculate_dc_exciter_params;

              model RotatingExciterBase
                parameter Real T_E "Exciter time constant (s)";
                parameter Real K_E "Exciter field gain";
                parameter Real E_1 "Exciter saturation point 1 (pu)";
                parameter Real E_2 "Exciter saturation point 2 (pu)";
                parameter Real S_EE_1 "Saturation at E_1";
                parameter Real S_EE_2 "Saturation at E_2";
                parameter Real Efd0;
                Modelica.Blocks.Interfaces.RealInput I_C annotation (Placement(transformation(
                        extent={{-120,-20},{-80,20}}), iconTransformation(extent={{-100,-10},
                          {-80,10}})));
                Modelica.Blocks.Interfaces.RealOutput EFD annotation (Placement(
                      transformation(extent={{80,-10},{100,10}}), iconTransformation(extent={
                          {80,-10},{100,10}})));
                Modelica.Blocks.Math.Gain gain(k=K_E) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=180,
                      origin={30,-50})));
                replaceable Modelica.Blocks.Math.Add Sum annotation (Placement(transformation(
                      extent={{-10,10},{10,-10}},
                      rotation=180,
                      origin={-30,-30})));
                Modelica.Blocks.Math.Product VE annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=180,
                      origin={30,-10})));
                NonElectrical.Functions.ImSE se1(
                  SE1=S_EE_1,
                  SE2=S_EE_2,
                  E1=E_1,
                  E2=E_2) annotation (Placement(transformation(
                      extent={{-9,-6},{9,6}},
                      rotation=180,
                      origin={61,-4})));
                Modelica.Blocks.Math.Feedback feedback
                  annotation (Placement(transformation(extent={{-60,10},{-40,30}})));
                replaceable Modelica.Blocks.Interfaces.SISO sISO
                  annotation (Placement(transformation(extent={{-10,10},{10,30}})));
              equation
                connect(Sum.y, feedback.u2) annotation (Line(points={{-41,-30},{-41,-30},{-50,
                        -30},{-50,12}}, color={0,0,127}));
                connect(se1.VE_OUT, VE.u2)
                  annotation (Line(points={{51.46,-4},{42,-4}}, color={0,0,127}));
                connect(se1.VE_IN, EFD) annotation (Line(points={{70.9,-4},{76,-4},{76,0},{90,
                        0}}, color={0,0,127}));
                connect(VE.u1, EFD) annotation (Line(points={{42,-16},{76,-16},{76,0},{90,0}},
                      color={0,0,127}));
                connect(gain.u, EFD) annotation (Line(points={{42,-50},{76,-50},{76,0},{90,0}},
                      color={0,0,127}));
                connect(gain.y, Sum.u2) annotation (Line(points={{19,-50},{-12,-50},{-12,-30},
                        {-18,-30}}, color={0,0,127}));
                connect(VE.y, Sum.u1) annotation (Line(points={{19,-10},{-12,-10},{-12,-22},{
                        -18,-22}}, color={0,0,127}));
                connect(I_C, feedback.u1) annotation (Line(points={{-100,0},{-68,0},{-68,20},
                        {-58,20}}, color={0,0,127}));
                connect(feedback.y, sISO.u)
                  annotation (Line(points={{-41,20},{-12,20},{-12,20}}, color={0,0,127}));
                connect(sISO.y, EFD)
                  annotation (Line(points={{11,20},{76,20},{76,0},{90,0}}, color={0,0,127}));
                annotation (
                  Icon(coordinateSystem(initialScale=0.05, extent={{-80,-80},{80,80}}),
                      graphics={Rectangle(
                        extent={{-80,80},{80,-80}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid),Text(
                        extent={{-52,70},{44,56}},
                        lineColor={28,108,200},
                        fillColor={255,255,255},
                        fillPattern=FillPattern.Solid,
                        textString="Rotating Exciter"),Text(
                        extent={{-81,4},{-57,-6}},
                        lineColor={28,108,200},
                        textString="I_C"),Text(
                        extent={{56,6},{77,-4}},
                        lineColor={28,108,200},
                        textString="V_E")}),
                  Diagram(coordinateSystem(initialScale=0.05, extent={{-80,-80},{80,80}})),
                  Documentation);
              end RotatingExciterBase;

              function invFEX "Inverse F_EX function for initialization"
                input Real K_C=K_C;
                input Real Efd0;
                input Real Ifd0;
                output Real VE0;
              algorithm
                if Ifd0 <= 0 then
                  VE0 := Efd0;
                elseif K_C*Ifd0/(Efd0 + 0.577*K_C*Ifd0) <= 0.433 then
                  VE0 := Efd0 + 0.577*K_C*Ifd0;
                elseif K_C*Ifd0/sqrt((Efd0^2 + (K_C*Ifd0)^2)/0.75) > 0.433 and K_C*Ifd0/sqrt(
                    (Efd0^2 + (K_C*Ifd0)^2)/0.75) < 0.75 then
                  VE0 := sqrt((Efd0^2 + (K_C*Ifd0)^2)/0.75);
                else
                  VE0 := (Efd0 + 1.732*K_C*Ifd0)/1.732;
                end if;
                annotation (Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PAGV2 - Section 15.2.4, PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2016-04-19</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Tin Rabuzin, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
              end invFEX;
            annotation (Documentation);
            end BaseClasses;
          annotation (Documentation(info="<html>
</html>"));
          end ES;

          package TG
            model ConstantPower
            extends BaseClasses.BaseGovernor;
            equation
              connect(PMECH0, PMECH) annotation (Line(points={{-100,-50},{0,-50},{0,0},{110,
                      0}}, color={0,0,127}));
              annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
                    coordinateSystem(preserveAspectRatio=false)));
            end ConstantPower;

            model IEEEG1
              Modelica.Blocks.Interfaces.RealInput SPEED_HP "Machine speed deviation from nominal (pu)"
                annotation (Placement(transformation(extent={{-172,2},{-162,14}}), iconTransformation(extent={{-162,-16},{-132,16}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag imLeadLag(
                K=K,
                T1=T_2,
                T2=T_1,
                y_start=0) annotation (Placement(transformation(extent={{-144,0},
                        {-128,16}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag(
                K=1,
                T=T_4,
                y_start=P0) annotation (Placement(transformation(extent={{-20,0},
                        {-4,16}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag1(
                K=1,
                T=T_5,
                y_start=P0)
                annotation (Placement(transformation(extent={{22,0},{38,16}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag2(
                K=1,
                T=T_6,
                y_start=P0)
                annotation (Placement(transformation(extent={{62,0},{78,16}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag3(
                K=1,
                T=T_7,
                y_start=P0) annotation (Placement(transformation(extent={{102,0},
                        {118,16}})));
              Modelica.Blocks.Math.Gain imGain1(k=K_1) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=90,
                    origin={10,32})));
              Modelica.Blocks.Math.Gain imGain2(k=K_2) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=-90,
                    origin={10,-16})));
              Modelica.Blocks.Math.Gain imGain3(k=K_3) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=90,
                    origin={50,32})));
              Modelica.Blocks.Math.Gain imGain4(k=K_4) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=-90,
                    origin={50,-16})));
              Modelica.Blocks.Math.Gain imGain5(k=K_5) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=90,
                    origin={90,32})));
              Modelica.Blocks.Math.Gain imGain6(k=K_6) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=-90,
                    origin={90,-16})));
              Modelica.Blocks.Math.Gain imGain7(k=K_7) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=90,
                    origin={130,32})));
              Modelica.Blocks.Math.Gain imGain8(k=K_8) annotation (Placement(transformation(
                    extent={{-6,-6},{6,6}},
                    rotation=-90,
                    origin={130,-16})));
              Modelica.Blocks.Interfaces.RealOutput PMECH_HP
                "Turbine mechanical power (pu)" annotation (Placement(transformation(extent=
                       {{170,52},{180,64}}), iconTransformation(extent={{160,26},{188,54}})));
              Modelica.Blocks.Interfaces.RealOutput PMECH_LP
                "Turbine mechanical power (pu)" annotation (Placement(transformation(extent=
                       {{170,-48},{180,-36}}), iconTransformation(extent={{160,-56},{188,-24}})));
              parameter Real P0 "Power reference of the governor";
              parameter Real K=20 "Governor gain, 1/R (pu)";
              parameter Real T_1=1e-8 "Control time constant (s)";
              parameter Real T_2=1e-8 "Control time constant (s)";
              parameter Real T_3=0.1 "Control time constant (s)";
              parameter Real U_o=0.1 "Max. rate if valve opening (p.u./s)";
              parameter Real U_c=-0.1 "Max. rate if valve closing (p.u./s)";
              parameter Real P_MAX=0.903 "Max. valve position (pu)";
              parameter Real P_MIN=0 "Min. valve position (pu)";
              parameter Real T_4=0.4 "HP section time constant (s)";
              parameter Real K_1=0.3 "Fraction of power from HP (pu)";
              parameter Real K_2=0;
              parameter Real T_5=9 "Reheat+IP time constant (s)";
              parameter Real K_3=0.4 "Fraction of power from IP (pu)";
              parameter Real K_4=0;
              parameter Real T_6=0.5 "Reheat+IP time constant s";
              parameter Real K_5=0.3 "Fraction of power from LP (pu)";
              parameter Real K_6=0;
              parameter Real T_7=1e-8 "LP section time const s";
              parameter Real K_7=0 "Fraction of power from IP  (pu)";
              parameter Real K_8=0;
              Modelica.Blocks.Sources.Constant Pref(k=P0) "Power reference "
                annotation (Placement(transformation(extent={{-144,34},{-128,50}})));
              Modelica.Blocks.Math.Add3 add3_1(k2=-1, k3=-1)
                annotation (Placement(transformation(extent={{-112,0},{-96,16}})));
              Modelica.Blocks.Math.Gain gain(k=1/T_3)
                annotation (Placement(transformation(extent={{-90,0},{-74,16}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=U_o, uMin=U_c)
                annotation (Placement(transformation(extent={{-68,0},{-52,16}})));
              Modelica.Blocks.Continuous.LimIntegrator limIntegrator(
                k=1,
                outMax=P_MAX,
                outMin=P_MIN,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                y_start=P0)
                annotation (Placement(transformation(extent={{-46,0},{-30,16}})));
              Modelica.Blocks.Math.Add add
                annotation (Placement(transformation(extent={{58,52},{70,64}})));
              Modelica.Blocks.Math.Add add1
                annotation (Placement(transformation(extent={{58,-48},{70,-36}})));
              Modelica.Blocks.Math.Add add2
                annotation (Placement(transformation(extent={{98,-48},{110,-36}})));
              Modelica.Blocks.Math.Add add3
                annotation (Placement(transformation(extent={{98,52},{110,64}})));
              Modelica.Blocks.Math.Add add4
                annotation (Placement(transformation(extent={{138,-48},{150,-36}})));
              Modelica.Blocks.Math.Add add5
                annotation (Placement(transformation(extent={{138,52},{150,64}})));
            equation
              connect(SPEED_HP, imLeadLag.u) annotation (Line(points={{-167,8},{-145.6,8}}, color={0,0,127}));
              connect(Pref.y, add3_1.u1) annotation (Line(points={{-127.2,42},{-122,42},{-122,14.4},{-113.6,14.4}}, color={0,0,127}));
              connect(add3_1.u2, imLeadLag.y) annotation (Line(points={{-113.6,8},{-113.6,8},{-127.2,8}}, color={0,0,127}));
              connect(add3_1.y, gain.u) annotation (Line(points={{-95.2,8},{-91.6,8}}, color={0,0,127}));
              connect(gain.y, limiter.u) annotation (Line(points={{-73.2,8},{-69.6,8}}, color={0,0,127}));
              connect(limiter.y, limIntegrator.u) annotation (Line(points={{-51.2,8},{-47.6,8}}, color={0,0,127}));
              connect(imSimpleLag1.u, imSimpleLag.y) annotation (Line(points={{20.4,8},{20.4,8},{-3.2,8}}, color={0,0,127}));
              connect(limIntegrator.y, imSimpleLag.u) annotation (Line(points={{-29.2,8},{-21.6,8}}, color={0,0,127}));
              connect(add3_1.u3, imSimpleLag.u) annotation (Line(points={{-113.6,1.6},{-122,1.6},{-122,-22},{-26,-22},{-26,8},{-21.6,8}}, color={0,0,127}));
              connect(imGain1.u, imSimpleLag.y) annotation (Line(points={{10,24.8},{10,8},{-3.2,8}}, color={0,0,127}));
              connect(imGain2.u, imSimpleLag.y) annotation (Line(points={{10,-8.8},{10,8},{-3.2,8}}, color={0,0,127}));
              connect(imSimpleLag1.y, imSimpleLag2.u) annotation (Line(points={{38.8,8},{60.4,8}}, color={0,0,127}));
              connect(imGain3.u, imSimpleLag2.u) annotation (Line(points={{50,24.8},{50,8},{60.4,8}}, color={0,0,127}));
              connect(imGain4.u, imSimpleLag2.u) annotation (Line(points={{50,-8.8},{50,8},{60.4,8}}, color={0,0,127}));
              connect(add.u2, imGain3.y) annotation (Line(points={{56.8,54.4},{50,54.4},{50,38.6}}, color={0,0,127}));
              connect(imGain1.y, add.u1) annotation (Line(points={{10,38.6},{10,61.6},{56.8,61.6}}, color={0,0,127}));
              connect(add1.u1, imGain4.y) annotation (Line(points={{56.8,-38.4},{50,-38.4},{50,-22.6}}, color={0,0,127}));
              connect(imGain2.y, add1.u2) annotation (Line(points={{10,-22.6},{10,-45.6},{56.8,-45.6}}, color={0,0,127}));
              connect(imSimpleLag2.y, imSimpleLag3.u) annotation (Line(points={{78.8,8},{100.4,8}}, color={0,0,127}));
              connect(imGain5.u, imSimpleLag3.u) annotation (Line(points={{90,24.8},{90,8},{100.4,8}}, color={0,0,127}));
              connect(imGain6.u, imSimpleLag3.u) annotation (Line(points={{90,-8.8},{90,8},{100.4,8}}, color={0,0,127}));
              connect(imGain6.y, add2.u1) annotation (Line(points={{90,-22.6},{90,-38.4},{96.8,-38.4}}, color={0,0,127}));
              connect(add1.y, add2.u2) annotation (Line(points={{70.6,-42},{90,-42},{90,-45.6},{96.8,-45.6}}, color={0,0,127}));
              connect(add.y, add3.u1) annotation (Line(points={{70.6,58},{90,58},{90,61.6},{96.8,61.6}}, color={0,0,127}));
              connect(imGain5.y, add3.u2) annotation (Line(points={{90,38.6},{90,54.4},{96.8,54.4}}, color={0,0,127}));
              connect(imSimpleLag3.y, imGain7.u) annotation (Line(points={{118.8,8},{130,8},{130,24.8}}, color={0,0,127}));
              connect(imGain8.u, imGain7.u) annotation (Line(points={{130,-8.8},{130,24.8}}, color={0,0,127}));
              connect(add4.y, PMECH_LP) annotation (Line(points={{150.6,-42},{152,-42},{175,-42}}, color={0,0,127}));
              connect(imGain8.y, add4.u1) annotation (Line(points={{130,-22.6},{130,-38.4},{136.8,-38.4}}, color={0,0,127}));
              connect(add2.y, add4.u2) annotation (Line(points={{110.6,-42},{130,-42},{130,-45.6},{136.8,-45.6}}, color={0,0,127}));
              connect(add3.y, add5.u1) annotation (Line(points={{110.6,58},{130,58},{130,61.6},{136.8,61.6}}, color={0,0,127}));
              connect(imGain7.y, add5.u2) annotation (Line(points={{130,38.6},{130,54.4},{136.8,54.4}}, color={0,0,127}));
              connect(add5.y, PMECH_HP) annotation (Line(points={{150.6,58},{152,58},{175,58}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(extent={{-140,-80},{160,80}}, preserveAspectRatio=
                        false)),
                Icon(coordinateSystem(extent={{-140,-80},{160,80}}, preserveAspectRatio=
                        true), graphics={Rectangle(extent={{-140,80},{160,-80}}, lineColor=
                      {0,0,255}),Text(
                      extent={{-122,18},{-68,-18}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="SPEED_HP"),Text(
                      extent={{84,56},{158,26}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="PMECH_HP"),Text(
                      extent={{86,-10},{158,-48}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="PMECH_LP"),Text(
                      extent={{-68,40},{88,-46}},
                      lineColor={0,0,255},
                      fillPattern=FillPattern.Solid,
                      textString="IEEEG1")}),
                Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>Turbine and Governor (IEEEG1), PSSE manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>2015-10-02</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Le Qi, SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigi.vanfretti@gmail.com\">luigi.vanfretti@gmail.com</a></p></td>
</tr>
</table>
</html>"));
            end IEEEG1;

            model IEESGO "IEESGO - IEEE Standard Model for Turbine-Governor"
            extends BaseClasses.BaseGovernor;
              parameter Real T_1=0.2 "Controller lag (s)";
              parameter Real T_2=0 "Controller lead compensation (s)";
              parameter Real T_3=0.5 "Governor lag (s)";
              parameter Real T_4=0.12
                "Delay due to steam inlet volumes associated with steam chest and inlet piping (s)";
              parameter Real T_5=5 "Reheater delay including hot and cold leads (s)";
              parameter Real T_6=0.5
                "Delay due to IP-LP turbine, crossover pipes, and LP end hoods (s)";
              parameter Real K_1=20 "1/p.u. regulation ";
              parameter Real K_2=0.59 "Fraction ";
              parameter Real K_3=0.43 "Fraction ";
              parameter Real P_MAX=0.98 "Upper power limit";
              parameter Real P_MIN=0 "Lower power limit";
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag(
                K=K_1,
                T=T_1,
                y_start=0) annotation (Placement(transformation(extent={{-180,-130},
                        {-160,-110}})));
              OpenIPSL.NonElectrical.Continuous.LeadLag imLeadLag(
                K=1,
                T1=T_2,
                T2=T_3,
                y_start=0) annotation (Placement(transformation(extent={{-140,-130},
                        {-120,-110}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag1(
                K=1,
                T=T_4,
                y_start=p0) annotation (Placement(transformation(extent={{20,-10},
                        {40,10}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag2(
                K=K_2,
                T=T_5,
                y_start=p0*K_2) annotation (Placement(transformation(extent={{
                        80,-80},{100,-60}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag imSimpleLag3(
                K=K_3,
                T=T_6,
                y_start=p0*K_2*K_3) annotation (Placement(transformation(extent
                      ={{120,-80},{140,-60}})));
              Modelica.Blocks.Math.Add add(k2=-1) annotation (Placement(transformation(extent={{-60,-10},
                        {-40,10}})));
              Modelica.Blocks.Nonlinear.Limiter limiter(uMax=P_MAX, uMin=P_MIN) annotation (Placement(transformation(extent={{-20,-10},
                        {0,10}})));
              Modelica.Blocks.Math.Gain gain(k=1 - K_2) annotation (Placement(transformation(extent={{120,-10},
                        {140,10}})));
              Modelica.Blocks.Math.Gain gain1(k=1 - K_3) annotation (Placement(transformation(extent={{120,-40},
                        {140,-20}})));
              Modelica.Blocks.Math.Add3 add3_1 annotation (Placement(transformation(extent={{160,-18},
                        {180,2}})));
            protected
              parameter Real p0(fixed=false);
            initial algorithm
              p0 := PMECH0;

            equation
              connect(imSimpleLag.y, imLeadLag.u) annotation (Line(points={{-159,-120},{-142,
                      -120}},                                                                color={0,0,127}));
              connect(imLeadLag.y, add.u2) annotation (Line(points={{-119,-120},{-80,-120},{
                      -80,-6},{-62,-6}},                                                                color={0,0,127}));
              connect(add.y, limiter.u) annotation (Line(points={{-39,0},{-22,0}},              color={0,0,127}));
              connect(limiter.y, imSimpleLag1.u) annotation (Line(points={{1,0},{1,0},{18,0}},       color={0,0,127}));
              connect(imSimpleLag2.y, imSimpleLag3.u) annotation (Line(points={{101,-70},{118,
                      -70}},                                                                                  color={0,0,127}));
              connect(gain1.u, imSimpleLag3.u) annotation (Line(points={{118,-30},{110,-30},
                      {110,-70},{118,-70}},                                                                   color={0,0,127}));
              connect(PMECH0, add.u1) annotation (Line(points={{-240,80},{-80,80},{-80,6},{-62,
                      6}},       color={0,0,127}));
              connect(SPEED, imSimpleLag.u) annotation (Line(points={{-240,-120},{-212,-120},
                      {-182,-120}}, color={0,0,127}));
              connect(imSimpleLag1.y, gain.u)
                annotation (Line(points={{41,0},{118,0}}, color={0,0,127}));
              connect(imSimpleLag2.u, gain.u) annotation (Line(points={{78,-70},{60,-70},{60,
                      0},{118,0}}, color={0,0,127}));
              connect(gain.y, add3_1.u1)
                annotation (Line(points={{141,0},{141,0},{158,0}}, color={0,0,127}));
              connect(gain1.y, add3_1.u2) annotation (Line(points={{141,-30},{148,-30},{148,
                      -8},{158,-8}}, color={0,0,127}));
              connect(imSimpleLag3.y, add3_1.u3) annotation (Line(points={{141,-70},{152,-70},
                      {152,-16},{158,-16}}, color={0,0,127}));
              connect(add3_1.y, PMECH) annotation (Line(points={{181,-8},{188,-8},{188,0},{250,
                      0}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-240,-200},{240,160}})),
                Icon(coordinateSystem(preserveAspectRatio=false, extent={{-240,-200},{240,160}}),
                     graphics={Text(
                      extent={{-52,20},{68,-20}},
                      lineColor={28,108,200},
                      textString="IEESGO")}));
            end IEESGO;

            model HYGOV
              extends BaseClasses.BaseGovernor;
              parameter Real R=0.05 "Permanent droop (pu)";
              parameter Real r=0.3 "Temporary droop (pu)";
              parameter Real T_r=5 "Governor time constant (s)";
              parameter Real T_f=0.05 "Filter time constant (s)";
              parameter Real T_g=0.5 "Servo time constant (s)";
              parameter Real VELM=0.2 "Gate open/close velocity limit";
              parameter Real G_MAX=0.9 "Maximum gate limit";
              parameter Real G_MIN=0 "Minimum gate limit";
              parameter Real T_w=1.25 "Water time constant (s)";
              parameter Real A_t=1.2 "Turbine gain";
              parameter Real D_turb=0.2 "Turbine damping";
              parameter Real q_NL=0.08 "Water flow at no load";
              Modelica.Blocks.Sources.Constant n_ref(k=nref) annotation (Placement(transformation(extent={{-178,14},{-166,26}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag SimpleLag1(
                K=1,
                T=T_f,
                y_start=0) annotation (Placement(transformation(extent={{-126,0},
                        {-114,12}})));
              Modelica.Blocks.Math.Gain Gain3(k=R)
                annotation (Placement(transformation(extent={{-130,-22},{-142,-10}})));
              Modelica.Blocks.Math.Gain Gain4(k=D_turb)
                annotation (Placement(transformation(extent={{-62,-34},{-50,-22}})));
              Modelica.Blocks.Sources.Constant hs(k=1)
                annotation (Placement(transformation(extent={{20,-20},{32,-8}})));
              Modelica.Blocks.Continuous.Integrator q(
                y_start=q0,
                initType=Modelica.Blocks.Types.Init.InitialOutput,
                k=1/T_w) annotation (Placement(transformation(extent={{62,-4},{74,8}})));
              Modelica.Blocks.Sources.Constant qNL(k=q_NL) annotation (Placement(transformation(extent={{92,-18},{84,-10}})));
              Modelica.Blocks.Math.Gain Gain6(k=A_t) annotation (Placement(transformation(extent={{132,-2},{144,10}})));
              OpenIPSL.NonElectrical.Continuous.SimpleLag g(
                K=1,
                T=T_g,
                y_start=g0) "servo_motor" annotation (Placement(transformation(
                      extent={{-40,0},{-28,12}})));
              Modelica.Blocks.Nonlinear.Limiter Velocity_Limiter(uMin=-VELM, uMax=VELM) annotation (Placement(transformation(extent={{-86,0},{-74,12}})));
              Modelica.Blocks.Continuous.LimIntegrator Position_Limiter(
                outMin=G_MIN,
                outMax=G_MAX,
                k=1,
                y_start=c0,
                initType=Modelica.Blocks.Types.Init.InitialOutput)
                annotation (Placement(transformation(extent={{-68,0},{-56,12}})));
              Real G "Gate opening (pu)";
              Real c "Desired gate opening (pu)";
              Real Q "Turbine flow (pu)";
              Real H "Turbine head (pu)";
              Modelica.Blocks.Math.Add add(k2=-1)
                annotation (Placement(transformation(extent={{-144,0},{-132,12}})));
              Modelica.Blocks.Math.Add add1
                annotation (Placement(transformation(extent={{-168,-12},{-156,0}})));
              Modelica.Blocks.Math.Division division
                annotation (Placement(transformation(extent={{0,-4},{12,8}})));
              Modelica.Blocks.Math.Product product
                annotation (Placement(transformation(extent={{20,-4},{32,8}})));
              Modelica.Blocks.Math.Add add2(k1=-1)
                annotation (Placement(transformation(extent={{42,-4},{54,8}})));
              Modelica.Blocks.Math.Add add3(k2=-1)
                annotation (Placement(transformation(extent={{82,-4},{94,8}})));
              Modelica.Blocks.Math.Add add4(k2=-1)
                annotation (Placement(transformation(extent={{152,-6},{164,6}})));
              Modelica.Blocks.Math.Product product1
                annotation (Placement(transformation(extent={{58,-30},{70,-18}})));
              Modelica.Blocks.Math.Product product2
                annotation (Placement(transformation(extent={{108,-2},{120,10}})));
              NonElectrical.Continuous.SimpleLead simpleLead(
                K=r*T_r,
                T=T_r,
                y_start=0)
                annotation (Placement(transformation(extent={{-106,0},{-94,12}})));
            protected
              parameter Real h0=1 "water head initial value";
              // Real T_w(start=T_w);//=1.25 "Water time constant, s";
              parameter Real q0(fixed=false);
              //=Pm0/(A_t*h0)+q_NL "water flow initial value";
              parameter Real g0(fixed=false);
              //=q0/sqrt(h0) "the gate opening initial value";
              parameter Real c0(fixed=false);
              //=g0 "desired gate position";
              parameter Real e0=0 "initial output for the filter";
              parameter Real nref(fixed=false);
              //=R*c0 "speed reference";
              parameter Real P_m0(fixed=false);
            initial algorithm
              P_m0 := PMECH0;
              q0 := P_m0/(A_t*h0) + q_NL;
              g0 := q0/sqrt(h0);
              //
              //
              c0 := g0;
              //c0_calculation(g0,G_MIN,G_MAX);
              nref := R*c0;
              //
            equation
              G = g.y;
              c = g.u;
              Q = q.y;
              H = product.y;
              connect(add.y, SimpleLag1.u) annotation (Line(points={{-131.4,6},{-127.2,6}}, color={0,0,127}));
              connect(n_ref.y, add.u1) annotation (Line(points={{-165.4,20},{-152,20},{-152,9.6},{-145.2,9.6}}, color={0,0,127}));
              connect(add1.y, add.u2) annotation (Line(points={{-155.4,-6},{-150,-6},{-150,2.4},{-145.2,2.4}}, color={0,0,127}));
              connect(Gain3.y, add1.u2) annotation (Line(points={{-142.6,-16},{-178,-16},{-178,-9.6},{-169.2,-9.6}}, color={0,0,127}));
              connect(Velocity_Limiter.y, Position_Limiter.u) annotation (Line(points={{-73.4,6},{-69.2,6}}, color={0,0,127}));
              connect(Position_Limiter.y, Gain3.u) annotation (Line(points={{-55.4,6},{-52,6},{-52,-16},{-128.8,-16}}, color={0,0,127}));
              connect(g.u, Gain3.u) annotation (Line(points={{-41.2,6},{-52,6},{-52,-16},{-128.8,-16}}, color={0,0,127}));
              connect(division.y, product.u1) annotation (Line(points={{12.6,2},{14,2},{14,5.6},{18.8,5.6}}, color={0,0,127}));
              connect(product.u2, product.u1) annotation (Line(points={{18.8,-1.6},{14,-1.6},{14,5.6},{18.8,5.6}}, color={0,0,127}));
              connect(product.y, add2.u1) annotation (Line(points={{32.6,2},{36,2},{36,5.6},{40.8,5.6}}, color={0,0,127}));
              connect(hs.y, add2.u2) annotation (Line(points={{32.6,-14},{36,-14},{36,-1.6},{40.8,-1.6}}, color={0,0,127}));
              connect(add2.y, q.u) annotation (Line(points={{54.6,2},{60.8,2}}, color={0,0,127}));
              connect(q.y, add3.u1) annotation (Line(points={{74.6,2},{76,2},{76,5.6},{80.8,5.6}}, color={0,0,127}));
              connect(qNL.y, add3.u2) annotation (Line(points={{83.6,-14},{76,-14},{76,-1.6},{80.8,-1.6}}, color={0,0,127}));
              connect(Gain4.y, product1.u2) annotation (Line(points={{-49.4,-28},{4,-28},{4,-27.6},{56.8,-27.6}}, color={0,0,127}));
              connect(product1.y, add4.u2) annotation (Line(points={{70.6,-24},{144,-24},{144,-3.6},{150.8,-3.6}}, color={0,0,127}));
              connect(product1.u1, g.y) annotation (Line(points={{56.8,-20.4},{-16,-20.4},{-16,6},{-27.4,6}}, color={0,0,127}));
              connect(division.u2, g.y) annotation (Line(points={{-1.2,-1.6},{-16,-1.6},{-16,6},{-27.4,6}}, color={0,0,127}));
              connect(division.u1, add3.u1) annotation (Line(points={{-1.2,5.6},{-6,5.6},{-6,20},{76,20},{76,5.6},{80.8,5.6}}, color={0,0,127}));
              connect(Gain6.y, add4.u1) annotation (Line(points={{144.6,4},{150.8,4},{150.8,3.6}}, color={0,0,127}));
              connect(product2.y, Gain6.u) annotation (Line(points={{120.6,4},{130.8,4},{130.8,4}}, color={0,0,127}));
              connect(add3.y, product2.u2) annotation (Line(points={{94.6,2},{100,2},{100,0.4},{106.8,0.4}}, color={0,0,127}));
              connect(product2.u1, add2.u1) annotation (Line(points={{106.8,7.6},{100,7.6},{100,16},{36,16},{36,5.6},{40.8,5.6}}, color={0,0,127}));
              connect(simpleLead.y, Velocity_Limiter.u) annotation (Line(points={{-93.4,6},{-87.2,6}}, color={0,0,127}));
              connect(simpleLead.u, SimpleLag1.y) annotation (Line(points={{-107.2,6},{-113.4,6}}, color={0,0,127}));
              connect(add4.y, PMECH)
                annotation (Line(points={{164.6,0},{250,0},{250,0}}, color={0,0,127}));
              connect(SPEED, add1.u1) annotation (Line(points={{-240,-120},{-200,-120},{
                      -200,-2.4},{-169.2,-2.4}}, color={0,0,127}));
              connect(Gain4.u, add1.u1) annotation (Line(points={{-63.2,-28},{-200,-28},{
                      -200,-2.4},{-169.2,-2.4}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-240,-200},{
                        240,160}}),                                                              graphics={Rectangle(
                      extent={{-190,32},{-12,-38}},
                      lineColor={255,128,0},
                      pattern=LinePattern.Dash,
                      lineThickness=1),Text(
                      extent={{-126,40},{-82,34}},
                      lineColor={255,128,0},
                      textStyle={TextStyle.Bold},
                      textString="Governor System"),Rectangle(
                      extent={{-8,32},{166,-38}},
                      lineColor={85,170,255},
                      pattern=LinePattern.Dash,
                      lineThickness=1),Text(
                      extent={{38,42},{98,32}},
                      lineColor={85,170,255},
                      textStyle={TextStyle.Bold},
                      textString="Hydrauli Turbine System")}),
                Icon(coordinateSystem(extent={{-240,-200},{240,160}},preserveAspectRatio=false),
                     graphics={Text(
                      extent={{-60,16},{64,-24}},
                      lineColor={28,108,200},
                      textString="HYGOV")}));
            end HYGOV;

            model TGOV1 "TGOV1 - Steam Turbine-Governor"
              extends BaseClasses.BaseGovernor;
              OpenIPSL.NonElectrical.Continuous.LeadLag imLeadLag(
                T1=T_2,
                T2=T_3,
                K=1,
                y_start=P0) annotation (Placement(transformation(extent={{80,-11},
                        {100,10}})));
              parameter Real R "Governor gain, 1/R (pu)";
              parameter Real D_t "(pu)";
              parameter Real T_1 "Control time constant (s)";
              parameter Real T_2 "Control time constant (s)";
              parameter Real T_3 "Control time constant (s)";
              parameter Real V_MAX "Max. valve position (p.u. on M_b)";
              parameter Real V_MIN "min. valve position (p.u. on M_b)";
              Modelica.Blocks.Math.Gain imGain9(k=1/R) annotation (Placement(transformation(extent={{0,-10},
                        {20,10}})));
              Modelica.Blocks.Math.Gain imGain1(k=D_t) annotation (Placement(transformation(extent={{40,-69},
                        {60,-50}})));
              Modelica.Blocks.Math.Add add(k2=-1) annotation (Placement(transformation(extent={{-40,-11},
                        {-20,10}})));
              Modelica.Blocks.Math.Add add1(k2=-1) annotation (Placement(transformation(extent={{180,-10},
                        {200,10}})));
              Modelica.Blocks.Sources.Constant REF(k=P_REF) annotation (Placement(transformation(extent={{-140,40},
                        {-120,60}})));
              NonElectrical.Continuous.SimpleLagLim simpleLagLim(
                K=1,
                T=T_1,
                y_start=P0,
                outMax=V_MAX,
                outMin=V_MIN) annotation (Placement(transformation(extent={{40,-9},{60,10}})));
            protected
              parameter Real P0(fixed=false) "Power reference of the governor";
              parameter Real P_REF(fixed=false);
            initial equation
              P0 = PMECH0;
              P_REF = P0*R;

            equation
              connect(REF.y, add.u1) annotation (Line(points={{-119,50},{-60,50},{-60,5.8},{
                      -42,5.8}},                                                    color={0,0,127}));
              connect(simpleLagLim.u, imGain9.y) annotation (Line(points={{38,0.5},{21,0.5},
                      {21,0}},                                                                          color={0,0,127}));
              connect(add1.y, PMECH)
                annotation (Line(points={{201,0},{250,0},{250,0}}, color={0,0,127}));
              connect(simpleLagLim.y, imLeadLag.u) annotation (Line(points={{61,0.5},{69.5,0.5},
                      {69.5,-0.5},{78,-0.5}}, color={0,0,127}));
              connect(add.y, imGain9.u) annotation (Line(points={{-19,-0.5},{-10.5,-0.5},{-10.5,
                      0},{-2,0}}, color={0,0,127}));
              connect(imLeadLag.y, add1.u1) annotation (Line(points={{101,-0.5},{160,-0.5},{
                      160,6},{178,6}}, color={0,0,127}));
              connect(imGain1.y, add1.u2) annotation (Line(points={{61,-59.5},{160,-59.5},{160,
                      -6},{178,-6}}, color={0,0,127}));
              connect(SPEED, add.u2) annotation (Line(points={{-240,-120},{-150,-120},{-60,-120},
                      {-60,-6.8},{-42,-6.8}}, color={0,0,127}));
              connect(imGain1.u, add.u2) annotation (Line(points={{38,-59.5},{-12,-59.5},{-12,
                      -60},{-60,-60},{-60,-6.8},{-42,-6.8}}, color={0,0,127}));
              annotation (
                Diagram(coordinateSystem(
                    extent={{-240,-200},{240,180}},
                    preserveAspectRatio=false,
                    grid={2,2},
                    initialScale=0.1)),
                Icon(coordinateSystem(
                    extent={{-240,-200},{240,180}},
                    preserveAspectRatio=false,
                    grid={2,2},
                    initialScale=0.1),
                    graphics={Text(
                      extent={{-60,26},{58,-18}},
                      lineColor={28,108,200},
                      textString="TGOV1")}));
            end TGOV1;

            package GGOV1 "GE General Governor/Turbine Model"
              block Min_select
                "Output the minimum and the maximum element of the input vector"
                parameter Integer nu(min=0) = 0 "Number of input connections"
                  annotation (Dialog(connectorSizing=true), HideResult=true);
                Modelica.Blocks.Interfaces.RealVectorInput u[nu]
                  annotation (Placement(transformation(extent={{-120,70},{-80,-70}})));
                Modelica.Blocks.Interfaces.RealOutput yMin(start=frs0) annotation (Placement(
                      transformation(extent={{100,-94},{120,-74}}, rotation=0)));
                parameter Real frs0;
              equation
                yMin = min(u);
                annotation (
                  Icon(coordinateSystem(
                      preserveAspectRatio=true,
                      extent={{-100,-100},{100,100}},
                      initialScale=0.1), graphics={Text(
                        extent={{-50,46},{76,-46}},
                        lineColor={0,0,255},
                        textString="Low value
select"),              Rectangle(extent={{-100,98},{100,-98}}, lineColor={0,0,255})}),
                  Documentation(info="<html>
<p>
Determines the minimum and maximum element of the input vector and
provide both values as output.
</p>
</html>"),        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                          100}}), graphics));
              end Min_select;

              block RSELECT "Output the minimum and the maximum element of the input vector"
                // extends Modelica.Blocks.Icons.Block;
                parameter Real Rselect;
                Modelica.Blocks.Interfaces.RealOutput y annotation (Placement(transformation(
                        extent={{100,-12},{120,8}}, rotation=0)));
                Modelica.Blocks.Interfaces.RealInput Pelect annotation (Placement(
                      transformation(extent={{-140,36},{-100,76}}), iconTransformation(extent=
                         {{-140,36},{-100,76}})));
                Modelica.Blocks.Interfaces.RealInput ValveStroke annotation (Placement(
                      transformation(extent={{4,-80},{44,-40}}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={8,-120})));
                Modelica.Blocks.Interfaces.RealInput GovernorOutput annotation (Placement(
                      transformation(extent={{6,-136},{46,-96}}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=90,
                      origin={84,-120})));
              equation
                y = if Rselect == 1 then Pelect elseif Rselect == (-1) then ValveStroke
                   elseif Rselect == (-2) then GovernorOutput else 0;
                annotation (
                  Icon(coordinateSystem(
                      preserveAspectRatio=true,
                      extent={{-100,-100},{100,100}},
                      initialScale=0.1), graphics={Text(
                        extent={{-51,31},{51,-31}},
                        lineColor={0,0,255},
                        textString="Rselect
 1 -  electrical power
-1 - valve stroke
-2 - governor output
 0 - isochronous",      horizontalAlignment=TextAlignment.Left,
                        origin={-11,-1},
                        rotation=270),Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,
                        0,255})}),
                  Documentation(info="<html>
<p>
Determines the minimum and maximum element of the input vector and
provide both values as output.
</p>
</html>"),        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                          100}}), graphics={Rectangle(extent={{-100,100},{100,-100}},
                        lineColor={0,0,255})}));
              end RSELECT;

              block flag "Output the minimum and the maximum element of the input vector"
                parameter Real flag;
                Modelica.Blocks.Interfaces.RealOutput y annotation (Placement(transformation(
                        extent={{100,-12},{120,8}}, rotation=0)));
                Modelica.Blocks.Interfaces.RealInput speed annotation (Placement(
                      transformation(extent={{6,-136},{46,-96}}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=0,
                      origin={-120,-2})));
              equation
                y = if flag == 1 then speed + 1 else 1;
                annotation (
                  Icon(coordinateSystem(
                      preserveAspectRatio=true,
                      extent={{-100,-100},{100,100}},
                      initialScale=0.1), graphics={Text(
                        extent={{-51,31},{51,-31}},
                        lineColor={0,0,255},
                        horizontalAlignment=TextAlignment.Left,
                        origin={1,5},
                        rotation=360,
                        textString="Flag"),Rectangle(extent={{-98,90},{96,-92}}, lineColor={0,
                        0,255})}),
                  Documentation(info="<html>
<p>
Determines the minimum and maximum element of the input vector and
provide both values as output.
</p>
</html>"),        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                          100}}), graphics));
              end flag;

              block Dm_select
                "Output the minimum and the maximum element of the input vector"
                parameter Real Dm;
                Modelica.Blocks.Interfaces.RealOutput y annotation (Placement(transformation(
                        extent={{100,-12},{120,8}}, rotation=0)));
                Modelica.Blocks.Interfaces.RealInput speed annotation (Placement(
                      transformation(extent={{6,-136},{46,-96}}), iconTransformation(
                      extent={{-20,-20},{20,20}},
                      rotation=0,
                      origin={-120,-2})));
              equation
                y = if Dm >= 0 then speed + 1 else (speed + 1)^Dm;
                annotation (
                  Icon(coordinateSystem(
                      preserveAspectRatio=true,
                      extent={{-100,-100},{100,100}},
                      initialScale=0.1), graphics={Text(
                        extent={{-51,31},{51,-31}},
                        lineColor={0,0,255},
                        horizontalAlignment=TextAlignment.Left,
                        origin={1,5},
                        rotation=360,
                        textString="Dm_select"),Rectangle(extent={{-98,90},{96,-92}},
                        lineColor={0,0,255})}),
                  Documentation(info="<html>
<p>
Determines the minimum and maximum element of the input vector and
provide both values as output.
</p>
</html>"),        Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                          100}}), graphics));
              end Dm_select;

              model GGOV1 "GE General Governor/Turbine Mode"
                parameter Integer Rselect=1 "Feedback signal for
                    governor droop"               annotation (Evaluate=true, choices(
                    choice=1 "Electrical power",
                    choice=0 "None (isochronous governor)",
                    choice=-1 "Governor output (requested stroke)",
                    choice=-2 "Fuel valve stroke (true stoke)"));
                parameter Integer Flag=1 "Switch for fuel source
                    characteristic"               annotation (Evaluate=true, choices(choice=0
                      "Fuel flow independent of speed", choice=1
                      "Fuel flow proportional to speed"));
                parameter Real R "Permanent droop (pu)";
                parameter Real T_pelec "Electrical power transducer time constant (s)";
                parameter Real maxerr "Maximum value for speed error signal";
                parameter Real minerr "Minimum value for speed error signal";
                parameter Real Kpgov "Governor proportional gain";
                parameter Real Kigov "Governor integral gain";
                parameter Real Kdgov "Governor derivative gain";
                parameter Real Tdgov "Governor derivative controller time constant (s)";
                parameter Real Vmax "Maximum valve position limit";
                parameter Real Vmin "Minimum valve position limit";
                parameter Real Tact "Actuator time constant (s)";
                parameter Real Kturb "Turbine gain";
                parameter Real Wfnl "No load fuel flow (pu)";
                parameter Real Tb "Turbine lag time constant (s)";
                parameter Real Tc "Turbine lead time constant (s)";
                parameter Real Teng "Transport lag time constant for diesel engine (s)";
                parameter Real Tfload "Load Limiter time constant (s)";
                parameter Real Kpload "Load limiter proportional gain for PI controller";
                parameter Real Kiload "Load limiter integral gain for PI controller";
                parameter Real Ldref "Load limiter reference value (pu)";
                parameter Real Dm "Mechanical damping coefficient (pu)";
                parameter Real Ropen "Maximum valve opening rate (p.u./s)";
                parameter Real Rclose "Maximum valve closing rate (p.u./s)";
                parameter Real Kimw "Power controller (reset) gain";
                parameter Real Aset "Acceleration limiter setpoint (p.u./s)";
                parameter Real Ka "Acceleration limiter gain";
                parameter Real Ta "Acceleration limiter time constant (s)";
                parameter Real Trate "Turbine rating (MW)";
                parameter Real db "Speed governor deadband";
                parameter Real Tsa "Temperature detection lead time constant (s)";
                parameter Real Tsb "Temperature detection lag time constant (s)";
                parameter Real Rup "Maximum rate of load limit increase";
                parameter Real Rdown "Maximum rate of load limit decrease";
                parameter Real DELT "PSSE time step";
                Modelica.Blocks.Math.Gain KPLOAD(k=Kpload)
                  annotation (Placement(transformation(extent={{-196,52},{-182,66}})));
                Modelica.Blocks.Math.Gain KPGOV(k=Kpgov)
                  annotation (Placement(transformation(extent={{-92,-82},{-76,-66}})));
                Modelica.Blocks.Continuous.Integrator s6(
                  k=1,
                  y_start=s60,
                  initType=Modelica.Blocks.Types.Init.InitialState) annotation (Placement(
                      transformation(
                      extent={{-6,-6},{6,6}},
                      rotation=180,
                      origin={-158,90})));
                Modelica.Blocks.Continuous.Integrator s2(
                  k=1,
                  initType=Modelica.Blocks.Types.Init.InitialOutput,
                  y_start=s20) annotation (Placement(transformation(
                      extent={{-7,-7},{7,7}},
                      rotation=180,
                      origin={-51,-117})));
                Modelica.Blocks.Continuous.Derivative s1(
                  k=Kdgov,
                  T=Tdgov,
                  y_start=0,
                  initType=Modelica.Blocks.Types.Init.InitialOutput)
                  annotation (Placement(transformation(extent={{-80,-40},{-60,-20}})));
                Modelica.Blocks.Math.Add3 GovernorPID
                  annotation (Placement(transformation(extent={{-60,-88},{-38,-66}})));
                Modelica.Blocks.Math.Add LoadlimiterPI
                  annotation (Placement(transformation(extent={{-168,56},{-152,72}})));
                Modelica.Blocks.Nonlinear.DeadZone deadZone(uMax=db, deadZoneAtInit=false)
                  annotation (Placement(transformation(extent={{-168,-84},{-148,-64}})));
                Modelica.Blocks.Nonlinear.Limiter limiterSerror(uMax=maxerr, uMin=minerr)
                  annotation (Placement(transformation(extent={{-138,-84},{-118,-64}})));
                Modelica.Blocks.Math.Add3 add3_2(k1=-1, k3=-1)
                  annotation (Placement(transformation(extent={{-198,-80},{-186,-68}})));
                Modelica.Blocks.Math.Gain Acceleration(k=Ka*DELT)
                  annotation (Placement(transformation(extent={{-116,0},{-92,24}})));
                Modelica.Blocks.Math.Add add
                  annotation (Placement(transformation(extent={{-54,-2},{-36,16}})));
                Modelica.Blocks.Interfaces.RealInput SPEED
                  "Machine speed deviation from nominal (pu)" annotation (Placement(
                      transformation(extent={{-346,102},{-310,138}}), iconTransformation(
                        extent={{-346,102},{-310,138}})));
                Modelica.Blocks.Interfaces.RealInput PELEC "Machine electrical power (pu)"
                  annotation (Placement(transformation(extent={{-348,-118},{-310,-80}}),
                      iconTransformation(extent={{-348,-118},{-310,-80}})));
                Modelica.Blocks.Continuous.Derivative s8(
                  k=1,
                  T=Ta,
                  y_start=0,
                  initType=Modelica.Blocks.Types.Init.InitialOutput)
                  annotation (Placement(transformation(extent={{-196,-14},{-170,12}})));
                Modelica.Blocks.Math.Add add1(k2=-1)
                  annotation (Placement(transformation(extent={{-146,2},{-126,22}})));
                Modelica.Blocks.Sources.Constant AccelerationSet(k=Aset)
                  annotation (Placement(transformation(extent={{-180,22},{-164,38}})));
                Modelica.Blocks.Math.Gain r(k=R) "Permanent droop" annotation (Placement(
                      transformation(
                      extent={{-7,-7},{7,7}},
                      rotation=90,
                      origin={-207,-101})));
                Modelica.Blocks.Math.Add add2
                  annotation (Placement(transformation(extent={{-238,-80},{-226,-68}})));
                Modelica.Blocks.Sources.Constant P_ref(k=Pref)
                  annotation (Placement(transformation(extent={{-276,-78},{-260,-62}})));
                Modelica.Blocks.Continuous.LimIntegrator s7(
                  k=Kimw,
                  outMax=1.1*R,
                  initType=Modelica.Blocks.Types.Init.InitialOutput,
                  y_start=s70) "Power controller" annotation (Placement(transformation(
                      extent={{-8,-8},{8,8}},
                      rotation=90,
                      origin={-246,-98})));
                Modelica.Blocks.Sources.Constant Pmw_set(k=Pmwset)
                  "Supervisory Load Controller Setpoint,"
                  annotation (Placement(transformation(extent={{-276,-148},{-260,-132}})));
                Modelica.Blocks.Math.Add add3(k2=-1) annotation (Placement(transformation(
                      extent={{-6,-6},{6,6}},
                      rotation=90,
                      origin={-246,-122})));
                NonElectrical.Continuous.SimpleLag s0(
                  T=T_pelec,
                  y_start=s00,
                  K=1) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=0,
                      origin={-270,-170})));
                Modelica.Blocks.Math.Add add6(k1=-1) annotation (Placement(transformation(
                      extent={{-8,-8},{8,8}},
                      rotation=180,
                      origin={-74,118})));
                NonElectrical.Continuous.SimpleLag s5(
                  T=Tfload,
                  y_start=s50,
                  K=1) annotation (Placement(transformation(
                      extent={{-10,10},{10,-10}},
                      rotation=180,
                      origin={-30,110})));
                Modelica.Blocks.Math.Gain gain(k=1/Kturb)
                  annotation (Placement(transformation(extent={{-138,124},{-122,140}})));
                Modelica.Blocks.Sources.Constant set(k=Ldref) "load reference"
                  annotation (Placement(transformation(extent={{-180,124},{-164,140}})));
                Modelica.Blocks.Nonlinear.Limiter maxLimiter(uMax=1, uMin=-Modelica.Constants.inf)
                  annotation (Placement(transformation(extent={{-126,56},{-110,72}})));
                NonElectrical.Continuous.LeadLag s9(
                  T1=Tsa,
                  T2=Tsb,
                  y_start=s90,
                  K=1) annotation (Placement(transformation(extent={{20,100},{0,120}})));
                Min_select min_select(nu=3, frs0=fsr0)
                  annotation (Placement(transformation(extent={{-18,-28},{-2,-12}})));
                Modelica.Blocks.Math.Product product
                  annotation (Placement(transformation(extent={{130,-66},{142,-54}})));
                OpenIPSL.NonElectrical.Continuous.LeadLag s4(
                  K=1,
                  T1=Tc,
                  T2=Tb,
                  y_start=s40) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={150,110})));
                Modelica.Blocks.Math.Gain gain1(k=Kturb) annotation (Placement(transformation(
                      extent={{-8,-8},{8,8}},
                      rotation=90,
                      origin={150,60})));
                Modelica.Blocks.Nonlinear.FixedDelay delay(delayTime=Teng)
                  "Transport lag time" annotation (Placement(transformation(
                      extent={{-14,-14},{14,14}},
                      rotation=90,
                      origin={150,20})));
                Modelica.Blocks.Math.Add add4(k2=-1) annotation (Placement(transformation(
                      extent={{-6,-6},{6,6}},
                      rotation=90,
                      origin={150,-24})));
                Modelica.Blocks.Math.Add add5(k1=-1) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=0,
                      origin={176,158})));
                Modelica.Blocks.Sources.Constant set1(k=Wfnl) "full load flow" annotation (
                    Placement(transformation(
                      extent={{-8,-8},{8,8}},
                      rotation=180,
                      origin={196,-38})));
                Modelica.Blocks.Math.Gain gain2(k=Dm) annotation (Placement(transformation(
                      extent={{-8,-8},{8,8}},
                      rotation=0,
                      origin={76,164})));
                flag flag10(flag=Flag) annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=90,
                      origin={128,-152})));
                Dm_select dm_select(Dm=Dm)
                  annotation (Placement(transformation(extent={{2,154},{22,174}})));
                Modelica.Blocks.Interfaces.RealOutput PMECH "Turbine mechanical power (pu)"
                  annotation (Placement(transformation(extent={{260,-10},{280,10}}),
                      iconTransformation(extent={{260,-10},{280,10}})));
                Modelica.Blocks.Math.Product product1 annotation (Placement(transformation(
                      extent={{-10,-10},{10,10}},
                      rotation=180,
                      origin={50,110})));
                Modelica.Blocks.Nonlinear.Limiter V(uMax=Vmax, uMin=Vmin)
                  annotation (Placement(transformation(extent={{10,-62},{24,-48}})));
                Modelica.Blocks.Math.Add add7 annotation (Placement(transformation(
                      extent={{-9,-9},{9,9}},
                      rotation=0,
                      origin={-85,137})));
                Modelica.Blocks.Sources.Constant set2(k=Wfnl) "full load flow" annotation (
                    Placement(transformation(
                      extent={{-8,-8},{8,8}},
                      rotation=270,
                      origin={-116,182})));
                Modelica.Blocks.Math.Gain Gain(k=Kiload/Kpload) annotation (Placement(
                      transformation(
                      extent={{-6,-6},{6,6}},
                      rotation=180,
                      origin={-138,90})));
                Modelica.Blocks.Math.Add LoadlimiterPI1(k2=-1) annotation (Placement(
                      transformation(
                      extent={{-6,6},{6,-6}},
                      rotation=180,
                      origin={-114,90})));
                Modelica.Blocks.Math.Gain KPGOV1(k=Kigov/Kpgov) annotation (Placement(
                      transformation(
                      extent={{-5,-5},{5,5}},
                      rotation=180,
                      origin={-31,-117})));
                Modelica.Blocks.Math.Add LoadlimiterPI2(k1=-1) annotation (Placement(
                      transformation(
                      extent={{-5,5},{5,-5}},
                      rotation=180,
                      origin={-11,-117})));
                Modelica.Blocks.Math.Gain Tactgain(k=1/Tact)
                  annotation (Placement(transformation(extent={{60,-62},{70,-52}})));
                Modelica.Blocks.Nonlinear.Limiter V1(uMax=Ropen, uMin=Rclose)
                  annotation (Placement(transformation(extent={{76,-64},{90,-50}})));
                Modelica.Blocks.Continuous.Integrator s3(
                  k=1,
                  initType=Modelica.Blocks.Types.Init.InitialOutput,
                  y_start=s30) annotation (Placement(transformation(
                      extent={{-7,-7},{7,7}},
                      rotation=0,
                      origin={107,-57})));
                Modelica.Blocks.Math.Add add8(k2=-1) annotation (Placement(transformation(
                      extent={{-6,-6},{6,6}},
                      rotation=0,
                      origin={48,-58})));
                RSELECT rSELECT(Rselect=Rselect) annotation (Placement(transformation(
                      extent={{-15,-22},{15,22}},
                      rotation=90,
                      origin={-206,-131})));
              protected
                parameter Real Pe0(fixed=false);
                parameter Real Pmech0(fixed=false);
                parameter Real Pref(fixed=false);
                parameter Real Pmwset(fixed=false);
                parameter Real s00(fixed=false);
                parameter Real s20(fixed=false);
                parameter Real s30(fixed=false);
                parameter Real s40(fixed=false);
                parameter Real s50(fixed=false);
                parameter Real s60(fixed=false);
                parameter Real s70(fixed=false);
                parameter Real s80(fixed=false);
                parameter Real s90(fixed=false);
                //parameter Real s10( fixed=false);
                parameter Real fsr0(fixed=false);
              initial equation
                Pe0 = PELEC;
                Pmech0 = PELEC;
                Pref = R*Pe0;
                Pmwset = s00;
                s00 = Pe0;
                s20 = fsr0;
                s30 = fsr0;
                s40 = Pmech0;
                s50 = s90;
                s60 = fsr0;
                s70 = 0;
                //assume s70=0
                s80 = 0;
                s90 = fsr0;
                fsr0 = (Pmech0 + Dm)/Kturb + Wfnl;
              equation
                connect(deadZone.y, limiterSerror.u) annotation (Line(
                    points={{-147,-74},{-140,-74}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(KPGOV.u, limiterSerror.y) annotation (Line(
                    points={{-93.6,-74},{-117,-74}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(Acceleration.y, add.u1) annotation (Line(
                    points={{-90.8,12},{-86,12},{-86,12.4},{-55.8,12.4}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(s8.y, add1.u2) annotation (Line(
                    points={{-168.7,-1},{-160,-1},{-160,6},{-148,6}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(AccelerationSet.y, add1.u1) annotation (Line(
                    points={{-163.2,30},{-150,30},{-150,18},{-148,18}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(Acceleration.u, add1.y) annotation (Line(
                    points={{-118.4,12},{-125,12}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(SPEED, s8.u) annotation (Line(
                    points={{-328,120},{-262,120},{-262,-1},{-198.6,-1}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(add3_2.y, deadZone.u) annotation (Line(
                    points={{-185.4,-74},{-170,-74}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(add3_2.u1, s8.u) annotation (Line(
                    points={{-199.2,-69.2},{-212,-69.2},{-212,-1},{-198.6,-1}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(r.y, add3_2.u3) annotation (Line(
                    points={{-207,-93.3},{-207,-78.8},{-199.2,-78.8}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(add2.y, add3_2.u2) annotation (Line(
                    points={{-225.4,-74},{-199.2,-74}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(P_ref.y, add2.u1) annotation (Line(
                    points={{-259.2,-70},{-250,-70},{-250,-70.4},{-239.2,-70.4}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(s7.y, add2.u2) annotation (Line(
                    points={{-246,-89.2},{-246,-77.6},{-239.2,-77.6}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(Pmw_set.y, add3.u1) annotation (Line(
                    points={{-259.2,-140},{-249.6,-140},{-249.6,-129.2}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(add3.y, s7.u) annotation (Line(
                    points={{-246,-115.4},{-246,-107.6}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(s0.y, add3.u2) annotation (Line(
                    points={{-259,-170},{-242,-170},{-242,-129.2},{-242.4,-129.2}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(s0.u, PELEC) annotation (Line(
                    points={{-282,-170},{-300,-170},{-300,-99},{-329,-99}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(set.y, gain.u) annotation (Line(
                    points={{-163.2,132},{-139.6,132}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(add6.u1, s5.y) annotation (Line(
                    points={{-64.4,113.2},{-51.2,113.2},{-51.2,110},{-41,110}},
                    color={0,0,127},
                    smooth=Smooth.None));
                connect(s5.u, s9.y) annotation (Line(
                    points={{-18,110},{-1,110}},
           