package WT3G1_test
  model WTblock
    OpenIPSL.Interfaces.PwPin pwPin annotation(
      Placement(visible = true, transformation(origin = {26, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {90, -2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Wind.PSSE.WT3G.WT3G1 wt3g1(K_ipll = K_ipll, K_pll = K_pll, M_b = M_b, P_0 = P_0, P_llmax = P_llmax, P_rated = P_rated, Q_0 = Q_0, V_0 = V_0, V_b = V_b, X_eq = X_eq, Zs(im = X_eq, re = 0) , angle_0 = angle_0) annotation(
      Placement(visible = true, transformation(origin = {-4, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    parameter OpenIPSL.Types.VoltageKilo V_b = 690 / 1000 "Base voltage of the bus";
    parameter Modelica.SIunits.PerUnit V_0 = 1 "Voltage magnitude (pu)";
    parameter Modelica.SIunits.Conversions.NonSIunits.Angle_deg angle_0 = 0 "Voltage angle";
    parameter OpenIPSL.Types.ActivePowerMega P_0 = 2 "Active power";
    parameter OpenIPSL.Types.ReactivePowerMega Q_0 = 0.65 "Reactive power";
    parameter Real M_b = 2 "Machine base power (MVA)";
    parameter Real X_eq = 0.8 "Equivalent reactance for current injection (pu)";
    parameter Real K_pll = 30 "PLL first integrator gain";
    parameter Real K_ipll = 0 "PLL second integrator gain";
    parameter Real P_llmax = 0.1 "PLL maximum limit";
    parameter Real P_rated = 2 "Turbine MW rating, not used in the equation";
  equation
    connect(wt3g1.p, pwPin) annotation(
      Line(points = {{7, 0}, {26, 0}}, color = {0, 0, 255}));
    connect(wt3g1.Ipcmd, wt3g1.ipcmd0) annotation(
      Line(points = {{-13, 3}, {-18, 3}, {-18, 14}, {-4, 14}, {-4, 11}, {-5, 11}}, color = {0, 0, 127}));
    connect(wt3g1.Eqcmd, wt3g1.eqcmd0) annotation(
      Line(points = {{-13, 7}, {-16, 7}, {-16, 12}, {-9, 12}, {-9, 11}}, color = {0, 0, 127}));
    annotation(
      Icon(graphics = {Rectangle(origin = {7, -2}, extent = {{-73, 40}, {73, -40}})}, coordinateSystem(initialScale = 0.1)));
  end WTblock;

  model Model
    WTblock generator16(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -1.4697, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.273731) annotation(
      Placement(visible = true, transformation(origin = {24, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine9(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {75, 19}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine17(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {205, 59}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer14(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-14, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b43(P_0 = 2, Q_0 = -15.0236, V_0 = 1, V_b = 0.7, angle_0 = 0.320473, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {110, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-140, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b23(P_0 = 2, Q_0 = -15.0236, V_0 = 1, V_b = 0.7, angle_0 = 0.320473, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b50(P_0 = 0, Q_0 = 0, V_0 = 0.990142, V_b = 35, angle_0 = 0.203493, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {132, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Events.PwFault pwFault1(R = 0.1, X = 0.01, t1 = 1, t2 = 1.25) annotation(
      Placement(visible = true, transformation(origin = {-24, -186}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer29(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {184, -78}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer20(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {120, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine6(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {-55, 53}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b17(P_0 = 0, Q_0 = 0, V_0 = 0.990144, V_b = 35, angle_0 = 0.168280, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-64, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine27(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {58, -102}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine23(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {205, -55}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer23(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {122, -2}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-140, 34}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator27(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 32.7356, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = -0.316028) annotation(
      Placement(visible = true, transformation(origin = {154, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator1(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = -0.277038 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.478251) annotation(
      Placement(visible = true, transformation(origin = {-168, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine19(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {139, -57}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine(B = 0.0000007539822 / 2, G = 0, R = 0.00126, X = 0.002) annotation(
      Placement(visible = true, transformation(origin = {-119, -19}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer17(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {54, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {-119, 53}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    WTblock generator28(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 44.1136, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = -0.042349) annotation(
      Placement(visible = true, transformation(origin = {154, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b57(P_0 = 0, Q_0 = 0, V_0 = 0.995817, V_b = 35, angle_0 = 0.030113, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {196, -38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b54(P_0 = 2, Q_0 = 34.1253, V_0 = 1, V_b = 0.7, angle_0 = -0.252259, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {176, 38}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer31(Sn = 63, V_b = 110, Vn = 110, kT = 35 / 110, r = 0.0074, x = 0.196) annotation(
      Placement(visible = true, transformation(origin = {25, -145}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b8(P_0 = 0, Q_0 = 0, V_0 = 0.988787, V_b = 35, angle_0 = 0.218878, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-128, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator9(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 0.021166 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.229292) annotation(
      Placement(visible = true, transformation(origin = {-106, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine25(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {-38, -100}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b16(P_0 = 0, Q_0 = 0, V_0 = 0.990379, V_b = 35, angle_0 = 0.152586, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-64, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine20(B = 0.0000007539822 / 2, G = 0, R = 0.00126, X = 0.002) annotation(
      Placement(visible = true, transformation(origin = {141, -17}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer5(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-76, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer30(Sn = 63, V_b = 110, Vn = 110, kT = 35 / 110, r = 0.0074, x = 0.196) annotation(
      Placement(visible = true, transformation(origin = {5, -145}, extent = {{-7, -7}, {7, 7}}, rotation = -90)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
      Placement(visible = true, transformation(extent = {{-162, -180}, {-112, -148}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b55(P_0 = 2, Q_0 = 32.7356, V_0 = 1, V_b = 0.7, angle_0 = -0.316028, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {174, 72}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator6(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -0.012465 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.274981) annotation(
      Placement(visible = true, transformation(origin = {-106, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer21(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {120, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b49(P_0 = 0, Q_0 = 0, V_0 = 0.990099, V_b = 35, angle_0 = 0.197266, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {132, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer12(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-14, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator22(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -1.5399, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.280255) annotation(
      Placement(visible = true, transformation(origin = {90, 68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b40(P_0 = 0, Q_0 = 0, V_0 = 0.990142, V_b = 35, angle_0 = 0.203493, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {66, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {-119, 19}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b44(P_0 = 2, Q_0 = -1.4697, V_0 = 1, V_b = 0.7, angle_0 = 0.273731, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {110, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer15(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {54, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b24(P_0 = 2, Q_0 = -1.4697, V_0 = 1, V_b = 0.7, angle_0 = 0.273731, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator4(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = 2.0717, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.218447) annotation(
      Placement(visible = true, transformation(origin = {-170, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Loads.PSAT.LOADPQ loadpq(P_0 = 0.565, Q_0 = 0.415, V_0 = 0.954474, V_b = 110, angle_0 = -3.099729, forcePQ = true) annotation(
      Placement(visible = true, transformation(origin = {11, -181}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
    WTblock generator7(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -0.013250 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.281049) annotation(
      Placement(visible = true, transformation(origin = {-106, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator26(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 34.1253, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = -0.252259) annotation(
      Placement(visible = true, transformation(origin = {154, 38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine10(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {75, 55}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine14(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {141, 57}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine22(B = 0.0000007539822 / 2, G = 0, R = 0.00126, X = 0.002) annotation(
      Placement(visible = true, transformation(origin = {205, -15}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b1(P_0 = 2, Q_0 = 2.0717, V_0 = 1, V_b = 0.7, angle_0 = 0.218447, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-150, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = 0.012975 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.350459) annotation(
      Placement(visible = true, transformation(origin = {-168, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b15(P_0 = 2, Q_0 = -0.013250 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.281049, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-86, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b62(P_0 = 0.565, Q_0 = 0.415, V_0 = 0.954474, V_b = 110, angle_0 = -3.09729, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {12, -162}, extent = {{-18, -18}, {18, 18}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer19(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {54, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b51(P_0 = 2, Q_0 = 44.1136, V_0 = 1, V_b = 0.7, angle_0 = -0.042349, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {174, -78}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b26(P_0 = 0, Q_0 = 0, V_0 = 0.990556, V_b = 35, angle_0 = 0.148485, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-2, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b38(P_0 = 0, Q_0 = 0, V_0 = 0.990012, V_b = 35, angle_0 = 0.184974, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {66, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b48(P_0 = 0, Q_0 = 0, V_0 = 0.990012, V_b = 35, angle_0 = 0.184974, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {132, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine18(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {205, 23}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    WTblock generator8(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -0.087082 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.260379) annotation(
      Placement(visible = true, transformation(origin = {-106, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Events.PwFault pwFault(R = 0.1, X = 0.01, t1 = 10, t2 = 10.25) annotation(
      Placement(visible = true, transformation(origin = {76, -138}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer8(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-76, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine28(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {96, -106}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b11(P_0 = 0.02, Q_0 = -0.087082, V_0 = 1, V_b = 0.7, angle_0 = 0.260379, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-86, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b9(P_0 = 0, Q_0 = 0, V_0 = 0.988313, V_b = 35, angle_0 = 0.285928, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-128, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer7(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-76, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b61(P_0 = 0, Q_0 = 0, V_0 = 0.990766, V_b = 35, angle_0 = 0.130804, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {13, -129}, extent = {{23, -23}, {-23, 23}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer27(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {184, 72}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b37(P_0 = 0, Q_0 = 0, V_0 = 0.990304, V_b = 35, angle_0 = 0.164591, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {66, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {-119, -61}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b31(P_0 = 2, Q_0 = 1.4362, V_0 = 1, V_b = 0.7, angle_0 = 0.21237, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {44, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b33(P_0 = 2, Q_0 = -15.0236, V_0 = 1, V_b = 0.7, angle_0 = 0.320473, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {44, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer10(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-14, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b30(P_0 = 0, Q_0 = 0, V_0 = 0.990142, V_b = 35, angle_0 = 0.203493, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-2, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b7(P_0 = 0, Q_0 = 0, V_0 = 0.989522, V_b = 35, angle_0 = 0.182415, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-128, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b45(P_0 = 2, Q_0 = -1.5399, V_0 = 1, V_b = 0.7, angle_0 = 0.280255, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {110, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b5(P_0 = 2, Q_0 = 0.012975 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.350459, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-150, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-140, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine12(B = 0.0000007539822 / 2, G = 0, R = 0.00126, X = 0.002) annotation(
      Placement(visible = true, transformation(origin = {7, -17}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer28(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {184, 2}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b58(P_0 = 0, Q_0 = 0, V_0 = 0.997924, V_b = 35, angle_0 = -0.037335, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {196, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b6(P_0 = 0, Q_0 = 0, V_0 = 0.990171, V_b = 35, angle_0 = 0.157245, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-128, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b10(P_0 = 0, Q_0 = 0, V_0 = 0.988421, V_b = 35, angle_0 = 0.285700, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-128, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b47(P_0 = 0, Q_0 = 0, V_0 = 0.990304, V_b = 35, angle_0 = 0.164591, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {132, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b20(P_0 = 0, Q_0 = 0, V_0 = 0.990011, V_b = 35, angle_0 = 0.205195, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-64, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b56(P_0 = 0, Q_0 = 0, V_0 = 0.993709, V_b = 35, angle_0 = 0.071875, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {196, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator29(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = -0.024, P_llmax = 0.1, P_rated = 2, Q_0 = 6.974, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0) annotation(
      Placement(visible = true, transformation(origin = {154, -38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b59(P_0 = 0, Q_0 = 0, V_0 = 0.999585, V_b = 35, angle_0 = -0.179689, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {196, 38}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator2(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 0.02, P_llmax = 0.2, P_rated = 2, Q_0 = -0.130209, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.345909) annotation(
      Placement(visible = true, transformation(origin = {-170, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer25(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {184, -38}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b14(P_0 = 2, Q_0 = -0.012465 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.274981, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-86, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b12(P_0 = 2, Q_0 = 0.021166 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.229292, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-86, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator12(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = -1.5399, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.280255) annotation(
      Placement(visible = true, transformation(origin = {-44, 68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b46(P_0 = 0, Q_0 = 0, V_0 = 0.990556, V_b = 35, angle_0 = 0.148485, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {132, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b22(P_0 = 2, Q_0 = 1.8533, V_0 = 1, V_b = 0.7, angle_0 = 0.226716, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator20(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -15.0236, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.320473) annotation(
      Placement(visible = true, transformation(origin = {90, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer4(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-140, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine11(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {5, -57}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b18(P_0 = 0, Q_0 = 0, V_0 = 0.989867, V_b = 35, angle_0 = 0.188167, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-64, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b53(P_0 = 2, Q_0 = 36.9488, V_0 = 1, V_b = 0.7, angle_0 = -0.121631, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {174, 2}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b52(P_0 = -0.024, Q_0 = 6.974, V_0 = 1, V_b = 0.7, angle_0 = 0, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {174, -38}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b3(P_0 = 2, Q_0 = -0.130209 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.345909, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-150, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator5(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -0.147856 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.322661) annotation(
      Placement(visible = true, transformation(origin = {-106, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine4(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {9, 57}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b4(P_0 = 2, Q_0 = -0.277038 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.478251, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-150, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer16(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {54, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer18(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {54, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator23(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 1.4362, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.21237) annotation(
      Placement(visible = true, transformation(origin = {90, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b60(P_0 = 0, Q_0 = 0, V_0 = 1.000402, V_b = 35, angle_0 = -0.249214, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {196, 72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator13(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = 1.4362, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.21237) annotation(
      Placement(visible = true, transformation(origin = {-44, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer22(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {120, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b27(P_0 = 0, Q_0 = 0, V_0 = 0.990304, V_b = 35, angle_0 = 0.164591, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-4, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator11(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = -1.4697, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.273731) annotation(
      Placement(visible = true, transformation(origin = {-44, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b39(P_0 = 0, Q_0 = 0, V_0 = 0.990099, V_b = 35, angle_0 = 0.197266, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {66, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b21(P_0 = 2, Q_0 = 1.4362, V_0 = 1, V_b = 0.7, angle_0 = 0.212370, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer11(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-12, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine24(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {-100, -114}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b28(P_0 = 0, Q_0 = 0, V_0 = 0.990012, V_b = 35, angle_0 = 0.184974, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-2, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b36(P_0 = 0, Q_0 = 0, V_0 = 0.990556, V_b = 35, angle_0 = 0.148485, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {66, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator21(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -1.4697, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.273731) annotation(
      Placement(visible = true, transformation(origin = {90, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine7(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {-59, -59}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Events.PwFault pwFault2(R = 0.1, X = 0.01, t1 = 15, t2 = 15.25) annotation(
      Placement(visible = true, transformation(origin = {-104, -136}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine15(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {75, -57}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer3(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-140, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer6(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-76, 34}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b32(P_0 = 2, Q_0 = 1.8533, V_0 = 1, V_b = 0.7, angle_0 = 0.226716, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {44, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine29(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {166, -110}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer26(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {184, 38}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine16(B = 0.0000007539822 / 2, G = 0, R = 0.00126, X = 0.002) annotation(
      Placement(visible = true, transformation(origin = {77, -17}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    WTblock generator3(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = 0.031443 * 100, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.239086) annotation(
      Placement(visible = true, transformation(origin = {-170, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b19(P_0 = 0, Q_0 = 0, V_0 = 0.989964, V_b = 35, angle_0 = 0.199459, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-64, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine13(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {141, 21}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b41(P_0 = 2, Q_0 = 1.4362, V_0 = 1, V_b = 0.7, angle_0 = 0.21237, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {110, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b35(P_0 = 2, Q_0 = -1.5399, V_0 = 1, V_b = 0.7, angle_0 = 0.280255, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {44, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b34(P_0 = 2, Q_0 = -1.4697, V_0 = 1, V_b = 0.7, angle_0 = 0.273731, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {44, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer9(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-76, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator25(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 36.9488, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = -0.121631) annotation(
      Placement(visible = true, transformation(origin = {154, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator10(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = -15.0236, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.320473) annotation(
      Placement(visible = true, transformation(origin = {-44, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator18(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 1.4362, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.21237) annotation(
      Placement(visible = true, transformation(origin = {24, -80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator17(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -1.5399, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.280255) annotation(
      Placement(visible = true, transformation(origin = {24, 68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b2(P_0 = 2, Q_0 = 0.031443 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.239086, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-150, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator24(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 1.8533, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.226716) annotation(
      Placement(visible = true, transformation(origin = {90, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    WTblock generator15(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = -15.0236, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.320473) annotation(
      Placement(visible = true, transformation(origin = {24, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b13(P_0 = 2, Q_0 = -0.147856 * 100, V_0 = 1, V_b = 0.7, angle_0 = 0.322661, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-86, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer24(Sn = 2.1, V_b = 35, Vn = 0.69, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {120, -80}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator19(K_ipll = 0, K_pll = 30, M_b = 10, P_0 = 2, P_llmax = 0.1, P_rated = 2, Q_0 = 1.8533, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.226716) annotation(
      Placement(visible = true, transformation(origin = {24, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer13(Sn = 2.1, V_b = 35, Vn = 35, kT = 0.7 / 35, r = 0.0073, x = 0.06) annotation(
      Placement(visible = true, transformation(origin = {-14, 0}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b42(P_0 = 2, Q_0 = 1.8533, V_0 = 1, V_b = 0.7, angle_0 = 0.226716, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {110, -40}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    OpenIPSL.Electrical.Branches.PwLine pwLine26(B = 0.0000008796459 / 2, G = 0, R = 0.00076, X = 0.0019) annotation(
      Placement(visible = true, transformation(origin = {16, -104}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine21(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {-55, 17}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine8(B = 0.0000007539822 / 2, G = 0, R = 0.00126, X = 0.002) annotation(
      Placement(visible = true, transformation(origin = {-55, -17}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Branches.PwLine pwLine5(B = 0.0000005026548 / 2, G = 0, R = 0.00391, X = 0.0023) annotation(
      Placement(visible = true, transformation(origin = {9, 21}, extent = {{-5, -5}, {5, 5}}, rotation = -90)));
    OpenIPSL.Electrical.Buses.Bus b29(P_0 = 0, Q_0 = 0, V_0 = 0.990099, V_b = 35, angle_0 = 0.197266, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-2, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Buses.Bus b25(P_0 = 2, Q_0 = -1.5399, V_0 = 1, V_b = 0.7, angle_0 = 0.280255, displayPF = true) annotation(
      Placement(visible = true, transformation(origin = {-24, 70}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    WTblock generator14(K_ipll = 40, K_pll = 10, M_b = 10, P_0 = 2, P_llmax = 0.2, P_rated = 2, Q_0 = 1.8533, V_0 = 1, V_b = 0.7, X_eq = 0.8, angle_0 = 0.226716) annotation(
      Placement(visible = true, transformation(origin = {-44, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(pwLine24.n, b61.p) annotation(
      Line(points = {{-91, -114}, {-6, -114}, {-6, -130}, {13, -130}, {13, -129}}, color = {0, 0, 255}));
    connect(pwLine27.n, b36.p) annotation(
      Line(points = {{67, -102}, {76, -102}, {76, -88}, {66, -88}, {66, -80}, {66, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer18.n, b38.p) annotation(
      Line(points = {{60.6, 0}, {66, 0}}, color = {0, 0, 255}));
    connect(generator12.pwPin, b25.p) annotation(
      Line(points = {{-35.4, 68}, {-23.5, 68}, {-23.5, 70}, {-24, 70}}, color = {0, 0, 255}));
    connect(twoWindingTransformer27.n, b60.p) annotation(
      Line(points = {{190.6, 72}, {196, 72}}, color = {0, 0, 255}));
    connect(pwFault2.p, b6.p) annotation(
      Line(points = {{-110, -136}, {-128, -136}, {-128, -80}, {-128, -80}}, color = {0, 0, 255}));
    connect(pwLine9.p, b39.p) annotation(
      Line(points = {{76, 24}, {74, 24}, {74, 30}, {66, 30}, {66, 36}, {66, 36}, {66, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer13.p, b23.p) annotation(
      Line(points = {{-20.6, 0}, {-24, 0}}, color = {0, 0, 255}));
    connect(pwLine8.p, b18.p) annotation(
      Line(points = {{-54, -12}, {-56, -12}, {-56, -6}, {-64, -6}, {-64, 0}, {-64, 0}}, color = {0, 0, 255}));
    connect(generator1.pwPin, b4.p) annotation(
      Line(points = {{-159, 36}, {-150, 36}}, color = {0, 0, 255}));
    connect(pwLine5.p, b29.p) annotation(
      Line(points = {{10, 26}, {8, 26}, {8, 30}, {-2, 30}, {-2, 36}, {-2, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer3.n, b7.p) annotation(
      Line(points = {{-134, -40}, {-128, -40}, {-128, -40}, {-128, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer19.n, b36.p) annotation(
      Line(points = {{60.6, -80}, {66, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer25.p, b52.p) annotation(
      Line(points = {{177.4, -38}, {174, -38}}, color = {0, 0, 255}));
    connect(twoWindingTransformer8.p, b13.p) annotation(
      Line(points = {{-82.6, 0}, {-86, 0}}, color = {0, 0, 255}));
    connect(pwLine5.n, b28.p) annotation(
      Line(points = {{10, 16}, {8, 16}, {8, 6}, {-2, 6}, {-2, 0}, {-2, 0}}, color = {0, 0, 255}));
    connect(generator19.pwPin, b32.p) annotation(
      Line(points = {{32.6, -40}, {44, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer25.n, b57.p) annotation(
      Line(points = {{190.6, -38}, {196, -38}}, color = {0, 0, 255}));
    connect(twoWindingTransformer20.p, b42.p) annotation(
      Line(points = {{113.4, -40}, {110, -40}}, color = {0, 0, 255}));
    connect(pwLine1.n, b6.p) annotation(
      Line(points = {{-118, -66}, {-120, -66}, {-120, -72}, {-128, -72}, {-128, -80}, {-128, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer.n, b10.p) annotation(
      Line(points = {{-133.4, 70}, {-128, 70}, {-128, 70}, {-128, 70}}, color = {0, 0, 255}));
    connect(generator8.pwPin, b11.p) annotation(
      Line(points = {{-97.4, -80}, {-86, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer1.n, b9.p) annotation(
      Line(points = {{-133.4, 34}, {-128, 34}, {-128, 36}, {-128, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer21.p, b44.p) annotation(
      Line(points = {{113.4, 36}, {110, 36}}, color = {0, 0, 255}));
    connect(pwLine29.n, b56.p) annotation(
      Line(points = {{175, -110}, {204, -110}, {204, -84}, {196, -84}, {196, -78}, {196, -78}}, color = {0, 0, 255}));
    connect(twoWindingTransformer26.p, b54.p) annotation(
      Line(points = {{177.4, 38}, {176, 38}}, color = {0, 0, 255}));
    connect(pwLine26.p, b26.p) annotation(
      Line(points = {{16, -95}, {16, -95}, {16, -86}, {-2, -86}, {-2, -80}, {-2, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer5.n, b17.p) annotation(
      Line(points = {{-69.4, -40}, {-64, -40}}, color = {0, 0, 255}));
    connect(pwLine7.n, b16.p) annotation(
      Line(points = {{-58, -64}, {-58, -64}, {-58, -74}, {-64, -74}, {-64, -80}, {-64, -80}}, color = {0, 0, 255}));
    connect(generator.pwPin, b5.p) annotation(
      Line(points = {{-159, 70}, {-150, 70}}, color = {0, 0, 255}));
    connect(pwLine13.p, b49.p) annotation(
      Line(points = {{142, 26}, {140, 26}, {140, 32}, {132, 32}, {132, 36}, {132, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer10.p, b22.p) annotation(
      Line(points = {{-20.6, -40}, {-24, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer8.n, b18.p) annotation(
      Line(points = {{-69.4, 0}, {-64, 0}}, color = {0, 0, 255}));
    connect(generator27.pwPin, b55.p) annotation(
      Line(points = {{162.6, 70}, {166.5, 70}, {166.5, 72}, {174, 72}}, color = {0, 0, 255}));
    connect(twoWindingTransformer9.p, b11.p) annotation(
      Line(points = {{-82.6, -80}, {-86, -80}}, color = {0, 0, 255}));
    connect(pwLine19.p, b47.p) annotation(
      Line(points = {{140, -52}, {138, -52}, {138, -46}, {132, -46}, {132, -40}, {132, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer4.n, b6.p) annotation(
      Line(points = {{-133.4, -80}, {-128, -80}, {-128, -80}, {-128, -80}}, color = {0, 0, 255}));
    connect(generator24.pwPin, b42.p) annotation(
      Line(points = {{98.6, -40}, {110, -40}}, color = {0, 0, 255}));
    connect(pwLine27.p, b61.p) annotation(
      Line(points = {{49, -102}, {26, -102}, {26, -128}, {14, -128}, {14, -129}, {13, -129}}, color = {0, 0, 255}));
    connect(twoWindingTransformer10.n, b27.p) annotation(
      Line(points = {{-7.4, -40}, {-4, -40}}, color = {0, 0, 255}));
    connect(generator25.pwPin, b53.p) annotation(
      Line(points = {{162.6, 2}, {174, 2}}, color = {0, 0, 255}));
    connect(pwLine26.n, b61.p) annotation(
      Line(points = {{16, -113}, {12, -113}, {12, -129}, {13, -129}}, color = {0, 0, 255}));
    connect(twoWindingTransformer15.p, b32.p) annotation(
      Line(points = {{47.4, -40}, {44, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer11.n, b29.p) annotation(
      Line(points = {{-5, 36}, {-2, 36}}, color = {0, 0, 255}));
    connect(pwLine29.p, b61.p) annotation(
      Line(points = {{157, -110}, {144, -110}, {144, -120}, {34, -120}, {34, -128}, {13, -128}, {13, -129}}, color = {0, 0, 255}));
    connect(pwLine22.p, b58.p) annotation(
      Line(points = {{206, -10}, {206, -10}, {206, -4}, {196, -4}, {196, 2}, {196, 2}}, color = {0, 0, 255}));
    connect(generator4.pwPin, b1.p) annotation(
      Line(points = {{-161.4, -80}, {-150, -80}, {-150, -80}, {-150, -80}}, color = {0, 0, 255}));
    connect(pwLine17.n, b59.p) annotation(
      Line(points = {{206, 54}, {204, 54}, {204, 46}, {196, 46}, {196, 38}, {196, 38}}, color = {0, 0, 255}));
    connect(generator22.pwPin, b45.p) annotation(
      Line(points = {{98.6, 68}, {110.5, 68}, {110.5, 70}, {110, 70}}, color = {0, 0, 255}));
    connect(generator11.pwPin, b24.p) annotation(
      Line(points = {{-35.4, 34}, {-35.5, 34}, {-35.5, 36}, {-24, 36}}, color = {0, 0, 255}));
    connect(pwLine10.p, b40.p) annotation(
      Line(points = {{76, 60}, {76, 60}, {76, 66}, {66, 66}, {66, 70}, {66, 70}}, color = {0, 0, 255}));
    connect(pwLine16.n, b37.p) annotation(
      Line(points = {{78, -22}, {76, -22}, {76, -34}, {66, -34}, {66, -40}, {66, -40}}, color = {0, 0, 255}));
    connect(pwFault.p, b61.p) annotation(
      Line(points = {{70, -138}, {32, -138}, {32, -128}, {14, -128}, {14, -128}}, color = {0, 0, 255}));
    connect(generator10.pwPin, b23.p) annotation(
      Line(points = {{-35.4, 0}, {-24, 0}}, color = {0, 0, 255}));
    connect(generator6.pwPin, b14.p) annotation(
      Line(points = {{-97.4, 36}, {-86, 36}}, color = {0, 0, 255}));
    connect(pwLine23.p, b57.p) annotation(
      Line(points = {{206, -50}, {206, -50}, {206, -42}, {196, -42}, {196, -38}, {196, -38}}, color = {0, 0, 255}));
    connect(twoWindingTransformer29.n, b56.p) annotation(
      Line(points = {{190.6, -78}, {196, -78}}, color = {0, 0, 255}));
    connect(generator20.pwPin, b43.p) annotation(
      Line(points = {{98.6, 0}, {110, 0}}, color = {0, 0, 255}));
    connect(pwLine7.p, b17.p) annotation(
      Line(points = {{-58, -54}, {-58, -54}, {-58, -44}, {-64, -44}, {-64, -40}, {-64, -40}}, color = {0, 0, 255}));
    connect(pwLine4.p, b30.p) annotation(
      Line(points = {{10, 62}, {8, 62}, {8, 70}, {-2, 70}, {-2, 70}}, color = {0, 0, 255}));
    connect(generator23.pwPin, b41.p) annotation(
      Line(points = {{98.6, -80}, {110, -80}}, color = {0, 0, 255}));
    connect(pwLine9.n, b38.p) annotation(
      Line(points = {{76, 14}, {76, 14}, {76, 6}, {66, 6}, {66, 0}, {66, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer31.p, b61.p) annotation(
      Line(points = {{25, -137.3}, {24, -137.3}, {24, -128}, {13, -128}, {13, -129}}, color = {0, 0, 255}));
    connect(twoWindingTransformer27.p, b55.p) annotation(
      Line(points = {{177.4, 72}, {174, 72}}, color = {0, 0, 255}));
    connect(generator16.pwPin, b34.p) annotation(
      Line(points = {{32.6, 36}, {44, 36}}, color = {0, 0, 255}));
    connect(pwLine15.n, b36.p) annotation(
      Line(points = {{76, -62}, {74, -62}, {74, -76}, {66, -76}, {66, -80}, {66, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer16.n, b39.p) annotation(
      Line(points = {{60.6, 36}, {66, 36}}, color = {0, 0, 255}));
    connect(pwFault1.p, b62.p) annotation(
      Line(points = {{-30, -186}, {-46, -186}, {-46, -170}, {2, -170}, {2, -162}, {12, -162}, {12, -162}}, color = {0, 0, 255}));
    connect(twoWindingTransformer2.p, b3.p) annotation(
      Line(points = {{-146.6, 0}, {-150, 0}, {-150, 0}, {-150, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer24.n, b46.p) annotation(
      Line(points = {{126.6, -80}, {132, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer6.n, b19.p) annotation(
      Line(points = {{-69.4, 34}, {-64, 34}, {-64, 36}}, color = {0, 0, 255}));
    connect(pwLine25.n, b61.p) annotation(
      Line(points = {{-29, -100}, {0, -100}, {0, -129}, {13, -129}}, color = {0, 0, 255}));
    connect(pwLine6.p, b20.p) annotation(
      Line(points = {{-54, 58}, {-54, 58}, {-54, 66}, {-64, 66}, {-64, 70}, {-64, 70}}, color = {0, 0, 255}));
    connect(pwLine14.n, b49.p) annotation(
      Line(points = {{142, 52}, {140, 52}, {140, 42}, {132, 42}, {132, 36}, {132, 36}}, color = {0, 0, 255}));
    connect(generator17.pwPin, b35.p) annotation(
      Line(points = {{32.6, 68}, {44.5, 68}, {44.5, 70}, {44, 70}}, color = {0, 0, 255}));
    connect(pwLine25.p, b16.p) annotation(
      Line(points = {{-47, -100}, {-60, -100}, {-60, -86}, {-64, -86}, {-64, -80}, {-64, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer29.p, b51.p) annotation(
      Line(points = {{177.4, -78}, {174, -78}}, color = {0, 0, 255}));
    connect(twoWindingTransformer3.p, b2.p) annotation(
      Line(points = {{-146, -40}, {-150, -40}, {-150, -40}, {-150, -40}}, color = {0, 0, 255}));
    connect(pwLine20.p, b48.p) annotation(
      Line(points = {{142, -12}, {142, -12}, {142, -6}, {132, -6}, {132, 0}, {132, 0}}, color = {0, 0, 255}));
    connect(generator9.pwPin, b12.p) annotation(
      Line(points = {{-97.4, -40}, {-86, -40}}, color = {0, 0, 255}));
    connect(pwLine13.n, b48.p) annotation(
      Line(points = {{142, 16}, {142, 16}, {142, 6}, {132, 6}, {132, 0}, {132, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer7.n, b20.p) annotation(
      Line(points = {{-69.4, 70}, {-64, 70}}, color = {0, 0, 255}));
    connect(loadpq.p, b62.p) annotation(
      Line(points = {{11, -176}, {12, -176}, {12, -162}}, color = {0, 0, 255}));
    connect(pwLine8.n, b17.p) annotation(
      Line(points = {{-54, -22}, {-56, -22}, {-56, -32}, {-64, -32}, {-64, -40}, {-64, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer12.p, b25.p) annotation(
      Line(points = {{-20.6, 70}, {-24, 70}}, color = {0, 0, 255}));
    connect(pwLine21.p, b19.p) annotation(
      Line(points = {{-54, 22}, {-56, 22}, {-56, 30}, {-64, 30}, {-64, 36}, {-64, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer28.p, b53.p) annotation(
      Line(points = {{177.4, 2}, {174, 2}}, color = {0, 0, 255}));
    connect(twoWindingTransformer22.p, b45.p) annotation(
      Line(points = {{113.4, 70}, {110, 70}}, color = {0, 0, 255}));
    connect(pwLine16.p, b38.p) annotation(
      Line(points = {{78, -12}, {76, -12}, {76, -6}, {66, -6}, {66, 0}, {66, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer30.p, b61.p) annotation(
      Line(points = {{5, -137.3}, {4, -137.3}, {4, -128}, {13, -128}, {13, -129}}, color = {0, 0, 255}));
    connect(pwLine10.n, b39.p) annotation(
      Line(points = {{76, 50}, {74, 50}, {74, 42}, {66, 42}, {66, 36}, {66, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer18.p, b33.p) annotation(
      Line(points = {{47.4, 0}, {44, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer6.p, b14.p) annotation(
      Line(points = {{-82.6, 34}, {-86, 34}, {-86, 36}}, color = {0, 0, 255}));
    connect(pwLine15.p, b37.p) annotation(
      Line(points = {{76, -52}, {74, -52}, {74, -46}, {66, -46}, {66, -40}, {66, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer9.n, b16.p) annotation(
      Line(points = {{-69.4, -80}, {-64, -80}}, color = {0, 0, 255}));
    connect(generator3.pwPin, b2.p) annotation(
      Line(points = {{-161.4, -40}, {-150, -40}, {-150, -40}, {-150, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer21.n, b49.p) annotation(
      Line(points = {{126.6, 36}, {132, 36}}, color = {0, 0, 255}));
    connect(pwLine18.n, b58.p) annotation(
      Line(points = {{206, 18}, {206, 18}, {206, 8}, {196, 8}, {196, 2}, {196, 2}}, color = {0, 0, 255}));
    connect(generator15.pwPin, b33.p) annotation(
      Line(points = {{32.6, 0}, {44, 0}}, color = {0, 0, 255}));
    connect(generator29.pwPin, b52.p) annotation(
      Line(points = {{162.6, -38}, {174, -38}}, color = {0, 0, 255}));
    connect(generator13.pwPin, b21.p) annotation(
      Line(points = {{-35.4, -80}, {-24, -80}}, color = {0, 0, 255}));
    connect(pwLine14.p, b50.p) annotation(
      Line(points = {{142, 62}, {140, 62}, {140, 64}, {132, 64}, {132, 70}, {132, 70}}, color = {0, 0, 255}));
    connect(twoWindingTransformer31.n, b62.p) annotation(
      Line(points = {{25, -152.7}, {25, -152.7}, {25, -162}, {12, -162}, {12, -162}}, color = {0, 0, 255}));
    connect(twoWindingTransformer15.n, b37.p) annotation(
      Line(points = {{60.6, -40}, {66, -40}}, color = {0, 0, 255}));
    connect(pwLine17.p, b60.p) annotation(
      Line(points = {{206, 64}, {204, 64}, {204, 66}, {196, 66}, {196, 72}, {196, 72}}, color = {0, 0, 255}));
    connect(generator21.pwPin, b44.p) annotation(
      Line(points = {{98.6, 36}, {110, 36}}, color = {0, 0, 255}));
    connect(generator28.pwPin, b51.p) annotation(
      Line(points = {{162.6, -78}, {174, -78}}, color = {0, 0, 255}));
    connect(pwLine.p, b8.p) annotation(
      Line(points = {{-118, -14}, {-120, -14}, {-120, -6}, {-128, -6}, {-128, 0}, {-128, 0}}, color = {0, 0, 255}));
    connect(pwLine11.n, b26.p) annotation(
      Line(points = {{6, -62}, {6, -62}, {6, -72}, {-2, -72}, {-2, -80}, {-2, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer14.n, b26.p) annotation(
      Line(points = {{-7.4, -80}, {-2, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer2.n, b8.p) annotation(
      Line(points = {{-133.4, 0}, {-128, 0}, {-128, 0}, {-128, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer23.n, b48.p) annotation(
      Line(points = {{129, -2}, {129.3, -2}, {129.3, 0}, {132, 0}}, color = {0, 0, 255}));
    connect(pwLine6.n, b19.p) annotation(
      Line(points = {{-54, 48}, {-56, 48}, {-56, 42}, {-64, 42}, {-64, 36}, {-64, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer.p, b5.p) annotation(
      Line(points = {{-146.6, 70}, {-150, 70}, {-150, 70}, {-150, 70}}, color = {0, 0, 255}));
    connect(generator14.pwPin, b22.p) annotation(
      Line(points = {{-35.4, -40}, {-24, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer7.p, b15.p) annotation(
      Line(points = {{-82.6, 70}, {-86, 70}}, color = {0, 0, 255}));
    connect(pwLine4.n, b29.p) annotation(
      Line(points = {{10, 52}, {8, 52}, {8, 42}, {-2, 42}, {-2, 36}, {-2, 36}}, color = {0, 0, 255}));
    connect(generator2.pwPin, b3.p) annotation(
      Line(points = {{-161.4, 0}, {-150, 0}, {-150, 0}, {-150, 0}}, color = {0, 0, 255}));
    connect(pwLine28.n, b46.p) annotation(
      Line(points = {{105, -106}, {140, -106}, {140, -86}, {132, -86}, {132, -80}, {132, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer11.p, b24.p) annotation(
      Line(points = {{-19, 36}, {-24, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer5.p, b12.p) annotation(
      Line(points = {{-82.6, -40}, {-86, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer13.n, b28.p) annotation(
      Line(points = {{-7.4, 0}, {-2, 0}}, color = {0, 0, 255}));
    connect(pwLine19.n, b46.p) annotation(
      Line(points = {{140, -62}, {140, -62}, {140, -74}, {132, -74}, {132, -80}, {132, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer14.p, b21.p) annotation(
      Line(points = {{-20.6, -80}, {-24, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer26.n, b59.p) annotation(
      Line(points = {{190.6, 38}, {196, 38}}, color = {0, 0, 255}));
    connect(twoWindingTransformer23.p, b43.p) annotation(
      Line(points = {{115, -2}, {111.7, -2}, {111.7, 0}, {110, 0}}, color = {0, 0, 255}));
    connect(pwLine2.n, b8.p) annotation(
      Line(points = {{-118, 14}, {-120, 14}, {-120, 6}, {-128, 6}, {-128, 0}, {-128, 0}}, color = {0, 0, 255}));
    connect(pwLine18.p, b59.p) annotation(
      Line(points = {{206, 28}, {204, 28}, {204, 30}, {196, 30}, {196, 38}, {196, 38}}, color = {0, 0, 255}));
    connect(twoWindingTransformer17.n, b40.p) annotation(
      Line(points = {{60.6, 70}, {66, 70}}, color = {0, 0, 255}));
    connect(pwLine20.n, b47.p) annotation(
      Line(points = {{142, -22}, {140, -22}, {140, -34}, {132, -34}, {132, -40}, {132, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer30.n, b62.p) annotation(
      Line(points = {{5, -152.7}, {4, -152.7}, {4, -162}, {12, -162}, {12, -162}}, color = {0, 0, 255}));
    connect(generator26.pwPin, b54.p) annotation(
      Line(points = {{162.6, 38}, {176, 38}}, color = {0, 0, 255}));
    connect(generator18.pwPin, b31.p) annotation(
      Line(points = {{32.6, -80}, {44, -80}}, color = {0, 0, 255}));
    connect(pwLine3.n, b9.p) annotation(
      Line(points = {{-119, 48.5}, {-120, 48.5}, {-120, 40}, {-128, 40}, {-128, 36}}, color = {0, 0, 255}));
    connect(pwLine1.p, b7.p) annotation(
      Line(points = {{-118, -56}, {-118, -56}, {-118, -48}, {-128, -48}, {-128, -40}, {-128, -40}}, color = {0, 0, 255}));
    connect(generator5.pwPin, b13.p) annotation(
      Line(points = {{-97.4, 0}, {-86, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer1.p, b4.p) annotation(
      Line(points = {{-146.6, 34}, {-150, 34}, {-150, 36}, {-150, 36}}, color = {0, 0, 255}));
    connect(twoWindingTransformer22.n, b50.p) annotation(
      Line(points = {{126.6, 70}, {132, 70}}, color = {0, 0, 255}));
    connect(generator7.pwPin, b15.p) annotation(
      Line(points = {{-97.4, 70}, {-86, 70}}, color = {0, 0, 255}));
    connect(pwLine3.p, b10.p) annotation(
      Line(points = {{-119, 57.5}, {-120, 57.5}, {-120, 64}, {-128, 64}, {-128, 70}}, color = {0, 0, 255}));
    connect(pwLine2.p, b9.p) annotation(
      Line(points = {{-118, 24}, {-120, 24}, {-120, 30}, {-128, 30}, {-128, 36}, {-128, 36}}, color = {0, 0, 255}));
    connect(pwLine12.p, b28.p) annotation(
      Line(points = {{8, -12}, {8, -12}, {8, -6}, {-2, -6}, {-2, 0}, {-2, 0}}, color = {0, 0, 255}));
    connect(pwLine24.p, b6.p) annotation(
      Line(points = {{-109, -114}, {-122, -114}, {-122, -86}, {-128, -86}, {-128, -80}}, color = {0, 0, 255}));
    connect(pwLine11.p, b27.p) annotation(
      Line(points = {{6, -52}, {6, -52}, {6, -46}, {-4, -46}, {-4, -40}, {-4, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer19.p, b31.p) annotation(
      Line(points = {{47.4, -80}, {44, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer28.n, b58.p) annotation(
      Line(points = {{190.6, 2}, {196, 2}}, color = {0, 0, 255}));
    connect(pwLine21.n, b18.p) annotation(
      Line(points = {{-54, 12}, {-56, 12}, {-56, 8}, {-64, 8}, {-64, 0}, {-64, 0}}, color = {0, 0, 255}));
    connect(twoWindingTransformer12.n, b30.p) annotation(
      Line(points = {{-7.4, 70}, {-2, 70}}, color = {0, 0, 255}));
    connect(pwLine12.n, b27.p) annotation(
      Line(points = {{8, -22}, {6, -22}, {6, -32}, {-4, -32}, {-4, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer4.p, b1.p) annotation(
      Line(points = {{-146.6, -80}, {-150, -80}, {-150, -80}, {-150, -80}}, color = {0, 0, 255}));
    connect(twoWindingTransformer17.p, b35.p) annotation(
      Line(points = {{47.4, 70}, {44, 70}}, color = {0, 0, 255}));
    connect(pwLine23.n, b56.p) annotation(
      Line(points = {{206, -60}, {206, -60}, {206, -70}, {196, -70}, {196, -78}, {196, -78}}, color = {0, 0, 255}));
    connect(twoWindingTransformer16.p, b34.p) annotation(
      Line(points = {{47.4, 36}, {44, 36}}, color = {0, 0, 255}));
    connect(pwLine.n, b7.p) annotation(
      Line(points = {{-118, -24}, {-118, -24}, {-118, -34}, {-128, -34}, {-128, -40}, {-128, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer20.n, b47.p) annotation(
      Line(points = {{126.6, -40}, {132, -40}}, color = {0, 0, 255}));
    connect(twoWindingTransformer24.p, b41.p) annotation(
      Line(points = {{113.4, -80}, {110, -80}}, color = {0, 0, 255}));
    connect(pwLine28.p, b61.p) annotation(
      Line(points = {{87, -106}, {76, -106}, {76, -112}, {32, -112}, {32, -128}, {14, -128}, {14, -129}, {13, -129}}, color = {0, 0, 255}));
    connect(pwLine22.n, b57.p) annotation(
      Line(points = {{206, -20}, {206, -20}, {206, -34}, {196, -34}, {196, -38}, {196, -38}}, color = {0, 0, 255}));
    annotation(
      Diagram(coordinateSystem(extent = {{-180, -195}, {210, 95}})),
      Icon(coordinateSystem(extent = {{-180, -195}, {210, 95}})));end Model;
  annotation(
    uses(OpenIPSL(version = "1.5.1"), Modelica(version = "3.2.3"), Complex(version = "3.2.3")));
end WT3G1_test;
