package Ex10_4
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-10:Vapor/Liquid Equilibrium- Introduction
  //Example: 10.4 Page 364
  //Title: Calculate dew point and bubble point pressures
  //==================================================================================

  model Ex10_4_a
    //==================================
    //Parameter section
    parameter Real T(unit = "K") = 283.15 "Temperature of system";
    parameter Real[3] y(unit = "") = {0.10, 0.20, 0.70} "Composition in liquid phase";
    parameter Real[3] P(unit = "bar") = {6.9, 10.34, 8.7} "Assumed pressures while dew pressure";
    parameter Real[3,3] K(unit = "") = {{20.0, 3.25, 0.92},{13.2,2.25,0.65},{16,2.65,0.762}} "K values";
    //==================================
    //Variable section
    Real[3,3] yibyKi(unit = "") "yi/Ki";
    Real[3] sum(start = 0) "Summation of yi/Ki";
    Real Pdew(unit = "bar") "Dew point pressure";
    //==================================
    //Equation section
  equation
    for i in 1:3 loop
      yibyKi[1,i] = y[i] / K[1,i];
      yibyKi[2,i] = y[i] / K[2,i];
      yibyKi[3,i] = y[i] / K[3,i];
      end for;
      sum[1] = sum(yibyKi[1,:]);
      sum[2] = sum(yibyKi[2,:]);
      sum[3] = sum(yibyKi[3,:]);
    Pdew = 8.7;
//Summation of yi/Ki =1
  end Ex10_4_a;


  //==================================

  model Ex10_4_b
    //==================================
    //Parameter section
    parameter Real T(unit = "K") = 283.15 "Temperature of system";
    parameter Real[3] x(unit = "") = {0.10, 0.20, 0.70} "Composition in liquid phase";
    parameter Real[3] P2(unit = "bar") = {26.2, 27.6, 26.54} "Assumed pressures while bubble pressure";
    parameter Real[3,3] K(unit = "") = {{5.6,1.11,0.335},{5.25,1.07,0.32},{5.49,1.10,0.33}} "K values";
    //==================================
    //Variable section
    Real[3,3] xiKi(unit = "") "xi/Ki";
    Real[3] sum(unit="") "Summation of xi/Ki";
    Real Pbub(unit = "bar") "Bubble point pressure";
    //==================================
    //Equation section
  equation
    for i in 1:3 loop
      xiKi[1,i] = x[i] * K[1,i];
      xiKi[2,i] = x[i] * K[2,i];
      xiKi[3,i] = x[i] * K[3,i];
      end for;
      sum[1] = sum(xiKi[1,:]);
      sum[2] = sum(xiKi[2,:]);
      sum[3] = sum(xiKi[3,:]);
  
    Pbub = 26.54;
//Summation of xi/Ki =1
  end Ex10_4_b;


  //==================================
end Ex10_4;
