//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-10:Vapor/Liquid Equilibrium- Introduction
//Example: 10.5 Page 368
//Title: Calculate liquid, vapor flow rates and composition
//==================================================================================
model Ex10_5

//==================================
//Parameter section
parameter Real P(unit="kPa")=110 "Pressure of system";
parameter Real P1s(unit="kPa")=195.75 "Saturation pressure of component 1";
parameter Real P2s(unit="kPa")=97.84 "Saturation pressure of component 2";
parameter Real P3s(unit="kPa")=50.32 "Saturation pressure of component 3";
parameter Real z1(unit="")=0.45 "Overall compostion";
parameter Real z2(unit="")=0.35 "Overall compostion";
parameter Real z3(unit="")=0.20 "Overall compostion";

//==================================
//Variable section
Real L(unit="mol") "Liquid quantity";
Real V(unit="mol") "Vapor quantity";
Real Pbub(unit="kPa") "Bubble point pressure";
Real Pdew(unit="kPa") "Dew point pressure";
Real K1(unit="") "K value";
Real K2(unit="") "K value";
Real K3(unit="") "K value";
Real x1(unit="") "Liquid compostion";
Real x2(unit="") "Liquid compostion";
Real x3(unit="") "Liquid compostion";
Real y1(unit="") "Vapor compostion";
Real y2(unit="") "Vapor compostion";
Real y3(unit="") "Vapor compostion";

//==================================
//Equation section
equation
Pbub = z1*P1s+z2*P2s+z3*P3s;
Pdew = 1/(z1/P1s+z2/P2s+z3/P3s);
K1 = P1s/P;
K2 = P2s/P;
K3 = P3s/P;
y1 = z1*K1/(1+V*(K1-1));
y2 = z2*K2/(1+V*(K2-1));
y3 = z3*K3/(1+V*(K3-1));
y1+y2+y3 = 1;
L = 1-V;
x1 = y1/K1;
x2 = y2/K2;
x3 = y3/K3;

end Ex10_5;
//==================================================================================