//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-10:Vapor/Liquid Equilibrium- Introduction
//Example: 10.6 Page 369
//Title: Calculate fraction of system in vapor
//==================================================================================
model Ex10_6

//==================================
//Parameter section
parameter Real[3] z(unit = "") = {0.10, 0.20, 0.70} "Composition of feed";
parameter Real[3] K(unit = "") = {10.0, 1.76, 0.52} "K values";

//==================================
//Variable section
Real V(unit = "") "Vapor fraction";
Real[3] y(unit = "") "Vapor composition";
Real[3] x(unit = "") "Liquid composition";

//==================================
//Equation section
equation
for i in 1:3 loop
y[i] = z[i]*K[i]/(1+V*(K[i]-1));
x[i] = y[i]/K[i];
end for;
y[1]+y[2]+y[3] = 1;

end Ex10_6;
//==================================================================================