//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-11:Solution Thermodynamics: Theory
//Example: 11.10 Page 416
//Title: Determine the excess properties of benzene hexane mixture
//==================================================================================
model Ex11_10

//==================================
//Parameter section
parameter Real T0(unit="K")=298.15 "Temperature at which property values are given";
parameter Real T(unit="K")=323.15 "Temperature of system";
parameter Real H0E(unit="J/mol")=897.9 "Reference excess enthalpy";
parameter Real G0E(unit="J/mol")=384.5 "Reference excess Gibbs free energy";
parameter Real CP0E(unit="J/mol K")=-2.86 "Reference excess specific heat";

//==================================
//Variable section
Real HE(unit="J/mol") "Excess enthalpy";
Real GE(unit="J/mol") "Excess Gibbs free energy";
Real SE(unit="J/mol K") "Excess entropy";
Real a(unit="") "Equation constants";
Real b(unit="") "Equation constants";
Real c(unit="") "Equation constants";

//==================================
//Equation section
equation
a = CP0E;
b = (G0E+a*(T0*log(T0)-T0)-c)/T0;
c = H0E-a*T0;
GE = -a*(T*log(T)-T)+b*T+c;
SE = a*log(T)-b;
HE = GE+T*SE;

end Ex11_10;
//==================================================================================