//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-11:Solution Thermodynamics: Theory
//Example: 11.5 Page 399
//Title: Calculate values of f and phi from data in steam tables
//==================================================================================
model Ex11_5

//==================================
//Parameter section
parameter Real[22] P(unit="kPa")={10,50,100,200,500,1000,1500,2000,2500,3000,3500,4000,4500,5000,5500,6000,6500,7000,7600,8000,8400,10000} "Pressures of system";
parameter Real T(unit="K")=573.15 "Temperature of system";
parameter Real R(unit="J / mol K ")=8.314 "Universal gas constant";

//==================================
//Variable section
Real[21] H(unit="J/g") "Enthalpy value";
Real[21] S(unit="J/K g") "Entropy value";
Real H_ast(unit="J/g") "Enthalpy value at 1kPa";
Real S_ast(unit="J/K g") "Entropy value at 1kPa";
Real[22] f(unit="kPa") "Fugacity";
Real[22] phi(unit="") "Fugacity coefficient";
Real Vi(unit="cm^3/mol") "Volume of saturated liquid";
Real P_sat(unit="kPa") "Saturation pressure of liquid";
Real phi_sat(unit="") "Fugacity coefficient of saturated liquid";
Real f_sat(unit="kPa") "Fugacity of saturated liquid";

//==================================
//Equation section
equation
H_ast = 3076.8;
S_ast = 10.3450;
H ={3076.6,3075.7,3074.2,3072.1,3064.8,3052.1,3038.9,3025,3010.4,2995.1,2979,2962,2944.2,2925.5,2905.8,2885,2862.9,2839.4,2808.8,2786.8,2763};
S ={9.282,8.5380,8.2166,7.8937,7.4614,7.1251,6.9207,6.7696,6.6470,6.5422,6.4491,6.3642,6.2852,6.2105,6.1388,6.0692,6.0008,5.9327,5.8503,5.7942,5.7366}; //From steam tables
for i in 1:21 loop
f[i] = exp((18.015/R)*((H[i]-H_ast)/T-(S[i]-S_ast)));
phi[i] = f[i]/P[i];
end for;
//After saturation pressure, f becomes constant
P_sat = 8592.7;
phi_sat = 0.7843;
f_sat = 6738.9;
Vi = 25.28;
f[22] = phi_sat*P_sat*exp(Vi*(P[22]-P_sat)/(R*1000*T));
phi[22] = f[22]/P[22];

end Ex11_5;
//==================================================================================
