//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-11:Solution Thermodynamics: Theory
//Example: 11.7 Page 406
//Title: Determine fugacity coefficients for nitrogen and methane
//==================================================================================
model Ex11_7

//==================================
//Parameter section
parameter Real P(unit="bar")=30 "Pressure of system";
parameter Real T(unit="K")=200 "Temperature of system";
parameter Real B11(unit="cm^3/mol")=-35.2 "Virial coefficients";
parameter Real B22(unit="cm^3/mol")=-105.0 "Virial coefficients";
parameter Real B12(unit="cm^3/mol")=-59.8 "Virial coefficients";
parameter Real R(unit="bar cm^3/mol K")=83.14 "Universal gas constant";
parameter Real y1(unit="")=0.4 "Mole fraction of N2 in vapor";

//==================================
//Variable section
Real sigma12(unit="cm^3/mol") "Virial coefficient";
Real phi1(unit="cm^3/mol") "Fugacity coefficient of component 1";
Real phi2(unit="cm^3/mol") "Fugacity coefficient of component 2";
Real B(unit="cm^3/mol") "Virial coefficient";
Real Z(unit="") "Compressibility factor";

//==================================
//Equation section
equation
sigma12 = 2*B12-B11-B22;
log(phi1) = P/(R*T)*(B11+(1-y1)^2*sigma12);
log(phi2) = P/(R*T)*(B22+(y1)^2*sigma12);
B = y1^2*B11+2*y1*(1-y1)*B12+(1-y1)^2*B22;
Z = 1+(B*P)/(R*T);

end Ex11_7;
//==================================================================================