//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-12:Solution Thermodynamics: Applications
//Example: 12.6 Page 466
//Title: Calculate heat transfer rate in evaporator
//==================================================================================
model Ex12_6

//==================================
//Parameter section
parameter Real Tf(unit="K")=294.15 "Feed temperature";
parameter Real T(unit="K")=361.15 "Boiling point of NaOH";
parameter Real Hsteam(unit="kJ/kg")=2666 "Enthalpy of saturated steam";
parameter Real H1(unit="kJ/kg")=79 "Enthalpy of 10% NaOH at 294.15 K";
parameter Real H2(unit="kJ/kg")=500 "Enthalpy of 50% NaOH at 361.15 K";
parameter Real m1(unit="kg/s")=1 "Mass of superheated steam entering";
parameter Real m2(unit="kg/s")=0.25 "Mass of 50% NaOH";
parameter Real m3(unit="kg/s")=1.25 "Mass of 10% NaOH";

//==================================
//Variable section
Real Q(unit="kW") "Heat transfer rate";

//==================================
//Equation section
equation
Q = m1*Hsteam+m2*H2-m3*H1; //energy balance

end Ex12_6;
//==================================================================================