//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-12:Solution Thermodynamics: Applications
//Example: 12.9 Page 469
//Title: Calculate heat to be transferred to NaOH solution
//==================================================================================
model Ex12_9

//==================================
//Parameter section
parameter Real T(unit="K")=294.15 "Temperature of NaOH,water and solution";
parameter Real H_H2O(unit="kJ/kg")=88 "Enthalpy of water";
parameter Real H_solid(unit="kJ/kg")=1113 "Enthalpy of 45% NaOH solution";
parameter Real H_sol(unit="kJ/kg")=216 "Enthalpy of solid NaOH";
parameter Real m1(unit="kg")=1 "Mass of solution";
parameter Real m2(unit="kg")=0.45 "Mass of solid NaOH";
parameter Real m3(unit="kg")=0.55 "Mass of water";

//==================================
//Variable section
Real Q(unit="kJ/kg") "Heat transfer rate";

//==================================
//Equation section
equation
Q = m1*H_sol-m2*H_solid-m3*H_H2O; //energy balance

end Ex12_9;
//==================================================================================
