package Ex13_11
function DOF
input Real pi;
input Real N;
input Real r;
input Real s;
output Real F;
algorithm
F := 2-pi+N-r-s;
end DOF;


//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-13:Chemical-Reaction Equilibria
  //Example: 13.11 Page 515
  //Title: Calculate degrees of freedom
  //==================================================================================

  model Ex13_11_a

//==================================
//Parameter section
parameter Real pi(unit = "") =2 "Number of phases";
parameter Real N(unit = "") =2 "Number of components";
parameter Real r(unit = "") =0 "Number of reactions";
parameter Real s(unit = "") =0 "Number of special constraints";

//==================================
//Variable section
Real F(unit = "") "Degrees of freedom";

//==================================
//Equation section
equation
F = DOF(pi,N,r,s);

end Ex13_11_a;
//==================================
model Ex13_11_b

//==================================
//Parameter section
parameter Real pi(unit = "") =3 "Number of phases";
parameter Real N(unit = "") =3 "Number of components";
parameter Real r(unit = "") =1 "Number of reactions";
parameter Real s(unit = "") =0 "Number of special constraints";

//==================================
//Variable section
Real F(unit = "") "Degrees of freedom";

//==================================
//Equation section
equation
F = DOF(pi,N,r,s);

end Ex13_11_b;
//==================================
model Ex13_11_c

//==================================
//Parameter section
parameter Real pi(unit = "") =2 "Number of phases";
parameter Real N(unit = "") =3 "Number of components";
parameter Real r(unit = "") =1 "Number of reactions";
parameter Real s(unit = "") =1 "Number of special constraints";

//==================================
//Variable section
Real F(unit = "") "Degrees of freedom";

//==================================
//Equation section
equation
F = DOF(pi,N,r,s);

end Ex13_11_c;
//==================================
model Ex13_11_d

//==================================
//Parameter section
parameter Real pi(unit = "") =1 "Number of phases";
parameter Real N(unit = "") =5 "Number of components";
parameter Real r(unit = "") =2 "Number of reactions";
parameter Real s(unit = "") =0 "Number of special constraints";

//==================================
//Variable section
Real F(unit = "") "Degrees of freedom";

//==================================
//Equation section
equation
F = DOF(pi,N,r,s);

end Ex13_11_d;
//==================================
end Ex13_11;
