//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.12 Page 519
//Title: Calculate the equilibrium product composition while cracking n butane
//==================================================================================
model Ex13_12

//==================================
//Parameter section
parameter Real P(unit="bar")=1.2 "Pressure of reaction";
parameter Real P0(unit="bar")=1 "Reference pressure";
parameter Real T(unit="K")=750 "Temperature of reaction";
parameter Real KI(unit="")=3.856 "Equilibrium constant";
parameter Real KII(unit="")=268.4 "Equilibrium constant";

//==================================
//Variable section
Real kappa(unit="") "Equation constant";
Real epsI(unit="") ;
Real epsII(unit="") ;
Real y_C4H10(unit="") "Equilibrium composition";
Real y_C2H4(unit="") "Equilibrium composition";
Real y_C2H6(unit="") "Equilibrium composition";
Real y_CH4(unit="") "Equilibrium composition";
Real y_C3H6(unit="") "Equilibrium composition";

//==================================
//Equation section
equation
kappa = (KII/KI)^0.5;
epsI = (KI*(P0/P)/(1+KI*(P0/P)*(kappa+1)^2))^0.5;
epsII = kappa*epsI;
y_C4H10 = (1-epsI-epsII)/(1+epsI+epsII);
y_C2H4 = epsI/(1+epsI+epsII);
y_C2H6 = y_C2H4;
y_CH4 = epsII/(1+epsI+epsII);
y_C3H6 = y_CH4;

end Ex13_12;
//==================================================================================
