//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.13 Page 520
//Title: Calculate the equilibrium composition of the gas stream
//==================================================================================
model Ex13_13

//==================================
//Parameter section
parameter Real P(unit="bar")=20 "Pressure of reaction";
parameter Real P0(unit="bar")=1 "Reference pressure";
parameter Real[6] T(unit="K")={1000,1100,1200,1300,1400,1500} "Temperature of reaction";
parameter Real[6] deltaGf_H2O(unit="J/mol")={-192420,-187000,-181380,-175720,-170020,-164310} "Change in Gibbs free energy of formation of H2O";
parameter Real[6] deltaGf_CO(unit="J/mol")={-200240,-209110,-217830,-226530,-235130,-243740} "Change in Gibbs free energy of formation of CO";
parameter Real[6] deltaGf_CO2(unit="J/mol")={-395790,-395960,-396020,-396080,-396130,-396160} "Change in Gibbs free energy of formation of CO2";
parameter Real ni_air(unit="mol")=2.38 "Initial number of moles of air";
parameter Real ni_H2O(unit="mol")=1 "Initial number of moles of H2O";
parameter Real R(unit="J/mol K")=8.314 "Universal gas constant";

//==================================
//Variable section
Real ni_O2(unit="mol") "Initial number of moles of O2";
Real ni_N2(unit="mol") "Initial number of moles of N2";
Real K_I(unit="") "Equilibrium constants";
Real K_II(unit="") "Equilibrium constants";
Real K_III(unit="") "Equilibrium constants"; 
Real[6] eps_a(unit="") ;
Real[6] eps_b(unit="") ;
Real[6] K_a(unit="") "Equilibrium constants";
Real[6] K_b(unit="") "Equilibrium constants";
Real[6] y_H2(unit="") "Equilibrium composition";
Real[6] y_H2O(unit="") "Equilibrium composition";
Real[6] y_CO(unit="") "Equilibrium composition";
Real[6] y_CO2(unit="") "Equilibrium composition";
Real[6] y_N2(unit="") "Equilibrium composition";

//==================================
//Equation section
equation
ni_O2 = 0.21*ni_air;
ni_N2 = 0.79*ni_air;
log(K_I) = (-deltaGf_H2O[6]/(R*T[6]));
log(K_II) = (-deltaGf_CO[6]/(R*T[6]));
log(K_III) = (-deltaGf_CO2[6]/(R*T[6]));
//since K values are very large another reaction mechanism is proposed 
//C + O2 --> 2CO
//H2O + C --> H2 + CO
for i in 1:6 loop
log(K_a[i]) = (-(2*deltaGf_CO[i]-deltaGf_CO2[i])/(R*T[i]));
log(K_b[i]) = (-(deltaGf_CO[i]-deltaGf_H2O[i])/(R*T[i]));
K_a[i] = (2*eps_a[i]+eps_b[i])^2/((0.5-eps_a[i])*(3.38+eps_a[i]+eps_b[i]))*(P/P0);// derived from equation 13.7
K_b[i] = eps_b[i]*(2*eps_a[i]+eps_b[i])/((1-eps_b[i])*(3.38+eps_a[i]+eps_b[i]))*(P/P0);
y_H2[i] = eps_b[i]/(3.38+eps_a[i]+eps_b[i]);
y_CO[i] = (2*eps_a[i]+eps_b[i])/(3.38+eps_a[i]+eps_b[i]);
y_H2O[i] = (1-eps_b[i])/(3.38+eps_a[i]+eps_b[i]);
y_CO2[i] = (ni_O2-eps_a[i])/(3.38+eps_a[i]+eps_b[i]);
y_N2[i] = ni_N2/(3.38+eps_a[i]+eps_b[i]);
end for;

end Ex13_13;