//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.4 Page 496
//Title: Calculate the equilibrium constant for hydration of ethylene
//==================================================================================
model Ex13_4

//==================================
//Parameter section
parameter Real T1(unit="K")=418.15 "Temperature of reaction";
parameter Real T2(unit="K")=593.15 "Temperature of reaction";
parameter Real Tr(unit="K")=298.15 "Reference temperature";
parameter Real A_C2H4(unit="")=1.424 "Cp constants";
parameter Real B_C2H4(unit="")=0.014394 "Cp constants";
parameter Real C_C2H4(unit="")=-0.000004392 "Cp constants";
parameter Real D_C2H4(unit="")=0 "Cp constants";
parameter Real A_H2O(unit="")=3.47 "Cp constants";
parameter Real B_H2O(unit="")=0.00145 "Cp constants";
parameter Real C_H2O(unit="")=0 "Cp constants";
parameter Real D_H2O(unit="")=12100 "Cp constants";
parameter Real A_C2H5OH(unit="")=3.518 "Cp constants";
parameter Real B_C2H5OH(unit="")=0.020001 "Cp constants";
parameter Real C_C2H5OH(unit="")=-0.000006002 "Cp constants";
parameter Real D_C2H5OH(unit="")=0 "Cp constants";
parameter Real H_C2H4(unit="J/mol")=52510 "Enthalpy of component";
parameter Real G_C2H4(unit="J/mol")=68460 "Gibbs free energy of component";
parameter Real H_H2O(unit="J/mol")=-241818 "Enthalpy of component";
parameter Real G_H2O(unit="J/mol")=-228572 "Gibbs free energy of component";
parameter Real H_C2H5OH(unit="J/mol")=-235100 "Enthalpy of component";
parameter Real G_C2H5OH(unit="J/mol")=-168490 "Gibbs free energy of component";
parameter Real R(unit="J/mol K")=8.314 "Universal gas constant";

//==================================
//Variable section
Real deltaA(unit="") "Cp constants";
Real deltaB(unit="") "Cp constants";
Real deltaC(unit="") "Cp constants";
Real deltaD(unit="") "Cp constants";
Real deltaH(unit="J/mol") "Change in enthalpy in reaction at 298.15 K";
Real deltaG(unit="J/mol") "Change in Gibbs free energy at 298.15 K";
Real deltaG_418byRT1(unit="") "Change in Gibbs free energy/(R*T1) at 418.15 K";
Real deltaG_593byRT2(unit="") "Change in Gibbs free energy/(R*T2) at 593.15 K";
Real K_418(unit="") "Equilibrium constant at 418.15 K";
Real K_593(unit="") "Equilibrium constant at 593.15 K";
Real I1(unit="") "Integral values";
Real I2(unit="") "Integral values";
Real I3(unit="") "Integral values";
Real I4(unit="") "Integral values";

//==================================
//Equation section
equation
deltaA = A_C2H5OH-A_C2H4-A_H2O;
deltaB = B_C2H5OH-B_C2H4-B_H2O;
deltaC = C_C2H5OH-C_C2H4-C_H2O;
deltaD = D_C2H5OH-D_C2H4-D_H2O;
deltaH = H_C2H5OH-H_C2H4-H_H2O;
deltaG = G_C2H5OH-G_C2H4-G_H2O;
//T=418.15 K
I2 = deltaA*log(T1/Tr)+(deltaB*Tr+(deltaC*Tr^2+deltaD/((T1/Tr)^2*Tr^2))*((T1/Tr)+1)/2)*((T1/Tr)-1);
I1 = (deltaA*Tr*((T1/Tr)-1)+deltaB/2*Tr^2*((T1/Tr)^2-1)+deltaC/3*Tr^3*((T1/Tr)^3-1)+deltaD/Tr*((T1/Tr)-1)/(T1/Tr));
deltaG_418byRT1 = (deltaG-deltaH)/(R*Tr)+deltaH/(R*T1)+I1/T1-I2;
K_418 = exp(-deltaG_418byRT1);
//T= 593.15K
I4 = deltaA*log(T2/Tr)+(deltaB*Tr+(deltaC*Tr^2+deltaD/((T2/Tr)^2*Tr^2))*((T2/Tr)+1)/2)*((T2/Tr)-1);
I3 = (deltaA*Tr*((T2/Tr)-1)+deltaB/2*Tr^2*((T2/Tr)^2-1)+deltaC/3*Tr^3*((T2/Tr)^3-1)+deltaD/Tr*((T2/Tr)-1)/(T2/Tr));
deltaG_593byRT2 = (deltaG-deltaH)/(R*Tr)+deltaH/(R*T2)+I3/T2-I4;
K_593 = exp(-deltaG_593byRT2);

end Ex13_4;
//==================================================================================
