//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.

//Chapter-14:Topics in Phase Equilibria
//Example: 14.1 Page 564
//Title: Determine the fugacity coefficients of nitrogen & methane
//==================================================================================

model Ex14_1
//==================================
//Parameter section
parameter Real T(unit="K")=200 "Temperature of system";
parameter Real P(unit="bar")=30 "Pressure of system";
parameter Real y1(unit="")=0.4 "Mole fraction of nitrogen";
parameter Real[2] Tc(unit="K")={126.2,190.6} "Critical temperatures";
parameter Real[2] Pc(unit="bar")={34,45.99} " Critical pressure";
parameter Real R(unit="bar cm^3/ mol K")=83.14 "Universal gas constant";

//===================
//Variable section
Real y2(unit="") "Mole fraction of methane";
Real[2] Tr(unit="K") "Reduced temperature";
Real[2] Pr(unit="bar") "Reduced pressure";
Real a1_bar(unit="") "Equation constants";
Real a2_bar(unit="") "Equation constants";
Real q1_bar(unit="") "Equation constants";
Real q2_bar(unit="") "Equation constants";
Real q(unit="") "Equation constants";
Real[2] ai(unit="") "Equation constants";
Real[2] bi(unit="") "Equation constants";
Real a(unit="") "Equation constants";
Real b(unit="") "Equation constants";
Real beta(unit="") "Equation constants";
Real I(unit="") "Equation constants";
Real z(unit="") "Compressibility factor";
Real[2] phi(unit="") "Fugacity coefficient";

//==================================
//Equation section
equation
y2 = 1-y1;
for i in 1:2 loop
Tr[i] = T/Tc[i];
Pr[i] = P/Pc[i];
ai[i] = 0.42748* Tr[i]^(-0.5)*R^2* Tc[i]^2/ Pc[i];
bi[i] = 0.08664*R* Tc[i]/ Pc[i];
end for;
a = y1^2*ai[1]+2*y1*y2*(ai[1]*ai[2])^(0.5)+y2^2*ai[2];
b = y1*bi[1]+y2*bi[2];
q = a/(b*R*T);
beta = b*P/(R*T);
z = 1+beta-q*beta*(z-beta)/(z*(z+beta));
I = log((z+beta)/z);
a1_bar = 2*y1*ai[1]+2*y2*(ai[1]*ai[2])^(0.5)-a;
a2_bar = 2*y2*ai[2]+2*y1*(ai[1]*ai[2])^(0.5)-a;
q1_bar = q*((2*y1*ai[1]+2*y2*(ai[1]*ai[2])^(0.5))/a-bi[1]/b);
q2_bar = q*((2*y2*ai[2]+2*y1*(ai[1]*ai[2])^(0.5))/a-bi[2]/b);
log(phi[1]) = bi[1]/b*(z-1)-log(z-beta)-q1_bar*I;
log(phi[2]) = bi[2]/b*(z-1)-log(z-beta)-q2_bar*I;

end Ex14_1;
//==================================================================================
