//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.

//Chapter-14:Topics in Phase Equilibria
//Example: 14.10 Page 612
//Title: Concepts developed for pure gas adsorption
//==================================================================================

model Ex14_10
//==================================
//Parameter section
parameter Real T(unit="K")=323.15 "Temperature of system";
parameter Real n(unit="mol/kg")=1 "Number of moles present";
parameter Real A(unit="m^/kg")=650000 "Surface area";
parameter Real R(unit="cm^3 bar/(mol K)")=83.14 "Universal gas constant";
parameter Real m=4.7087 "Toth parameters";
parameter Real b=2.1941 "Toth parameters";
parameter Real t=0.3984 "Toth parameters";
parameter Real C0=0.4016 "Cubic polynomial parameters";
parameter Real C1=-0.6471 "Cubic polynomial parameters";
parameter Real C2=-0.4567 "Cubic polynomial parameters";
parameter Real C3=-0.12 "Cubic polynomial parameters";

//==================================
//Variable section
Real k_Toth(unit="mol/kg kPa") "Apparent value of Henry's constant";
Real k_cubic(unit="mol/kg kPa") "from cubic polynomial equation";
Real z(unit="N m/bar cm^3 ") "Integral n/P*dP/dn with respect to dn";
Real PI(unit="N/m") "Spreading pressure";

//==================================
//Equation section
equation
k_Toth = m/(b)^(1/t);
k_cubic = C0;  //k = lim n->0 (C0+C1*n+C2*n^2+C3*n^3)
z = 1.69*10^(-1); //calculated from plot given in Fig 14.25
PI = n*R*T/A*z;

end Ex14_10;
//==================================================================================