//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-15:Thermodynamic Analysis of Processes
//Example: 15.1 Page 636
//Title: Make an thermodynamic analysis of the power plant
//==================================================================================
model Ex15_1

//==================================
//Parameter section
parameter Real T1(unit="K")=298.15 "Ambient temperature";
parameter Real T2(unit="K")=460 "Temperature of process";
parameter Real[4] t(unit="K")={318.98,773.15,318.98,318.98} "Temperature of steam";
parameter Real[4] P(unit="kPa")={8600,8600,10,10} "Pressure of steam";
parameter Real[4] H(unit="kJ/kg")={203.4,3391.6,2436,191.8} "Enthalpy of steam";
parameter Real[4] S(unit="kJ/kg K")={0.6580,6.6858,7.6846,0.6493} "Entropy of steam";
parameter Real excess(unit="%")=25 "% excess of air";
parameter Real dH_CO2(unit="kJ/kg")=-393509 "Enthalpy of CO2";
parameter Real dH_H2O(unit="kJ/kg")=-241818 "Enthalpy of H2O";
parameter Real dH_CH4(unit="kJ/kg")=-74520 "Enthalpy of CH4";
parameter Real dG_CO2(unit="kJ/kg K")=-394359 "Enropy of CO2";
parameter Real dG_H2O(unit="kJ/kg K")=-228572 "Entropy of H2O";
parameter Real dG_CH4(unit="kJ/kg K")=-50460 "Entropy of CH4";
parameter Real R(unit="J/mol K")=8.314 "Universal gas constant";

//==================================
//Variable section
Real[2] n_O2(unit="mol") "Number of moles of O2";
Real n_N2(unit="mol") "Number of moles of N2";
Real n_CO2(unit="mol") "Number of moles of CO2";
Real n_CH4(unit="mol") "Number of moles of CH4";
Real n_H2O(unit="mol") "Number of moles of H2O";
Real y_O2(unit="mol") "Mole fraction of O2 at initial and final stages";
Real y_N2(unit="mol") "Mole fraction of N2";
Real y_CO2(unit="mol") "Mole fraction of CO2";
Real y_H2O(unit="mol") "Mole fraction of H2O";
Real dH_298(unit="kJ/kg") "Enthalpy at 298 K";
Real dG_298(unit="kJ/kg") "Free energy at 298 K";
Real dS_298(unit="kJ/K kg") "Entropy at 298 K";
Real dH_a(unit="kJ/kg") "Enthalpy";
Real dH_b(unit="kJ/kg") "Enthalpy";
Real dH_c(unit="kJ/kg") "Enthalpy";
Real dH_d(unit="kJ/kg") "Enthalpy";
Real dS_a(unit="kJ/kg K") "Entropy";
Real dS_b(unit="kJ/kg K") "Entropy";
Real dS_c(unit="kJ/kg K") "Entropy";
Real dS_d(unit="kJ/kg K") "Entropy";
Real dH(unit="kJ/kg") "Overall change in enthalpy";
Real dS(unit="kJ/kg K") "Overall change in entropy";
Real Cp_H(unit="kJ/kg") "Specific heat";
Real Cp_S(unit="kJ/kg") "Specific heat";
Real m(unit="kg/s") "Mass flow rate";
Real[4] SG(unit="kJ/ K") "Entropy change of the process";
Real W_ideal(unit="kW") "Ideal work";
Real Ws(unit="kW") "Work obtained from turbine";
Real[4] W_lost(unit="kW") "Work lost";
Real Q_c(unit="kW") "Heat transferred in condenser";
Real[5] per_Wlost(unit="kW") "% work lost";
Real[4] per_SG(unit="kJ/ K") "Percentage entropy change of the process";

//==================================
//Equation section
equation
dH_298 = dH_CO2+2*dH_H2O-dH_CH4;
dG_298 = dG_CO2+2*dG_H2O-dG_CH4;
dS_298 = (dH_298-dG_298)/T1;
n_O2[1] = 2*(excess/100+1);
n_N2 = n_O2[1]*(79/21);
n_CO2 = 1;
n_H2O = 2;
n_O2[2] = n_O2[1]-n_H2O;
y_O2 = n_O2[2]/(n_O2[2]+n_N2+n_CO2+n_H2O);
y_N2 = n_N2/(n_O2[2]+n_N2+n_CO2+n_H2O);
y_CO2 = 1/(n_O2[2]+n_N2+n_CO2+n_H2O);
y_H2O = 2/(n_O2[2]+n_N2+n_CO2+n_H2O);
//a 
dH_a = 0;
dS_a = (n_O2[1]+n_N2)*R*(0.21*log(0.21)+0.79*log(0.79)); //Fraction of oxygen and nitrogen in air
//b
dH_b = dH_298;
dS_b = dS_298;
//c
dH_c = 0;
dS_c = -(n_O2[2]+n_N2+n_CO2+n_H2O)*R*(y_O2*log(y_O2)+y_N2*log(y_N2)+y_CO2*log(y_CO2)+y_H2O*log(y_H2O));
//d
Cp_H = 41.649*n_CO2+34.153*n_H2O+30.473*n_O2[2]+29.381*n_N2;
Cp_S = 41.377*n_CO2+34.106*n_H2O+30.405*n_O2[2]+29.360*n_N2;
dH_d = Cp_H*(T2-T1);
dS_d = Cp_S*log(T2/T1);
dH = dH_a+dH_b+dH_c+dH_d;
dS = dS_a+dS_b+dS_c+dS_d;
m = 84.75; //From Ex.8.1
m*(H[2]-H[1])+n_CH4*dH/10^3 = 0;
W_ideal = n_CH4*(dH/10^3-T1*dS/10^3);
Ws = 80*10^3; //calculated in Ex8.1
//Furnace
SG[1] = n_CH4*dS/10^3+m*(S[2]-S[1]);
W_lost[1] = T1*SG[1];
//Turbine
SG[2] = m*(S[3]-S[2]);
W_lost[2] = T1*SG[2];
//Condenser
Q_c = -190.2E3; //Heat transfereed in the condenser from Ex 8.1
SG[3] = m*(S[4]-S[3])-Q_c/T1;
W_lost[3] = T1*SG[3];
//Pump
SG[4] = m*(S[1]-S[4]);
W_lost[4] = T1*SG[4];
per_SG[1] = SG[1]/sum(SG);
per_SG[2] = SG[2]/sum(SG);
per_SG[3] = SG[3]/sum(SG);
per_SG[4] = SG[4]/sum(SG);
per_Wlost[1] = W_lost[1]/(sum(W_lost)+Ws);
per_Wlost[2] = W_lost[2]/(sum(W_lost)+Ws);
per_Wlost[3] = W_lost[3]/(sum(W_lost)+Ws);
per_Wlost[4] = W_lost[4]/(sum(W_lost)+Ws);
per_Wlost[5] = Ws/(sum(W_lost)+Ws);

end Ex15_1;
//==================================================================================