//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-15:Thermodynamic Analysis of Processes
//Example: 15.2 Page 641
//Title: Make an thermodynamic analysis of the liquefaction process
//==================================================================================
model Ex15_2

//==================================
//Parameter section
parameter Real[6] T(unit="K")={300,300,207.1,111.5,111.5,295} "Temperature at differents parts of system";
parameter Real[6] P(unit="bar")={1,60,60,1,1,1} "Pressure at differents parts of system";
parameter Real[6] H(unit="kJ/kg")={1199.8,1140,772,285.4,796.9,1188.9} "Enthalpy of component at differents parts of system";
parameter Real[6] S(unit="kJ/K kg")={11.629,9.359,7.798,4.962,9.523,11.589} "Entropy of component at differents parts of system";
parameter Real Ws(unit="kJ")=1000 "Energy given to compressor";

//==================================
//Variable section
Real[3] SG(unit="kJ/ K") "Entropy change of the process";
Real[3] Q(unit="kJ") "Energy change of the process";
Real W_ideal(unit="kW") "Ideal work";
Real[3] Wlost(unit="kW") "Work lost";
Real z(unit="kg") "Amount of CH4 liquefied";
Real[4] per_Wlost(unit="kW") "% work lost";
Real[3] per_SG(unit="kJ/ K") "Percentage entropy change of the process";

//==================================
//Equation section
equation
z = (H[6]-H[2]-Q[2])/(H[6]-H[4]);
W_ideal = (z*H[4]+(1-z)*H[6]-H[1])-T[1]*(z*S[4]+(1-z)*S[6]-S[1]);
//cooling
Q[1] = H[2]-H[1]-Ws;
SG[1] = S[2]-S[1]-Q[1]/T[1];
Wlost[1] = T[1]*SG[1];
//Exchanger
Q[2] = 5;
SG[2] = (S[6]-S[5])*(1-z)+(S[3]-S[2])-Q[2]/T[1];
Wlost[2] = T[1]*SG[2];
//Throttle
Q[3] = 0;
SG[3] = z*S[4]-S[3]+(1-z)*S[5];
Wlost[3] = T[1]*SG[3];
per_SG[1] = SG[1]/sum(SG);
per_SG[2] = SG[2]/sum(SG);
per_SG[3] = SG[3]/sum(SG);
per_Wlost[1] = Wlost[1]/(sum(Wlost)+W_ideal);
per_Wlost[2] = Wlost[2]/(sum(Wlost)+W_ideal);
per_Wlost[3] = Wlost[3]/(sum(Wlost)+W_ideal);
per_Wlost[4] = W_ideal/(sum(Wlost)+W_ideal);

end Ex15_2;
//==================================================================================
