//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.1 Page 25
//Title: Find Energy in a Waterfall 
//==================================================================================
model Ex2_1

//==================================
//Parameter section
parameter Real m(unit = "kg") = 1 "Mass of water";
parameter Real z(unit = "m") = 100 "Height of waterfall"; 
parameter Real g(unit ="m/s2") =9.8066 "Acceleration of gravity";
parameter Real cp(unit = "J/kg deg C") = 4184 "Specific heat of water";

//==================================
//Variable section
Real EP1(unit = "J") "Potential energy of water at top";
Real EK1(unit = "J") "Kinetic energy of water at top";
Real EP2(unit = "J") "Potential energy of water before it hits bottom";
Real EK2(unit = "J") "Kinetic energy of water before it hits bottom";
Real T(unit = "deg C") "Temperature change";

//==================================
//Equation section
equation
EP1 = m*g*z;
EK1 = 0;
EP2 = 0;
EK2 = EP1+EK1-EP2; //conservation of energy
T = EK2/(cp*m); //conduction of heat

end Ex2_1;
//==================================================================================

