//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.11 Page 45
//Title: Calculate flow properties for liquid hexane 
//==================================================================================
model Ex2_11

//==================================
// Library section
extends Modelica.Constants ;

//==================================
//Parameter section
parameter Real m(unit = "kg/s") = 0.75 "Mass flow rate of n-hexane";
parameter Real D1(unit = "cm") = 5 "Diameter of pipe";
parameter Real D2(unit = "cm") = 2 "Diameter of pipe";
parameter Real rho(unit = "kg/m3") = 659 "Density of n-hexane";

//==================================
//Variable section
Real q(unit = "m3/s") "Volumetric flow rate of n-hexane";
Real n(unit = "mol/s") "Molar flow rate";
Real A1(unit = "m2") "Cross sectional area when D=D1";//notation different from textbook is used with numbering
Real A2(unit = "m2") "Cross sectional area when D=D2";
Real u1(unit = "m/s") "Velocity of flow when D=D1";
Real u2(unit = "m/s") "Velocity of flow when D=D2";

//==================================
//Equation section
equation 
q = m/rho;
n = m*10^3/86.177;//multiplied by 10^3 to convert kg to g and divided molecular weight 
A1 = pi/4*(D1*0.01)^2;//multiplied by 0.01 to convert cm to m
A2 = pi/4*(D2*0.01)^2;
u1 = q/A1;
u2 = q/A2;

end Ex2_11;
//==================================================================================