//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.14 Page 50
//Title: Calculate time taken for temperature drop 
//==================================================================================
model Ex2_14

//==================================
//Parameter section
parameter Real m(unit = "kg") =190 "Mass of water";
parameter Real mdot(unit = "kg/s") =0.2 "Mass flow rate of water";
parameter Real T0(unit = "K") =333.15 "Initial outlet temperature of water";
parameter Real T(unit = "K") =308.15 "Final outlet temperature of water";
parameter Real T1(unit = "K") =283.15 "Initial outlet of water";

//==================================
//Variable section
Real t(unit = "s") "Time taken for temperature drop";

//==================================
//Equation section
equation
t = -(m/mdot*log((T-T1)/(T0-T1))); //integrated equation of energy balance

end Ex2_14;
//==================================================================================