//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.7 Page 36
//Title: Calculate energy changes in piston arrangement 
//==================================================================================
model Ex2_7

//==================================
// Library section
extends Modelica.Constants ;

//==================================
//Parameter section
parameter Real m(unit = "kg") =45 "Mass over the pan";
parameter Real mT(unit = "kg") =23 "Total mass piston and pan";
parameter Real h(unit = "m") =0.5 "Distance moved by piston";

//==================================
//Variable section
Real deltaE_P_surr(unit="N m") "Energy change by surrounding";
Real deltaU_t(unit="N m") "deltaU_t_sys+deltaU_t_surr";

//==================================
//Equation section
equation
deltaE_P_surr = (m+mT)*g_n*h;
deltaU_t+deltaE_P_surr = 0; //energy balance

end Ex2_7;
//==================================================================================