//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-3:Volumetric Properties of Pure Fluids
//Example: 3.1 Page 69
//Title: Find volume change and pressure generated 
//==================================================================================
model Ex3_1

//==================================
//Parameter section
parameter Real T1(unit = "K") =293.15 "Initial temperature of liquid acetone";
parameter Real P1(unit = "bar") =1 "Initial pressure of liquid acetone";
parameter Real beta(unit = "K^-1") =1.487e-3 "Volume expansivity";
parameter Real k(unit = "bar^-1") =62e-6 "Isothermal compressibility";
parameter Real V1(unit = "cm^3/g") =1.287 "Volume";
parameter Real T(unit = "K") =273.15 "Final temperature of liquid acetone";
parameter Real T2(unit = "K") =303.15 "Final temperature of liquid acetone at const vol";
parameter Real P(unit = "bar") =10 "Final pressure of liquid acetone";

//==================================
//Variable section
Real dPbydT(unit = "bar/deg C") "(dP/dT)v";
Real P2(unit = "bar") "Final pressure of liquid acetone at const vol";
Real V2(unit = "cm^3/g") "Final Volume";
Real deltaV(unit = "cm^3/g") "Change in Volume";
Real deltaP(unit = "bar") "Change in pressure";

//==================================
//Equation section
equation
//a
dPbydT = beta/k; 
//b
deltaP = beta/k*(T2-T1);
P2 = P1+deltaP;
//c
V2 = V1*exp(beta*(T-T1)-k*(P-P1));
deltaV = V2-V1;

end Ex3_1;
//==================================================================================
