package Ex3_10
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-3:Volumetric properties of pure fluids
  //Example: 3.10 Page 105
  //Title: Molar volume of n-butane using generalized correlations
  //==================================================================================

  model Ex3_10_a
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 25 "Pressure of system";
    parameter Real T(unit = "K") = 510 "Temperature of system";
    parameter Real omega(unit = "") = 0.2 "Pitzer parameters";
    parameter Real Pc(unit = "bar") = 37.96 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 425.1 "Critical temperature of system";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real V(unit = "cm^3/mol") "Volume for a";
    //==================================
    //Equation section
  equation
    V = R * T / P;
  end Ex3_10_a;

  //==================================

  model Ex3_10_b
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 25 "Pressure of system";
    parameter Real T(unit = "K") = 510 "Temperature of system";
    parameter Real omega(unit = "") = 0.2 "Pitzer parameters";
    parameter Real Pc(unit = "bar") = 37.96 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 425.1 "Critical temperature of system";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real Tr(unit = "") "Reduced temperature";
    Real Pr(unit = "") "Reduced Pressure";
    Real Z0(unit = "") "From interpolation in tables E.1 and E.2";
    Real Z1(unit = "") "From interpolation in tables E.1 and E.2";
    Real V(unit = "cm^3/mol") "Volume for b";
    Real Z(unit = "") "Compressibility factor for b";
    //==================================
    //Equation section
  equation
    Tr = T / Tc;
    Pr = P / Pc;
    Z0 = 0.865;
//From interpolation in tables E.1 and E.2
    Z1 = 0.038;
    Z = Z0 + omega * Z1;
    V = Z * R * T / P;
  end Ex3_10_b;

  //==================================

  model Ex3_10_c
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 25 "Pressure of system";
    parameter Real T(unit = "K") = 510 "Temperature of system";
    parameter Real omega(unit = "") = 0.2 "Pitzer parameters";
    parameter Real Pc(unit = "bar") = 37.96 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 425.1 "Critical temperature of system";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real Tr(unit = "") "Reduced temperature";
    Real Pr(unit = "") "Reduced Pressure";
    Real V(unit = "cm^3/mol") "Volume for c";
    Real Z(unit = "") "Compressibility factor for c";
    Real B0(unit = "") "Pitzer parameter";
    Real B1(unit = "") "Pitzer parameter";
    Real Bcap(unit = "") "Pitzer parameter";
    //==================================
    //Equation section
  equation
    Tr = T / Tc;
    Pr = P / Pc;
    B0 = 0.083 - 0.422 / Tr ^ 1.6;
//from equation 3.65
    B1 = 0.139 - 0.172 / Tr ^ 4.2;
//from equation 3.66
    Bcap = B0 + omega * B1;
    Z = 1 + Bcap * Pr / Tr;
    V = Z * R * T / P;
  end Ex3_10_c;

  //==================================

  model Ex3_10_d
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 25 "Pressure of system";
    parameter Real T(unit = "K") = 510 "Temperature of system";
    parameter Real omega(unit = "") = 0.2 "Pitzer parameters";
    parameter Real Pc(unit = "bar") = 37.96 "Critical pressure of system";
    //from appendix B
    parameter Real Tc(unit = "K") = 425.1 "Critical temperature of system";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real Tr(unit = "") "Reduced temperature";
    Real Pr(unit = "") "Reduced Pressure";
    Real V(unit = "cm^3/mol") "Volume for d";
    Real Z(unit = "") "Compressibility factor for d";
    Real B0(unit = "") "Pitzer parameter";
    Real B1(unit = "") "Pitzer parameter";
    Real Bcap(unit = "") "Pitzer parameter";
    Real C0(unit = "") "Pitzer parameter";
    Real C1(unit = "") "Pitzer parameter";
    Real Ccap(unit = "") "Pitzer parameter";
    //==================================
    //Equation section
  equation
    Tr = T / Tc;
    Pr = P / Pc;
    B0 = 0.083 - 0.422 / Tr ^ 1.6;
//from equation 3.65
    B1 = 0.139 - 0.172 / Tr ^ 4.2;
//from equation 3.66
    Bcap = B0 + omega * B1;
    C0 = 0.01407+0.02432/Tr-0.00313/Tr^10.5;
  C1 = -0.02676+0.05539/Tr^2.7-0.00242/Tr^10.5;
  Ccap = C0+omega*C1;
  Z = 1+Bcap*Pr/(Tr*Z)+Ccap*(Pr/(Tr*Z))^2;
  V = Z*R*T/P;
  end Ex3_10_d;

  //==================================
end Ex3_10;
