//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-3:Volumetric properties of pure fluids
//Example: 3.13 Page 110
//Title: Find density of gaseous ammonia
//==================================================================================
model Ex3_13

//==================================
//Parameter section
parameter Real T(unit = "K") =310 "Temperature of system";
parameter Real P(unit = "bar") =100 "Pressure of system";
parameter Real Tc(unit = "K") =405.7 "Critical temperature of system"; //appendix B
parameter Real Vc(unit = "cm^3/mol") =72.47 "Critical volume of system";
parameter Real Pc(unit = "bar") =112.8 "Critical Pressure";
parameter Real Zc(unit = "") =0.242 "Critical compression factor of system";
parameter Real M(unit = "g/mol") =17.02  "Molecular weight of ammonia";

//==================================
//Variable section
Real Tr(unit = "") "Reduced temperature";
Real Pr(unit = "") "Reduced Pressure";
Real Vsat(unit = "cm^3/mol") "Saturated liquid volume";
Real rho_r2(unit = "g/cm^3") "Density at b from graph";
Real V(unit = "cm^3/mol") "Liquid volume at b";
Real rho_r1(unit = "g/cm^3") "Density of saturated liquid at Tr=0.764";
Real V1(unit = "cm^3/mol") "Experimental value";
Real V2(unit = "cm^3/mol") "Liquid volume";

//==================================
//Equation section
equation
Tr = T/Tc;
//a
Vsat = Vc*Zc^((1-Tr)^(2/7));
//b
Pr = P/Pc;
rho_r2 = 2.38;//from Fig. 3.16
V = Vc/rho_r2;//error is high compared to experimental values
rho_r1 = 2.34;
V1 = 29.14;
V2 = V1*rho_r1/rho_r2;

end Ex3_13;
//==================================================================================