package Ex3_8
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-3:Volumetric properties of pure fluids
  //Example: 3.8 Page 89
  //Title: Find V and Z for iso propanol vapor
  //==================================================================================

  model Ex3_8_a
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 10 "Pressure of vapor";
    parameter Real T(unit = "K") = 473.15 "Temperature of vapor";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    //==================================
    //Variable section
    Real V(unit = "cm^3/mol") "Volume-Ideal gas equation";
    Real Z(unit = "") "Z-Ideal gas equation";
    //==================================
    //Equation section
  equation
    Z = 1;
//ideal gas
    V = R * T / P;
//Ideal gas equation
  end Ex3_8_a;

  //==================================

  model Ex3_8_b
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 10 "Pressure of vapor";
    parameter Real T(unit = "K") = 473.15 "Temperature of vapor";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    parameter Real B(unit = "cm^3/mol") = -388 "Virial coefficient";
    parameter Real C(unit = "cm^6/mol^2") = -26000 "Virial coefficient";
    //==================================
    //Variable section
    Real V(unit = "cm^3/mol") "Volume-common form of Virial equation";
    Real Z(unit = "") "Z-common form of Virial equation";
    //==================================
    //Equation section
  equation
    V = R * T / P + B;
//common form of Virial equation
    Z = P * V / (R * T);
  end Ex3_8_b;

  //==================================

  model Ex3_8_c
    //==================================
    //Parameter section
    parameter Real P(unit = "bar") = 10 "Pressure of vapor";
    parameter Real T(unit = "K") = 473.15 "Temperature of vapor";
    parameter Real R(unit = "cm^3 bar/(mol K)") = 83.14 "Universal gas constant";
    parameter Real B(unit = "cm^3/mol") = -388 "Virial coefficient";
    parameter Real C(unit = "cm^6/mol^2") = -26000 "Virial coefficient";
    //==================================
    //Variable section
    Real V(unit = "cm^3/mol") "Volume-Virial equation";
    Real Z(start = 1) "Z-Virial equation";
    //==================================
    //Equation section
  equation
    V = R * T / P * (1 + B / V + C / V ^ 2);
    Z = P * V / (R * T);
  end Ex3_8_c;

  //==================================
end Ex3_8;
