//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.1 Page 129
//Title: Develop an equation for Cp/R
//==================================================================================
model Ex4_1

//==================================
//Parameter section
parameter Real A =1.702 "Coefficient of T^0 in equation with temperature in K ";
parameter Real B =9.081E-3 "Coefficient of T^1 in equation with temperature in K ";
parameter Real C =-2.167E-6 "Coefficient of T^2 in equation with temperature in K ";

//==================================
//Variable section
Real a "Coefficient of T^0 in equation with temperature in  deg C ";
Real b "Coefficient of T^1 in equation with temperature in  deg C ";
Real c "Coefficient of T^2 in equation with temperature in  deg C ";

//==================================
//Equation section
equation
a = A+B*273.15+C*273.15^2;
b = B+2*C*273.15;
c = C;

end Ex4_1;
//==================================================================================