//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.2 Page 131
//Title: Calculate the heat required to heat methane
//==================================================================================
model Ex4_2

//==================================
//Parameter section
parameter Real T0(unit = "K") =533.15 "Initial temperature of methane";
parameter Real T(unit = "K") =873.15 "Final temperature of methane";
parameter Real n(unit = "mol") =1 "No. of moles of methane";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";

//==================================
//Variable section
Real tau(unit = "") "Ratio of initial and final temperatures";
Real Q(unit = "J") "No. of moles of methane";

//==================================
//Equation section
equation
tau = T/T0;
Q = R*(1.702*T0*(tau-1)+(9.081*0.001/2)*T0^2*(tau^2-1)-(2.164*0.000001/3)*T0^3*(tau^3-1));//equation of methane obtained from ex 4.1

end Ex4_2;
//==================================================================================